/************************************************************************************
* Second Stage Loader.
* (c) Copyright 2009, Freescale, Inc.  All rights reserved.
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale.
*
************************************************************************************/
#include "EmbeddedTypes.h"
#include "Platform.h"
#include "Engine.h"
#include "UART.h"
#include "NVM.h"
#include "Main.h"

/************************************************************************************
*************************************************************************************
* Public memory declarations
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Private prototypes
*************************************************************************************
************************************************************************************/

/***********************************************************************************/
void Main(void)
{
  volatile uint16_t loopIndex = 20000;  

  //The bootstrap leaves the NVM regulator off. Start it, taking care of the buck option.
  // Bypass the BUCK regulator.
  // Bypassing the buck will require 700us in order to allow the battery to charge the buck capacitor.
  // Once the 700us has elapsed, the  1.8V regulator can be enabled.
  CRM_VREG_CNTL.buckBypassEn = 1;
  while(loopIndex--);
  
  // Enable the 1.8V regulator
  CRM_VREG_CNTL.vReg1P8VEn = 1;
  // 200us after the VREG_1P8V_EN bit was set, the full current drive capability of the 1.8V voltage
  // regulator will be enabled.    
  while(!CRM_STATUS.vReg1P8VRdy);
  
  //Initialize the UART communication
  UART_Init();
  // Send READY
  UART_SendRawData("READY", 5);

  //Loop forever executing host commands
  while(1)
  {
    ENG_Process();
  }
}


/************************************************************************************
*************************************************************************************
* Private functions
*************************************************************************************
************************************************************************************/
/***********************************************************************************/