//Metering Defines

#define N_SAMPLES 256       // number of samples in the buffer
#define SAMPLE_FOR_DFT 256  // number of samples used for the DFT
#define SAMPLE_FOR_RMS 256  // number of samples used for the RMS

/*Metering Datatypes*/
//Power Measures Structure
typedef struct{
  long long Act_Eng;   // Active Energy
  long Act_Pwr;        // Active Power
  long React_Pwr;      // Reactive Power
  long Apr_Pwr;        // Aparent Power
  word Vrms;           // Vrms
  word Irms;           // Irms
  word Pwr_fct;        // Power_factor
}Power_vec;

//Time Variables (for debuggin only)
typedef struct{
  dword  Act_Eng;    // Active Energy
  dword Act_Pwr;     // Active Power
  dword React_Pwr;   // Reactive Power
  dword Apr_Pwr;     // Aparent Power
  dword Vrms;        // Vrms
  dword Irms;        // Irms
  dword Pwr_fct;     // Power_factor
}Power_time;

//Complex Number
typedef struct {
  long Real;
  long Img;
} Complex;


//--------------------
/*funtion prototypes*/
//--------------------
word  RMS_calc(short* input);
word  SquareRoot(dword A);
dword ASM_FF1(dword A);
Complex DFT(short *input);
word RMS_DFT_calc(Complex A);
dword Act_Pwr_DFT_calc(Complex V, Complex I);
dword Reac_Pwr_DFT_calc(Complex V, Complex I);
void Power_Calc(short *V, short *I, Power_vec *Out, Power_time *tm);
word THD_calc(word Total_RMS, word Fund_RMS);
asm void ADD64bits(long long* ACC, long A);
asm long MAC_BUFF(short *B1, short *B2, short N);
//-----------------------------------------------------------------------------------------

#define MAX_INT 5      // maximum number of interactions for square root calculation
#define COEF_MAX 15 // Max amplitude for DFT sin and cos table coeficients 
#define ASM_SUM 1

#define RMS_DEC (N_SAMPLES/SAMPLE_FOR_RMS)
#define DEC (N_SAMPLES/SAMPLE_FOR_DFT)        
#if DEC == 1
#define DFT_INTERMEDIATE 1 //0 - 32-bits intermediate result; //l - 64-bits intermediate result 
#else
#define DFT_INTERMEDIATE 0 //0 - 32-bits intermediate result; //l - 64-bits intermediate result 
#endif

#if ((DEC == 1) & (DFT_INTERMEDIATE == 0))
#error "if DEC == 1 intermediate results should be 64-bits"
#endif


#if DFT_INTERMEDIATE == 0
#define DFT_SCALING 8     //256
#else
#define DFT_SCALING 0     //1
#endif

#if (DEC == 1)
#define FAC_DEC 0
#elif (DEC == 2)
#define FAC_DEC 1
#elif (DEC == 4)
#define FAC_DEC 2
#elif (DEC == 8)
#define FAC_DEC 3
#else 
#error "N_SAMPLES / SAMPLE_FOR_DFT should be 1, 2, 4, or 8"
#endif

#if (N_SAMPLES == 256)
#define FAC_N_SAMPLES 8
#elif (N_SAMPLES == 128)
#define FAC_N_SAMPLES 7
#elif (N_SAMPLES == 64)
#define FAC_N_SAMPLES 6
#elif (N_SAMPLES == 32)
#define FAC_N_SAMPLES 5
#else 
#error "N_SAMPLES should be 256, 128, 64, or 32"
#endif


#define FAC_SAMPLE_FOR_DFT (FAC_N_SAMPLES - FAC_DEC)

#if (SAMPLE_FOR_RMS == 256)
#define FAC_SAMPLE_FOR_RMS 8
#elif (SAMPLE_FOR_RMS == 128)
#define FAC_SAMPLE_FOR_RMS 7
#elif (SAMPLE_FOR_RMS == 64)
#define FAC_SAMPLE_FOR_RMS 6
#elif (SAMPLE_FOR_RMS == 32)
#define FAC_SAMPLE_FOR_RMS 5
#else 
#error "SAMPLE_FOR_RMS should be 256, 128, 64, or 32"
#endif

