/*
 - MC51EM256Demo
   
  
   

 
*/
#include "m51em256evb.h" /* include peripheral declarations */
#include "stdlib.h"
#include "lcd.h"
#include "task_mgr.h"


void RTC_disable();
void GPIO_init(void);


/*
  Configure Push-buttons inputs
*/

void MCU_init(void) 
 {
  SOPT1 = 0; // Disable COP
  
 
 }

void GPIO_init(void) 
 {
  PTEPE = PTEPE_PTEPE1_MASK | PTEPE_PTEPE2_MASK ;
  PTBPE = PTBPE_PTBPE6_MASK | PTBPE_PTBPE7_MASK ;
 }



void RTC_disable()
{
  uint16 status;
  
 // RTC WP disable   // just for reference 
  if (RTC_CTRL_WE==2) status = 1; 

  RTC_CTRL = 0;//0b00;
  RTC_CTRL = 1;//0b01;
  RTC_CTRL = 3;//0b11;
  RTC_CTRL = 2;//0b10;
   
  if (RTC_CTRL_WE==2) status = 2; 

// RTC - Disable All RTC interrupts inlcuding tamper    
  RTC_IER = 0;  
  
  RTC_CTRL = 15<<9;  // maximum Tamper duration
  
  RTC_CTRL |= 0x02;   // Enable Write protect   
}


void tsk_welcome(void) 
 {
  vfnLCD_Write_New_Msg("51EM256 Demo");
  if (sw1_click() || !timer_task) next_task(
 }






interrupt VectorNumber_Vmtim1 void MTIM_isrv(void) 
 {
 (void)MTIM1SC;
  MTIM1SC_TOF = 0;  // Clears TOF 
 }


void MTIM_init() 
 {
     MTIM1SC = MTIM1SC_TOIE_MASK ; //Starts MTIM Operation
     MTIM1CLK =0;  //BUSCLK , prescaler = 1
 }
 
 
 

 /*******************************************/


void main(void) 
{
  MCU_init(); 
  RTC_disable();   /*RTC disable*/
  
  uart_init();     //SCI2 is used for printf.
  /*LCD   initialization and Push-buttons */  
  GPIO_init();
  vfnLCD_Init();
  LCDC1_LCDIEN = 1;  // Enable LCD interrupts

  printf("MC51EM256 Demo software");  // Send mesage via SCI1
  vfnLCD_Write_New_Msg("51EM256 Demo");
  next_task(tsk_welcome);
  
  EnableInterrupts;
  
  for(;;) 
   {
   
    ptr_next_task();  //jump to the last task asigned by next_task(); 
   
   
   }
}

