/*
  KBI

*/

#include "m51em256evb.h"
#include "kbi.h"
#include "low_power.h"
#include "validation.h"

void KBI1_init(void);
interrupt VectorNumber_Vkbi1 void  KBI1_service(void);

/* enabling KBI for a validation selector */
void KBI1_init(void)
{
   ENABLE_MUX_CONTROL;
   
   /*starting KBI1 clock*/
   SCGC3_KBI1 = 1;
       
   /*FSL:pin init for Nucleus*/
   PTBPF1_B6    = 1;
   PTBPF1_B7    = 1;

   /*make them explicitily input!!!*/
   PTBDD_PTBDD6 = 0;
   PTBDD_PTBDD7 = 0;
   
   /*pull-up for SW3 & 4*/
   PTBPE_PTBPE6 = 1;
   PTBPE_PTBPE7 = 1;

   KBI1SC_KBIE = 0; // disable
   
   KBI1ES       = 0; //Pull up connected, detects falling edge in all KBI1 pins
   KBI1PE       = KBI1PE_KBIPE5_MASK|KBI1PE_KBIPE4_MASK;
   
   KBI1SC_KBACK = 1; // clear KBIF
   KBI1SC_KBIE  = 1;
   
   DISABLE_MUX_CONTROL;   
}

/*
  specific assignation for validations
 */    

interrupt VectorNumber_Vkbi1 void  KBI1_service(void) 
{
    //sharing functions due to lack of KBI buttons,
    static uint8 button_SW3 = 0,button_SW4 = 0;

     KBI1SC_KBACK = 1;            // clear KBIF
     
     //SW3 - PTE5     
     if(!SW3)
     {
      if(!button_SW3)
      {
        button_SW3 = ~button_SW3;
        sw_303_click();
      }
      else
      {
        button_SW3 = ~button_SW3;
        sw_301_click();
      }
      //button_SW3 = ~button_SW3;
     }
     
     //SW4 - PTE3
     if(!SW4)
     {
      if(!button_SW4)
      {
        button_SW4 = ~button_SW4;
        sw_304_click();
      }
      else
      {
        button_SW4 = ~button_SW4;
        sw_302_click();
      }
     }
}
  
