#include "m51em256evb.h"
#include "tpm.h"
#include "low_power.h"

//needed for SCI validation!!!

volatile dword TPMCount = 0;

/*starting function for the delay*/
void TPM_Init()
{
       /*starting timer clock*/
       SCGC4_TPM = 1;
       TPMSC_TOIE = 1;      //Enable interrupts
       TPMMOD = 0xFFFF;
       TPMSC_PS = 0b101;      
}

/*
 * Delay function using channel one
 * 1ms up to 65 seconds!! ~aprox
 * change #defien SYSTEM_CLOCK if core freq has changed!!!!!
 * b06862 
 */

void StartTPM(void){

  TPMCount = 0;        //Clear Counter Variable
  TPMCNTH = 0x00;      //Clear TPM Counter
  TPMSC_TOF = 0;
  TPMSC_CLKSx = 0x01;  //Start TPM with Bus clock 
  LED3_OFF();           //Turn on LED
}

dword Stop_Read_TPM(void){

  TPMSC_CLKSx = 00;   //Stop Counter
  TPMCount |= TPMCNT;
  LED3_ON();
  return(TPMCount*1.28);

}

__interrupt void TPM_ISR(void){

    TPMSC_TOF = 0;
    TPMCount += 0x10000;
    LED4_TOGGLE();
}


void TPM_delay(word A){
  
  TPMCount = 0;        //Clear Counter Variable
  TPMCNTH = 0x00;      //Clear TPM Counter
  TPMSC_TOF = 0;
  TPMSC_CLKSx = 0x01;  //Start TPM with Bus clock 
  while((TPMCount>>16)<A)asm(nop);
  TPMSC_CLKSx = 00;   //Stop Counter
  TPMCount |= TPMCNT;
}