/*****************************************************************************
 * Copyright (c) 2008, Freescale Semiconductor                               *
 * Freescale Quick Note                                                      *
 *                                                                           *
 * File name   : main.c                                                      *
 * Project name: EzPORT demo software                                        *
 *                                                                           *
 * Author      : Paolo Alcantara                                             *
 * Department  : RTAC Americas                                               *
 *                                                                           *
 * Description : Send a s19 file received from UART using QSPI controller	 *
 *                                                                           *
 *				 Connect the following cables between boards:                *
 *				 PC -> SERIAL -> 5213(SPI) -> connections -> 5213(EzPort)	 *
 * 																			 *
 *    SPI		     EzPort													 *
 *    																		 *
 *    DOUT			 DIN													 *
 *    DIN			 DOUT													 *
 *    SCLK			 CLK													 *
 *    SPI_CS0		 RCON													 *
 *    TC0   		 RSTOUT													 *
 *	  TC1   		 RSTIN													 *
 *    GND            GND                                                     *
 *																			 *
 *	  @115.2 Kbps 8-N-1-XON/XOFF                                             *
 * History     :                                                             *
 * 4/16/2007   : First version of the software                               *
 * 1/23/2008   : Second version of the sofware                               *
 *                                                                           *
 *****************************************************************************/

#include "stdlib.h"
#include "common.h"
#include "serial_s19.h"
#include "qspi.h"
#include "ezport.h"


/************************************MAIN*************************************/

void main()
{
	printf("\nEzPort example code\n");
	
	/* starting EzPORT interface */
	if(EzPORTinit())
	{
		printf("Error during EzPort init\n");
	}
	else
	{
		if(EzPORTerase())
		{
			printf("Error during erase\n");			
		}
		else
		{
			printf("Send code using xoff-xon control at 115.2Kbps\n");
	
			/* get s19 file from uart interface */
			dl_download_srec(FALSE);
		}
	}
		
	while(1)
	;
}

