/*
 * File:	mcf5213.c
 * Purpose:	MCF521x specific routines	
 *
 * Notes:		
 */

#pragma cplusplus off
#include "common.h"

extern int d0_reset;
extern int d1_reset;

/********************************************************************/
void
cpu_startup (void)
{
#ifdef DEBUG_PRINT
    /*
     * Determine cause(s) of reset
     */
    printf("\n\n");
    if (MCF_SCM_CRSR & MCF_SCM_CRSR_CWDR)
        printf("Core Watchdog Time Reset\n");
    if (MCF_CIM_RSR & MCF_CIM_RSR_LVD)
        printf("Low Voltage Detect Reset\n");
    if (MCF_CIM_RSR & MCF_CIM_RSR_SOFT)
        printf("Software Reset\n");
    if (MCF_CIM_RSR & MCF_CIM_RSR_WDR)
        printf("Watchdog Timer Reset\n");
    if (MCF_CIM_RSR & MCF_CIM_RSR_POR)
        printf("Power-on Reset\n");
    if (MCF_CIM_RSR & MCF_CIM_RSR_EXT)
        printf("External Reset\n");
    if (MCF_CIM_RSR & MCF_CIM_RSR_LOC)
        printf("Loss of Clock Reset\n");
    if (MCF_CIM_RSR & MCF_CIM_RSR_LOL)
        printf("Loss of PLL Lock Reset\n");
#endif
#if 0
    /*
     * Print out the core integration information
     */
    mcf5xxx_interpret_d0d1(d0_reset,d1_reset);
#endif

    /* 
	 * Enable on-chip modules to access internal SRAM 
	 */
	MCF_SCM_RAMBAR = 0
	    | MCF_SCM_RAMBAR_BA(SRAM_ADDRESS)
        | MCF_SCM_RAMBAR_BDE;
}
/********************************************************************/
void
cpu_handle_interrupt (int vector)
{
    if (vector < 64 || vector > 192)
        return;
    
    switch (vector)
    {
        case 65: /* Eport Interrupt 1 */
        case 66: /* Eport Interrupt 2 */
        case 67: /* Eport Interrupt 3 */
        case 68: /* Eport Interrupt 4 */
        case 69: /* Eport Interrupt 5 */
        case 70: /* Eport Interrupt 6 */
        case 71: /* Eport Interrupt 7 */

            /* 
             * Clear the interrupt source 
             * This clears the flag for edge triggered interrupts
             */
            MCF_EPORT_EPFR = (uint8)(0x01 << (vector - 64));
            printf("Edge Port Interrupt #%d\n",vector - 64);
            break;  
        default:
            printf("User Defined Vector #%d\n",vector);
            break;
    }
}
/********************************************************************/
/*
 * Pause for the specified number of micro-seconds.
 * Uses DTIM3 as a timer
 */
void
cpu_pause(int usecs)
{
    /* Enable the DMA Timer 3 */
    MCF_DTIM3_DTRR = (usecs - 1);
    MCF_DTIM3_DTER = MCF_DTIM_DTER_REF;
    MCF_DTIM3_DTMR = 0
        | MCF_DTIM_DTMR_PS(sys_clk_khz / 1000)
        | MCF_DTIM_DTMR_ORRI
        | MCF_DTIM_DTMR_FRR
        | MCF_DTIM_DTMR_CLK_DIV1
        | MCF_DTIM_DTMR_RST;

    while ((MCF_DTIM3_DTER & MCF_DTIM_DTER_REF) == 0) 
    {};
    
    /* Disable the timer */
    MCF_DTIM3_DTMR = 0;
}
/********************************************************************/
