#include "MC1321XZSTAR3.h"
#include "drivers.h"


#pragma DATA_SEG SHORT _DATA_ZEROPAGE
 extern  UINT8 gu8RTxMode;						        //!< Global mode mirror. MC13192 Status. 
#pragma DATA_SEG DEFAULT

void RadioInit(void) {
#if 0
    SPIDrvWrite(0x11,0x80FF);   /* Eliminate Unlock Conditions due to L01 */
    SPIDrvWrite(0x1B,0x8000);   /* Disable TC1. */
    SPIDrvWrite(0x1D,0x8000);   /* Disable TC2. */
    SPIDrvWrite(0x1F,0x8000);   /* Disable TC3. */
    SPIDrvWrite(0x21,0x8000);   /* Disable TC4. */
    SPIDrvWrite(0x07,0x4C00);   /* Enable CLKo in Doze */
    SPIDrvWrite(0x0C,0x0381);   /* IRQ pull-up disable. Vdd for RF switch is set*/
    SPIDrvWrite(0x04,0xA08D);   /* New cal value */
    SPIDrvWrite(0x05,0x8351);   /* Acoma, TC1, Doze, ATTN masks, LO1, CRC */
    SPIDrvWrite(0x06,0x4720);   /* CCA, TX, RX, energy detect */
    SPIDrvWrite(0x0B,0xC0FE);   /* IRQ pull-up disable. Vdd for RF switch is set*/
    (void)SPIDrvRead(0x25);
    /* Advance the state variable to Idle */
    gu8RTxMode = IDLE_MODE;
 #else
 /* Please refer to document MC13192RM for hidden register initialization */
    SPIDrvWrite(0x11,0x20FF);   /* Eliminate Unlock Conditions due to L01 */
    SPIDrvWrite(0x1B,0x8000);   /* Disable TC1. */
    SPIDrvWrite(0x1D,0x8000);   /* Disable TC2. */
    SPIDrvWrite(0x1F,0x8000);   /* Disable TC3. */
    SPIDrvWrite(0x21,0x8000);   /* Disable TC4. */
    SPIDrvWrite(0x07,0x5C00);   /* Enable CLKo in Doze */
    SPIDrvWrite(0x0C,0x0300);   /* IRQ pull-up disable. */
    (void)SPIDrvRead(0x25);           /* Sets the reset indicator bit */
    SPIDrvWrite(0x04,0xA08D);   /* New cal value */
    SPIDrvWrite(0x08,0xFFF7);   /* Preferred injection */
    SPIDrvWrite(0x05,0x8351);   /* Acoma, TC1, Doze, ATTN masks, LO1, CRC */
    SPIDrvWrite(0x06,0x4720);   /* CCA, TX, RX, energy detect */
 
    /* Read the status register to clear any undesired IRQs. */
    (void)SPIDrvRead(0x24);           /* Clear the status register, if set */
    gu8RTxMode = IDLE_MODE;     /* Update global to reflect MC13192 status */
 #endif   
}