/* 13213-ZSTAR3.h 
 * Header for the MC13213-ZSTAR3 reference board

 * $Author: rgd04c $
 * $Date: Feb-19-2008$
 * $Name:  $
 */
 
//includes
#include "pub_def.h"
#include "board_config.h"

//Prototypes
void RadioInit(void);

//Defines


#define MC1321X
#define HCS08G
#define MC13192_CE              PTED_PTED2                
#define MC13192_CE_PORT         PTEDD_PTEDD2                
#define MC13192_ATTN            PTDD_PTDD0
#define MC13192_ATTN_PORT       PTDDD_PTDDD0
#define MC13192_RTXEN           PTDD_PTDD1
#define MC13192_RTXEN_PORT      PTDDD_PTDDD1
#define MC13192_RESET           PTDD_PTDD3
#define MC13192_RESET_PORT      PTDDD_PTDDD3
#define MC13192_RESET_PULLUP    PTDPE_PTDPE3
#define MC13192_IRQ_SOURCE      IRQSC
#define MC13192_IRQ_IE_BIT      IRQSC_IRQIE


/* Antenna Switch/PA can be implemented via the CT_Bias control line */
/* See the MC1321x reference manual */

#ifdef ANTENNA_SWITCH
    #define MC13192_ANT_CTRL        PTBD_PTBD6
    #define MC13192_ANT_CTRL2       PTBD_PTBD6   /* 
                                                  * Second Control line not
                                                  * used in MC13192EVB
                                                  */
    #define MC13192_ANT_CTRL_PORT   PTBDD_PTBDD6
    #define MC13192_ANT_CTRL2_PORT  PTBDD_PTBDD6 /* 
                                                  * Second Control line not 
                                                  * used in MC13192EVB
                                                  */
    #define ANT_CTRL_OFF            0       /* Logic low is off */
    #define ANT_CTRL_ON             1       /* Logic high is on */
#endif ANTENNA_SWITCH

#ifdef LNA
    #define MC13192_LNA_CTRL        PTBD_PTBD0
    #define MC13192_LNA_CTRL_PORT   PTBDD_PTBDD0
    #define LNA_ON                  1
    #define LNA_OFF                 0
#endif LNA  


/**************************************************************
Enable peripherials that are on the Board
**************************************************************/


//#define ACCEL_ENABLED         TRUE

#define DEFAULT_BUS_SPEED	   8000000

#define  SCI_DEFAULT_BAUD  38400

/**************************************************************
Define the SCI perameters
**************************************************************/

   #define  SCIBDH     SCI1BDH
   #define  SCIBDL     SCI1BDL
   #define  SCIC1      SCI1C1 
   #define  SCIC2      SCI1C2 
   #define  SCIS1      SCI1S1 
   #define  SCIS2      SCI1S2 
   #define  SCIC3      SCI1C3 
   #define  SCID       SCI1D

   #define  SCIS1_TDRE  SCI1S1_TDRE
   #define  SCIS1_TC    SCI1S1_TC

/**************************************************************
Define the SPI perameters
**************************************************************/

#if __VERSION__ <= 5021  // CW5.1 does not implement these correctly in header
  
  #ifndef SPI1C1
    #define SPI1C1 SPIC1
  #endif
       
  #ifndef SPI1C2
    #define SPI1C2 SPIC2
  #endif
    
#endif
  
/**************************************************************
Define the LED perameters
**************************************************************/

#define LED1                    PTCD_PTCD5
#define LED1DIR                 PTCDD_PTCDD5

    
#define LED_ON                  1
#define LED_OFF					        0
#define DDIR_OUTPUT             1
#define DDIR_INPUT              0
    
#define LED_INIT_MACRO LED1     = LED_OFF; \
                       LED1DIR  = DDIR_OUTPUT;      
    
    
/***********************************************
Define Switches
***********************************************/
    
    
/* SW1 on schematic */
#define PB0 PTAD_PTAD7
#define PB0PU PTAPE_PTAPE7
#define PB0DIR PTADD_PTADD7
#define PB0IE KBI1PE_KBIPE7
  
/* SW2 on schematic */
#define PB1 PTAD_PTAD6
#define PB1PU PTAPE_PTAPE6
#define PB1DIR PTADD_PTADD6
#define PB1IE KBI1PE_KBIPE6
   
/* SW3 on schematic */
#define PB2 PTAD_PTAD0
#define PB2PU PTAPE_PTAPE0
#define PB2DIR PTADD_PTADD0
#define PB2IE KBI1PE_KBIPE0
  

/* Define the KBI Pins */
#define KBI_SW1 0x80
#define KBI_SW2 0x40
#define KBI_SW3 0x01

#define SWITCH_INIT_MACRO    PB0PU  = TRUE; \
                             PB1PU  = TRUE; \
                             PB2PU  = TRUE; \
                             PB0DIR = FALSE;\
                             PB1DIR = FALSE;\
                             PB2DIR = FALSE;

                            

    
/***********************************************
Define Port B
Accelerometer
***********************************************/

#define ACCEL_PS          PTBD_PTBD5
#define ACCEL_GSELECT1    PTBD_PTBD1
#define ACCEL_START_X     ATD1SC = 2;
#define ACCEL_START_Y     ATD1SC = 3;
#define ACCEL_START_Z     ATD1SC = 4;         
  
#define ACCEL_INIT_MACRO  ATD1PE=0x1C; ATD1C=0xE1;\
                          PTBDD_PTBDD0=DDIR_OUTPUT;\
                          PTBDD_PTBDD1=DDIR_OUTPUT;\
                          PTBDD_PTBDD5=DDIR_OUTPUT;
                          
#define ACCEL_G_OFF       ACCEL_PS = 0;
#define ACCEL_G_ON        ACCEL_PS = 1; 
#define ACCEL_G_1p5       ACCEL_GSELECT1 = 0; ACCEL_GSELECT2 = 0;
#define ACCEL_G_2p0       ACCEL_GSELECT1 = 0; ACCEL_GSELECT2 = 1;
#define ACCEL_G_4p0       ACCEL_GSELECT1 = 1; ACCEL_GSELECT2 = 0;
#define ACCEL_G_6p0       ACCEL_GSELECT1 = 1; ACCEL_GSELECT2 = 1;

    

/***********************************************
Temperature Sensor
***********************************************/


                              
                              
#define ENTER_LOW_POWER _asm stop

/***********************************************
Duplicate PB0 to PUSH_BUTTON1 etc for different
formats.
***********************************************/

#define PUSH_BUTTON1 PB0
#define PUSH_BUTTON2 PB1
#define PUSH_BUTTON3 PB2

#define BUTTON1 PB0
#define BUTTON2 PB1
#define BUTTON3 PB2

#define PB_PRESSED 0
/***********************************************
Define Buzzer
***********************************************/

