/********************************************************************************
*                                                                     
*       Copyright (C) 2009 Freescale Semiconductor, Inc.              
*       All Rights Reserved								              
*														              
* Filename:     main.c                
*														              
* Revision:     11/09/09 										              
*														              
* Functions:    Includes main function
*         
* Description:  
*
* Notes:        Use SCI when debugging only
*
*********************************************************************************/

#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "porting_support.h"
#include "ICS.h"
#include "ADC16.h"
#include "PDB.h"
#include "sci_drv.h"
#include "interrupts.h"

/*********************************** Defines ***********************************/

#define BUSCLK_FREQ_KHZ		20000L	
#define TERMINAL_BAUD_RATE	57600 
#define SCIBD_BAUD_RATE ((BUSCLK_FREQ_KHZ * 10) / (16 * (TERMINAL_BAUD_RATE/100)))

#define ON  0xFF
#define OFF 0x00
#define SET 0xFF
#define CLEAR 0x00

/*********************************** Function **********************************/

void System_Init(void);
void Init_RTC(void);
void Init_Pins(void);

/*******************************************************************************
* Function:        main
*
* Description:     
*
* Returns:         never return
*
* Notes:           system, ICS, SCI1, PDB and ADC1-4 initialised.
*
*                  ADCH -> ADCn ->->-> MUX -> Pin# -> MCU Port Header
*                  DADP0   3           n/a    22      29
*                  DADP1   1           n/a    25      31
*                  DADP2   2           n/a    28      33
*                  DADP3   4           n/a    31      35
*                  DADM0   3           n/a    23      30
*                  DADM1   1           n/a    26      32
*                  DADM2   2           n/a    29      34
*                  DADM3   4           n/a    32      36
*                  AD4     3           n/a    24      25
*                  AD5     1           n/a    27      27
*                  AD6     2           n/a    30      22
*                  AD7     4           n/a    33      24
*                  AD8     3           E0     42      41
*                  AD9     3           E1     43      43
*                  AD10    1           A2     45      19
*                  AD11    1           A5     48      13
*                  AD12    1           A6     49      15
*                  AD13    3 & 1       A7     50      39
*                  AD14    2           B6     64      9
*                  AD15    2           B7     65      11
*                  AD16    2           F4     16      *39(LCD_EN J26)
*                  AD17    4 & 2       F4     17      *37(LCD_EN J26)
*                  AD18    4 & 2       F4     18      *35(LCD_EN J26)
*                  AD19    4 & 2       F4     19      *33(LCD_EN J26)
*                 
*******************************************************************************/

void main(void) {

  System_Init();      /* including pin mux control, ADC channel or I/O */
  
  DisableInterrupts; /* Disable interrupts */
  
  /* 16MHz FEI mode */
  ICS_Config((CLKS_FLL|IREFS_INTERNAL|IRCLKEN_ACTIVE|IREFSTEN_INTERNAL_STOP_DISABLE),
  (BDIV_1|LP_FLL_ENABLED|EREFS_OSCILLATOR|ERCLKEN_ACTIVE|EREFSTEN_INTERNAL_STOP_ENABLE), 0x80,(DCO_RANGE_MID|DCO_MAX_25)); 
    
  /* Configure SCI1 for terminal data from ADC when debugging*/
  TerminalPointer = (tSCI *)SCI2;
  SCI_Config(TerminalPointer, SCIBD_BAUD_RATE);
  /* SCI comms are slow and cause ISR conjestion resulting in PDB errors */
  
  /* Configure ADCs */
  ADCPointer = (tADC *)ADC1;
  ADC_Init(ADCPointer, (ADLPC_NORMAL|ADIV_2|ADLSMP_SHORT|MODE_16|ADICLK_BUS_2), (ADACKEN_DISABLED|ADHSC_HISPEED|ADLSTS_2) , 0, 0,
  (ADTRG_HW|ACFE_DISABLED|ACREN_DISABLED|REFSEL_EXT), (ADCO_SINGLE|AVGE_DISABLED|AVGS_32), (AIEN_OFF|DIFF_SINGLE|0x1F),
  (AIEN_OFF|DIFF_SINGLE|0x1F), Vtemp, Bandgap);
  
  ADCPointer = (tADC *)ADC2;
  ADC_Init(ADCPointer, (ADLPC_NORMAL|ADIV_2|ADLSMP_SHORT|MODE_16|ADICLK_BUS_2), (ADACKEN_DISABLED|ADHSC_HISPEED|ADLSTS_2) , 0, 0,
  (ADTRG_HW|ACFE_DISABLED|ACREN_DISABLED|REFSEL_EXT), (ADCO_SINGLE|AVGE_DISABLED|AVGS_32), (AIEN_OFF|DIFF_SINGLE|0x1F),
  (AIEN_OFF|DIFF_SINGLE|0x1F), Vtemp, Bandgap);
  
  ADCPointer = (tADC *)ADC3;
  ADC_Init(ADCPointer, (ADLPC_NORMAL|ADIV_2|ADLSMP_SHORT|MODE_16|ADICLK_BUS_2), (ADACKEN_DISABLED|ADHSC_HISPEED|ADLSTS_2) , 0, 0,
  (ADTRG_HW|ACFE_DISABLED|ACREN_DISABLED|REFSEL_EXT), (ADCO_SINGLE|AVGE_DISABLED|AVGS_32), (AIEN_OFF|DIFF_SINGLE|0x1F),
  (AIEN_OFF|DIFF_SINGLE|0x1F), Vtemp, Bandgap);
  
  ADCPointer = (tADC *)ADC4;
  ADC_Init(ADCPointer, (ADLPC_NORMAL|ADIV_2|ADLSMP_SHORT|MODE_16|ADICLK_BUS_2), (ADACKEN_DISABLED|ADHSC_HISPEED|ADLSTS_2) , 0, 0,
  (ADTRG_HW|ACFE_DISABLED|ACREN_DISABLED|REFSEL_EXT), (ADCO_SINGLE|AVGE_DISABLED|AVGS_32), (AIEN_OFF|DIFF_SINGLE|0x1F),
  (AIEN_OFF|DIFF_SINGLE|0x1F), Vtemp, Bandgap);
  
  /* 20MHz FEI mode */
  ICS_Config((CLKS_FLL|IREFS_INTERNAL|IRCLKEN_ACTIVE|IREFSTEN_INTERNAL_STOP_DISABLE),
  (BDIV_1|LP_FLL_ENABLED|EREFS_OSCILLATOR|ERCLKEN_ACTIVE|EREFSTEN_INTERNAL_STOP_ENABLE), 0xF0,(DCO_RANGE_HIGH|DCO_MAX_25)); 
   
  /* Configure PDB */
  PDBInit((PRESCALER_1|IF_SET|CONT_CONT|TRIGSEL_SW|IE_ENABLED|EN_DISABLED), 0xFFFF, 0xF000);
  
  EnableInterrupts;     /* Enable interrupts */                 
  
  PDBSCR_SWTRIG = 1;    /* start PDB running */
    
  for(;;) {
    
    _Wait;   
          
  } /* loop forever */

}


/******************************************************************************
Function Name	:	System_Init
Engineer      :	r54940
Date          :	11/09/09

Parameters		:	
Returns			  :	NONE
Notes         :	Configures system registers and I/O
******************************************************************************/
void System_Init(void)
{
 
  IRQSC = OFF;
  VREFSC = 0x81;
  SPMSC1 = 0x01;         /* Enable Bandgap */
  SPMSC2 = OFF;
  SPMSC3 = OFF;
  SOPT1 = 0x20;          /* Enable Stop Mode, Disable COP */
  INTC_WCR = 0x86;       /* Enable all levels of interrupts */
  SCGC1 = 0xF7;          /* ADC's and SCI's gated on */
  SCGC2 = 0x20;          /* Vref Gated on */
  SCGC3 = 0x3F;
  SCGC4 = 0x48;          /* PDB gated on */
  SCGC5 = 0xFC;
  SIMIPS1 = OFF;
  SIMIPS2 = OFF;
  
  Init_RTC();
  Init_Pins();
 
}

/******************************************************************************
Function Name	:	Init_RTC
Engineer      :	r54940
Date          :	11/09/09

Parameters		:	
Returns			  :	NONE
Notes         :	RTC Initialisation
******************************************************************************/

void Init_RTC(void)
{
  /* unlock sequence */
  IRTC_CTRL = 0;/* 0b00 */
  IRTC_CTRL = 1;/* 0b01 */
  IRTC_CTRL = 3;/* 0b11 */
  IRTC_CTRL = 2;/* 0b10 */
   
  /* disable all RTC interrupts including tamper */
  IRTC_IER = 0;  
  IRTC_CTRL = 15<<9;  /* maximum tamper duration */
  IRTC_CTRL |= 0x02;  /* enable write protect */
}

/******************************************************************************
Function Name	:	Init_Pins
Engineer      :	r54940
Date          :	11/09/09

Parameters		:	
Returns			  :	NONE
Notes         :	I/O
******************************************************************************/
void Init_Pins(void)
{
  
  /* enable all ADC pins via mux control register */
  PTAPF1 = 0xFC;
  PTAPF2 = 0x30;
  PTBPF1 = 0xF0;
  PTBPF2 = 0x0F;
  PTCPF1 = 0x00;
  PTCPF2 = 0x00;
  PTDPF1 = 0x00;
  PTDPF2 = 0x00;
  PTEPF1 = 0x00;
  PTEPF2 = 0x0F;
  PTFPF1 = 0xFF;
  PTFPF2 = 0x00;
  
  /* disable all pull ups */
  PTAPE = ON;
  PTBPE = ON;
  PTCPE = ON;
  PTDPE = ON;
  PTEPE = ON;
  PTFPE = ON;
  
  /* low drive strength */
  PTADS = OFF;
  PTBDS = OFF;
  PTCDS = OFF;
  PTDDS = OFF;
  PTEDS = OFF;
  PTFDS = OFF;
  
  /* disable slew rate */
  PTASE = OFF;
  PTBSE = OFF;
  PTCSE = OFF;
  PTDSE = OFF;
  PTESE = OFF;
  PTFSE = OFF;
  
  /* enable input filters */
  PTAIFE = ON;
  PTBIFE = ON;
  PTCIFE = ON;
  PTDIFE = ON;
  PTEIFE = ON;
  PTFIFE = ON;
  
  /* clear I/O data */
  PTAD = CLEAR;
  PTBD = CLEAR;
  PTCD = CLEAR;
  PTDD = CLEAR;
  PTED = CLEAR;
  PTFD = CLEAR;
  
  /* all ports outputs */
  PTADD = SET;
  PTBDD = SET;
  PTCDD = SET;
  PTDDD = SET;
  PTEDD = SET;
  PTFDD = SET;

}