/****************************************************************************************************/
/**
\file       ICS.c
\author     Alejandra Guzmn Castellanos
\author     Freescale Semiconductor
\author     Technical Information Center (TIC)
\version    1.0
\date			August 2009      
*/
/****************************************************************************************************/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.  	*/
/* CUSTOMER retains the final decision relative to the total design and functionality of the end 	*/
/* product.                                                                                      	*/
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/


/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "ICS.h"

/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide MACROs / #DEFINE-CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Declaration of module wide TYPEs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide VARIABLEs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide (CONST-) CONSTANTs - NOT for use in other modules
*****************************************************************************************************/
const UINT8 NVTrimValue@0x03FF; 
const UINT8 NVFineTrimeValue @0x03FE;  
/*****************************************************************************************************
* Code of project wide FUNCTIONS
*****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief    
* \author   
* \param   void  
* \return   void
* \todo     
*/
/****************************************************************************************************/
void vfnICS_FEI (void)
{
    /** Trim internal oscillator to 31.25 kHz */
   	ICSTRM = NVTrimValue;

	/** 20MHz of bus frequency */
	ICSSC = (UINT8)(DRST + DMX32_ENABLE + NVFineTrimeValue);

	/**	BDIV:00 divide selected clock by 1 RANGE:0 low frequency range HGO:0 low power;
			LP:1 FLL disable in bypass mode EREFS:0 no effect ERECLKEN:0 no effect EREFSTEN:0 no effect*/
	ICSC2 =  ICSC2_LP_MASK;

	/**	CLKS:00 output of FLL  RDIV:000 divide by 1 the reference for the FLL
			IREFS:1 internal reference clock IRCLKEN:1 enable ICSIRCLK IREFSTEN:0 internal reference clock is disable during stop*/ 
	ICSC1 =  ICSC1_IREFS_MASK +  ICSC1_IRCLKEN_MASK;

}
/****************************************************************************************************/
