/****************************************************************************************************/
/**
\file       	IRTC.c
\author     Alejandra Guzmn Castellanos
\author     Freescale Semiconductor
\author     Technical Information Center (TIC)
\version    1.0
\date			August 2009      
*/
/****************************************************************************************************/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.  	*/
/* CUSTOMER retains the final decision relative to the total design and functionality of the end 	*/
/* product.                                                                                      	*/
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.					*/
/*                                                                                                  															*/
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, 							*/
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         							*/
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      						*/
/* FREESCALE services.                                                                              													*/
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     						*/
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or 			*/
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        					*/
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER							*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      							*/
/*                                                                                                  															*/
/****************************************************************************************************/

/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "IRTC.h"

/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide MACROs / #DEFINE-CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Declaration of module wide TYPEs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide VARIABLEs - NOT for use in other modules
*****************************************************************************************************/
UINT8 gu8IRTCStatusFlag = 0;

/*****************************************************************************************************
* Definition of module wide (CONST-) CONSTANTs - NOT for use in other modules
*****************************************************************************************************/
/*****************************************************************************************************
* Code of project wide FUNCTIONS
*****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief   Robust Real Time Clock (IRTC) Initialization 
* \param  void  
* \return   void
* \todo     
*/
void vfnIRTC_Init (void)
{
	vfnUnprotectRTC();

	IRTC_CTRL_INIT; 
	IRTC_YEARMON_bin_YEAR = SetYear(_YEAR);
	IRTC_YEARMON_bin_MONTH = _MONTH;
	IRTC_DAYS_bin_DAYS = _DAY;
	IRTC_HOURMIN_bin = (UINT16)((_HOUR<<8) + _MINUTES);
	IRTC_SECONDS_bin = _SECONDS;
	IRTC_ISR = 0xFF;																														//Clear all interrupts
	IRTC_IER = IRTC_IER_MIN_MASK + IRTC_IER_HR_MASK + IRTC_IER_1HZ_MASK;				//Enable minute and hour interrupt

  PROTECT_IRTC();
}
/****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief	Disable the protection of the IRTC 
* \param  	void 						
* \return   void
*/
 
void vfnUnprotectRTC (void)
{
do
{
	if (IRTC_PROTECTED)						/** If protection enable, disable write protection */
	{
		UNPROTECT_IRTC();					/** Secuence to unprotect IRTC*/
	}
}while (IRTC_PROTECTED);
   


}
/****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief	Unprotect the IRTC, and returns the Year status from the RTC_YEARMON register   
* \param  	void 						
* \return 	UINT16 -- time status in years 
*/
UINT16 u16IRTC_Time_GetYear (void)
{
  UINT16 u16Temp;
	
	vfnUnprotectRTC ();
	u16Temp = GetYear(IRTC_YEARMON_bin_YEAR);
	PROTECT_IRTC ();

	return (u16Temp);
}
/****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief	Unprotect the IRTC, and returns the Time Month status from the RTC_YEARMON register   
* \param  	void 						
* \return 	UINT8 -- Current Month 
*/
UINT8 u8IRTC_Time_GetMonth (void)
{
  UINT8 u8Temp;
	
	vfnUnprotectRTC ();
	u8Temp = (UINT8)(IRTC_YEARMON_bin_MONTH);
	PROTECT_IRTC ();

	return (u8Temp);
}
/****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief   Unprotect the IRTC, and returns the Day status from the RTC_DAYS register   
* \param  	void 						
* \return   UINT8 -- Current Day
*/
UINT8 u8IRTC_Time_GetDay (void)
{
  UINT8 u8Temp;
	
	vfnUnprotectRTC ();
	u8Temp = (UINT8)(IRTC_DAYS_bin_DAYS);
	PROTECT_IRTC ();

	return (u8Temp);
}
/****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief  	Unprotect the IRTC, and returns the Hour status from the RTC_HOURMIN register   
* \param  	void 						
* \return 	UINT8 -- Current Hour 
*/
UINT8 u8IRTC_Time_GetHour(void)
{
  UINT8 u8Temp;
	
	vfnUnprotectRTC ();
	u8Temp = (UINT8)(IRTC_HOURMIN_bin_HOURS);
	PROTECT_IRTC ();

	return (u8Temp);
}
/****************************************************************************************************/


/****************************************************************************************************/
/**
* \brief  	Unprotect the IRTC, and returns the Minute status from the RTC_HOURMIN register    
* \param  	void 						
* \return 	UINT8 -- Current Minute
*/
UINT8 u8IRTC_Time_GetMinute (void)
{
  UINT8 u8Temp;
	
	vfnUnprotectRTC ();
	u8Temp = (UINT8)(IRTC_HOURMIN_bin_MINUTES);
	PROTECT_IRTC ();

	return (u8Temp);
}
/****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief 	Unprotect the IRTC, and returns the Countdown status from the RTC_COUNT_DN register       
* \param  	void 						
* \return   UINT8 -- current countdown status 
*/
UINT8 u8IRTC_GetCountDown (void)
{
  UINT8 u8Temp;
	
	vfnUnprotectRTC ();
	u8Temp = (UINT8)(IRTC_COUNT_DN_bin_COUNTDOWN_COUNT);
	PROTECT_IRTC ();

	return (u8Temp);
}
/****************************************************************************************************/


interrupt VectorNumber_Vrtc void RTC_ISR (void)
{
  UINT16 u16Temp;	

   /** Tell to the Main State Machine that an IRTC event has occur*/
	IRTC_EVENT;

	/** Clear all the RTC interrupts	*/	
	vfnUnprotectRTC ();
												
  u16Temp = IRTC_ISR;
	IRTC_ISR = 0xFFFF;
		
	PROTECT_IRTC();										
	
	/** A minute interrupt has occur, therefore countdown interrupt is enable */
	if ((u16Temp & 0x0020) && IRTC_CNTDN )	 
	{
		IRTC_IER_STW = 1;										
		IRTC_MIN_EVENT;
	}

	/** When a countdown interrupt occurs toggle LED1, and disable count-down mode*/
	if (u16Temp & 0x0002)											
	{
		IRTC_CNTDN_CLEAR;
		LED1_TOGGLE;
	}

	u16Temp = 0; 

}




