/****************************************************************************************************/
/**
\file       KBI.c
\brief      
\author     Alejandra Guzmn Castellanos
\author     Freescale Semiconductor
\author     Technical Information Center (TIC)
\version    1.0
\date		August 2009      
*/
/****************************************************************************************************/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.  	*/
/* CUSTOMER retains the final decision relative to the total design and functionality of the end 	*/
/* product.                                                                                      	*/
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/

/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "KBI.h"

/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide MACROs / #DEFINE-CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Declaration of module wide TYPEs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide VARIABLEs - NOT for use in other modules
*****************************************************************************************************/
 UINT8 gu8KBIStatusFlag;
 UINT32 gu32Keys = 0xFF;
/*****************************************************************************************************
* Definition of module wide (CONST-) CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Code of project wide FUNCTIONS
*****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief	Initializes the Keyboard Interrupt Module, with the macros previously defined at the KBI.h file     
* \param    void  
* \return   void
* \todo     
*/
void vfnKBI_Init (void)
{
	/** Port pin functionality*/
    KBI4_EN;
	KBI5_EN;
	/** Mask KBI interrupts*/
	KBI1SC_KBIE = 0;					
	/** Select interrupt edge*/
	KBI4_FALLING_EDGE;
	KBI5_FALLING_EDGE;
	/** Internal pullup*/
	KBI4_PULLUP_ENABLE;
	KBI5_PULLUP_ENABLE;
	/** Activate interrupts*/
	KBI4_IE;
	KBI5_IE;
	/** Clear any false interrupt*/
    KBI1SC_KBACK = 1;
	/** Enable KBI interrupts*/
	KBI1SC_KBIE = 1;	
}
/****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief	This function clears the KBI interrupt flag, stores in a global variable the KBI_PORT status,
			and finally sets a flag to tell the main application that a KBI event just occur.     
   
* \param    UINT8  
* \return   void
* \todo     
*/
interrupt VectorNumber_Vkbi1 void KBI_ISR (void)
{
 	/** Clear interrupt flag*/
  KBI1SC_KBACK = 1;
	
	/** Read KBI port */
	gu32Keys = KBI_PORT;

	/** Update flag status */
	KBI_EVENT;	 
}
/****************************************************************************************************/

