/****************************************************************************************************/
/**
\file       KBI.h
\brief      
\author     Alejandra Guzmn Castellanos
\author     Freescale Semiconductor
\author     Technical Information Center (TIC)
\version    1.0
\date			August 2009      
*/
/****************************************************************************************************/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.  	*/
/* CUSTOMER retains the final decision relative to the total design and functionality of the end 	*/
/* product.                                                                                      	*/
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/

/*****************************************************************************************************
* Module definition against multiple inclusion
/*****************************************************************************************************/
#ifndef __APP_KBI_H
#define __APP_IRTCI_H

/*****************************************************************************************************
* Include files
/*****************************************************************************************************/

/** Variable types and common definitions */
#include "GPIO.h"
#include "derivative.h"
#include "FslTypes.h"
/*****************************************************************************************************
* Declaration of project wide TYPES
/*****************************************************************************************************/

/*****************************************************************************************************
* Definition of project wide VARIABLES
/*****************************************************************************************************/
extern UINT8  gu8KBIStatusFlag;
extern UINT32 gu32Keys;

/*****************************************************************************************************
* Definition of project wide MACROS / #DEFINE-CONSTANTS 
/*****************************************************************************************************/

/*--------------------------------KBI initialization-------------------------------------------------*/
#define KBI4_EN					PTBPF1_B6 = 0b01
#define KBI5_EN					PTBPF1_B7 = 0b01

#define KBI4_FALLING_EDGE 		KBI1ES_KBEDG4=0
#define KBI5_FALLING_EDGE 		KBI1ES_KBEDG5=0

#define KBI4_PULLUP_ENABLE 		PTBPE_PTBPE6=1
#define KBI5_PULLUP_ENABLE 		PTBPE_PTBPE7=1

#define KBI4_IE  				KBI1PE_KBIPE4 = 1  
#define KBI5_IE  				KBI1PE_KBIPE5 = 1 
/*---------------------------------------------------------------------------------------------------*/


/*--------------------------------KBI detection------------------------------------------------------*/
#define KBI4_MASK				PTBD_PTBD6_MASK
#define KBI5_MASK				PTBD_PTBD7_MASK

#define KBI_PORT 				PTBD
 
#define KBI4_EVENT				!(gu32Keys & KBI4_MASK)
#define KBI4_CLEAR				gu32Keys = 0xFF

#define KBI5_EVENT				!(gu32Keys & KBI5_MASK)
#define KBI5_CLEAR				gu32Keys = 0xFF
/*---------------------------------------------------------------------------------------------------*/


/*--------------------------------KBI interrupt event------------------------------------------------*/
#define KBI_VARIABLE			gu8KBIStatusFlag

#define KBI_EVENT				EVENT(gu8KBIStatusFlag, 0)		
#define KEY						COMPARE(gu8KBIStatusFlag, 0)					
#define KEY_CLEAR				CLEAR(gu8KBIStatusFlag, 0)	

#define FALSE_KEY_EVENT			EVENT(gu8KBIStatusFlag,1)
#define FALSE_KEY				COMPARE(gu8KBIStatusFlag, 1)
#define FALSE_KEY_CLEAR			CLEAR(gu8KBIStatusFlag, 1)

/*---------------------------------------------------------------------------------------------------*/

	


/*****************************************************************************************************
* Declaration of project wide FUNCTIONS
/*****************************************************************************************************/

void vfnKBI_Init (void);

/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
/*****************************************************************************************************/

#endif /* __APP_IRTC_H */