/****************************************************************************************************/
/**
\file         MTIM.c
\author     Alejandra Guzmn Castellanos
\author     Freescale Semiconductor
\author     Technical Information Center (TIC)
\version    1.0
\date			August 2009      
*/
/****************************************************************************************************/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.  	*/
/* CUSTOMER retains the final decision relative to the total design and functionality of the end 	*/
/* product.                                                                                      	*/
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/


/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "MTIM.h"

/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide MACROs / #DEFINE-CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Declaration of module wide TYPEs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide VARIABLEs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide (CONST-) CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Code of project wide FUNCTIONS
*****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief 	Initializes the MTIM16 peripheral    
* \param    UINT8  
* \return   void
* \todo     
*/
void vfnMTIM_Init (void)
{
	/**CLKS:00 Bus clock;
	PS:1000 Clock source  256 */
	MTIM3CLK = MTIM3CLK_PS3_MASK;
	
	/**TOF:0 clear flag  TOIE:0 interrupt disable TRST:1 Counter reset TSTP:1 Counter stop */
	MTIM3SC =  MTIM3SC_TRST_MASK + MTIM3SC_TSTP_MASK;
}
/****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief	Initializes the MTIM module, enables the count, waits until x delay, clears the MTIM flag
			and stops the counting. 	    
* \param    UINT16 u16Delay --> number of counts needed for certain delay 
* \return   void
* \todo     
*/
/****************************************************************************************************/
void vfnMTIM_Delay (UINT16 u16Delay)
{
  UINT8 u8DummyRead;

	/**Delay =  (Preescaler * MOD ) / Clock )
	   Delay =  (256 * u16Delay) / 20MHz      */
   MTIM3MOD = u16Delay;

	/**Start counting*/
	MTIM3SC_TSTP = 0;

    /** Wait until the delay has pass */
    while (!MTIM3SC_TOF)
    {
      __RESET_WATCHDOG();
    }

	/** Clear TOF flag */
	u8DummyRead = MTIM3SC;
	MTIM3SC_TOF = 0;

	/* Stop MTIM*/
	MTIM3SC_TSTP = 1;
}
/****************************************************************************************************/

