/****************************************************************************************************/
/**
\file       Keys.h
\brief      
\author     Alejandra Guzmn Castellanos
\author     Freescale Semiconductor
\author     Technical Information Center (TIC)
\version    1.0
\date		August 2009      
*/
/****************************************************************************************************/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.		*/
/* CUSTOMER retains the final decision relative to the total design and functionality of the end    */
/* product.                                                                                         */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/

/*****************************************************************************************************
* Module definition against multiple inclusion
*****************************************************************************************************/
#ifndef __APP_Keys_H
#define __APP_Keys_H

/*****************************************************************************************************
* Include files
*****************************************************************************************************/

/** Variable types and common definitions */
#include "Menu.h"
#include "MTIM.h"
#include "KBI.h"

#include "FslTypes.h"
#include "derivative.h"

/*****************************************************************************************************
* Declaration of project wide TYPES
*****************************************************************************************************/
typedef enum 
{
	_False,
	_Enter,
	_Click
}Keys;

/*****************************************************************************************************
* Definition of project wide VARIABLES
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of project wide MACROS / #DEFINE-CONSTANTS 
*****************************************************************************************************/	
#define _DEBOUNCE_25ms              1700
#define _DEBOUNCE_50ms              3906
#define _DEBOUNCE_75ms              5860
#define _DEBOUNCE_100ms             6800
#define _DEBOUNCE_150ms             10300
#define _DEBOUNCE_200ms             13350
#define _DEBOUNCE_250ms             16400
#define _DEBOUNCE_500ms             38800


#define ClickEvent 	KBI5_EVENT
#define ClearClick	KBI5_CLEAR

#define EnterEvent 	KBI4_EVENT
#define ClearEnter	KBI4_CLEAR

/*****************************************************************************************************
* Declaration of project wide FUNCTIONS
*****************************************************************************************************/
UINT8 u8fnGetKey (void);

/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

#endif /* __APP_Keys_H */