/****************************************************************************************************/
/**
\file       Menu.c
\author     Alejandra Guzmn Castellanos
\author     Freescale Semiconductor
\author     Technical Information Center (TIC)
\version    1.0
\date			August 2009      
*/
/****************************************************************************************************/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.  	*/
/* CUSTOMER retains the final decision relative to the total design and functionality of the end 	*/
/* product.                                                                                      	*/
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/

/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "Menu.h"

/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

/** Time and Alarm Menu Configurations*/
UINT8 u8Error (void);
UINT8 u8Year (void);
UINT8 u8Month (void);
UINT8 u8Day (void);
UINT8 u8Hour (void);
UINT8 u8Minute (void);
UINT8 u8CountDown (void);
UINT8 u8Exit (void);

/** Daylight Configurations*/
UINT8 u8DEndMonth (void);
UINT8 u8DEndDay (void);
UINT8 u8DEndHour (void);

/** Main menu functions */
void vfnCountDown (void);
void vfnTime (void);
void vfnDaylight (void);

/** Reads current values at the Robust Real Time Clock */
void vfnGetIRTCValues (void);
/*****************************************************************************************************
* Definition of module wide MACROs / #DEFINE-CONSTANTs - NOT for use in other modules
*****************************************************************************************************/
#define _Enter		1
/*****************************************************************************************************
* Declaration of module wide TYPEs - NOT for use in other modules
*****************************************************************************************************/
typedef enum
 {
 	_MainMenu,
	_ExitMenu,
	_two,
	_three,
	_four,
	_five,
	_CountDown,
	_Exit
 }Flag_status;
/*****************************************************************************************************
* Definition of module wide VARIABLEs - NOT for use in other modules
*****************************************************************************************************/
/** Structure that stores values to be configurated at the IRTC registers*/
ClockStatus  IRTCStatus;

UINT8	gu8MenuStatusFlag;

volatile UINT32 gu32EnterCounter = _MainMenu;
UINT32 gu32Menu = _MainMenu;

 /**Main Menu displays */
UINT8 au8Time [ ] = { " Time "};
UINT8 au8Alarm [ ] = { " Alarm "};
UINT8 au8Daylight [ ] = { "Daylight"};
UINT8 au8Countdown [ ] = { "CountDown"};


UINT8 *apu8Messagess [ ] =
{
	&au8Countdown[0],
	&au8Time[0],
	&au8Alarm[0],
	&au8Daylight[0],
};

/** Menu Configuration displays */
UINT8	au8Error [ ] = {"Error "};
UINT8 au8Year [ ] = {"Year 20"};
UINT8 au8Month[ ] = {"Month"};
UINT8 au8Day[ ] = {"Day "};
UINT8 au8Hour[ ] = {"Hour "};
UINT8 au8Minute[ ] = {"Minute "};
UINT8 au8Exit[ ] = {"Exit "};
UINT8 au8CountDown[ ] = {"CDown "};


UINT8 *apu8Text [ ] =
{
	&au8Error[0],		
	&au8Year[0],
	&au8Month[0],
	&au8Day[0],
	&au8Hour[0],
	&au8Minute[0],
	&au8Exit[0]
};

UINT8 *apu8Text2 [ ] =
{
	&au8Error[0],		
	&au8Month[0],
	&au8Day[0],
	&au8Hour[0],
	&au8Month[0],
	&au8Day[0],
	&au8Hour[0]
};

/*****************************************************************************************************
* Definition of module wide (CONST-) CONSTANTs - NOT for use in other modules
*****************************************************************************************************/
const UINT8 DaysPerMonth[13] = {0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

/** 													Function pointer arrays 																				*/
/*****************************************************************************************************/
/** Main Menu array*/
void (*const MainMenuStates[ ])(void) =
{
	vfnCountDown,
	vfnTime,
	vfnTime,
	vfnDaylight
};

/** Time and Alarm Configuration array*/
UINT8 (*const MenuStates[ ])(void) = 
{
	u8Error,
	u8Year,
	u8Month,
	u8Day,
	u8Hour,
	u8Minute,
	u8Exit
};

/** Daylight Saiving Configuration array */
UINT8 (*const MenuStates2[ ])(void) = 
{
	u8Error,
	u8Month,
	u8Day,
	u8Hour,
	u8DEndMonth,
	u8DEndDay,
	u8DEndHour
};
/** 													Function pointer arrays 																				*/
/*****************************************************************************************************/


/*****************************************************************************************************
* Code of project wide FUNCTIONS
*****************************************************************************************************/


/****************************************************************************************************/
/**
* \brief	After receiving a keyboard event, this function determines how to respond with the key 
			previously detected. If no Enter event has been detected, the function displays the main menu messages. 
			Once a main menu has been selected, the function runs a secondary state machine that manages the menu. 
* \param   UINT8 u8KeyPress -- Keyboard pressed   
* \return  void
*/
void vfnClockMenu (UINT8 u8KeyPress)
{
   vfnClearAlphanumeric ();

	if (u8KeyPress == _Enter)
	{
			gu32EnterCounter = gu32EnterCounter + 1;
			gu32EnterCounter &= 0x07;
	}
	else
	{
		if (!gu32EnterCounter)
		{
			gu32Menu ++;
		    gu32Menu &= 0x03;
			vfnLCD_Write_Msg ((UINT8 _POINTER)(apu8Messagess[gu32Menu]));
			vfnGetIRTCValues();
		} 
	}

	/**One option from the main menu has been selected*/
	if (gu32EnterCounter )			 
	{
		if (gu32EnterCounter == _Exit)
		{
			END_MENU_EVENT;
			gu32EnterCounter = _MainMenu;
		}
		else
		{
			MainMenuStates[gu32Menu]();
		}
 	}
}
/****************************************************************************************************/
void vfnCountDown (void)
{
  UINT8 u8Temp;

	if (gu32EnterCounter == 1)
	{
		u8Temp = u8CountDown();
		vfnLCD_Write_Msg ((UINT8 _POINTER)(&au8CountDown[0]));
		vfnLCD_WriteDecimal(u8Temp, 8);
	}

	if (gu32EnterCounter==2)
	{
		gu32EnterCounter = _CountDown;
		vfnLCD_Write_Msg ((UINT8 _POINTER)(apu8Text[gu32EnterCounter]));
	}

}

void vfnTime (void)
{
  UINT8 u8Temp;

	u8Temp = MenuStates[gu32EnterCounter]();
	vfnLCD_Write_Msg ((UINT8 _POINTER)(apu8Text[gu32EnterCounter]));
	vfnLCD_WriteDecimal(u8Temp, 8);
}

void vfnDaylight (void)
{
	UINT8 u8Temp;
	vfnLCD_Write_Msg ((UINT8 _POINTER)(apu8Text[gu32EnterCounter]));
	u8Temp = MenuStates2[gu32EnterCounter]();
	vfnLCD_WriteDecimal(u8Temp, 8);
}


/****************************************************************************************************/
UINT8 u8Year (void)
{
	IRTCStatus.u16Years ++;
	return ((UINT8)(IRTCStatus.u16Years - 2000));   
}
/****************************************************************************************************/


/****************************************************************************************************/
UINT8 u8Month (void)
{
	if (IRTCStatus.u8Months < _DECEMBER)
	{
		IRTCStatus.u8Months ++;	
	}	
	else
	{
		IRTCStatus.u8Months = _JANUARY;	
	}
	return (IRTCStatus.u8Months);
}
/****************************************************************************************************/

/****************************************************************************************************/
UINT8 u8Day (void)
{
	if (IRTCStatus.u8Days < DaysPerMonth[IRTCStatus.u8Months] )
	{
		IRTCStatus.u8Days++;	
	}	
	else
	{
		IRTCStatus.u8Days = 1;
	}
	return (IRTCStatus.u8Days);
}
/****************************************************************************************************/

/****************************************************************************************************/
UINT8 u8Hour (void)
{
	if (IRTCStatus.u8Hours < 24)
	{
		IRTCStatus.u8Hours++;	
	}	
	else
	{
		IRTCStatus.u8Hours = 1;
	}
	return (IRTCStatus.u8Hours);
}

/****************************************************************************************************/
UINT8 u8Minute (void)
{
	if (IRTCStatus.u8Minutes < 60)
	{
		IRTCStatus.u8Minutes++;	
	}	
	else
	{
		IRTCStatus.u8Minutes = 1;
	}
	return (IRTCStatus.u8Minutes);
}
/****************************************************************************************************/

/****************************************************************************************************/
UINT8 u8Error (void)
{  
	return 0;
}
/****************************************************************************************************/

/****************************************************************************************************/
UINT8 u8CountDown (void)
{  
   	if (IRTCStatus.u8CntDown < 99)
	{
		IRTCStatus.u8CntDown++;	
	}	
	else
	{
		IRTCStatus.u8CntDown = 1;
	}
  	return(	IRTCStatus.u8CntDown);
}
/****************************************************************************************************/

/****************************************************************************************************/
UINT8 u8Exit (void)
{  
   return   0;
}
/****************************************************************************************************/

/****************************************************************************************************/
UINT8 u8DEndMonth (void)
{
	if (IRTCStatus.u8DEndMonths < _DECEMBER)
	{
		IRTCStatus.u8DEndMonths ++;	
	}	
	else
	{
		IRTCStatus.u8DEndMonths = _JANUARY;	
	}
	return (IRTCStatus.u8DEndMonths);
}
/****************************************************************************************************/

/****************************************************************************************************/
UINT8 u8DEndDay (void)
{
	if (IRTCStatus.u8DEndDays < 31)
	{
		IRTCStatus.u8DEndDays++;	
	}	
	else
	{
		IRTCStatus.u8DEndDays = 1;
	}
	return (IRTCStatus.u8DEndDays);
}
/****************************************************************************************************/

/****************************************************************************************************/
UINT8 u8DEndHour (void)
{
	if (IRTCStatus.u8DEndHours < 24)
	{
		IRTCStatus.u8DEndHours++;	
	}	
	else
	{
		IRTCStatus.u8DEndHours = 1;
	}
	return (IRTCStatus.u8DEndHours);
}

/****************************************************************************************************/



/****************************************************************************************************/
void vfnGetIRTCValues ( )
{
	IRTCStatus.u16Years =u16IRTC_Time_GetYear();
	IRTCStatus.u16Years --;

	IRTCStatus.u8Months = u8IRTC_Time_GetMonth();
	IRTCStatus.u8Months --;

	IRTCStatus.u8Days = u8IRTC_Time_GetDay();
	IRTCStatus.u8Days --;

	IRTCStatus.u8Hours =  u8IRTC_Time_GetHour();
	IRTCStatus.u8Hours --;

	IRTCStatus.u8Minutes = u8IRTC_Time_GetMinute();
	IRTCStatus.u8Minutes --;

	IRTCStatus.u8CntDown	= u8IRTC_GetCountDown();

	IRTCStatus.u8Months = IRTCStatus.u8Months; 
	IRTCStatus.u8DEndDays = IRTCStatus.u8Days;
	IRTCStatus.u8DEndHours = IRTCStatus.u8Hours;
}






