/***********************************************************************************************\
* Freescale MMA8451Q Driver
*
* Filename: spi.c
*
*
* (c) Copyright 2010, Freescale, Inc.  All rights reserved.
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
\***********************************************************************************************/

#include "system.h"

/***********************************************************************************************\
* Private macros
\***********************************************************************************************/

/***********************************************************************************************\
* Private type definitions
\***********************************************************************************************/

/***********************************************************************************************\
* Private prototypes
\***********************************************************************************************/

/***********************************************************************************************\
* Private memory declarations
\***********************************************************************************************/

/***********************************************************************************************\
* Public memory declarations
\***********************************************************************************************/

/***********************************************************************************************\
* Public functions
\***********************************************************************************************/

/*********************************************************\
* SPI Write One Byte
\*********************************************************/
void SPI_ChrShift(byte data)
{
  byte i;
  while (!SPIS_SPTEF);
  SPID = data;
  while (!SPIS_SPRF);
  i = SPID;
}


/*********************************************************\
* SPI Read One Byte
\*********************************************************/
byte SPI_ChrShiftR(byte data)
{
  while (!SPIS_SPTEF);
  SPID = data;
  while (!SPIS_SPRF);
  return SPID;
}


/*********************************************************\
* SPI Write 5 Bytes
\*********************************************************/
void SPI_ChrShift5(byte data1, byte data2, byte data3, byte data4, byte data5)
{
  SPI_ChrShift(data1);
  SPI_ChrShift(data2);
  SPI_ChrShift(data3);
  SPI_ChrShift(data4);
  SPI_ChrShift(data5);
}


/*********************************************************\
* SPI Write 4 Bytes
\*********************************************************/
void SPI_FullShift4(byte data1, byte data2, byte data3, byte data4)
{
  SPI_SS_SELECT;
  SPI_ChrShift(data1);
  SPI_ChrShift(data2);
  SPI_ChrShift(data3);
  SPI_ChrShift(data4);
  SPI_SS_DESELECT;
}


/***********************************************************************************************\
* Private functions
\***********************************************************************************************/

