#include "SPI.h"

/************************************************/
void SPI_Init(void)
{
  SPI_SS = 1;
  _SPI_SS= 1;
  
  //SPI1BR = 0x24; // 375 Khz  
  SPI1BR = 0x14; // 375 Khz with 24 MHz busclock     		
  SPI1C2 = 0x00;     
  SPI1C1 = SPI1C1_SPE_MASK | SPI1C1_MSTR_MASK;
}

/************************************************/
void SPI_Send_byte(UINT8 u8Data)
{
	(void)SPI1S;
	SPI1D=u8Data;
	while(!SPI1S_SPTEF){};
}

/************************************************/
UINT8 SPI_Receive_byte(void)
{
	(void)SPI1D;
	SPI1D=0xFF;
	while(!SPI1S_SPRF){};	
	return(SPI1D);
}

/************************************************/
void SPI_High_rate(void)
{
  SPI1C1 = 0x00;
  //SPI2BR = 0x11; // 375 Khz
  SPI1BR = 0x14; // 375 Khz for 24 Mhz clock      		
  SPI1C1 = SPI1C1_SPE_MASK | SPI1C1_MSTR_MASK;
}
