/*
 * File:		XTWR-MCF51MM.h
 * Purpose:	MM tower board definitions and memory map information if used
 *
 * Notes:
 */

#ifndef _MCF51MM256XTWR
#define _MCF51MM256XTWR 

/********************************************************************/
#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "FslTypes.h"

/********************************************************************/

#define	BUS_CLOCK		  24000000UL             /* bus frequency in Hz */

#define SW1      PTDD_PTDD1
#define SW2      PTCD_PTCD6
#define SW3_1_4  PTAD_PTAD5
#define SW3_2_3  PTBD_PTBD1
#define SW4      PTED_PTED4

#define SW1_DD      PTDDD_PTDDD1
#define SW2_DD      PTCDD_PTCDD6
#define SW3_1_4_DD  PTADD_PTADD5
#define SW3_2_3_DD  PTBDD_PTBDD1
//#define SW4_DD      PTEDD_PTEDD4  //It is an input only pin

#define SW1_PE      PTDPE_PTDPE1
#define SW2_PE      PTCPE_PTCPE6
#define SW3_1_4_PE  PTAPE_PTAPE5
#define SW3_2_3_PE  PTBPE_PTBPE1
#define SW4_PE      PTEPE_PTEPE4


#define SW1_ON()      !SW1
#define SW2_ON()      !SW2
#define SW3_1_4_ON()  !SW3_1_4
#define SW4_ON()      !SW4

#define SW1_OFF()     SW1
#define SW2_OFF()     SW2
#define SW3_2_3_OFF() SW3_2_3
#define SW4_OFF()     SW4

#define LED1 PTFD_PTFD2
#define LED2 PTFD_PTFD1
#define LED3 PTFD_PTFD0
#define LED4 PTED_PTED7

#define LED1_DD PTFDD_PTFDD2
#define LED2_DD PTFDD_PTFDD1
#define LED3_DD PTFDD_PTFDD0
#define LED4_DD PTEDD_PTEDD7

#define LED1_PE PTFPE_PTFPE2
#define LED2_PE PTFPE_PTFPE1
#define LED3_PE PTFPE_PTFPE0
#define LED4_PE PTEPE_PTEPE7

#define LED1_ON()  LED1 = 1
#define LED1_OFF() LED1 = 0
#define LED2_ON()  LED2 = 1
#define LED2_OFF() LED2 = 0
#define LED3_ON()  LED3 = 1
#define LED3_OFF() LED3 = 0
#define LED4_ON()  LED4 = 1
#define LED4_OFF() LED4 = 0
                          
#define LED1_TOGGLE()  LED1 = !LED1;
#define LED2_TOGGLE()  LED2 = !LED2;
#define LED3_TOGGLE()  LED3 = !LED3;
#define LED4_TOGGLE()  LED4 = !LED4;

/********************************************************************/

#endif 
