/* +FHDR-----------------------------------------------------------------------
* Copyright (c) 2011, Freescale Semiconductor, Inc.
* ----------------------------------------------------------------------------
* FILE NAME : Gestures.h
* AUTHOR    : Freescale Semiconductor, Inc.
* ----------------------------------------------------------------------------
* RELEASE HISTORY
* VERSION DATE AUTHOR DESCRIPTION
* (1.0) 11/01/2011   B32599 (Initial Template)
* ----------------------------------------------------------------------------
* KEYWORDS : Xtrinsic
* ----------------------------------------------------------------------------
* PURPOSE:
* ----------------------------------------------------------------------------
* REUSE ISSUES
*
* -FHDR-----------------------------------------------------------------------
*/

#ifndef GESTURES_H_
#define GESTURES_H_


/******************************************************************************
*******************************************************************************
*                             HIGH G/LOW G APPLICATION                        *
*******************************************************************************
*******************************************************************************/


/******************************************************************************
* Public Macros
*******************************************************************************/

#define LG_SELCT			0			/* index of LG configuration */
#define HG_SELCT			1			/* index of HG configuration */
#define NUMS_OF_LHG			2			/* number of LG/HG */

/******************************************************************************
* Public type definitions
*******************************************************************************/

/* ----------------------------------------------------------------------------
 * HIGH G/LOW G parameter structure
 * ----------------------------------------------------------------------------*/
typedef struct lhg_events_bits_tag
{
    uint8_t lgx_enable      :1;
    uint8_t lgy_enable      :1;
    uint8_t lgz_enable      :1;
    uint8_t lgAndOr_enable  :1;
    uint8_t DBCNT	        :1;
    uint8_t Rsvd	        :3;
}lhg_cfg_bits_t;

typedef union lhg_event_mask_tag
{
	uint8_t Byte;
	lhg_cfg_bits_t bits;
}lhg_cfg_t;

typedef struct lhg_app_tag
{
    uint16_t 	lhg_thresh;
    uint8_t  	lhg_cnt_min;
    lhg_cfg_t  	lhg_cfg;
}lhg_app_t;

typedef union lhg_fifo_mask
{
	uint8_t Byte;
	struct{
		uint8_t	Rsvd1: 3;
		uint8_t	FIFOLGE: 1;
		uint8_t	Rsvd2: 3;
		uint8_t	FIFOHGE: 1;
	}bits;
}lhg_fifo_t;

typedef struct lhg_param_tag
{
    lhg_app_t 	lhg_app[NUMS_OF_LHG];
    uint8_t   	low_high_g_K_LP;
    lhg_fifo_t	lhg_fifo_mask;
}lhg_param_t;


/* ----------------------------------------------------------------------------
 * HIGH G/LOW G output structure
 * ----------------------------------------------------------------------------*/

typedef union
{
    uint8_t Byte;
    struct{
    	uint8_t LGX  :1;
        uint8_t LGY  :1;
        uint8_t LGZ  :1;
        uint8_t LGE  :1;
        uint8_t HGX  :1;
        uint8_t HGY  :1;
        uint8_t HGZ  :1;
        uint8_t HGE  :1;
    }bits;
}lhg_outs_t;


/* ----------------------------------------------------------------------------
 * HIGH G/LOW G structure
 * ----------------------------------------------------------------------------*/

typedef struct lhg_struct_tag
{
	lhg_outs_t outs;
	lhg_param_t param;
}lhg_struct_t;



/******************************************************************************
*******************************************************************************
*                        PORTRAIT LANDSCAPE APPLICATION                       *
*******************************************************************************
*******************************************************************************/

/******************************************************************************
* Public Macros definitions
*******************************************************************************/

/******************************************************************************
* Public type definitions
*******************************************************************************/

/* ----------------------------------------------------------------------------
 * PORTRAIT LANDSCAPE parameter structure
 * ----------------------------------------------------------------------------*/

typedef union{
	uint8_t	Byte;
	struct{
		uint8_t GOFF    :3;
		uint8_t DBCNTM  :1;
		uint8_t Rsvd1   :1;
		uint8_t BKFR_EN :1;
		uint8_t PL_EN   :1;
		uint8_t PLFDE   :1;
	}bits;
}pl_cfg_t;

typedef struct pl_int_data_tag{
	uint8_t  threshold_tilt;
	uint8_t  portrait_angle;
	uint8_t  landscape_angle;
	uint8_t  debounce_count;
	uint8_t  hysteresis_LO;
	uint8_t  hysteresis_BAFRO;
	pl_cfg_t cfg;
}pl_param_t;


/* ----------------------------------------------------------------------------
 * PORTRAIT LANDSCAPE output structure
 * ----------------------------------------------------------------------------*/

typedef union{
	uint8_t	Byte;
	struct{
		uint8_t BAFRO     :2;
		uint8_t LAPO      :3;
		uint8_t Rsvd1     :1;
		uint8_t Lock  	:1;
		uint8_t Evnt 		:1;
	}bits;
}pl_outs_t;


/* ----------------------------------------------------------------------------
 * PORTRAIT LANDSCAPE structure
 * ----------------------------------------------------------------------------*/

typedef struct pl_struct_tag{
	pl_outs_t outs;
	pl_param_t param;
}pl_struct_t;



/******************************************************************************
*******************************************************************************
*                         TAP DTAP APPLICATION 			                      *
*******************************************************************************
*******************************************************************************/

/******************************************************************************
* Public macros
*******************************************************************************/

#define TAP_SELCT			0		/* index of TAP configuration */
#define DTAP_SELECT			1		/* index of DTAP configuration */
#define NUMS_OF_TAP			2		/* number of TAP */

/******************************************************************************
* Public type definitions
*******************************************************************************/

/* ----------------------------------------------------------------------------
 *  TAP DTAP parameter structure
 * ----------------------------------------------------------------------------*/

typedef union
{
	  uint8_t Byte;
	  struct{
		  uint8_t  X_enable	:1;
		  uint8_t  Y_enable	:1;
		  uint8_t  Z_enable :1;
		  uint8_t  Rsvd		:5;
	  }bits;
}tap_axls_enable_t;

typedef struct
{
	  int16_t 			tap_thresh;
	  uint8_t 			tap_on_min;
	  uint8_t 			tap_on_max;
	  uint8_t 			tap_tap_min_time;
	  uint8_t 			tap_K_HP;
	  uint8_t 			tap_K_LP;
	  tap_axls_enable_t tap_axis_enable;
	  uint8_t 			tap_events_mask;
}tap_dt_param_t;


/* ----------------------------------------------------------------------------
 *  TAP DTAP output structure
 * ----------------------------------------------------------------------------*/

typedef union{
	uint8_t Byte;
	struct {
		uint8_t	XEv		:1;
		uint8_t	XDir	:1;
		uint8_t	YEv		:1;
		uint8_t	YDir	:1;
		uint8_t	ZEv		:1;
		uint8_t	ZDir	:1;
		uint8_t	Rsvd	:1;
		uint8_t	TAP		:1;
	 }bits;
}TAP_DT_out_t;

typedef struct tap_dt_out_data_tag
{
	TAP_DT_out_t  	TAP_DT_out[NUMS_OF_TAP];
}tap_dt_outs_t;

/* ----------------------------------------------------------------------------
 *  TAP DTAP structure
 * ----------------------------------------------------------------------------*/

typedef struct tap_struct_tag
{
	tap_dt_outs_t outs;
	tap_dt_param_t param;
}tap_struct_t;



/******************************************************************************
*******************************************************************************
*                         TILT APPLICATION	 			                      *
*******************************************************************************
*******************************************************************************/

/******************************************************************************
* Public macros
*******************************************************************************/

#define XZ_PLANE		0		/* index of XZ PLANE configuration */
#define YZ_PLANE		1		/* index of YZ PLANE configuration */
#define XY_PLANE		2		/* index of XY PLANE configuration */
#define NUM_OF_PLANES	3		/* number of PLANES */

/******************************************************************************
* Public type definitions
*******************************************************************************/

/* ----------------------------------------------------------------------------
 *  TILT parameter structure
 * ----------------------------------------------------------------------------*/

typedef union {
	uint8_t Byte;
	struct{
		uint8_t AngThreshold    :4;
		uint8_t XZEn            :1;
		uint8_t YZEn            :1;
		uint8_t XYEn            :1;
		uint8_t Rsvd            :1;
	}bits;
}tilt_cfg1_t;

typedef union {
  uint8_t Byte;
  struct {
	  uint8_t Rsvd: 7;
	  uint8_t change_quad_evnt:1;
  }bits;
}tilt_evnts_mask_t;

typedef struct tilt_int_data_tag
{
    uint8_t  	tilt_K_LP;
    tilt_cfg1_t tilt_cfg1;
    tilt_evnts_mask_t tilt_events_mask;
}tilt_param_t;


/* ----------------------------------------------------------------------------
 *  TILT output structure
 * ----------------------------------------------------------------------------*/

typedef union{
	uint8_t	Byte;
	struct{
		uint8_t	ANGLE	:7;
		uint8_t   ANGFLG	:1;
	}bits;
}tilt_ang_t;

typedef union tilt_quad_tag
{
	uint8_t Byte;
	struct{
		uint8_t	xy_quad :2;
		uint8_t	yz_quad :2;
		uint8_t	xz_quad :2;
		uint8_t	Rsvd  	:1;
		uint8_t	quadflag:1;
	}bits;
}tilt_quad_t;

typedef struct tilt_out_data_tag
{
    tilt_ang_t tilt_ang[NUM_OF_PLANES];
    tilt_quad_t tilt_xz_yz_quad;
}tilt_outs_t;


/* ----------------------------------------------------------------------------
 *  TILT output structure
 * ----------------------------------------------------------------------------*/

typedef struct tilt_struct_tag
{
  tilt_outs_t outs;
  tilt_param_t param;
}tilt_struct_t;


#endif /* GESTURES_H_ */
