/* +FHDR-----------------------------------------------------------------------
* Copyright (c) 2011, Freescale Semiconductor, Inc.
* * ----------------------------------------------------------------------------
* FILE NAME : customer_apps_binding.h
* AUTHOR    : Freescale Semiconductor, Inc. 
* ----------------------------------------------------------------------------
* RELEASE HISTORY
* VERSION DATE AUTHOR DESCRIPTION
* (1.0) 11/01/2011   B32599 (Initial Template)
* ----------------------------------------------------------------------------
* KEYWORDS : Xtrinsic
* ----------------------------------------------------------------------------
* PURPOSE: 
* ----------------------------------------------------------------------------
* REUSE ISSUES
*  
* -FHDR-----------------------------------------------------------------------
*/

#ifndef CUSTOM_APP_BIND_H_
#define CUSTOM_APP_BIND_H_

#include "frontend.h"


/******************************************************************************
*******************************************************************************
*                             Custom Application Binding                      *
*******************************************************************************
*******************************************************************************/


/******************************************************************************
* Public Macros
*******************************************************************************/

#define MAX_TABLES       			(4U)
#define TABLE_IDENTIFIER 			(0x9550C0DE)


/******************************************************************************
*******************************************************************************
* Public type definitions
*******************************************************************************
*******************************************************************************/

typedef void (*cbFunction) (void);


typedef struct Data_APMap_tag
{
  void (*initCbFn)(void);   /* init  callback function pointer */
  void (*rstCbFn)(void);    /* reset callback function pointer */
  void (*clrCbFn)(void);    /* clear callback function pointer */
  void (*function)(void);   /* function pointer */
  uint8_t  AP_ID;
  uint8_t  parameter_bytes;
  uint8_t  output_bytes;
}Data_APMap_t;


typedef struct app_table_tag {
    uint32_t       table_identifier; /* magic code to identify an app_table */
    uint32_t       num_of_apps;      /* number of entries in apmap */ 
    Data_APMap_t apmap[];          /* apmap table */
} app_table_t;


/******************************************************************************
*******************************************************************************
* Freescale API definitions
*******************************************************************************
*******************************************************************************/

typedef enum fsl_api_indx_tag {
  FSL_API_FN_EVNT_Q            = 0,
  FSL_API_FN_REG_USER_INT      = 1,
  FSL_API_FN_REQ_DATA_RAM      = 2,
  FSL_API_FN_GET_APMAP_PTR     = 3,
  FSL_API_FN_APP_OUT_ADDR      = 4,
  FSL_API_FN_APP_PARAM_ADDR    = 5,
  FSL_API_FN_IIR_FILTER        = 6,
  FSL_API_FN_GET_DATA_PTR      = 7,
  FSL_API_CONFIG_CUTOFF_FILTER = 8,      
  MAX_FSL_FN_API
}fsl_api_indx_tag;


/******************************************************************************
*******************************************************************************
* Freescale type definitions
*******************************************************************************
*******************************************************************************/

#define FSL_API_TABLE_LOOKUP_TRAP 	(7U)

inline asm __declspec(register_abi) void * fsl_api_table_lookup(uint32_t index) {
    trap #FSL_API_TABLE_LOOKUP_TRAP;
}

typedef const Data_APMap_t *(get_apmap_ptr_t)(uint8_t apid);
typedef uint8_t *(request_ram_ptr_t)(uint16_t sz, uint8_t u8AppId);
typedef void *(get_data_ptr_t)(uint8_t u8AppId);
typedef void (event_fifo_push_ptr_t)(void *data, uint8 size);
typedef void *(app_out_addr_ptr_t)(uint8_t appId, uint8_t *output_bytes);
typedef void *(app_param_addr_ptr_t)(uint8_t appId, uint8_t *parameter_bytes);
typedef int16_t (iir_ptr_t)(int16 input, const coef_t *coef, void *buffer);
typedef int16_t (config_cutoff_filter_ptr_t)(int16_t input, uint32_t k, void *buffer, filter_type_t filter_type);

#endif /*CUSTOM_APP_BIND_H_*/
