/* +FHDR-----------------------------------------------------------------------
* Copyright (c) 2011, Freescale Semiconductor, Inc.
* ----------------------------------------------------------------------------
* FILE NAME : frontend.h
* AUTHOR    : Freescale Semiconductor, Inc.
* ----------------------------------------------------------------------------
* RELEASE HISTORY
* VERSION DATE AUTHOR DESCRIPTION
* (1.0) 11/01/2011   B32599 (Initial Template)
* ----------------------------------------------------------------------------
* KEYWORDS : Xtrinsic
* ----------------------------------------------------------------------------
* PURPOSE:
* ----------------------------------------------------------------------------
* REUSE ISSUES
*
* -FHDR-----------------------------------------------------------------------
*/

#ifndef FRONTEND_H_
#define FRONTEND_H_


/******************************************************************************
*******************************************************************************
*                             FRONTEND				                          *
*******************************************************************************
*******************************************************************************/


/******************************************************************************
* Public Macros
*******************************************************************************/

/* [FRONTEND_OUTPUTS] options*/
#define AFE_STAGE_0				0 	/* index of stage 0 anti-aliased output*/
#define AFE_STAGE_1				1	/* index of stage 1 anti-aliased output*/
#define AFE_STAGE_0_ABS			2	/* index of stage 0 absolute value output*/
#define AFE_STAGE_0_GM			3	/* index of stage 0 g-mode dependent resolution output*/
#define AFE_STAGE_0_LPF			4	/* index of stage 0 configurable lowpass filter output*/
#define AFE_STAGE_0_HPF			5	/* index of stage 0 configurable highpass filter output*/
#define FRONTEND_OUTPUTS		6   /* number of outputs */

/* [FRONTEND_AXES] options*/
#define FRONTEND_X              0 	/* index to x axis */
#define FRONTEND_Y              1 	/* index to y axis */
#define FRONTEND_Z              2 	/* index to z axis */
#define FRONTEND_AXES           3 	/* number of axes */

/*  AFE_CSRSTR options*/
#define FS_2g					1	/* index to 2g Full scale */
#define FS_4g					2	/* index to 4g Full scale */
#define FS_8g					3	/* index to 8g Full scale */

#define CM_16bit				0	/* index to 16 bit conversion */
#define CM_14bit				1	/* index to 14 bit conversion */
#define CM_12bit				2	/* index to 12 bit conversion */
#define CM_10bit				3	/* index to 10 bit conversion */

#define ExtADC					1	/* index to use external signal to ADC conversion */
#define NExtADC					0	/* index to not use external signal to ADC conversion */

#define Temp					1	/* index to use temperature conversion */
#define NTemp					0	/* index to not use temperature conversion */

// [FRONTEND_CONFIG_FILTERS_PARAMS] options
#define FRONTEND_CONFIG_HPF        		0 	/* index to highpass filter in array of configurable filters */
#define FRONTEND_CONFIG_LPF        		1 	/* index to lowpass filter in array of configurable filters */
#define FRONTEND_CONFIG_TEMP_LPF   		2 	/* index of lowpass filter for temp output in array of configurable filters*/
#define FRONTEND_CONFIG_EIC_LPF    		3 	/* index of lowpass filter for external input conversion in array of configurable filters*/
#define FRONTEND_CONFIG_FILTERS_PARAMS  4  	/* number of configurable filters of parameter structure*/



/******************************************************************************
* Public type definitions
*******************************************************************************/

/* ----------------------------------------------------------------------------
 * FRONTEND parameter structure
 * ----------------------------------------------------------------------------*/

/*** AFE_CSR - AFE Control & Status Register; 0xFFFFEC40 ***/
typedef union {
  uint16_t Word;
  struct {
    uint8_t Rsvd1:2;              /* Reserved */
    uint8_t CM: 2;				/* Conversion mode */
    uint8_t TEMP: 1;				/* Temperature as input */
    uint8_t EXTADC: 1;			/* External ADC as input */
    uint8_t FS: 2;				/* Full scale selection */
    uint8_t Rsvd2;				/* Reserved */
  }Bits;
} AFE_CSRSTR;

typedef struct frontend_struct_tag {
    struct{
      int16_t accel_output[FRONTEND_OUTPUTS][FRONTEND_AXES];
      int16_t temp_output;
      int16_t eic_output;
      uint16_t frame_counter;
    } outs;
    struct {
    	AFE_CSRSTR 	afe_csr;
        uint16_t  user_offset[FRONTEND_AXES];
        uint8_t   config_k[FRONTEND_CONFIG_FILTERS_PARAMS];
        uint8_t   sfd_rate;
    } param;
} frontend_struct_t;


/******************************************************************************
* Freescale Private Macros and Prototypes
*******************************************************************************/

// indices to filter buffer
#define FRONTEND_CONFIG_ORDER      	1 	/* order of configurable filters */
#define FRONTEND_BUFFER_OUTPUT   	0 	/* index to stored output */
#define FRONTEND_BUFFER_INPUT    	1 	/* index to stored input */
#define FRONTEND_BUFFER_SIZE     	2 	/* number of buffer elements needed for each filter delay. i.e., one element for storing previous input and one element for storing previous output */


typedef struct coef_t {
    uint16_t order;     /* only need uint8_t but make uint16_t so coef_ary is longword aligned */
    uint16_t shift;     /* only need uint8_t but make uint16_t so coef_ary is longword aligned */
/*lint -save -e43 Disable MISRA rule (43) checking. */\
    int16_t coef_ary[]; // empty array must be last struct member
/*lint -restore */
} coef_t;

typedef enum filter_type_tag {
    LOWPASS  = 0,
    HIGHPASS = -32768
    /* this is the value of the coefficient for x[n-1] */
} filter_type_t;


typedef int16_t                      config_cutoff_buffer_1axis_t[FRONTEND_CONFIG_ORDER][FRONTEND_BUFFER_SIZE];
typedef config_cutoff_buffer_1axis_t config_cutoff_buffer_3axis_t[FRONTEND_AXES];


#endif /* FRONTEND_H_ */
