/* +FHDR-----------------------------------------------------------------------
* Copyright (c) 2011, Freescale Semiconductor, Inc.
* ----------------------------------------------------------------------------
* FILE NAME : gpio.h
* AUTHOR    : Freescale Semiconductor, Inc.
* ----------------------------------------------------------------------------
* RELEASE HISTORY
* VERSION DATE AUTHOR DESCRIPTION
* (1.0) 11/01/2011   B32599 (Initial Template)
* ----------------------------------------------------------------------------
* KEYWORDS : Xtrinsic
* ----------------------------------------------------------------------------
* PURPOSE:
* ----------------------------------------------------------------------------
* REUSE ISSUES
*
* -FHDR-----------------------------------------------------------------------
*/

#ifndef GPIO_H_
#define GPIO_H_



/******************************************************************************
*******************************************************************************
*                             GPIO Deamon			                          *
*******************************************************************************
*******************************************************************************/


/******************************************************************************
* Public Macros
*******************************************************************************/

#define GPIO6			0		/* index of GPIO6 */
#define GPIO7			1		/* index of GPIO7 */
#define GPIO8			2		/* index of GPIO8 */
#define GPIO9			3		/* index of GPIO9 */
#define NUMS_OF_GPIO	4		/* number of LG/HG */

/******************************************************************************
* Public type definitions
*******************************************************************************/

/* ----------------------------------------------------------------------------
 * GPIO parameter structure
 * ----------------------------------------------------------------------------*/

typedef struct gpio_app_struct_tag
{
    uint8_t app_id;
    uint8_t sr_bitnum;
}gpio_app_struct_t;

typedef union gpio_pol_MSB_tag
{
    uint8_t Byte;
    struct{
		uint8_t GPIO8_bit	:1;
		uint8_t GPIO9_bit	:1;
		uint8_t Rsvd		:6;
	}bits;
}gpio_pol_MSB_t;

typedef union gpio_pol_LSB_tag
{
    uint8_t Byte;
    struct{
		uint8_t Rsvd		:6;
		uint8_t GPIO6_bit	:1;
		uint8_t GPIO7_bit	:1;
	}bits;
}gpio_pol_LSB_t;

typedef struct gpio_param_tag
{
	gpio_app_struct_t 	app[NUMS_OF_GPIO];
	gpio_pol_MSB_t	  	gpio_polMSB;
	gpio_pol_LSB_t		gpio_polLSB;
}gpio_param_t;



#endif /* GPIO_H_ */


