/* +FHDR-----------------------------------------------------------------------
* Copyright (c) 2011, Freescale Semiconductor, Inc.
* * ----------------------------------------------------------------------------
* FILE NAME : CustomApp1.c
* AUTHOR    : Freescale Semiconductor, Inc. 
* * ----------------------------------------------------------------------------
* RELEASE HISTORY
* VERSION DATE AUTHOR DESCRIPTION
* (1.0) 11/01/2011   B32599 (Initial Template)
* ----------------------------------------------------------------------------
* KEYWORDS : Xtrinsic
* ----------------------------------------------------------------------------
* PURPOSE: 
* ----------------------------------------------------------------------------
* REUSE ISSUES
*  
* -FHDR-----------------------------------------------------------------------
*/


/******************************************************************************
*
* Includes Application Header file
*
*******************************************************************************/
#include "CustomApp1.h"



/******************************************************************************
 * main function
 * 
 * Function: based on counts, if count exceeds 10, toggle GPIO7 pin
 * Count1 DataCnt: 	10 frame counters
 * Count2 ZlockCnt: 10 continuous Gesture event Zlock = 0
 * Count3 PLmixCnt: 10 continuous Gesture event Zlock = 0 & Orientation is Portrait up
 * 
 * Reference to AFE raw data: data is copied to user variables accelX, accelY, and accelZ
 * 
 ******************************************************************************/

void user_app_main(void) {
    
	/* use the Freescale API to lookup helper function addresses */
    get_data_ptr_t		* get_data_ptr = fsl_api_table_lookup(FSL_API_FN_GET_DATA_PTR);         
	//app_out_addr_ptr_t        * app_out_addr_ptr        = fsl_api_table_lookup(FSL_API_FN_APP_OUT_ADDR);  	
 
    /* Look up the address of RAM data structures */
    user_app_struct_t	* user_app_struct  	= get_data_ptr(USER_APP_FBID);
    frontend_struct_t   * frontend_struct  	= get_data_ptr(XYZ_DATA_FBID);
    pl_struct_t			* pl_struct			= get_data_ptr(PORTRAIT_LANDSCAPE_FBID);
	  
    /* acquire accelerometer data and process */   
    user_app_struct->outs.accelX = frontend_struct->outs.accel_output[AFE_STAGE_0][FRONTEND_X];
	user_app_struct->outs.accelY = frontend_struct->outs.accel_output[AFE_STAGE_0][FRONTEND_Y];
	user_app_struct->outs.accelZ = frontend_struct->outs.accel_output[AFE_STAGE_0][FRONTEND_Z];

	/* User Case 0 */ 
	// increase DataCnt data counter every frame
	/*user_app_struct->outs.DataCnt += 1; 
	if (user_app_struct->outs.DataCnt == user_app_struct->param.event_cnt && (user_app_struct->outs.accelZ > 0x0CCE))
	{
		RGPIO_DATA ^= (1<<7);
		user_app_struct->outs.DataCnt = 0;
	}*/

	/* User Application Example 1 */
	// acquire PL Z-lock status, and process
	/*if (pl_struct->outs.bits.Lock == 1)
	{
		// 		log event, if Zlock is detected, increase ZlockCnt
		user_app_struct->outs.ZlockCnt += 1;
	}
	else
	{
		user_app_struct->outs.ZlockCnt = 0;
	}
	if (user_app_struct->outs.ZlockCnt == user_app_struct->param.event_cnt)
	{
		RGPIO_DATA ^= (1<<7);
		user_app_struct->outs.ZlockCnt = 0;
	}*/
	
	/* User Application Example 2 */
	/*// acquire PL Z-lock and orientation status, and process
	if (pl_struct->outs.bits.Lock == 1)
	{
		// 		log event, if orientation = portrait up && Zlock is detected, increase PLmixCnt
		//		else clear PLmixCnt 	
		if (pl_struct->outs.bits.LAPO == 0x01)
			user_app_struct->outs.PLmixCnt += 1;
		else
			user_app_struct->outs.PLmixCnt = 0;
	}
	if (user_app_struct->outs.PLmixCnt == user_app_struct->param.event_cnt)
	{
		RGPIO_DATA ^= (1<<7);
		user_app_struct->outs.PLmixCnt = 0;
	}
	*/
	
	
	/* Combined all three User Application Examples */
	// increase DataCnt data counter every frame
	user_app_struct->outs.DataCnt += 1; 
	
	// acquire PL Z-lock and orientation status, and process
	if (pl_struct->outs.bits.Lock == 1)
	{
		user_app_struct->outs.ZlockCnt += 1;
		// acquire PL Z-lock and orientation status, and process 
		//		log event, if orientation = portrait up && Zlock is detected, increase PLmixCnt
		//		else clear PLmixCnt
		if (pl_struct->outs.bits.LAPO == 0x01)
			user_app_struct->outs.PLmixCnt += 1;
		else
			user_app_struct->outs.PLmixCnt = 0;
	}
	else
	{
		user_app_struct->outs.ZlockCnt = 0;
	}
	
	/* process GPIO_7 according to cfg
	 * if cfg = Data, GPIO7 is toggled when board sits on table > 0.8g and DataCnt reach event_cnt
	 * if cfg = Zlock, GPIO7 is toggled when board is tilted from horizon < 30 deg for 10 frame cycle
	 * if cfg = PLmix, GPIO7 is toggled when board is tilted from horizon < 30 deg 
	 * 										AND device orientation is Portrait Up or more then event_cnt counts 
	 */
	switch (user_app_struct->param.cfg)
	{
		case Data: 
				if (user_app_struct->outs.DataCnt == user_app_struct->param.event_cnt && (user_app_struct->outs.accelZ > 0x0CCE))
				{
					RGPIO_DATA ^= (1<<7);
					user_app_struct->outs.GPIO_State ^= 1;
					user_app_struct->outs.DataCnt = 0;
				}
				break;
		case Zlock:
				if (user_app_struct->outs.ZlockCnt == user_app_struct->param.event_cnt)
				{
					RGPIO_DATA ^= (1<<7);
					user_app_struct->outs.GPIO_State ^= 1;
					user_app_struct->outs.ZlockCnt = 0;
				}
				break;
		case PLmix:
				if (user_app_struct->outs.PLmixCnt == user_app_struct->param.event_cnt)
				{
					RGPIO_DATA ^= (1<<7);
					user_app_struct->outs.GPIO_State ^= 1;
					user_app_struct->outs.PLmixCnt = 0;
				}
				break;
		default:
				break;
	}
	
	/* Error condition /data range handle */
	if (user_app_struct->outs.DataCnt > user_app_struct->param.event_cnt)
		user_app_struct->outs.DataCnt = 0;
	if (user_app_struct->outs.ZlockCnt > user_app_struct->param.event_cnt)
		user_app_struct->outs.ZlockCnt = 0;
	if (user_app_struct->outs.PLmixCnt > user_app_struct->param.event_cnt)
		user_app_struct->outs.PLmixCnt = 0;

}

/******************************************************************************
 * Initialization function
 * 
 * Function: 
 * 1. schedule User application to run on 488Hz frequency
 * 2. set up AFE module
 * 3. set up Power management
 * 4. set up Gesture functions
 * 5. initialize the user application variables
 * 
 ******************************************************************************/

void user_app_init(void) {

	/* ---------------------------------------------------------------------------------------------
	 * Define user task run frequency u=in scheduler structure
	 * 		Frequency: 488Hz
	 * 		Activity:  Always run regardless of accelerometer 
	 * ---------------------------------------------------------------------------------------------*/
		
		/* use the Freescale API to lookup helper function addresses */
		get_data_ptr_t        * get_data_ptr        = fsl_api_table_lookup(FSL_API_FN_GET_DATA_PTR);
		
		/* look up the address of scheduler data structures */    
		scheduler_struct_t    * scheduler_struct    = get_data_ptr(SCHEDULER_FBID);
		
		/* configure the scheduler for priority and activity */
		scheduler_struct->param.sched_parms[USER_APP_FBID].bits.priority = TASK488HZ;
		scheduler_struct->param.sched_parms[USER_APP_FBID].bits.activity = ALWAYS;

		
	/* ---------------------------------------------------------------------------------------------
	 * Allocation user task RAM memory space
	 * 		Memory structure: user_app_struct_t
	 * ---------------------------------------------------------------------------------------------*/
 		
		/* use the Freescale API to lookup helper function addresses */
		request_ram_ptr_t	* request_ram_ptr	  	= fsl_api_table_lookup(FSL_API_FN_REQ_DATA_RAM);	
				
		/* assign RAM space */
		user_app_struct_t	* user_app_struct  		= (user_app_struct_t*) request_ram_ptr(sizeof(user_app_struct_t),USER_APP_FBID);

		
	/* ---------------------------------------------------------------------------------------------
	 * Setup Power management
	 * Option 1: Disable Power management
	 * Option 2: Auto Power management
	 * Option 3: Doze mode, further reduce power based on accelerometer, wake up by tilt the board 90 degree
	 * ---------------------------------------------------------------------------------------------*/
	
		/* Setup Auto wake/sleep config structure */
		/* use the Freescale API to lookup helper function addresses */
		app_param_addr_ptr_t        * app_param_addr_ptr        = fsl_api_table_lookup(FSL_API_FN_APP_PARAM_ADDR);  	

		/* look up the address of AFE data structures */ 
		uint8 parameter_bytes;
		uint8 (*sleep_wake_param)[] = app_param_addr_ptr(SLEEP_WAKE_FBID,&parameter_bytes);

		/* Wake EVE part up for observation */ 
			/* configure 1: disables power management 
			 * 				always run, disable sleep and doze modes, and stop instruction 
			 * Note: make sure to use this mode in debug */
			(*sleep_wake_param)[6] = 0x10; 
			
			/* configure 2: enable power management 
			 * 				go to stop when no further software activity */
			//(*sleep_wake_param)[6] = 0x00; 	    //enable stop, disable sleep, enable doze mode
			
			/* configure 3: enable power management 
			 * 				go to doze when no further software and acceleromter activity */
			/*(*sleep_wake_param)[6] = 0x06; 	    //disable stop, disable sleep, enable doze mode, with period of 2.05ms
			(*sleep_wake_param)[0] = 0x00; 		//threshold = 120 
			(*sleep_wake_param)[1] = 0x78; 
			(*sleep_wake_param)[2] = 0x09; 		//enter Doze mode after 5s inactivity =  488 * 5 
			(*sleep_wake_param)[3] = 0x88; 
			(*sleep_wake_param)[4] = 0x07; 		//long doze sample at 1.9Hz
			(*sleep_wake_param)[5] = 0x03; 		//short doze sample at 30Hz
			*/

			
	/* ---------------------------------------------------------------------------------------------
	 * Setup Gesture function: 
	 * 		Portrait-landscape	- details commented
	 * 		
	 * ---------------------------------------------------------------------------------------------*/
		
		/* use the Freescale API to lookup helper function addresses */
		//get_data_ptr_t        * get_data_ptr        = fsl_api_table_lookup(FSL_API_FN_GET_DATA_PTR);  
		
		/* look up the address of AFE data structures */ 
		/* configure the Portrait-Landscape FB for threshold, debounce, and axes */
		pl_struct_t			  *pl_struct			= get_data_ptr(PORTRAIT_LANDSCAPE_FBID); 
		
		/* set the configure values */
		pl_struct->param.threshold_tilt = 30;		// Z-axis tilt/Lock-out angle = 45 degree
		pl_struct->param.portrait_angle = 60; 		// Landscape to Portrait transit at 60 degree
		pl_struct->param.landscape_angle = 30; 		// Portrait to Landscape transit at 30 degree
		pl_struct->param.debounce_count = 10;		// 10 consist samples to confirm the flag
		pl_struct->param.hysteresis_LO = 5;			// hysteresis degree = 5 degree for back / forth
		pl_struct->param.hysteresis_BAFRO = 133;	// hysteresis degree = 15 degree for  		
		pl_struct->param.cfg.Byte = 0xE8;			// 0b1110'1000

		
	/* ---------------------------------------------------------------------------------------------
	 * Setup Data FIFO
	 * 	Buffer size = 0x60 hex bytes
	 *  Buffer Applicaton = Frontend accelerometer data
	 *  Watermark size = 0x30 hex bytes
	 * ---------------------------------------------------------------------------------------------*/
		
		/* use the Freescale API to lookup helper function addresses */
		//get_data_ptr_t        * get_data_ptr        = fsl_api_table_lookup(FSL_API_FN_GET_DATA_PTR);  
		
		/* look up the address of data FIFO structures */ 
		dataFifo_struct_t	*dataFifo_struct	= get_data_ptr(DATA_FIFO_FBID); 
	 	
		/* set up configures for FIFO */
		dataFifo_struct->param.config.Byte = 0x0C;
		dataFifo_struct->param.sz = 0x0060;
		dataFifo_struct->param.ch1_app_id = XYZ_DATA_FBID;
		dataFifo_struct->param.wmrk = 0x0030;

		
	/* ---------------------------------------------------------------------------------------------
	 * Setup Event FIFO
	 * 	Buffer size = 0x60 hex bytes
	 *  Watermark size = 0x40 hex bytes
	 *  Event time-out if no activities is detected after 0x0100 Frame Count
	 * ---------------------------------------------------------------------------------------------*/	
		
		/* use the Freescale API to lookup helper function addresses */
		//get_data_ptr_t        * get_data_ptr        = fsl_api_table_lookup(FSL_API_FN_GET_DATA_PTR);  

		/* look up the address of data FIFO structures */ 
		eventFifo_struct_t	*eventFifo_struct	= get_data_ptr(EVENT_FIFO_FBID); 
		
		/* set up configures for FIFO */
		eventFifo_struct->param.sz = 0x0060;
		eventFifo_struct->param.wmrk = 0x0040;
		eventFifo_struct->param.time_out = 0x0100;

		
	/* ---------------------------------------------------------------------------------------------
	 * Setup Initial / Reset values for user application
	 * ---------------------------------------------------------------------------------------------*/

		user_app_reset();

}

/******************************************************************************
 * Reset function
 * 
 ******************************************************************************/

void user_app_reset(void){

    /* use the Freescale API to lookup helper function addresses */
    get_data_ptr_t        * get_data_ptr        = fsl_api_table_lookup(FSL_API_FN_GET_DATA_PTR);
	
    /* initialization of status for Host */
	user_app_struct_t	* user_app_struct		= get_data_ptr(USER_APP_FBID);
    
    user_app_struct->outs.GPIO_State 	= 0x01;
	user_app_struct->outs.DataCnt		= 0x00;
	user_app_struct->outs.ZlockCnt		= 0x00;
	user_app_struct->outs.PLmixCnt		= 0x00;
	user_app_struct->outs.FaccelX 		= 0x0000;
	user_app_struct->outs.FaccelY 		= 0x0000;
	user_app_struct->outs.FaccelZ 		= 0x0000;
	user_app_struct->param.cfg			= Data;
	user_app_struct->param.event_cnt	= MAX_COUNTER_LIMIT;
	user_app_struct->private.state		= 0x00;
	user_app_struct->private.flag		= 0x00;
	
	/* initialize GPIO7 to High on start */   
	RGPIO_DATA = (1<<7);		

}

/******************************************************************************
 * Clear function
 * 
 ******************************************************************************/

void user_app_clear(void){

}


