/*******************************************************************************
*
*	Freescale Semiconductor Inc.
*	(c) Copyright 2010 Freescale Semiconductor Inc.
*	ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
*	@file app_main.c
*	
*	@version 0.0.2.0
*	
*	@lastmodusr B16958
*	
*	@lastmoddate Jul-1-2010
*	
********************************************************************************
*
*	@brief Main function of the application
*
*	
*	@project AN4147
*	
*	@author B16958
*	
*	@ingroup common
*
******************************************************************************/

/******************************************************************************
* Includes
******************************************************************************/
#include "MPC560xB.h"
#include "sys_init.h"
#include "sci_app_01.h"
#include "sci_app_02.h"
#include "sci_app_03.h"
#include "sci_app_04.h"
#include "sci_app_05.h"
#include "spi_app_01.h"
#include "spi_app_02.h"

/***************************************************************************//*!
*
* @brief Main function which only initialize the system and runs the function
* 		interface for the selected example.
*
*
*	@ingroup common
*
******************************************************************************/

int main(void) 
{

	SysInit();

#if defined(sci_app_01)
	SciApp01();
#elif defined(sci_app_02)
	SciApp02();
#elif defined(sci_app_03)
	SciApp03();
#elif defined(sci_app_04)
	SciApp04();
#elif defined(sci_app_05)
	SciApp05();
#elif defined(spi_app_01)
	SpiApp01();
#elif defined(spi_app_02)
	SpiApp02();
#else
#	error "Not defined valid example to execute!"
#endif

	return 0;
}
