################################################################################
# Freescale Semiconductor Inc.
# (c) Copyright 2010 Freescale Semiconductor Inc.
# ALL RIGHTS RESERVED.
#############################################################################/*!
#
#	@file rules.mak
#
#	@version 1.0.1.0
#
#	@lastmodusr B16958
#
#	@lastmoddate Jul-1-2010
#
#	@brief Commands and options for building the application for MPC5607B with Code Warrior
#
#	@project AN4147
#
#	@author B16958
#
##############################################################################*/

CC 			:= $(CW_DIR)/PowerPC_EABI_Tools/Command_Line_Tools/mwcceppc.exe
LD 			:= $(CW_DIR)/PowerPC_EABI_Tools/Command_Line_Tools/mwldeppc.exe
AS 			:= $(CW_DIR)/PowerPC_EABI_Tools/Command_Line_Tools/mwasmeppc.exe
CCOPT 			:=-gdwarf-2 -proc Zen -common off -w on -char unsigned -use_isel on \
			-sdatathreshold 0 -sdata2threshold 0 \
			-nosyspath -ir $(CW_DIR)/PowerPC_EABI_Support/MSL/MSL_C \
			-cpp_exceptions off -use_lmw_stmw on  \
			-far_near_addressing -Op -sym dwarf-2,full -vle

LDOPT 			:= -proc Zen -char unsigned -gdwarf-2 -listdwarf \
			-romaddr 0x00000000 -rambuffer 0x00000000  \
			 
ASOPT 			:= -c -proc Zen -vle
LINKER_DEFS		:=$(COMPILER)/flash.lcf


# Compiling and Linking macros
COMPILE_C_FILE = $(CC) $(CCOPT) -c -D$(1) -c $< -o $@
COMPILE_S_FILE = $(AS) $(ASOPT) -I$(COMPILER) $< -o $@
LINK_O_FILES = $(LD) $(LDOPT) -lcf $(LINKER_DEFS) $(word $(1),$(APP_OBJ)) $(COMMON_OBJ) -o $@ -map $(basename $@).map
