/*******************************************************************************
*
*	Freescale Semiconductor Inc.
*	(c) Copyright 2010 Freescale Semiconductor Inc.
*	ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
*	@file startup.c
*	
*	@version 0.0.1.0
*	
*	@lastmodusr B16958
*	
*	@lastmoddate May-31-2010
*	
*	@brief MPC560xB Startup File VLE
*	
********************************************************************************/

#define S_INTC_BASEADDR        0xFFF48000UL
#define S_INTC_MCR             (S_INTC_BASEADDR + ((unsigned long)0x0u))
#define S_INTC_MCR_VTES_4BYTES ((unsigned long)0x00000000)    /* Vector Table Entry Size - 4 bytes */
#define S_INTC_MCR_HVEN_ON     ((unsigned long)0x00000001)    /* Hardware Vector ENable - On */
#define S_INTC_CPR             (S_INTC_BASEADDR + ((unsigned long)0x8)) /* Current Priority Register */

#define S_REG_WRITE32(address, value)       (*(volatile unsigned long*)(address) = (value))

/* Function Definitions */
extern void main(void);


void StartupCode(void)

{
    asm(" .globl _start");
    asm(" .align 2");
    asm("_start:");

    asm(" xor  r0, r0, r0");
    asm(" xor  r1, r1, r1");
    asm(" xor  r2, r2, r2");
    asm(" xor  r3, r3, r3");
    asm(" xor  r4, r4, r4");
    asm(" xor  r5, r5, r5");
    asm(" xor  r6, r6, r6");
    asm(" xor  r7, r7, r7");
    asm(" xor  r8, r8, r8");
    asm(" xor  r9, r9, r9");
    asm(" xor  r10, r10, r10");
    asm(" xor  r11, r11, r11");
    asm(" xor  r12, r12, r12");
    asm(" xor  r13, r13, r13");
    asm(" xor  r14, r14, r14");
    asm(" xor  r15, r15, r15");
    asm(" xor  r16, r16, r16");
    asm(" xor  r17, r17, r17");
    asm(" xor  r18, r18, r18");
    asm(" xor  r19, r19, r19");
    asm(" xor  r20, r20, r20");
    asm(" xor  r21, r21, r21");
    asm(" xor  r22, r22, r22");
    asm(" xor  r23, r23, r23");
    asm(" xor  r24, r24, r24");
    asm(" xor  r25, r25, r25");
    asm(" xor  r26, r26, r26");
    asm(" xor  r27, r27, r27");
    asm(" xor  r28, r28, r28");
    asm(" xor  r29, r29, r29");
    asm(" xor  r30, r30, r30");
    asm(" xor  r31, r31, r31");

    /* Initialize IVPR register to address of Interrupt Vector Table */
    asm (" e_lis r5, __IV_ADDR@h ");
    asm (" e_or2i  r5,__IV_ADDR@l ");
    asm (" mtIVPR r5");

    asm(" e_lis   r1, __SP_INIT@h");
    asm(" e_or2i    r1, __SP_INIT@l");

     asm(" e_lis   r5, INT_SRAM_SIZE@h");     /* Number of 128 byte segments */
     asm(" e_or2i    r5, INT_SRAM_SIZE@l"); /* Number of 128 byte segments */
     asm(" se_mtctr r5");                       /* configure control register for use with e_bdnz */

/* start address of the internal SRAM */
     asm(" e_lis   r5,INT_SRAM_START@h");
     asm(" e_or2i    r5, INT_SRAM_START@l");

/* Repeat */
     asm("sram_loop:");
     asm(" e_stmw  r0,0(r5)"); /* write all 32 registers to L2RAM */
     asm(" e_addi  r5,r5,128"); /* increment the ram ptr */
     asm(" e_bdnz   sram_loop"); /* loop for 64k of L2RAM */

/************************/
/* Erase ".sbss Section" */
/************************/
     asm(" e_lis  r5, SBSS_SRAM_SIZE@h");       /* Number of words */
     asm(" e_or2i   r5, SBSS_SRAM_SIZE@l");   /* Number of words */
     asm(" or.  r5, r5, r5");                 /* Number of words */
     asm(" e_beq    sram_erase1");
     asm(" se_mtctr r5");                        /* configure control register for use with e_bdnz */

/* start address of the sbss section */
     asm(" e_lis   r5,SBSS_SRAM_START@h");
     asm(" e_or2i    r5, SBSS_SRAM_START@l");
     asm(" xor   r0, r0, r0 ");
     asm(" e_subi  r5,r5,4");                   /* decrement by 4 to prepare for e_stwu in loop */

/* Repeat */
     asm("sram_loop1:");
     asm(" e_stwu   r0,4(r5)");                 /* write 0 to RAM and update r5 address */
     asm(" e_bdnz   sram_loop1");
     asm("sram_erase1:");

/************************/
/* Erase ".bss Section" */
/************************/
     asm(" e_lis   r5, BSS_SRAM_SIZE@h");      /* Number of words */
     asm(" e_or2i    r5, BSS_SRAM_SIZE@l");  /* Number of words */
     asm(" or.   r5, r5, r5");               /* Number of words */
     asm(" e_beq   sram_erase2");
     asm(" se_mtctr r5");                       /* configure control register for use with e_bdnz */

/* start address of the bss section */
     asm(" e_lis   r5, BSS_SRAM_START@h");
     asm(" e_or2i    r5, BSS_SRAM_START@l");
     asm(" e_subi  r5,r5,4");                   /* decrement by 4 to prepare for e_stwu in loop */

/* Repeat */
     asm("sram_loop2:");
     asm(" e_stwu r0,4(r5)");                  /* write 0 to RAM and update r5 address, r0 must be zero */
     asm(" e_bdnz   sram_loop2");
     asm("sram_erase2:");

/******************************************************************/
/* Copy  initialized data from Flash to SRAM                      */
/******************************************************************/
/*******************/
/* .PPC.EMB.sdata0 */
/*******************/
     asm(" e_lis   r5, RC_PPC_SDATA2_SIZE@h");      /* Number of words */
     asm(" e_or2i    r5, RC_PPC_SDATA2_SIZE@l");  /* Number of words */
     asm(" or.   r5, r5, r5");                     /* Number of words */
     asm(" e_beq   data_copy1");
     asm(" se_mtctr r5");                       /* configure control register for use with e_bdnz */

/* source address of the section */
     asm(" e_lis   r8, RC_PPC_SDATA2_SRC@h");
     asm(" e_or2i    r8, RC_PPC_SDATA2_SRC@l");
     asm(" e_subi  r8,r8,4");                   /* decrement by 4 to prepare for e_stwu in loop */

/* Destination address of the section */
     asm(" e_lis   r9, RC_PPC_SDATA2_DEST@h");
     asm(" e_or2i    r9, RC_PPC_SDATA2_DEST@l");
     asm(" e_subi  r9,r9,4");                   /* decrement by 4 to prepare for e_stwu in loop */

/* Repeat */
     asm("data_copy_loop1:");
     asm(" e_lwzu  r10,4(r8)");
     asm(" e_stwu  r10,4(r9)");
     asm(" e_bdnz  data_copy_loop1");
    asm("data_copy1:");
/**********/
/* .sdata */
/**********/
     asm(" e_lis   r5, RC_SDATA_SIZE@h");      /* Number of words */
     asm(" e_or2i    r5, RC_SDATA_SIZE@l");      /* Number of words */
     asm(" or.   r5, r5, r5");                     /* Number of words */
     asm(" e_beq   data_copy2");
     asm(" se_mtctr r5");                       /* configure control register for use with e_bdnz */

/* source address of the section */
     asm(" e_lis   r8, RC_SDATA_SRC@h");
     asm(" e_or2i    r8, RC_SDATA_SRC@l");
     asm(" e_subi  r8,r8,4");                   /* decrement by 4 to prepare for e_stwu in loop */

/* Destination address of the section */
     asm(" e_lis   r9, RC_SDATA_DEST@h");
     asm(" e_or2i    r9, RC_SDATA_DEST@l");
     asm(" e_subi  r9,r9,4");                   /* decrement by 4 to prepare for e_stwu in loop */

/* Repeat */
     asm("data_copy_loop2:");
     asm(" e_lwzu  r10,4(r8)");
     asm(" e_stwu  r10,4(r9)");
     asm(" e_bdnz  data_copy_loop2");
     asm("data_copy2:");
/**********/
/* .data */
/**********/
     asm(" e_lis   r5, RC_DATA_SIZE@h");      /* Number of words */
     asm(" e_or2i    r5, RC_DATA_SIZE@l");      /* Number of words */
     asm(" or.   r5, r5, r5");                     /* Number of words */
     asm(" e_beq   data_copy3");
     asm(" se_mtctr r5");                       /* configure control register for use with e_bdnz */

/* source address of the section */
     asm(" e_lis   r8, RC_DATA_SRC@h");
     asm(" e_or2i    r8, RC_DATA_SRC@l");
     asm(" e_subi  r8,r8,4");                   /* decrement by 4 to prepare for e_stwu in loop */

/* Destination address of the section */
     asm(" e_lis   r9, RC_DATA_DEST@h");
     asm(" e_or2i    r9, RC_DATA_DEST@l");
     asm(" e_subi  r9,r9,4");                   /* decrement by 4 to prepare for e_stwu in loop */

/* Repeat */
     asm("data_copy_loop3:");
     asm(" e_lwzu  r10,4(r8)");
     asm(" e_stwu  r10,4(r9)");
     asm(" e_bdnz  data_copy_loop3");
     asm("data_copy3:");

/*********************************/
/* Set the small ro data pointer */
/*********************************/
     asm(" e_lis   r2, SDATA_RO_START@h");
     asm(" e_or2i    r2, SDATA_RO_START@l");

/*********************************/
/* Set the small rw data pointer */
/*********************************/
     asm(" e_lis   r13, SDATA_RW_START@h");
     asm(" e_or2i    r13, SDATA_RW_START@l");

    /* Configure INTC for hardware vector mode */
    S_REG_WRITE32(S_INTC_MCR,S_INTC_MCR_HVEN_ON|S_INTC_MCR_VTES_4BYTES);

    /* Setup main code priority */
    S_REG_WRITE32(S_INTC_CPR,0);

/******************************************************************/
/* Call Main Routine                                              */
/******************************************************************/
     /* Prepare a terminating stack record. */
     asm (" e_li r0, -1");
     asm (" e_stwu r1, -8(r1)"); /* Decrement stack by 8 bytes, (write word) */
     asm (" e_stw  r0, 4(r1)");  /* Make an illegal return address of 0xFFFFFFFF */
     asm (" e_stw  r0, 0(r1)");  /* Make an illegal back chain address of 0xFFFFFFFF */

     main();

     while (1)
     {
     }
}
