/*******************************************************************************
*
*	Freescale Semiconductor Inc.
*	(c) Copyright 2010 Freescale Semiconductor Inc.
*	ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
*	@file flash.ld
*	
*	@version 0.0.2.0
*	
*	@lastmodusr B16958
*	
*	@lastmoddate Jul-1-2010
*	
*	@brief Bolero Linker Command File for Internal FLASH
*	
********************************************************************************/

MEMORY {

//  512K Internal Flash
    flash_rsvd1       : ORIGIN = 0x00000000, LENGTH = 8
    flash_memory      : ORIGIN = 0x00000008, LENGTH = 512K-0x10008
    flash_vec         : ORIGIN = 0x00070000, LENGTH = 0x0D00
    flash_not_used    : ORIGIN = 0x00070D00, LENGTH = 0xC000
    flash_rsvd2      : ORIGIN = .,          LENGTH = 0 


//  32KB of internal SRAM starting at 0x40000000
    ram_rsvd1    :     ORIGIN = 0x20000000, LENGTH = 0
    int_sram     :     ORIGIN = 0x40000000, LENGTH = 0x6F00
    iram_stack   :     ORIGIN = 0x40006F00, LENGTH = 0x1000
    ram_user_tcd :     ORIGIN = 0x40007F00, LENGTH = 0x0100
    ram_rsvd2    :     ORIGIN = .,          LENGTH = 0

}

//
// Program layout for starting in ROM, copying data to RAM,
// and continuing to execute out of ROM.
//

SECTIONS
{
//
// RAM SECTIONS
//
    .PPC.EMB.sdata0 	          		    ABS : > int_sram
    .PPC.EMB.sbss0                            CLEAR ABS : > .
   
    .sdabase 		       		       ALIGN(8)	: > .	
    .sdata 						: > .
    .sbss 						: > .
    .data 						: > .
    .bss 						: > .

//
// ROM SECTIONS
//
    .rcw                                                : > flash_rsvd1
    .text						: > flash_memory
    .vletext						: > .
    .syscall						: > .
    .rodata		 					: > .
    .sdata2 						: > .
    .secinfo 						: > .
    .fixaddr 						: > .
    .fixtype 						: > .

    .ROM.PPC.EMB.sdata0 	   ROM(.PPC.EMB.sdata0) : > .
    .ROM.sdata  	            	    ROM(.sdata) : > .
    .ROM.data 	            		     ROM(.data) : > .

    .not_used                                           : > flash_not_used
    .isrvectbl                            ALIGN(0x1000) : > flash_vec

//
// These special symbols mark the bounds of RAM and ROM memory.
// They are used by the MULTI debugger.
//
    __ghs_ramstart  = MEMADDR(ram_rsvd1);
    __ghs_ramend    = MEMENDADDR(ram_rsvd2);
    __ghs_romstart  = MEMADDR(flash_rsvd1);
    __ghs_romend    = MEMENDADDR(flash_rsvd2);

    __IV_ADDR       = MEMADDR(flash_vec);
    
    NOT_USED       = MEMADDR(flash_not_used);

    INT_SRAM_START  = ADDR(int_sram);
    INT_SRAM_SIZE   = 32K/128;                        // Init 128 bytes at a time
    SBSS_SRAM_START = ADDR(.sbss);
    SBSS_SRAM_SIZE  = (SIZEOF(.sbss)+3)/4;            // Init 4 bytes at a time
    BSS_SRAM_START  = ADDR(.bss);
    BSS_SRAM_SIZE   = (SIZEOF(.bss)+3)/4;             // Init 4 bytes at a time
    SDATA_RW_START  = ADDR(.sdata);
    SDATA_RO_START  = ADDR(.sdata2);

    RC_PPC_SDATA2_SRC  = ADDR(.ROM.PPC.EMB.sdata0);
    RC_PPC_SDATA2_DEST = ADDR(.PPC.EMB.sdata0);
    RC_PPC_SDATA2_SIZE = (SIZEOF(.ROM.PPC.EMB.sdata0)+3)/4; // Copy 4 bytes at a time
    RC_SDATA_SRC       = ADDR(.ROM.sdata);
    RC_SDATA_DEST      = ADDR(.sdata);
    RC_SDATA_SIZE      = (SIZEOF(.ROM.sdata)+3)/4;          // Copy 4 bytes at a time
    RC_DATA_SRC        = ADDR(.ROM.data);
    RC_DATA_DEST       = ADDR(.data);
    RC_DATA_SIZE       = (SIZEOF(.ROM.data)+3)/4;           // Copy 4 bytes at a time

    __SP_INIT      = ADDR(iram_stack) + SIZEOF(iram_stack);
    __SP_END       = ADDR(iram_stack);
    __STACK_SIZE   = SIZEOF(iram_stack);

}
