################################################################################
# Freescale Semiconductor Inc.
# (c) Copyright 2010 Freescale Semiconductor Inc.
# ALL RIGHTS RESERVED.
#############################################################################/*!
#
#	@file rules.mak
#
#	@version 1.0.1.0
#
#	@lastmodusr B16958
#
#	@lastmoddate May-31-2010
#
#	@brief Commands and options for building the application for MPC5607B with GreenHills
#
#	@project AN4147
#
#	@author B16958
#
##############################################################################*/
CC 			:= $(GHS_DIR)/ccppc.exe
LD 			:= $(GHS_DIR)/ccppc.exe
AS 			:= $(GHS_DIR)/asppc.exe
CCOPT 			:= -bsp generic -cpu=ppc560xb  -ansi  -dwarf2 --no_commons -nokeeptempfiles -pnone --incorrect_pragma_warnings \
		 	--slash_comment -vle -asm=-elf -preprocess_assembly_files --no_exceptions -dual_debug -sda=0 --prototype_errors \
			-Wundef	--nocpp -uvfd -M -keepmap -Ospace -G
LDOPT 			:= -cpu=ppc560xb -vle -nostartfiles
ASOPT 			:= -cpu=ppc560xb
LINKER_DEFS		:=$(COMPILER)/flash.ld

# Compiling and Linking macros
COMPILE_C_FILE = $(CC) $(CCOPT) -D$(1) -c $< -o $@
COMPILE_S_FILE = $(AS) $(ASOPT) -I$(COMPILER) $< -o $@
LINK_O_FILES = $(LD) $(LDOPT) $(LINKER_DEFS) $(word $(1),$(APP_OBJ)) $(COMMON_OBJ) -o $@
