/***************************************************************************//*!
*
*	Freescale Semiconductor Inc.
*	(c) Copyright 2010 Freescale Semiconductor Inc.
*	ALL RIGHTS RESERVED.
*
********************************************************************************
*
*	@file sci_app_01.h
*	
*	@version 0.0.1.0
*	
*	@lastmodusr B16958
*	
*	@lastmoddate May-18-2010
*	
********************************************************************************
*
*	@brief eDMA emulating single SCI transmit
*
*	This example demonstates how the eDMA could be used to emulate SCI.
*	Using LINFlex0 to recieve one byte from serial line, sending the same
*	byte using DMA single channel.
*	Configuration:
*		* LINFlex0 - Rx only on PCR_19 (PB3)
*		* DMA channel 0 writes to GPIO PCR_18 (PB2)
*		* DMA triggered using PIT_0 with always enabled source (periodic triggers only)
*		* SW task: On reception of one byte using UART transmit the same byte using DMA
*		* Connection: Standard wiring on EVB: PB2 and PB3 -> SCI transciever
*	
*	@project ANN-xxxx
*	
*	@author B16958
*	
*	@ingroup sci_tx
*
******************************************************************************/
#ifndef SCI_APP_01_H
#define SCI_APP_01_H

/******************************************************************************
* External Function Declarations
******************************************************************************/
extern void SciApp01(void);

#endif /* SCI_APP_01_H */