/***************************************************************************//*!
*
*	Freescale Semiconductor Inc.
*	(c) Copyright 2010 Freescale Semiconductor Inc.
*	ALL RIGHTS RESERVED.
*
********************************************************************************
*
*	@file sci_app_04.h
*	
*	@version 0.0.1.0
*	
*	@lastmodusr B16958
*	
*	@lastmoddate May-18-2010
*	
********************************************************************************
*
*	@brief eDMA emulating multiple SCI transmits with condition
*
*	This example demonstates how the eDMA could be used to emulate SCI transmiter
*	of variable length
*	Configuration:
*		* DMA channel 0 writes to GPIO PCR_18 (PB2)
*		* DMA channel 0 activated using periodic triggers
*		* DMA channel 1 takes one byte from buffers and link to the channel 0
*		* DMA channel 1 activated explicitely by SW to transmit burst of bytes
*		* Connection: Standard wiring on EVB: PB2 and PB3 -> SCI transciever
*	
*	@project ANN-xxxx
*	
*	@author B16958
*	
*	@ingroup sci_tx
*
******************************************************************************/
#ifndef SCI_APP_04_H
#define SCI_APP_04_H

/******************************************************************************
* External Function Declarations
******************************************************************************/
extern void SciApp04(void);

#endif /* SCI_APP_04_H */