/***************************************************************************//*!
*
*	Freescale Semiconductor Inc.
*	(c) Copyright 2010 Freescale Semiconductor Inc.
*	ALL RIGHTS RESERVED.
*
********************************************************************************
*
*	@file spi_app_02.h
*	
*	@version 0.0.2.0
*	
*	@lastmodusr B16958
*	
*	@lastmoddate May-31-2010
*	
********************************************************************************
*
*	@brief eDMA emulating SPI slave
*
*	This example demonstates how the eDMA could be used to emulate SPI slave,
*	sending and recieving data
*	Configuration:
*		- DMA channel 0 SCK activated by SPI master (eMIOS0-CH0-SAIC)
*		- DMA channel 1 processes data in
*		- DMA channel 2 processes data out
*		- CS is solved by SW, but could be as an additional DMA channel
*		- Connection: Connect DSPI to GPIO used for eDMA spi emulation
*			- PC4: DSPI1_SIN  -> PB0 (DMA SOUT)
*			- PC5: DSPI1_SOUT -> PB1 (DMA SIN)
*			- PC2: DSPI1_SCK  -> PA0 (DMA SCK)
*			- PC3: DSPI1_CS0  -> PB3 (DMA CS0)
*	
*	@project ANN-xxxx
*	
*	@author B16958
*	
*	@ingroup spi_slave
*
******************************************************************************/
#ifndef SPI_APP_02_H
#define SPI_APP_02_H

/******************************************************************************
* External Function Declarations
******************************************************************************/
extern void SpiApp02(void);

#endif /* SPI_APP_02_H */