/*******************************************************************************
*
*	Freescale Semiconductor Inc.
*	(c) Copyright 2010 Freescale Semiconductor Inc.
*	ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
*	@file sys_init.c
*	
*	@version 0.0.1.0
*	
*	@lastmodusr B16958
*	
*	@lastmoddate May-31-2010
*	
********************************************************************************
*
*	@brief Initializes the 5607B to run on the oscillator clock and enable basic 
*			peripherals
*
*	
*	@project AN4147
*	
*	@author B16958
*	
*	@ingroup common
*
******************************************************************************/

/******************************************************************************
* Includes
******************************************************************************/
#include "MPC560xB.h"
#include "sys_init.h"

/***************************************************************************//*!
*
* @brief Disabling the watchdog for MPC560xB device.
*
******************************************************************************/
static void DisableWatchdog(void)
{
    SWT.SR.R = 0x0000c520; /* key */
    SWT.SR.R = 0x0000d928; /* key */
    SWT.CR.R = 0x8000010A; /* disable WEN */
}

/***************************************************************************//*!
*
* @brief Enabling all peripherals in DRUN mode for MPC560xB.
*
******************************************************************************/
static void EnableAllPeripherals(void)
{
    /* Enbable all peripheral clocks */
    CGM.SCDC.R = 0x80808080;
    /* Setting RUN Configuration Register ME_RUN_PC[0] */
    ME.RUNPC[0].R=0x000000FE; /* Peripheral ON in every mode */

    /* Re-enter in DRUN mode to update */
    ME.MCTL.R = 0x30005AF0;           /* Mode & Key */
    ME.MCTL.R = 0x3000A50F;           /* Mode & Key */
}

/***************************************************************************//*!
*
* @brief Setup the default 8MHz oscillator (with no PLL), used on MPC56xx evaluation board.
*
******************************************************************************/
static void VVOscInit(void)
{
	/* Enable XOSC */
    CGM.OSC_CTL.R = 0x00800000; /* Set OSC Count value=64 */
    CGM.LPOSC_CTL.R = 0x00800000; /* Set LPOSC Count value=64 */
    CGM.LPOSC_CTL.B.OSCON = 1; /* Enable LPOSC */
    CGM.FMPLL[0].CR.B.PLL_FAIL_MASK = 1; /* Set PLL FAIL mask */
    CGM.FMPLL[0].CR.R = 0x02400104; /* 8 MHz xtal: Set PLL0 to 64 MHz */
    CGM.LPRC_CTL.R = CGM.LPRC_CTL.R | ((32 - 1) << 8);

	ME.DRUN.B.OSCON = 0x1;           /* XOSC is on */
	ME.DRUN.B.SYSCLK = 0x0;            /* clock still at IRC */
	/* Re-enter in DRUN mode to update */
	ME.MCTL.R = 0x30005AF0;           /* Mode & Key */
	ME.MCTL.R = 0x3000A50F;           /* Mode & Key */
	while(ME.GS.B.MTRANS == 1) /* Wait for mode entry to complete */
	{
		
	}
	while(ME.GS.B.CURRENTMODE != 0x3)/* Check DRUN mode has been entered */
	{
		
	}
	while (ME.GS.B.RC!=1)/* Now switch the mode second time to the XOSC */
	{
		
	}
	/* wait till the oscillator is stabilized */
	while (ME.GS.B.OSC!=1)	/* switch to the XOSC and wait */
	{
		
	}
	ME.DRUN.B.SYSCLK = 2;            /* System clock setting */
	ME.MCTL.R = 0x30005AF0;           /* Mode & Key */
	ME.MCTL.R = 0x3000A50F;           /* Mode & Key */
	while(ME.GS.B.MTRANS == 1)		/* Wait for mode entry to complete */
	{
		
	}          
	while(ME.GS.B.CURRENTMODE != 0x3)/* Check DRUN mode has been entered */
	{
		
	}
	while(ME.GS.B.SYSCLK != 2) /* fail is stuck here	 */
	{
		
	}

}

/******************************************************************************
* External function definitions
******************************************************************************/


/***************************************************************************//*!
*
* @brief Function to initialize the MPC5607B CPU to run using on board 8MHZ oscillator
*
* Disables the Watchdog, Enables all peripheral in DRUN mode, using external
* 8MH XOSC, enables the clockout to PA[0]
*
******************************************************************************/
void SysInit(void)
{

	DisableWatchdog();
	EnableAllPeripherals();
	VVOscInit();
}
