#define OFFSET 32767

typedef unsigned char uint8_t;
typedef unsigned int  uint16_t;
typedef unsigned long uint32_t;
typedef unsigned long uint64_t[2];

typedef char int8_t;
typedef int  int16_t;
typedef long int32_t;
typedef long int64_t[2];

typedef struct { uint8_t year, mon, day, wday, hour, min, sec; } RTC; 

/*Metering Datatypes*/
//Power Measures Structure
typedef struct{ 
  int32_t  kwh;        // Active Energy
  int32_t  kw;         // Active Power
  int32_t  kvra;       // Reactive Power
  int32_t  kva;        // Aparent Power
  uint16_t v;          // Vrms
  uint16_t a;          // Irms
  uint16_t hz;         // Line freq
  int32_t cosfi;       // Power_factor
}power_vec_t;



typedef struct
{
    uint8_t count;
    uint8_t type;        // 00 no tamper event
    RTC     tamper_time; // 01 tamper pin
} tamper_t;     

typedef struct
{
    power_vec_t         powervec;
    RTC                 time;    
    tamper_t            tamper[2];
} emeter_t;
