#ifndef _RTC_DRIVER_INT_H_
#define _RTC_DRIVER_INT_H_

#include "MC9S08GW64.h"

/******************************************************************************/
/* FUNCTION          : irtc_setYearOffset                                     */
/******************************************************************************/
/* Abstract          : This function sets the year offset in IRTC registers   */
/*                                                                            */
/* Input Parameters  : offset: offset from year 2112                          */
/*                                                                            */
/* Return Parameter  : 0 - success, 1 - failure                               */
/******************************************************************************/
unsigned char irtc_setYearOffset(unsigned char offset);

/******************************************************************************/
/* FUNCTION          : irtc_setAlarmYearOffset                                */
/******************************************************************************/
/* Abstract          : This function sets alarm year offset in IRTC registers */
/*                                                                            */
/* Input Parameters  : offset: offset from year 2112                          */
/*                                                                            */
/* Return Parameter  : 0 - success, 1 - failure                               */
/******************************************************************************/
unsigned char irtc_setAlarmYearOffset(unsigned char offset);

/******************************************************************************/
/* FUNCTION          : irtc_setMonth                                          */
/******************************************************************************/
/* Abstract          : This function sets the month in IRTC registers         */
/*                                                                            */
/* Input Parameters  : month: a number from 1 to 12                           */
/*                                                                            */
/* Return Parameter  : 0 - success, 1 - failure                               */
/******************************************************************************/
unsigned char irtc_setMonth(unsigned char month);

/******************************************************************************/
/* FUNCTION          : irtc_setAlarmMonth                                     */
/******************************************************************************/
/* Abstract          : This function sets alarm month in IRTC registers       */
/*                                                                            */
/* Input Parameters  : month: a number from 1 to 12                           */
/*                                                                            */
/* Return Parameter  : 0 - success, 1 - failure                               */
/******************************************************************************/
unsigned char irtc_setAlarmMonth(unsigned char month);

/******************************************************************************/
/* FUNCTION          : irtc_setDayAndDate                                     */
/******************************************************************************/
/* Abstract          : This function sets the day and date in IRTC registers  */
/*                                                                            */
/* Input Parameters  : weekday: week day to be set                            */
/*                     date: date to be set                                   */
/*                                                                            */
/* Return Parameter  : 0 - success, 1 - failure                               */
/******************************************************************************/
unsigned char irtc_setDayAndDate(unsigned char weekday, unsigned char date);

/******************************************************************************/
/* FUNCTION          : irtc_setAlarmDate                                      */
/******************************************************************************/
/* Abstract          : This function sets the alarm day in RTC registers      */
/*                                                                            */
/* Input Parameters  : date: date to be set                                   */
/*                                                                            */
/* Return Parameter  : 0 - success, 1 - failure                               */
/******************************************************************************/
unsigned char irtc_setAlarmDate(unsigned char date);

/******************************************************************************/
/* FUNCTION          : irtc_setHour                                           */
/******************************************************************************/
/* Abstract          : This function sets the hours in IRTC registers         */
/*                                                                            */
/* Input Parameters  : hour: a number from 0 to 23                            */
/*                                                                            */
/* Return Parameter  : 0 - success, 1 - failure                               */
/******************************************************************************/
unsigned char irtc_setHour(unsigned char hour);

/******************************************************************************/
/* FUNCTION          : irtc_setAlarmHour                                      */
/******************************************************************************/
/* Abstract          : This function sets alarm hour in IRTC registers        */
/*                                                                            */
/* Input Parameters  : hour: a number from 0 to 23                            */
/*                                                                            */
/* Return Parameter  : 0 - success, 1 - failure                               */
/******************************************************************************/
unsigned char irtc_setAlarmHour(unsigned char hour);

/******************************************************************************/
/* FUNCTION          : irtc_setMin                                            */
/******************************************************************************/
/* Abstract          : This function sets the minutes in IRTC registers       */
/*                                                                            */
/* Input Parameters  : min: a number from 0 to 59                             */
/*                                                                            */
/* Return Parameter  : 0 - success, 1 - failure                               */
/******************************************************************************/
unsigned char irtc_setMin(unsigned char min);

/******************************************************************************/
/* FUNCTION          : irtc_setAlarmMin                                       */
/******************************************************************************/
/* Abstract          : This function sets alarm minutes in IRTC registers     */
/*                                                                            */
/* Input Parameters  : min: a number from 0 to 59                             */
/*                                                                            */
/* Return Parameter  : 0 - success, 1 - failure                               */
/******************************************************************************/
unsigned char irtc_setAlarmMin(unsigned char min);

/******************************************************************************/
/* FUNCTION          : irtc_setSeconds                                        */
/******************************************************************************/
/* Abstract          : This function sets the saeconds in IRTC registers      */
/*                                                                            */
/* Input Parameters  : sec: a number from 0 to 59                             */
/*                                                                            */
/* Return Parameter  : 0 - success, 1 - failure                               */
/******************************************************************************/
unsigned char irtc_setSeconds(unsigned char sec);

/******************************************************************************/
/* FUNCTION          : irtc_setAlarmSeconds                                   */
/******************************************************************************/
/* Abstract          : This function sets alarm seconds in IRTC registers     */
/*                                                                            */
/* Input Parameters  : sec: a number from 0 to 59                             */
/*                                                                            */
/* Return Parameter  : 0 - success, 1 - failure                               */
/******************************************************************************/
unsigned char irtc_setAlarmSeconds(unsigned char sec);

/******************************************************************************/
/* FUNCTION          : irtc_getYearOffset                                     */
/******************************************************************************/
/* Abstract          : This function gets the year offset in IRTC registers   */
/*                                                                            */
/* Input Parameters  : none                                                   */
/*                                                                            */
/* Return Parameter  : year offset value                                      */
/******************************************************************************/
#define irtc_getYearOffset()  IRTC_YEARMON_H

/******************************************************************************/
/* FUNCTION          : irtc_getMonth                                          */
/******************************************************************************/
/* Abstract          : This function gets the month in IRTC registers         */
/*                                                                            */
/* Input Parameters  : none                                                   */
/*                                                                            */
/* Return Parameter  : month value                                            */
/******************************************************************************/
#define irtc_getMonth()   IRTC_YEARMON_L_MONTH

/******************************************************************************/
/* FUNCTION          : irtc_getDay                                            */
/******************************************************************************/
/* Abstract          : This function gets the day in IRTC registers           */
/*                                                                            */
/* Input Parameters  : none                                                   */
/*                                                                            */
/* Return Parameter  : weekday: week day to be get                            */
/******************************************************************************/
#define irtc_getDay() IRTC_DAYS_H_DAY_OF_WEEK

/******************************************************************************/
/* FUNCTION          : irtc_getDate                                           */
/******************************************************************************/
/* Abstract          : This function gets the date in IRTC registers          */
/*                                                                            */
/* Input Parameters  : none                                                   */
/*                                                                            */
/* Return Parameter  : date: date to be get                                   */
/******************************************************************************/
#define irtc_getDate() IRTC_DAYS_L_DAYS


/******************************************************************************/
/* FUNCTION          : irtc_getHour                                           */
/******************************************************************************/
/* Abstract          : This function gets the hours in IRTC registers         */
/*                                                                            */
/* Input Parameters  : none                                                   */
/*                                                                            */
/* Return Parameter  : hour: a number from 0 to 23                            */
/******************************************************************************/
#define irtc_getHour()  IRTC_HOURMIN_H_HOURS

/******************************************************************************/
/* FUNCTION          : irtc_getMin                                            */
/******************************************************************************/
/* Abstract          : This function gets the minutes in IRTC registers       */
/*                                                                            */
/* Input Parameters  : none                                                   */
/*                                                                            */
/* Return Parameter  : min: a number from 0 to 59                             */
/******************************************************************************/
#define irtc_getMin()   IRTC_HOURMIN_L_MINUTES

/******************************************************************************/
/* FUNCTION          : irtc_getSeconds                                        */
/******************************************************************************/
/* Abstract          : This function gets the seconds in IRTC registers       */
/*                                                                            */
/* Input Parameters  : none                                                   */
/*                                                                            */
/* Return Parameter  : sec: a number from 0 to 59                             */
/******************************************************************************/
#define irtc_getSeconds()   IRTC_SECONDS_L_SECONDS

/******************************************************************************/
/* FUNCTION          : irtc_getAlarmYearOffset                                */
/******************************************************************************/
/* Abstract          : This function gets alarm year offset in IRTC registers */
/*                                                                            */
/* Input Parameters  : none                                                   */
/*                                                                            */
/* Return Parameter  : year offset value                                      */
/******************************************************************************/
#define irtc_getAlarmYearOffset()  IRTC_ALM_YRMON_H

/******************************************************************************/
/* FUNCTION          : irtc_getAlarmMonth                                     */
/******************************************************************************/
/* Abstract          : This function gets alarm month in IRTC registers       */
/*                                                                            */
/* Input Parameters  : none                                                   */
/*                                                                            */
/* Return Parameter  : month value                                            */
/******************************************************************************/
#define irtc_getAlarmMonth()   IRTC_ALM_YRMON_L_ALM_MONTH

/******************************************************************************/
/* FUNCTION          : irtc_getAlarmDate                                      */
/******************************************************************************/
/* Abstract          : This function gets alarm date in IRTC registers        */
/*                                                                            */
/* Input Parameters  : none                                                   */
/*                                                                            */
/* Return Parameter  : date: date to be get                                   */
/******************************************************************************/
#define irtc_getAlarmDate() IRTC_ALM_DAYS_L_ALM_DAYS


/******************************************************************************/
/* FUNCTION          : irtc_getAlarmHour                                      */
/******************************************************************************/
/* Abstract          : This function gets alarm hours in IRTC registers       */
/*                                                                            */
/* Input Parameters  : none                                                   */
/*                                                                            */
/* Return Parameter  : hour: a number from 0 to 23                            */
/******************************************************************************/
#define irtc_getAlarmHour()  IRTC_ALM_HM_H_ALM_HOURS

/******************************************************************************/
/* FUNCTION          : irtc_getAlarmMin                                       */
/******************************************************************************/
/* Abstract          : This function gets alarm minutes in IRTC registers     */
/*                                                                            */
/* Input Parameters  : none                                                   */
/*                                                                            */
/* Return Parameter  : min: a number from 0 to 59                             */
/******************************************************************************/
#define irtc_getAlarmMin()   IRTC_ALM_HM_L_ALM_MINUTES

/******************************************************************************/
/* FUNCTION          : irtc_getAlarmSeconds                                   */
/******************************************************************************/
/* Abstract          : This function gets alarm seconds in IRTC registers     */
/*                                                                            */
/* Input Parameters  : none                                                   */
/*                                                                            */
/* Return Parameter  : sec: a number from 0 to 59                             */
/******************************************************************************/
#define irtc_getAlarmSeconds()   IRTC_ALM_SEC_L_ALM_SECONDS

/******************************************************************************/
/* FUNCTION          : irtc_getTamperStampYearOffset                          */
/******************************************************************************/
/* Abstract          : This function gets tamper stamp year offset in IRTC    */
/*                                                                            */
/* Input Parameters  : none                                                   */
/*                                                                            */
/* Return Parameter  : year offset value                                      */
/******************************************************************************/
#define irtc_getTamperStampYearOffset()  IRTC_TTSR_YM_H

/******************************************************************************/
/* FUNCTION          : irtc_getTamperStampMonth                               */
/******************************************************************************/
/* Abstract          : This function gets tamper stamp month in IRTC          */
/*                                                                            */
/* Input Parameters  : none                                                   */
/*                                                                            */
/* Return Parameter  : month value                                            */
/******************************************************************************/
#define irtc_getTamperStampMonth()   IRTC_TTSR_YM_L_TIME_STAMP_MONTHS

/******************************************************************************/
/* FUNCTION          : irtc_getTamperStampDate                                */
/******************************************************************************/
/* Abstract          : This function gets tamper stamp date in IRTC registers */
/*                                                                            */
/* Input Parameters  : none                                                   */
/*                                                                            */
/* Return Parameter  : date: date to be get                                   */
/******************************************************************************/
#define irtc_getTamperStampDate() IRTC_TTSR_DAY_L_TIME_STAMP_DAY


/******************************************************************************/
/* FUNCTION          : irtc_getTamperStampHour                                */
/******************************************************************************/
/* Abstract          : This function gets tamper stamp hours in IRTC registers*/
/*                                                                            */
/* Input Parameters  : none                                                   */
/*                                                                            */
/* Return Parameter  : hour: a number from 0 to 23                            */
/******************************************************************************/
#define irtc_getTamperStampHour()  IRTC_TTSR_HM_H_TIME_STAMP_HOURS

/******************************************************************************/
/* FUNCTION          : irtc_getTamperStampMin                                 */
/******************************************************************************/
/* Abstract          : This function gets tamper stamp minutes in IRTC        */
/*                                                                            */
/* Input Parameters  : none                                                   */
/*                                                                            */
/* Return Parameter  : min: a number from 0 to 59                             */
/******************************************************************************/
#define irtc_getTamperStampMin()   IRTC_TTSR_HM_L_TIME_STAMP_MINUTES

/******************************************************************************/
/* FUNCTION          : irtc_getTamperStampSeconds                             */
/******************************************************************************/
/* Abstract          : This function gets tamper stamp seconds in IRTC        */
/*                                                                            */
/* Input Parameters  : none                                                   */
/*                                                                            */
/* Return Parameter  : sec: a number from 0 to 59                             */
/******************************************************************************/
#define irtc_getTamperStampSeconds()   IRTC_TTSR_SEC_L_TIME_STAMP_SECONDS

/******************************************************************************/
/* FUNCTION          : irtc_unprotectRegisters                                */
/******************************************************************************/
/* Abstract          : This function unprotects the IRTC registers for 2 sec  */
/*                                                                            */
/* Input Parameters  : none                                                   */
/*                                                                            */
/* Return Parameter  : none                                                   */
/******************************************************************************/
void irtc_unprotectRegisters(void);

/******************************************************************************/
/* FUNCTION          : irtc_protectRegisters                                  */
/******************************************************************************/
/* Abstract          : This function protects the IRTC registers              */
/*                                                                            */
/* Input Parameters  : none                                                   */
/*                                                                            */
/* Return Parameter  : none                                                   */
/******************************************************************************/
void irtc_protectRegisters(void);

#endif  /* #ifndef _RTC_DRIVER_INT_H_ */
