#ifndef _SCI_CONFIG_H
#define _SCI_CONFIG_H
#define BUS_CLK  16776195

/*selects the port for SCI1 Tx and Rx pins*/
#define SCI1_TxRx_PortC 1            //pin C5 as TXD1 & pin C4 as RXD1
#define SCI1_TxRx_PortB 0            //pin B1 as TXD1 & pin B0 as RXD1

#if ( (SCI1_TxRx_PortC && SCI1_TxRx_PortB) || !(SCI1_TxRx_PortC || SCI1_TxRx_PortB))
  #error "error SCI1_Port"           //error if both the ports are defined 1 or 0
#endif

/*selects the port for SCI2 Tx and Rx pins*/
#define SCI2_TxRx_PortA 1            //pin A5 as TXD1 & pin A4 as RXD1
#define SCI2_TxRx_PortB 0            //???????

#if ( (SCI2_TxRx_PortA && SCI2_TxRx_PortB) || !(SCI2_TxRx_PortA || SCI2_TxRx_PortB))
  #error "error SCI2_Port"           //error if both the ports are defined 1 or 0
#endif

/*selects the port for SCI3 Tx and Rx pins*/
#define SCI3_TxRx_PortC 1           //pin C5 as RXD3 & pin C6 as TXD3
#define SCI3_TxRx_PortG 0           //pin G4 as RXD3 & pin G5 as TXD3

#if ( (SCI3_TxRx_PortC && SCI3_TxRx_PortG) || !(SCI3_TxRx_PortC || SCI3_TxRx_PortG))
  #error "error SCI3_Port"          //error if both the ports are defined 1 or 0
#endif


/*selects the UART port for using printf function*/
#define UART_SEL 0            //selects the uart to use printf functions

#define INTERNAL_PULL_UP_SCI0  1       // TXD0 is internally pulled up to 3.3V

#endif