/* lcd_functions.c */
                   
/////////////////////////////////////////////////////////////////////////////////////////
// PrintString
// --------------------------------------------------------------------------------------
// Prints a string on the LCD
/////////////////////////////////////////////////////////////////////////////////////////
#include "lcd.h"
#include "MC9S08GW64.h"

extern unsigned char ir_command;

extern unsigned char blinkindex;

void lcd_PrintString(unsigned char *str)
{
  unsigned char i;
  /*for(i = 0; str[1] != 0;i++)
    ;*/
  for(i = 0; str[i] != 0;)
  {
    LCDPutChar(str[i], ++i);
  }
  while(i<=NUM_DIGITS)
  {
    LCDPutChar(' ', ++i);
  }
  
}

/////////////////////////////////////////////////////////////////////////////////////////
// SlideString
// --------------------------------------------------------------------------------------
// Slides strings on the LCD
/////////////////////////////////////////////////////////////////////////////////////////
void lcd_SlideString(unsigned char *str, unsigned char d)
{

  unsigned char i, j, start;

  for(i = 0; str[i] != 0; i++) 
  {
    //Delay(d);
    LCDClear();
    d++;
    if(i < NUM_DIGITS) 
      start = 0;
    else  
      start = i-NUM_DIGITS+1; 
    for(j = start; j <= i; j++)
      LCDPutChar(str[j], NUM_DIGITS-i+j);
  }
}

void DispHexVal(unsigned char val, unsigned char startloc)
{

  unsigned char ch[2];
    
  // High value
  if((val>>4) < 0x0A)
    ch[1] = '0' + (val>>4);
  else
    ch[1] = 'A' + (val>>4) - 0x0A;
  // Low value
  if((val&0x0F) < 0x0A)
    ch[0] = '0' + (val&0x0F);
  else
    ch[0] = 'A' + (val&0x0F) - 0x0A;
  
  LCDPutChar(ch[1], startloc);
  LCDPutChar(ch[0], startloc+1);
  
}
void DispDecVal(unsigned char val, unsigned char startloc)
{

  unsigned char ch[2],i,tempchar,location;
    
  // High value
  ch[0] = '0' + (val/10);
  // Low value
  ch[1] = '0' + (val%10);
  
  for(i = 0; i <= 1; i++)
  {
    location = startloc+i;
    tempchar = ch[i];

    if((location) == blinkindex)
      LCDPutChar(tempchar, location);
    else
      LCDPutChar(' ', location);

    LCDPutChar(tempchar, location);
  }
}

void lcd_disp(unsigned char *str)
{
  unsigned char i;
  
  for(i = 1; i <= 10;i++)
  {
    if(*str < 100)
    {
      //LCDPutChar(*str,i-1);
      DispDecVal(*str, i-1);
      i++;
      str++;
    }
    else if(*str == 0xFE)
    {

    }
    else
    {
      LCDPutChar(' ',i-1);
    }
    str++;
  }
}

void lcd_StopBlinking()
{
  LCDBCTL &= ~0x80;

}
