;/*******************************************************************************
;*
;* Freescale Semiconductor Inc.
;* (c) Copyright 2004-2006 Freescale Semiconductor, Inc.
;* (c) Copyright 2001-2004 Motorola, Inc.
;* ALL RIGHTS RESERVED.
;*
;********************************************************************************
;*
;* $File Name: math.asm$
;*
;* $Date:      Jul-20-2009$
;*
;* $Version:   0.0.3.0$
;*
;* $Author:    B12615 
;*
;* Description:
;*   File contains basic mathematical functions
;*
;* Modules Included:

;*   signed int add16(signed int x, signed int y)
;*   unsigned int uadd16(unsigned int x, unsigned int y)
;*   unsigned long uadd32(unsigned long x, unsigned long y)
;*   void uadd32_64(unsigned long x, UINT64 y)
;*   void add32_64(signed long x, UINT64 y)
;*   signed int sub16(signed int x, signed int y)
;*   unsigned int usub16(unsigned int x, unsigned int y)
;*   void umul32_32_64(unsigned long x, signed long y, UINT64 z)
;*
;*****************************************************************************/

;/*****************************************************************************
;*   External Symbol Definition
;*****************************************************************************/

; export symbols
            XDEF add16
            XDEF uadd16
            XDEF uadd32
            XDEF uadd32_64
            XDEF add32_64
            XDEF sub16
            XDEF usub16
            XDEF umul32_32_64


; variable/data section
MY_ZEROPAGE: SECTION  SHORT
; Insert here your data definition. For demonstration, temp_byte is used.

; code section
MyCode:     SECTION
; this assembly routine is called the C/C++ application


;/*****************************************************************************
;*
;* Module: void umul32_64(unsigned long x, unsigned long y, UINT64 z)
;*
;* Description:
;*    The function performs unsigned 32-bit multiplication x*y. 
;*    The 64-bit result is stored in z.
;*
;* Returns:   z = x + y
;*
;* Arguments: x (in) L1->9,SP L2->10,SP
;*                   H1->7,SP H2->8,SP
;*            
;*            y (in) L1->5,SP L2->6,SP
;*                   H1->3,SP H2->4,SP
;*                    
;*            *z(in) L->X  H->H
;*                   ;
;* Range Issues: None
;*
;* Special Issues:  typedef unsigned long UIN64[2]
;*                  The result is not saturated
;*
;*****************************************************************************/ 
       
      ;/******AFTER TEMPORERY STORAGE CREATION*********/
      ; opr1: L_2 -> 31,Sp L_1 -> 32,Sp <-->   H_2 -> 29,Sp H_1 -> 30,Sp   
      ; opr2: L_2 -> 27,Sp L_1 -> 28,Sp <--> H_2 ->25,Sp H_1 -> 26,Sp   
      ; result - L X(b)    H -> H(b)   poiter on result
      ;/******AFTER TEMPORERY STORAGE CREATION*********/

 umul32_32_64: 
  
           AIS #-20       ;[2] creation of the temporary storage on stack (20 byte)
                          ; 4x5 byte for intermediate results 1(3 - 7,SP), 2(8 - 12,SP)
                          ; 3(13 - 17,SP), 4(18 - 22,SP)  
           PSHX           ;[2] save result adress on stack Low - X(2,SP)
           PSHH           ;[2] save result adress on stack Hi - H(1,Sp)  
;-----------------------------------------------------
;                          [6]           
           
;*****************************************************           
;*********/***** multiply(x)*(y(LSB(2))***************
;*****************************************************

           LDA  28,SP     ;[4] y-LSB(2)
           LDX  32,SP     ;[4] x-LSB(2)
           MUL            ;[5] y-LSB(2) * x-LSB(2) = res1
           STA  3,SP      ;[4] ersult LSB
           STX  4,SP      ;[4] result MSB -> store row_1_0
           
           LDA  28,SP     ;[4] y-LSB(2)
           LDX  31,SP     ;[4] x-LSB(1)
           MUL            ;[5] y-LSB(2) * x-LSB(1) = res2
           ADD  4,SP      ;[4] res1 MSB + res2 LSB  
                    
           BCC  row_1_1   ;[3] if carry set, increment MSB
           INCX           ;[1] if carry, increment res2(2)
           
row_1_1:   STX  5,SP      ;[4] store res2 MSB
           STA  4,SP      ;[4] store res1 MSB + res2 LSB

           LDA  28,SP     ;[4] y-LSB(2)
           LDX  30,SP     ;[4] x-MSB(2)
           MUL            ;[5] y-LSB(2) * x-MSB(2) = res3
           ADD  5,SP      ;[4] res2 MSB + res3 LSB
           BCC  row_1_2   ;[3] if carry set, increment MSB  
           INCX           ;[1] if carry, increment res3 MSB
                     
row_1_2:   STX  6,SP      ;[4] store res3 MSB
           STA  5,SP      ;[4] store res2 MSB + res3 LSB
           
           LDA  28,SP     ;[4] y-LSB(2)
           LDX  29,SP     ;[4] x-MSB(1)
           MUL            ;[5] y-LSB(2) * x-MSB(1) = res4
           ADD  6,SP      ;[4] res3 MSB + res4 LSB
           BCC  row_1_3   ;[3] if carry set, increment MSB
           INCX           ;[1]if carry, increment res4 MSB
                      
row_1_3:   STX  7,SP      ;[4] store res4 MSB
           STA  6,SP      ;[4] store res3 MSB + res4 LSB
;                 -------------------------------
;                          [109] * 4 for all MSB&LSB multiplication           
           
;*****************************************************           
;*************** multiply(x)*(y(LSB(1))***************
;*****************************************************
           
           LDA  27,SP     ; y-LSB(1)
           LDX  32,SP     ; x-LSB(2)
           MUL            ; y-LSB(1) * x-LSB(2) = res1
           STA  8,SP      ; result LSB
           STX  9,SP      ; result MSB -> store row_2_0
           
           LDA  27,SP     ; y-LSB(1)
           LDX  31,SP     ; x-LSB(1)
           MUL            ; y-LSB(1) * x-LSB(1) = res2
           ADD  9,SP      ; res1 MSB + res2 LSB           
           BCC  row_2_1   ; if carry set, increment MSB         
           INCX           ; if carry, increment res2(2)
           
row_2_1:   STX  10,SP     ; store res2 MSB
           STA  9,SP      ; store res1 MSB + res2 LSB

           LDA  27,SP     ; y-LSB(1)
           LDX  30,SP     ; x-MSB(2)
           MUL            ; y-LSB(1) * x-MSB(2) = res3
           ADD  10,SP     ; res2 MSB + res3 LSB
           BCC  row_2_2   ; if carry set, increment MSB
           INCX           ; if carry, increment res3 MSB
                      
row_2_2:   STX  11,SP     ; store res3 MSB
           STA  10,SP     ; store res2 MSB + res3 LSB
           
           LDA  27,SP     ; y-LSB(1)
           LDX  29,SP     ; x-MSB(1)
           MUL            ; y-LSB(1) * x-MSB(1) = res4
           ADD  11,SP     ; res3 MSB + res4 LSB
           BCC  row_2_3   ; if carry set, increment MSB
           INCX           ; if carry, increment res4 MSB
                     
row_2_3:   STX  12,SP     ; store res4 MSB
           STA  11,SP     ; store res3 MSB + res4 LSB

;*****************************************************           
;*************** multiply(x)*(y(MSB(2))***************
;*****************************************************        

           LDA  26,SP     ; y-MSB(2)
           LDX  32,SP     ; x-LSB(2)
           MUL            ; y-MSB(2) * x-LSB(2) = res1
           STA  13,SP     ; result LSB
           STX  14,SP     ; result MSB -> row_3_0
           
           LDA  26,SP     ; y-MSB(2)
           LDX  31,SP     ; x-LSB(1)
           MUL            ; y-MSB(2) * x-LSB(1) = res2
           ADD  14,SP     ; res1 MSB + res2 LSB           
           BCC  row_3_1   ; if carry set, increment MSB
           INCX           ; if carry, increment res2 MSB
           
row_3_1:   STX  15,SP     ; store res2 MSB
           STA  14,SP     ; store res1 MSB + res2 LSB

           LDA  26,SP     ; y-MSB(2)
           LDX  30,SP     ; x-MSB(2)
           MUL            ; y-MSB(2) * x-MSB(2) = res3
           ADD  15,SP     ; res2 MSB + res3 LSB
           BCC  row_3_2   ; if carry set, increment MSB
           INCX           ; if carry, increment res3 MSB
                     
row_3_2:   STX  16,SP     ; store res3 MSB
           STA  15,SP     ; store res2 MSB + res3 LSB
           
           LDA  26,SP     ; y-MSB(1)
           LDX  29,SP     ; x-MSB(1)
           MUL            ; y-mSB(1) * x-MSB(1) = res4
           ADD  16,SP     ; res3 MSB + res4 LSB
           BCC  row_3_3   ; if carry set, increment MSB
           INCX           ; if carry, increment res4 MSB
                    
row_3_3:   STX  17,SP     ; store res4 MSB
           STA  16,SP     ; store res3 MSB + res4 LSB
           
;*****************************************************           
;*************** multiply(x)*(y(MSB(1))***************
;*****************************************************        

           LDA  25,SP     ; y-MSB(1)
           LDX  32,SP     ; x-LSB(2)
           MUL            ; y-MSB(1) * x-LSB(2) = res1
           STA  18,SP     ; result LSB
           STX  19,SP     ; result MSB -> row_4_0
           
           LDA  25,SP     ; y-MSB(1)
           LDX  31,SP     ; x-LSB(1)
           MUL            ; y-MSB(1) * x-LSB(1) = res2
           ADD  19,SP     ; res1 MSB + res2 LSB           
           BCC  row_4_1   ; if carry set, increment MSB
           INCX           ; if carry, increment res2 MSB
           
row_4_1:   STX  20,SP     ; store res2 MSB
           STA  19,SP     ; store res1 MSB + res2 LSB

           LDA  25,SP     ; y-MSB(1)
           LDX  30,SP     ; x-MSB(2)
           MUL            ; y-MSB(1) * x-MSB(2) = res3
           ADD  20,SP     ; res2 MSB + res3 LSB
           BCC  row_4_2   ; if carry set, increment MSB
           INCX           ; if carry, increment res3 MSB
                          
row_4_2:   STX  21,SP     ; store res3 MSB
           STA  20,SP     ; store res2 MSB + res3 LSB
           
           LDA  25,SP     ; y-MSB(1)
           LDX  29,SP     ; x-MSB(1)
           MUL            ; y-MSB(1) * x-MSB(1) = res4
           ADD  21,SP     ; res2 MSB + res3 LSB
           BCC  row_4_3   ; if carry set, increment MSB
           INCX           ; if carry, increment res4 MSB
                    
row_4_3:   STX  22,SP     ; store res4 MSB
           STA  21,SP     ; store res3 MSB + res4 LSB

;*****************************************************           
;********** addition of intermediate results *********
;****and store final result to destination address****
;*****************************************************          

           PULH           ;[3] load dress ofresult MSB
           PULX           ;[3] load dress ofresult LSB
                          ; SP - 2
                             
           LDA  1,SP      ;[4]
           STA  7,X       ;[2] store LSB(4) of result
           
           LDA  2,SP      ;[4]
           ADD  6,SP      ;[4]
           STA  6,X       ;[2] store LSB(3) of result
           
           LDA  3,SP      ;[4]
           ADC  7,SP      ;[4]
           STA  5,X       ;[2] store LSB(2) of result
              
           LDA  4,SP      ;[4]
           ADC  8,SP      ;[4]
           STA  4,X       ;[2] store LSB(1) of result
           
           LDA  5,SP      ;[4]
           ADC  9,SP      ;[4]
           STA  3,X       ;[2] store MSB(3) of result
           
           LDA  10,SP     ;[4]
           ADC  14,SP     ;[4]
           STA  2,X       ;[2] store MSB(2) of result
           
           LDA  15,SP     ;[4]
           ADC  19,SP     ;[4]
           STA  1,X       ;[2] store MSB(2) of result
           
           LDA  20, SP    ;[4] MSB(1) of result
           BCC  _incr     ;[3] branch if next carry will not set
           INCA           ;[1] increment without carry -> never overflow
                           ;[80] 
_incr      STA  0,X       ;[2] store MSB(1) of result

           LDA  5,X       ;[2] load LSB(2) to accumulator
           ADD  11,SP     ;[4]
           STA  5,X       ;[2] 
           
           LDA  4,X       ;[2] load LSB(1) to accumulator
           ADC  12,SP     ;[4]
           STA  4,X       ;[2]
           
           LDA  3,X       ;[2] load MSB(4) to accumulator
           ADC  13,SP     ;[1]
           STA  3,X       ;[2]
           
           LDA  2,X       ;[2] load MSB(3) to accumulator
           ADC  18,SP     ;[1]
           STA  2,X       ;[2] store MSB(3) of result
           
           BCC  _incr1    ;[3] if carry set, increment MSB(2)
           LDA  1,X       ;[3] load MSB(2) to accumulator  
           ADC  #0        ;[2] increment with ADC -> carry
           STA  1,X       ;[3] store inceremented MSB(2)
           
           BCC  _incr1    ;[3] if carry set, increment MSB(1)
           INC  0,X       ;[4] increment without carry -> never overflow
                           ;[46]
_incr1:    LDA  4,X       ;[2] load LSB(1) to accumulator
           ADD  16,SP     ;[4]
           STA  4,X       ;[2] store LSB(1) of result
           
           LDA  3,X       ;[2] load MSB(4) to accumulator
           ADC  17,SP     ;[4]
           STA  3,X       ;[2] store MSB(4) of result
                      
           BCC  _incr2    ;[3] if carry set, increment MSB(3)
           LDA  2,X       ;[3] load MSB(3) to accumulator 
           ADC  #0        ;[2] increment with ADC -> carry
           STA  2,X       ;[3] store inceremented MSB(3)
           
           BCC  _incr2    ;[3] if carry set, increment MSB(2)
           LDA  1,X       ;[3] load MSB(2) to accumulator
           ADC  #0        ;[2] increment with ADC -> carry
           STA  1,X       ;[3] store inceremented MSB(2)
           
           BCC  _incr2    ;[3] if carry set, increment MSB(1)
           INC  0,X       ;[4] increment without carry -> never overflow
          
           
;*****************************************************           
;********** addition of intermediate results *********
;****and store final result to destination address****
;*****************************************************  
           
_incr2:    AIS  #20       ;[2] clear temporary storage
           RTS            ;[6] END
                           ;[53]
;                    -----------------
;                         [179]
;----------------------------------------------------
;                     max.[615]  
     
;/*****************************************************************************
;*
;* Module: signed int add16(signed int x, signed int y)
;*
;* Description:
;*   The function performs the addition x+y with overflow control
;*   and saturation. The 16-bit result is set at +32767 when overflow occurs,
;*   or at -32768 when underflow occurs.
;*
;* Returns:   x + y
;*
;* Arguments: x (in) L->4,SP H->3,SP
;*            y (in) L->X;   H->H
;*
;* Range Issues: None
;*
;* Special Issues: The result is saturated
;*
;*****************************************************************************/
;  /* (V - Overflow Flag, N - Negative flag) */
;  /* V=1 & N=1 too high */
;  /* V=1 & N=0 too low  */ 

add16: 
           
           TXA                 ;[1] y-LSB in accumulator
           ADD  4,SP           ;[4] ADD y-LSB + x-LSB
           PSHA                ;[2] save result of firt addition on stack
           PSHH                ;[2] save y-MSB on stack
           PULA                ;[3] load accumulator with y-MSB
           ADC  4,SP           ;[4] ADC y-MSB + x-MSB + carry           
           PSHA                ;[2] save result of second addition on stack
           PULH                ;[3] load H with second result (MSB)
           PULX                ;[3] load X with first result  (LSB)
        
           BLT  _negative      ;[3] branch if V=0 & N=1 or V=1 & N=0        
           BPL  __end          ;[3] branch if result(H:X) possitive, V = 0 & N = 0 -> legal operation
           LDHX #$7FFF         ;[3] V = 1 & N = 1 -> overflow  
           RTS                 ;    END

_negative: BMI  __end          ;[3] branch if result(H:X) negative, V = 0 & N = 1 -> legal operation    
           LDHX #$8000			   ;[3] V = 1 & N = 0 -> underflow
__end:     RTS                 ;[6] END
;-----------------------------------------------------------------------------
;                           max.[45]   


 ;/*****************************************************************************
;*
;* Module: signed int sub16(signed int x, signed int y)
;*
;* Description:
;*   The function performs the 16-bit subtraction x-y with overflow control
;*   and saturation. The 16-bit result is set at +32767 when overflow occurs,
;*   or at -32768 when underflow occurs.
;*
;* Returns:   x - y
;*
;* Arguments: x (in) L->4,SP H->3,SP
;*            y (in) L->X;   H->H
;*
;* Range Issues: None
;*
;* Special Issues: The result is saturated
;*                 #define sub16(x,y)   sub16(y,x)
;*****************************************************************************/
;  /* (V - Overflow Flag, N - Negative flag) */
;  /* V=1 & N=1 too high */
;  /* V=1 & N=0 too low  */ 

sub16:    
           TXA                  ;[1] y-LSB in accumulator
           SUB  4,SP            ;[4] SUB y-LSB - x-LSB
           PSHA                 ;[2] save result of firt substraction on stack
           PSHH                 ;[2] save y-MSB on stack
           PULA                 ;[3] load accumulator with y-MSB
           SBC  4,SP            ;[4] ADC y-MSB - x-MSB - carry           
           PSHA                 ;[2] save result of second substraction on stack
           PULH                 ;[3] load H with second result (MSB)
           PULX                 ;[3] load X with first result  (LSB)
       
           BLT  __negative      ;[3] branch if V=0 & N=1 or V=1 & N=0        
           BPL  _end_           ;[3] branch if result(H:X) possitive, V = 0 & N = 0 -> legal operation
           LDHX #$7FFF          ;[3] V = 1 & N = 1 -> overflow  
           RTS                  ;    END

__negative:BMI  _end_           ;[3] branch if result(H:X) negative, V = 0 & N = 1 -> legal operation    
           LDHX #$8000			    ;[3] V = 1 & N = 0 -> underflow
_end_:     RTS                  ;[6] END
;-----------------------------------------------------------------------------
;                            max.[45]          

        
;/*****************************************************************************
;*
;* Module: unsigned int uadd16(unsigned int x, unsigned int y)
;*
;* Description:
;*    The function performs unsigned 16-bit addition x+y with overflow control 
;*    and saturation. The 16-bit result is set at +65534 when overflow occurs.
;*
;* Returns:   x + y
;*
;* Arguments: x (in) L->4,SP H->3,SP
;*            y (in) L->X;   H->H
;*
;* Range Issues: None
;*
;* Special Issues: The result is saturated
;*
;*****************************************************************************/        

uadd16:

           TXA                 ;[1] y-LSB in accumulator
           ADD  4,SP           ;[4] ADD y-LSB + x-LSB
           PSHA                ;[2] save result of firt addition on stack
           PSHH                ;[2] save H(y) on stack
           PULA                ;[3] load accumulator with H(b)
           ADC  4,SP           ;[4] ADC H(y) + H(x) + carry            
           PSHA                ;[2] save result of second addition on stack
           PULH                ;[3] load H with second result (MSB)
           PULX                ;[3] load X with first result (LSB)        
           
           BCC  _end           ;[3] branch if carry is not set,legal operation    
           LDHX #$FFFF      	 ;[3] saturation
           RTS                 ;[6] END
;------------------------------------------------------------------------
;                           max.[36]  


 ;/*****************************************************************************
;*
;* Module: unsigned int usub16(unsigned int x, unsigned int y)
;*
;* Description:
;*   The function performs the unsigned 16-bit subtraction x-y with underflow
;*   control. The 16-bit result is set at 0 when underflow occurs.
;*
;* Returns:   x - y
;*
;* Arguments: x (in) L->4,SP H->3,SP
;*            y (in) L->X;   H->H
;*
;* Range Issues: None
;*
;* Special Issues: The result is saturated
;*                 #define usub16(x,y)   usub16(y,x)
;*****************************************************************************/

usub16: 
           TXA              ;[1] y-LSB in accumulator
           SUB  4,SP        ;[4] ADD y-LSB + x-LSB
           PSHA             ;[2] save result of firt addition on stack
           PSHH             ;[2] save y-MSB on stack
           PULA             ;[3] load accumulator with y-MSB
           SBC  4,SP        ;[4] ADC y-MSB + x-MSB + carry           
           BCS  carryset    ;[3] branch if carry set
           PSHA             ;[2] save result of second addition on stack
           PULH             ;[3] load H with second result (MSB)
           PULX             ;[3] load X with first result  (LSB)
           RTS              ;[6] END
carryset:
           PULH             ;[3] move high byte from stack to A
           CLRH             ;[1] clear H
           CLRX             ;[1] clear X
           RTS              ;[6] END
;---------------------------------------------------------------------------
;                        max.[38]           
           
;/*****************************************************************************
;*
;* Module: unsigned long uadd32(unsigned long x, unsigned long y)
;*
;* Description:
;*    The function performs unsigned 32-bit addition x+y with overflow control 
;*    and saturation. The 32-bit result is set at +4294967295 when overflow occurs.
;*
;* Returns:   z = x + y
;*
;* Arguments: *z(in) L->12,SP H->11,SP
;*            
;*            x (in) L1->9,SP L2->10,SP
;*                   H1->7,SP H2->8,SP
;*                    
;*            y (in) L1->5,SP; L2->6,SP;
;*                   H1->3,SP; H2->4,SP;                   
;*
;* Range Issues: None
;*
;* Special Issues: The result is saturated
;*
;*****************************************************************************/  
    
 uadd32:
 
           LDHX 11,SP         ;[4] load *z to H:X           
           LDA  10,SP         ;[4] x-LSB(2)
           ADD  6,SP          ;[4] x-LSB(2) + y-LSB(2)
           STA  3,X           ;[3] LSB(2) -> z
           
           LDA  9,SP          ;[4] x-LSB(1)
           ADC  5,SP          ;[4] x-LSB(1) + y-LSB(1)
           STA  2,X           ;[3] LSB(1) -> z
           
           LDA  8,SP          ;[4] x-MSB(2)
           ADC  4,SP          ;[4] x-MSB(2) + y-MSB(2)
           STA  1,X           ;[3] MSB(2) -> z
           
           LDA  7,SP          ;[4] x-MSB(1)
           ADC  3,SP          ;[4] x-MSB(1) + y-MSB(1)
           STA  0,X           ;[3] MSB(1) -> z
                      
           BCC  _end          ;[3] if carry clear -> end,if set -> overflow
;                         ----------------
;                              [51]
;                                
           LDA  #$FF          ;[2] load accumulator - 0xFF value
           STA  0,X           ;[3] store FF in MSB(1)
           STA  1,X           ;[3] store FF in MSB(2)
           STA  2,X           ;[3] store FF in LSB(1)
           STA  3,X           ;[3] store FF in LSB(2)
           RTS                ;[6] end
;                        ----------------
;                              [20] 
;-----------------------------------------------------------------------
;                          max.[71]
  
          
;/*****************************************************************************
;*
;* Module: void uadd32_64(unsigned long x, UINT64 y)
;*
;* Description:
;*    The function performs addition of unsigned 32-bit number with unsigned 64-bit number (x+y). 
;*    The 64-bit result is stored in y.
;*
;* Returns:   x + y
;*
;* Arguments: x (in) L1->5,SP L2->6,SP
;*                   H1->3,SP H2->4,SP
;*                    
;*            *y (in) L->X; H->H;                   
;*
;* Range Issues: None
;*
;* Special Issues:  typedef unsigned long UIN64[2]
;*                  The result is not saturated
;*
;*****************************************************************************/  
      
uadd32_64:

           LDA  6,SP        ;[4] x-LSB(2)
           ADD  7,X         ;[3] x-LSB(2) + y-LSB(4)
           STA  7,X         ;[3] store addition
           
           LDA  5,SP        ;[4] x-LSB(1)
           ADC  6,X         ;[3] x-LSB(1) + y-LSB(3)
           STA  6,X         ;[3] store addition
           
           LDA  4,SP        ;[4] x-MSB(2)
           ADC  5,X         ;[3] x-MSB(1) + y-LSB(2)
           STA  5,X         ;[3] store addition
           
           LDA  3,SP        ;[4] x-MSB(1)
           ADC  4,X         ;[3] x-MSB(1) + y-LSB(1)
           STA  4,X         ;[3] store addition
;                    ----------------------
;                             [40]    
        
           BCC  _end        ;[3] if carry clear -> END, if set increment  
           LDA  3,X         ;[3] load y-MSB(4) to accumulator
           ADC  #0          ;[2]
           STA  3,X         ;[3] save incremented y-MSB(4)
           
           BCC  _end        ;[3] if carry clear -> END, if set increment  
           LDA  2,X         ;[3] load y-MSB(3) to accumulator 
           ADC  #0          ;[2] increment y-MSB(3)
           STA  2,X         ;[3] save incremented y-MSB(3)
           
           BCC  _end        ;[3] if carry clear -> END, if set increment  
           LDA  1,X         ;[3] load y-MSB(2) to accumulator 
           ADC  #0          ;[2] increment y-MSB(2)
           STA  1,X         ;[3] save incremented y-MSB(2)
          
           BCC  _end        ;[3] if carry clear -> END, if set increment 
           INC  0,X         ;[4] increment y-MSB(1)  
                   
_end:      RTS              ;[6] END        
;-----------------------------------------------------------------------
;                        max.[86] 
         
;/*****************************************************************************
;*
;* Module: void add32_64(signed long x, UINT64 y)
;*
;* Description:
;*    The function performs addition of unsigned 32-bit number with unsigned 64-bit number (x+y). 
;*    The 64-bit result is stored in y.
;*
;* Returns:   x + y
;*
;* Arguments: x (in) L1->5,SP L2->6,SP
;*                   H1->3,SP H2->4,SP
;*                    
;*            *y (in) L->X; H->H;                   
;*
;* Range Issues: None
;*
;* Special Issues:  typedef unsigned long UIN64[2]
;*                  The result is not saturated
;*
;*****************************************************************************/  
      
add32_64:

           LDA  6,SP        ;[4] x-LSB(2)
           ADD  7,X         ;[3] x-LSB(2) + y-LSB(4)
           STA  7,X         ;[3] store addition
           
           LDA  5,SP        ;[4] x-LSB(1)
           ADC  6,X         ;[3] x-LSB(1) + y-LSB(3)
           STA  6,X         ;[3] store addition
           
           LDA  4,SP        ;[4] x-MSB(2)
           ADC  5,X         ;[3] x-MSB(1) + y-LSB(2)
           STA  5,X         ;[3] store addition
           
           LDA  3,SP        ;[4] x-MSB(1)
           BLT  __NEG       ;[3] jupm if N exOR V = 1
           
           ADC  4,X         ;[3] x-MSB(1) + y-LSB(1)
           STA  4,X         ;[3] store addition
;                    ----------------------
;                             [43]

           BCC  _End        ;[3] if carry clear -> END, if set increment  
           LDA  3,X         ;[3] load y-MSB(4) to accumulator
           ADC  #0          ;[2]
           STA  3,X         ;[3] save incremented y-MSB(4)
           
           BCC  _End        ;[3] if carry clear -> END, if set increment  
           LDA  2,X         ;[3] load y-MSB(3) to accumulator 
           ADC  #0          ;[2] increment y-MSB(3)
           STA  2,X         ;[3] save incremented y-MSB(3)
           
           BCC  _End        ;[3] if carry clear -> END, if set increment  
           LDA  1,X         ;[3] load y-MSB(2) to accumulator 
           ADC  #0          ;[2] increment y-MSB(2)
           STA  1,X         ;[3] save incremented y-MSB(2)
          
           BCC  _End        ;[3] if carry clear -> END, if set increment 
           INC  0,X         ;[4] increment y-MSB(1)             
           RTS              ;[6] END
;-----------------------------------------------------------------------
;                             [89]
__NEG:
           ADC  4,X         ;[3] x-MSB(1) + y-LSB(1)
           STA  4,X         ;[3] store addition

           BCS  _End        ;[3] if carry set -> END, if clear deccrement  
           LDA  3,X         ;[3] load y-MSB(4) to accumulator
           SUB  #1          ;[2]
           STA  3,X         ;[3] save incremented y-MSB(4)
           
           BCC  _End        ;[3] if carry clear -> END, if set increment  
           LDA  2,X         ;[3] load y-MSB(3) to accumulator 
           SBC  #0          ;[2] decrement y-MSB(3)
           STA  2,X         ;[3] save cecremented y-MSB(3)
           
           BCC  _End        ;[3] if carry clear -> END, if set increment  
           LDA  1,X         ;[3] load y-MSB(2) to accumulator 
           SBC  #0          ;[2] decrement y-MSB(2)
           STA  1,X         ;[3] save decremented y-MSB(2)
          
           BCC  _End        ;[3] if carry clear -> END, if set increment 
           DEC  0,X         ;[4] decrement y-MSB(1)            
_End:      RTS              ;[6] END        
;-----------------------------------------------------------------------
;                             ;[89] 
           
           

           
           
          
           
           
           
           
           
           
           
           
           
           
           
           
           
           
           
           
           
           
           
           
           
           
        