/* Based on CPU DB MC9S08GW64_80, version 3.00.000 (RegistersPrg V2.31) */
/*
** ###################################################################
**     Filename  : mc9s08gw64.h
**     Processor : MC9S08GW64
**     FileFormat: V2.31
**     DataSheet : MC9S08GW64RM Rev.1 9/2009
**     Compiler  : CodeWarrior compiler
**     Date/Time : 15.10.2009, 8:57
**     Abstract  :
**         This header implements the mapping of I/O devices.
**
**     Copyright : 1997 - 2009 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
**
**     CPU Registers Revisions:
**               - none
**
**     File-Format-Revisions:
**               - none
**
**     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
**     derivative device. To avoid extra current drain from floating input pins, the users reset
**     initialization routine in the application program must either enable on-chip pull-up devices
**     or change the direction of unconnected pins to outputs so the pins do not float.
** ###################################################################
*/

#ifndef _MC9S08GW64_H
#define _MC9S08GW64_H

/* Types definition */
typedef unsigned char byte;
typedef unsigned int word;
typedef unsigned long dword;
typedef unsigned long dlong[2];

/* Watchdog reset macro */
#ifndef __RESET_WATCHDOG
#ifdef _lint
  #define __RESET_WATCHDOG()  /* empty */
#else
  #define __RESET_WATCHDOG() (void)(SRS = 0x55, SRS = 0xAA)
#endif
#endif /* __RESET_WATCHDOG */

#define REG_BASE 0x0000                /* Base address for the I/O register block */


#pragma MESSAGE DISABLE C1106 /* WARNING C1106: Non-standard bitfield type */

/**************** interrupt vector numbers ****************/
#define VectorNumber_Vpdb               52
#define VectorNumber_Vpdb_err           51
#define VectorNumber_Vlcd               50
#define VectorNumber_Virtc              49
#define VectorNumber_Vkbi               48
#define VectorNumber_VReserved45        47
#define VectorNumber_VReserved44        46
#define VectorNumber_VReserved43        45
#define VectorNumber_VReserved42        44
#define VectorNumber_VReserved41        43
#define VectorNumber_VReserved40        42
#define VectorNumber_VReserved39        41
#define VectorNumber_VReserved38        40
#define VectorNumber_VReserved37        39
#define VectorNumber_VReserved36        38
#define VectorNumber_VReserved35        37
#define VectorNumber_VReserved34        36
#define VectorNumber_VReserved33        35
#define VectorNumber_VReserved32        34
#define VectorNumber_VReserved31        33
#define VectorNumber_VReserved30        32
#define VectorNumber_Vpcnt              31
#define VectorNumber_Vcmp2              30
#define VectorNumber_Vcmp1              29
#define VectorNumber_Vcmp0              28
#define VectorNumber_Vadc1              27
#define VectorNumber_Vadc0              26
#define VectorNumber_Vmtim3             25
#define VectorNumber_Vmtim2             24
#define VectorNumber_Vmtim1             23
#define VectorNumber_Vftmch1            22
#define VectorNumber_Vftmch0            21
#define VectorNumber_Vftmovf            20
#define VectorNumber_Viic               19
#define VectorNumber_Vspi2              18
#define VectorNumber_Vspi1              17
#define VectorNumber_Vspi0              16
#define VectorNumber_Vsci3tx            15
#define VectorNumber_Vsci3rx            14
#define VectorNumber_Vsci3err           13
#define VectorNumber_Vsci2tx            12
#define VectorNumber_Vsci2rx            11
#define VectorNumber_Vsci2err           10
#define VectorNumber_Vsci1tx            9
#define VectorNumber_Vsci1rx            8
#define VectorNumber_Vsci1err           7
#define VectorNumber_Vsci0tx            6
#define VectorNumber_Vsci0rx            5
#define VectorNumber_Vsci0err           4
#define VectorNumber_Vlvd               3
#define VectorNumber_Virq               2
#define VectorNumber_Vswi               1
#define VectorNumber_Vreset             0

/**************** interrupt vector table ****************/
#define Vpdb                            0x0000FF96
#define Vpdb_err                        0x0000FF98
#define Vlcd                            0x0000FF9A
#define Virtc                           0x0000FF9C
#define Vkbi                            0x0000FF9E
#define VReserved45                     0x0000FFA0
#define VReserved44                     0x0000FFA2
#define VReserved43                     0x0000FFA4
#define VReserved42                     0x0000FFA6
#define VReserved41                     0x0000FFA8
#define VReserved40                     0x0000FFAA
#define VReserved39                     0x0000FFAC
#define VReserved38                     0x0000FFAE
#define VReserved37                     0x0000FFB0
#define VReserved36                     0x0000FFB2
#define VReserved35                     0x0000FFB4
#define VReserved34                     0x0000FFB6
#define VReserved33                     0x0000FFB8
#define VReserved32                     0x0000FFBA
#define VReserved31                     0x0000FFBC
#define VReserved30                     0x0000FFBE
#define Vpcnt                           0x0000FFC0
#define Vcmp2                           0x0000FFC2
#define Vcmp1                           0x0000FFC4
#define Vcmp0                           0x0000FFC6
#define Vadc1                           0x0000FFC8
#define Vadc0                           0x0000FFCA
#define Vmtim3                          0x0000FFCC
#define Vmtim2                          0x0000FFCE
#define Vmtim1                          0x0000FFD0
#define Vftmch1                         0x0000FFD2
#define Vftmch0                         0x0000FFD4
#define Vftmovf                         0x0000FFD6
#define Viic                            0x0000FFD8
#define Vspi2                           0x0000FFDA
#define Vspi1                           0x0000FFDC
#define Vspi0                           0x0000FFDE
#define Vsci3tx                         0x0000FFE0
#define Vsci3rx                         0x0000FFE2
#define Vsci3err                        0x0000FFE4
#define Vsci2tx                         0x0000FFE6
#define Vsci2rx                         0x0000FFE8
#define Vsci2err                        0x0000FFEA
#define Vsci1tx                         0x0000FFEC
#define Vsci1rx                         0x0000FFEE
#define Vsci1err                        0x0000FFF0
#define Vsci0tx                         0x0000FFF2
#define Vsci0rx                         0x0000FFF4
#define Vsci0err                        0x0000FFF6
#define Vlvd                            0x0000FFF8
#define Virq                            0x0000FFFA
#define Vswi                            0x0000FFFC
#define Vreset                          0x0000FFFE

/**************** registers I/O map ****************/

/*** PTAD - Port A Data Register; 0x00000000 ***/
typedef union {
  byte Byte;
  struct {
    byte PTAD0       :1;                                       /* Port A Data Register Bit 0 */
    byte PTAD1       :1;                                       /* Port A Data Register Bit 1 */
    byte PTAD2       :1;                                       /* Port A Data Register Bit 2 */
    byte PTAD3       :1;                                       /* Port A Data Register Bit 3 */
    byte PTAD4       :1;                                       /* Port A Data Register Bit 4 */
    byte PTAD5       :1;                                       /* Port A Data Register Bit 5 */
    byte PTAD6       :1;                                       /* Port A Data Register Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpPTAD :7;
    byte         :1;
  } MergedBits;
} PTADSTR;
extern volatile PTADSTR _PTAD @0x00000000;
#define PTAD                            _PTAD.Byte
#define PTAD_PTAD0                      _PTAD.Bits.PTAD0
#define PTAD_PTAD1                      _PTAD.Bits.PTAD1
#define PTAD_PTAD2                      _PTAD.Bits.PTAD2
#define PTAD_PTAD3                      _PTAD.Bits.PTAD3
#define PTAD_PTAD4                      _PTAD.Bits.PTAD4
#define PTAD_PTAD5                      _PTAD.Bits.PTAD5
#define PTAD_PTAD6                      _PTAD.Bits.PTAD6
#define PTAD_PTAD                       _PTAD.MergedBits.grpPTAD

#define PTAD_PTAD0_MASK                 1
#define PTAD_PTAD1_MASK                 2
#define PTAD_PTAD2_MASK                 4
#define PTAD_PTAD3_MASK                 8
#define PTAD_PTAD4_MASK                 16
#define PTAD_PTAD5_MASK                 32
#define PTAD_PTAD6_MASK                 64
#define PTAD_PTAD_MASK                  127
#define PTAD_PTAD_BITNUM                0


/*** PTADD - Port A Data Direction Register; 0x00000001 ***/
typedef union {
  byte Byte;
  struct {
    byte PTADD0      :1;                                       /* Data Direction for Port A Bit 0 */
    byte PTADD1      :1;                                       /* Data Direction for Port A Bit 1 */
    byte PTADD2      :1;                                       /* Data Direction for Port A Bit 2 */
    byte PTADD3      :1;                                       /* Data Direction for Port A Bit 3 */
    byte PTADD4      :1;                                       /* Data Direction for Port A Bit 4 */
    byte PTADD5      :1;                                       /* Data Direction for Port A Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTADD :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTADDSTR;
extern volatile PTADDSTR _PTADD @0x00000001;
#define PTADD                           _PTADD.Byte
#define PTADD_PTADD0                    _PTADD.Bits.PTADD0
#define PTADD_PTADD1                    _PTADD.Bits.PTADD1
#define PTADD_PTADD2                    _PTADD.Bits.PTADD2
#define PTADD_PTADD3                    _PTADD.Bits.PTADD3
#define PTADD_PTADD4                    _PTADD.Bits.PTADD4
#define PTADD_PTADD5                    _PTADD.Bits.PTADD5
#define PTADD_PTADD                     _PTADD.MergedBits.grpPTADD

#define PTADD_PTADD0_MASK               1
#define PTADD_PTADD1_MASK               2
#define PTADD_PTADD2_MASK               4
#define PTADD_PTADD3_MASK               8
#define PTADD_PTADD4_MASK               16
#define PTADD_PTADD5_MASK               32
#define PTADD_PTADD_MASK                63
#define PTADD_PTADD_BITNUM              0


/*** PTBD - Port B Data Register; 0x00000002 ***/
typedef union {
  byte Byte;
  struct {
    byte PTBD0       :1;                                       /* Port B Data Register Bit 0 */
    byte PTBD1       :1;                                       /* Port B Data Register Bit 1 */
    byte PTBD2       :1;                                       /* Port B Data Register Bit 2 */
    byte PTBD3       :1;                                       /* Port B Data Register Bit 3 */
    byte PTBD4       :1;                                       /* Port B Data Register Bit 4 */
    byte PTBD5       :1;                                       /* Port B Data Register Bit 5 */
    byte PTBD6       :1;                                       /* Port B Data Register Bit 6 */
    byte PTBD7       :1;                                       /* Port B Data Register Bit 7 */
  } Bits;
} PTBDSTR;
extern volatile PTBDSTR _PTBD @0x00000002;
#define PTBD                            _PTBD.Byte
#define PTBD_PTBD0                      _PTBD.Bits.PTBD0
#define PTBD_PTBD1                      _PTBD.Bits.PTBD1
#define PTBD_PTBD2                      _PTBD.Bits.PTBD2
#define PTBD_PTBD3                      _PTBD.Bits.PTBD3
#define PTBD_PTBD4                      _PTBD.Bits.PTBD4
#define PTBD_PTBD5                      _PTBD.Bits.PTBD5
#define PTBD_PTBD6                      _PTBD.Bits.PTBD6
#define PTBD_PTBD7                      _PTBD.Bits.PTBD7

#define PTBD_PTBD0_MASK                 1
#define PTBD_PTBD1_MASK                 2
#define PTBD_PTBD2_MASK                 4
#define PTBD_PTBD3_MASK                 8
#define PTBD_PTBD4_MASK                 16
#define PTBD_PTBD5_MASK                 32
#define PTBD_PTBD6_MASK                 64
#define PTBD_PTBD7_MASK                 128


/*** PTBDD - Port B Data Direction Register; 0x00000003 ***/
typedef union {
  byte Byte;
  struct {
    byte PTBDD0      :1;                                       /* Data Direction for Port B Bit 0 */
    byte PTBDD1      :1;                                       /* Data Direction for Port B Bit 1 */
    byte PTBDD2      :1;                                       /* Data Direction for Port B Bit 2 */
    byte PTBDD3      :1;                                       /* Data Direction for Port B Bit 3 */
    byte PTBDD4      :1;                                       /* Data Direction for Port B Bit 4 */
    byte PTBDD5      :1;                                       /* Data Direction for Port B Bit 5 */
    byte PTBDD6      :1;                                       /* Data Direction for Port B Bit 6 */
    byte PTBDD7      :1;                                       /* Data Direction for Port B Bit 7 */
  } Bits;
} PTBDDSTR;
extern volatile PTBDDSTR _PTBDD @0x00000003;
#define PTBDD                           _PTBDD.Byte
#define PTBDD_PTBDD0                    _PTBDD.Bits.PTBDD0
#define PTBDD_PTBDD1                    _PTBDD.Bits.PTBDD1
#define PTBDD_PTBDD2                    _PTBDD.Bits.PTBDD2
#define PTBDD_PTBDD3                    _PTBDD.Bits.PTBDD3
#define PTBDD_PTBDD4                    _PTBDD.Bits.PTBDD4
#define PTBDD_PTBDD5                    _PTBDD.Bits.PTBDD5
#define PTBDD_PTBDD6                    _PTBDD.Bits.PTBDD6
#define PTBDD_PTBDD7                    _PTBDD.Bits.PTBDD7

#define PTBDD_PTBDD0_MASK               1
#define PTBDD_PTBDD1_MASK               2
#define PTBDD_PTBDD2_MASK               4
#define PTBDD_PTBDD3_MASK               8
#define PTBDD_PTBDD4_MASK               16
#define PTBDD_PTBDD5_MASK               32
#define PTBDD_PTBDD6_MASK               64
#define PTBDD_PTBDD7_MASK               128


/*** PTCD - Port C Data Register; 0x00000004 ***/
typedef union {
  byte Byte;
  struct {
    byte PTCD0       :1;                                       /* Port C Data Register Bit 0 */
    byte PTCD1       :1;                                       /* Port C Data Register Bit 1 */
    byte PTCD2       :1;                                       /* Port C Data Register Bit 2 */
    byte PTCD3       :1;                                       /* Port C Data Register Bit 3 */
    byte PTCD4       :1;                                       /* Port C Data Register Bit 4 */
    byte PTCD5       :1;                                       /* Port C Data Register Bit 5 */
    byte PTCD6       :1;                                       /* Port C Data Register Bit 6 */
    byte PTCD7       :1;                                       /* Port C Data Register Bit 7 */
  } Bits;
} PTCDSTR;
extern volatile PTCDSTR _PTCD @0x00000004;
#define PTCD                            _PTCD.Byte
#define PTCD_PTCD0                      _PTCD.Bits.PTCD0
#define PTCD_PTCD1                      _PTCD.Bits.PTCD1
#define PTCD_PTCD2                      _PTCD.Bits.PTCD2
#define PTCD_PTCD3                      _PTCD.Bits.PTCD3
#define PTCD_PTCD4                      _PTCD.Bits.PTCD4
#define PTCD_PTCD5                      _PTCD.Bits.PTCD5
#define PTCD_PTCD6                      _PTCD.Bits.PTCD6
#define PTCD_PTCD7                      _PTCD.Bits.PTCD7

#define PTCD_PTCD0_MASK                 1
#define PTCD_PTCD1_MASK                 2
#define PTCD_PTCD2_MASK                 4
#define PTCD_PTCD3_MASK                 8
#define PTCD_PTCD4_MASK                 16
#define PTCD_PTCD5_MASK                 32
#define PTCD_PTCD6_MASK                 64
#define PTCD_PTCD7_MASK                 128


/*** PTCDD - Port C Data Direction Register; 0x00000005 ***/
typedef union {
  byte Byte;
  struct {
    byte PTCDD0      :1;                                       /* Data Direction for Port C Bit 0 */
    byte PTCDD1      :1;                                       /* Data Direction for Port C Bit 1 */
    byte PTCDD2      :1;                                       /* Data Direction for Port C Bit 2 */
    byte PTCDD3      :1;                                       /* Data Direction for Port C Bit 3 */
    byte PTCDD4      :1;                                       /* Data Direction for Port C Bit 4 */
    byte PTCDD5      :1;                                       /* Data Direction for Port C Bit 5 */
    byte PTCDD6      :1;                                       /* Data Direction for Port C Bit 6 */
    byte PTCDD7      :1;                                       /* Data Direction for Port C Bit 7 */
  } Bits;
} PTCDDSTR;
extern volatile PTCDDSTR _PTCDD @0x00000005;
#define PTCDD                           _PTCDD.Byte
#define PTCDD_PTCDD0                    _PTCDD.Bits.PTCDD0
#define PTCDD_PTCDD1                    _PTCDD.Bits.PTCDD1
#define PTCDD_PTCDD2                    _PTCDD.Bits.PTCDD2
#define PTCDD_PTCDD3                    _PTCDD.Bits.PTCDD3
#define PTCDD_PTCDD4                    _PTCDD.Bits.PTCDD4
#define PTCDD_PTCDD5                    _PTCDD.Bits.PTCDD5
#define PTCDD_PTCDD6                    _PTCDD.Bits.PTCDD6
#define PTCDD_PTCDD7                    _PTCDD.Bits.PTCDD7

#define PTCDD_PTCDD0_MASK               1
#define PTCDD_PTCDD1_MASK               2
#define PTCDD_PTCDD2_MASK               4
#define PTCDD_PTCDD3_MASK               8
#define PTCDD_PTCDD4_MASK               16
#define PTCDD_PTCDD5_MASK               32
#define PTCDD_PTCDD6_MASK               64
#define PTCDD_PTCDD7_MASK               128


/*** PTDD - Port D Data Register; 0x00000006 ***/
typedef union {
  byte Byte;
  struct {
    byte PTDD0       :1;                                       /* Port D Data Register Bit 0 */
    byte PTDD1       :1;                                       /* Port D Data Register Bit 1 */
    byte PTDD2       :1;                                       /* Port D Data Register Bit 2 */
    byte PTDD3       :1;                                       /* Port D Data Register Bit 3 */
    byte PTDD4       :1;                                       /* Port D Data Register Bit 4 */
    byte PTDD5       :1;                                       /* Port D Data Register Bit 5 */
    byte PTDD6       :1;                                       /* Port D Data Register Bit 6 */
    byte PTDD7       :1;                                       /* Port D Data Register Bit 7 */
  } Bits;
} PTDDSTR;
extern volatile PTDDSTR _PTDD @0x00000006;
#define PTDD                            _PTDD.Byte
#define PTDD_PTDD0                      _PTDD.Bits.PTDD0
#define PTDD_PTDD1                      _PTDD.Bits.PTDD1
#define PTDD_PTDD2                      _PTDD.Bits.PTDD2
#define PTDD_PTDD3                      _PTDD.Bits.PTDD3
#define PTDD_PTDD4                      _PTDD.Bits.PTDD4
#define PTDD_PTDD5                      _PTDD.Bits.PTDD5
#define PTDD_PTDD6                      _PTDD.Bits.PTDD6
#define PTDD_PTDD7                      _PTDD.Bits.PTDD7

#define PTDD_PTDD0_MASK                 1
#define PTDD_PTDD1_MASK                 2
#define PTDD_PTDD2_MASK                 4
#define PTDD_PTDD3_MASK                 8
#define PTDD_PTDD4_MASK                 16
#define PTDD_PTDD5_MASK                 32
#define PTDD_PTDD6_MASK                 64
#define PTDD_PTDD7_MASK                 128


/*** PTDDD - Port D Data Direction Register; 0x00000007 ***/
typedef union {
  byte Byte;
  struct {
    byte PTDDD0      :1;                                       /* Data Direction for Port D Bit 0 */
    byte PTDDD1      :1;                                       /* Data Direction for Port D Bit 1 */
    byte PTDDD2      :1;                                       /* Data Direction for Port D Bit 2 */
    byte PTDDD3      :1;                                       /* Data Direction for Port D Bit 3 */
    byte PTDDD4      :1;                                       /* Data Direction for Port D Bit 4 */
    byte PTDDD5      :1;                                       /* Data Direction for Port D Bit 5 */
    byte PTDDD6      :1;                                       /* Data Direction for Port D Bit 6 */
    byte PTDDD7      :1;                                       /* Data Direction for Port D Bit 7 */
  } Bits;
} PTDDDSTR;
extern volatile PTDDDSTR _PTDDD @0x00000007;
#define PTDDD                           _PTDDD.Byte
#define PTDDD_PTDDD0                    _PTDDD.Bits.PTDDD0
#define PTDDD_PTDDD1                    _PTDDD.Bits.PTDDD1
#define PTDDD_PTDDD2                    _PTDDD.Bits.PTDDD2
#define PTDDD_PTDDD3                    _PTDDD.Bits.PTDDD3
#define PTDDD_PTDDD4                    _PTDDD.Bits.PTDDD4
#define PTDDD_PTDDD5                    _PTDDD.Bits.PTDDD5
#define PTDDD_PTDDD6                    _PTDDD.Bits.PTDDD6
#define PTDDD_PTDDD7                    _PTDDD.Bits.PTDDD7

#define PTDDD_PTDDD0_MASK               1
#define PTDDD_PTDDD1_MASK               2
#define PTDDD_PTDDD2_MASK               4
#define PTDDD_PTDDD3_MASK               8
#define PTDDD_PTDDD4_MASK               16
#define PTDDD_PTDDD5_MASK               32
#define PTDDD_PTDDD6_MASK               64
#define PTDDD_PTDDD7_MASK               128


/*** PTED - Port E Data Register; 0x00000008 ***/
typedef union {
  byte Byte;
  struct {
    byte PTED0       :1;                                       /* Port E Data Register Bit 0 */
    byte PTED1       :1;                                       /* Port E Data Register Bit 1 */
    byte PTED2       :1;                                       /* Port E Data Register Bit 2 */
    byte PTED3       :1;                                       /* Port E Data Register Bit 3 */
    byte PTED4       :1;                                       /* Port E Data Register Bit 4 */
    byte PTED5       :1;                                       /* Port E Data Register Bit 5 */
    byte PTED6       :1;                                       /* Port E Data Register Bit 6 */
    byte PTED7       :1;                                       /* Port E Data Register Bit 7 */
  } Bits;
} PTEDSTR;
extern volatile PTEDSTR _PTED @0x00000008;
#define PTED                            _PTED.Byte
#define PTED_PTED0                      _PTED.Bits.PTED0
#define PTED_PTED1                      _PTED.Bits.PTED1
#define PTED_PTED2                      _PTED.Bits.PTED2
#define PTED_PTED3                      _PTED.Bits.PTED3
#define PTED_PTED4                      _PTED.Bits.PTED4
#define PTED_PTED5                      _PTED.Bits.PTED5
#define PTED_PTED6                      _PTED.Bits.PTED6
#define PTED_PTED7                      _PTED.Bits.PTED7

#define PTED_PTED0_MASK                 1
#define PTED_PTED1_MASK                 2
#define PTED_PTED2_MASK                 4
#define PTED_PTED3_MASK                 8
#define PTED_PTED4_MASK                 16
#define PTED_PTED5_MASK                 32
#define PTED_PTED6_MASK                 64
#define PTED_PTED7_MASK                 128


/*** PTEDD - Port E Data Direction Register; 0x00000009 ***/
typedef union {
  byte Byte;
  struct {
    byte PTEDD0      :1;                                       /* Data Direction for Port E Bit 0 */
    byte PTEDD1      :1;                                       /* Data Direction for Port E Bit 1 */
    byte PTEDD2      :1;                                       /* Data Direction for Port E Bit 2 */
    byte PTEDD3      :1;                                       /* Data Direction for Port E Bit 3 */
    byte PTEDD4      :1;                                       /* Data Direction for Port E Bit 4 */
    byte PTEDD5      :1;                                       /* Data Direction for Port E Bit 5 */
    byte PTEDD6      :1;                                       /* Data Direction for Port E Bit 6 */
    byte PTEDD7      :1;                                       /* Data Direction for Port E Bit 7 */
  } Bits;
} PTEDDSTR;
extern volatile PTEDDSTR _PTEDD @0x00000009;
#define PTEDD                           _PTEDD.Byte
#define PTEDD_PTEDD0                    _PTEDD.Bits.PTEDD0
#define PTEDD_PTEDD1                    _PTEDD.Bits.PTEDD1
#define PTEDD_PTEDD2                    _PTEDD.Bits.PTEDD2
#define PTEDD_PTEDD3                    _PTEDD.Bits.PTEDD3
#define PTEDD_PTEDD4                    _PTEDD.Bits.PTEDD4
#define PTEDD_PTEDD5                    _PTEDD.Bits.PTEDD5
#define PTEDD_PTEDD6                    _PTEDD.Bits.PTEDD6
#define PTEDD_PTEDD7                    _PTEDD.Bits.PTEDD7

#define PTEDD_PTEDD0_MASK               1
#define PTEDD_PTEDD1_MASK               2
#define PTEDD_PTEDD2_MASK               4
#define PTEDD_PTEDD3_MASK               8
#define PTEDD_PTEDD4_MASK               16
#define PTEDD_PTEDD5_MASK               32
#define PTEDD_PTEDD6_MASK               64
#define PTEDD_PTEDD7_MASK               128


/*** PTFD - Port F Data Register; 0x0000000A ***/
typedef union {
  byte Byte;
  struct {
    byte PTFD0       :1;                                       /* Port F Data Register Bit 0 */
    byte PTFD1       :1;                                       /* Port F Data Register Bit 1 */
    byte PTFD2       :1;                                       /* Port F Data Register Bit 2 */
    byte PTFD3       :1;                                       /* Port F Data Register Bit 3 */
    byte PTFD4       :1;                                       /* Port F Data Register Bit 4 */
    byte PTFD5       :1;                                       /* Port F Data Register Bit 5 */
    byte PTFD6       :1;                                       /* Port F Data Register Bit 6 */
    byte PTFD7       :1;                                       /* Port F Data Register Bit 7 */
  } Bits;
} PTFDSTR;
extern volatile PTFDSTR _PTFD @0x0000000A;
#define PTFD                            _PTFD.Byte
#define PTFD_PTFD0                      _PTFD.Bits.PTFD0
#define PTFD_PTFD1                      _PTFD.Bits.PTFD1
#define PTFD_PTFD2                      _PTFD.Bits.PTFD2
#define PTFD_PTFD3                      _PTFD.Bits.PTFD3
#define PTFD_PTFD4                      _PTFD.Bits.PTFD4
#define PTFD_PTFD5                      _PTFD.Bits.PTFD5
#define PTFD_PTFD6                      _PTFD.Bits.PTFD6
#define PTFD_PTFD7                      _PTFD.Bits.PTFD7

#define PTFD_PTFD0_MASK                 1
#define PTFD_PTFD1_MASK                 2
#define PTFD_PTFD2_MASK                 4
#define PTFD_PTFD3_MASK                 8
#define PTFD_PTFD4_MASK                 16
#define PTFD_PTFD5_MASK                 32
#define PTFD_PTFD6_MASK                 64
#define PTFD_PTFD7_MASK                 128


/*** PTFDD - Port F Data Direction Register; 0x0000000B ***/
typedef union {
  byte Byte;
  struct {
    byte PTFDD0      :1;                                       /* Data Direction for Port F Bit 0 */
    byte PTFDD1      :1;                                       /* Data Direction for Port F Bit 1 */
    byte PTFDD2      :1;                                       /* Data Direction for Port F Bit 2 */
    byte PTFDD3      :1;                                       /* Data Direction for Port F Bit 3 */
    byte PTFDD4      :1;                                       /* Data Direction for Port F Bit 4 */
    byte PTFDD5      :1;                                       /* Data Direction for Port F Bit 5 */
    byte PTFDD6      :1;                                       /* Data Direction for Port F Bit 6 */
    byte PTFDD7      :1;                                       /* Data Direction for Port F Bit 7 */
  } Bits;
} PTFDDSTR;
extern volatile PTFDDSTR _PTFDD @0x0000000B;
#define PTFDD                           _PTFDD.Byte
#define PTFDD_PTFDD0                    _PTFDD.Bits.PTFDD0
#define PTFDD_PTFDD1                    _PTFDD.Bits.PTFDD1
#define PTFDD_PTFDD2                    _PTFDD.Bits.PTFDD2
#define PTFDD_PTFDD3                    _PTFDD.Bits.PTFDD3
#define PTFDD_PTFDD4                    _PTFDD.Bits.PTFDD4
#define PTFDD_PTFDD5                    _PTFDD.Bits.PTFDD5
#define PTFDD_PTFDD6                    _PTFDD.Bits.PTFDD6
#define PTFDD_PTFDD7                    _PTFDD.Bits.PTFDD7

#define PTFDD_PTFDD0_MASK               1
#define PTFDD_PTFDD1_MASK               2
#define PTFDD_PTFDD2_MASK               4
#define PTFDD_PTFDD3_MASK               8
#define PTFDD_PTFDD4_MASK               16
#define PTFDD_PTFDD5_MASK               32
#define PTFDD_PTFDD6_MASK               64
#define PTFDD_PTFDD7_MASK               128


/*** PTGD - Port G Data Register; 0x0000000C ***/
typedef union {
  byte Byte;
  struct {
    byte PTGD0       :1;                                       /* Port G Data Register Bit 0 */
    byte PTGD1       :1;                                       /* Port G Data Register Bit 1 */
    byte PTGD2       :1;                                       /* Port G Data Register Bit 2 */
    byte PTGD3       :1;                                       /* Port G Data Register Bit 3 */
    byte PTGD4       :1;                                       /* Port G Data Register Bit 4 */
    byte PTGD5       :1;                                       /* Port G Data Register Bit 5 */
    byte PTGD6       :1;                                       /* Port G Data Register Bit 6 */
    byte PTGD7       :1;                                       /* Port G Data Register Bit 7 */
  } Bits;
} PTGDSTR;
extern volatile PTGDSTR _PTGD @0x0000000C;
#define PTGD                            _PTGD.Byte
#define PTGD_PTGD0                      _PTGD.Bits.PTGD0
#define PTGD_PTGD1                      _PTGD.Bits.PTGD1
#define PTGD_PTGD2                      _PTGD.Bits.PTGD2
#define PTGD_PTGD3                      _PTGD.Bits.PTGD3
#define PTGD_PTGD4                      _PTGD.Bits.PTGD4
#define PTGD_PTGD5                      _PTGD.Bits.PTGD5
#define PTGD_PTGD6                      _PTGD.Bits.PTGD6
#define PTGD_PTGD7                      _PTGD.Bits.PTGD7

#define PTGD_PTGD0_MASK                 1
#define PTGD_PTGD1_MASK                 2
#define PTGD_PTGD2_MASK                 4
#define PTGD_PTGD3_MASK                 8
#define PTGD_PTGD4_MASK                 16
#define PTGD_PTGD5_MASK                 32
#define PTGD_PTGD6_MASK                 64
#define PTGD_PTGD7_MASK                 128


/*** PTGDD - Port G Data Direction Register; 0x0000000D ***/
typedef union {
  byte Byte;
  struct {
    byte PTGDD0      :1;                                       /* Data Direction for Port G Bit 0 */
    byte PTGDD1      :1;                                       /* Data Direction for Port G Bit 1 */
    byte PTGDD2      :1;                                       /* Data Direction for Port G Bit 2 */
    byte PTGDD3      :1;                                       /* Data Direction for Port G Bit 3 */
    byte PTGDD4      :1;                                       /* Data Direction for Port G Bit 4 */
    byte PTGDD5      :1;                                       /* Data Direction for Port G Bit 5 */
    byte PTGDD6      :1;                                       /* Data Direction for Port G Bit 6 */
    byte PTGDD7      :1;                                       /* Data Direction for Port G Bit 7 */
  } Bits;
} PTGDDSTR;
extern volatile PTGDDSTR _PTGDD @0x0000000D;
#define PTGDD                           _PTGDD.Byte
#define PTGDD_PTGDD0                    _PTGDD.Bits.PTGDD0
#define PTGDD_PTGDD1                    _PTGDD.Bits.PTGDD1
#define PTGDD_PTGDD2                    _PTGDD.Bits.PTGDD2
#define PTGDD_PTGDD3                    _PTGDD.Bits.PTGDD3
#define PTGDD_PTGDD4                    _PTGDD.Bits.PTGDD4
#define PTGDD_PTGDD5                    _PTGDD.Bits.PTGDD5
#define PTGDD_PTGDD6                    _PTGDD.Bits.PTGDD6
#define PTGDD_PTGDD7                    _PTGDD.Bits.PTGDD7

#define PTGDD_PTGDD0_MASK               1
#define PTGDD_PTGDD1_MASK               2
#define PTGDD_PTGDD2_MASK               4
#define PTGDD_PTGDD3_MASK               8
#define PTGDD_PTGDD4_MASK               16
#define PTGDD_PTGDD5_MASK               32
#define PTGDD_PTGDD6_MASK               64
#define PTGDD_PTGDD7_MASK               128


/*** PTHD - Port H Data Register; 0x0000000E ***/
typedef union {
  byte Byte;
  struct {
    byte PTHD0       :1;                                       /* Port H Data Register Bit 0 */
    byte PTHD1       :1;                                       /* Port H Data Register Bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTHD :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTHDSTR;
extern volatile PTHDSTR _PTHD @0x0000000E;
#define PTHD                            _PTHD.Byte
#define PTHD_PTHD0                      _PTHD.Bits.PTHD0
#define PTHD_PTHD1                      _PTHD.Bits.PTHD1
#define PTHD_PTHD                       _PTHD.MergedBits.grpPTHD

#define PTHD_PTHD0_MASK                 1
#define PTHD_PTHD1_MASK                 2
#define PTHD_PTHD_MASK                  3
#define PTHD_PTHD_BITNUM                0


/*** PTHDD - Port H Data Direction Register; 0x0000000F ***/
typedef union {
  byte Byte;
  struct {
    byte PTHDD0      :1;                                       /* Data Direction for Port H Bit 0 */
    byte PTHDD1      :1;                                       /* Data Direction for Port H Bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTHDD :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTHDDSTR;
extern volatile PTHDDSTR _PTHDD @0x0000000F;
#define PTHDD                           _PTHDD.Byte
#define PTHDD_PTHDD0                    _PTHDD.Bits.PTHDD0
#define PTHDD_PTHDD1                    _PTHDD.Bits.PTHDD1
#define PTHDD_PTHDD                     _PTHDD.MergedBits.grpPTHDD

#define PTHDD_PTHDD0_MASK               1
#define PTHDD_PTHDD1_MASK               2
#define PTHDD_PTHDD_MASK                3
#define PTHDD_PTHDD_BITNUM              0


/*** MTIM1SC - MTIM Clock Configuration Register; 0x00000010 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TSTP        :1;                                       /* MTIM Counter Stop */
    byte TRST        :1;                                       /* MTIM Counter Reset */
    byte TOIE        :1;                                       /* MTIM Overflow Interrupt Enable */
    byte TOF         :1;                                       /* MTIM Overflow Flag */
  } Bits;
} MTIM1SCSTR;
extern volatile MTIM1SCSTR _MTIM1SC @0x00000010;
#define MTIM1SC                         _MTIM1SC.Byte
#define MTIM1SC_TSTP                    _MTIM1SC.Bits.TSTP
#define MTIM1SC_TRST                    _MTIM1SC.Bits.TRST
#define MTIM1SC_TOIE                    _MTIM1SC.Bits.TOIE
#define MTIM1SC_TOF                     _MTIM1SC.Bits.TOF

#define MTIM1SC_TSTP_MASK               16
#define MTIM1SC_TRST_MASK               32
#define MTIM1SC_TOIE_MASK               64
#define MTIM1SC_TOF_MASK                128


/*** MTIM1CLK - MTIM Clock Configuration Register; 0x00000011 ***/
typedef union {
  byte Byte;
  struct {
    byte PS0         :1;                                       /* Clock source Prescaler Bit 0 */
    byte PS1         :1;                                       /* Clock source Prescaler Bit 1 */
    byte PS2         :1;                                       /* Clock source Prescaler Bit 2 */
    byte PS3         :1;                                       /* Clock source Prescaler Bit 3 */
    byte CLKS0       :1;                                       /* Clock source Select Bit 0 */
    byte CLKS1       :1;                                       /* Clock source Select Bit 1 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPS   :4;
    byte grpCLKS :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} MTIM1CLKSTR;
extern volatile MTIM1CLKSTR _MTIM1CLK @0x00000011;
#define MTIM1CLK                        _MTIM1CLK.Byte
#define MTIM1CLK_PS0                    _MTIM1CLK.Bits.PS0
#define MTIM1CLK_PS1                    _MTIM1CLK.Bits.PS1
#define MTIM1CLK_PS2                    _MTIM1CLK.Bits.PS2
#define MTIM1CLK_PS3                    _MTIM1CLK.Bits.PS3
#define MTIM1CLK_CLKS0                  _MTIM1CLK.Bits.CLKS0
#define MTIM1CLK_CLKS1                  _MTIM1CLK.Bits.CLKS1
#define MTIM1CLK_PS                     _MTIM1CLK.MergedBits.grpPS
#define MTIM1CLK_CLKS                   _MTIM1CLK.MergedBits.grpCLKS

#define MTIM1CLK_PS0_MASK               1
#define MTIM1CLK_PS1_MASK               2
#define MTIM1CLK_PS2_MASK               4
#define MTIM1CLK_PS3_MASK               8
#define MTIM1CLK_CLKS0_MASK             16
#define MTIM1CLK_CLKS1_MASK             32
#define MTIM1CLK_PS_MASK                15
#define MTIM1CLK_PS_BITNUM              0
#define MTIM1CLK_CLKS_MASK              48
#define MTIM1CLK_CLKS_BITNUM            4


/*** MTIM1CNT - MTIM Counter Register; 0x00000012 ***/
typedef union {
  byte Byte;
} MTIM1CNTSTR;
extern volatile MTIM1CNTSTR _MTIM1CNT @0x00000012;
#define MTIM1CNT                        _MTIM1CNT.Byte


/*** MTIM1MOD - MTIM Modulo Register; 0x00000013 ***/
typedef union {
  byte Byte;
} MTIM1MODSTR;
extern volatile MTIM1MODSTR _MTIM1MOD @0x00000013;
#define MTIM1MOD                        _MTIM1MOD.Byte


/*** MTIM2SC - MTIM Clock Configuration Register; 0x00000014 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TSTP        :1;                                       /* MTIM Counter Stop */
    byte TRST        :1;                                       /* MTIM Counter Reset */
    byte TOIE        :1;                                       /* MTIM Overflow Interrupt Enable */
    byte TOF         :1;                                       /* MTIM Overflow Flag */
  } Bits;
} MTIM2SCSTR;
extern volatile MTIM2SCSTR _MTIM2SC @0x00000014;
#define MTIM2SC                         _MTIM2SC.Byte
#define MTIM2SC_TSTP                    _MTIM2SC.Bits.TSTP
#define MTIM2SC_TRST                    _MTIM2SC.Bits.TRST
#define MTIM2SC_TOIE                    _MTIM2SC.Bits.TOIE
#define MTIM2SC_TOF                     _MTIM2SC.Bits.TOF

#define MTIM2SC_TSTP_MASK               16
#define MTIM2SC_TRST_MASK               32
#define MTIM2SC_TOIE_MASK               64
#define MTIM2SC_TOF_MASK                128


/*** MTIM2CLK - MTIM Clock Configuration Register; 0x00000015 ***/
typedef union {
  byte Byte;
  struct {
    byte PS0         :1;                                       /* Clock source Prescaler Bit 0 */
    byte PS1         :1;                                       /* Clock source Prescaler Bit 1 */
    byte PS2         :1;                                       /* Clock source Prescaler Bit 2 */
    byte PS3         :1;                                       /* Clock source Prescaler Bit 3 */
    byte CLKS0       :1;                                       /* Clock source Select Bit 0 */
    byte CLKS1       :1;                                       /* Clock source Select Bit 1 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPS   :4;
    byte grpCLKS :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} MTIM2CLKSTR;
extern volatile MTIM2CLKSTR _MTIM2CLK @0x00000015;
#define MTIM2CLK                        _MTIM2CLK.Byte
#define MTIM2CLK_PS0                    _MTIM2CLK.Bits.PS0
#define MTIM2CLK_PS1                    _MTIM2CLK.Bits.PS1
#define MTIM2CLK_PS2                    _MTIM2CLK.Bits.PS2
#define MTIM2CLK_PS3                    _MTIM2CLK.Bits.PS3
#define MTIM2CLK_CLKS0                  _MTIM2CLK.Bits.CLKS0
#define MTIM2CLK_CLKS1                  _MTIM2CLK.Bits.CLKS1
#define MTIM2CLK_PS                     _MTIM2CLK.MergedBits.grpPS
#define MTIM2CLK_CLKS                   _MTIM2CLK.MergedBits.grpCLKS

#define MTIM2CLK_PS0_MASK               1
#define MTIM2CLK_PS1_MASK               2
#define MTIM2CLK_PS2_MASK               4
#define MTIM2CLK_PS3_MASK               8
#define MTIM2CLK_CLKS0_MASK             16
#define MTIM2CLK_CLKS1_MASK             32
#define MTIM2CLK_PS_MASK                15
#define MTIM2CLK_PS_BITNUM              0
#define MTIM2CLK_CLKS_MASK              48
#define MTIM2CLK_CLKS_BITNUM            4


/*** MTIM2CNT - MTIM Counter Register; 0x00000016 ***/
typedef union {
  byte Byte;
} MTIM2CNTSTR;
extern volatile MTIM2CNTSTR _MTIM2CNT @0x00000016;
#define MTIM2CNT                        _MTIM2CNT.Byte


/*** MTIM2MOD - MTIM Modulo Register; 0x00000017 ***/
typedef union {
  byte Byte;
} MTIM2MODSTR;
extern volatile MTIM2MODSTR _MTIM2MOD @0x00000017;
#define MTIM2MOD                        _MTIM2MOD.Byte


/*** MTIM3SC - MTIM16 Status and Control Register; 0x00000018 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte TSTP        :1;                                       /* MTIM16 Counter Stop */
    byte TRST        :1;                                       /* MTIM16 Counter Reset */
    byte TOIE        :1;                                       /* MTIM16 Overflow Interrupt Enable */
    byte TOF         :1;                                       /* MTIM16 Overflow Flag */
  } Bits;
} MTIM3SCSTR;
extern volatile MTIM3SCSTR _MTIM3SC @0x00000018;
#define MTIM3SC                         _MTIM3SC.Byte
#define MTIM3SC_TSTP                    _MTIM3SC.Bits.TSTP
#define MTIM3SC_TRST                    _MTIM3SC.Bits.TRST
#define MTIM3SC_TOIE                    _MTIM3SC.Bits.TOIE
#define MTIM3SC_TOF                     _MTIM3SC.Bits.TOF

#define MTIM3SC_TSTP_MASK               16
#define MTIM3SC_TRST_MASK               32
#define MTIM3SC_TOIE_MASK               64
#define MTIM3SC_TOF_MASK                128


/*** MTIM3CLK - MTIM16 Clock Configuration Register; 0x00000019 ***/
typedef union {
  byte Byte;
  struct {
    byte PS0         :1;                                       /* Clock source Prescaler Bit 0 */
    byte PS1         :1;                                       /* Clock source Prescaler Bit 1 */
    byte PS2         :1;                                       /* Clock source Prescaler Bit 2 */
    byte PS3         :1;                                       /* Clock source Prescaler Bit 3 */
    byte CLKS0       :1;                                       /* Clock source Select Bit 0 */
    byte CLKS1       :1;                                       /* Clock source Select Bit 1 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPS   :4;
    byte grpCLKS :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} MTIM3CLKSTR;
extern volatile MTIM3CLKSTR _MTIM3CLK @0x00000019;
#define MTIM3CLK                        _MTIM3CLK.Byte
#define MTIM3CLK_PS0                    _MTIM3CLK.Bits.PS0
#define MTIM3CLK_PS1                    _MTIM3CLK.Bits.PS1
#define MTIM3CLK_PS2                    _MTIM3CLK.Bits.PS2
#define MTIM3CLK_PS3                    _MTIM3CLK.Bits.PS3
#define MTIM3CLK_CLKS0                  _MTIM3CLK.Bits.CLKS0
#define MTIM3CLK_CLKS1                  _MTIM3CLK.Bits.CLKS1
#define MTIM3CLK_PS                     _MTIM3CLK.MergedBits.grpPS
#define MTIM3CLK_CLKS                   _MTIM3CLK.MergedBits.grpCLKS

#define MTIM3CLK_PS0_MASK               1
#define MTIM3CLK_PS1_MASK               2
#define MTIM3CLK_PS2_MASK               4
#define MTIM3CLK_PS3_MASK               8
#define MTIM3CLK_CLKS0_MASK             16
#define MTIM3CLK_CLKS1_MASK             32
#define MTIM3CLK_PS_MASK                15
#define MTIM3CLK_PS_BITNUM              0
#define MTIM3CLK_CLKS_MASK              48
#define MTIM3CLK_CLKS_BITNUM            4


/*** MTIM3CNT - MTIM16 Counter Register; 0x0000001A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MTIM3CNTH - MTIM16 Counter Register High; 0x0000001A ***/
    union {
      byte Byte;
    } MTIM3CNTHSTR;
    #define MTIM3CNTH                   _MTIM3CNT.Overlap_STR.MTIM3CNTHSTR.Byte
    

    /*** MTIM3CNTL - MTIM16 Counter Register Low; 0x0000001B ***/
    union {
      byte Byte;
    } MTIM3CNTLSTR;
    #define MTIM3CNTL                   _MTIM3CNT.Overlap_STR.MTIM3CNTLSTR.Byte
    
  } Overlap_STR;

} MTIM3CNTSTR;
extern volatile MTIM3CNTSTR _MTIM3CNT @0x0000001A;
#define MTIM3CNT                        _MTIM3CNT.Word


/*** MTIM3MOD - MTIM16 Modulo Register; 0x0000001C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** MTIM3MODH - MTIM16 Modulo Register High; 0x0000001C ***/
    union {
      byte Byte;
    } MTIM3MODHSTR;
    #define MTIM3MODH                   _MTIM3MOD.Overlap_STR.MTIM3MODHSTR.Byte
    

    /*** MTIM3MODL - MTIM16 Modulo Register Low; 0x0000001D ***/
    union {
      byte Byte;
    } MTIM3MODLSTR;
    #define MTIM3MODL                   _MTIM3MOD.Overlap_STR.MTIM3MODLSTR.Byte
    
  } Overlap_STR;

} MTIM3MODSTR;
extern volatile MTIM3MODSTR _MTIM3MOD @0x0000001C;
#define MTIM3MOD                        _MTIM3MOD.Word


/*** PDBSC - PDB Status and Control Register; 0x00000020 ***/
typedef union {
  word Word;
  struct {
    word EN          :1;                                       /* Module Enable */
    word IE          :1;                                       /* Interrupt Enable */
    word TRIGSEL0    :1;                                       /* Input Trigger Select, bit 0 */
    word TRIGSEL1    :1;                                       /* Input Trigger Select, bit 1 */
    word TRIGSEL2    :1;                                       /* Input Trigger Select, bit 2 */
    word SWTRIG      :1;                                       /* Software Trigger */
    word CONT        :1;                                       /* Continuous Mode Enable */
    word IF          :1;                                       /* Interrupt Flag */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word PRESCALER0  :1;                                       /* Clock Prescaler Select, bit 0 */
    word PRESCALER1  :1;                                       /* Clock Prescaler Select, bit 1 */
    word PRESCALER2  :1;                                       /* Clock Prescaler Select, bit 2 */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word grpTRIGSEL :3;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpPRESCALER :3;
  } MergedBits;
} PDBSCSTR;
extern volatile PDBSCSTR _PDBSC @0x00000020;
#define PDBSC                           _PDBSC.Word
#define PDBSC_EN                        _PDBSC.Bits.EN
#define PDBSC_IE                        _PDBSC.Bits.IE
#define PDBSC_TRIGSEL0                  _PDBSC.Bits.TRIGSEL0
#define PDBSC_TRIGSEL1                  _PDBSC.Bits.TRIGSEL1
#define PDBSC_TRIGSEL2                  _PDBSC.Bits.TRIGSEL2
#define PDBSC_SWTRIG                    _PDBSC.Bits.SWTRIG
#define PDBSC_CONT                      _PDBSC.Bits.CONT
#define PDBSC_IF                        _PDBSC.Bits.IF
#define PDBSC_PRESCALER0                _PDBSC.Bits.PRESCALER0
#define PDBSC_PRESCALER1                _PDBSC.Bits.PRESCALER1
#define PDBSC_PRESCALER2                _PDBSC.Bits.PRESCALER2
#define PDBSC_TRIGSEL                   _PDBSC.MergedBits.grpTRIGSEL
#define PDBSC_PRESCALER                 _PDBSC.MergedBits.grpPRESCALER

#define PDBSC_EN_MASK                   1
#define PDBSC_IE_MASK                   2
#define PDBSC_TRIGSEL0_MASK             4
#define PDBSC_TRIGSEL1_MASK             8
#define PDBSC_TRIGSEL2_MASK             16
#define PDBSC_SWTRIG_MASK               32
#define PDBSC_CONT_MASK                 64
#define PDBSC_IF_MASK                   128
#define PDBSC_PRESCALER0_MASK           8192
#define PDBSC_PRESCALER1_MASK           16384
#define PDBSC_PRESCALER2_MASK           32768
#define PDBSC_TRIGSEL_MASK              28
#define PDBSC_TRIGSEL_BITNUM            2
#define PDBSC_PRESCALER_MASK            57344
#define PDBSC_PRESCALER_BITNUM          13


/*** PDBMOD - PDB Counter Modulus Register; 0x00000022 ***/
typedef union {
  word Word;
  struct {
    word MOD0        :1;                                       /* Counter Modulus, bit 0 */
    word MOD1        :1;                                       /* Counter Modulus, bit 1 */
    word MOD2        :1;                                       /* Counter Modulus, bit 2 */
    word MOD3        :1;                                       /* Counter Modulus, bit 3 */
    word MOD4        :1;                                       /* Counter Modulus, bit 4 */
    word MOD5        :1;                                       /* Counter Modulus, bit 5 */
    word MOD6        :1;                                       /* Counter Modulus, bit 6 */
    word MOD7        :1;                                       /* Counter Modulus, bit 7 */
    word MOD8        :1;                                       /* Counter Modulus, bit 8 */
    word MOD9        :1;                                       /* Counter Modulus, bit 9 */
    word MOD10       :1;                                       /* Counter Modulus, bit 10 */
    word MOD11       :1;                                       /* Counter Modulus, bit 11 */
    word MOD12       :1;                                       /* Counter Modulus, bit 12 */
    word MOD13       :1;                                       /* Counter Modulus, bit 13 */
    word MOD14       :1;                                       /* Counter Modulus, bit 14 */
    word MOD15       :1;                                       /* Counter Modulus, bit 15 */
  } Bits;
} PDBMODSTR;
extern volatile PDBMODSTR _PDBMOD @0x00000022;
#define PDBMOD                          _PDBMOD.Word
#define PDBMOD_MOD0                     _PDBMOD.Bits.MOD0
#define PDBMOD_MOD1                     _PDBMOD.Bits.MOD1
#define PDBMOD_MOD2                     _PDBMOD.Bits.MOD2
#define PDBMOD_MOD3                     _PDBMOD.Bits.MOD3
#define PDBMOD_MOD4                     _PDBMOD.Bits.MOD4
#define PDBMOD_MOD5                     _PDBMOD.Bits.MOD5
#define PDBMOD_MOD6                     _PDBMOD.Bits.MOD6
#define PDBMOD_MOD7                     _PDBMOD.Bits.MOD7
#define PDBMOD_MOD8                     _PDBMOD.Bits.MOD8
#define PDBMOD_MOD9                     _PDBMOD.Bits.MOD9
#define PDBMOD_MOD10                    _PDBMOD.Bits.MOD10
#define PDBMOD_MOD11                    _PDBMOD.Bits.MOD11
#define PDBMOD_MOD12                    _PDBMOD.Bits.MOD12
#define PDBMOD_MOD13                    _PDBMOD.Bits.MOD13
#define PDBMOD_MOD14                    _PDBMOD.Bits.MOD14
#define PDBMOD_MOD15                    _PDBMOD.Bits.MOD15

#define PDBMOD_MOD0_MASK                1
#define PDBMOD_MOD1_MASK                2
#define PDBMOD_MOD2_MASK                4
#define PDBMOD_MOD3_MASK                8
#define PDBMOD_MOD4_MASK                16
#define PDBMOD_MOD5_MASK                32
#define PDBMOD_MOD6_MASK                64
#define PDBMOD_MOD7_MASK                128
#define PDBMOD_MOD8_MASK                256
#define PDBMOD_MOD9_MASK                512
#define PDBMOD_MOD10_MASK               1024
#define PDBMOD_MOD11_MASK               2048
#define PDBMOD_MOD12_MASK               4096
#define PDBMOD_MOD13_MASK               8192
#define PDBMOD_MOD14_MASK               16384
#define PDBMOD_MOD15_MASK               32768


/*** PDBCNT - PDB Counter Value Register; 0x00000024 ***/
typedef union {
  word Word;
  struct {
    word COUNT0      :1;                                       /* Counter Value, bit 0 */
    word COUNT1      :1;                                       /* Counter Value, bit 1 */
    word COUNT2      :1;                                       /* Counter Value, bit 2 */
    word COUNT3      :1;                                       /* Counter Value, bit 3 */
    word COUNT4      :1;                                       /* Counter Value, bit 4 */
    word COUNT5      :1;                                       /* Counter Value, bit 5 */
    word COUNT6      :1;                                       /* Counter Value, bit 6 */
    word COUNT7      :1;                                       /* Counter Value, bit 7 */
    word COUNT8      :1;                                       /* Counter Value, bit 8 */
    word COUNT9      :1;                                       /* Counter Value, bit 9 */
    word COUNT10     :1;                                       /* Counter Value, bit 10 */
    word COUNT11     :1;                                       /* Counter Value, bit 11 */
    word COUNT12     :1;                                       /* Counter Value, bit 12 */
    word COUNT13     :1;                                       /* Counter Value, bit 13 */
    word COUNT14     :1;                                       /* Counter Value, bit 14 */
    word COUNT15     :1;                                       /* Counter Value, bit 15 */
  } Bits;
} PDBCNTSTR;
extern volatile PDBCNTSTR _PDBCNT @0x00000024;
#define PDBCNT                          _PDBCNT.Word
#define PDBCNT_COUNT0                   _PDBCNT.Bits.COUNT0
#define PDBCNT_COUNT1                   _PDBCNT.Bits.COUNT1
#define PDBCNT_COUNT2                   _PDBCNT.Bits.COUNT2
#define PDBCNT_COUNT3                   _PDBCNT.Bits.COUNT3
#define PDBCNT_COUNT4                   _PDBCNT.Bits.COUNT4
#define PDBCNT_COUNT5                   _PDBCNT.Bits.COUNT5
#define PDBCNT_COUNT6                   _PDBCNT.Bits.COUNT6
#define PDBCNT_COUNT7                   _PDBCNT.Bits.COUNT7
#define PDBCNT_COUNT8                   _PDBCNT.Bits.COUNT8
#define PDBCNT_COUNT9                   _PDBCNT.Bits.COUNT9
#define PDBCNT_COUNT10                  _PDBCNT.Bits.COUNT10
#define PDBCNT_COUNT11                  _PDBCNT.Bits.COUNT11
#define PDBCNT_COUNT12                  _PDBCNT.Bits.COUNT12
#define PDBCNT_COUNT13                  _PDBCNT.Bits.COUNT13
#define PDBCNT_COUNT14                  _PDBCNT.Bits.COUNT14
#define PDBCNT_COUNT15                  _PDBCNT.Bits.COUNT15

#define PDBCNT_COUNT0_MASK              1
#define PDBCNT_COUNT1_MASK              2
#define PDBCNT_COUNT2_MASK              4
#define PDBCNT_COUNT3_MASK              8
#define PDBCNT_COUNT4_MASK              16
#define PDBCNT_COUNT5_MASK              32
#define PDBCNT_COUNT6_MASK              64
#define PDBCNT_COUNT7_MASK              128
#define PDBCNT_COUNT8_MASK              256
#define PDBCNT_COUNT9_MASK              512
#define PDBCNT_COUNT10_MASK             1024
#define PDBCNT_COUNT11_MASK             2048
#define PDBCNT_COUNT12_MASK             4096
#define PDBCNT_COUNT13_MASK             8192
#define PDBCNT_COUNT14_MASK             16384
#define PDBCNT_COUNT15_MASK             32768


/*** PDBIDLY - PDB Interrupt Delay Register; 0x00000026 ***/
typedef union {
  word Word;
  struct {
    word IDELAY0     :1;                                       /* Interrupt Delay, bit 0 */
    word IDELAY1     :1;                                       /* Interrupt Delay, bit 1 */
    word IDELAY2     :1;                                       /* Interrupt Delay, bit 2 */
    word IDELAY3     :1;                                       /* Interrupt Delay, bit 3 */
    word IDELAY4     :1;                                       /* Interrupt Delay, bit 4 */
    word IDELAY5     :1;                                       /* Interrupt Delay, bit 5 */
    word IDELAY6     :1;                                       /* Interrupt Delay, bit 6 */
    word IDELAY7     :1;                                       /* Interrupt Delay, bit 7 */
    word IDELAY8     :1;                                       /* Interrupt Delay, bit 8 */
    word IDELAY9     :1;                                       /* Interrupt Delay, bit 9 */
    word IDELAY10    :1;                                       /* Interrupt Delay, bit 10 */
    word IDELAY11    :1;                                       /* Interrupt Delay, bit 11 */
    word IDELAY12    :1;                                       /* Interrupt Delay, bit 12 */
    word IDELAY13    :1;                                       /* Interrupt Delay, bit 13 */
    word IDELAY14    :1;                                       /* Interrupt Delay, bit 14 */
    word IDELAY15    :1;                                       /* Interrupt Delay, bit 15 */
  } Bits;
} PDBIDLYSTR;
extern volatile PDBIDLYSTR _PDBIDLY @0x00000026;
#define PDBIDLY                         _PDBIDLY.Word
#define PDBIDLY_IDELAY0                 _PDBIDLY.Bits.IDELAY0
#define PDBIDLY_IDELAY1                 _PDBIDLY.Bits.IDELAY1
#define PDBIDLY_IDELAY2                 _PDBIDLY.Bits.IDELAY2
#define PDBIDLY_IDELAY3                 _PDBIDLY.Bits.IDELAY3
#define PDBIDLY_IDELAY4                 _PDBIDLY.Bits.IDELAY4
#define PDBIDLY_IDELAY5                 _PDBIDLY.Bits.IDELAY5
#define PDBIDLY_IDELAY6                 _PDBIDLY.Bits.IDELAY6
#define PDBIDLY_IDELAY7                 _PDBIDLY.Bits.IDELAY7
#define PDBIDLY_IDELAY8                 _PDBIDLY.Bits.IDELAY8
#define PDBIDLY_IDELAY9                 _PDBIDLY.Bits.IDELAY9
#define PDBIDLY_IDELAY10                _PDBIDLY.Bits.IDELAY10
#define PDBIDLY_IDELAY11                _PDBIDLY.Bits.IDELAY11
#define PDBIDLY_IDELAY12                _PDBIDLY.Bits.IDELAY12
#define PDBIDLY_IDELAY13                _PDBIDLY.Bits.IDELAY13
#define PDBIDLY_IDELAY14                _PDBIDLY.Bits.IDELAY14
#define PDBIDLY_IDELAY15                _PDBIDLY.Bits.IDELAY15

#define PDBIDLY_IDELAY0_MASK            1
#define PDBIDLY_IDELAY1_MASK            2
#define PDBIDLY_IDELAY2_MASK            4
#define PDBIDLY_IDELAY3_MASK            8
#define PDBIDLY_IDELAY4_MASK            16
#define PDBIDLY_IDELAY5_MASK            32
#define PDBIDLY_IDELAY6_MASK            64
#define PDBIDLY_IDELAY7_MASK            128
#define PDBIDLY_IDELAY8_MASK            256
#define PDBIDLY_IDELAY9_MASK            512
#define PDBIDLY_IDELAY10_MASK           1024
#define PDBIDLY_IDELAY11_MASK           2048
#define PDBIDLY_IDELAY12_MASK           4096
#define PDBIDLY_IDELAY13_MASK           8192
#define PDBIDLY_IDELAY14_MASK           16384
#define PDBIDLY_IDELAY15_MASK           32768


/*** PDBCH1CR - PDB Channel 1 Control Register; 0x00000028 ***/
typedef union {
  word Word;
  struct {
    word ENB         :1;                                       /* Trigger B Enable */
    word ENA         :1;                                       /* Trigger A Enable */
    word BOS0        :1;                                       /* Channel 1 Trigger B Output Select, bit 0 */
    word BOS1        :1;                                       /* Channel 1 Trigger B Output Select, bit 1 */
    word AOS0        :1;                                       /* Channel 1 Trigger A Output Select, bit 0 */
    word AOS1        :1;                                       /* Channel 1 Trigger A Output Select, bit 1 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ERRB        :1;                                       /* Sequence error on TriggerB */
    word ERRA        :1;                                       /* Sequence error on TriggerA */
  } Bits;
  struct {
    word         :1;
    word grpENx  :1;
    word grpBOS  :2;
    word grpAOS  :2;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpERRx :1;
  } MergedBits;
} PDBCH1CRSTR;
extern volatile PDBCH1CRSTR _PDBCH1CR @0x00000028;
#define PDBCH1CR                        _PDBCH1CR.Word
#define PDBCH1CR_ENB                    _PDBCH1CR.Bits.ENB
#define PDBCH1CR_ENA                    _PDBCH1CR.Bits.ENA
#define PDBCH1CR_BOS0                   _PDBCH1CR.Bits.BOS0
#define PDBCH1CR_BOS1                   _PDBCH1CR.Bits.BOS1
#define PDBCH1CR_AOS0                   _PDBCH1CR.Bits.AOS0
#define PDBCH1CR_AOS1                   _PDBCH1CR.Bits.AOS1
#define PDBCH1CR_ERRB                   _PDBCH1CR.Bits.ERRB
#define PDBCH1CR_ERRA                   _PDBCH1CR.Bits.ERRA
#define PDBCH1CR_BOS                    _PDBCH1CR.MergedBits.grpBOS
#define PDBCH1CR_AOS                    _PDBCH1CR.MergedBits.grpAOS

#define PDBCH1CR_ENB_MASK               1
#define PDBCH1CR_ENA_MASK               2
#define PDBCH1CR_BOS0_MASK              4
#define PDBCH1CR_BOS1_MASK              8
#define PDBCH1CR_AOS0_MASK              16
#define PDBCH1CR_AOS1_MASK              32
#define PDBCH1CR_ERRB_MASK              16384
#define PDBCH1CR_ERRA_MASK              32768
#define PDBCH1CR_BOS_MASK               12
#define PDBCH1CR_BOS_BITNUM             2
#define PDBCH1CR_AOS_MASK               48
#define PDBCH1CR_AOS_BITNUM             4


/*** PDBCH1DLYA - PDB Channel 1 Delay A Register; 0x0000002A ***/
typedef union {
  word Word;
  struct {
    word DELAYA0     :1;                                       /* Delay A, bit 0 */
    word DELAYA1     :1;                                       /* Delay A, bit 1 */
    word DELAYA2     :1;                                       /* Delay A, bit 2 */
    word DELAYA3     :1;                                       /* Delay A, bit 3 */
    word DELAYA4     :1;                                       /* Delay A, bit 4 */
    word DELAYA5     :1;                                       /* Delay A, bit 5 */
    word DELAYA6     :1;                                       /* Delay A, bit 6 */
    word DELAYA7     :1;                                       /* Delay A, bit 7 */
    word DELAYA8     :1;                                       /* Delay A, bit 8 */
    word DELAYA9     :1;                                       /* Delay A, bit 9 */
    word DELAYA10    :1;                                       /* Delay A, bit 10 */
    word DELAYA11    :1;                                       /* Delay A, bit 11 */
    word DELAYA12    :1;                                       /* Delay A, bit 12 */
    word DELAYA13    :1;                                       /* Delay A, bit 13 */
    word DELAYA14    :1;                                       /* Delay A, bit 14 */
    word DELAYA15    :1;                                       /* Delay A, bit 15 */
  } Bits;
} PDBCH1DLYASTR;
extern volatile PDBCH1DLYASTR _PDBCH1DLYA @0x0000002A;
#define PDBCH1DLYA                      _PDBCH1DLYA.Word
#define PDBCH1DLYA_DELAYA0              _PDBCH1DLYA.Bits.DELAYA0
#define PDBCH1DLYA_DELAYA1              _PDBCH1DLYA.Bits.DELAYA1
#define PDBCH1DLYA_DELAYA2              _PDBCH1DLYA.Bits.DELAYA2
#define PDBCH1DLYA_DELAYA3              _PDBCH1DLYA.Bits.DELAYA3
#define PDBCH1DLYA_DELAYA4              _PDBCH1DLYA.Bits.DELAYA4
#define PDBCH1DLYA_DELAYA5              _PDBCH1DLYA.Bits.DELAYA5
#define PDBCH1DLYA_DELAYA6              _PDBCH1DLYA.Bits.DELAYA6
#define PDBCH1DLYA_DELAYA7              _PDBCH1DLYA.Bits.DELAYA7
#define PDBCH1DLYA_DELAYA8              _PDBCH1DLYA.Bits.DELAYA8
#define PDBCH1DLYA_DELAYA9              _PDBCH1DLYA.Bits.DELAYA9
#define PDBCH1DLYA_DELAYA10             _PDBCH1DLYA.Bits.DELAYA10
#define PDBCH1DLYA_DELAYA11             _PDBCH1DLYA.Bits.DELAYA11
#define PDBCH1DLYA_DELAYA12             _PDBCH1DLYA.Bits.DELAYA12
#define PDBCH1DLYA_DELAYA13             _PDBCH1DLYA.Bits.DELAYA13
#define PDBCH1DLYA_DELAYA14             _PDBCH1DLYA.Bits.DELAYA14
#define PDBCH1DLYA_DELAYA15             _PDBCH1DLYA.Bits.DELAYA15

#define PDBCH1DLYA_DELAYA0_MASK         1
#define PDBCH1DLYA_DELAYA1_MASK         2
#define PDBCH1DLYA_DELAYA2_MASK         4
#define PDBCH1DLYA_DELAYA3_MASK         8
#define PDBCH1DLYA_DELAYA4_MASK         16
#define PDBCH1DLYA_DELAYA5_MASK         32
#define PDBCH1DLYA_DELAYA6_MASK         64
#define PDBCH1DLYA_DELAYA7_MASK         128
#define PDBCH1DLYA_DELAYA8_MASK         256
#define PDBCH1DLYA_DELAYA9_MASK         512
#define PDBCH1DLYA_DELAYA10_MASK        1024
#define PDBCH1DLYA_DELAYA11_MASK        2048
#define PDBCH1DLYA_DELAYA12_MASK        4096
#define PDBCH1DLYA_DELAYA13_MASK        8192
#define PDBCH1DLYA_DELAYA14_MASK        16384
#define PDBCH1DLYA_DELAYA15_MASK        32768


/*** PDBCH1DLYB - PDB Channel 1 Delay B Register; 0x0000002C ***/
typedef union {
  word Word;
  struct {
    word DELAYB0     :1;                                       /* Delay B, bit 0 */
    word DELAYB1     :1;                                       /* Delay B, bit 1 */
    word DELAYB2     :1;                                       /* Delay B, bit 2 */
    word DELAYB3     :1;                                       /* Delay B, bit 3 */
    word DELAYB4     :1;                                       /* Delay B, bit 4 */
    word DELAYB5     :1;                                       /* Delay B, bit 5 */
    word DELAYB6     :1;                                       /* Delay B, bit 6 */
    word DELAYB7     :1;                                       /* Delay B, bit 7 */
    word DELAYB8     :1;                                       /* Delay B, bit 8 */
    word DELAYB9     :1;                                       /* Delay B, bit 9 */
    word DELAYB10    :1;                                       /* Delay B, bit 10 */
    word DELAYB11    :1;                                       /* Delay B, bit 11 */
    word DELAYB12    :1;                                       /* Delay B, bit 12 */
    word DELAYB13    :1;                                       /* Delay B, bit 13 */
    word DELAYB14    :1;                                       /* Delay B, bit 14 */
    word DELAYB15    :1;                                       /* Delay B, bit 15 */
  } Bits;
} PDBCH1DLYBSTR;
extern volatile PDBCH1DLYBSTR _PDBCH1DLYB @0x0000002C;
#define PDBCH1DLYB                      _PDBCH1DLYB.Word
#define PDBCH1DLYB_DELAYB0              _PDBCH1DLYB.Bits.DELAYB0
#define PDBCH1DLYB_DELAYB1              _PDBCH1DLYB.Bits.DELAYB1
#define PDBCH1DLYB_DELAYB2              _PDBCH1DLYB.Bits.DELAYB2
#define PDBCH1DLYB_DELAYB3              _PDBCH1DLYB.Bits.DELAYB3
#define PDBCH1DLYB_DELAYB4              _PDBCH1DLYB.Bits.DELAYB4
#define PDBCH1DLYB_DELAYB5              _PDBCH1DLYB.Bits.DELAYB5
#define PDBCH1DLYB_DELAYB6              _PDBCH1DLYB.Bits.DELAYB6
#define PDBCH1DLYB_DELAYB7              _PDBCH1DLYB.Bits.DELAYB7
#define PDBCH1DLYB_DELAYB8              _PDBCH1DLYB.Bits.DELAYB8
#define PDBCH1DLYB_DELAYB9              _PDBCH1DLYB.Bits.DELAYB9
#define PDBCH1DLYB_DELAYB10             _PDBCH1DLYB.Bits.DELAYB10
#define PDBCH1DLYB_DELAYB11             _PDBCH1DLYB.Bits.DELAYB11
#define PDBCH1DLYB_DELAYB12             _PDBCH1DLYB.Bits.DELAYB12
#define PDBCH1DLYB_DELAYB13             _PDBCH1DLYB.Bits.DELAYB13
#define PDBCH1DLYB_DELAYB14             _PDBCH1DLYB.Bits.DELAYB14
#define PDBCH1DLYB_DELAYB15             _PDBCH1DLYB.Bits.DELAYB15

#define PDBCH1DLYB_DELAYB0_MASK         1
#define PDBCH1DLYB_DELAYB1_MASK         2
#define PDBCH1DLYB_DELAYB2_MASK         4
#define PDBCH1DLYB_DELAYB3_MASK         8
#define PDBCH1DLYB_DELAYB4_MASK         16
#define PDBCH1DLYB_DELAYB5_MASK         32
#define PDBCH1DLYB_DELAYB6_MASK         64
#define PDBCH1DLYB_DELAYB7_MASK         128
#define PDBCH1DLYB_DELAYB8_MASK         256
#define PDBCH1DLYB_DELAYB9_MASK         512
#define PDBCH1DLYB_DELAYB10_MASK        1024
#define PDBCH1DLYB_DELAYB11_MASK        2048
#define PDBCH1DLYB_DELAYB12_MASK        4096
#define PDBCH1DLYB_DELAYB13_MASK        8192
#define PDBCH1DLYB_DELAYB14_MASK        16384
#define PDBCH1DLYB_DELAYB15_MASK        32768


/*** PDBCH2CR - PDB Channel 2 Control Register; 0x00000030 ***/
typedef union {
  word Word;
  struct {
    word ENB         :1;                                       /* Trigger B Enable */
    word ENA         :1;                                       /* Trigger A Enable */
    word BOS0        :1;                                       /* Channel 2 Trigger B Output Select, bit 0 */
    word BOS1        :1;                                       /* Channel 2 Trigger B Output Select, bit 1 */
    word AOS0        :1;                                       /* Channel 2 Trigger A Output Select, bit 0 */
    word AOS1        :1;                                       /* Channel 2 Trigger A Output Select, bit 1 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ERRB        :1;                                       /* Sequence error on TriggerB */
    word ERRA        :1;                                       /* Sequence error on TriggerA */
  } Bits;
  struct {
    word         :1;
    word grpENx  :1;
    word grpBOS  :2;
    word grpAOS  :2;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpERRx :1;
  } MergedBits;
} PDBCH2CRSTR;
extern volatile PDBCH2CRSTR _PDBCH2CR @0x00000030;
#define PDBCH2CR                        _PDBCH2CR.Word
#define PDBCH2CR_ENB                    _PDBCH2CR.Bits.ENB
#define PDBCH2CR_ENA                    _PDBCH2CR.Bits.ENA
#define PDBCH2CR_BOS0                   _PDBCH2CR.Bits.BOS0
#define PDBCH2CR_BOS1                   _PDBCH2CR.Bits.BOS1
#define PDBCH2CR_AOS0                   _PDBCH2CR.Bits.AOS0
#define PDBCH2CR_AOS1                   _PDBCH2CR.Bits.AOS1
#define PDBCH2CR_ERRB                   _PDBCH2CR.Bits.ERRB
#define PDBCH2CR_ERRA                   _PDBCH2CR.Bits.ERRA
#define PDBCH2CR_BOS                    _PDBCH2CR.MergedBits.grpBOS
#define PDBCH2CR_AOS                    _PDBCH2CR.MergedBits.grpAOS

#define PDBCH2CR_ENB_MASK               1
#define PDBCH2CR_ENA_MASK               2
#define PDBCH2CR_BOS0_MASK              4
#define PDBCH2CR_BOS1_MASK              8
#define PDBCH2CR_AOS0_MASK              16
#define PDBCH2CR_AOS1_MASK              32
#define PDBCH2CR_ERRB_MASK              16384
#define PDBCH2CR_ERRA_MASK              32768
#define PDBCH2CR_BOS_MASK               12
#define PDBCH2CR_BOS_BITNUM             2
#define PDBCH2CR_AOS_MASK               48
#define PDBCH2CR_AOS_BITNUM             4


/*** PDBCH2DLYA - PDB Channel 2 Delay A Register; 0x00000032 ***/
typedef union {
  word Word;
  struct {
    word DELAYA0     :1;                                       /* Delay A, bit 0 */
    word DELAYA1     :1;                                       /* Delay A, bit 1 */
    word DELAYA2     :1;                                       /* Delay A, bit 2 */
    word DELAYA3     :1;                                       /* Delay A, bit 3 */
    word DELAYA4     :1;                                       /* Delay A, bit 4 */
    word DELAYA5     :1;                                       /* Delay A, bit 5 */
    word DELAYA6     :1;                                       /* Delay A, bit 6 */
    word DELAYA7     :1;                                       /* Delay A, bit 7 */
    word DELAYA8     :1;                                       /* Delay A, bit 8 */
    word DELAYA9     :1;                                       /* Delay A, bit 9 */
    word DELAYA10    :1;                                       /* Delay A, bit 10 */
    word DELAYA11    :1;                                       /* Delay A, bit 11 */
    word DELAYA12    :1;                                       /* Delay A, bit 12 */
    word DELAYA13    :1;                                       /* Delay A, bit 13 */
    word DELAYA14    :1;                                       /* Delay A, bit 14 */
    word DELAYA15    :1;                                       /* Delay A, bit 15 */
  } Bits;
} PDBCH2DLYASTR;
extern volatile PDBCH2DLYASTR _PDBCH2DLYA @0x00000032;
#define PDBCH2DLYA                      _PDBCH2DLYA.Word
#define PDBCH2DLYA_DELAYA0              _PDBCH2DLYA.Bits.DELAYA0
#define PDBCH2DLYA_DELAYA1              _PDBCH2DLYA.Bits.DELAYA1
#define PDBCH2DLYA_DELAYA2              _PDBCH2DLYA.Bits.DELAYA2
#define PDBCH2DLYA_DELAYA3              _PDBCH2DLYA.Bits.DELAYA3
#define PDBCH2DLYA_DELAYA4              _PDBCH2DLYA.Bits.DELAYA4
#define PDBCH2DLYA_DELAYA5              _PDBCH2DLYA.Bits.DELAYA5
#define PDBCH2DLYA_DELAYA6              _PDBCH2DLYA.Bits.DELAYA6
#define PDBCH2DLYA_DELAYA7              _PDBCH2DLYA.Bits.DELAYA7
#define PDBCH2DLYA_DELAYA8              _PDBCH2DLYA.Bits.DELAYA8
#define PDBCH2DLYA_DELAYA9              _PDBCH2DLYA.Bits.DELAYA9
#define PDBCH2DLYA_DELAYA10             _PDBCH2DLYA.Bits.DELAYA10
#define PDBCH2DLYA_DELAYA11             _PDBCH2DLYA.Bits.DELAYA11
#define PDBCH2DLYA_DELAYA12             _PDBCH2DLYA.Bits.DELAYA12
#define PDBCH2DLYA_DELAYA13             _PDBCH2DLYA.Bits.DELAYA13
#define PDBCH2DLYA_DELAYA14             _PDBCH2DLYA.Bits.DELAYA14
#define PDBCH2DLYA_DELAYA15             _PDBCH2DLYA.Bits.DELAYA15

#define PDBCH2DLYA_DELAYA0_MASK         1
#define PDBCH2DLYA_DELAYA1_MASK         2
#define PDBCH2DLYA_DELAYA2_MASK         4
#define PDBCH2DLYA_DELAYA3_MASK         8
#define PDBCH2DLYA_DELAYA4_MASK         16
#define PDBCH2DLYA_DELAYA5_MASK         32
#define PDBCH2DLYA_DELAYA6_MASK         64
#define PDBCH2DLYA_DELAYA7_MASK         128
#define PDBCH2DLYA_DELAYA8_MASK         256
#define PDBCH2DLYA_DELAYA9_MASK         512
#define PDBCH2DLYA_DELAYA10_MASK        1024
#define PDBCH2DLYA_DELAYA11_MASK        2048
#define PDBCH2DLYA_DELAYA12_MASK        4096
#define PDBCH2DLYA_DELAYA13_MASK        8192
#define PDBCH2DLYA_DELAYA14_MASK        16384
#define PDBCH2DLYA_DELAYA15_MASK        32768


/*** PDBCH2DLYB - PDB Channel 2 Delay B Register; 0x00000034 ***/
typedef union {
  word Word;
  struct {
    word DELAYB0     :1;                                       /* Delay B, bit 0 */
    word DELAYB1     :1;                                       /* Delay B, bit 1 */
    word DELAYB2     :1;                                       /* Delay B, bit 2 */
    word DELAYB3     :1;                                       /* Delay B, bit 3 */
    word DELAYB4     :1;                                       /* Delay B, bit 4 */
    word DELAYB5     :1;                                       /* Delay B, bit 5 */
    word DELAYB6     :1;                                       /* Delay B, bit 6 */
    word DELAYB7     :1;                                       /* Delay B, bit 7 */
    word DELAYB8     :1;                                       /* Delay B, bit 8 */
    word DELAYB9     :1;                                       /* Delay B, bit 9 */
    word DELAYB10    :1;                                       /* Delay B, bit 10 */
    word DELAYB11    :1;                                       /* Delay B, bit 11 */
    word DELAYB12    :1;                                       /* Delay B, bit 12 */
    word DELAYB13    :1;                                       /* Delay B, bit 13 */
    word DELAYB14    :1;                                       /* Delay B, bit 14 */
    word DELAYB15    :1;                                       /* Delay B, bit 15 */
  } Bits;
} PDBCH2DLYBSTR;
extern volatile PDBCH2DLYBSTR _PDBCH2DLYB @0x00000034;
#define PDBCH2DLYB                      _PDBCH2DLYB.Word
#define PDBCH2DLYB_DELAYB0              _PDBCH2DLYB.Bits.DELAYB0
#define PDBCH2DLYB_DELAYB1              _PDBCH2DLYB.Bits.DELAYB1
#define PDBCH2DLYB_DELAYB2              _PDBCH2DLYB.Bits.DELAYB2
#define PDBCH2DLYB_DELAYB3              _PDBCH2DLYB.Bits.DELAYB3
#define PDBCH2DLYB_DELAYB4              _PDBCH2DLYB.Bits.DELAYB4
#define PDBCH2DLYB_DELAYB5              _PDBCH2DLYB.Bits.DELAYB5
#define PDBCH2DLYB_DELAYB6              _PDBCH2DLYB.Bits.DELAYB6
#define PDBCH2DLYB_DELAYB7              _PDBCH2DLYB.Bits.DELAYB7
#define PDBCH2DLYB_DELAYB8              _PDBCH2DLYB.Bits.DELAYB8
#define PDBCH2DLYB_DELAYB9              _PDBCH2DLYB.Bits.DELAYB9
#define PDBCH2DLYB_DELAYB10             _PDBCH2DLYB.Bits.DELAYB10
#define PDBCH2DLYB_DELAYB11             _PDBCH2DLYB.Bits.DELAYB11
#define PDBCH2DLYB_DELAYB12             _PDBCH2DLYB.Bits.DELAYB12
#define PDBCH2DLYB_DELAYB13             _PDBCH2DLYB.Bits.DELAYB13
#define PDBCH2DLYB_DELAYB14             _PDBCH2DLYB.Bits.DELAYB14
#define PDBCH2DLYB_DELAYB15             _PDBCH2DLYB.Bits.DELAYB15

#define PDBCH2DLYB_DELAYB0_MASK         1
#define PDBCH2DLYB_DELAYB1_MASK         2
#define PDBCH2DLYB_DELAYB2_MASK         4
#define PDBCH2DLYB_DELAYB3_MASK         8
#define PDBCH2DLYB_DELAYB4_MASK         16
#define PDBCH2DLYB_DELAYB5_MASK         32
#define PDBCH2DLYB_DELAYB6_MASK         64
#define PDBCH2DLYB_DELAYB7_MASK         128
#define PDBCH2DLYB_DELAYB8_MASK         256
#define PDBCH2DLYB_DELAYB9_MASK         512
#define PDBCH2DLYB_DELAYB10_MASK        1024
#define PDBCH2DLYB_DELAYB11_MASK        2048
#define PDBCH2DLYB_DELAYB12_MASK        4096
#define PDBCH2DLYB_DELAYB13_MASK        8192
#define PDBCH2DLYB_DELAYB14_MASK        16384
#define PDBCH2DLYB_DELAYB15_MASK        32768


/*** PPAGE - Program Page Register; 0x00000038 ***/
typedef union {
  byte Byte;
  struct {
    byte XA14        :1;                                       /* Extended address, bit 14 */
    byte XA15        :1;                                       /* Extended address, bit 15 */
    byte XA16        :1;                                       /* Extended address, bit 16 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpXA_14 :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PPAGESTR;
extern volatile PPAGESTR _PPAGE @0x00000038;
#define PPAGE                           _PPAGE.Byte
#define PPAGE_XA14                      _PPAGE.Bits.XA14
#define PPAGE_XA15                      _PPAGE.Bits.XA15
#define PPAGE_XA16                      _PPAGE.Bits.XA16
#define PPAGE_XA_14                     _PPAGE.MergedBits.grpXA_14
#define PPAGE_XA                        PPAGE_XA_14

#define PPAGE_XA14_MASK                 1
#define PPAGE_XA15_MASK                 2
#define PPAGE_XA16_MASK                 4
#define PPAGE_XA_14_MASK                7
#define PPAGE_XA_14_BITNUM              0


/*** LAP2 - Linear Address Pointer Register 2; 0x00000039 ***/
typedef union {
  byte Byte;
  struct {
    byte LA16        :1;                                       /* Linear address pointer, bit 16 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} LAP2STR;
extern volatile LAP2STR _LAP2 @0x00000039;
#define LAP2                            _LAP2.Byte
#define LAP2_LA16                       _LAP2.Bits.LA16

#define LAP2_LA16_MASK                  1


/*** LAP1 - Linear Address Pointer Register 1; 0x0000003A ***/
typedef union {
  byte Byte;
  struct {
    byte LA8         :1;                                       /* Linear address pointer, bit 8 */
    byte LA9         :1;                                       /* Linear address pointer, bit 9 */
    byte LA10        :1;                                       /* Linear address pointer, bit 10 */
    byte LA11        :1;                                       /* Linear address pointer, bit 11 */
    byte LA12        :1;                                       /* Linear address pointer, bit 12 */
    byte LA13        :1;                                       /* Linear address pointer, bit 13 */
    byte LA14        :1;                                       /* Linear address pointer, bit 14 */
    byte LA15        :1;                                       /* Linear address pointer, bit 15 */
  } Bits;
} LAP1STR;
extern volatile LAP1STR _LAP1 @0x0000003A;
#define LAP1                            _LAP1.Byte
#define LAP1_LA8                        _LAP1.Bits.LA8
#define LAP1_LA9                        _LAP1.Bits.LA9
#define LAP1_LA10                       _LAP1.Bits.LA10
#define LAP1_LA11                       _LAP1.Bits.LA11
#define LAP1_LA12                       _LAP1.Bits.LA12
#define LAP1_LA13                       _LAP1.Bits.LA13
#define LAP1_LA14                       _LAP1.Bits.LA14
#define LAP1_LA15                       _LAP1.Bits.LA15

#define LAP1_LA8_MASK                   1
#define LAP1_LA9_MASK                   2
#define LAP1_LA10_MASK                  4
#define LAP1_LA11_MASK                  8
#define LAP1_LA12_MASK                  16
#define LAP1_LA13_MASK                  32
#define LAP1_LA14_MASK                  64
#define LAP1_LA15_MASK                  128


/*** LAP0 - Linear Address Pointer Register 0; 0x0000003B ***/
typedef union {
  byte Byte;
  struct {
    byte LA0         :1;                                       /* Linear address pointer, bit 0 */
    byte LA1         :1;                                       /* Linear address pointer, bit 1 */
    byte LA2         :1;                                       /* Linear address pointer, bit 2 */
    byte LA3         :1;                                       /* Linear address pointer, bit 3 */
    byte LA4         :1;                                       /* Linear address pointer, bit 4 */
    byte LA5         :1;                                       /* Linear address pointer, bit 5 */
    byte LA6         :1;                                       /* Linear address pointer, bit 6 */
    byte LA7         :1;                                       /* Linear address pointer, bit 7 */
  } Bits;
} LAP0STR;
extern volatile LAP0STR _LAP0 @0x0000003B;
#define LAP0                            _LAP0.Byte
#define LAP0_LA0                        _LAP0.Bits.LA0
#define LAP0_LA1                        _LAP0.Bits.LA1
#define LAP0_LA2                        _LAP0.Bits.LA2
#define LAP0_LA3                        _LAP0.Bits.LA3
#define LAP0_LA4                        _LAP0.Bits.LA4
#define LAP0_LA5                        _LAP0.Bits.LA5
#define LAP0_LA6                        _LAP0.Bits.LA6
#define LAP0_LA7                        _LAP0.Bits.LA7

#define LAP0_LA0_MASK                   1
#define LAP0_LA1_MASK                   2
#define LAP0_LA2_MASK                   4
#define LAP0_LA3_MASK                   8
#define LAP0_LA4_MASK                   16
#define LAP0_LA5_MASK                   32
#define LAP0_LA6_MASK                   64
#define LAP0_LA7_MASK                   128


/*** LWP - Linear Word Post Increment Register; 0x0000003C ***/
typedef union {
  byte Byte;
  struct {
    byte D0          :1;                                       /* Data value bit 0 */
    byte D1          :1;                                       /* Data value bit 1 */
    byte D2          :1;                                       /* Data value bit 2 */
    byte D3          :1;                                       /* Data value bit 3 */
    byte D4          :1;                                       /* Data value bit 4 */
    byte D5          :1;                                       /* Data value bit 5 */
    byte D6          :1;                                       /* Data value bit 6 */
    byte D7          :1;                                       /* Data value bit 7 */
  } Bits;
} LWPSTR;
extern volatile LWPSTR _LWP @0x0000003C;
#define LWP                             _LWP.Byte
#define LWP_D0                          _LWP.Bits.D0
#define LWP_D1                          _LWP.Bits.D1
#define LWP_D2                          _LWP.Bits.D2
#define LWP_D3                          _LWP.Bits.D3
#define LWP_D4                          _LWP.Bits.D4
#define LWP_D5                          _LWP.Bits.D5
#define LWP_D6                          _LWP.Bits.D6
#define LWP_D7                          _LWP.Bits.D7

#define LWP_D0_MASK                     1
#define LWP_D1_MASK                     2
#define LWP_D2_MASK                     4
#define LWP_D3_MASK                     8
#define LWP_D4_MASK                     16
#define LWP_D5_MASK                     32
#define LWP_D6_MASK                     64
#define LWP_D7_MASK                     128


/*** LBP - Linear Byte Post Increment Register; 0x0000003D ***/
typedef union {
  byte Byte;
  struct {
    byte D0          :1;                                       /* Data value bit 0 */
    byte D1          :1;                                       /* Data value bit 1 */
    byte D2          :1;                                       /* Data value bit 2 */
    byte D3          :1;                                       /* Data value bit 3 */
    byte D4          :1;                                       /* Data value bit 4 */
    byte D5          :1;                                       /* Data value bit 5 */
    byte D6          :1;                                       /* Data value bit 6 */
    byte D7          :1;                                       /* Data value bit 7 */
  } Bits;
} LBPSTR;
extern volatile LBPSTR _LBP @0x0000003D;
#define LBP                             _LBP.Byte
#define LBP_D0                          _LBP.Bits.D0
#define LBP_D1                          _LBP.Bits.D1
#define LBP_D2                          _LBP.Bits.D2
#define LBP_D3                          _LBP.Bits.D3
#define LBP_D4                          _LBP.Bits.D4
#define LBP_D5                          _LBP.Bits.D5
#define LBP_D6                          _LBP.Bits.D6
#define LBP_D7                          _LBP.Bits.D7

#define LBP_D0_MASK                     1
#define LBP_D1_MASK                     2
#define LBP_D2_MASK                     4
#define LBP_D3_MASK                     8
#define LBP_D4_MASK                     16
#define LBP_D5_MASK                     32
#define LBP_D6_MASK                     64
#define LBP_D7_MASK                     128


/*** LB - Linear Byte Register; 0x0000003E ***/
typedef union {
  byte Byte;
  struct {
    byte D0          :1;                                       /* Data value bit 0 */
    byte D1          :1;                                       /* Data value bit 1 */
    byte D2          :1;                                       /* Data value bit 2 */
    byte D3          :1;                                       /* Data value bit 3 */
    byte D4          :1;                                       /* Data value bit 4 */
    byte D5          :1;                                       /* Data value bit 5 */
    byte D6          :1;                                       /* Data value bit 6 */
    byte D7          :1;                                       /* Data value bit 7 */
  } Bits;
} LBSTR;
extern volatile LBSTR _LB @0x0000003E;
#define LB                              _LB.Byte
#define LB_D0                           _LB.Bits.D0
#define LB_D1                           _LB.Bits.D1
#define LB_D2                           _LB.Bits.D2
#define LB_D3                           _LB.Bits.D3
#define LB_D4                           _LB.Bits.D4
#define LB_D5                           _LB.Bits.D5
#define LB_D6                           _LB.Bits.D6
#define LB_D7                           _LB.Bits.D7

#define LB_D0_MASK                      1
#define LB_D1_MASK                      2
#define LB_D2_MASK                      4
#define LB_D3_MASK                      8
#define LB_D4_MASK                      16
#define LB_D5_MASK                      32
#define LB_D6_MASK                      64
#define LB_D7_MASK                      128


/*** LAPAB - Linear Address Pointer Add Byte Register; 0x0000003F ***/
typedef union {
  byte Byte;
  struct {
    byte D0          :1;                                       /* Data value bit 0 */
    byte D1          :1;                                       /* Data value bit 1 */
    byte D2          :1;                                       /* Data value bit 2 */
    byte D3          :1;                                       /* Data value bit 3 */
    byte D4          :1;                                       /* Data value bit 4 */
    byte D5          :1;                                       /* Data value bit 5 */
    byte D6          :1;                                       /* Data value bit 6 */
    byte D7          :1;                                       /* Data value bit 7 */
  } Bits;
} LAPABSTR;
extern volatile LAPABSTR _LAPAB @0x0000003F;
#define LAPAB                           _LAPAB.Byte
#define LAPAB_D0                        _LAPAB.Bits.D0
#define LAPAB_D1                        _LAPAB.Bits.D1
#define LAPAB_D2                        _LAPAB.Bits.D2
#define LAPAB_D3                        _LAPAB.Bits.D3
#define LAPAB_D4                        _LAPAB.Bits.D4
#define LAPAB_D5                        _LAPAB.Bits.D5
#define LAPAB_D6                        _LAPAB.Bits.D6
#define LAPAB_D7                        _LAPAB.Bits.D7

#define LAPAB_D0_MASK                   1
#define LAPAB_D1_MASK                   2
#define LAPAB_D2_MASK                   4
#define LAPAB_D3_MASK                   8
#define LAPAB_D4_MASK                   16
#define LAPAB_D5_MASK                   32
#define LAPAB_D6_MASK                   64
#define LAPAB_D7_MASK                   128


/*** ADC0SC1A - Status and Control Register 1A; 0x00000040 ***/
typedef union {
  byte Byte;
  struct {
    byte ADCHA0      :1;                                       /* Input Channel Select Bit 0 */
    byte ADCHA1      :1;                                       /* Input Channel Select Bit 1 */
    byte ADCHA2      :1;                                       /* Input Channel Select Bit 2 */
    byte ADCHA3      :1;                                       /* Input Channel Select Bit 3 */
    byte ADCHA4      :1;                                       /* Input Channel Select Bit 4 */
    byte DIFFA       :1;                                       /* Differential Mode Enable - DIFFA configures the ADC to operate in differential mode */
    byte AIENA       :1;                                       /* Interrupt Enable - AIENA enables conversion complete interrupts. When COCOA becomes set while the respective AIENA is high, an interrupt is asserted */
    byte COCOA       :1;                                       /* Conversion Complete Flag */
  } Bits;
  struct {
    byte grpADCHA :5;
    byte grpDIFFx :1;
    byte grpAIENx :1;
    byte grpCOCOx :1;
  } MergedBits;
} ADC0SC1ASTR;
extern volatile ADC0SC1ASTR _ADC0SC1A @0x00000040;
#define ADC0SC1A                        _ADC0SC1A.Byte
#define ADC0SC1A_ADCHA0                 _ADC0SC1A.Bits.ADCHA0
#define ADC0SC1A_ADCHA1                 _ADC0SC1A.Bits.ADCHA1
#define ADC0SC1A_ADCHA2                 _ADC0SC1A.Bits.ADCHA2
#define ADC0SC1A_ADCHA3                 _ADC0SC1A.Bits.ADCHA3
#define ADC0SC1A_ADCHA4                 _ADC0SC1A.Bits.ADCHA4
#define ADC0SC1A_DIFFA                  _ADC0SC1A.Bits.DIFFA
#define ADC0SC1A_AIENA                  _ADC0SC1A.Bits.AIENA
#define ADC0SC1A_COCOA                  _ADC0SC1A.Bits.COCOA
#define ADC0SC1A_ADCHA                  _ADC0SC1A.MergedBits.grpADCHA

#define ADC0SC1A_ADCHA0_MASK            1
#define ADC0SC1A_ADCHA1_MASK            2
#define ADC0SC1A_ADCHA2_MASK            4
#define ADC0SC1A_ADCHA3_MASK            8
#define ADC0SC1A_ADCHA4_MASK            16
#define ADC0SC1A_DIFFA_MASK             32
#define ADC0SC1A_AIENA_MASK             64
#define ADC0SC1A_COCOA_MASK             128
#define ADC0SC1A_ADCHA_MASK             31
#define ADC0SC1A_ADCHA_BITNUM           0


/*** ADC0SC1B - Status and Control Register 1B; 0x00000041 ***/
typedef union {
  byte Byte;
  struct {
    byte ADCHB0      :1;                                       /* Input Channel Select Bit 0 */
    byte ADCHB1      :1;                                       /* Input Channel Select Bit 1 */
    byte ADCHB2      :1;                                       /* Input Channel Select Bit 2 */
    byte ADCHB3      :1;                                       /* Input Channel Select Bit 3 */
    byte ADCHB4      :1;                                       /* Input Channel Select Bit 4 */
    byte DIFFB       :1;                                       /* Differential Mode Enable - DIFFB configures the ADC to operate in differential mode */
    byte AIENB       :1;                                       /* Interrupt Enable - AIENB enables conversion complete interrupts. When COCOB becomes set while the respective AIENB is high, an interrupt is asserted */
    byte COCOB       :1;                                       /* Conversion Complete Flag */
  } Bits;
  struct {
    byte grpADCHB :5;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} ADC0SC1BSTR;
extern volatile ADC0SC1BSTR _ADC0SC1B @0x00000041;
#define ADC0SC1B                        _ADC0SC1B.Byte
#define ADC0SC1B_ADCHB0                 _ADC0SC1B.Bits.ADCHB0
#define ADC0SC1B_ADCHB1                 _ADC0SC1B.Bits.ADCHB1
#define ADC0SC1B_ADCHB2                 _ADC0SC1B.Bits.ADCHB2
#define ADC0SC1B_ADCHB3                 _ADC0SC1B.Bits.ADCHB3
#define ADC0SC1B_ADCHB4                 _ADC0SC1B.Bits.ADCHB4
#define ADC0SC1B_DIFFB                  _ADC0SC1B.Bits.DIFFB
#define ADC0SC1B_AIENB                  _ADC0SC1B.Bits.AIENB
#define ADC0SC1B_COCOB                  _ADC0SC1B.Bits.COCOB
#define ADC0SC1B_ADCHB                  _ADC0SC1B.MergedBits.grpADCHB

#define ADC0SC1B_ADCHB0_MASK            1
#define ADC0SC1B_ADCHB1_MASK            2
#define ADC0SC1B_ADCHB2_MASK            4
#define ADC0SC1B_ADCHB3_MASK            8
#define ADC0SC1B_ADCHB4_MASK            16
#define ADC0SC1B_DIFFB_MASK             32
#define ADC0SC1B_AIENB_MASK             64
#define ADC0SC1B_COCOB_MASK             128
#define ADC0SC1B_ADCHB_MASK             31
#define ADC0SC1B_ADCHB_BITNUM           0


/*** ADC0CFG1 - Configuration Register 1; 0x00000042 ***/
typedef union {
  byte Byte;
  struct {
    byte ADICLK0     :1;                                       /* Input Clock Select Bit 0 */
    byte ADICLK1     :1;                                       /* Input Clock Select Bit 1 */
    byte MODE0       :1;                                       /* Conversion Mode Selection Bit 0 */
    byte MODE1       :1;                                       /* Conversion Mode Selection Bit 1 */
    byte ADLSMP      :1;                                       /* Long Sample Time Configuration */
    byte ADIV0       :1;                                       /* Clock Divide Select Bit 0 */
    byte ADIV1       :1;                                       /* Clock Divide Select Bit 1 */
    byte ADLPC       :1;                                       /* Low Power Configuration */
  } Bits;
  struct {
    byte grpADICLK :2;
    byte grpMODE :2;
    byte         :1;
    byte grpADIV :2;
    byte         :1;
  } MergedBits;
} ADC0CFG1STR;
extern volatile ADC0CFG1STR _ADC0CFG1 @0x00000042;
#define ADC0CFG1                        _ADC0CFG1.Byte
#define ADC0CFG1_ADICLK0                _ADC0CFG1.Bits.ADICLK0
#define ADC0CFG1_ADICLK1                _ADC0CFG1.Bits.ADICLK1
#define ADC0CFG1_MODE0                  _ADC0CFG1.Bits.MODE0
#define ADC0CFG1_MODE1                  _ADC0CFG1.Bits.MODE1
#define ADC0CFG1_ADLSMP                 _ADC0CFG1.Bits.ADLSMP
#define ADC0CFG1_ADIV0                  _ADC0CFG1.Bits.ADIV0
#define ADC0CFG1_ADIV1                  _ADC0CFG1.Bits.ADIV1
#define ADC0CFG1_ADLPC                  _ADC0CFG1.Bits.ADLPC
#define ADC0CFG1_ADICLK                 _ADC0CFG1.MergedBits.grpADICLK
#define ADC0CFG1_MODE                   _ADC0CFG1.MergedBits.grpMODE
#define ADC0CFG1_ADIV                   _ADC0CFG1.MergedBits.grpADIV

#define ADC0CFG1_ADICLK0_MASK           1
#define ADC0CFG1_ADICLK1_MASK           2
#define ADC0CFG1_MODE0_MASK             4
#define ADC0CFG1_MODE1_MASK             8
#define ADC0CFG1_ADLSMP_MASK            16
#define ADC0CFG1_ADIV0_MASK             32
#define ADC0CFG1_ADIV1_MASK             64
#define ADC0CFG1_ADLPC_MASK             128
#define ADC0CFG1_ADICLK_MASK            3
#define ADC0CFG1_ADICLK_BITNUM          0
#define ADC0CFG1_MODE_MASK              12
#define ADC0CFG1_MODE_BITNUM            2
#define ADC0CFG1_ADIV_MASK              96
#define ADC0CFG1_ADIV_BITNUM            5


/*** ADC0CFG2 - Configuration Register 2; 0x00000043 ***/
typedef union {
  byte Byte;
  struct {
    byte ADLSTS0     :1;                                       /* Long Sample Time Select Bit 0 */
    byte ADLSTS1     :1;                                       /* Long Sample Time Select Bit 1 */
    byte ADHSC       :1;                                       /* High Speed Configuration */
    byte ADACKEN     :1;                                       /* Asynchronous Clock Output Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpADLSTS :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} ADC0CFG2STR;
extern volatile ADC0CFG2STR _ADC0CFG2 @0x00000043;
#define ADC0CFG2                        _ADC0CFG2.Byte
#define ADC0CFG2_ADLSTS0                _ADC0CFG2.Bits.ADLSTS0
#define ADC0CFG2_ADLSTS1                _ADC0CFG2.Bits.ADLSTS1
#define ADC0CFG2_ADHSC                  _ADC0CFG2.Bits.ADHSC
#define ADC0CFG2_ADACKEN                _ADC0CFG2.Bits.ADACKEN
#define ADC0CFG2_ADLSTS                 _ADC0CFG2.MergedBits.grpADLSTS

#define ADC0CFG2_ADLSTS0_MASK           1
#define ADC0CFG2_ADLSTS1_MASK           2
#define ADC0CFG2_ADHSC_MASK             4
#define ADC0CFG2_ADACKEN_MASK           8
#define ADC0CFG2_ADLSTS_MASK            3
#define ADC0CFG2_ADLSTS_BITNUM          0


/*** ADC0RA - Data Result Register A; 0x00000044 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ADC0RHA - Data Result High Register A; 0x00000044 ***/
    union {
      byte Byte;
      struct {
        byte D8          :1;                                       /* ADC Result Data Bit 8 */
        byte D9          :1;                                       /* ADC Result Data Bit 9 */
        byte D10         :1;                                       /* ADC Result Data Bit 10 */
        byte D11         :1;                                       /* ADC Result Data Bit 11 */
        byte D12         :1;                                       /* ADC Result Data Bit 12 */
        byte D13         :1;                                       /* ADC Result Data Bit 13 */
        byte D14         :1;                                       /* ADC Result Data Bit 14 */
        byte D15         :1;                                       /* ADC Result Data Bit 15 */
      } Bits;
    } ADC0RHASTR;
    #define ADC0RHA                     _ADC0RA.Overlap_STR.ADC0RHASTR.Byte
    #define ADC0RHA_D8                  _ADC0RA.Overlap_STR.ADC0RHASTR.Bits.D8
    #define ADC0RHA_D9                  _ADC0RA.Overlap_STR.ADC0RHASTR.Bits.D9
    #define ADC0RHA_D10                 _ADC0RA.Overlap_STR.ADC0RHASTR.Bits.D10
    #define ADC0RHA_D11                 _ADC0RA.Overlap_STR.ADC0RHASTR.Bits.D11
    #define ADC0RHA_D12                 _ADC0RA.Overlap_STR.ADC0RHASTR.Bits.D12
    #define ADC0RHA_D13                 _ADC0RA.Overlap_STR.ADC0RHASTR.Bits.D13
    #define ADC0RHA_D14                 _ADC0RA.Overlap_STR.ADC0RHASTR.Bits.D14
    #define ADC0RHA_D15                 _ADC0RA.Overlap_STR.ADC0RHASTR.Bits.D15
    
    #define ADC0RHA_D8_MASK             1
    #define ADC0RHA_D9_MASK             2
    #define ADC0RHA_D10_MASK            4
    #define ADC0RHA_D11_MASK            8
    #define ADC0RHA_D12_MASK            16
    #define ADC0RHA_D13_MASK            32
    #define ADC0RHA_D14_MASK            64
    #define ADC0RHA_D15_MASK            128
    

    /*** ADC0RLA - Data Result Low Register A; 0x00000045 ***/
    union {
      byte Byte;
      struct {
        byte D0          :1;                                       /* ADC Result Data Bit 0 */
        byte D1          :1;                                       /* ADC Result Data Bit 1 */
        byte D2          :1;                                       /* ADC Result Data Bit 2 */
        byte D3          :1;                                       /* ADC Result Data Bit 3 */
        byte D4          :1;                                       /* ADC Result Data Bit 4 */
        byte D5          :1;                                       /* ADC Result Data Bit 5 */
        byte D6          :1;                                       /* ADC Result Data Bit 6 */
        byte D7          :1;                                       /* ADC Result Data Bit 7 */
      } Bits;
    } ADC0RLASTR;
    #define ADC0RLA                     _ADC0RA.Overlap_STR.ADC0RLASTR.Byte
    #define ADC0RLA_D0                  _ADC0RA.Overlap_STR.ADC0RLASTR.Bits.D0
    #define ADC0RLA_D1                  _ADC0RA.Overlap_STR.ADC0RLASTR.Bits.D1
    #define ADC0RLA_D2                  _ADC0RA.Overlap_STR.ADC0RLASTR.Bits.D2
    #define ADC0RLA_D3                  _ADC0RA.Overlap_STR.ADC0RLASTR.Bits.D3
    #define ADC0RLA_D4                  _ADC0RA.Overlap_STR.ADC0RLASTR.Bits.D4
    #define ADC0RLA_D5                  _ADC0RA.Overlap_STR.ADC0RLASTR.Bits.D5
    #define ADC0RLA_D6                  _ADC0RA.Overlap_STR.ADC0RLASTR.Bits.D6
    #define ADC0RLA_D7                  _ADC0RA.Overlap_STR.ADC0RLASTR.Bits.D7
    
    #define ADC0RLA_D0_MASK             1
    #define ADC0RLA_D1_MASK             2
    #define ADC0RLA_D2_MASK             4
    #define ADC0RLA_D3_MASK             8
    #define ADC0RLA_D4_MASK             16
    #define ADC0RLA_D5_MASK             32
    #define ADC0RLA_D6_MASK             64
    #define ADC0RLA_D7_MASK             128
    
  } Overlap_STR;

} ADC0RASTR;
extern volatile ADC0RASTR _ADC0RA @0x00000044;
#define ADC0RA                          _ADC0RA.Word


/*** ADC0RB - Data Result Register B; 0x00000046 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ADC0RHB - Data Result High Register B; 0x00000046 ***/
    union {
      byte Byte;
      struct {
        byte D8          :1;                                       /* ADC Result Data Bit 8 */
        byte D9          :1;                                       /* ADC Result Data Bit 9 */
        byte D10         :1;                                       /* ADC Result Data Bit 10 */
        byte D11         :1;                                       /* ADC Result Data Bit 11 */
        byte D12         :1;                                       /* ADC Result Data Bit 12 */
        byte D13         :1;                                       /* ADC Result Data Bit 13 */
        byte D14         :1;                                       /* ADC Result Data Bit 14 */
        byte D15         :1;                                       /* ADC Result Data Bit 15 */
      } Bits;
    } ADC0RHBSTR;
    #define ADC0RHB                     _ADC0RB.Overlap_STR.ADC0RHBSTR.Byte
    #define ADC0RHB_D8                  _ADC0RB.Overlap_STR.ADC0RHBSTR.Bits.D8
    #define ADC0RHB_D9                  _ADC0RB.Overlap_STR.ADC0RHBSTR.Bits.D9
    #define ADC0RHB_D10                 _ADC0RB.Overlap_STR.ADC0RHBSTR.Bits.D10
    #define ADC0RHB_D11                 _ADC0RB.Overlap_STR.ADC0RHBSTR.Bits.D11
    #define ADC0RHB_D12                 _ADC0RB.Overlap_STR.ADC0RHBSTR.Bits.D12
    #define ADC0RHB_D13                 _ADC0RB.Overlap_STR.ADC0RHBSTR.Bits.D13
    #define ADC0RHB_D14                 _ADC0RB.Overlap_STR.ADC0RHBSTR.Bits.D14
    #define ADC0RHB_D15                 _ADC0RB.Overlap_STR.ADC0RHBSTR.Bits.D15
    
    #define ADC0RHB_D8_MASK             1
    #define ADC0RHB_D9_MASK             2
    #define ADC0RHB_D10_MASK            4
    #define ADC0RHB_D11_MASK            8
    #define ADC0RHB_D12_MASK            16
    #define ADC0RHB_D13_MASK            32
    #define ADC0RHB_D14_MASK            64
    #define ADC0RHB_D15_MASK            128
    

    /*** ADC0RLB - Data Result Low Register B; 0x00000047 ***/
    union {
      byte Byte;
      struct {
        byte D0          :1;                                       /* ADC Result Data Bit 0 */
        byte D1          :1;                                       /* ADC Result Data Bit 1 */
        byte D2          :1;                                       /* ADC Result Data Bit 2 */
        byte D3          :1;                                       /* ADC Result Data Bit 3 */
        byte D4          :1;                                       /* ADC Result Data Bit 4 */
        byte D5          :1;                                       /* ADC Result Data Bit 5 */
        byte D6          :1;                                       /* ADC Result Data Bit 6 */
        byte D7          :1;                                       /* ADC Result Data Bit 7 */
      } Bits;
    } ADC0RLBSTR;
    #define ADC0RLB                     _ADC0RB.Overlap_STR.ADC0RLBSTR.Byte
    #define ADC0RLB_D0                  _ADC0RB.Overlap_STR.ADC0RLBSTR.Bits.D0
    #define ADC0RLB_D1                  _ADC0RB.Overlap_STR.ADC0RLBSTR.Bits.D1
    #define ADC0RLB_D2                  _ADC0RB.Overlap_STR.ADC0RLBSTR.Bits.D2
    #define ADC0RLB_D3                  _ADC0RB.Overlap_STR.ADC0RLBSTR.Bits.D3
    #define ADC0RLB_D4                  _ADC0RB.Overlap_STR.ADC0RLBSTR.Bits.D4
    #define ADC0RLB_D5                  _ADC0RB.Overlap_STR.ADC0RLBSTR.Bits.D5
    #define ADC0RLB_D6                  _ADC0RB.Overlap_STR.ADC0RLBSTR.Bits.D6
    #define ADC0RLB_D7                  _ADC0RB.Overlap_STR.ADC0RLBSTR.Bits.D7
    
    #define ADC0RLB_D0_MASK             1
    #define ADC0RLB_D1_MASK             2
    #define ADC0RLB_D2_MASK             4
    #define ADC0RLB_D3_MASK             8
    #define ADC0RLB_D4_MASK             16
    #define ADC0RLB_D5_MASK             32
    #define ADC0RLB_D6_MASK             64
    #define ADC0RLB_D7_MASK             128
    
  } Overlap_STR;

} ADC0RBSTR;
extern volatile ADC0RBSTR _ADC0RB @0x00000046;
#define ADC0RB                          _ADC0RB.Word


/*** SPI0C1 - SPI0 Control Register 1; 0x00000048 ***/
typedef union {
  byte Byte;
  struct {
    byte LSBFE       :1;                                       /* LSB First (Shifter Direction) */
    byte SSOE        :1;                                       /* Slave Select Output Enable */
    byte CPHA        :1;                                       /* Clock Phase */
    byte CPOL        :1;                                       /* Clock Polarity */
    byte MSTR        :1;                                       /* Master/Slave Mode Select */
    byte SPTIE       :1;                                       /* SPI Transmit Interrupt Enable */
    byte SPE         :1;                                       /* SPI System Enable */
    byte SPIE        :1;                                       /* SPI Interrupt Enable (for SPRF and MODF) */
  } Bits;
} SPI0C1STR;
extern volatile SPI0C1STR _SPI0C1 @0x00000048;
#define SPI0C1                          _SPI0C1.Byte
#define SPI0C1_LSBFE                    _SPI0C1.Bits.LSBFE
#define SPI0C1_SSOE                     _SPI0C1.Bits.SSOE
#define SPI0C1_CPHA                     _SPI0C1.Bits.CPHA
#define SPI0C1_CPOL                     _SPI0C1.Bits.CPOL
#define SPI0C1_MSTR                     _SPI0C1.Bits.MSTR
#define SPI0C1_SPTIE                    _SPI0C1.Bits.SPTIE
#define SPI0C1_SPE                      _SPI0C1.Bits.SPE
#define SPI0C1_SPIE                     _SPI0C1.Bits.SPIE

#define SPI0C1_LSBFE_MASK               1
#define SPI0C1_SSOE_MASK                2
#define SPI0C1_CPHA_MASK                4
#define SPI0C1_CPOL_MASK                8
#define SPI0C1_MSTR_MASK                16
#define SPI0C1_SPTIE_MASK               32
#define SPI0C1_SPE_MASK                 64
#define SPI0C1_SPIE_MASK                128


/*** SPI0C2 - SPI0 Control Register 2; 0x00000049 ***/
typedef union {
  byte Byte;
  struct {
    byte SPC0        :1;                                       /* SPI Pin Control 0 */
    byte SPISWAI     :1;                                       /* SPI Stop in Wait Mode */
    byte             :1; 
    byte BIDIROE     :1;                                       /* Bidirectional Mode Output Enable */
    byte MODFEN      :1;                                       /* Master Mode-Fault Function Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} SPI0C2STR;
extern volatile SPI0C2STR _SPI0C2 @0x00000049;
#define SPI0C2                          _SPI0C2.Byte
#define SPI0C2_SPC0                     _SPI0C2.Bits.SPC0
#define SPI0C2_SPISWAI                  _SPI0C2.Bits.SPISWAI
#define SPI0C2_BIDIROE                  _SPI0C2.Bits.BIDIROE
#define SPI0C2_MODFEN                   _SPI0C2.Bits.MODFEN

#define SPI0C2_SPC0_MASK                1
#define SPI0C2_SPISWAI_MASK             2
#define SPI0C2_BIDIROE_MASK             8
#define SPI0C2_MODFEN_MASK              16


/*** SPI0BR - SPI0 Baud Rate Register; 0x0000004A ***/
typedef union {
  byte Byte;
  struct {
    byte SPR0        :1;                                       /* SPI Baud Rate Divisor Bit 0 */
    byte SPR1        :1;                                       /* SPI Baud Rate Divisor Bit 1 */
    byte SPR2        :1;                                       /* SPI Baud Rate Divisor Bit 2 */
    byte SPR3        :1;                                       /* SPI Baud Rate Divisor Bit 3 */
    byte SPPR0       :1;                                       /* SPI Baud Rate Prescale Divisor Bit 0 */
    byte SPPR1       :1;                                       /* SPI Baud Rate Prescale Divisor Bit 1 */
    byte SPPR2       :1;                                       /* SPI Baud Rate Prescale Divisor Bit 2 */
    byte             :1; 
  } Bits;
  struct {
    byte grpSPR  :4;
    byte grpSPPR :3;
    byte         :1;
  } MergedBits;
} SPI0BRSTR;
extern volatile SPI0BRSTR _SPI0BR @0x0000004A;
#define SPI0BR                          _SPI0BR.Byte
#define SPI0BR_SPR0                     _SPI0BR.Bits.SPR0
#define SPI0BR_SPR1                     _SPI0BR.Bits.SPR1
#define SPI0BR_SPR2                     _SPI0BR.Bits.SPR2
#define SPI0BR_SPR3                     _SPI0BR.Bits.SPR3
#define SPI0BR_SPPR0                    _SPI0BR.Bits.SPPR0
#define SPI0BR_SPPR1                    _SPI0BR.Bits.SPPR1
#define SPI0BR_SPPR2                    _SPI0BR.Bits.SPPR2
#define SPI0BR_SPR                      _SPI0BR.MergedBits.grpSPR
#define SPI0BR_SPPR                     _SPI0BR.MergedBits.grpSPPR

#define SPI0BR_SPR0_MASK                1
#define SPI0BR_SPR1_MASK                2
#define SPI0BR_SPR2_MASK                4
#define SPI0BR_SPR3_MASK                8
#define SPI0BR_SPPR0_MASK               16
#define SPI0BR_SPPR1_MASK               32
#define SPI0BR_SPPR2_MASK               64
#define SPI0BR_SPR_MASK                 15
#define SPI0BR_SPR_BITNUM               0
#define SPI0BR_SPPR_MASK                112
#define SPI0BR_SPPR_BITNUM              4


/*** SPI0S - SPI0 Status Register; 0x0000004B ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MODF        :1;                                       /* Master Mode Fault Flag */
    byte SPTEF       :1;                                       /* SPI Transmit Buffer Empty Flag */
    byte             :1; 
    byte SPRF        :1;                                       /* SPI Read Buffer Full Flag */
  } Bits;
} SPI0SSTR;
extern volatile SPI0SSTR _SPI0S @0x0000004B;
#define SPI0S                           _SPI0S.Byte
#define SPI0S_MODF                      _SPI0S.Bits.MODF
#define SPI0S_SPTEF                     _SPI0S.Bits.SPTEF
#define SPI0S_SPRF                      _SPI0S.Bits.SPRF

#define SPI0S_MODF_MASK                 16
#define SPI0S_SPTEF_MASK                32
#define SPI0S_SPRF_MASK                 128


/*** SPI0D - SPI0 Data Register; 0x0000004D ***/
typedef union {
  byte Byte;
} SPI0DSTR;
extern volatile SPI0DSTR _SPI0D @0x0000004D;
#define SPI0D                           _SPI0D.Byte


/*** SPI1C1 - SPI1 Control Register 1; 0x00000050 ***/
typedef union {
  byte Byte;
  struct {
    byte LSBFE       :1;                                       /* LSB First (Shifter Direction) */
    byte SSOE        :1;                                       /* Slave Select Output Enable */
    byte CPHA        :1;                                       /* Clock Phase */
    byte CPOL        :1;                                       /* Clock Polarity */
    byte MSTR        :1;                                       /* Master/Slave Mode Select */
    byte SPTIE       :1;                                       /* SPI Transmit Interrupt Enable */
    byte SPE         :1;                                       /* SPI System Enable */
    byte SPIE        :1;                                       /* SPI Interrupt Enable (for SPRF and MODF) */
  } Bits;
} SPI1C1STR;
extern volatile SPI1C1STR _SPI1C1 @0x00000050;
#define SPI1C1                          _SPI1C1.Byte
#define SPI1C1_LSBFE                    _SPI1C1.Bits.LSBFE
#define SPI1C1_SSOE                     _SPI1C1.Bits.SSOE
#define SPI1C1_CPHA                     _SPI1C1.Bits.CPHA
#define SPI1C1_CPOL                     _SPI1C1.Bits.CPOL
#define SPI1C1_MSTR                     _SPI1C1.Bits.MSTR
#define SPI1C1_SPTIE                    _SPI1C1.Bits.SPTIE
#define SPI1C1_SPE                      _SPI1C1.Bits.SPE
#define SPI1C1_SPIE                     _SPI1C1.Bits.SPIE

#define SPI1C1_LSBFE_MASK               1
#define SPI1C1_SSOE_MASK                2
#define SPI1C1_CPHA_MASK                4
#define SPI1C1_CPOL_MASK                8
#define SPI1C1_MSTR_MASK                16
#define SPI1C1_SPTIE_MASK               32
#define SPI1C1_SPE_MASK                 64
#define SPI1C1_SPIE_MASK                128


/*** SPI1C2 - SPI1 Control Register 2; 0x00000051 ***/
typedef union {
  byte Byte;
  struct {
    byte SPC0        :1;                                       /* SPI Pin Control 0 */
    byte SPISWAI     :1;                                       /* SPI Stop in Wait Mode */
    byte             :1; 
    byte BIDIROE     :1;                                       /* Bidirectional Mode Output Enable */
    byte MODFEN      :1;                                       /* Master Mode-Fault Function Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} SPI1C2STR;
extern volatile SPI1C2STR _SPI1C2 @0x00000051;
#define SPI1C2                          _SPI1C2.Byte
#define SPI1C2_SPC0                     _SPI1C2.Bits.SPC0
#define SPI1C2_SPISWAI                  _SPI1C2.Bits.SPISWAI
#define SPI1C2_BIDIROE                  _SPI1C2.Bits.BIDIROE
#define SPI1C2_MODFEN                   _SPI1C2.Bits.MODFEN

#define SPI1C2_SPC0_MASK                1
#define SPI1C2_SPISWAI_MASK             2
#define SPI1C2_BIDIROE_MASK             8
#define SPI1C2_MODFEN_MASK              16


/*** SPI1BR - SPI1 Baud Rate Register; 0x00000052 ***/
typedef union {
  byte Byte;
  struct {
    byte SPR0        :1;                                       /* SPI Baud Rate Divisor Bit 0 */
    byte SPR1        :1;                                       /* SPI Baud Rate Divisor Bit 1 */
    byte SPR2        :1;                                       /* SPI Baud Rate Divisor Bit 2 */
    byte SPR3        :1;                                       /* SPI Baud Rate Divisor Bit 3 */
    byte SPPR0       :1;                                       /* SPI Baud Rate Prescale Divisor Bit 0 */
    byte SPPR1       :1;                                       /* SPI Baud Rate Prescale Divisor Bit 1 */
    byte SPPR2       :1;                                       /* SPI Baud Rate Prescale Divisor Bit 2 */
    byte             :1; 
  } Bits;
  struct {
    byte grpSPR  :4;
    byte grpSPPR :3;
    byte         :1;
  } MergedBits;
} SPI1BRSTR;
extern volatile SPI1BRSTR _SPI1BR @0x00000052;
#define SPI1BR                          _SPI1BR.Byte
#define SPI1BR_SPR0                     _SPI1BR.Bits.SPR0
#define SPI1BR_SPR1                     _SPI1BR.Bits.SPR1
#define SPI1BR_SPR2                     _SPI1BR.Bits.SPR2
#define SPI1BR_SPR3                     _SPI1BR.Bits.SPR3
#define SPI1BR_SPPR0                    _SPI1BR.Bits.SPPR0
#define SPI1BR_SPPR1                    _SPI1BR.Bits.SPPR1
#define SPI1BR_SPPR2                    _SPI1BR.Bits.SPPR2
#define SPI1BR_SPR                      _SPI1BR.MergedBits.grpSPR
#define SPI1BR_SPPR                     _SPI1BR.MergedBits.grpSPPR

#define SPI1BR_SPR0_MASK                1
#define SPI1BR_SPR1_MASK                2
#define SPI1BR_SPR2_MASK                4
#define SPI1BR_SPR3_MASK                8
#define SPI1BR_SPPR0_MASK               16
#define SPI1BR_SPPR1_MASK               32
#define SPI1BR_SPPR2_MASK               64
#define SPI1BR_SPR_MASK                 15
#define SPI1BR_SPR_BITNUM               0
#define SPI1BR_SPPR_MASK                112
#define SPI1BR_SPPR_BITNUM              4


/*** SPI1S - SPI1 Status Register; 0x00000053 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MODF        :1;                                       /* Master Mode Fault Flag */
    byte SPTEF       :1;                                       /* SPI Transmit Buffer Empty Flag */
    byte             :1; 
    byte SPRF        :1;                                       /* SPI Read Buffer Full Flag */
  } Bits;
} SPI1SSTR;
extern volatile SPI1SSTR _SPI1S @0x00000053;
#define SPI1S                           _SPI1S.Byte
#define SPI1S_MODF                      _SPI1S.Bits.MODF
#define SPI1S_SPTEF                     _SPI1S.Bits.SPTEF
#define SPI1S_SPRF                      _SPI1S.Bits.SPRF

#define SPI1S_MODF_MASK                 16
#define SPI1S_SPTEF_MASK                32
#define SPI1S_SPRF_MASK                 128


/*** SPI1D - SPI1 Data Register; 0x00000055 ***/
typedef union {
  byte Byte;
} SPI1DSTR;
extern volatile SPI1DSTR _SPI1D @0x00000055;
#define SPI1D                           _SPI1D.Byte


/*** SPI2C1 - SPI2 Control Register 1; 0x00000058 ***/
typedef union {
  byte Byte;
  struct {
    byte LSBFE       :1;                                       /* LSB First (Shifter Direction) */
    byte SSOE        :1;                                       /* Slave Select Output Enable */
    byte CPHA        :1;                                       /* Clock Phase */
    byte CPOL        :1;                                       /* Clock Polarity */
    byte MSTR        :1;                                       /* Master/Slave Mode Select */
    byte SPTIE       :1;                                       /* SPI Transmit Interrupt Enable */
    byte SPE         :1;                                       /* SPI System Enable */
    byte SPIE        :1;                                       /* SPI Interrupt Enable (for SPRF and MODF) */
  } Bits;
} SPI2C1STR;
extern volatile SPI2C1STR _SPI2C1 @0x00000058;
#define SPI2C1                          _SPI2C1.Byte
#define SPI2C1_LSBFE                    _SPI2C1.Bits.LSBFE
#define SPI2C1_SSOE                     _SPI2C1.Bits.SSOE
#define SPI2C1_CPHA                     _SPI2C1.Bits.CPHA
#define SPI2C1_CPOL                     _SPI2C1.Bits.CPOL
#define SPI2C1_MSTR                     _SPI2C1.Bits.MSTR
#define SPI2C1_SPTIE                    _SPI2C1.Bits.SPTIE
#define SPI2C1_SPE                      _SPI2C1.Bits.SPE
#define SPI2C1_SPIE                     _SPI2C1.Bits.SPIE

#define SPI2C1_LSBFE_MASK               1
#define SPI2C1_SSOE_MASK                2
#define SPI2C1_CPHA_MASK                4
#define SPI2C1_CPOL_MASK                8
#define SPI2C1_MSTR_MASK                16
#define SPI2C1_SPTIE_MASK               32
#define SPI2C1_SPE_MASK                 64
#define SPI2C1_SPIE_MASK                128


/*** SPI2C2 - SPI2 Control Register 2; 0x00000059 ***/
typedef union {
  byte Byte;
  struct {
    byte SPC0        :1;                                       /* SPI Pin Control 0 */
    byte SPISWAI     :1;                                       /* SPI Stop in Wait Mode */
    byte             :1; 
    byte BIDIROE     :1;                                       /* Bidirectional Mode Output Enable */
    byte MODFEN      :1;                                       /* Master Mode-Fault Function Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} SPI2C2STR;
extern volatile SPI2C2STR _SPI2C2 @0x00000059;
#define SPI2C2                          _SPI2C2.Byte
#define SPI2C2_SPC0                     _SPI2C2.Bits.SPC0
#define SPI2C2_SPISWAI                  _SPI2C2.Bits.SPISWAI
#define SPI2C2_BIDIROE                  _SPI2C2.Bits.BIDIROE
#define SPI2C2_MODFEN                   _SPI2C2.Bits.MODFEN

#define SPI2C2_SPC0_MASK                1
#define SPI2C2_SPISWAI_MASK             2
#define SPI2C2_BIDIROE_MASK             8
#define SPI2C2_MODFEN_MASK              16


/*** SPI2BR - SPI2 Baud Rate Register; 0x0000005A ***/
typedef union {
  byte Byte;
  struct {
    byte SPR0        :1;                                       /* SPI Baud Rate Divisor Bit 0 */
    byte SPR1        :1;                                       /* SPI Baud Rate Divisor Bit 1 */
    byte SPR2        :1;                                       /* SPI Baud Rate Divisor Bit 2 */
    byte SPR3        :1;                                       /* SPI Baud Rate Divisor Bit 3 */
    byte SPPR0       :1;                                       /* SPI Baud Rate Prescale Divisor Bit 0 */
    byte SPPR1       :1;                                       /* SPI Baud Rate Prescale Divisor Bit 1 */
    byte SPPR2       :1;                                       /* SPI Baud Rate Prescale Divisor Bit 2 */
    byte             :1; 
  } Bits;
  struct {
    byte grpSPR  :4;
    byte grpSPPR :3;
    byte         :1;
  } MergedBits;
} SPI2BRSTR;
extern volatile SPI2BRSTR _SPI2BR @0x0000005A;
#define SPI2BR                          _SPI2BR.Byte
#define SPI2BR_SPR0                     _SPI2BR.Bits.SPR0
#define SPI2BR_SPR1                     _SPI2BR.Bits.SPR1
#define SPI2BR_SPR2                     _SPI2BR.Bits.SPR2
#define SPI2BR_SPR3                     _SPI2BR.Bits.SPR3
#define SPI2BR_SPPR0                    _SPI2BR.Bits.SPPR0
#define SPI2BR_SPPR1                    _SPI2BR.Bits.SPPR1
#define SPI2BR_SPPR2                    _SPI2BR.Bits.SPPR2
#define SPI2BR_SPR                      _SPI2BR.MergedBits.grpSPR
#define SPI2BR_SPPR                     _SPI2BR.MergedBits.grpSPPR

#define SPI2BR_SPR0_MASK                1
#define SPI2BR_SPR1_MASK                2
#define SPI2BR_SPR2_MASK                4
#define SPI2BR_SPR3_MASK                8
#define SPI2BR_SPPR0_MASK               16
#define SPI2BR_SPPR1_MASK               32
#define SPI2BR_SPPR2_MASK               64
#define SPI2BR_SPR_MASK                 15
#define SPI2BR_SPR_BITNUM               0
#define SPI2BR_SPPR_MASK                112
#define SPI2BR_SPPR_BITNUM              4


/*** SPI2S - SPI2 Status Register; 0x0000005B ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MODF        :1;                                       /* Master Mode Fault Flag */
    byte SPTEF       :1;                                       /* SPI Transmit Buffer Empty Flag */
    byte             :1; 
    byte SPRF        :1;                                       /* SPI Read Buffer Full Flag */
  } Bits;
} SPI2SSTR;
extern volatile SPI2SSTR _SPI2S @0x0000005B;
#define SPI2S                           _SPI2S.Byte
#define SPI2S_MODF                      _SPI2S.Bits.MODF
#define SPI2S_SPTEF                     _SPI2S.Bits.SPTEF
#define SPI2S_SPRF                      _SPI2S.Bits.SPRF

#define SPI2S_MODF_MASK                 16
#define SPI2S_SPTEF_MASK                32
#define SPI2S_SPRF_MASK                 128


/*** SPI2D - SPI2 Data Register; 0x0000005D ***/
typedef union {
  byte Byte;
} SPI2DSTR;
extern volatile SPI2DSTR _SPI2D @0x0000005D;
#define SPI2D                           _SPI2D.Byte


/*** PCNT_STATUS - PCounter Status Register; 0x00000060 ***/
typedef union {
  word Word;
  struct {
    word FCOVF       :1;                                       /* FCounter Overflow Flag */
    word RCOVF       :1;                                       /* RCounter Overflow Flag */
    word SINVF       :1;                                       /* State Invalid Interrupt Flag */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word CURR_INV    :3;                                       /* Current state of the state machine when a state invalid event occurs, bit 0 */
    word             :1; 
    word PSTATE_INV  :3;                                       /* Sensor input pin state when a state invalid event occurs, bit 0 */
    word             :1; 
  } Bits;
} PCNT_STATUSSTR;
extern volatile PCNT_STATUSSTR _PCNT_STATUS @0x00000060;
#define PCNT_STATUS                     _PCNT_STATUS.Word
#define PCNT_STATUS_FCOVF               _PCNT_STATUS.Bits.FCOVF
#define PCNT_STATUS_RCOVF               _PCNT_STATUS.Bits.RCOVF
#define PCNT_STATUS_SINVF               _PCNT_STATUS.Bits.SINVF
#define PCNT_STATUS_CURR_INV            _PCNT_STATUS.Bits.CURR_INV
#define PCNT_STATUS_PSTATE_INV          _PCNT_STATUS.Bits.PSTATE_INV

#define PCNT_STATUS_FCOVF_MASK          1
#define PCNT_STATUS_RCOVF_MASK          2
#define PCNT_STATUS_SINVF_MASK          4
#define PCNT_STATUS_CURR_INV_MASK       1792
#define PCNT_STATUS_CURR_INV_BITNUM     8
#define PCNT_STATUS_PSTATE_INV_MASK     28672
#define PCNT_STATUS_PSTATE_INV_BITNUM   12


/*** PCNT_CTRL - PCounter Control Register; 0x00000062 ***/
typedef union {
  word Word;
  struct {
    word FILTER_VALUE :4;                                      /* Filter value bit 0 */
    word CPWMS       :1;                                       /* CPWM Selection */
    word POL         :1;                                       /* Polarity bit */
    word DIR         :1;                                       /* Direction bit */
    word PCNT_EN     :1;                                       /* Enable/Disable bit */
    word CHANNEL_SEL :3;                                       /* Channel select bit 0 */
    word MODE0       :1;                                       /* Mode select, bit 0 */
    word MODE1       :1;                                       /* Mode select, bit 1 */
    word FCOVFIE     :1;                                       /* FCounter Overflow Interrupt Enable bit */
    word RCOVFIE     :1;                                       /* RCounter Overflow Interrupt Eenable bit */
    word SINVIE      :1;                                       /* State Invalid Interrupt Enable bit */
  } Bits;
  struct {
    word         :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :3;
    word grpMODE :2;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} PCNT_CTRLSTR;
extern volatile PCNT_CTRLSTR _PCNT_CTRL @0x00000062;
#define PCNT_CTRL                       _PCNT_CTRL.Word
#define PCNT_CTRL_FILTER_VALUE          _PCNT_CTRL.Bits.FILTER_VALUE
#define PCNT_CTRL_CPWMS                 _PCNT_CTRL.Bits.CPWMS
#define PCNT_CTRL_POL                   _PCNT_CTRL.Bits.POL
#define PCNT_CTRL_DIR                   _PCNT_CTRL.Bits.DIR
#define PCNT_CTRL_PCNT_EN               _PCNT_CTRL.Bits.PCNT_EN
#define PCNT_CTRL_CHANNEL_SEL           _PCNT_CTRL.Bits.CHANNEL_SEL
#define PCNT_CTRL_MODE0                 _PCNT_CTRL.Bits.MODE0
#define PCNT_CTRL_MODE1                 _PCNT_CTRL.Bits.MODE1
#define PCNT_CTRL_FCOVFIE               _PCNT_CTRL.Bits.FCOVFIE
#define PCNT_CTRL_RCOVFIE               _PCNT_CTRL.Bits.RCOVFIE
#define PCNT_CTRL_SINVIE                _PCNT_CTRL.Bits.SINVIE
#define PCNT_CTRL_MODE                  _PCNT_CTRL.MergedBits.grpMODE

#define PCNT_CTRL_FILTER_VALUE_MASK     15
#define PCNT_CTRL_FILTER_VALUE_BITNUM   0
#define PCNT_CTRL_CPWMS_MASK            16
#define PCNT_CTRL_POL_MASK              32
#define PCNT_CTRL_DIR_MASK              64
#define PCNT_CTRL_PCNT_EN_MASK          128
#define PCNT_CTRL_CHANNEL_SEL_MASK      1792
#define PCNT_CTRL_CHANNEL_SEL_BITNUM    8
#define PCNT_CTRL_MODE0_MASK            2048
#define PCNT_CTRL_MODE1_MASK            4096
#define PCNT_CTRL_FCOVFIE_MASK          8192
#define PCNT_CTRL_RCOVFIE_MASK          16384
#define PCNT_CTRL_SINVIE_MASK           32768
#define PCNT_CTRL_MODE_MASK             6144
#define PCNT_CTRL_MODE_BITNUM           11


/*** PCNT_FCMOD - PCounter Forward Counter Modulus Register; 0x00000064 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PCNT_FCMOD_H - PCounter Forward Counter Modulus Register High; 0x00000064 ***/
    union {
      byte Byte;
      struct {
        byte             :8;                                       /* PCounter Forward Counter Modulo Bits */
      } Bits;
    } PCNT_FCMOD_HSTR;
    #define PCNT_FCMOD_H                _PCNT_FCMOD.Overlap_STR.PCNT_FCMOD_HSTR.Byte
    

    /*** PCNT_FCMOD_L - PCounter Forward Counter Modulus Register Low; 0x00000065 ***/
    union {
      byte Byte;
      struct {
        byte             :8;                                       /* PCounter Forward Counter Modulo Bits */
      } Bits;
    } PCNT_FCMOD_LSTR;
    #define PCNT_FCMOD_L                _PCNT_FCMOD.Overlap_STR.PCNT_FCMOD_LSTR.Byte
    
  } Overlap_STR;

} PCNT_FCMODSTR;
extern volatile PCNT_FCMODSTR _PCNT_FCMOD @0x00000064;
#define PCNT_FCMOD                      _PCNT_FCMOD.Word


/*** PCNT_FCNTR - PCounter Forward Counter Register; 0x00000066 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PCNT_FCNTR_H - PCounter Forward Counter Register High; 0x00000066 ***/
    union {
      byte Byte;
      struct {
        byte             :8;                                       /* PCounter Forward Counter Bits */
      } Bits;
    } PCNT_FCNTR_HSTR;
    #define PCNT_FCNTR_H                _PCNT_FCNTR.Overlap_STR.PCNT_FCNTR_HSTR.Byte
    

    /*** PCNT_FCNTR_L - PCounter Forward Counter Register Low; 0x00000067 ***/
    union {
      byte Byte;
      struct {
        byte             :8;                                       /* PCounter Forward Counter Bits */
      } Bits;
    } PCNT_FCNTR_LSTR;
    #define PCNT_FCNTR_L                _PCNT_FCNTR.Overlap_STR.PCNT_FCNTR_LSTR.Byte
    
  } Overlap_STR;

} PCNT_FCNTRSTR;
extern volatile PCNT_FCNTRSTR _PCNT_FCNTR @0x00000066;
#define PCNT_FCNTR                      _PCNT_FCNTR.Word


/*** PCNT_RCMOD - PCounter Reverse Counter Modulus Register; 0x00000068 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PCNT_RCMOD_H - PCounter Reverse Counter Modulus Register High; 0x00000068 ***/
    union {
      byte Byte;
      struct {
        byte             :8;                                       /* PCounter Reverse Counter Modulo Bits */
      } Bits;
    } PCNT_RCMOD_HSTR;
    #define PCNT_RCMOD_H                _PCNT_RCMOD.Overlap_STR.PCNT_RCMOD_HSTR.Byte
    

    /*** PCNT_RCMOD_L - PCounter Reverse Counter Modulus Register Low; 0x00000069 ***/
    union {
      byte Byte;
      struct {
        byte             :8;                                       /* PCounter Reverse Counter Modulo Bits */
      } Bits;
    } PCNT_RCMOD_LSTR;
    #define PCNT_RCMOD_L                _PCNT_RCMOD.Overlap_STR.PCNT_RCMOD_LSTR.Byte
    
  } Overlap_STR;

} PCNT_RCMODSTR;
extern volatile PCNT_RCMODSTR _PCNT_RCMOD @0x00000068;
#define PCNT_RCMOD                      _PCNT_RCMOD.Word


/*** PCNT_RCNTR - PCounter Reverse Counter Register; 0x0000006A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PCNT_RCNTR_H - PCounter Reverse Counter Register High; 0x0000006A ***/
    union {
      byte Byte;
      struct {
        byte             :8;                                       /* PCounter Reverse Counter  Bits */
      } Bits;
    } PCNT_RCNTR_HSTR;
    #define PCNT_RCNTR_H                _PCNT_RCNTR.Overlap_STR.PCNT_RCNTR_HSTR.Byte
    

    /*** PCNT_RCNTR_L - PCounter Reverse Counter Register Low; 0x0000006B ***/
    union {
      byte Byte;
      struct {
        byte             :8;                                       /* PCounter Reverse Counter  Bits */
      } Bits;
    } PCNT_RCNTR_LSTR;
    #define PCNT_RCNTR_L                _PCNT_RCNTR.Overlap_STR.PCNT_RCNTR_LSTR.Byte
    
  } Overlap_STR;

} PCNT_RCNTRSTR;
extern volatile PCNT_RCNTRSTR _PCNT_RCNTR @0x0000006A;
#define PCNT_RCNTR                      _PCNT_RCNTR.Word


/*** PCNT_PWM_MOD - PCounter PWM Modulus Register; 0x0000006C ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PCNT_PWM_MOD_H - PCounter PWM Modulus Register High; 0x0000006C ***/
    union {
      byte Byte;
      struct {
        byte             :8;                                       /* PCounter PWM Modulo Bits */
      } Bits;
    } PCNT_PWM_MOD_HSTR;
    #define PCNT_PWM_MOD_H              _PCNT_PWM_MOD.Overlap_STR.PCNT_PWM_MOD_HSTR.Byte
    

    /*** PCNT_PWM_MOD_L - PCounter PWM Modulus Register Low; 0x0000006D ***/
    union {
      byte Byte;
      struct {
        byte             :8;                                       /* PCounter PWM Modulo Bits */
      } Bits;
    } PCNT_PWM_MOD_LSTR;
    #define PCNT_PWM_MOD_L              _PCNT_PWM_MOD.Overlap_STR.PCNT_PWM_MOD_LSTR.Byte
    
  } Overlap_STR;

} PCNT_PWM_MODSTR;
extern volatile PCNT_PWM_MODSTR _PCNT_PWM_MOD @0x0000006C;
#define PCNT_PWM_MOD                    _PCNT_PWM_MOD.Word


/*** PCNT_PWM_CH1_VAL - PCounter PWM Channel 1 Value Register; 0x0000006E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PCNT_PWM_CH1_H_VAL - PCounter PWM Channel 1 Value Register High; 0x0000006E ***/
    union {
      byte Byte;
      struct {
        byte             :8;                                       /* PCounter PWM Channel 1 Value Bits */
      } Bits;
    } PCNT_PWM_CH1_H_VALSTR;
    #define PCNT_PWM_CH1_H_VAL          _PCNT_PWM_CH1_VAL.Overlap_STR.PCNT_PWM_CH1_H_VALSTR.Byte
    

    /*** PCNT_PWM_CH1_L_VAL - PCounter PWM Channel 1 Value Register Low; 0x0000006F ***/
    union {
      byte Byte;
      struct {
        byte             :8;                                       /* PCounter PWM Channel 1 Value Bits */
      } Bits;
    } PCNT_PWM_CH1_L_VALSTR;
    #define PCNT_PWM_CH1_L_VAL          _PCNT_PWM_CH1_VAL.Overlap_STR.PCNT_PWM_CH1_L_VALSTR.Byte
    
  } Overlap_STR;

} PCNT_PWM_CH1_VALSTR;
extern volatile PCNT_PWM_CH1_VALSTR _PCNT_PWM_CH1_VAL @0x0000006E;
#define PCNT_PWM_CH1_VAL                _PCNT_PWM_CH1_VAL.Word


/*** PCNT_PWM_CH2_VAL - PCounter PWM Channel 2 Value Register; 0x00000070 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PCNT_PWM_CH2_H_VAL - PCounter PWM Channel 2 Value Register High; 0x00000070 ***/
    union {
      byte Byte;
      struct {
        byte             :8;                                       /* PCounter PWM Channel 2 Value Bits */
      } Bits;
    } PCNT_PWM_CH2_H_VALSTR;
    #define PCNT_PWM_CH2_H_VAL          _PCNT_PWM_CH2_VAL.Overlap_STR.PCNT_PWM_CH2_H_VALSTR.Byte
    

    /*** PCNT_PWM_CH2_L_VAL - PCounter PWM Channel 2 Value Register Low; 0x00000071 ***/
    union {
      byte Byte;
      struct {
        byte             :8;                                       /* PCounter PWM Channel 2 Value Bits */
      } Bits;
    } PCNT_PWM_CH2_L_VALSTR;
    #define PCNT_PWM_CH2_L_VAL          _PCNT_PWM_CH2_VAL.Overlap_STR.PCNT_PWM_CH2_L_VALSTR.Byte
    
  } Overlap_STR;

} PCNT_PWM_CH2_VALSTR;
extern volatile PCNT_PWM_CH2_VALSTR _PCNT_PWM_CH2_VAL @0x00000070;
#define PCNT_PWM_CH2_VAL                _PCNT_PWM_CH2_VAL.Word


/*** PCNT_STATE - PCounter Status Register; 0x00000072 ***/
typedef union {
  word Word;
  struct {
    word CURR_STATE  :3;                                       /* This is for debugging purpose.These bits reflect the current state of the state machine */
    word PCOUNTER_STATE :3;                                    /* This is for debugging purpose.These bits reflect value on sensor inputs coming into PCounter */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} PCNT_STATESTR;
extern volatile PCNT_STATESTR _PCNT_STATE @0x00000072;
#define PCNT_STATE                      _PCNT_STATE.Word
#define PCNT_STATE_CURR_STATE           _PCNT_STATE.Bits.CURR_STATE
#define PCNT_STATE_PCOUNTER_STATE       _PCNT_STATE.Bits.PCOUNTER_STATE

#define PCNT_STATE_CURR_STATE_MASK      7
#define PCNT_STATE_CURR_STATE_BITNUM    0
#define PCNT_STATE_PCOUNTER_STATE_MASK  56
#define PCNT_STATE_PCOUNTER_STATE_BITNUM 3


/*** KBISC - KBI Status and Control Register; 0x00000074 ***/
typedef union {
  byte Byte;
  struct {
    byte KBIMOD      :1;                                       /* Keyboard Detection Mode */
    byte KBIE        :1;                                       /* Keyboard Interrupt Enable */
    byte KBACK       :1;                                       /* Keyboard Interrupt Acknowledge */
    byte KBF         :1;                                       /* Keyboard Interrupt Flag */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} KBISCSTR;
extern volatile KBISCSTR _KBISC @0x00000074;
#define KBISC                           _KBISC.Byte
#define KBISC_KBIMOD                    _KBISC.Bits.KBIMOD
#define KBISC_KBIE                      _KBISC.Bits.KBIE
#define KBISC_KBACK                     _KBISC.Bits.KBACK
#define KBISC_KBF                       _KBISC.Bits.KBF

#define KBISC_KBIMOD_MASK               1
#define KBISC_KBIE_MASK                 2
#define KBISC_KBACK_MASK                4
#define KBISC_KBF_MASK                  8


/*** KBIPE - KBI Pin Enable Register; 0x00000075 ***/
typedef union {
  byte Byte;
  struct {
    byte KBIPE0      :1;                                       /* Keyboard Pin Enable for KBI Port Bit 0 */
    byte KBIPE1      :1;                                       /* Keyboard Pin Enable for KBI Port Bit 1 */
    byte KBIPE2      :1;                                       /* Keyboard Pin Enable for KBI Port Bit 2 */
    byte KBIPE3      :1;                                       /* Keyboard Pin Enable for KBI Port Bit 3 */
    byte KBIPE4      :1;                                       /* Keyboard Pin Enable for KBI Port Bit 4 */
    byte KBIPE5      :1;                                       /* Keyboard Pin Enable for KBI Port Bit 5 */
    byte KBIPE6      :1;                                       /* Keyboard Pin Enable for KBI Port Bit 6 */
    byte KBIPE7      :1;                                       /* Keyboard Pin Enable for KBI Port Bit 7 */
  } Bits;
} KBIPESTR;
extern volatile KBIPESTR _KBIPE @0x00000075;
#define KBIPE                           _KBIPE.Byte
#define KBIPE_KBIPE0                    _KBIPE.Bits.KBIPE0
#define KBIPE_KBIPE1                    _KBIPE.Bits.KBIPE1
#define KBIPE_KBIPE2                    _KBIPE.Bits.KBIPE2
#define KBIPE_KBIPE3                    _KBIPE.Bits.KBIPE3
#define KBIPE_KBIPE4                    _KBIPE.Bits.KBIPE4
#define KBIPE_KBIPE5                    _KBIPE.Bits.KBIPE5
#define KBIPE_KBIPE6                    _KBIPE.Bits.KBIPE6
#define KBIPE_KBIPE7                    _KBIPE.Bits.KBIPE7

#define KBIPE_KBIPE0_MASK               1
#define KBIPE_KBIPE1_MASK               2
#define KBIPE_KBIPE2_MASK               4
#define KBIPE_KBIPE3_MASK               8
#define KBIPE_KBIPE4_MASK               16
#define KBIPE_KBIPE5_MASK               32
#define KBIPE_KBIPE6_MASK               64
#define KBIPE_KBIPE7_MASK               128


/*** KBIES - KBI Edge Select Register; 0x00000076 ***/
typedef union {
  byte Byte;
  struct {
    byte KBEDG0      :1;                                       /* Keyboard Edge Select Bit 0 */
    byte KBEDG1      :1;                                       /* Keyboard Edge Select Bit 1 */
    byte KBEDG2      :1;                                       /* Keyboard Edge Select Bit 2 */
    byte KBEDG3      :1;                                       /* Keyboard Edge Select Bit 3 */
    byte KBEDG4      :1;                                       /* Keyboard Edge Select Bit 4 */
    byte KBEDG5      :1;                                       /* Keyboard Edge Select Bit 5 */
    byte KBEDG6      :1;                                       /* Keyboard Edge Select Bit 6 */
    byte KBEDG7      :1;                                       /* Keyboard Edge Select Bit 7 */
  } Bits;
} KBIESSTR;
extern volatile KBIESSTR _KBIES @0x00000076;
#define KBIES                           _KBIES.Byte
#define KBIES_KBEDG0                    _KBIES.Bits.KBEDG0
#define KBIES_KBEDG1                    _KBIES.Bits.KBEDG1
#define KBIES_KBEDG2                    _KBIES.Bits.KBEDG2
#define KBIES_KBEDG3                    _KBIES.Bits.KBEDG3
#define KBIES_KBEDG4                    _KBIES.Bits.KBEDG4
#define KBIES_KBEDG5                    _KBIES.Bits.KBEDG5
#define KBIES_KBEDG6                    _KBIES.Bits.KBEDG6
#define KBIES_KBEDG7                    _KBIES.Bits.KBEDG7

#define KBIES_KBEDG0_MASK               1
#define KBIES_KBEDG1_MASK               2
#define KBIES_KBEDG2_MASK               4
#define KBIES_KBEDG3_MASK               8
#define KBIES_KBEDG4_MASK               16
#define KBIES_KBEDG5_MASK               32
#define KBIES_KBEDG6_MASK               64
#define KBIES_KBEDG7_MASK               128


/*** IRQSC - Interrupt request status and control register; 0x00000077 ***/
typedef union {
  byte Byte;
  struct {
    byte IRQMOD      :1;                                       /* IRQ Detection Mode */
    byte IRQIE       :1;                                       /* IRQ Interrupt Enable */
    byte IRQACK      :1;                                       /* IRQ Acknowledge */
    byte IRQF        :1;                                       /* IRQ Flag */
    byte IRQPE       :1;                                       /* IRQ Pin Enable */
    byte IRQEDG      :1;                                       /* IRQ Edge Select */
    byte IRQPDD      :1;                                       /* IRQ Pull Device Disable */
    byte             :1; 
  } Bits;
} IRQSCSTR;
extern volatile IRQSCSTR _IRQSC @0x00000077;
#define IRQSC                           _IRQSC.Byte
#define IRQSC_IRQMOD                    _IRQSC.Bits.IRQMOD
#define IRQSC_IRQIE                     _IRQSC.Bits.IRQIE
#define IRQSC_IRQACK                    _IRQSC.Bits.IRQACK
#define IRQSC_IRQF                      _IRQSC.Bits.IRQF
#define IRQSC_IRQPE                     _IRQSC.Bits.IRQPE
#define IRQSC_IRQEDG                    _IRQSC.Bits.IRQEDG
#define IRQSC_IRQPDD                    _IRQSC.Bits.IRQPDD

#define IRQSC_IRQMOD_MASK               1
#define IRQSC_IRQIE_MASK                2
#define IRQSC_IRQACK_MASK               4
#define IRQSC_IRQF_MASK                 8
#define IRQSC_IRQPE_MASK                16
#define IRQSC_IRQEDG_MASK               32
#define IRQSC_IRQPDD_MASK               64


/*** SCI0BD - SCI0 Baud Rate Register; 0x00000078 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SCI0BDH - SCI0 Baud Rate Register High; 0x00000078 ***/
    union {
      byte Byte;
      struct {
        byte SBR8        :1;                                       /* Baud Rate Modulo Divisor Bit 8 */
        byte SBR9        :1;                                       /* Baud Rate Modulo Divisor Bit 9 */
        byte SBR10       :1;                                       /* Baud Rate Modulo Divisor Bit 10 */
        byte SBR11       :1;                                       /* Baud Rate Modulo Divisor Bit 11 */
        byte SBR12       :1;                                       /* Baud Rate Modulo Divisor Bit 12 */
        byte             :1; 
        byte RXEDGIE     :1;                                       /* RxD Input Active Edge Interrupt Enable (for RXEDGIF) */
        byte LBKDIE      :1;                                       /* LIN Break Detect Interrupt Enable (for LBKDIF) */
      } Bits;
      struct {
        byte grpSBR_8 :5;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } SCI0BDHSTR;
    #define SCI0BDH                     _SCI0BD.Overlap_STR.SCI0BDHSTR.Byte
    #define SCI0BDH_SBR8                _SCI0BD.Overlap_STR.SCI0BDHSTR.Bits.SBR8
    #define SCI0BDH_SBR9                _SCI0BD.Overlap_STR.SCI0BDHSTR.Bits.SBR9
    #define SCI0BDH_SBR10               _SCI0BD.Overlap_STR.SCI0BDHSTR.Bits.SBR10
    #define SCI0BDH_SBR11               _SCI0BD.Overlap_STR.SCI0BDHSTR.Bits.SBR11
    #define SCI0BDH_SBR12               _SCI0BD.Overlap_STR.SCI0BDHSTR.Bits.SBR12
    #define SCI0BDH_RXEDGIE             _SCI0BD.Overlap_STR.SCI0BDHSTR.Bits.RXEDGIE
    #define SCI0BDH_LBKDIE              _SCI0BD.Overlap_STR.SCI0BDHSTR.Bits.LBKDIE
    #define SCI0BDH_SBR_8               _SCI0BD.Overlap_STR.SCI0BDHSTR.MergedBits.grpSBR_8
    #define SCI0BDH_SBR                 SCI0BDH_SBR_8
    
    #define SCI0BDH_SBR8_MASK           1
    #define SCI0BDH_SBR9_MASK           2
    #define SCI0BDH_SBR10_MASK          4
    #define SCI0BDH_SBR11_MASK          8
    #define SCI0BDH_SBR12_MASK          16
    #define SCI0BDH_RXEDGIE_MASK        64
    #define SCI0BDH_LBKDIE_MASK         128
    #define SCI0BDH_SBR_8_MASK          31
    #define SCI0BDH_SBR_8_BITNUM        0
    

    /*** SCI0BDL - SCI0 Baud Rate Register Low; 0x00000079 ***/
    union {
      byte Byte;
      struct {
        byte SBR0        :1;                                       /* Baud Rate Modulo Divisor Bit 0 */
        byte SBR1        :1;                                       /* Baud Rate Modulo Divisor Bit 1 */
        byte SBR2        :1;                                       /* Baud Rate Modulo Divisor Bit 2 */
        byte SBR3        :1;                                       /* Baud Rate Modulo Divisor Bit 3 */
        byte SBR4        :1;                                       /* Baud Rate Modulo Divisor Bit 4 */
        byte SBR5        :1;                                       /* Baud Rate Modulo Divisor Bit 5 */
        byte SBR6        :1;                                       /* Baud Rate Modulo Divisor Bit 6 */
        byte SBR7        :1;                                       /* Baud Rate Modulo Divisor Bit 7 */
      } Bits;
    } SCI0BDLSTR;
    #define SCI0BDL                     _SCI0BD.Overlap_STR.SCI0BDLSTR.Byte
    #define SCI0BDL_SBR0                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR0
    #define SCI0BDL_SBR1                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR1
    #define SCI0BDL_SBR2                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR2
    #define SCI0BDL_SBR3                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR3
    #define SCI0BDL_SBR4                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR4
    #define SCI0BDL_SBR5                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR5
    #define SCI0BDL_SBR6                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR6
    #define SCI0BDL_SBR7                _SCI0BD.Overlap_STR.SCI0BDLSTR.Bits.SBR7
    
    #define SCI0BDL_SBR0_MASK           1
    #define SCI0BDL_SBR1_MASK           2
    #define SCI0BDL_SBR2_MASK           4
    #define SCI0BDL_SBR3_MASK           8
    #define SCI0BDL_SBR4_MASK           16
    #define SCI0BDL_SBR5_MASK           32
    #define SCI0BDL_SBR6_MASK           64
    #define SCI0BDL_SBR7_MASK           128
    
  } Overlap_STR;

} SCI0BDSTR;
extern volatile SCI0BDSTR _SCI0BD @0x00000078;
#define SCI0BD                          _SCI0BD.Word


/*** SCI0C1 - SCI0 Control Register 1; 0x0000007A ***/
typedef union {
  byte Byte;
  struct {
    byte PT          :1;                                       /* Parity Type */
    byte PE          :1;                                       /* Parity Enable */
    byte ILT         :1;                                       /* Idle Line Type Select */
    byte WAKE        :1;                                       /* Receiver Wakeup Method Select */
    byte M           :1;                                       /* 9-Bit or 8-Bit Mode Select */
    byte RSRC        :1;                                       /* Receiver Source Select */
    byte SCISWAI     :1;                                       /* SCI Stops in Wait Mode */
    byte LOOPS       :1;                                       /* Loop Mode Select */
  } Bits;
} SCI0C1STR;
extern volatile SCI0C1STR _SCI0C1 @0x0000007A;
#define SCI0C1                          _SCI0C1.Byte
#define SCI0C1_PT                       _SCI0C1.Bits.PT
#define SCI0C1_PE                       _SCI0C1.Bits.PE
#define SCI0C1_ILT                      _SCI0C1.Bits.ILT
#define SCI0C1_WAKE                     _SCI0C1.Bits.WAKE
#define SCI0C1_M                        _SCI0C1.Bits.M
#define SCI0C1_RSRC                     _SCI0C1.Bits.RSRC
#define SCI0C1_SCISWAI                  _SCI0C1.Bits.SCISWAI
#define SCI0C1_LOOPS                    _SCI0C1.Bits.LOOPS

#define SCI0C1_PT_MASK                  1
#define SCI0C1_PE_MASK                  2
#define SCI0C1_ILT_MASK                 4
#define SCI0C1_WAKE_MASK                8
#define SCI0C1_M_MASK                   16
#define SCI0C1_RSRC_MASK                32
#define SCI0C1_SCISWAI_MASK             64
#define SCI0C1_LOOPS_MASK               128


/*** SCI0C2 - SCI0 Control Register 2; 0x0000007B ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break */
    byte RWU         :1;                                       /* Receiver Wakeup Control */
    byte RE          :1;                                       /* Receiver Enable */
    byte TE          :1;                                       /* Transmitter Enable */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable (for IDLE) */
    byte RIE         :1;                                       /* Receiver Interrupt Enable (for RDRF) */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable (for TC) */
    byte TIE         :1;                                       /* Transmit Interrupt Enable (for TDRE) */
  } Bits;
} SCI0C2STR;
extern volatile SCI0C2STR _SCI0C2 @0x0000007B;
#define SCI0C2                          _SCI0C2.Byte
#define SCI0C2_SBK                      _SCI0C2.Bits.SBK
#define SCI0C2_RWU                      _SCI0C2.Bits.RWU
#define SCI0C2_RE                       _SCI0C2.Bits.RE
#define SCI0C2_TE                       _SCI0C2.Bits.TE
#define SCI0C2_ILIE                     _SCI0C2.Bits.ILIE
#define SCI0C2_RIE                      _SCI0C2.Bits.RIE
#define SCI0C2_TCIE                     _SCI0C2.Bits.TCIE
#define SCI0C2_TIE                      _SCI0C2.Bits.TIE

#define SCI0C2_SBK_MASK                 1
#define SCI0C2_RWU_MASK                 2
#define SCI0C2_RE_MASK                  4
#define SCI0C2_TE_MASK                  8
#define SCI0C2_ILIE_MASK                16
#define SCI0C2_RIE_MASK                 32
#define SCI0C2_TCIE_MASK                64
#define SCI0C2_TIE_MASK                 128


/*** SCI0S1 - SCI0 Status Register 1; 0x0000007C ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Receiver Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF        :1;                                       /* Receive Data Register Full Flag */
    byte TC          :1;                                       /* Transmission Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} SCI0S1STR;
extern volatile SCI0S1STR _SCI0S1 @0x0000007C;
#define SCI0S1                          _SCI0S1.Byte
#define SCI0S1_PF                       _SCI0S1.Bits.PF
#define SCI0S1_FE                       _SCI0S1.Bits.FE
#define SCI0S1_NF                       _SCI0S1.Bits.NF
#define SCI0S1_OR                       _SCI0S1.Bits.OR
#define SCI0S1_IDLE                     _SCI0S1.Bits.IDLE
#define SCI0S1_RDRF                     _SCI0S1.Bits.RDRF
#define SCI0S1_TC                       _SCI0S1.Bits.TC
#define SCI0S1_TDRE                     _SCI0S1.Bits.TDRE

#define SCI0S1_PF_MASK                  1
#define SCI0S1_FE_MASK                  2
#define SCI0S1_NF_MASK                  4
#define SCI0S1_OR_MASK                  8
#define SCI0S1_IDLE_MASK                16
#define SCI0S1_RDRF_MASK                32
#define SCI0S1_TC_MASK                  64
#define SCI0S1_TDRE_MASK                128


/*** SCI0S2 - SCI0 Status Register 2; 0x0000007D ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte LBKDE       :1;                                       /* LIN Break Detection Enable */
    byte BRK13       :1;                                       /* Break Character Generation Length */
    byte RWUID       :1;                                       /* Receive Wake Up Idle Detect */
    byte RXINV       :1;                                       /* Receive Data Inversion */
    byte             :1; 
    byte RXEDGIF     :1;                                       /* RxD Pin Active Edge Interrupt Flag */
    byte LBKDIF      :1;                                       /* LIN Break Detect Interrupt Flag */
  } Bits;
} SCI0S2STR;
extern volatile SCI0S2STR _SCI0S2 @0x0000007D;
#define SCI0S2                          _SCI0S2.Byte
#define SCI0S2_RAF                      _SCI0S2.Bits.RAF
#define SCI0S2_LBKDE                    _SCI0S2.Bits.LBKDE
#define SCI0S2_BRK13                    _SCI0S2.Bits.BRK13
#define SCI0S2_RWUID                    _SCI0S2.Bits.RWUID
#define SCI0S2_RXINV                    _SCI0S2.Bits.RXINV
#define SCI0S2_RXEDGIF                  _SCI0S2.Bits.RXEDGIF
#define SCI0S2_LBKDIF                   _SCI0S2.Bits.LBKDIF

#define SCI0S2_RAF_MASK                 1
#define SCI0S2_LBKDE_MASK               2
#define SCI0S2_BRK13_MASK               4
#define SCI0S2_RWUID_MASK               8
#define SCI0S2_RXINV_MASK               16
#define SCI0S2_RXEDGIF_MASK             64
#define SCI0S2_LBKDIF_MASK              128


/*** SCI0C3 - SCI0 Control Register 3; 0x0000007E ***/
typedef union {
  byte Byte;
  struct {
    byte PEIE        :1;                                       /* Parity Error Interrupt Enable */
    byte FEIE        :1;                                       /* Framing Error Interrupt Enable */
    byte NEIE        :1;                                       /* Noise Error Interrupt Enable */
    byte ORIE        :1;                                       /* Overrun Interrupt Enable */
    byte TXINV       :1;                                       /* Transmit Data Inversion */
    byte TXDIR       :1;                                       /* TxD Pin Direction in Single-Wire Mode */
    byte T8          :1;                                       /* Ninth Data Bit for Transmitter */
    byte R8          :1;                                       /* Ninth Data Bit for Receiver */
  } Bits;
} SCI0C3STR;
extern volatile SCI0C3STR _SCI0C3 @0x0000007E;
#define SCI0C3                          _SCI0C3.Byte
#define SCI0C3_PEIE                     _SCI0C3.Bits.PEIE
#define SCI0C3_FEIE                     _SCI0C3.Bits.FEIE
#define SCI0C3_NEIE                     _SCI0C3.Bits.NEIE
#define SCI0C3_ORIE                     _SCI0C3.Bits.ORIE
#define SCI0C3_TXINV                    _SCI0C3.Bits.TXINV
#define SCI0C3_TXDIR                    _SCI0C3.Bits.TXDIR
#define SCI0C3_T8                       _SCI0C3.Bits.T8
#define SCI0C3_R8                       _SCI0C3.Bits.R8

#define SCI0C3_PEIE_MASK                1
#define SCI0C3_FEIE_MASK                2
#define SCI0C3_NEIE_MASK                4
#define SCI0C3_ORIE_MASK                8
#define SCI0C3_TXINV_MASK               16
#define SCI0C3_TXDIR_MASK               32
#define SCI0C3_T8_MASK                  64
#define SCI0C3_R8_MASK                  128


/*** SCI0D - SCI0 Data Register; 0x0000007F ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Receive/Transmit Data Bit 0 */
    byte R1_T1       :1;                                       /* Receive/Transmit Data Bit 1 */
    byte R2_T2       :1;                                       /* Receive/Transmit Data Bit 2 */
    byte R3_T3       :1;                                       /* Receive/Transmit Data Bit 3 */
    byte R4_T4       :1;                                       /* Receive/Transmit Data Bit 4 */
    byte R5_T5       :1;                                       /* Receive/Transmit Data Bit 5 */
    byte R6_T6       :1;                                       /* Receive/Transmit Data Bit 6 */
    byte R7_T7       :1;                                       /* Receive/Transmit Data Bit 7 */
  } Bits;
} SCI0DSTR;
extern volatile SCI0DSTR _SCI0D @0x0000007F;
#define SCI0D                           _SCI0D.Byte
#define SCI0D_R0_T0                     _SCI0D.Bits.R0_T0
#define SCI0D_R1_T1                     _SCI0D.Bits.R1_T1
#define SCI0D_R2_T2                     _SCI0D.Bits.R2_T2
#define SCI0D_R3_T3                     _SCI0D.Bits.R3_T3
#define SCI0D_R4_T4                     _SCI0D.Bits.R4_T4
#define SCI0D_R5_T5                     _SCI0D.Bits.R5_T5
#define SCI0D_R6_T6                     _SCI0D.Bits.R6_T6
#define SCI0D_R7_T7                     _SCI0D.Bits.R7_T7

#define SCI0D_R0_T0_MASK                1
#define SCI0D_R1_T1_MASK                2
#define SCI0D_R2_T2_MASK                4
#define SCI0D_R3_T3_MASK                8
#define SCI0D_R4_T4_MASK                16
#define SCI0D_R5_T5_MASK                32
#define SCI0D_R6_T6_MASK                64
#define SCI0D_R7_T7_MASK                128


/*** ADC1SC1A - Status and Control Register 1A; 0x00000080 ***/
typedef union {
  byte Byte;
  struct {
    byte ADCHA0      :1;                                       /* Input Channel Select Bit 0 */
    byte ADCHA1      :1;                                       /* Input Channel Select Bit 1 */
    byte ADCHA2      :1;                                       /* Input Channel Select Bit 2 */
    byte ADCHA3      :1;                                       /* Input Channel Select Bit 3 */
    byte ADCHA4      :1;                                       /* Input Channel Select Bit 4 */
    byte DIFFA       :1;                                       /* Differential Mode Enable - DIFFA configures the ADC to operate in differential mode */
    byte AIENA       :1;                                       /* Interrupt Enable - AIENA enables conversion complete interrupts. When COCOA becomes set while the respective AIENA is high, an interrupt is asserted */
    byte COCOA       :1;                                       /* Conversion Complete Flag */
  } Bits;
  struct {
    byte grpADCHA :5;
    byte grpDIFFx :1;
    byte grpAIENx :1;
    byte grpCOCOx :1;
  } MergedBits;
} ADC1SC1ASTR;
extern volatile ADC1SC1ASTR _ADC1SC1A @0x00000080;
#define ADC1SC1A                        _ADC1SC1A.Byte
#define ADC1SC1A_ADCHA0                 _ADC1SC1A.Bits.ADCHA0
#define ADC1SC1A_ADCHA1                 _ADC1SC1A.Bits.ADCHA1
#define ADC1SC1A_ADCHA2                 _ADC1SC1A.Bits.ADCHA2
#define ADC1SC1A_ADCHA3                 _ADC1SC1A.Bits.ADCHA3
#define ADC1SC1A_ADCHA4                 _ADC1SC1A.Bits.ADCHA4
#define ADC1SC1A_DIFFA                  _ADC1SC1A.Bits.DIFFA
#define ADC1SC1A_AIENA                  _ADC1SC1A.Bits.AIENA
#define ADC1SC1A_COCOA                  _ADC1SC1A.Bits.COCOA
#define ADC1SC1A_ADCHA                  _ADC1SC1A.MergedBits.grpADCHA

#define ADC1SC1A_ADCHA0_MASK            1
#define ADC1SC1A_ADCHA1_MASK            2
#define ADC1SC1A_ADCHA2_MASK            4
#define ADC1SC1A_ADCHA3_MASK            8
#define ADC1SC1A_ADCHA4_MASK            16
#define ADC1SC1A_DIFFA_MASK             32
#define ADC1SC1A_AIENA_MASK             64
#define ADC1SC1A_COCOA_MASK             128
#define ADC1SC1A_ADCHA_MASK             31
#define ADC1SC1A_ADCHA_BITNUM           0


/*** ADC1SC1B - Status and Control Register 1B; 0x00000081 ***/
typedef union {
  byte Byte;
  struct {
    byte ADCHB0      :1;                                       /* Input Channel Select Bit 0 */
    byte ADCHB1      :1;                                       /* Input Channel Select Bit 1 */
    byte ADCHB2      :1;                                       /* Input Channel Select Bit 2 */
    byte ADCHB3      :1;                                       /* Input Channel Select Bit 3 */
    byte ADCHB4      :1;                                       /* Input Channel Select Bit 4 */
    byte DIFFB       :1;                                       /* Differential Mode Enable - DIFFB configures the ADC to operate in differential mode */
    byte AIENB       :1;                                       /* Interrupt Enable - AIENB enables conversion complete interrupts. When COCOB becomes set while the respective AIENB is high, an interrupt is asserted */
    byte COCOB       :1;                                       /* Conversion Complete Flag */
  } Bits;
  struct {
    byte grpADCHB :5;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} ADC1SC1BSTR;
extern volatile ADC1SC1BSTR _ADC1SC1B @0x00000081;
#define ADC1SC1B                        _ADC1SC1B.Byte
#define ADC1SC1B_ADCHB0                 _ADC1SC1B.Bits.ADCHB0
#define ADC1SC1B_ADCHB1                 _ADC1SC1B.Bits.ADCHB1
#define ADC1SC1B_ADCHB2                 _ADC1SC1B.Bits.ADCHB2
#define ADC1SC1B_ADCHB3                 _ADC1SC1B.Bits.ADCHB3
#define ADC1SC1B_ADCHB4                 _ADC1SC1B.Bits.ADCHB4
#define ADC1SC1B_DIFFB                  _ADC1SC1B.Bits.DIFFB
#define ADC1SC1B_AIENB                  _ADC1SC1B.Bits.AIENB
#define ADC1SC1B_COCOB                  _ADC1SC1B.Bits.COCOB
#define ADC1SC1B_ADCHB                  _ADC1SC1B.MergedBits.grpADCHB

#define ADC1SC1B_ADCHB0_MASK            1
#define ADC1SC1B_ADCHB1_MASK            2
#define ADC1SC1B_ADCHB2_MASK            4
#define ADC1SC1B_ADCHB3_MASK            8
#define ADC1SC1B_ADCHB4_MASK            16
#define ADC1SC1B_DIFFB_MASK             32
#define ADC1SC1B_AIENB_MASK             64
#define ADC1SC1B_COCOB_MASK             128
#define ADC1SC1B_ADCHB_MASK             31
#define ADC1SC1B_ADCHB_BITNUM           0


/*** ADC1CFG1 - Configuration Register 1; 0x00000082 ***/
typedef union {
  byte Byte;
  struct {
    byte ADICLK0     :1;                                       /* Input Clock Select Bit 0 */
    byte ADICLK1     :1;                                       /* Input Clock Select Bit 1 */
    byte MODE0       :1;                                       /* Conversion Mode Selection Bit 0 */
    byte MODE1       :1;                                       /* Conversion Mode Selection Bit 1 */
    byte ADLSMP      :1;                                       /* Long Sample Time Configuration */
    byte ADIV0       :1;                                       /* Clock Divide Select Bit 0 */
    byte ADIV1       :1;                                       /* Clock Divide Select Bit 1 */
    byte ADLPC       :1;                                       /* Low Power Configuration */
  } Bits;
  struct {
    byte grpADICLK :2;
    byte grpMODE :2;
    byte         :1;
    byte grpADIV :2;
    byte         :1;
  } MergedBits;
} ADC1CFG1STR;
extern volatile ADC1CFG1STR _ADC1CFG1 @0x00000082;
#define ADC1CFG1                        _ADC1CFG1.Byte
#define ADC1CFG1_ADICLK0                _ADC1CFG1.Bits.ADICLK0
#define ADC1CFG1_ADICLK1                _ADC1CFG1.Bits.ADICLK1
#define ADC1CFG1_MODE0                  _ADC1CFG1.Bits.MODE0
#define ADC1CFG1_MODE1                  _ADC1CFG1.Bits.MODE1
#define ADC1CFG1_ADLSMP                 _ADC1CFG1.Bits.ADLSMP
#define ADC1CFG1_ADIV0                  _ADC1CFG1.Bits.ADIV0
#define ADC1CFG1_ADIV1                  _ADC1CFG1.Bits.ADIV1
#define ADC1CFG1_ADLPC                  _ADC1CFG1.Bits.ADLPC
#define ADC1CFG1_ADICLK                 _ADC1CFG1.MergedBits.grpADICLK
#define ADC1CFG1_MODE                   _ADC1CFG1.MergedBits.grpMODE
#define ADC1CFG1_ADIV                   _ADC1CFG1.MergedBits.grpADIV

#define ADC1CFG1_ADICLK0_MASK           1
#define ADC1CFG1_ADICLK1_MASK           2
#define ADC1CFG1_MODE0_MASK             4
#define ADC1CFG1_MODE1_MASK             8
#define ADC1CFG1_ADLSMP_MASK            16
#define ADC1CFG1_ADIV0_MASK             32
#define ADC1CFG1_ADIV1_MASK             64
#define ADC1CFG1_ADLPC_MASK             128
#define ADC1CFG1_ADICLK_MASK            3
#define ADC1CFG1_ADICLK_BITNUM          0
#define ADC1CFG1_MODE_MASK              12
#define ADC1CFG1_MODE_BITNUM            2
#define ADC1CFG1_ADIV_MASK              96
#define ADC1CFG1_ADIV_BITNUM            5


/*** ADC1CFG2 - Configuration Register 2; 0x00000083 ***/
typedef union {
  byte Byte;
  struct {
    byte ADLSTS0     :1;                                       /* Long Sample Time Select Bit 0 */
    byte ADLSTS1     :1;                                       /* Long Sample Time Select Bit 1 */
    byte ADHSC       :1;                                       /* High Speed Configuration */
    byte ADACKEN     :1;                                       /* Asynchronous Clock Output Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpADLSTS :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} ADC1CFG2STR;
extern volatile ADC1CFG2STR _ADC1CFG2 @0x00000083;
#define ADC1CFG2                        _ADC1CFG2.Byte
#define ADC1CFG2_ADLSTS0                _ADC1CFG2.Bits.ADLSTS0
#define ADC1CFG2_ADLSTS1                _ADC1CFG2.Bits.ADLSTS1
#define ADC1CFG2_ADHSC                  _ADC1CFG2.Bits.ADHSC
#define ADC1CFG2_ADACKEN                _ADC1CFG2.Bits.ADACKEN
#define ADC1CFG2_ADLSTS                 _ADC1CFG2.MergedBits.grpADLSTS

#define ADC1CFG2_ADLSTS0_MASK           1
#define ADC1CFG2_ADLSTS1_MASK           2
#define ADC1CFG2_ADHSC_MASK             4
#define ADC1CFG2_ADACKEN_MASK           8
#define ADC1CFG2_ADLSTS_MASK            3
#define ADC1CFG2_ADLSTS_BITNUM          0


/*** ADC1RA - Data Result Register A; 0x00000084 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ADC1RHA - Data Result High Register A; 0x00000084 ***/
    union {
      byte Byte;
      struct {
        byte D8          :1;                                       /* ADC Result Data Bit 8 */
        byte D9          :1;                                       /* ADC Result Data Bit 9 */
        byte D10         :1;                                       /* ADC Result Data Bit 10 */
        byte D11         :1;                                       /* ADC Result Data Bit 11 */
        byte D12         :1;                                       /* ADC Result Data Bit 12 */
        byte D13         :1;                                       /* ADC Result Data Bit 13 */
        byte D14         :1;                                       /* ADC Result Data Bit 14 */
        byte D15         :1;                                       /* ADC Result Data Bit 15 */
      } Bits;
    } ADC1RHASTR;
    #define ADC1RHA                     _ADC1RA.Overlap_STR.ADC1RHASTR.Byte
    #define ADC1RHA_D8                  _ADC1RA.Overlap_STR.ADC1RHASTR.Bits.D8
    #define ADC1RHA_D9                  _ADC1RA.Overlap_STR.ADC1RHASTR.Bits.D9
    #define ADC1RHA_D10                 _ADC1RA.Overlap_STR.ADC1RHASTR.Bits.D10
    #define ADC1RHA_D11                 _ADC1RA.Overlap_STR.ADC1RHASTR.Bits.D11
    #define ADC1RHA_D12                 _ADC1RA.Overlap_STR.ADC1RHASTR.Bits.D12
    #define ADC1RHA_D13                 _ADC1RA.Overlap_STR.ADC1RHASTR.Bits.D13
    #define ADC1RHA_D14                 _ADC1RA.Overlap_STR.ADC1RHASTR.Bits.D14
    #define ADC1RHA_D15                 _ADC1RA.Overlap_STR.ADC1RHASTR.Bits.D15
    
    #define ADC1RHA_D8_MASK             1
    #define ADC1RHA_D9_MASK             2
    #define ADC1RHA_D10_MASK            4
    #define ADC1RHA_D11_MASK            8
    #define ADC1RHA_D12_MASK            16
    #define ADC1RHA_D13_MASK            32
    #define ADC1RHA_D14_MASK            64
    #define ADC1RHA_D15_MASK            128
    

    /*** ADC1RLA - Data Result Low Register A; 0x00000085 ***/
    union {
      byte Byte;
      struct {
        byte D0          :1;                                       /* ADC Result Data Bit 0 */
        byte D1          :1;                                       /* ADC Result Data Bit 1 */
        byte D2          :1;                                       /* ADC Result Data Bit 2 */
        byte D3          :1;                                       /* ADC Result Data Bit 3 */
        byte D4          :1;                                       /* ADC Result Data Bit 4 */
        byte D5          :1;                                       /* ADC Result Data Bit 5 */
        byte D6          :1;                                       /* ADC Result Data Bit 6 */
        byte D7          :1;                                       /* ADC Result Data Bit 7 */
      } Bits;
    } ADC1RLASTR;
    #define ADC1RLA                     _ADC1RA.Overlap_STR.ADC1RLASTR.Byte
    #define ADC1RLA_D0                  _ADC1RA.Overlap_STR.ADC1RLASTR.Bits.D0
    #define ADC1RLA_D1                  _ADC1RA.Overlap_STR.ADC1RLASTR.Bits.D1
    #define ADC1RLA_D2                  _ADC1RA.Overlap_STR.ADC1RLASTR.Bits.D2
    #define ADC1RLA_D3                  _ADC1RA.Overlap_STR.ADC1RLASTR.Bits.D3
    #define ADC1RLA_D4                  _ADC1RA.Overlap_STR.ADC1RLASTR.Bits.D4
    #define ADC1RLA_D5                  _ADC1RA.Overlap_STR.ADC1RLASTR.Bits.D5
    #define ADC1RLA_D6                  _ADC1RA.Overlap_STR.ADC1RLASTR.Bits.D6
    #define ADC1RLA_D7                  _ADC1RA.Overlap_STR.ADC1RLASTR.Bits.D7
    
    #define ADC1RLA_D0_MASK             1
    #define ADC1RLA_D1_MASK             2
    #define ADC1RLA_D2_MASK             4
    #define ADC1RLA_D3_MASK             8
    #define ADC1RLA_D4_MASK             16
    #define ADC1RLA_D5_MASK             32
    #define ADC1RLA_D6_MASK             64
    #define ADC1RLA_D7_MASK             128
    
  } Overlap_STR;

} ADC1RASTR;
extern volatile ADC1RASTR _ADC1RA @0x00000084;
#define ADC1RA                          _ADC1RA.Word


/*** ADC1RB - Data Result Register B; 0x00000086 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ADC1RHB - Data Result High Register B; 0x00000086 ***/
    union {
      byte Byte;
      struct {
        byte D8          :1;                                       /* ADC Result Data Bit 8 */
        byte D9          :1;                                       /* ADC Result Data Bit 9 */
        byte D10         :1;                                       /* ADC Result Data Bit 10 */
        byte D11         :1;                                       /* ADC Result Data Bit 11 */
        byte D12         :1;                                       /* ADC Result Data Bit 12 */
        byte D13         :1;                                       /* ADC Result Data Bit 13 */
        byte D14         :1;                                       /* ADC Result Data Bit 14 */
        byte D15         :1;                                       /* ADC Result Data Bit 15 */
      } Bits;
    } ADC1RHBSTR;
    #define ADC1RHB                     _ADC1RB.Overlap_STR.ADC1RHBSTR.Byte
    #define ADC1RHB_D8                  _ADC1RB.Overlap_STR.ADC1RHBSTR.Bits.D8
    #define ADC1RHB_D9                  _ADC1RB.Overlap_STR.ADC1RHBSTR.Bits.D9
    #define ADC1RHB_D10                 _ADC1RB.Overlap_STR.ADC1RHBSTR.Bits.D10
    #define ADC1RHB_D11                 _ADC1RB.Overlap_STR.ADC1RHBSTR.Bits.D11
    #define ADC1RHB_D12                 _ADC1RB.Overlap_STR.ADC1RHBSTR.Bits.D12
    #define ADC1RHB_D13                 _ADC1RB.Overlap_STR.ADC1RHBSTR.Bits.D13
    #define ADC1RHB_D14                 _ADC1RB.Overlap_STR.ADC1RHBSTR.Bits.D14
    #define ADC1RHB_D15                 _ADC1RB.Overlap_STR.ADC1RHBSTR.Bits.D15
    
    #define ADC1RHB_D8_MASK             1
    #define ADC1RHB_D9_MASK             2
    #define ADC1RHB_D10_MASK            4
    #define ADC1RHB_D11_MASK            8
    #define ADC1RHB_D12_MASK            16
    #define ADC1RHB_D13_MASK            32
    #define ADC1RHB_D14_MASK            64
    #define ADC1RHB_D15_MASK            128
    

    /*** ADC1RLB - Data Result Low Register B; 0x00000087 ***/
    union {
      byte Byte;
      struct {
        byte D0          :1;                                       /* ADC Result Data Bit 0 */
        byte D1          :1;                                       /* ADC Result Data Bit 1 */
        byte D2          :1;                                       /* ADC Result Data Bit 2 */
        byte D3          :1;                                       /* ADC Result Data Bit 3 */
        byte D4          :1;                                       /* ADC Result Data Bit 4 */
        byte D5          :1;                                       /* ADC Result Data Bit 5 */
        byte D6          :1;                                       /* ADC Result Data Bit 6 */
        byte D7          :1;                                       /* ADC Result Data Bit 7 */
      } Bits;
    } ADC1RLBSTR;
    #define ADC1RLB                     _ADC1RB.Overlap_STR.ADC1RLBSTR.Byte
    #define ADC1RLB_D0                  _ADC1RB.Overlap_STR.ADC1RLBSTR.Bits.D0
    #define ADC1RLB_D1                  _ADC1RB.Overlap_STR.ADC1RLBSTR.Bits.D1
    #define ADC1RLB_D2                  _ADC1RB.Overlap_STR.ADC1RLBSTR.Bits.D2
    #define ADC1RLB_D3                  _ADC1RB.Overlap_STR.ADC1RLBSTR.Bits.D3
    #define ADC1RLB_D4                  _ADC1RB.Overlap_STR.ADC1RLBSTR.Bits.D4
    #define ADC1RLB_D5                  _ADC1RB.Overlap_STR.ADC1RLBSTR.Bits.D5
    #define ADC1RLB_D6                  _ADC1RB.Overlap_STR.ADC1RLBSTR.Bits.D6
    #define ADC1RLB_D7                  _ADC1RB.Overlap_STR.ADC1RLBSTR.Bits.D7
    
    #define ADC1RLB_D0_MASK             1
    #define ADC1RLB_D1_MASK             2
    #define ADC1RLB_D2_MASK             4
    #define ADC1RLB_D3_MASK             8
    #define ADC1RLB_D4_MASK             16
    #define ADC1RLB_D5_MASK             32
    #define ADC1RLB_D6_MASK             64
    #define ADC1RLB_D7_MASK             128
    
  } Overlap_STR;

} ADC1RBSTR;
extern volatile ADC1RBSTR _ADC1RB @0x00000086;
#define ADC1RB                          _ADC1RB.Word


/*** SCI1BD - SCI1 Baud Rate Register; 0x00000088 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SCI1BDH - SCI1 Baud Rate Register High; 0x00000088 ***/
    union {
      byte Byte;
      struct {
        byte SBR8        :1;                                       /* Baud Rate Modulo Divisor Bit 8 */
        byte SBR9        :1;                                       /* Baud Rate Modulo Divisor Bit 9 */
        byte SBR10       :1;                                       /* Baud Rate Modulo Divisor Bit 10 */
        byte SBR11       :1;                                       /* Baud Rate Modulo Divisor Bit 11 */
        byte SBR12       :1;                                       /* Baud Rate Modulo Divisor Bit 12 */
        byte             :1; 
        byte RXEDGIE     :1;                                       /* RxD Input Active Edge Interrupt Enable (for RXEDGIF) */
        byte LBKDIE      :1;                                       /* LIN Break Detect Interrupt Enable (for LBKDIF) */
      } Bits;
      struct {
        byte grpSBR_8 :5;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } SCI1BDHSTR;
    #define SCI1BDH                     _SCI1BD.Overlap_STR.SCI1BDHSTR.Byte
    #define SCI1BDH_SBR8                _SCI1BD.Overlap_STR.SCI1BDHSTR.Bits.SBR8
    #define SCI1BDH_SBR9                _SCI1BD.Overlap_STR.SCI1BDHSTR.Bits.SBR9
    #define SCI1BDH_SBR10               _SCI1BD.Overlap_STR.SCI1BDHSTR.Bits.SBR10
    #define SCI1BDH_SBR11               _SCI1BD.Overlap_STR.SCI1BDHSTR.Bits.SBR11
    #define SCI1BDH_SBR12               _SCI1BD.Overlap_STR.SCI1BDHSTR.Bits.SBR12
    #define SCI1BDH_RXEDGIE             _SCI1BD.Overlap_STR.SCI1BDHSTR.Bits.RXEDGIE
    #define SCI1BDH_LBKDIE              _SCI1BD.Overlap_STR.SCI1BDHSTR.Bits.LBKDIE
    #define SCI1BDH_SBR_8               _SCI1BD.Overlap_STR.SCI1BDHSTR.MergedBits.grpSBR_8
    #define SCI1BDH_SBR                 SCI1BDH_SBR_8
    
    #define SCI1BDH_SBR8_MASK           1
    #define SCI1BDH_SBR9_MASK           2
    #define SCI1BDH_SBR10_MASK          4
    #define SCI1BDH_SBR11_MASK          8
    #define SCI1BDH_SBR12_MASK          16
    #define SCI1BDH_RXEDGIE_MASK        64
    #define SCI1BDH_LBKDIE_MASK         128
    #define SCI1BDH_SBR_8_MASK          31
    #define SCI1BDH_SBR_8_BITNUM        0
    

    /*** SCI1BDL - SCI1 Baud Rate Register Low; 0x00000089 ***/
    union {
      byte Byte;
      struct {
        byte SBR0        :1;                                       /* Baud Rate Modulo Divisor Bit 0 */
        byte SBR1        :1;                                       /* Baud Rate Modulo Divisor Bit 1 */
        byte SBR2        :1;                                       /* Baud Rate Modulo Divisor Bit 2 */
        byte SBR3        :1;                                       /* Baud Rate Modulo Divisor Bit 3 */
        byte SBR4        :1;                                       /* Baud Rate Modulo Divisor Bit 4 */
        byte SBR5        :1;                                       /* Baud Rate Modulo Divisor Bit 5 */
        byte SBR6        :1;                                       /* Baud Rate Modulo Divisor Bit 6 */
        byte SBR7        :1;                                       /* Baud Rate Modulo Divisor Bit 7 */
      } Bits;
    } SCI1BDLSTR;
    #define SCI1BDL                     _SCI1BD.Overlap_STR.SCI1BDLSTR.Byte
    #define SCI1BDL_SBR0                _SCI1BD.Overlap_STR.SCI1BDLSTR.Bits.SBR0
    #define SCI1BDL_SBR1                _SCI1BD.Overlap_STR.SCI1BDLSTR.Bits.SBR1
    #define SCI1BDL_SBR2                _SCI1BD.Overlap_STR.SCI1BDLSTR.Bits.SBR2
    #define SCI1BDL_SBR3                _SCI1BD.Overlap_STR.SCI1BDLSTR.Bits.SBR3
    #define SCI1BDL_SBR4                _SCI1BD.Overlap_STR.SCI1BDLSTR.Bits.SBR4
    #define SCI1BDL_SBR5                _SCI1BD.Overlap_STR.SCI1BDLSTR.Bits.SBR5
    #define SCI1BDL_SBR6                _SCI1BD.Overlap_STR.SCI1BDLSTR.Bits.SBR6
    #define SCI1BDL_SBR7                _SCI1BD.Overlap_STR.SCI1BDLSTR.Bits.SBR7
    
    #define SCI1BDL_SBR0_MASK           1
    #define SCI1BDL_SBR1_MASK           2
    #define SCI1BDL_SBR2_MASK           4
    #define SCI1BDL_SBR3_MASK           8
    #define SCI1BDL_SBR4_MASK           16
    #define SCI1BDL_SBR5_MASK           32
    #define SCI1BDL_SBR6_MASK           64
    #define SCI1BDL_SBR7_MASK           128
    
  } Overlap_STR;

} SCI1BDSTR;
extern volatile SCI1BDSTR _SCI1BD @0x00000088;
#define SCI1BD                          _SCI1BD.Word


/*** SCI1C1 - SCI1 Control Register 1; 0x0000008A ***/
typedef union {
  byte Byte;
  struct {
    byte PT          :1;                                       /* Parity Type */
    byte PE          :1;                                       /* Parity Enable */
    byte ILT         :1;                                       /* Idle Line Type Select */
    byte WAKE        :1;                                       /* Receiver Wakeup Method Select */
    byte M           :1;                                       /* 9-Bit or 8-Bit Mode Select */
    byte RSRC        :1;                                       /* Receiver Source Select */
    byte SCISWAI     :1;                                       /* SCI Stops in Wait Mode */
    byte LOOPS       :1;                                       /* Loop Mode Select */
  } Bits;
} SCI1C1STR;
extern volatile SCI1C1STR _SCI1C1 @0x0000008A;
#define SCI1C1                          _SCI1C1.Byte
#define SCI1C1_PT                       _SCI1C1.Bits.PT
#define SCI1C1_PE                       _SCI1C1.Bits.PE
#define SCI1C1_ILT                      _SCI1C1.Bits.ILT
#define SCI1C1_WAKE                     _SCI1C1.Bits.WAKE
#define SCI1C1_M                        _SCI1C1.Bits.M
#define SCI1C1_RSRC                     _SCI1C1.Bits.RSRC
#define SCI1C1_SCISWAI                  _SCI1C1.Bits.SCISWAI
#define SCI1C1_LOOPS                    _SCI1C1.Bits.LOOPS

#define SCI1C1_PT_MASK                  1
#define SCI1C1_PE_MASK                  2
#define SCI1C1_ILT_MASK                 4
#define SCI1C1_WAKE_MASK                8
#define SCI1C1_M_MASK                   16
#define SCI1C1_RSRC_MASK                32
#define SCI1C1_SCISWAI_MASK             64
#define SCI1C1_LOOPS_MASK               128


/*** SCI1C2 - SCI1 Control Register 2; 0x0000008B ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break */
    byte RWU         :1;                                       /* Receiver Wakeup Control */
    byte RE          :1;                                       /* Receiver Enable */
    byte TE          :1;                                       /* Transmitter Enable */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable (for IDLE) */
    byte RIE         :1;                                       /* Receiver Interrupt Enable (for RDRF) */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable (for TC) */
    byte TIE         :1;                                       /* Transmit Interrupt Enable (for TDRE) */
  } Bits;
} SCI1C2STR;
extern volatile SCI1C2STR _SCI1C2 @0x0000008B;
#define SCI1C2                          _SCI1C2.Byte
#define SCI1C2_SBK                      _SCI1C2.Bits.SBK
#define SCI1C2_RWU                      _SCI1C2.Bits.RWU
#define SCI1C2_RE                       _SCI1C2.Bits.RE
#define SCI1C2_TE                       _SCI1C2.Bits.TE
#define SCI1C2_ILIE                     _SCI1C2.Bits.ILIE
#define SCI1C2_RIE                      _SCI1C2.Bits.RIE
#define SCI1C2_TCIE                     _SCI1C2.Bits.TCIE
#define SCI1C2_TIE                      _SCI1C2.Bits.TIE

#define SCI1C2_SBK_MASK                 1
#define SCI1C2_RWU_MASK                 2
#define SCI1C2_RE_MASK                  4
#define SCI1C2_TE_MASK                  8
#define SCI1C2_ILIE_MASK                16
#define SCI1C2_RIE_MASK                 32
#define SCI1C2_TCIE_MASK                64
#define SCI1C2_TIE_MASK                 128


/*** SCI1S1 - SCI1 Status Register 1; 0x0000008C ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Receiver Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF        :1;                                       /* Receive Data Register Full Flag */
    byte TC          :1;                                       /* Transmission Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} SCI1S1STR;
extern volatile SCI1S1STR _SCI1S1 @0x0000008C;
#define SCI1S1                          _SCI1S1.Byte
#define SCI1S1_PF                       _SCI1S1.Bits.PF
#define SCI1S1_FE                       _SCI1S1.Bits.FE
#define SCI1S1_NF                       _SCI1S1.Bits.NF
#define SCI1S1_OR                       _SCI1S1.Bits.OR
#define SCI1S1_IDLE                     _SCI1S1.Bits.IDLE
#define SCI1S1_RDRF                     _SCI1S1.Bits.RDRF
#define SCI1S1_TC                       _SCI1S1.Bits.TC
#define SCI1S1_TDRE                     _SCI1S1.Bits.TDRE

#define SCI1S1_PF_MASK                  1
#define SCI1S1_FE_MASK                  2
#define SCI1S1_NF_MASK                  4
#define SCI1S1_OR_MASK                  8
#define SCI1S1_IDLE_MASK                16
#define SCI1S1_RDRF_MASK                32
#define SCI1S1_TC_MASK                  64
#define SCI1S1_TDRE_MASK                128


/*** SCI1S2 - SCI1 Status Register 2; 0x0000008D ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte LBKDE       :1;                                       /* LIN Break Detection Enable */
    byte BRK13       :1;                                       /* Break Character Generation Length */
    byte RWUID       :1;                                       /* Receive Wake Up Idle Detect */
    byte RXINV       :1;                                       /* Receive Data Inversion */
    byte             :1; 
    byte RXEDGIF     :1;                                       /* RxD Pin Active Edge Interrupt Flag */
    byte LBKDIF      :1;                                       /* LIN Break Detect Interrupt Flag */
  } Bits;
} SCI1S2STR;
extern volatile SCI1S2STR _SCI1S2 @0x0000008D;
#define SCI1S2                          _SCI1S2.Byte
#define SCI1S2_RAF                      _SCI1S2.Bits.RAF
#define SCI1S2_LBKDE                    _SCI1S2.Bits.LBKDE
#define SCI1S2_BRK13                    _SCI1S2.Bits.BRK13
#define SCI1S2_RWUID                    _SCI1S2.Bits.RWUID
#define SCI1S2_RXINV                    _SCI1S2.Bits.RXINV
#define SCI1S2_RXEDGIF                  _SCI1S2.Bits.RXEDGIF
#define SCI1S2_LBKDIF                   _SCI1S2.Bits.LBKDIF

#define SCI1S2_RAF_MASK                 1
#define SCI1S2_LBKDE_MASK               2
#define SCI1S2_BRK13_MASK               4
#define SCI1S2_RWUID_MASK               8
#define SCI1S2_RXINV_MASK               16
#define SCI1S2_RXEDGIF_MASK             64
#define SCI1S2_LBKDIF_MASK              128


/*** SCI1C3 - SCI1 Control Register 3; 0x0000008E ***/
typedef union {
  byte Byte;
  struct {
    byte PEIE        :1;                                       /* Parity Error Interrupt Enable */
    byte FEIE        :1;                                       /* Framing Error Interrupt Enable */
    byte NEIE        :1;                                       /* Noise Error Interrupt Enable */
    byte ORIE        :1;                                       /* Overrun Interrupt Enable */
    byte TXINV       :1;                                       /* Transmit Data Inversion */
    byte TXDIR       :1;                                       /* TxD Pin Direction in Single-Wire Mode */
    byte T8          :1;                                       /* Ninth Data Bit for Transmitter */
    byte R8          :1;                                       /* Ninth Data Bit for Receiver */
  } Bits;
} SCI1C3STR;
extern volatile SCI1C3STR _SCI1C3 @0x0000008E;
#define SCI1C3                          _SCI1C3.Byte
#define SCI1C3_PEIE                     _SCI1C3.Bits.PEIE
#define SCI1C3_FEIE                     _SCI1C3.Bits.FEIE
#define SCI1C3_NEIE                     _SCI1C3.Bits.NEIE
#define SCI1C3_ORIE                     _SCI1C3.Bits.ORIE
#define SCI1C3_TXINV                    _SCI1C3.Bits.TXINV
#define SCI1C3_TXDIR                    _SCI1C3.Bits.TXDIR
#define SCI1C3_T8                       _SCI1C3.Bits.T8
#define SCI1C3_R8                       _SCI1C3.Bits.R8

#define SCI1C3_PEIE_MASK                1
#define SCI1C3_FEIE_MASK                2
#define SCI1C3_NEIE_MASK                4
#define SCI1C3_ORIE_MASK                8
#define SCI1C3_TXINV_MASK               16
#define SCI1C3_TXDIR_MASK               32
#define SCI1C3_T8_MASK                  64
#define SCI1C3_R8_MASK                  128


/*** SCI1D - SCI1 Data Register; 0x0000008F ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Receive/Transmit Data Bit 0 */
    byte R1_T1       :1;                                       /* Receive/Transmit Data Bit 1 */
    byte R2_T2       :1;                                       /* Receive/Transmit Data Bit 2 */
    byte R3_T3       :1;                                       /* Receive/Transmit Data Bit 3 */
    byte R4_T4       :1;                                       /* Receive/Transmit Data Bit 4 */
    byte R5_T5       :1;                                       /* Receive/Transmit Data Bit 5 */
    byte R6_T6       :1;                                       /* Receive/Transmit Data Bit 6 */
    byte R7_T7       :1;                                       /* Receive/Transmit Data Bit 7 */
  } Bits;
} SCI1DSTR;
extern volatile SCI1DSTR _SCI1D @0x0000008F;
#define SCI1D                           _SCI1D.Byte
#define SCI1D_R0_T0                     _SCI1D.Bits.R0_T0
#define SCI1D_R1_T1                     _SCI1D.Bits.R1_T1
#define SCI1D_R2_T2                     _SCI1D.Bits.R2_T2
#define SCI1D_R3_T3                     _SCI1D.Bits.R3_T3
#define SCI1D_R4_T4                     _SCI1D.Bits.R4_T4
#define SCI1D_R5_T5                     _SCI1D.Bits.R5_T5
#define SCI1D_R6_T6                     _SCI1D.Bits.R6_T6
#define SCI1D_R7_T7                     _SCI1D.Bits.R7_T7

#define SCI1D_R0_T0_MASK                1
#define SCI1D_R1_T1_MASK                2
#define SCI1D_R2_T2_MASK                4
#define SCI1D_R3_T3_MASK                8
#define SCI1D_R4_T4_MASK                16
#define SCI1D_R5_T5_MASK                32
#define SCI1D_R6_T6_MASK                64
#define SCI1D_R7_T7_MASK                128


/*** IICA1 - IIC Address Register; 0x00000090 ***/
typedef union {
  byte Byte;
  union { /* Several registers at the same address */
    /*** IICA1 - IIC Address Register; Several registers at the same address ***/
    union {
      struct {
        byte             :1; 
        byte AD1         :1;                                       /* Slave Address Bit 1 */
        byte AD2         :1;                                       /* Slave Address Bit 2 */
        byte AD3         :1;                                       /* Slave Address Bit 3 */
        byte AD4         :1;                                       /* Slave Address Bit 4 */
        byte AD5         :1;                                       /* Slave Address Bit 5 */
        byte AD6         :1;                                       /* Slave Address Bit 6 */
        byte AD7         :1;                                       /* Slave Address Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte grpAD_1 :7;
      } MergedBits;
    } IICA1STR;
    #define IICA1                       _IICA1.Byte
    #define IICA1_AD1                   _IICA1.SameAddr_STR.IICA1STR.Bits.AD1
    #define IICA1_AD2                   _IICA1.SameAddr_STR.IICA1STR.Bits.AD2
    #define IICA1_AD3                   _IICA1.SameAddr_STR.IICA1STR.Bits.AD3
    #define IICA1_AD4                   _IICA1.SameAddr_STR.IICA1STR.Bits.AD4
    #define IICA1_AD5                   _IICA1.SameAddr_STR.IICA1STR.Bits.AD5
    #define IICA1_AD6                   _IICA1.SameAddr_STR.IICA1STR.Bits.AD6
    #define IICA1_AD7                   _IICA1.SameAddr_STR.IICA1STR.Bits.AD7
    #define IICA1_AD_1                  _IICA1.SameAddr_STR.IICA1STR.MergedBits.grpAD_1
    #define IICA1_AD                    IICA1_AD_1
    
    #define IICA1_AD1_MASK              2
    #define IICA1_AD2_MASK              4
    #define IICA1_AD3_MASK              8
    #define IICA1_AD4_MASK              16
    #define IICA1_AD5_MASK              32
    #define IICA1_AD6_MASK              64
    #define IICA1_AD7_MASK              128
    #define IICA1_AD_1_MASK             254
    #define IICA1_AD_1_BITNUM           1
    
    /*** IICA - IIC Address Register; Several registers at the same address ***/
    union {
      struct {
        byte             :1; 
        byte AD1         :1;                                       /* Slave Address Bit 1 */
        byte AD2         :1;                                       /* Slave Address Bit 2 */
        byte AD3         :1;                                       /* Slave Address Bit 3 */
        byte AD4         :1;                                       /* Slave Address Bit 4 */
        byte AD5         :1;                                       /* Slave Address Bit 5 */
        byte AD6         :1;                                       /* Slave Address Bit 6 */
        byte AD7         :1;                                       /* Slave Address Bit 7 */
      } Bits;
      struct {
        byte     :1;
        byte grpAD_1 :7;
      } MergedBits;
    } IICASTR;
    #define IICA                        _IICA1.Byte
    #define IICA_AD1                    _IICA1.SameAddr_STR.IICASTR.Bits.AD1
    #define IICA_AD2                    _IICA1.SameAddr_STR.IICASTR.Bits.AD2
    #define IICA_AD3                    _IICA1.SameAddr_STR.IICASTR.Bits.AD3
    #define IICA_AD4                    _IICA1.SameAddr_STR.IICASTR.Bits.AD4
    #define IICA_AD5                    _IICA1.SameAddr_STR.IICASTR.Bits.AD5
    #define IICA_AD6                    _IICA1.SameAddr_STR.IICASTR.Bits.AD6
    #define IICA_AD7                    _IICA1.SameAddr_STR.IICASTR.Bits.AD7
    #define IICA_AD_1                   _IICA1.SameAddr_STR.IICASTR.MergedBits.grpAD_1
    #define IICA_AD                     IICA_AD_1
    
    #define IICA_AD1_MASK               2
    #define IICA_AD2_MASK               4
    #define IICA_AD3_MASK               8
    #define IICA_AD4_MASK               16
    #define IICA_AD5_MASK               32
    #define IICA_AD6_MASK               64
    #define IICA_AD7_MASK               128
    #define IICA_AD_1_MASK              254
    #define IICA_AD_1_BITNUM            1
    
  } SameAddr_STR; /*Several registers at the same address */

} IICA1STR;
extern volatile IICA1STR _IICA1 @0x00000090;


/*** IICF - IIC Frequency Divider Register; 0x00000091 ***/
typedef union {
  byte Byte;
  struct {
    byte ICR0        :1;                                       /* IIC Clock Rate Bit 0 */
    byte ICR1        :1;                                       /* IIC Clock Rate Bit 1 */
    byte ICR2        :1;                                       /* IIC Clock Rate Bit 2 */
    byte ICR3        :1;                                       /* IIC Clock Rate Bit 3 */
    byte ICR4        :1;                                       /* IIC Clock Rate Bit 4 */
    byte ICR5        :1;                                       /* IIC Clock Rate Bit 5 */
    byte MULT0       :1;                                       /* Multiplier Factor Bit 0 */
    byte MULT1       :1;                                       /* Multiplier Factor Bit 1 */
  } Bits;
  struct {
    byte grpICR  :6;
    byte grpMULT :2;
  } MergedBits;
} IICFSTR;
extern volatile IICFSTR _IICF @0x00000091;
#define IICF                            _IICF.Byte
#define IICF_ICR0                       _IICF.Bits.ICR0
#define IICF_ICR1                       _IICF.Bits.ICR1
#define IICF_ICR2                       _IICF.Bits.ICR2
#define IICF_ICR3                       _IICF.Bits.ICR3
#define IICF_ICR4                       _IICF.Bits.ICR4
#define IICF_ICR5                       _IICF.Bits.ICR5
#define IICF_MULT0                      _IICF.Bits.MULT0
#define IICF_MULT1                      _IICF.Bits.MULT1
#define IICF_ICR                        _IICF.MergedBits.grpICR
#define IICF_MULT                       _IICF.MergedBits.grpMULT

#define IICF_ICR0_MASK                  1
#define IICF_ICR1_MASK                  2
#define IICF_ICR2_MASK                  4
#define IICF_ICR3_MASK                  8
#define IICF_ICR4_MASK                  16
#define IICF_ICR5_MASK                  32
#define IICF_MULT0_MASK                 64
#define IICF_MULT1_MASK                 128
#define IICF_ICR_MASK                   63
#define IICF_ICR_BITNUM                 0
#define IICF_MULT_MASK                  192
#define IICF_MULT_BITNUM                6


/*** IICC1 - IIC Control Register 1; 0x00000092 ***/
typedef union {
  byte Byte;
  union { /* Several registers at the same address */
    /*** IICC1 - IIC Control Register 1; Several registers at the same address ***/
    union {
      struct {
        byte             :1; 
        byte WUEN        :1;                                       /* Wake-up Enable */
        byte RSTA        :1;                                       /* Repeat START */
        byte TXAK        :1;                                       /* Transmit Acknowledge Enable */
        byte TX          :1;                                       /* Transmit Mode Select */
        byte MST         :1;                                       /* Master Mode Select */
        byte IICIE       :1;                                       /* IIC Interrupt Enable */
        byte IICEN       :1;                                       /* IIC Enable */
      } Bits;
    } IICC1STR;
    #define IICC1                       _IICC1.Byte
    #define IICC1_WUEN                  _IICC1.SameAddr_STR.IICC1STR.Bits.WUEN
    #define IICC1_RSTA                  _IICC1.SameAddr_STR.IICC1STR.Bits.RSTA
    #define IICC1_TXAK                  _IICC1.SameAddr_STR.IICC1STR.Bits.TXAK
    #define IICC1_TX                    _IICC1.SameAddr_STR.IICC1STR.Bits.TX
    #define IICC1_MST                   _IICC1.SameAddr_STR.IICC1STR.Bits.MST
    #define IICC1_IICIE                 _IICC1.SameAddr_STR.IICC1STR.Bits.IICIE
    #define IICC1_IICEN                 _IICC1.SameAddr_STR.IICC1STR.Bits.IICEN
    
    #define IICC1_WUEN_MASK             2
    #define IICC1_RSTA_MASK             4
    #define IICC1_TXAK_MASK             8
    #define IICC1_TX_MASK               16
    #define IICC1_MST_MASK              32
    #define IICC1_IICIE_MASK            64
    #define IICC1_IICEN_MASK            128
    
    /*** IICC - IIC Control Register; Several registers at the same address ***/
    union {
      struct {
        byte             :1; 
        byte WUEN        :1;                                       /* Wake-up Enable */
        byte RSTA        :1;                                       /* Repeat START */
        byte TXAK        :1;                                       /* Transmit Acknowledge Enable */
        byte TX          :1;                                       /* Transmit Mode Select */
        byte MST         :1;                                       /* Master Mode Select */
        byte IICIE       :1;                                       /* IIC Interrupt Enable */
        byte IICEN       :1;                                       /* IIC Enable */
      } Bits;
    } IICCSTR;
    #define IICC                        _IICC1.Byte
    #define IICC_WUEN                   _IICC1.SameAddr_STR.IICCSTR.Bits.WUEN
    #define IICC_RSTA                   _IICC1.SameAddr_STR.IICCSTR.Bits.RSTA
    #define IICC_TXAK                   _IICC1.SameAddr_STR.IICCSTR.Bits.TXAK
    #define IICC_TX                     _IICC1.SameAddr_STR.IICCSTR.Bits.TX
    #define IICC_MST                    _IICC1.SameAddr_STR.IICCSTR.Bits.MST
    #define IICC_IICIE                  _IICC1.SameAddr_STR.IICCSTR.Bits.IICIE
    #define IICC_IICEN                  _IICC1.SameAddr_STR.IICCSTR.Bits.IICEN
    
    #define IICC_WUEN_MASK              2
    #define IICC_RSTA_MASK              4
    #define IICC_TXAK_MASK              8
    #define IICC_TX_MASK                16
    #define IICC_MST_MASK               32
    #define IICC_IICIE_MASK             64
    #define IICC_IICEN_MASK             128
    
  } SameAddr_STR; /*Several registers at the same address */

} IICC1STR;
extern volatile IICC1STR _IICC1 @0x00000092;


/*** IICS - IIC Status Register; 0x00000093 ***/
typedef union {
  byte Byte;
  struct {
    byte RXAK        :1;                                       /* Receive Acknowledge */
    byte IICIF       :1;                                       /* IIC Interrupt Flag */
    byte SRW         :1;                                       /* Slave Read/Write */
    byte             :1; 
    byte ARBL        :1;                                       /* Arbitration Lost */
    byte BUSY        :1;                                       /* Bus Busy */
    byte IAAS        :1;                                       /* Addressed as a Slave */
    byte TCF         :1;                                       /* Transfer Complete Flag */
  } Bits;
} IICSSTR;
extern volatile IICSSTR _IICS @0x00000093;
#define IICS                            _IICS.Byte
#define IICS_RXAK                       _IICS.Bits.RXAK
#define IICS_IICIF                      _IICS.Bits.IICIF
#define IICS_SRW                        _IICS.Bits.SRW
#define IICS_ARBL                       _IICS.Bits.ARBL
#define IICS_BUSY                       _IICS.Bits.BUSY
#define IICS_IAAS                       _IICS.Bits.IAAS
#define IICS_TCF                        _IICS.Bits.TCF

#define IICS_RXAK_MASK                  1
#define IICS_IICIF_MASK                 2
#define IICS_SRW_MASK                   4
#define IICS_ARBL_MASK                  16
#define IICS_BUSY_MASK                  32
#define IICS_IAAS_MASK                  64
#define IICS_TCF_MASK                   128


/*** IICD - IIC Data I/O Register; 0x00000094 ***/
typedef union {
  byte Byte;
  struct {
    byte DATA0       :1;                                       /* IIC Data Bit 0 */
    byte DATA1       :1;                                       /* IIC Data Bit 1 */
    byte DATA2       :1;                                       /* IIC Data Bit 2 */
    byte DATA3       :1;                                       /* IIC Data Bit 3 */
    byte DATA4       :1;                                       /* IIC Data Bit 4 */
    byte DATA5       :1;                                       /* IIC Data Bit 5 */
    byte DATA6       :1;                                       /* IIC Data Bit 6 */
    byte DATA7       :1;                                       /* IIC Data Bit 7 */
  } Bits;
} IICDSTR;
extern volatile IICDSTR _IICD @0x00000094;
#define IICD                            _IICD.Byte
#define IICD_DATA0                      _IICD.Bits.DATA0
#define IICD_DATA1                      _IICD.Bits.DATA1
#define IICD_DATA2                      _IICD.Bits.DATA2
#define IICD_DATA3                      _IICD.Bits.DATA3
#define IICD_DATA4                      _IICD.Bits.DATA4
#define IICD_DATA5                      _IICD.Bits.DATA5
#define IICD_DATA6                      _IICD.Bits.DATA6
#define IICD_DATA7                      _IICD.Bits.DATA7

#define IICD_DATA0_MASK                 1
#define IICD_DATA1_MASK                 2
#define IICD_DATA2_MASK                 4
#define IICD_DATA3_MASK                 8
#define IICD_DATA4_MASK                 16
#define IICD_DATA5_MASK                 32
#define IICD_DATA6_MASK                 64
#define IICD_DATA7_MASK                 128


/*** IICC2 - IIC Control Register 2; 0x00000095 ***/
typedef union {
  byte Byte;
  struct {
    byte AD8         :1;                                       /* Slave Address Bit 8 */
    byte AD9         :1;                                       /* Slave Address Bit 9 */
    byte AD10        :1;                                       /* Slave Address Bit 10 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte ADEXT       :1;                                       /* Address Extension */
    byte GCAEN       :1;                                       /* General Call Address Enable */
  } Bits;
  struct {
    byte grpAD_8 :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} IICC2STR;
extern volatile IICC2STR _IICC2 @0x00000095;
#define IICC2                           _IICC2.Byte
#define IICC2_AD8                       _IICC2.Bits.AD8
#define IICC2_AD9                       _IICC2.Bits.AD9
#define IICC2_AD10                      _IICC2.Bits.AD10
#define IICC2_ADEXT                     _IICC2.Bits.ADEXT
#define IICC2_GCAEN                     _IICC2.Bits.GCAEN
#define IICC2_AD_8                      _IICC2.MergedBits.grpAD_8
#define IICC2_AD                        IICC2_AD_8

#define IICC2_AD8_MASK                  1
#define IICC2_AD9_MASK                  2
#define IICC2_AD10_MASK                 4
#define IICC2_ADEXT_MASK                64
#define IICC2_GCAEN_MASK                128
#define IICC2_AD_8_MASK                 7
#define IICC2_AD_8_BITNUM               0


/*** IICFLT - IIC Filter register; 0x00000096 ***/
typedef union {
  byte Byte;
  struct {
    byte FLT0        :1;                                       /* Filter value bit 0 */
    byte FLT1        :1;                                       /* Filter value bit 1 */
    byte FLT2        :1;                                       /* Filter value bit 2 */
    byte FLT3        :1;                                       /* Filter value bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpFLT  :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} IICFLTSTR;
extern volatile IICFLTSTR _IICFLT @0x00000096;
#define IICFLT                          _IICFLT.Byte
#define IICFLT_FLT0                     _IICFLT.Bits.FLT0
#define IICFLT_FLT1                     _IICFLT.Bits.FLT1
#define IICFLT_FLT2                     _IICFLT.Bits.FLT2
#define IICFLT_FLT3                     _IICFLT.Bits.FLT3
#define IICFLT_FLT                      _IICFLT.MergedBits.grpFLT

#define IICFLT_FLT0_MASK                1
#define IICFLT_FLT1_MASK                2
#define IICFLT_FLT2_MASK                4
#define IICFLT_FLT3_MASK                8
#define IICFLT_FLT_MASK                 15
#define IICFLT_FLT_BITNUM               0


/*** IICSMB - SMBus Control and Status Register; 0x00000097 ***/
typedef union {
  byte Byte;
  struct {
    byte SHTF2IE     :1;                                       /* SHTF2 Interrupt Enable */
    byte SHTF2       :1;                                       /* SCL High Timeout Flag 2 */
    byte SHTF1       :1;                                       /* SCL High Timeout Flag 1 */
    byte SLTF        :1;                                       /* SCL Low Timeout Flag */
    byte TCKSEL      :1;                                       /* Time Out Counter Clock Select */
    byte SIICAEN     :1;                                       /* Second IIC Address Enable */
    byte ALERTEN     :1;                                       /* SMBus Alert Response Address Enable */
    byte FACK        :1;                                       /* Fast NACK/ACK enable */
  } Bits;
} IICSMBSTR;
extern volatile IICSMBSTR _IICSMB @0x00000097;
#define IICSMB                          _IICSMB.Byte
#define IICSMB_SHTF2IE                  _IICSMB.Bits.SHTF2IE
#define IICSMB_SHTF2                    _IICSMB.Bits.SHTF2
#define IICSMB_SHTF1                    _IICSMB.Bits.SHTF1
#define IICSMB_SLTF                     _IICSMB.Bits.SLTF
#define IICSMB_TCKSEL                   _IICSMB.Bits.TCKSEL
#define IICSMB_SIICAEN                  _IICSMB.Bits.SIICAEN
#define IICSMB_ALERTEN                  _IICSMB.Bits.ALERTEN
#define IICSMB_FACK                     _IICSMB.Bits.FACK

#define IICSMB_SHTF2IE_MASK             1
#define IICSMB_SHTF2_MASK               2
#define IICSMB_SHTF1_MASK               4
#define IICSMB_SLTF_MASK                8
#define IICSMB_TCKSEL_MASK              16
#define IICSMB_SIICAEN_MASK             32
#define IICSMB_ALERTEN_MASK             64
#define IICSMB_FACK_MASK                128


/*** IICA2 - IIC Address Register 2; 0x00000098 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte SAD1        :1;                                       /* SMBus Address Bit 1 */
    byte SAD2        :1;                                       /* SMBus Address Bit 2 */
    byte SAD3        :1;                                       /* SMBus Address Bit 3 */
    byte SAD4        :1;                                       /* SMBus Address Bit 4 */
    byte SAD5        :1;                                       /* SMBus Address Bit 5 */
    byte SAD6        :1;                                       /* SMBus Address Bit 6 */
    byte SAD7        :1;                                       /* SMBus Address Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte grpSAD_1 :7;
  } MergedBits;
} IICA2STR;
extern volatile IICA2STR _IICA2 @0x00000098;
#define IICA2                           _IICA2.Byte
#define IICA2_SAD1                      _IICA2.Bits.SAD1
#define IICA2_SAD2                      _IICA2.Bits.SAD2
#define IICA2_SAD3                      _IICA2.Bits.SAD3
#define IICA2_SAD4                      _IICA2.Bits.SAD4
#define IICA2_SAD5                      _IICA2.Bits.SAD5
#define IICA2_SAD6                      _IICA2.Bits.SAD6
#define IICA2_SAD7                      _IICA2.Bits.SAD7
#define IICA2_SAD_1                     _IICA2.MergedBits.grpSAD_1
#define IICA2_SAD                       IICA2_SAD_1

#define IICA2_SAD1_MASK                 2
#define IICA2_SAD2_MASK                 4
#define IICA2_SAD3_MASK                 8
#define IICA2_SAD4_MASK                 16
#define IICA2_SAD5_MASK                 32
#define IICA2_SAD6_MASK                 64
#define IICA2_SAD7_MASK                 128
#define IICA2_SAD_1_MASK                254
#define IICA2_SAD_1_BITNUM              1


/*** IICSLT - IIC SCL Low Time Out register; 0x00000099 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** IICSLTH - IIC SCL Low Time Out register - High byte; 0x00000099 ***/
    union {
      byte Byte;
      struct {
        byte SSLT8       :1;                                       /* SCL Low Time Out Bit 8 */
        byte SSLT9       :1;                                       /* SCL Low Time Out Bit 9 */
        byte SSLT10      :1;                                       /* SCL Low Time Out Bit 10 */
        byte SSLT11      :1;                                       /* SCL Low Time Out Bit 11 */
        byte SSLT12      :1;                                       /* SCL Low Time Out Bit 12 */
        byte SSLT13      :1;                                       /* SCL Low Time Out Bit 13 */
        byte SSLT14      :1;                                       /* SCL Low Time Out Bit 14 */
        byte SSLT15      :1;                                       /* SCL Low Time Out Bit 15 */
      } Bits;
    } IICSLTHSTR;
    #define IICSLTH                     _IICSLT.Overlap_STR.IICSLTHSTR.Byte
    #define IICSLTH_SSLT8               _IICSLT.Overlap_STR.IICSLTHSTR.Bits.SSLT8
    #define IICSLTH_SSLT9               _IICSLT.Overlap_STR.IICSLTHSTR.Bits.SSLT9
    #define IICSLTH_SSLT10              _IICSLT.Overlap_STR.IICSLTHSTR.Bits.SSLT10
    #define IICSLTH_SSLT11              _IICSLT.Overlap_STR.IICSLTHSTR.Bits.SSLT11
    #define IICSLTH_SSLT12              _IICSLT.Overlap_STR.IICSLTHSTR.Bits.SSLT12
    #define IICSLTH_SSLT13              _IICSLT.Overlap_STR.IICSLTHSTR.Bits.SSLT13
    #define IICSLTH_SSLT14              _IICSLT.Overlap_STR.IICSLTHSTR.Bits.SSLT14
    #define IICSLTH_SSLT15              _IICSLT.Overlap_STR.IICSLTHSTR.Bits.SSLT15
    
    #define IICSLTH_SSLT8_MASK          1
    #define IICSLTH_SSLT9_MASK          2
    #define IICSLTH_SSLT10_MASK         4
    #define IICSLTH_SSLT11_MASK         8
    #define IICSLTH_SSLT12_MASK         16
    #define IICSLTH_SSLT13_MASK         32
    #define IICSLTH_SSLT14_MASK         64
    #define IICSLTH_SSLT15_MASK         128
    

    /*** IICSLTL - IIC SCL Low Time Out register - Low byte; 0x0000009A ***/
    union {
      byte Byte;
      struct {
        byte SSLT0       :1;                                       /* SCL Low Time Out Bits, bit 0 */
        byte SSLT1       :1;                                       /* SCL Low Time Out Bits, bit 1 */
        byte SSLT2       :1;                                       /* SCL Low Time Out Bits, bit 2 */
        byte SSLT3       :1;                                       /* SCL Low Time Out Bits, bit 3 */
        byte SSLT4       :1;                                       /* SCL Low Time Out Bits, bit 4 */
        byte SSLT5       :1;                                       /* SCL Low Time Out Bits, bit 5 */
        byte SSLT6       :1;                                       /* SCL Low Time Out Bits, bit 6 */
        byte SSLT7       :1;                                       /* SCL Low Time Out Bits, bit 7 */
      } Bits;
    } IICSLTLSTR;
    #define IICSLTL                     _IICSLT.Overlap_STR.IICSLTLSTR.Byte
    #define IICSLTL_SSLT0               _IICSLT.Overlap_STR.IICSLTLSTR.Bits.SSLT0
    #define IICSLTL_SSLT1               _IICSLT.Overlap_STR.IICSLTLSTR.Bits.SSLT1
    #define IICSLTL_SSLT2               _IICSLT.Overlap_STR.IICSLTLSTR.Bits.SSLT2
    #define IICSLTL_SSLT3               _IICSLT.Overlap_STR.IICSLTLSTR.Bits.SSLT3
    #define IICSLTL_SSLT4               _IICSLT.Overlap_STR.IICSLTLSTR.Bits.SSLT4
    #define IICSLTL_SSLT5               _IICSLT.Overlap_STR.IICSLTLSTR.Bits.SSLT5
    #define IICSLTL_SSLT6               _IICSLT.Overlap_STR.IICSLTLSTR.Bits.SSLT6
    #define IICSLTL_SSLT7               _IICSLT.Overlap_STR.IICSLTLSTR.Bits.SSLT7
    
    #define IICSLTL_SSLT0_MASK          1
    #define IICSLTL_SSLT1_MASK          2
    #define IICSLTL_SSLT2_MASK          4
    #define IICSLTL_SSLT3_MASK          8
    #define IICSLTL_SSLT4_MASK          16
    #define IICSLTL_SSLT5_MASK          32
    #define IICSLTL_SSLT6_MASK          64
    #define IICSLTL_SSLT7_MASK          128
    
  } Overlap_STR;

} IICSLTSTR;
extern volatile IICSLTSTR _IICSLT @0x00000099;
#define IICSLT                          _IICSLT.Word


/*** FTMSC - FTM Status and Control Register; 0x000000A0 ***/
typedef union {
  byte Byte;
  struct {
    byte PS0         :1;                                       /* Prescale Divisor Select Bit 0 */
    byte PS1         :1;                                       /* Prescale Divisor Select Bit 1 */
    byte PS2         :1;                                       /* Prescale Divisor Select Bit 2 */
    byte CLKSA       :1;                                       /* Clock Source Select A */
    byte CLKSB       :1;                                       /* Clock Source Select B */
    byte CPWMS       :1;                                       /* Center-Aligned PWM Select */
    byte TOIE        :1;                                       /* Timer Overflow Interrupt Enable */
    byte TOF         :1;                                       /* Timer Overflow Flag */
  } Bits;
  struct {
    byte grpPS   :3;
    byte grpCLKSx :2;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} FTMSCSTR;
extern volatile FTMSCSTR _FTMSC @0x000000A0;
#define FTMSC                           _FTMSC.Byte
#define FTMSC_PS0                       _FTMSC.Bits.PS0
#define FTMSC_PS1                       _FTMSC.Bits.PS1
#define FTMSC_PS2                       _FTMSC.Bits.PS2
#define FTMSC_CLKSA                     _FTMSC.Bits.CLKSA
#define FTMSC_CLKSB                     _FTMSC.Bits.CLKSB
#define FTMSC_CPWMS                     _FTMSC.Bits.CPWMS
#define FTMSC_TOIE                      _FTMSC.Bits.TOIE
#define FTMSC_TOF                       _FTMSC.Bits.TOF
#define FTMSC_PS                        _FTMSC.MergedBits.grpPS
#define FTMSC_CLKSx                     _FTMSC.MergedBits.grpCLKSx

#define FTMSC_PS0_MASK                  1
#define FTMSC_PS1_MASK                  2
#define FTMSC_PS2_MASK                  4
#define FTMSC_CLKSA_MASK                8
#define FTMSC_CLKSB_MASK                16
#define FTMSC_CPWMS_MASK                32
#define FTMSC_TOIE_MASK                 64
#define FTMSC_TOF_MASK                  128
#define FTMSC_PS_MASK                   7
#define FTMSC_PS_BITNUM                 0
#define FTMSC_CLKSx_MASK                24
#define FTMSC_CLKSx_BITNUM              3


/*** FTMCNT - FTM Timer Counter Register; 0x000000A1 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** FTMCNTH - FTM Timer Counter Register High; 0x000000A1 ***/
    union {
      byte Byte;
    } FTMCNTHSTR;
    #define FTMCNTH                     _FTMCNT.Overlap_STR.FTMCNTHSTR.Byte
    

    /*** FTMCNTL - FTM Timer Counter Register Low; 0x000000A2 ***/
    union {
      byte Byte;
    } FTMCNTLSTR;
    #define FTMCNTL                     _FTMCNT.Overlap_STR.FTMCNTLSTR.Byte
    
  } Overlap_STR;

} FTMCNTSTR;
extern volatile FTMCNTSTR _FTMCNT @0x000000A1;
#define FTMCNT                          _FTMCNT.Word


/*** FTMMOD - FTM Timer Counter Modulo Register; 0x000000A3 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** FTMMODH - FTM Timer Counter Modulo Register High; 0x000000A3 ***/
    union {
      byte Byte;
    } FTMMODHSTR;
    #define FTMMODH                     _FTMMOD.Overlap_STR.FTMMODHSTR.Byte
    

    /*** FTMMODL - FTM Timer Counter Modulo Register Low; 0x000000A4 ***/
    union {
      byte Byte;
    } FTMMODLSTR;
    #define FTMMODL                     _FTMMOD.Overlap_STR.FTMMODLSTR.Byte
    
  } Overlap_STR;

} FTMMODSTR;
extern volatile FTMMODSTR _FTMMOD @0x000000A3;
#define FTMMOD                          _FTMMOD.Word


/*** FTMC0SC - FTM Timer Channel 0 Status and Control Register; 0x000000A5 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte ELS0A       :1;                                       /* Edge/Level Select Bit A */
    byte ELS0B       :1;                                       /* Edge/Level Select Bit B */
    byte MS0A        :1;                                       /* Mode Select A for FTM Channel 0 */
    byte MS0B        :1;                                       /* Mode Select B for FTM Channel 0 */
    byte CH0IE       :1;                                       /* Channel 0 Interrupt Enable */
    byte CH0F        :1;                                       /* Channel 0 Flag */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpELS0x :2;
    byte grpMS0x :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} FTMC0SCSTR;
extern volatile FTMC0SCSTR _FTMC0SC @0x000000A5;
#define FTMC0SC                         _FTMC0SC.Byte
#define FTMC0SC_ELS0A                   _FTMC0SC.Bits.ELS0A
#define FTMC0SC_ELS0B                   _FTMC0SC.Bits.ELS0B
#define FTMC0SC_MS0A                    _FTMC0SC.Bits.MS0A
#define FTMC0SC_MS0B                    _FTMC0SC.Bits.MS0B
#define FTMC0SC_CH0IE                   _FTMC0SC.Bits.CH0IE
#define FTMC0SC_CH0F                    _FTMC0SC.Bits.CH0F
#define FTMC0SC_ELS0x                   _FTMC0SC.MergedBits.grpELS0x
#define FTMC0SC_MS0x                    _FTMC0SC.MergedBits.grpMS0x

#define FTMC0SC_ELS0A_MASK              4
#define FTMC0SC_ELS0B_MASK              8
#define FTMC0SC_MS0A_MASK               16
#define FTMC0SC_MS0B_MASK               32
#define FTMC0SC_CH0IE_MASK              64
#define FTMC0SC_CH0F_MASK               128
#define FTMC0SC_ELS0x_MASK              12
#define FTMC0SC_ELS0x_BITNUM            2
#define FTMC0SC_MS0x_MASK               48
#define FTMC0SC_MS0x_BITNUM             4


/*** FTMC0V - FTM Timer Channel 0 Value Register; 0x000000A6 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** FTMC0VH - FTM Timer Channel 0 Value Register High; 0x000000A6 ***/
    union {
      byte Byte;
    } FTMC0VHSTR;
    #define FTMC0VH                     _FTMC0V.Overlap_STR.FTMC0VHSTR.Byte
    

    /*** FTMC0VL - FTM Timer Channel 0 Value Register Low; 0x000000A7 ***/
    union {
      byte Byte;
    } FTMC0VLSTR;
    #define FTMC0VL                     _FTMC0V.Overlap_STR.FTMC0VLSTR.Byte
    
  } Overlap_STR;

} FTMC0VSTR;
extern volatile FTMC0VSTR _FTMC0V @0x000000A6;
#define FTMC0V                          _FTMC0V.Word


/*** FTMC1SC - FTM Timer Channel 1 Status and Control Register; 0x000000A8 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte ELS1A       :1;                                       /* Edge/Level Select Bit A */
    byte ELS1B       :1;                                       /* Edge/Level Select Bit B */
    byte MS1A        :1;                                       /* Mode Select A for FTM Channel 1 */
    byte MS1B        :1;                                       /* Mode Select B for FTM Channel 1 */
    byte CH1IE       :1;                                       /* Channel 1 Interrupt Enable */
    byte CH1F        :1;                                       /* Channel 1 Flag */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpELS1x :2;
    byte grpMS1x :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} FTMC1SCSTR;
extern volatile FTMC1SCSTR _FTMC1SC @0x000000A8;
#define FTMC1SC                         _FTMC1SC.Byte
#define FTMC1SC_ELS1A                   _FTMC1SC.Bits.ELS1A
#define FTMC1SC_ELS1B                   _FTMC1SC.Bits.ELS1B
#define FTMC1SC_MS1A                    _FTMC1SC.Bits.MS1A
#define FTMC1SC_MS1B                    _FTMC1SC.Bits.MS1B
#define FTMC1SC_CH1IE                   _FTMC1SC.Bits.CH1IE
#define FTMC1SC_CH1F                    _FTMC1SC.Bits.CH1F
#define FTMC1SC_ELS1x                   _FTMC1SC.MergedBits.grpELS1x
#define FTMC1SC_MS1x                    _FTMC1SC.MergedBits.grpMS1x

#define FTMC1SC_ELS1A_MASK              4
#define FTMC1SC_ELS1B_MASK              8
#define FTMC1SC_MS1A_MASK               16
#define FTMC1SC_MS1B_MASK               32
#define FTMC1SC_CH1IE_MASK              64
#define FTMC1SC_CH1F_MASK               128
#define FTMC1SC_ELS1x_MASK              12
#define FTMC1SC_ELS1x_BITNUM            2
#define FTMC1SC_MS1x_MASK               48
#define FTMC1SC_MS1x_BITNUM             4


/*** FTMC1V - FTM Timer Channel 1 Value Register; 0x000000A9 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** FTMC1VH - FTM Timer Channel 1 Value Register High; 0x000000A9 ***/
    union {
      byte Byte;
    } FTMC1VHSTR;
    #define FTMC1VH                     _FTMC1V.Overlap_STR.FTMC1VHSTR.Byte
    

    /*** FTMC1VL - FTM Timer Channel 1 Value Register Low; 0x000000AA ***/
    union {
      byte Byte;
    } FTMC1VLSTR;
    #define FTMC1VL                     _FTMC1V.Overlap_STR.FTMC1VLSTR.Byte
    
  } Overlap_STR;

} FTMC1VSTR;
extern volatile FTMC1VSTR _FTMC1V @0x000000A9;
#define FTMC1V                          _FTMC1V.Word


/*** CRCH - CRC High Word Register; 0x000000B0 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** CRCH_Upper_Byte - CRC High Upper Byte; 0x000000B0 ***/
    union {
      byte Byte;
      struct {
        byte             :8;                                       /* Initial 32-bit seed, bit 24 */
      } Bits;
    } CRCH_Upper_ByteSTR;
    #define CRCH_Upper_Byte             _CRCH.Overlap_STR.CRCH_Upper_ByteSTR.Byte
    

    /*** CRCH_Lower_Byte - CRC High Lower Byte; 0x000000B1 ***/
    union {
      byte Byte;
      struct {
        byte             :8;                                       /* Initial 32-bit seed, bit 16 */
      } Bits;
    } CRCH_Lower_ByteSTR;
    #define CRCH_Lower_Byte             _CRCH.Overlap_STR.CRCH_Lower_ByteSTR.Byte
    
  } Overlap_STR;

} CRCHSTR;
extern volatile CRCHSTR _CRCH @0x000000B0;
#define CRCH                            _CRCH.Word


/*** CRCL - CRC Low Word Register; 0x000000B2 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** CRCL_Upper_Byte - CRC Low Upper Byte; 0x000000B2 ***/
    union {
      byte Byte;
      struct {
        byte             :8;                                       /* Initial 32-bit seed, bit 8 */
      } Bits;
    } CRCL_Upper_ByteSTR;
    #define CRCL_Upper_Byte             _CRCL.Overlap_STR.CRCL_Upper_ByteSTR.Byte
    

    /*** CRCL_Lower_Byte - CRC Low Lower Byte; 0x000000B3 ***/
    union {
      byte Byte;
      struct {
        byte             :8;                                       /* Initial 32-bit seed, bit 0 */
      } Bits;
    } CRCL_Lower_ByteSTR;
    #define CRCL_Lower_Byte             _CRCL.Overlap_STR.CRCL_Lower_ByteSTR.Byte
    
  } Overlap_STR;

} CRCLSTR;
extern volatile CRCLSTR _CRCL @0x000000B2;
#define CRCL                            _CRCL.Word


/*** GEN_POLY_H - Polynomial High Word Register; 0x000000B4 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** GEN_POLY_H_Upper_Byte - Polynomial High Word Upper Byte; 0x000000B4 ***/
    union {
      byte Byte;
      struct {
        byte             :8;                                       /* Generator polynomial, bit 24 */
      } Bits;
    } GEN_POLY_H_Upper_ByteSTR;
    #define GEN_POLY_H_Upper_Byte       _GEN_POLY_H.Overlap_STR.GEN_POLY_H_Upper_ByteSTR.Byte
    

    /*** GEN_POLY_H_Lower_Byte - Polynomial High Word Lower Byte; 0x000000B5 ***/
    union {
      byte Byte;
      struct {
        byte             :8;                                       /* Generator polynomial, bit 16 */
      } Bits;
    } GEN_POLY_H_Lower_ByteSTR;
    #define GEN_POLY_H_Lower_Byte       _GEN_POLY_H.Overlap_STR.GEN_POLY_H_Lower_ByteSTR.Byte
    
  } Overlap_STR;

} GEN_POLY_HSTR;
extern volatile GEN_POLY_HSTR _GEN_POLY_H @0x000000B4;
#define GEN_POLY_H                      _GEN_POLY_H.Word


/*** GEN_POLY_L - Polynomial Low Word Register; 0x000000B6 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** GEN_POLY_L_Upper_Byte - Polynomial Low Word Upper Byte; 0x000000B6 ***/
    union {
      byte Byte;
      struct {
        byte             :8;                                       /* Generator polynomial, bit 8 */
      } Bits;
    } GEN_POLY_L_Upper_ByteSTR;
    #define GEN_POLY_L_Upper_Byte       _GEN_POLY_L.Overlap_STR.GEN_POLY_L_Upper_ByteSTR.Byte
    

    /*** GEN_POLY_L_Lower_Byte - Polynomial Low Word Lower Byte; 0x000000B7 ***/
    union {
      byte Byte;
      struct {
        byte             :8;                                       /* Generator polynomial, bit 0 */
      } Bits;
    } GEN_POLY_L_Lower_ByteSTR;
    #define GEN_POLY_L_Lower_Byte       _GEN_POLY_L.Overlap_STR.GEN_POLY_L_Lower_ByteSTR.Byte
    
  } Overlap_STR;

} GEN_POLY_LSTR;
extern volatile GEN_POLY_LSTR _GEN_POLY_L @0x000000B6;
#define GEN_POLY_L                      _GEN_POLY_L.Word


/*** CRC_CTRL - Control Register; 0x000000B8 ***/
typedef union {
  word Word;
  struct {
    word TCRC        :1;                                       /* Width of CRC */
    word WaS         :1;                                       /* Writes to the CRC registers as SEED */
    word FXOR        :1;                                       /* Bit to enable XOR-ING the Final checksum value while reading */
    word             :1; 
    word ToTR0       :1;                                       /* Type of Transpose for Read, bit 0, bit 0 */
    word ToTR1       :1;                                       /* Type of Transpose for Read, bit 0, bit 1 */
    word ToT0        :1;                                       /* Type of Transpose, bit 0, bit 0 */
    word ToT1        :1;                                       /* Type of Transpose, bit 0, bit 1 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpToTR :2;
    word grpToT  :2;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} CRC_CTRLSTR;
extern volatile CRC_CTRLSTR _CRC_CTRL @0x000000B8;
#define CRC_CTRL                        _CRC_CTRL.Word
#define CRC_CTRL_TCRC                   _CRC_CTRL.Bits.TCRC
#define CRC_CTRL_WaS                    _CRC_CTRL.Bits.WaS
#define CRC_CTRL_FXOR                   _CRC_CTRL.Bits.FXOR
#define CRC_CTRL_ToTR0                  _CRC_CTRL.Bits.ToTR0
#define CRC_CTRL_ToTR1                  _CRC_CTRL.Bits.ToTR1
#define CRC_CTRL_ToT0                   _CRC_CTRL.Bits.ToT0
#define CRC_CTRL_ToT1                   _CRC_CTRL.Bits.ToT1
#define CRC_CTRL_ToTR                   _CRC_CTRL.MergedBits.grpToTR
#define CRC_CTRL_ToT                    _CRC_CTRL.MergedBits.grpToT

#define CRC_CTRL_TCRC_MASK              1
#define CRC_CTRL_WaS_MASK               2
#define CRC_CTRL_FXOR_MASK              4
#define CRC_CTRL_ToTR0_MASK             16
#define CRC_CTRL_ToTR1_MASK             32
#define CRC_CTRL_ToT0_MASK              64
#define CRC_CTRL_ToT1_MASK              128
#define CRC_CTRL_ToTR_MASK              48
#define CRC_CTRL_ToTR_BITNUM            4
#define CRC_CTRL_ToT_MASK               192
#define CRC_CTRL_ToT_BITNUM             6


/*** LCDPEN0 - LCD Pin Enable Register 0; 0x00001080 ***/
typedef union {
  byte Byte;
  struct {
    byte PEN0        :1;                                       /* Enable LCD pin 0 for LCD operation */
    byte PEN1        :1;                                       /* Enable LCD pin 1 for LCD operation */
    byte PEN2        :1;                                       /* Enable LCD pin 2 for LCD operation */
    byte PEN3        :1;                                       /* Enable LCD pin 3 for LCD operation */
    byte PEN4        :1;                                       /* Enable LCD pin 4 for LCD operation */
    byte PEN5        :1;                                       /* Enable LCD pin 5 for LCD operation */
    byte PEN6        :1;                                       /* Enable LCD pin 6 for LCD operation */
    byte PEN7        :1;                                       /* Enable LCD pin 7 for LCD operation */
  } Bits;
} LCDPEN0STR;
extern volatile LCDPEN0STR _LCDPEN0 @0x00001080;
#define LCDPEN0                         _LCDPEN0.Byte
#define LCDPEN0_PEN0                    _LCDPEN0.Bits.PEN0
#define LCDPEN0_PEN1                    _LCDPEN0.Bits.PEN1
#define LCDPEN0_PEN2                    _LCDPEN0.Bits.PEN2
#define LCDPEN0_PEN3                    _LCDPEN0.Bits.PEN3
#define LCDPEN0_PEN4                    _LCDPEN0.Bits.PEN4
#define LCDPEN0_PEN5                    _LCDPEN0.Bits.PEN5
#define LCDPEN0_PEN6                    _LCDPEN0.Bits.PEN6
#define LCDPEN0_PEN7                    _LCDPEN0.Bits.PEN7
/* LCDPEN_ARR: Access 6 LCDPENx registers in an array */
#define LCDPEN_ARR                      ((volatile byte * __far) &LCDPEN0)

#define LCDPEN0_PEN0_MASK               1
#define LCDPEN0_PEN1_MASK               2
#define LCDPEN0_PEN2_MASK               4
#define LCDPEN0_PEN3_MASK               8
#define LCDPEN0_PEN4_MASK               16
#define LCDPEN0_PEN5_MASK               32
#define LCDPEN0_PEN6_MASK               64
#define LCDPEN0_PEN7_MASK               128


/*** LCDPEN1 - LCD Pin Enable Register 1; 0x00001081 ***/
typedef union {
  byte Byte;
  struct {
    byte PEN8        :1;                                       /* Enable LCD pin 8 for LCD operation */
    byte PEN9        :1;                                       /* Enable LCD pin 9 for LCD operation */
    byte PEN10       :1;                                       /* Enable LCD pin 10 for LCD operation */
    byte PEN11       :1;                                       /* Enable LCD pin 11 for LCD operation */
    byte PEN12       :1;                                       /* Enable LCD pin 12 for LCD operation */
    byte PEN13       :1;                                       /* Enable LCD pin 13 for LCD operation */
    byte PEN14       :1;                                       /* Enable LCD pin 14 for LCD operation */
    byte PEN15       :1;                                       /* Enable LCD pin 15 for LCD operation */
  } Bits;
} LCDPEN1STR;
extern volatile LCDPEN1STR _LCDPEN1 @0x00001081;
#define LCDPEN1                         _LCDPEN1.Byte
#define LCDPEN1_PEN8                    _LCDPEN1.Bits.PEN8
#define LCDPEN1_PEN9                    _LCDPEN1.Bits.PEN9
#define LCDPEN1_PEN10                   _LCDPEN1.Bits.PEN10
#define LCDPEN1_PEN11                   _LCDPEN1.Bits.PEN11
#define LCDPEN1_PEN12                   _LCDPEN1.Bits.PEN12
#define LCDPEN1_PEN13                   _LCDPEN1.Bits.PEN13
#define LCDPEN1_PEN14                   _LCDPEN1.Bits.PEN14
#define LCDPEN1_PEN15                   _LCDPEN1.Bits.PEN15

#define LCDPEN1_PEN8_MASK               1
#define LCDPEN1_PEN9_MASK               2
#define LCDPEN1_PEN10_MASK              4
#define LCDPEN1_PEN11_MASK              8
#define LCDPEN1_PEN12_MASK              16
#define LCDPEN1_PEN13_MASK              32
#define LCDPEN1_PEN14_MASK              64
#define LCDPEN1_PEN15_MASK              128


/*** LCDPEN2 - LCD Pin Enable Register 2; 0x00001082 ***/
typedef union {
  byte Byte;
  struct {
    byte PEN16       :1;                                       /* Enable LCD pin 16 for LCD operation */
    byte PEN17       :1;                                       /* Enable LCD pin 17 for LCD operation */
    byte PEN18       :1;                                       /* Enable LCD pin 18 for LCD operation */
    byte PEN19       :1;                                       /* Enable LCD pin 19 for LCD operation */
    byte PEN20       :1;                                       /* Enable LCD pin 20 for LCD operation */
    byte PEN21       :1;                                       /* Enable LCD pin 21 for LCD operation */
    byte PEN22       :1;                                       /* Enable LCD pin 22 for LCD operation */
    byte PEN23       :1;                                       /* Enable LCD pin 23 for LCD operation */
  } Bits;
} LCDPEN2STR;
extern volatile LCDPEN2STR _LCDPEN2 @0x00001082;
#define LCDPEN2                         _LCDPEN2.Byte
#define LCDPEN2_PEN16                   _LCDPEN2.Bits.PEN16
#define LCDPEN2_PEN17                   _LCDPEN2.Bits.PEN17
#define LCDPEN2_PEN18                   _LCDPEN2.Bits.PEN18
#define LCDPEN2_PEN19                   _LCDPEN2.Bits.PEN19
#define LCDPEN2_PEN20                   _LCDPEN2.Bits.PEN20
#define LCDPEN2_PEN21                   _LCDPEN2.Bits.PEN21
#define LCDPEN2_PEN22                   _LCDPEN2.Bits.PEN22
#define LCDPEN2_PEN23                   _LCDPEN2.Bits.PEN23

#define LCDPEN2_PEN16_MASK              1
#define LCDPEN2_PEN17_MASK              2
#define LCDPEN2_PEN18_MASK              4
#define LCDPEN2_PEN19_MASK              8
#define LCDPEN2_PEN20_MASK              16
#define LCDPEN2_PEN21_MASK              32
#define LCDPEN2_PEN22_MASK              64
#define LCDPEN2_PEN23_MASK              128


/*** LCDPEN3 - LCD Pin Enable Register 3; 0x00001083 ***/
typedef union {
  byte Byte;
  struct {
    byte PEN24       :1;                                       /* Enable LCD pin 24 for LCD operation */
    byte PEN25       :1;                                       /* Enable LCD pin 25 for LCD operation */
    byte PEN26       :1;                                       /* Enable LCD pin 26 for LCD operation */
    byte PEN27       :1;                                       /* Enable LCD pin 27 for LCD operation */
    byte PEN28       :1;                                       /* Enable LCD pin 28 for LCD operation */
    byte PEN29       :1;                                       /* Enable LCD pin 29 for LCD operation */
    byte PEN30       :1;                                       /* Enable LCD pin 30 for LCD operation */
    byte PEN31       :1;                                       /* Enable LCD pin 31 for LCD operation */
  } Bits;
} LCDPEN3STR;
extern volatile LCDPEN3STR _LCDPEN3 @0x00001083;
#define LCDPEN3                         _LCDPEN3.Byte
#define LCDPEN3_PEN24                   _LCDPEN3.Bits.PEN24
#define LCDPEN3_PEN25                   _LCDPEN3.Bits.PEN25
#define LCDPEN3_PEN26                   _LCDPEN3.Bits.PEN26
#define LCDPEN3_PEN27                   _LCDPEN3.Bits.PEN27
#define LCDPEN3_PEN28                   _LCDPEN3.Bits.PEN28
#define LCDPEN3_PEN29                   _LCDPEN3.Bits.PEN29
#define LCDPEN3_PEN30                   _LCDPEN3.Bits.PEN30
#define LCDPEN3_PEN31                   _LCDPEN3.Bits.PEN31

#define LCDPEN3_PEN24_MASK              1
#define LCDPEN3_PEN25_MASK              2
#define LCDPEN3_PEN26_MASK              4
#define LCDPEN3_PEN27_MASK              8
#define LCDPEN3_PEN28_MASK              16
#define LCDPEN3_PEN29_MASK              32
#define LCDPEN3_PEN30_MASK              64
#define LCDPEN3_PEN31_MASK              128


/*** LCDPEN4 - LCD Pin Enable Register 4; 0x00001084 ***/
typedef union {
  byte Byte;
  struct {
    byte PEN32       :1;                                       /* Enable LCD pin 32 for LCD operation */
    byte PEN33       :1;                                       /* Enable LCD pin 33 for LCD operation */
    byte PEN34       :1;                                       /* Enable LCD pin 34 for LCD operation */
    byte PEN35       :1;                                       /* Enable LCD pin 35 for LCD operation */
    byte PEN36       :1;                                       /* Enable LCD pin 36 for LCD operation */
    byte PEN37       :1;                                       /* Enable LCD pin 37 for LCD operation */
    byte PEN38       :1;                                       /* Enable LCD pin 38 for LCD operation */
    byte PEN39       :1;                                       /* Enable LCD pin 39 for LCD operation */
  } Bits;
} LCDPEN4STR;
extern volatile LCDPEN4STR _LCDPEN4 @0x00001084;
#define LCDPEN4                         _LCDPEN4.Byte
#define LCDPEN4_PEN32                   _LCDPEN4.Bits.PEN32
#define LCDPEN4_PEN33                   _LCDPEN4.Bits.PEN33
#define LCDPEN4_PEN34                   _LCDPEN4.Bits.PEN34
#define LCDPEN4_PEN35                   _LCDPEN4.Bits.PEN35
#define LCDPEN4_PEN36                   _LCDPEN4.Bits.PEN36
#define LCDPEN4_PEN37                   _LCDPEN4.Bits.PEN37
#define LCDPEN4_PEN38                   _LCDPEN4.Bits.PEN38
#define LCDPEN4_PEN39                   _LCDPEN4.Bits.PEN39

#define LCDPEN4_PEN32_MASK              1
#define LCDPEN4_PEN33_MASK              2
#define LCDPEN4_PEN34_MASK              4
#define LCDPEN4_PEN35_MASK              8
#define LCDPEN4_PEN36_MASK              16
#define LCDPEN4_PEN37_MASK              32
#define LCDPEN4_PEN38_MASK              64
#define LCDPEN4_PEN39_MASK              128


/*** LCDPEN5 - LCD Pin Enable Register 5; 0x00001085 ***/
typedef union {
  byte Byte;
  struct {
    byte PEN40       :1;                                       /* Enable LCD pin 40 for LCD operation */
    byte PEN41       :1;                                       /* Enable LCD pin 41 for LCD operation */
    byte PEN42       :1;                                       /* Enable LCD pin 42 for LCD operation */
    byte PEN43       :1;                                       /* Enable LCD pin 43 for LCD operation */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPEN_40 :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} LCDPEN5STR;
extern volatile LCDPEN5STR _LCDPEN5 @0x00001085;
#define LCDPEN5                         _LCDPEN5.Byte
#define LCDPEN5_PEN40                   _LCDPEN5.Bits.PEN40
#define LCDPEN5_PEN41                   _LCDPEN5.Bits.PEN41
#define LCDPEN5_PEN42                   _LCDPEN5.Bits.PEN42
#define LCDPEN5_PEN43                   _LCDPEN5.Bits.PEN43
#define LCDPEN5_PEN_40                  _LCDPEN5.MergedBits.grpPEN_40
#define LCDPEN5_PEN                     LCDPEN5_PEN_40

#define LCDPEN5_PEN40_MASK              1
#define LCDPEN5_PEN41_MASK              2
#define LCDPEN5_PEN42_MASK              4
#define LCDPEN5_PEN43_MASK              8
#define LCDPEN5_PEN_40_MASK             15
#define LCDPEN5_PEN_40_BITNUM           0


/*** LCDBPEN0 - LCD Backplane Enable Register 0; 0x00001088 ***/
typedef union {
  byte Byte;
  struct {
    byte BPEN0       :1;                                       /* Enable LCD pin 0 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN1       :1;                                       /* Enable LCD pin 1 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN2       :1;                                       /* Enable LCD pin 2 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN3       :1;                                       /* Enable LCD pin 3 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN4       :1;                                       /* Enable LCD pin 4 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN5       :1;                                       /* Enable LCD pin 5 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN6       :1;                                       /* Enable LCD pin 6 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN7       :1;                                       /* Enable LCD pin 7 to operate as an LCD backplane or an LCD frontplane */
  } Bits;
} LCDBPEN0STR;
extern volatile LCDBPEN0STR _LCDBPEN0 @0x00001088;
#define LCDBPEN0                        _LCDBPEN0.Byte
#define LCDBPEN0_BPEN0                  _LCDBPEN0.Bits.BPEN0
#define LCDBPEN0_BPEN1                  _LCDBPEN0.Bits.BPEN1
#define LCDBPEN0_BPEN2                  _LCDBPEN0.Bits.BPEN2
#define LCDBPEN0_BPEN3                  _LCDBPEN0.Bits.BPEN3
#define LCDBPEN0_BPEN4                  _LCDBPEN0.Bits.BPEN4
#define LCDBPEN0_BPEN5                  _LCDBPEN0.Bits.BPEN5
#define LCDBPEN0_BPEN6                  _LCDBPEN0.Bits.BPEN6
#define LCDBPEN0_BPEN7                  _LCDBPEN0.Bits.BPEN7
/* LCDBPEN_ARR: Access 6 LCDBPENx registers in an array */
#define LCDBPEN_ARR                     ((volatile byte * __far) &LCDBPEN0)

#define LCDBPEN0_BPEN0_MASK             1
#define LCDBPEN0_BPEN1_MASK             2
#define LCDBPEN0_BPEN2_MASK             4
#define LCDBPEN0_BPEN3_MASK             8
#define LCDBPEN0_BPEN4_MASK             16
#define LCDBPEN0_BPEN5_MASK             32
#define LCDBPEN0_BPEN6_MASK             64
#define LCDBPEN0_BPEN7_MASK             128


/*** LCDBPEN1 - LCD Backplane Enable Register 1; 0x00001089 ***/
typedef union {
  byte Byte;
  struct {
    byte BPEN8       :1;                                       /* Enable LCD pin 8 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN9       :1;                                       /* Enable LCD pin 9 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN10      :1;                                       /* Enable LCD pin 10 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN11      :1;                                       /* Enable LCD pin 11 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN12      :1;                                       /* Enable LCD pin 12 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN13      :1;                                       /* Enable LCD pin 13 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN14      :1;                                       /* Enable LCD pin 14 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN15      :1;                                       /* Enable LCD pin 15 to operate as an LCD backplane or an LCD frontplane */
  } Bits;
} LCDBPEN1STR;
extern volatile LCDBPEN1STR _LCDBPEN1 @0x00001089;
#define LCDBPEN1                        _LCDBPEN1.Byte
#define LCDBPEN1_BPEN8                  _LCDBPEN1.Bits.BPEN8
#define LCDBPEN1_BPEN9                  _LCDBPEN1.Bits.BPEN9
#define LCDBPEN1_BPEN10                 _LCDBPEN1.Bits.BPEN10
#define LCDBPEN1_BPEN11                 _LCDBPEN1.Bits.BPEN11
#define LCDBPEN1_BPEN12                 _LCDBPEN1.Bits.BPEN12
#define LCDBPEN1_BPEN13                 _LCDBPEN1.Bits.BPEN13
#define LCDBPEN1_BPEN14                 _LCDBPEN1.Bits.BPEN14
#define LCDBPEN1_BPEN15                 _LCDBPEN1.Bits.BPEN15

#define LCDBPEN1_BPEN8_MASK             1
#define LCDBPEN1_BPEN9_MASK             2
#define LCDBPEN1_BPEN10_MASK            4
#define LCDBPEN1_BPEN11_MASK            8
#define LCDBPEN1_BPEN12_MASK            16
#define LCDBPEN1_BPEN13_MASK            32
#define LCDBPEN1_BPEN14_MASK            64
#define LCDBPEN1_BPEN15_MASK            128


/*** LCDBPEN2 - LCD Backplane Enable Register 2; 0x0000108A ***/
typedef union {
  byte Byte;
  struct {
    byte BPEN16      :1;                                       /* Enable LCD pin 16 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN17      :1;                                       /* Enable LCD pin 17 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN18      :1;                                       /* Enable LCD pin 18 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN19      :1;                                       /* Enable LCD pin 19 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN20      :1;                                       /* Enable LCD pin 20 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN21      :1;                                       /* Enable LCD pin 21 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN22      :1;                                       /* Enable LCD pin 22 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN23      :1;                                       /* Enable LCD pin 23 to operate as an LCD backplane or an LCD frontplane */
  } Bits;
} LCDBPEN2STR;
extern volatile LCDBPEN2STR _LCDBPEN2 @0x0000108A;
#define LCDBPEN2                        _LCDBPEN2.Byte
#define LCDBPEN2_BPEN16                 _LCDBPEN2.Bits.BPEN16
#define LCDBPEN2_BPEN17                 _LCDBPEN2.Bits.BPEN17
#define LCDBPEN2_BPEN18                 _LCDBPEN2.Bits.BPEN18
#define LCDBPEN2_BPEN19                 _LCDBPEN2.Bits.BPEN19
#define LCDBPEN2_BPEN20                 _LCDBPEN2.Bits.BPEN20
#define LCDBPEN2_BPEN21                 _LCDBPEN2.Bits.BPEN21
#define LCDBPEN2_BPEN22                 _LCDBPEN2.Bits.BPEN22
#define LCDBPEN2_BPEN23                 _LCDBPEN2.Bits.BPEN23

#define LCDBPEN2_BPEN16_MASK            1
#define LCDBPEN2_BPEN17_MASK            2
#define LCDBPEN2_BPEN18_MASK            4
#define LCDBPEN2_BPEN19_MASK            8
#define LCDBPEN2_BPEN20_MASK            16
#define LCDBPEN2_BPEN21_MASK            32
#define LCDBPEN2_BPEN22_MASK            64
#define LCDBPEN2_BPEN23_MASK            128


/*** LCDBPEN3 - LCD Backplane Enable Register 3; 0x0000108B ***/
typedef union {
  byte Byte;
  struct {
    byte BPEN24      :1;                                       /* Enable LCD pin 24 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN25      :1;                                       /* Enable LCD pin 25 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN26      :1;                                       /* Enable LCD pin 26 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN27      :1;                                       /* Enable LCD pin 27 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN28      :1;                                       /* Enable LCD pin 28 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN29      :1;                                       /* Enable LCD pin 29 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN30      :1;                                       /* Enable LCD pin 30 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN31      :1;                                       /* Enable LCD pin 31 to operate as an LCD backplane or an LCD frontplane */
  } Bits;
} LCDBPEN3STR;
extern volatile LCDBPEN3STR _LCDBPEN3 @0x0000108B;
#define LCDBPEN3                        _LCDBPEN3.Byte
#define LCDBPEN3_BPEN24                 _LCDBPEN3.Bits.BPEN24
#define LCDBPEN3_BPEN25                 _LCDBPEN3.Bits.BPEN25
#define LCDBPEN3_BPEN26                 _LCDBPEN3.Bits.BPEN26
#define LCDBPEN3_BPEN27                 _LCDBPEN3.Bits.BPEN27
#define LCDBPEN3_BPEN28                 _LCDBPEN3.Bits.BPEN28
#define LCDBPEN3_BPEN29                 _LCDBPEN3.Bits.BPEN29
#define LCDBPEN3_BPEN30                 _LCDBPEN3.Bits.BPEN30
#define LCDBPEN3_BPEN31                 _LCDBPEN3.Bits.BPEN31

#define LCDBPEN3_BPEN24_MASK            1
#define LCDBPEN3_BPEN25_MASK            2
#define LCDBPEN3_BPEN26_MASK            4
#define LCDBPEN3_BPEN27_MASK            8
#define LCDBPEN3_BPEN28_MASK            16
#define LCDBPEN3_BPEN29_MASK            32
#define LCDBPEN3_BPEN30_MASK            64
#define LCDBPEN3_BPEN31_MASK            128


/*** LCDBPEN4 - LCD Backplane Enable Register 4; 0x0000108C ***/
typedef union {
  byte Byte;
  struct {
    byte BPEN32      :1;                                       /* Enable LCD pin 32 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN33      :1;                                       /* Enable LCD pin 33 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN34      :1;                                       /* Enable LCD pin 34 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN35      :1;                                       /* Enable LCD pin 35 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN36      :1;                                       /* Enable LCD pin 36 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN37      :1;                                       /* Enable LCD pin 37 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN38      :1;                                       /* Enable LCD pin 38 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN39      :1;                                       /* Enable LCD pin 39 to operate as an LCD backplane or an LCD frontplane */
  } Bits;
} LCDBPEN4STR;
extern volatile LCDBPEN4STR _LCDBPEN4 @0x0000108C;
#define LCDBPEN4                        _LCDBPEN4.Byte
#define LCDBPEN4_BPEN32                 _LCDBPEN4.Bits.BPEN32
#define LCDBPEN4_BPEN33                 _LCDBPEN4.Bits.BPEN33
#define LCDBPEN4_BPEN34                 _LCDBPEN4.Bits.BPEN34
#define LCDBPEN4_BPEN35                 _LCDBPEN4.Bits.BPEN35
#define LCDBPEN4_BPEN36                 _LCDBPEN4.Bits.BPEN36
#define LCDBPEN4_BPEN37                 _LCDBPEN4.Bits.BPEN37
#define LCDBPEN4_BPEN38                 _LCDBPEN4.Bits.BPEN38
#define LCDBPEN4_BPEN39                 _LCDBPEN4.Bits.BPEN39

#define LCDBPEN4_BPEN32_MASK            1
#define LCDBPEN4_BPEN33_MASK            2
#define LCDBPEN4_BPEN34_MASK            4
#define LCDBPEN4_BPEN35_MASK            8
#define LCDBPEN4_BPEN36_MASK            16
#define LCDBPEN4_BPEN37_MASK            32
#define LCDBPEN4_BPEN38_MASK            64
#define LCDBPEN4_BPEN39_MASK            128


/*** LCDBPEN5 - LCD Backplane Enable Register 5; 0x0000108D ***/
typedef union {
  byte Byte;
  struct {
    byte BPEN40      :1;                                       /* Enable LCD pin 40 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN41      :1;                                       /* Enable LCD pin 41 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN42      :1;                                       /* Enable LCD pin 42 to operate as an LCD backplane or an LCD frontplane */
    byte BPEN43      :1;                                       /* Enable LCD pin 43 to operate as an LCD backplane or an LCD frontplane */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpBPEN_40 :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} LCDBPEN5STR;
extern volatile LCDBPEN5STR _LCDBPEN5 @0x0000108D;
#define LCDBPEN5                        _LCDBPEN5.Byte
#define LCDBPEN5_BPEN40                 _LCDBPEN5.Bits.BPEN40
#define LCDBPEN5_BPEN41                 _LCDBPEN5.Bits.BPEN41
#define LCDBPEN5_BPEN42                 _LCDBPEN5.Bits.BPEN42
#define LCDBPEN5_BPEN43                 _LCDBPEN5.Bits.BPEN43
#define LCDBPEN5_BPEN_40                _LCDBPEN5.MergedBits.grpBPEN_40
#define LCDBPEN5_BPEN                   LCDBPEN5_BPEN_40

#define LCDBPEN5_BPEN40_MASK            1
#define LCDBPEN5_BPEN41_MASK            2
#define LCDBPEN5_BPEN42_MASK            4
#define LCDBPEN5_BPEN43_MASK            8
#define LCDBPEN5_BPEN_40_MASK           15
#define LCDBPEN5_BPEN_40_BITNUM         0


/*** LCDWF0 - LCD Waveform Register 0; 0x00001090 ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD0     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD0     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD0     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD0     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD0     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD0     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD0     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD0     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF0STR;
extern volatile LCDWF0STR _LCDWF0 @0x00001090;
#define LCDWF0                          _LCDWF0.Byte
#define LCDWF0_BPALCD0                  _LCDWF0.Bits.BPALCD0
#define LCDWF0_BPBLCD0                  _LCDWF0.Bits.BPBLCD0
#define LCDWF0_BPCLCD0                  _LCDWF0.Bits.BPCLCD0
#define LCDWF0_BPDLCD0                  _LCDWF0.Bits.BPDLCD0
#define LCDWF0_BPELCD0                  _LCDWF0.Bits.BPELCD0
#define LCDWF0_BPFLCD0                  _LCDWF0.Bits.BPFLCD0
#define LCDWF0_BPGLCD0                  _LCDWF0.Bits.BPGLCD0
#define LCDWF0_BPHLCD0                  _LCDWF0.Bits.BPHLCD0
/* LCDWF_ARR: Access 44 LCDWFx registers in an array */
#define LCDWF_ARR                       ((volatile byte * __far) &LCDWF0)

#define LCDWF0_BPALCD0_MASK             1
#define LCDWF0_BPBLCD0_MASK             2
#define LCDWF0_BPCLCD0_MASK             4
#define LCDWF0_BPDLCD0_MASK             8
#define LCDWF0_BPELCD0_MASK             16
#define LCDWF0_BPFLCD0_MASK             32
#define LCDWF0_BPGLCD0_MASK             64
#define LCDWF0_BPHLCD0_MASK             128


/*** LCDWF1 - LCD Waveform Register 1; 0x00001091 ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD1     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD1     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD1     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD1     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD1     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD1     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD1     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD1     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF1STR;
extern volatile LCDWF1STR _LCDWF1 @0x00001091;
#define LCDWF1                          _LCDWF1.Byte
#define LCDWF1_BPALCD1                  _LCDWF1.Bits.BPALCD1
#define LCDWF1_BPBLCD1                  _LCDWF1.Bits.BPBLCD1
#define LCDWF1_BPCLCD1                  _LCDWF1.Bits.BPCLCD1
#define LCDWF1_BPDLCD1                  _LCDWF1.Bits.BPDLCD1
#define LCDWF1_BPELCD1                  _LCDWF1.Bits.BPELCD1
#define LCDWF1_BPFLCD1                  _LCDWF1.Bits.BPFLCD1
#define LCDWF1_BPGLCD1                  _LCDWF1.Bits.BPGLCD1
#define LCDWF1_BPHLCD1                  _LCDWF1.Bits.BPHLCD1

#define LCDWF1_BPALCD1_MASK             1
#define LCDWF1_BPBLCD1_MASK             2
#define LCDWF1_BPCLCD1_MASK             4
#define LCDWF1_BPDLCD1_MASK             8
#define LCDWF1_BPELCD1_MASK             16
#define LCDWF1_BPFLCD1_MASK             32
#define LCDWF1_BPGLCD1_MASK             64
#define LCDWF1_BPHLCD1_MASK             128


/*** LCDWF2 - LCD Waveform Register 2; 0x00001092 ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD2     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD2     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD2     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD2     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD2     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD2     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD2     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD2     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF2STR;
extern volatile LCDWF2STR _LCDWF2 @0x00001092;
#define LCDWF2                          _LCDWF2.Byte
#define LCDWF2_BPALCD2                  _LCDWF2.Bits.BPALCD2
#define LCDWF2_BPBLCD2                  _LCDWF2.Bits.BPBLCD2
#define LCDWF2_BPCLCD2                  _LCDWF2.Bits.BPCLCD2
#define LCDWF2_BPDLCD2                  _LCDWF2.Bits.BPDLCD2
#define LCDWF2_BPELCD2                  _LCDWF2.Bits.BPELCD2
#define LCDWF2_BPFLCD2                  _LCDWF2.Bits.BPFLCD2
#define LCDWF2_BPGLCD2                  _LCDWF2.Bits.BPGLCD2
#define LCDWF2_BPHLCD2                  _LCDWF2.Bits.BPHLCD2

#define LCDWF2_BPALCD2_MASK             1
#define LCDWF2_BPBLCD2_MASK             2
#define LCDWF2_BPCLCD2_MASK             4
#define LCDWF2_BPDLCD2_MASK             8
#define LCDWF2_BPELCD2_MASK             16
#define LCDWF2_BPFLCD2_MASK             32
#define LCDWF2_BPGLCD2_MASK             64
#define LCDWF2_BPHLCD2_MASK             128


/*** LCDWF3 - LCD Waveform Register 3; 0x00001093 ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD3     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD3     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD3     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD3     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD3     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD3     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD3     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD3     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF3STR;
extern volatile LCDWF3STR _LCDWF3 @0x00001093;
#define LCDWF3                          _LCDWF3.Byte
#define LCDWF3_BPALCD3                  _LCDWF3.Bits.BPALCD3
#define LCDWF3_BPBLCD3                  _LCDWF3.Bits.BPBLCD3
#define LCDWF3_BPCLCD3                  _LCDWF3.Bits.BPCLCD3
#define LCDWF3_BPDLCD3                  _LCDWF3.Bits.BPDLCD3
#define LCDWF3_BPELCD3                  _LCDWF3.Bits.BPELCD3
#define LCDWF3_BPFLCD3                  _LCDWF3.Bits.BPFLCD3
#define LCDWF3_BPGLCD3                  _LCDWF3.Bits.BPGLCD3
#define LCDWF3_BPHLCD3                  _LCDWF3.Bits.BPHLCD3

#define LCDWF3_BPALCD3_MASK             1
#define LCDWF3_BPBLCD3_MASK             2
#define LCDWF3_BPCLCD3_MASK             4
#define LCDWF3_BPDLCD3_MASK             8
#define LCDWF3_BPELCD3_MASK             16
#define LCDWF3_BPFLCD3_MASK             32
#define LCDWF3_BPGLCD3_MASK             64
#define LCDWF3_BPHLCD3_MASK             128


/*** LCDWF4 - LCD Waveform Register 4; 0x00001094 ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD4     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD4     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD4     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD4     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD4     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD4     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD4     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD4     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF4STR;
extern volatile LCDWF4STR _LCDWF4 @0x00001094;
#define LCDWF4                          _LCDWF4.Byte
#define LCDWF4_BPALCD4                  _LCDWF4.Bits.BPALCD4
#define LCDWF4_BPBLCD4                  _LCDWF4.Bits.BPBLCD4
#define LCDWF4_BPCLCD4                  _LCDWF4.Bits.BPCLCD4
#define LCDWF4_BPDLCD4                  _LCDWF4.Bits.BPDLCD4
#define LCDWF4_BPELCD4                  _LCDWF4.Bits.BPELCD4
#define LCDWF4_BPFLCD4                  _LCDWF4.Bits.BPFLCD4
#define LCDWF4_BPGLCD4                  _LCDWF4.Bits.BPGLCD4
#define LCDWF4_BPHLCD4                  _LCDWF4.Bits.BPHLCD4

#define LCDWF4_BPALCD4_MASK             1
#define LCDWF4_BPBLCD4_MASK             2
#define LCDWF4_BPCLCD4_MASK             4
#define LCDWF4_BPDLCD4_MASK             8
#define LCDWF4_BPELCD4_MASK             16
#define LCDWF4_BPFLCD4_MASK             32
#define LCDWF4_BPGLCD4_MASK             64
#define LCDWF4_BPHLCD4_MASK             128


/*** LCDWF5 - LCD Waveform Register 5; 0x00001095 ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD5     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD5     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD5     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD5     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD5     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD5     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD5     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD5     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF5STR;
extern volatile LCDWF5STR _LCDWF5 @0x00001095;
#define LCDWF5                          _LCDWF5.Byte
#define LCDWF5_BPALCD5                  _LCDWF5.Bits.BPALCD5
#define LCDWF5_BPBLCD5                  _LCDWF5.Bits.BPBLCD5
#define LCDWF5_BPCLCD5                  _LCDWF5.Bits.BPCLCD5
#define LCDWF5_BPDLCD5                  _LCDWF5.Bits.BPDLCD5
#define LCDWF5_BPELCD5                  _LCDWF5.Bits.BPELCD5
#define LCDWF5_BPFLCD5                  _LCDWF5.Bits.BPFLCD5
#define LCDWF5_BPGLCD5                  _LCDWF5.Bits.BPGLCD5
#define LCDWF5_BPHLCD5                  _LCDWF5.Bits.BPHLCD5

#define LCDWF5_BPALCD5_MASK             1
#define LCDWF5_BPBLCD5_MASK             2
#define LCDWF5_BPCLCD5_MASK             4
#define LCDWF5_BPDLCD5_MASK             8
#define LCDWF5_BPELCD5_MASK             16
#define LCDWF5_BPFLCD5_MASK             32
#define LCDWF5_BPGLCD5_MASK             64
#define LCDWF5_BPHLCD5_MASK             128


/*** LCDWF6 - LCD Waveform Register 6; 0x00001096 ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD6     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD6     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD6     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD6     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD6     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD6     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD6     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD6     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF6STR;
extern volatile LCDWF6STR _LCDWF6 @0x00001096;
#define LCDWF6                          _LCDWF6.Byte
#define LCDWF6_BPALCD6                  _LCDWF6.Bits.BPALCD6
#define LCDWF6_BPBLCD6                  _LCDWF6.Bits.BPBLCD6
#define LCDWF6_BPCLCD6                  _LCDWF6.Bits.BPCLCD6
#define LCDWF6_BPDLCD6                  _LCDWF6.Bits.BPDLCD6
#define LCDWF6_BPELCD6                  _LCDWF6.Bits.BPELCD6
#define LCDWF6_BPFLCD6                  _LCDWF6.Bits.BPFLCD6
#define LCDWF6_BPGLCD6                  _LCDWF6.Bits.BPGLCD6
#define LCDWF6_BPHLCD6                  _LCDWF6.Bits.BPHLCD6

#define LCDWF6_BPALCD6_MASK             1
#define LCDWF6_BPBLCD6_MASK             2
#define LCDWF6_BPCLCD6_MASK             4
#define LCDWF6_BPDLCD6_MASK             8
#define LCDWF6_BPELCD6_MASK             16
#define LCDWF6_BPFLCD6_MASK             32
#define LCDWF6_BPGLCD6_MASK             64
#define LCDWF6_BPHLCD6_MASK             128


/*** LCDWF7 - LCD Waveform Register 7; 0x00001097 ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD7     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD7     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD7     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD7     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD7     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD7     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD7     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD7     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF7STR;
extern volatile LCDWF7STR _LCDWF7 @0x00001097;
#define LCDWF7                          _LCDWF7.Byte
#define LCDWF7_BPALCD7                  _LCDWF7.Bits.BPALCD7
#define LCDWF7_BPBLCD7                  _LCDWF7.Bits.BPBLCD7
#define LCDWF7_BPCLCD7                  _LCDWF7.Bits.BPCLCD7
#define LCDWF7_BPDLCD7                  _LCDWF7.Bits.BPDLCD7
#define LCDWF7_BPELCD7                  _LCDWF7.Bits.BPELCD7
#define LCDWF7_BPFLCD7                  _LCDWF7.Bits.BPFLCD7
#define LCDWF7_BPGLCD7                  _LCDWF7.Bits.BPGLCD7
#define LCDWF7_BPHLCD7                  _LCDWF7.Bits.BPHLCD7

#define LCDWF7_BPALCD7_MASK             1
#define LCDWF7_BPBLCD7_MASK             2
#define LCDWF7_BPCLCD7_MASK             4
#define LCDWF7_BPDLCD7_MASK             8
#define LCDWF7_BPELCD7_MASK             16
#define LCDWF7_BPFLCD7_MASK             32
#define LCDWF7_BPGLCD7_MASK             64
#define LCDWF7_BPHLCD7_MASK             128


/*** LCDWF8 - LCD Waveform Register 8; 0x00001098 ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD8     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD8     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD8     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD8     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD8     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD8     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD8     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD8     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF8STR;
extern volatile LCDWF8STR _LCDWF8 @0x00001098;
#define LCDWF8                          _LCDWF8.Byte
#define LCDWF8_BPALCD8                  _LCDWF8.Bits.BPALCD8
#define LCDWF8_BPBLCD8                  _LCDWF8.Bits.BPBLCD8
#define LCDWF8_BPCLCD8                  _LCDWF8.Bits.BPCLCD8
#define LCDWF8_BPDLCD8                  _LCDWF8.Bits.BPDLCD8
#define LCDWF8_BPELCD8                  _LCDWF8.Bits.BPELCD8
#define LCDWF8_BPFLCD8                  _LCDWF8.Bits.BPFLCD8
#define LCDWF8_BPGLCD8                  _LCDWF8.Bits.BPGLCD8
#define LCDWF8_BPHLCD8                  _LCDWF8.Bits.BPHLCD8

#define LCDWF8_BPALCD8_MASK             1
#define LCDWF8_BPBLCD8_MASK             2
#define LCDWF8_BPCLCD8_MASK             4
#define LCDWF8_BPDLCD8_MASK             8
#define LCDWF8_BPELCD8_MASK             16
#define LCDWF8_BPFLCD8_MASK             32
#define LCDWF8_BPGLCD8_MASK             64
#define LCDWF8_BPHLCD8_MASK             128


/*** LCDWF9 - LCD Waveform Register 9; 0x00001099 ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD9     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD9     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD9     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD9     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD9     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD9     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD9     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD9     :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF9STR;
extern volatile LCDWF9STR _LCDWF9 @0x00001099;
#define LCDWF9                          _LCDWF9.Byte
#define LCDWF9_BPALCD9                  _LCDWF9.Bits.BPALCD9
#define LCDWF9_BPBLCD9                  _LCDWF9.Bits.BPBLCD9
#define LCDWF9_BPCLCD9                  _LCDWF9.Bits.BPCLCD9
#define LCDWF9_BPDLCD9                  _LCDWF9.Bits.BPDLCD9
#define LCDWF9_BPELCD9                  _LCDWF9.Bits.BPELCD9
#define LCDWF9_BPFLCD9                  _LCDWF9.Bits.BPFLCD9
#define LCDWF9_BPGLCD9                  _LCDWF9.Bits.BPGLCD9
#define LCDWF9_BPHLCD9                  _LCDWF9.Bits.BPHLCD9

#define LCDWF9_BPALCD9_MASK             1
#define LCDWF9_BPBLCD9_MASK             2
#define LCDWF9_BPCLCD9_MASK             4
#define LCDWF9_BPDLCD9_MASK             8
#define LCDWF9_BPELCD9_MASK             16
#define LCDWF9_BPFLCD9_MASK             32
#define LCDWF9_BPGLCD9_MASK             64
#define LCDWF9_BPHLCD9_MASK             128


/*** LCDWF10 - LCD Waveform Register 10; 0x0000109A ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD10    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD10    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD10    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD10    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD10    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD10    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD10    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD10    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF10STR;
extern volatile LCDWF10STR _LCDWF10 @0x0000109A;
#define LCDWF10                         _LCDWF10.Byte
#define LCDWF10_BPALCD10                _LCDWF10.Bits.BPALCD10
#define LCDWF10_BPBLCD10                _LCDWF10.Bits.BPBLCD10
#define LCDWF10_BPCLCD10                _LCDWF10.Bits.BPCLCD10
#define LCDWF10_BPDLCD10                _LCDWF10.Bits.BPDLCD10
#define LCDWF10_BPELCD10                _LCDWF10.Bits.BPELCD10
#define LCDWF10_BPFLCD10                _LCDWF10.Bits.BPFLCD10
#define LCDWF10_BPGLCD10                _LCDWF10.Bits.BPGLCD10
#define LCDWF10_BPHLCD10                _LCDWF10.Bits.BPHLCD10

#define LCDWF10_BPALCD10_MASK           1
#define LCDWF10_BPBLCD10_MASK           2
#define LCDWF10_BPCLCD10_MASK           4
#define LCDWF10_BPDLCD10_MASK           8
#define LCDWF10_BPELCD10_MASK           16
#define LCDWF10_BPFLCD10_MASK           32
#define LCDWF10_BPGLCD10_MASK           64
#define LCDWF10_BPHLCD10_MASK           128


/*** LCDWF11 - LCD Waveform Register 11; 0x0000109B ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD11    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD11    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD11    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD11    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD11    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD11    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD11    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD11    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF11STR;
extern volatile LCDWF11STR _LCDWF11 @0x0000109B;
#define LCDWF11                         _LCDWF11.Byte
#define LCDWF11_BPALCD11                _LCDWF11.Bits.BPALCD11
#define LCDWF11_BPBLCD11                _LCDWF11.Bits.BPBLCD11
#define LCDWF11_BPCLCD11                _LCDWF11.Bits.BPCLCD11
#define LCDWF11_BPDLCD11                _LCDWF11.Bits.BPDLCD11
#define LCDWF11_BPELCD11                _LCDWF11.Bits.BPELCD11
#define LCDWF11_BPFLCD11                _LCDWF11.Bits.BPFLCD11
#define LCDWF11_BPGLCD11                _LCDWF11.Bits.BPGLCD11
#define LCDWF11_BPHLCD11                _LCDWF11.Bits.BPHLCD11

#define LCDWF11_BPALCD11_MASK           1
#define LCDWF11_BPBLCD11_MASK           2
#define LCDWF11_BPCLCD11_MASK           4
#define LCDWF11_BPDLCD11_MASK           8
#define LCDWF11_BPELCD11_MASK           16
#define LCDWF11_BPFLCD11_MASK           32
#define LCDWF11_BPGLCD11_MASK           64
#define LCDWF11_BPHLCD11_MASK           128


/*** LCDWF12 - LCD Waveform Register 12; 0x0000109C ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD12    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD12    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD12    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD12    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD12    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD12    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD12    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD12    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF12STR;
extern volatile LCDWF12STR _LCDWF12 @0x0000109C;
#define LCDWF12                         _LCDWF12.Byte
#define LCDWF12_BPALCD12                _LCDWF12.Bits.BPALCD12
#define LCDWF12_BPBLCD12                _LCDWF12.Bits.BPBLCD12
#define LCDWF12_BPCLCD12                _LCDWF12.Bits.BPCLCD12
#define LCDWF12_BPDLCD12                _LCDWF12.Bits.BPDLCD12
#define LCDWF12_BPELCD12                _LCDWF12.Bits.BPELCD12
#define LCDWF12_BPFLCD12                _LCDWF12.Bits.BPFLCD12
#define LCDWF12_BPGLCD12                _LCDWF12.Bits.BPGLCD12
#define LCDWF12_BPHLCD12                _LCDWF12.Bits.BPHLCD12

#define LCDWF12_BPALCD12_MASK           1
#define LCDWF12_BPBLCD12_MASK           2
#define LCDWF12_BPCLCD12_MASK           4
#define LCDWF12_BPDLCD12_MASK           8
#define LCDWF12_BPELCD12_MASK           16
#define LCDWF12_BPFLCD12_MASK           32
#define LCDWF12_BPGLCD12_MASK           64
#define LCDWF12_BPHLCD12_MASK           128


/*** LCDWF13 - LCD Waveform Register 13; 0x0000109D ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD13    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD13    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD13    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD13    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD13    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD13    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD13    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD13    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF13STR;
extern volatile LCDWF13STR _LCDWF13 @0x0000109D;
#define LCDWF13                         _LCDWF13.Byte
#define LCDWF13_BPALCD13                _LCDWF13.Bits.BPALCD13
#define LCDWF13_BPBLCD13                _LCDWF13.Bits.BPBLCD13
#define LCDWF13_BPCLCD13                _LCDWF13.Bits.BPCLCD13
#define LCDWF13_BPDLCD13                _LCDWF13.Bits.BPDLCD13
#define LCDWF13_BPELCD13                _LCDWF13.Bits.BPELCD13
#define LCDWF13_BPFLCD13                _LCDWF13.Bits.BPFLCD13
#define LCDWF13_BPGLCD13                _LCDWF13.Bits.BPGLCD13
#define LCDWF13_BPHLCD13                _LCDWF13.Bits.BPHLCD13

#define LCDWF13_BPALCD13_MASK           1
#define LCDWF13_BPBLCD13_MASK           2
#define LCDWF13_BPCLCD13_MASK           4
#define LCDWF13_BPDLCD13_MASK           8
#define LCDWF13_BPELCD13_MASK           16
#define LCDWF13_BPFLCD13_MASK           32
#define LCDWF13_BPGLCD13_MASK           64
#define LCDWF13_BPHLCD13_MASK           128


/*** LCDWF14 - LCD Waveform Register 14; 0x0000109E ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD14    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD14    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD14    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD14    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD14    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD14    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD14    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD14    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF14STR;
extern volatile LCDWF14STR _LCDWF14 @0x0000109E;
#define LCDWF14                         _LCDWF14.Byte
#define LCDWF14_BPALCD14                _LCDWF14.Bits.BPALCD14
#define LCDWF14_BPBLCD14                _LCDWF14.Bits.BPBLCD14
#define LCDWF14_BPCLCD14                _LCDWF14.Bits.BPCLCD14
#define LCDWF14_BPDLCD14                _LCDWF14.Bits.BPDLCD14
#define LCDWF14_BPELCD14                _LCDWF14.Bits.BPELCD14
#define LCDWF14_BPFLCD14                _LCDWF14.Bits.BPFLCD14
#define LCDWF14_BPGLCD14                _LCDWF14.Bits.BPGLCD14
#define LCDWF14_BPHLCD14                _LCDWF14.Bits.BPHLCD14

#define LCDWF14_BPALCD14_MASK           1
#define LCDWF14_BPBLCD14_MASK           2
#define LCDWF14_BPCLCD14_MASK           4
#define LCDWF14_BPDLCD14_MASK           8
#define LCDWF14_BPELCD14_MASK           16
#define LCDWF14_BPFLCD14_MASK           32
#define LCDWF14_BPGLCD14_MASK           64
#define LCDWF14_BPHLCD14_MASK           128


/*** LCDWF15 - LCD Waveform Register 15; 0x0000109F ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD15    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD15    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD15    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD15    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD15    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD15    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD15    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD15    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF15STR;
extern volatile LCDWF15STR _LCDWF15 @0x0000109F;
#define LCDWF15                         _LCDWF15.Byte
#define LCDWF15_BPALCD15                _LCDWF15.Bits.BPALCD15
#define LCDWF15_BPBLCD15                _LCDWF15.Bits.BPBLCD15
#define LCDWF15_BPCLCD15                _LCDWF15.Bits.BPCLCD15
#define LCDWF15_BPDLCD15                _LCDWF15.Bits.BPDLCD15
#define LCDWF15_BPELCD15                _LCDWF15.Bits.BPELCD15
#define LCDWF15_BPFLCD15                _LCDWF15.Bits.BPFLCD15
#define LCDWF15_BPGLCD15                _LCDWF15.Bits.BPGLCD15
#define LCDWF15_BPHLCD15                _LCDWF15.Bits.BPHLCD15

#define LCDWF15_BPALCD15_MASK           1
#define LCDWF15_BPBLCD15_MASK           2
#define LCDWF15_BPCLCD15_MASK           4
#define LCDWF15_BPDLCD15_MASK           8
#define LCDWF15_BPELCD15_MASK           16
#define LCDWF15_BPFLCD15_MASK           32
#define LCDWF15_BPGLCD15_MASK           64
#define LCDWF15_BPHLCD15_MASK           128


/*** LCDWF16 - LCD Waveform Register 16; 0x000010A0 ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD16    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD16    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD16    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD16    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD16    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD16    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD16    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD16    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF16STR;
extern volatile LCDWF16STR _LCDWF16 @0x000010A0;
#define LCDWF16                         _LCDWF16.Byte
#define LCDWF16_BPALCD16                _LCDWF16.Bits.BPALCD16
#define LCDWF16_BPBLCD16                _LCDWF16.Bits.BPBLCD16
#define LCDWF16_BPCLCD16                _LCDWF16.Bits.BPCLCD16
#define LCDWF16_BPDLCD16                _LCDWF16.Bits.BPDLCD16
#define LCDWF16_BPELCD16                _LCDWF16.Bits.BPELCD16
#define LCDWF16_BPFLCD16                _LCDWF16.Bits.BPFLCD16
#define LCDWF16_BPGLCD16                _LCDWF16.Bits.BPGLCD16
#define LCDWF16_BPHLCD16                _LCDWF16.Bits.BPHLCD16

#define LCDWF16_BPALCD16_MASK           1
#define LCDWF16_BPBLCD16_MASK           2
#define LCDWF16_BPCLCD16_MASK           4
#define LCDWF16_BPDLCD16_MASK           8
#define LCDWF16_BPELCD16_MASK           16
#define LCDWF16_BPFLCD16_MASK           32
#define LCDWF16_BPGLCD16_MASK           64
#define LCDWF16_BPHLCD16_MASK           128


/*** LCDWF17 - LCD Waveform Register 17; 0x000010A1 ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD17    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD17    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD17    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD17    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD17    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD17    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD17    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD17    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF17STR;
extern volatile LCDWF17STR _LCDWF17 @0x000010A1;
#define LCDWF17                         _LCDWF17.Byte
#define LCDWF17_BPALCD17                _LCDWF17.Bits.BPALCD17
#define LCDWF17_BPBLCD17                _LCDWF17.Bits.BPBLCD17
#define LCDWF17_BPCLCD17                _LCDWF17.Bits.BPCLCD17
#define LCDWF17_BPDLCD17                _LCDWF17.Bits.BPDLCD17
#define LCDWF17_BPELCD17                _LCDWF17.Bits.BPELCD17
#define LCDWF17_BPFLCD17                _LCDWF17.Bits.BPFLCD17
#define LCDWF17_BPGLCD17                _LCDWF17.Bits.BPGLCD17
#define LCDWF17_BPHLCD17                _LCDWF17.Bits.BPHLCD17

#define LCDWF17_BPALCD17_MASK           1
#define LCDWF17_BPBLCD17_MASK           2
#define LCDWF17_BPCLCD17_MASK           4
#define LCDWF17_BPDLCD17_MASK           8
#define LCDWF17_BPELCD17_MASK           16
#define LCDWF17_BPFLCD17_MASK           32
#define LCDWF17_BPGLCD17_MASK           64
#define LCDWF17_BPHLCD17_MASK           128


/*** LCDWF18 - LCD Waveform Register 18; 0x000010A2 ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD18    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD18    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD18    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD18    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD18    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD18    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD18    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD18    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF18STR;
extern volatile LCDWF18STR _LCDWF18 @0x000010A2;
#define LCDWF18                         _LCDWF18.Byte
#define LCDWF18_BPALCD18                _LCDWF18.Bits.BPALCD18
#define LCDWF18_BPBLCD18                _LCDWF18.Bits.BPBLCD18
#define LCDWF18_BPCLCD18                _LCDWF18.Bits.BPCLCD18
#define LCDWF18_BPDLCD18                _LCDWF18.Bits.BPDLCD18
#define LCDWF18_BPELCD18                _LCDWF18.Bits.BPELCD18
#define LCDWF18_BPFLCD18                _LCDWF18.Bits.BPFLCD18
#define LCDWF18_BPGLCD18                _LCDWF18.Bits.BPGLCD18
#define LCDWF18_BPHLCD18                _LCDWF18.Bits.BPHLCD18

#define LCDWF18_BPALCD18_MASK           1
#define LCDWF18_BPBLCD18_MASK           2
#define LCDWF18_BPCLCD18_MASK           4
#define LCDWF18_BPDLCD18_MASK           8
#define LCDWF18_BPELCD18_MASK           16
#define LCDWF18_BPFLCD18_MASK           32
#define LCDWF18_BPGLCD18_MASK           64
#define LCDWF18_BPHLCD18_MASK           128


/*** LCDWF19 - LCD Waveform Register 19; 0x000010A3 ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD19    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD19    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD19    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD19    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD19    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD19    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD19    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD19    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF19STR;
extern volatile LCDWF19STR _LCDWF19 @0x000010A3;
#define LCDWF19                         _LCDWF19.Byte
#define LCDWF19_BPALCD19                _LCDWF19.Bits.BPALCD19
#define LCDWF19_BPBLCD19                _LCDWF19.Bits.BPBLCD19
#define LCDWF19_BPCLCD19                _LCDWF19.Bits.BPCLCD19
#define LCDWF19_BPDLCD19                _LCDWF19.Bits.BPDLCD19
#define LCDWF19_BPELCD19                _LCDWF19.Bits.BPELCD19
#define LCDWF19_BPFLCD19                _LCDWF19.Bits.BPFLCD19
#define LCDWF19_BPGLCD19                _LCDWF19.Bits.BPGLCD19
#define LCDWF19_BPHLCD19                _LCDWF19.Bits.BPHLCD19

#define LCDWF19_BPALCD19_MASK           1
#define LCDWF19_BPBLCD19_MASK           2
#define LCDWF19_BPCLCD19_MASK           4
#define LCDWF19_BPDLCD19_MASK           8
#define LCDWF19_BPELCD19_MASK           16
#define LCDWF19_BPFLCD19_MASK           32
#define LCDWF19_BPGLCD19_MASK           64
#define LCDWF19_BPHLCD19_MASK           128


/*** LCDWF20 - LCD Waveform Register 20; 0x000010A4 ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD20    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD20    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD20    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD20    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD20    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD20    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD20    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD20    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF20STR;
extern volatile LCDWF20STR _LCDWF20 @0x000010A4;
#define LCDWF20                         _LCDWF20.Byte
#define LCDWF20_BPALCD20                _LCDWF20.Bits.BPALCD20
#define LCDWF20_BPBLCD20                _LCDWF20.Bits.BPBLCD20
#define LCDWF20_BPCLCD20                _LCDWF20.Bits.BPCLCD20
#define LCDWF20_BPDLCD20                _LCDWF20.Bits.BPDLCD20
#define LCDWF20_BPELCD20                _LCDWF20.Bits.BPELCD20
#define LCDWF20_BPFLCD20                _LCDWF20.Bits.BPFLCD20
#define LCDWF20_BPGLCD20                _LCDWF20.Bits.BPGLCD20
#define LCDWF20_BPHLCD20                _LCDWF20.Bits.BPHLCD20

#define LCDWF20_BPALCD20_MASK           1
#define LCDWF20_BPBLCD20_MASK           2
#define LCDWF20_BPCLCD20_MASK           4
#define LCDWF20_BPDLCD20_MASK           8
#define LCDWF20_BPELCD20_MASK           16
#define LCDWF20_BPFLCD20_MASK           32
#define LCDWF20_BPGLCD20_MASK           64
#define LCDWF20_BPHLCD20_MASK           128


/*** LCDWF21 - LCD Waveform Register 21; 0x000010A5 ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD21    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD21    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD21    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD21    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD21    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD21    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD21    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD21    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF21STR;
extern volatile LCDWF21STR _LCDWF21 @0x000010A5;
#define LCDWF21                         _LCDWF21.Byte
#define LCDWF21_BPALCD21                _LCDWF21.Bits.BPALCD21
#define LCDWF21_BPBLCD21                _LCDWF21.Bits.BPBLCD21
#define LCDWF21_BPCLCD21                _LCDWF21.Bits.BPCLCD21
#define LCDWF21_BPDLCD21                _LCDWF21.Bits.BPDLCD21
#define LCDWF21_BPELCD21                _LCDWF21.Bits.BPELCD21
#define LCDWF21_BPFLCD21                _LCDWF21.Bits.BPFLCD21
#define LCDWF21_BPGLCD21                _LCDWF21.Bits.BPGLCD21
#define LCDWF21_BPHLCD21                _LCDWF21.Bits.BPHLCD21

#define LCDWF21_BPALCD21_MASK           1
#define LCDWF21_BPBLCD21_MASK           2
#define LCDWF21_BPCLCD21_MASK           4
#define LCDWF21_BPDLCD21_MASK           8
#define LCDWF21_BPELCD21_MASK           16
#define LCDWF21_BPFLCD21_MASK           32
#define LCDWF21_BPGLCD21_MASK           64
#define LCDWF21_BPHLCD21_MASK           128


/*** LCDWF22 - LCD Waveform Register 22; 0x000010A6 ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD22    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD22    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD22    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD22    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD22    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD22    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD22    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD22    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF22STR;
extern volatile LCDWF22STR _LCDWF22 @0x000010A6;
#define LCDWF22                         _LCDWF22.Byte
#define LCDWF22_BPALCD22                _LCDWF22.Bits.BPALCD22
#define LCDWF22_BPBLCD22                _LCDWF22.Bits.BPBLCD22
#define LCDWF22_BPCLCD22                _LCDWF22.Bits.BPCLCD22
#define LCDWF22_BPDLCD22                _LCDWF22.Bits.BPDLCD22
#define LCDWF22_BPELCD22                _LCDWF22.Bits.BPELCD22
#define LCDWF22_BPFLCD22                _LCDWF22.Bits.BPFLCD22
#define LCDWF22_BPGLCD22                _LCDWF22.Bits.BPGLCD22
#define LCDWF22_BPHLCD22                _LCDWF22.Bits.BPHLCD22

#define LCDWF22_BPALCD22_MASK           1
#define LCDWF22_BPBLCD22_MASK           2
#define LCDWF22_BPCLCD22_MASK           4
#define LCDWF22_BPDLCD22_MASK           8
#define LCDWF22_BPELCD22_MASK           16
#define LCDWF22_BPFLCD22_MASK           32
#define LCDWF22_BPGLCD22_MASK           64
#define LCDWF22_BPHLCD22_MASK           128


/*** LCDWF23 - LCD Waveform Register 23; 0x000010A7 ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD23    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD23    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD23    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD23    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD23    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD23    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD23    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD23    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF23STR;
extern volatile LCDWF23STR _LCDWF23 @0x000010A7;
#define LCDWF23                         _LCDWF23.Byte
#define LCDWF23_BPALCD23                _LCDWF23.Bits.BPALCD23
#define LCDWF23_BPBLCD23                _LCDWF23.Bits.BPBLCD23
#define LCDWF23_BPCLCD23                _LCDWF23.Bits.BPCLCD23
#define LCDWF23_BPDLCD23                _LCDWF23.Bits.BPDLCD23
#define LCDWF23_BPELCD23                _LCDWF23.Bits.BPELCD23
#define LCDWF23_BPFLCD23                _LCDWF23.Bits.BPFLCD23
#define LCDWF23_BPGLCD23                _LCDWF23.Bits.BPGLCD23
#define LCDWF23_BPHLCD23                _LCDWF23.Bits.BPHLCD23

#define LCDWF23_BPALCD23_MASK           1
#define LCDWF23_BPBLCD23_MASK           2
#define LCDWF23_BPCLCD23_MASK           4
#define LCDWF23_BPDLCD23_MASK           8
#define LCDWF23_BPELCD23_MASK           16
#define LCDWF23_BPFLCD23_MASK           32
#define LCDWF23_BPGLCD23_MASK           64
#define LCDWF23_BPHLCD23_MASK           128


/*** LCDWF24 - LCD Waveform Register 24; 0x000010A8 ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD24    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD24    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD24    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD24    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD24    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD24    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD24    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD24    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF24STR;
extern volatile LCDWF24STR _LCDWF24 @0x000010A8;
#define LCDWF24                         _LCDWF24.Byte
#define LCDWF24_BPALCD24                _LCDWF24.Bits.BPALCD24
#define LCDWF24_BPBLCD24                _LCDWF24.Bits.BPBLCD24
#define LCDWF24_BPCLCD24                _LCDWF24.Bits.BPCLCD24
#define LCDWF24_BPDLCD24                _LCDWF24.Bits.BPDLCD24
#define LCDWF24_BPELCD24                _LCDWF24.Bits.BPELCD24
#define LCDWF24_BPFLCD24                _LCDWF24.Bits.BPFLCD24
#define LCDWF24_BPGLCD24                _LCDWF24.Bits.BPGLCD24
#define LCDWF24_BPHLCD24                _LCDWF24.Bits.BPHLCD24

#define LCDWF24_BPALCD24_MASK           1
#define LCDWF24_BPBLCD24_MASK           2
#define LCDWF24_BPCLCD24_MASK           4
#define LCDWF24_BPDLCD24_MASK           8
#define LCDWF24_BPELCD24_MASK           16
#define LCDWF24_BPFLCD24_MASK           32
#define LCDWF24_BPGLCD24_MASK           64
#define LCDWF24_BPHLCD24_MASK           128


/*** LCDWF25 - LCD Waveform Register 25; 0x000010A9 ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD25    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD25    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD25    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD25    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD25    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD25    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD25    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD25    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF25STR;
extern volatile LCDWF25STR _LCDWF25 @0x000010A9;
#define LCDWF25                         _LCDWF25.Byte
#define LCDWF25_BPALCD25                _LCDWF25.Bits.BPALCD25
#define LCDWF25_BPBLCD25                _LCDWF25.Bits.BPBLCD25
#define LCDWF25_BPCLCD25                _LCDWF25.Bits.BPCLCD25
#define LCDWF25_BPDLCD25                _LCDWF25.Bits.BPDLCD25
#define LCDWF25_BPELCD25                _LCDWF25.Bits.BPELCD25
#define LCDWF25_BPFLCD25                _LCDWF25.Bits.BPFLCD25
#define LCDWF25_BPGLCD25                _LCDWF25.Bits.BPGLCD25
#define LCDWF25_BPHLCD25                _LCDWF25.Bits.BPHLCD25

#define LCDWF25_BPALCD25_MASK           1
#define LCDWF25_BPBLCD25_MASK           2
#define LCDWF25_BPCLCD25_MASK           4
#define LCDWF25_BPDLCD25_MASK           8
#define LCDWF25_BPELCD25_MASK           16
#define LCDWF25_BPFLCD25_MASK           32
#define LCDWF25_BPGLCD25_MASK           64
#define LCDWF25_BPHLCD25_MASK           128


/*** LCDWF26 - LCD Waveform Register 26; 0x000010AA ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD26    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD26    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD26    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD26    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD26    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD26    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD26    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD26    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF26STR;
extern volatile LCDWF26STR _LCDWF26 @0x000010AA;
#define LCDWF26                         _LCDWF26.Byte
#define LCDWF26_BPALCD26                _LCDWF26.Bits.BPALCD26
#define LCDWF26_BPBLCD26                _LCDWF26.Bits.BPBLCD26
#define LCDWF26_BPCLCD26                _LCDWF26.Bits.BPCLCD26
#define LCDWF26_BPDLCD26                _LCDWF26.Bits.BPDLCD26
#define LCDWF26_BPELCD26                _LCDWF26.Bits.BPELCD26
#define LCDWF26_BPFLCD26                _LCDWF26.Bits.BPFLCD26
#define LCDWF26_BPGLCD26                _LCDWF26.Bits.BPGLCD26
#define LCDWF26_BPHLCD26                _LCDWF26.Bits.BPHLCD26

#define LCDWF26_BPALCD26_MASK           1
#define LCDWF26_BPBLCD26_MASK           2
#define LCDWF26_BPCLCD26_MASK           4
#define LCDWF26_BPDLCD26_MASK           8
#define LCDWF26_BPELCD26_MASK           16
#define LCDWF26_BPFLCD26_MASK           32
#define LCDWF26_BPGLCD26_MASK           64
#define LCDWF26_BPHLCD26_MASK           128


/*** LCDWF27 - LCD Waveform Register 27; 0x000010AB ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD27    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD27    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD27    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD27    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD27    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD27    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD27    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD27    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF27STR;
extern volatile LCDWF27STR _LCDWF27 @0x000010AB;
#define LCDWF27                         _LCDWF27.Byte
#define LCDWF27_BPALCD27                _LCDWF27.Bits.BPALCD27
#define LCDWF27_BPBLCD27                _LCDWF27.Bits.BPBLCD27
#define LCDWF27_BPCLCD27                _LCDWF27.Bits.BPCLCD27
#define LCDWF27_BPDLCD27                _LCDWF27.Bits.BPDLCD27
#define LCDWF27_BPELCD27                _LCDWF27.Bits.BPELCD27
#define LCDWF27_BPFLCD27                _LCDWF27.Bits.BPFLCD27
#define LCDWF27_BPGLCD27                _LCDWF27.Bits.BPGLCD27
#define LCDWF27_BPHLCD27                _LCDWF27.Bits.BPHLCD27

#define LCDWF27_BPALCD27_MASK           1
#define LCDWF27_BPBLCD27_MASK           2
#define LCDWF27_BPCLCD27_MASK           4
#define LCDWF27_BPDLCD27_MASK           8
#define LCDWF27_BPELCD27_MASK           16
#define LCDWF27_BPFLCD27_MASK           32
#define LCDWF27_BPGLCD27_MASK           64
#define LCDWF27_BPHLCD27_MASK           128


/*** LCDWF28 - LCD Waveform Register 28; 0x000010AC ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD28    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD28    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD28    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD28    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD28    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD28    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD28    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD28    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF28STR;
extern volatile LCDWF28STR _LCDWF28 @0x000010AC;
#define LCDWF28                         _LCDWF28.Byte
#define LCDWF28_BPALCD28                _LCDWF28.Bits.BPALCD28
#define LCDWF28_BPBLCD28                _LCDWF28.Bits.BPBLCD28
#define LCDWF28_BPCLCD28                _LCDWF28.Bits.BPCLCD28
#define LCDWF28_BPDLCD28                _LCDWF28.Bits.BPDLCD28
#define LCDWF28_BPELCD28                _LCDWF28.Bits.BPELCD28
#define LCDWF28_BPFLCD28                _LCDWF28.Bits.BPFLCD28
#define LCDWF28_BPGLCD28                _LCDWF28.Bits.BPGLCD28
#define LCDWF28_BPHLCD28                _LCDWF28.Bits.BPHLCD28

#define LCDWF28_BPALCD28_MASK           1
#define LCDWF28_BPBLCD28_MASK           2
#define LCDWF28_BPCLCD28_MASK           4
#define LCDWF28_BPDLCD28_MASK           8
#define LCDWF28_BPELCD28_MASK           16
#define LCDWF28_BPFLCD28_MASK           32
#define LCDWF28_BPGLCD28_MASK           64
#define LCDWF28_BPHLCD28_MASK           128


/*** LCDWF29 - LCD Waveform Register 29; 0x000010AD ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD29    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD29    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD29    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD29    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD29    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD29    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD29    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD29    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF29STR;
extern volatile LCDWF29STR _LCDWF29 @0x000010AD;
#define LCDWF29                         _LCDWF29.Byte
#define LCDWF29_BPALCD29                _LCDWF29.Bits.BPALCD29
#define LCDWF29_BPBLCD29                _LCDWF29.Bits.BPBLCD29
#define LCDWF29_BPCLCD29                _LCDWF29.Bits.BPCLCD29
#define LCDWF29_BPDLCD29                _LCDWF29.Bits.BPDLCD29
#define LCDWF29_BPELCD29                _LCDWF29.Bits.BPELCD29
#define LCDWF29_BPFLCD29                _LCDWF29.Bits.BPFLCD29
#define LCDWF29_BPGLCD29                _LCDWF29.Bits.BPGLCD29
#define LCDWF29_BPHLCD29                _LCDWF29.Bits.BPHLCD29

#define LCDWF29_BPALCD29_MASK           1
#define LCDWF29_BPBLCD29_MASK           2
#define LCDWF29_BPCLCD29_MASK           4
#define LCDWF29_BPDLCD29_MASK           8
#define LCDWF29_BPELCD29_MASK           16
#define LCDWF29_BPFLCD29_MASK           32
#define LCDWF29_BPGLCD29_MASK           64
#define LCDWF29_BPHLCD29_MASK           128


/*** LCDWF30 - LCD Waveform Register 30; 0x000010AE ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD30    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD30    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD30    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD30    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD30    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD30    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD30    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD30    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF30STR;
extern volatile LCDWF30STR _LCDWF30 @0x000010AE;
#define LCDWF30                         _LCDWF30.Byte
#define LCDWF30_BPALCD30                _LCDWF30.Bits.BPALCD30
#define LCDWF30_BPBLCD30                _LCDWF30.Bits.BPBLCD30
#define LCDWF30_BPCLCD30                _LCDWF30.Bits.BPCLCD30
#define LCDWF30_BPDLCD30                _LCDWF30.Bits.BPDLCD30
#define LCDWF30_BPELCD30                _LCDWF30.Bits.BPELCD30
#define LCDWF30_BPFLCD30                _LCDWF30.Bits.BPFLCD30
#define LCDWF30_BPGLCD30                _LCDWF30.Bits.BPGLCD30
#define LCDWF30_BPHLCD30                _LCDWF30.Bits.BPHLCD30

#define LCDWF30_BPALCD30_MASK           1
#define LCDWF30_BPBLCD30_MASK           2
#define LCDWF30_BPCLCD30_MASK           4
#define LCDWF30_BPDLCD30_MASK           8
#define LCDWF30_BPELCD30_MASK           16
#define LCDWF30_BPFLCD30_MASK           32
#define LCDWF30_BPGLCD30_MASK           64
#define LCDWF30_BPHLCD30_MASK           128


/*** LCDWF31 - LCD Waveform Register 31; 0x000010AF ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD31    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD31    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD31    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD31    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD31    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD31    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD31    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD31    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF31STR;
extern volatile LCDWF31STR _LCDWF31 @0x000010AF;
#define LCDWF31                         _LCDWF31.Byte
#define LCDWF31_BPALCD31                _LCDWF31.Bits.BPALCD31
#define LCDWF31_BPBLCD31                _LCDWF31.Bits.BPBLCD31
#define LCDWF31_BPCLCD31                _LCDWF31.Bits.BPCLCD31
#define LCDWF31_BPDLCD31                _LCDWF31.Bits.BPDLCD31
#define LCDWF31_BPELCD31                _LCDWF31.Bits.BPELCD31
#define LCDWF31_BPFLCD31                _LCDWF31.Bits.BPFLCD31
#define LCDWF31_BPGLCD31                _LCDWF31.Bits.BPGLCD31
#define LCDWF31_BPHLCD31                _LCDWF31.Bits.BPHLCD31

#define LCDWF31_BPALCD31_MASK           1
#define LCDWF31_BPBLCD31_MASK           2
#define LCDWF31_BPCLCD31_MASK           4
#define LCDWF31_BPDLCD31_MASK           8
#define LCDWF31_BPELCD31_MASK           16
#define LCDWF31_BPFLCD31_MASK           32
#define LCDWF31_BPGLCD31_MASK           64
#define LCDWF31_BPHLCD31_MASK           128


/*** LCDWF32 - LCD Waveform Register 32; 0x000010B0 ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD32    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD32    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD32    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD32    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD32    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD32    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD32    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD32    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF32STR;
extern volatile LCDWF32STR _LCDWF32 @0x000010B0;
#define LCDWF32                         _LCDWF32.Byte
#define LCDWF32_BPALCD32                _LCDWF32.Bits.BPALCD32
#define LCDWF32_BPBLCD32                _LCDWF32.Bits.BPBLCD32
#define LCDWF32_BPCLCD32                _LCDWF32.Bits.BPCLCD32
#define LCDWF32_BPDLCD32                _LCDWF32.Bits.BPDLCD32
#define LCDWF32_BPELCD32                _LCDWF32.Bits.BPELCD32
#define LCDWF32_BPFLCD32                _LCDWF32.Bits.BPFLCD32
#define LCDWF32_BPGLCD32                _LCDWF32.Bits.BPGLCD32
#define LCDWF32_BPHLCD32                _LCDWF32.Bits.BPHLCD32

#define LCDWF32_BPALCD32_MASK           1
#define LCDWF32_BPBLCD32_MASK           2
#define LCDWF32_BPCLCD32_MASK           4
#define LCDWF32_BPDLCD32_MASK           8
#define LCDWF32_BPELCD32_MASK           16
#define LCDWF32_BPFLCD32_MASK           32
#define LCDWF32_BPGLCD32_MASK           64
#define LCDWF32_BPHLCD32_MASK           128


/*** LCDWF33 - LCD Waveform Register 33; 0x000010B1 ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD33    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD33    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD33    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD33    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD33    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD33    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD33    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD33    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF33STR;
extern volatile LCDWF33STR _LCDWF33 @0x000010B1;
#define LCDWF33                         _LCDWF33.Byte
#define LCDWF33_BPALCD33                _LCDWF33.Bits.BPALCD33
#define LCDWF33_BPBLCD33                _LCDWF33.Bits.BPBLCD33
#define LCDWF33_BPCLCD33                _LCDWF33.Bits.BPCLCD33
#define LCDWF33_BPDLCD33                _LCDWF33.Bits.BPDLCD33
#define LCDWF33_BPELCD33                _LCDWF33.Bits.BPELCD33
#define LCDWF33_BPFLCD33                _LCDWF33.Bits.BPFLCD33
#define LCDWF33_BPGLCD33                _LCDWF33.Bits.BPGLCD33
#define LCDWF33_BPHLCD33                _LCDWF33.Bits.BPHLCD33

#define LCDWF33_BPALCD33_MASK           1
#define LCDWF33_BPBLCD33_MASK           2
#define LCDWF33_BPCLCD33_MASK           4
#define LCDWF33_BPDLCD33_MASK           8
#define LCDWF33_BPELCD33_MASK           16
#define LCDWF33_BPFLCD33_MASK           32
#define LCDWF33_BPGLCD33_MASK           64
#define LCDWF33_BPHLCD33_MASK           128


/*** LCDWF34 - LCD Waveform Register 34; 0x000010B2 ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD34    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD34    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD34    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD34    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD34    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD34    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD34    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD34    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF34STR;
extern volatile LCDWF34STR _LCDWF34 @0x000010B2;
#define LCDWF34                         _LCDWF34.Byte
#define LCDWF34_BPALCD34                _LCDWF34.Bits.BPALCD34
#define LCDWF34_BPBLCD34                _LCDWF34.Bits.BPBLCD34
#define LCDWF34_BPCLCD34                _LCDWF34.Bits.BPCLCD34
#define LCDWF34_BPDLCD34                _LCDWF34.Bits.BPDLCD34
#define LCDWF34_BPELCD34                _LCDWF34.Bits.BPELCD34
#define LCDWF34_BPFLCD34                _LCDWF34.Bits.BPFLCD34
#define LCDWF34_BPGLCD34                _LCDWF34.Bits.BPGLCD34
#define LCDWF34_BPHLCD34                _LCDWF34.Bits.BPHLCD34

#define LCDWF34_BPALCD34_MASK           1
#define LCDWF34_BPBLCD34_MASK           2
#define LCDWF34_BPCLCD34_MASK           4
#define LCDWF34_BPDLCD34_MASK           8
#define LCDWF34_BPELCD34_MASK           16
#define LCDWF34_BPFLCD34_MASK           32
#define LCDWF34_BPGLCD34_MASK           64
#define LCDWF34_BPHLCD34_MASK           128


/*** LCDWF35 - LCD Waveform Register 35; 0x000010B3 ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD35    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD35    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD35    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD35    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD35    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD35    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD35    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD35    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF35STR;
extern volatile LCDWF35STR _LCDWF35 @0x000010B3;
#define LCDWF35                         _LCDWF35.Byte
#define LCDWF35_BPALCD35                _LCDWF35.Bits.BPALCD35
#define LCDWF35_BPBLCD35                _LCDWF35.Bits.BPBLCD35
#define LCDWF35_BPCLCD35                _LCDWF35.Bits.BPCLCD35
#define LCDWF35_BPDLCD35                _LCDWF35.Bits.BPDLCD35
#define LCDWF35_BPELCD35                _LCDWF35.Bits.BPELCD35
#define LCDWF35_BPFLCD35                _LCDWF35.Bits.BPFLCD35
#define LCDWF35_BPGLCD35                _LCDWF35.Bits.BPGLCD35
#define LCDWF35_BPHLCD35                _LCDWF35.Bits.BPHLCD35

#define LCDWF35_BPALCD35_MASK           1
#define LCDWF35_BPBLCD35_MASK           2
#define LCDWF35_BPCLCD35_MASK           4
#define LCDWF35_BPDLCD35_MASK           8
#define LCDWF35_BPELCD35_MASK           16
#define LCDWF35_BPFLCD35_MASK           32
#define LCDWF35_BPGLCD35_MASK           64
#define LCDWF35_BPHLCD35_MASK           128


/*** LCDWF36 - LCD Waveform Register 36; 0x000010B4 ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD36    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD36    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD36    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD36    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD36    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD36    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD36    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD36    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF36STR;
extern volatile LCDWF36STR _LCDWF36 @0x000010B4;
#define LCDWF36                         _LCDWF36.Byte
#define LCDWF36_BPALCD36                _LCDWF36.Bits.BPALCD36
#define LCDWF36_BPBLCD36                _LCDWF36.Bits.BPBLCD36
#define LCDWF36_BPCLCD36                _LCDWF36.Bits.BPCLCD36
#define LCDWF36_BPDLCD36                _LCDWF36.Bits.BPDLCD36
#define LCDWF36_BPELCD36                _LCDWF36.Bits.BPELCD36
#define LCDWF36_BPFLCD36                _LCDWF36.Bits.BPFLCD36
#define LCDWF36_BPGLCD36                _LCDWF36.Bits.BPGLCD36
#define LCDWF36_BPHLCD36                _LCDWF36.Bits.BPHLCD36

#define LCDWF36_BPALCD36_MASK           1
#define LCDWF36_BPBLCD36_MASK           2
#define LCDWF36_BPCLCD36_MASK           4
#define LCDWF36_BPDLCD36_MASK           8
#define LCDWF36_BPELCD36_MASK           16
#define LCDWF36_BPFLCD36_MASK           32
#define LCDWF36_BPGLCD36_MASK           64
#define LCDWF36_BPHLCD36_MASK           128


/*** LCDWF37 - LCD Waveform Register 37; 0x000010B5 ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD37    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD37    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD37    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD37    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD37    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD37    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD37    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD37    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF37STR;
extern volatile LCDWF37STR _LCDWF37 @0x000010B5;
#define LCDWF37                         _LCDWF37.Byte
#define LCDWF37_BPALCD37                _LCDWF37.Bits.BPALCD37
#define LCDWF37_BPBLCD37                _LCDWF37.Bits.BPBLCD37
#define LCDWF37_BPCLCD37                _LCDWF37.Bits.BPCLCD37
#define LCDWF37_BPDLCD37                _LCDWF37.Bits.BPDLCD37
#define LCDWF37_BPELCD37                _LCDWF37.Bits.BPELCD37
#define LCDWF37_BPFLCD37                _LCDWF37.Bits.BPFLCD37
#define LCDWF37_BPGLCD37                _LCDWF37.Bits.BPGLCD37
#define LCDWF37_BPHLCD37                _LCDWF37.Bits.BPHLCD37

#define LCDWF37_BPALCD37_MASK           1
#define LCDWF37_BPBLCD37_MASK           2
#define LCDWF37_BPCLCD37_MASK           4
#define LCDWF37_BPDLCD37_MASK           8
#define LCDWF37_BPELCD37_MASK           16
#define LCDWF37_BPFLCD37_MASK           32
#define LCDWF37_BPGLCD37_MASK           64
#define LCDWF37_BPHLCD37_MASK           128


/*** LCDWF38 - LCD Waveform Register 38; 0x000010B6 ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD38    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD38    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD38    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD38    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD38    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD38    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD38    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD38    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF38STR;
extern volatile LCDWF38STR _LCDWF38 @0x000010B6;
#define LCDWF38                         _LCDWF38.Byte
#define LCDWF38_BPALCD38                _LCDWF38.Bits.BPALCD38
#define LCDWF38_BPBLCD38                _LCDWF38.Bits.BPBLCD38
#define LCDWF38_BPCLCD38                _LCDWF38.Bits.BPCLCD38
#define LCDWF38_BPDLCD38                _LCDWF38.Bits.BPDLCD38
#define LCDWF38_BPELCD38                _LCDWF38.Bits.BPELCD38
#define LCDWF38_BPFLCD38                _LCDWF38.Bits.BPFLCD38
#define LCDWF38_BPGLCD38                _LCDWF38.Bits.BPGLCD38
#define LCDWF38_BPHLCD38                _LCDWF38.Bits.BPHLCD38

#define LCDWF38_BPALCD38_MASK           1
#define LCDWF38_BPBLCD38_MASK           2
#define LCDWF38_BPCLCD38_MASK           4
#define LCDWF38_BPDLCD38_MASK           8
#define LCDWF38_BPELCD38_MASK           16
#define LCDWF38_BPFLCD38_MASK           32
#define LCDWF38_BPGLCD38_MASK           64
#define LCDWF38_BPHLCD38_MASK           128


/*** LCDWF39 - LCD Waveform Register 39; 0x000010B7 ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD39    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD39    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD39    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD39    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD39    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD39    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD39    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD39    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF39STR;
extern volatile LCDWF39STR _LCDWF39 @0x000010B7;
#define LCDWF39                         _LCDWF39.Byte
#define LCDWF39_BPALCD39                _LCDWF39.Bits.BPALCD39
#define LCDWF39_BPBLCD39                _LCDWF39.Bits.BPBLCD39
#define LCDWF39_BPCLCD39                _LCDWF39.Bits.BPCLCD39
#define LCDWF39_BPDLCD39                _LCDWF39.Bits.BPDLCD39
#define LCDWF39_BPELCD39                _LCDWF39.Bits.BPELCD39
#define LCDWF39_BPFLCD39                _LCDWF39.Bits.BPFLCD39
#define LCDWF39_BPGLCD39                _LCDWF39.Bits.BPGLCD39
#define LCDWF39_BPHLCD39                _LCDWF39.Bits.BPHLCD39

#define LCDWF39_BPALCD39_MASK           1
#define LCDWF39_BPBLCD39_MASK           2
#define LCDWF39_BPCLCD39_MASK           4
#define LCDWF39_BPDLCD39_MASK           8
#define LCDWF39_BPELCD39_MASK           16
#define LCDWF39_BPFLCD39_MASK           32
#define LCDWF39_BPGLCD39_MASK           64
#define LCDWF39_BPHLCD39_MASK           128


/*** LCDWF40 - LCD Waveform Register 40; 0x000010B8 ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD40    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD40    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD40    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD40    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD40    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD40    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD40    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD40    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF40STR;
extern volatile LCDWF40STR _LCDWF40 @0x000010B8;
#define LCDWF40                         _LCDWF40.Byte
#define LCDWF40_BPALCD40                _LCDWF40.Bits.BPALCD40
#define LCDWF40_BPBLCD40                _LCDWF40.Bits.BPBLCD40
#define LCDWF40_BPCLCD40                _LCDWF40.Bits.BPCLCD40
#define LCDWF40_BPDLCD40                _LCDWF40.Bits.BPDLCD40
#define LCDWF40_BPELCD40                _LCDWF40.Bits.BPELCD40
#define LCDWF40_BPFLCD40                _LCDWF40.Bits.BPFLCD40
#define LCDWF40_BPGLCD40                _LCDWF40.Bits.BPGLCD40
#define LCDWF40_BPHLCD40                _LCDWF40.Bits.BPHLCD40

#define LCDWF40_BPALCD40_MASK           1
#define LCDWF40_BPBLCD40_MASK           2
#define LCDWF40_BPCLCD40_MASK           4
#define LCDWF40_BPDLCD40_MASK           8
#define LCDWF40_BPELCD40_MASK           16
#define LCDWF40_BPFLCD40_MASK           32
#define LCDWF40_BPGLCD40_MASK           64
#define LCDWF40_BPHLCD40_MASK           128


/*** LCDWF41 - LCD Waveform Register 41; 0x000010B9 ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD41    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD41    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD41    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD41    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD41    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD41    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD41    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD41    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF41STR;
extern volatile LCDWF41STR _LCDWF41 @0x000010B9;
#define LCDWF41                         _LCDWF41.Byte
#define LCDWF41_BPALCD41                _LCDWF41.Bits.BPALCD41
#define LCDWF41_BPBLCD41                _LCDWF41.Bits.BPBLCD41
#define LCDWF41_BPCLCD41                _LCDWF41.Bits.BPCLCD41
#define LCDWF41_BPDLCD41                _LCDWF41.Bits.BPDLCD41
#define LCDWF41_BPELCD41                _LCDWF41.Bits.BPELCD41
#define LCDWF41_BPFLCD41                _LCDWF41.Bits.BPFLCD41
#define LCDWF41_BPGLCD41                _LCDWF41.Bits.BPGLCD41
#define LCDWF41_BPHLCD41                _LCDWF41.Bits.BPHLCD41

#define LCDWF41_BPALCD41_MASK           1
#define LCDWF41_BPBLCD41_MASK           2
#define LCDWF41_BPCLCD41_MASK           4
#define LCDWF41_BPDLCD41_MASK           8
#define LCDWF41_BPELCD41_MASK           16
#define LCDWF41_BPFLCD41_MASK           32
#define LCDWF41_BPGLCD41_MASK           64
#define LCDWF41_BPHLCD41_MASK           128


/*** LCDWF42 - LCD Waveform Register 42; 0x000010BA ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD42    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD42    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD42    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD42    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD42    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD42    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD42    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD42    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF42STR;
extern volatile LCDWF42STR _LCDWF42 @0x000010BA;
#define LCDWF42                         _LCDWF42.Byte
#define LCDWF42_BPALCD42                _LCDWF42.Bits.BPALCD42
#define LCDWF42_BPBLCD42                _LCDWF42.Bits.BPBLCD42
#define LCDWF42_BPCLCD42                _LCDWF42.Bits.BPCLCD42
#define LCDWF42_BPDLCD42                _LCDWF42.Bits.BPDLCD42
#define LCDWF42_BPELCD42                _LCDWF42.Bits.BPELCD42
#define LCDWF42_BPFLCD42                _LCDWF42.Bits.BPFLCD42
#define LCDWF42_BPGLCD42                _LCDWF42.Bits.BPGLCD42
#define LCDWF42_BPHLCD42                _LCDWF42.Bits.BPHLCD42

#define LCDWF42_BPALCD42_MASK           1
#define LCDWF42_BPBLCD42_MASK           2
#define LCDWF42_BPCLCD42_MASK           4
#define LCDWF42_BPDLCD42_MASK           8
#define LCDWF42_BPELCD42_MASK           16
#define LCDWF42_BPFLCD42_MASK           32
#define LCDWF42_BPGLCD42_MASK           64
#define LCDWF42_BPHLCD42_MASK           128


/*** LCDWF43 - LCD Waveform Register 43; 0x000010BB ***/
typedef union {
  byte Byte;
  struct {
    byte BPALCD43    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPBLCD43    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPCLCD43    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPDLCD43    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPELCD43    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPFLCD43    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPGLCD43    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
    byte BPHLCD43    :1;                                       /* Segment on/off Frontplane/Backplane Operation */
  } Bits;
} LCDWF43STR;
extern volatile LCDWF43STR _LCDWF43 @0x000010BB;
#define LCDWF43                         _LCDWF43.Byte
#define LCDWF43_BPALCD43                _LCDWF43.Bits.BPALCD43
#define LCDWF43_BPBLCD43                _LCDWF43.Bits.BPBLCD43
#define LCDWF43_BPCLCD43                _LCDWF43.Bits.BPCLCD43
#define LCDWF43_BPDLCD43                _LCDWF43.Bits.BPDLCD43
#define LCDWF43_BPELCD43                _LCDWF43.Bits.BPELCD43
#define LCDWF43_BPFLCD43                _LCDWF43.Bits.BPFLCD43
#define LCDWF43_BPGLCD43                _LCDWF43.Bits.BPGLCD43
#define LCDWF43_BPHLCD43                _LCDWF43.Bits.BPHLCD43

#define LCDWF43_BPALCD43_MASK           1
#define LCDWF43_BPBLCD43_MASK           2
#define LCDWF43_BPCLCD43_MASK           4
#define LCDWF43_BPDLCD43_MASK           8
#define LCDWF43_BPELCD43_MASK           16
#define LCDWF43_BPFLCD43_MASK           32
#define LCDWF43_BPGLCD43_MASK           64
#define LCDWF43_BPHLCD43_MASK           128


/*** SRS - System Reset Status Register; 0x00001800 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte LVD         :1;                                       /* Low Voltage Detect */
    byte             :1; 
    byte ILAD        :1;                                       /* Illegal Address */
    byte ILOP        :1;                                       /* Illegal Opcode */
    byte COP         :1;                                       /* Computer Operating Properly (COP) Watchdog */
    byte PIN         :1;                                       /* External Reset Pin */
    byte POR         :1;                                       /* Power-On Reset */
  } Bits;
} SRSSTR;
extern volatile SRSSTR _SRS @0x00001800;
#define SRS                             _SRS.Byte
#define SRS_LVD                         _SRS.Bits.LVD
#define SRS_ILAD                        _SRS.Bits.ILAD
#define SRS_ILOP                        _SRS.Bits.ILOP
#define SRS_COP                         _SRS.Bits.COP
#define SRS_PIN                         _SRS.Bits.PIN
#define SRS_POR                         _SRS.Bits.POR

#define SRS_LVD_MASK                    2
#define SRS_ILAD_MASK                   8
#define SRS_ILOP_MASK                   16
#define SRS_COP_MASK                    32
#define SRS_PIN_MASK                    64
#define SRS_POR_MASK                    128


/*** SBDFR - System Background Debug Force Reset Register; 0x00001801 ***/
typedef union {
  byte Byte;
  struct {
    byte BDFR        :1;                                       /* Background Debug Force Reset */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} SBDFRSTR;
extern volatile SBDFRSTR _SBDFR @0x00001801;
#define SBDFR                           _SBDFR.Byte
#define SBDFR_BDFR                      _SBDFR.Bits.BDFR

#define SBDFR_BDFR_MASK                 1


/*** SOPT1 - System Options Register 1; 0x00001802 ***/
typedef union {
  byte Byte;
  struct {
    byte COPW        :1;                                       /* COP Window Mode */
    byte COPCLKS     :1;                                       /* COP Watchdog Clock Select */
    byte COPT0       :1;                                       /* COP Watchdog Timeout, bit 0 */
    byte COPT1       :1;                                       /* COP Watchdog Timeout, bit 1 */
    byte             :1; 
    byte STOPE       :1;                                       /* Stop Mode Enable */
    byte             :1; 
    byte BKGDPE      :1;                                       /* Unused */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpCOPT :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} SOPT1STR;
extern volatile SOPT1STR _SOPT1 @0x00001802;
#define SOPT1                           _SOPT1.Byte
#define SOPT1_COPW                      _SOPT1.Bits.COPW
#define SOPT1_COPCLKS                   _SOPT1.Bits.COPCLKS
#define SOPT1_COPT0                     _SOPT1.Bits.COPT0
#define SOPT1_COPT1                     _SOPT1.Bits.COPT1
#define SOPT1_STOPE                     _SOPT1.Bits.STOPE
#define SOPT1_BKGDPE                    _SOPT1.Bits.BKGDPE
#define SOPT1_COPT                      _SOPT1.MergedBits.grpCOPT

#define SOPT1_COPW_MASK                 1
#define SOPT1_COPCLKS_MASK              2
#define SOPT1_COPT0_MASK                4
#define SOPT1_COPT1_MASK                8
#define SOPT1_STOPE_MASK                32
#define SOPT1_BKGDPE_MASK               128
#define SOPT1_COPT_MASK                 12
#define SOPT1_COPT_BITNUM               2


/*** SDID - System Device Identification Register; 0x00001805 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SDIDH - System Device Identification Register High; 0x00001805 ***/
    union {
      byte Byte;
      struct {
        byte ID8         :1;                                       /* Part Identification Number, bit 8 */
        byte ID9         :1;                                       /* Part Identification Number, bit 9 */
        byte ID10        :1;                                       /* Part Identification Number, bit 10 */
        byte ID11        :1;                                       /* Part Identification Number, bit 11 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpID_8 :4;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } SDIDHSTR;
    #define SDIDH                       _SDID.Overlap_STR.SDIDHSTR.Byte
    #define SDIDH_ID8                   _SDID.Overlap_STR.SDIDHSTR.Bits.ID8
    #define SDIDH_ID9                   _SDID.Overlap_STR.SDIDHSTR.Bits.ID9
    #define SDIDH_ID10                  _SDID.Overlap_STR.SDIDHSTR.Bits.ID10
    #define SDIDH_ID11                  _SDID.Overlap_STR.SDIDHSTR.Bits.ID11
    #define SDIDH_ID_8                  _SDID.Overlap_STR.SDIDHSTR.MergedBits.grpID_8
    #define SDIDH_ID                    SDIDH_ID_8
    
    #define SDIDH_ID8_MASK              1
    #define SDIDH_ID9_MASK              2
    #define SDIDH_ID10_MASK             4
    #define SDIDH_ID11_MASK             8
    #define SDIDH_ID_8_MASK             15
    #define SDIDH_ID_8_BITNUM           0
    

    /*** SDIDL - System Device Identification Register Low; 0x00001806 ***/
    union {
      byte Byte;
      struct {
        byte ID0         :1;                                       /* Part Identification Number, bit 0 */
        byte ID1         :1;                                       /* Part Identification Number, bit 1 */
        byte ID2         :1;                                       /* Part Identification Number, bit 2 */
        byte ID3         :1;                                       /* Part Identification Number, bit 3 */
        byte ID4         :1;                                       /* Part Identification Number, bit 4 */
        byte ID5         :1;                                       /* Part Identification Number, bit 5 */
        byte ID6         :1;                                       /* Part Identification Number, bit 6 */
        byte ID7         :1;                                       /* Part Identification Number, bit 7 */
      } Bits;
    } SDIDLSTR;
    #define SDIDL                       _SDID.Overlap_STR.SDIDLSTR.Byte
    #define SDIDL_ID0                   _SDID.Overlap_STR.SDIDLSTR.Bits.ID0
    #define SDIDL_ID1                   _SDID.Overlap_STR.SDIDLSTR.Bits.ID1
    #define SDIDL_ID2                   _SDID.Overlap_STR.SDIDLSTR.Bits.ID2
    #define SDIDL_ID3                   _SDID.Overlap_STR.SDIDLSTR.Bits.ID3
    #define SDIDL_ID4                   _SDID.Overlap_STR.SDIDLSTR.Bits.ID4
    #define SDIDL_ID5                   _SDID.Overlap_STR.SDIDLSTR.Bits.ID5
    #define SDIDL_ID6                   _SDID.Overlap_STR.SDIDLSTR.Bits.ID6
    #define SDIDL_ID7                   _SDID.Overlap_STR.SDIDLSTR.Bits.ID7
    
    #define SDIDL_ID0_MASK              1
    #define SDIDL_ID1_MASK              2
    #define SDIDL_ID2_MASK              4
    #define SDIDL_ID3_MASK              8
    #define SDIDL_ID4_MASK              16
    #define SDIDL_ID5_MASK              32
    #define SDIDL_ID6_MASK              64
    #define SDIDL_ID7_MASK              128
    
  } Overlap_STR;

} SDIDSTR;
extern volatile SDIDSTR _SDID @0x00001805;
#define SDID                            _SDID.Word


/*** SCGC1 - System Clock Gating Control 1 Register; 0x00001808 ***/
typedef union {
  byte Byte;
  struct {
    byte SCI0        :1;                                       /* SCI0 Clock Gate Control */
    byte SCI1        :1;                                       /* SCI1 Clock Gate Control */
    byte SCI2        :1;                                       /* SCI2 Clock Gate Control */
    byte SCI3        :1;                                       /* SCI3 Clock Gate Control */
    byte IIC         :1;                                       /* IIC Clock Gate Control */
    byte KBI         :1;                                       /* KBI Clock Gate Control */
    byte ADC0        :1;                                       /* ADC0 Clock Gate Control */
    byte ADC1        :1;                                       /* ADC1 Clock Gate Control */
  } Bits;
  struct {
    byte grpSCI  :4;
    byte         :1;
    byte         :1;
    byte grpADC  :2;
  } MergedBits;
} SCGC1STR;
extern volatile SCGC1STR _SCGC1 @0x00001808;
#define SCGC1                           _SCGC1.Byte
#define SCGC1_SCI0                      _SCGC1.Bits.SCI0
#define SCGC1_SCI1                      _SCGC1.Bits.SCI1
#define SCGC1_SCI2                      _SCGC1.Bits.SCI2
#define SCGC1_SCI3                      _SCGC1.Bits.SCI3
#define SCGC1_IIC                       _SCGC1.Bits.IIC
#define SCGC1_KBI                       _SCGC1.Bits.KBI
#define SCGC1_ADC0                      _SCGC1.Bits.ADC0
#define SCGC1_ADC1                      _SCGC1.Bits.ADC1
#define SCGC1_SCI                       _SCGC1.MergedBits.grpSCI
#define SCGC1_ADC                       _SCGC1.MergedBits.grpADC

#define SCGC1_SCI0_MASK                 1
#define SCGC1_SCI1_MASK                 2
#define SCGC1_SCI2_MASK                 4
#define SCGC1_SCI3_MASK                 8
#define SCGC1_IIC_MASK                  16
#define SCGC1_KBI_MASK                  32
#define SCGC1_ADC0_MASK                 64
#define SCGC1_ADC1_MASK                 128
#define SCGC1_SCI_MASK                  15
#define SCGC1_SCI_BITNUM                0
#define SCGC1_ADC_MASK                  192
#define SCGC1_ADC_BITNUM                6


/*** SCGC2 - System Clock Gating Control 2 Register; 0x00001809 ***/
typedef union {
  byte Byte;
  struct {
    byte SPI0        :1;                                       /* SPI0 Clock Gate Control */
    byte SPI1        :1;                                       /* SPI1 Clock Gate Control */
    byte SPI2        :1;                                       /* SPI2 Clock Gate Control */
    byte LCD         :1;                                       /* LCD Clock Gate Control */
    byte IRQ         :1;                                       /* IRQ Clock Gate Control */
    byte VREF        :1;                                       /* VREF Clock Gate Control */
    byte             :1; 
    byte CLKPRE      :1;                                       /* CLKPRE Clock Gate Control */
  } Bits;
  struct {
    byte grpSPI  :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} SCGC2STR;
extern volatile SCGC2STR _SCGC2 @0x00001809;
#define SCGC2                           _SCGC2.Byte
#define SCGC2_SPI0                      _SCGC2.Bits.SPI0
#define SCGC2_SPI1                      _SCGC2.Bits.SPI1
#define SCGC2_SPI2                      _SCGC2.Bits.SPI2
#define SCGC2_LCD                       _SCGC2.Bits.LCD
#define SCGC2_IRQ                       _SCGC2.Bits.IRQ
#define SCGC2_VREF                      _SCGC2.Bits.VREF
#define SCGC2_CLKPRE                    _SCGC2.Bits.CLKPRE
#define SCGC2_SPI                       _SCGC2.MergedBits.grpSPI

#define SCGC2_SPI0_MASK                 1
#define SCGC2_SPI1_MASK                 2
#define SCGC2_SPI2_MASK                 4
#define SCGC2_LCD_MASK                  8
#define SCGC2_IRQ_MASK                  16
#define SCGC2_VREF_MASK                 32
#define SCGC2_CLKPRE_MASK               128
#define SCGC2_SPI_MASK                  7
#define SCGC2_SPI_BITNUM                0


/*** SCGC3 - System Clock Gating Control 3 Register; 0x0000180A ***/
typedef union {
  byte Byte;
  struct {
    byte PTA         :1;                                       /* PTA Clock Gate Control */
    byte PTB         :1;                                       /* LCD Clock Gate Control */
    byte PTC         :1;                                       /* PTC Clock Gate Control */
    byte PTD         :1;                                       /* PTD Clock Gate Control */
    byte PTE         :1;                                       /* PTE Clock Gate Control */
    byte PTF         :1;                                       /* PTF Clock Gate Control */
    byte PTG         :1;                                       /* PTG Clock Gate Control */
    byte PTH         :1;                                       /* PTH Clock Gate Control */
  } Bits;
} SCGC3STR;
extern volatile SCGC3STR _SCGC3 @0x0000180A;
#define SCGC3                           _SCGC3.Byte
#define SCGC3_PTA                       _SCGC3.Bits.PTA
#define SCGC3_PTB                       _SCGC3.Bits.PTB
#define SCGC3_PTC                       _SCGC3.Bits.PTC
#define SCGC3_PTD                       _SCGC3.Bits.PTD
#define SCGC3_PTE                       _SCGC3.Bits.PTE
#define SCGC3_PTF                       _SCGC3.Bits.PTF
#define SCGC3_PTG                       _SCGC3.Bits.PTG
#define SCGC3_PTH                       _SCGC3.Bits.PTH

#define SCGC3_PTA_MASK                  1
#define SCGC3_PTB_MASK                  2
#define SCGC3_PTC_MASK                  4
#define SCGC3_PTD_MASK                  8
#define SCGC3_PTE_MASK                  16
#define SCGC3_PTF_MASK                  32
#define SCGC3_PTG_MASK                  64
#define SCGC3_PTH_MASK                  128


/*** SCGC4 - System Clock Gating Control 4 Register; 0x0000180B ***/
typedef union {
  byte Byte;
  struct {
    byte MTIM3       :1;                                       /* MTIM3 Clock Gate Control */
    byte MTIM2       :1;                                       /* MTIM2 Clock Gate Control */
    byte MTIM1       :1;                                       /* MTIM1 Clock Gate Control */
    byte PDB         :1;                                       /* PDB Clock Gate Control */
    byte FTM         :1;                                       /* FTM Clock Gate Control */
    byte CRC         :1;                                       /* CRC Clock Gate Control */
    byte MUXCTRL     :1;                                       /* MUXCTRL Clock Gate Control */
    byte             :1; 
  } Bits;
} SCGC4STR;
extern volatile SCGC4STR _SCGC4 @0x0000180B;
#define SCGC4                           _SCGC4.Byte
#define SCGC4_MTIM3                     _SCGC4.Bits.MTIM3
#define SCGC4_MTIM2                     _SCGC4.Bits.MTIM2
#define SCGC4_MTIM1                     _SCGC4.Bits.MTIM1
#define SCGC4_PDB                       _SCGC4.Bits.PDB
#define SCGC4_FTM                       _SCGC4.Bits.FTM
#define SCGC4_CRC                       _SCGC4.Bits.CRC
#define SCGC4_MUXCTRL                   _SCGC4.Bits.MUXCTRL

#define SCGC4_MTIM3_MASK                1
#define SCGC4_MTIM2_MASK                2
#define SCGC4_MTIM1_MASK                4
#define SCGC4_PDB_MASK                  8
#define SCGC4_FTM_MASK                  16
#define SCGC4_CRC_MASK                  32
#define SCGC4_MUXCTRL_MASK              64


/*** SCGC5 - System Clock Gating Control 5 Register; 0x0000180C ***/
typedef union {
  byte Byte;
  struct {
    byte FLS         :1;                                       /* FLS Clock Gate Control */
    byte             :1; 
    byte PCNT        :1;                                       /* PCNT Clock Gate Control */
    byte IRTC        :1;                                       /* IRTC Clock Gate Control */
    byte BKPT        :1;                                       /* BKPT Clock Gate Control */
    byte PRACMP0     :1;                                       /* PRACMP0 Clock Gate Control */
    byte PRACMP1     :1;                                       /* PRACMP1 Clock Gate Control */
    byte PRACMP2     :1;                                       /* PRACMP2 Clock Gate Control */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpPRACMP :3;
  } MergedBits;
} SCGC5STR;
extern volatile SCGC5STR _SCGC5 @0x0000180C;
#define SCGC5                           _SCGC5.Byte
#define SCGC5_FLS                       _SCGC5.Bits.FLS
#define SCGC5_PCNT                      _SCGC5.Bits.PCNT
#define SCGC5_IRTC                      _SCGC5.Bits.IRTC
#define SCGC5_BKPT                      _SCGC5.Bits.BKPT
#define SCGC5_PRACMP0                   _SCGC5.Bits.PRACMP0
#define SCGC5_PRACMP1                   _SCGC5.Bits.PRACMP1
#define SCGC5_PRACMP2                   _SCGC5.Bits.PRACMP2
#define SCGC5_PRACMP                    _SCGC5.MergedBits.grpPRACMP

#define SCGC5_FLS_MASK                  1
#define SCGC5_PCNT_MASK                 4
#define SCGC5_IRTC_MASK                 8
#define SCGC5_BKPT_MASK                 16
#define SCGC5_PRACMP0_MASK              32
#define SCGC5_PRACMP1_MASK              64
#define SCGC5_PRACMP2_MASK              128
#define SCGC5_PRACMP_MASK               224
#define SCGC5_PRACMP_BITNUM             5


/*** SIMIPS1 - Internal Peripheral Select Register 1; 0x0000180D ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte MTIM2CS     :1;                                       /* MTIM2 External Clock Select */
    byte PCNTSS      :1;                                       /* PCNT Sensor Select */
    byte             :1; 
    byte MTIM3CS     :1;                                       /* MTIM3 External Clock Select */
    byte FTMCS       :2;                                       /* FTM External Clock Select */
  } Bits;
} SIMIPS1STR;
extern volatile SIMIPS1STR _SIMIPS1 @0x0000180D;
#define SIMIPS1                         _SIMIPS1.Byte
#define SIMIPS1_MTIM2CS                 _SIMIPS1.Bits.MTIM2CS
#define SIMIPS1_PCNTSS                  _SIMIPS1.Bits.PCNTSS
#define SIMIPS1_MTIM3CS                 _SIMIPS1.Bits.MTIM3CS
#define SIMIPS1_FTMCS                   _SIMIPS1.Bits.FTMCS

#define SIMIPS1_MTIM2CS_MASK            4
#define SIMIPS1_PCNTSS_MASK             8
#define SIMIPS1_MTIM3CS_MASK            32
#define SIMIPS1_FTMCS_MASK              192
#define SIMIPS1_FTMCS_BITNUM            6


/*** SIMIPS2 - Internal Peripheral Select Register 2; 0x0000180E ***/
typedef union {
  byte Byte;
  struct {
    byte MODTX1      :1;                                       /* Modulate TxD1 */
    byte             :1; 
    byte MTBASE1     :3;                                       /* SCI1 Tx Modulation Time Base Select */
    byte RX1IN       :1;                                       /* SCI1 Rx Input Pin Select */
    byte             :1; 
    byte             :1; 
  } Bits;
} SIMIPS2STR;
extern volatile SIMIPS2STR _SIMIPS2 @0x0000180E;
#define SIMIPS2                         _SIMIPS2.Byte
#define SIMIPS2_MODTX1                  _SIMIPS2.Bits.MODTX1
#define SIMIPS2_MTBASE1                 _SIMIPS2.Bits.MTBASE1
#define SIMIPS2_RX1IN                   _SIMIPS2.Bits.RX1IN

#define SIMIPS2_MODTX1_MASK             1
#define SIMIPS2_MTBASE1_MASK            28
#define SIMIPS2_MTBASE1_BITNUM          2
#define SIMIPS2_RX1IN_MASK              32


/*** SIMIPS3 - Internal Peripheral Select Register 3; 0x0000180F ***/
typedef union {
  byte Byte;
  struct {
    byte MODTX2      :1;                                       /* Modulate Tx2 */
    byte DDRIVE      :1;                                       /* Double Current Drive on TxD2 Enable */
    byte MTBASE2     :3;                                       /* SCI2 Tx Modulation Time Base Select */
    byte RX2IN       :1;                                       /* SCI2 Rx Input Pin Select */
    byte PCNTFCS     :2;                                       /* PCNT Filter Clock Select */
  } Bits;
} SIMIPS3STR;
extern volatile SIMIPS3STR _SIMIPS3 @0x0000180F;
#define SIMIPS3                         _SIMIPS3.Byte
#define SIMIPS3_MODTX2                  _SIMIPS3.Bits.MODTX2
#define SIMIPS3_DDRIVE                  _SIMIPS3.Bits.DDRIVE
#define SIMIPS3_MTBASE2                 _SIMIPS3.Bits.MTBASE2
#define SIMIPS3_RX2IN                   _SIMIPS3.Bits.RX2IN
#define SIMIPS3_PCNTFCS                 _SIMIPS3.Bits.PCNTFCS

#define SIMIPS3_MODTX2_MASK             1
#define SIMIPS3_DDRIVE_MASK             2
#define SIMIPS3_MTBASE2_MASK            28
#define SIMIPS3_MTBASE2_BITNUM          2
#define SIMIPS3_RX2IN_MASK              32
#define SIMIPS3_PCNTFCS_MASK            192
#define SIMIPS3_PCNTFCS_BITNUM          6


/*** SIMCO - SIM Clock Options Register; 0x00001810 ***/
typedef union {
  byte Byte;
  struct {
    byte CS          :4;                                       /* Clock Select for CLKOUT pin */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} SIMCOSTR;
extern volatile SIMCOSTR _SIMCO @0x00001810;
#define SIMCO                           _SIMCO.Byte
#define SIMCO_CS                        _SIMCO.Bits.CS

#define SIMCO_CS_MASK                   15
#define SIMCO_CS_BITNUM                 0


/*** CCSCTRL - Clock Check and Select Control Register; 0x00001814 ***/
typedef union {
  byte Byte;
  struct {
    byte ICS_EXT_CLK_SEL :1; 
    byte CLK_TEST    :1; 
    byte CLK_CHK_EN  :1;                                       /* Clock Check Enable */
    byte             :1; 
    byte OSC2_PRESCALER0 :1;                                   /* Oscillator2 Prescaler, bit 0 */
    byte OSC2_PRESCALER1 :1;                                   /* Oscillator2 Prescaler, bit 1 */
    byte OSC2_PRESCALER2 :1;                                   /* Oscillator2 Prescaler, bit 2 */
    byte OSC2_PRESCALER3 :1;                                   /* Oscillator2 Prescaler, bit 3 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpOSC2_PRESCALER :4;
  } MergedBits;
} CCSCTRLSTR;
extern volatile CCSCTRLSTR _CCSCTRL @0x00001814;
#define CCSCTRL                         _CCSCTRL.Byte
#define CCSCTRL_ICS_EXT_CLK_SEL         _CCSCTRL.Bits.ICS_EXT_CLK_SEL
#define CCSCTRL_CLK_TEST                _CCSCTRL.Bits.CLK_TEST
#define CCSCTRL_CLK_CHK_EN              _CCSCTRL.Bits.CLK_CHK_EN
#define CCSCTRL_OSC2_PRESCALER0         _CCSCTRL.Bits.OSC2_PRESCALER0
#define CCSCTRL_OSC2_PRESCALER1         _CCSCTRL.Bits.OSC2_PRESCALER1
#define CCSCTRL_OSC2_PRESCALER2         _CCSCTRL.Bits.OSC2_PRESCALER2
#define CCSCTRL_OSC2_PRESCALER3         _CCSCTRL.Bits.OSC2_PRESCALER3
#define CCSCTRL_OSC2_PRESCALER          _CCSCTRL.MergedBits.grpOSC2_PRESCALER

#define CCSCTRL_ICS_EXT_CLK_SEL_MASK    1
#define CCSCTRL_CLK_TEST_MASK           2
#define CCSCTRL_CLK_CHK_EN_MASK         4
#define CCSCTRL_OSC2_PRESCALER0_MASK    16
#define CCSCTRL_OSC2_PRESCALER1_MASK    32
#define CCSCTRL_OSC2_PRESCALER2_MASK    64
#define CCSCTRL_OSC2_PRESCALER3_MASK    128
#define CCSCTRL_OSC2_PRESCALER_MASK     240
#define CCSCTRL_OSC2_PRESCALER_BITNUM   4


/*** CCSTMR1 - Clock Check and Select Oscillator1 Timer Register; 0x00001815 ***/
typedef union {
  byte Byte;
  struct {
    byte             :8;                                       /* Oscillator 1 Timer */
  } Bits;
} CCSTMR1STR;
extern volatile CCSTMR1STR _CCSTMR1 @0x00001815;
#define CCSTMR1                         _CCSTMR1.Byte


/*** CCSTMR2 - Clock Check and Select Oscillator2 Timer Register; 0x00001816 ***/
typedef union {
  byte Byte;
  struct {
    byte             :8;                                       /* Oscillator 2 Timer */
  } Bits;
} CCSTMR2STR;
extern volatile CCSTMR2STR _CCSTMR2 @0x00001816;
#define CCSTMR2                         _CCSTMR2.Byte


/*** CCSTMRIR - Clock Check and Select Internal Reference Clock Timer Register; 0x00001817 ***/
typedef union {
  byte Byte;
  struct {
    byte             :8;                                       /* Internal Reference Clock Timer */
  } Bits;
} CCSTMRIRSTR;
extern volatile CCSTMRIRSTR _CCSTMRIR @0x00001817;
#define CCSTMRIR                        _CCSTMRIR.Byte


/*** SPMSC1 - System Power Management Status and Control 1 Register; 0x0000181C ***/
typedef union {
  byte Byte;
  struct {
    byte BGBE        :1;                                       /* Bandgap Buffer Enable */
    byte BGBDS       :1;                                       /* Bandgap Buffer Drive Select */
    byte LVDE        :1;                                       /* Low-Voltage Detect Enable */
    byte LVDSE       :1;                                       /* Low-Voltage Detect Stop Enable */
    byte LVDRE       :1;                                       /* Low-Voltage Detect Reset Enable */
    byte LVDIE       :1;                                       /* Low-Voltage Detect Interrupt Enable */
    byte LVDACK      :1;                                       /* Low-Voltage Detect Acknowledge */
    byte LVDF        :1;                                       /* Low-Voltage Detect Flag */
  } Bits;
} SPMSC1STR;
extern volatile SPMSC1STR _SPMSC1 @0x0000181C;
#define SPMSC1                          _SPMSC1.Byte
#define SPMSC1_BGBE                     _SPMSC1.Bits.BGBE
#define SPMSC1_BGBDS                    _SPMSC1.Bits.BGBDS
#define SPMSC1_LVDE                     _SPMSC1.Bits.LVDE
#define SPMSC1_LVDSE                    _SPMSC1.Bits.LVDSE
#define SPMSC1_LVDRE                    _SPMSC1.Bits.LVDRE
#define SPMSC1_LVDIE                    _SPMSC1.Bits.LVDIE
#define SPMSC1_LVDACK                   _SPMSC1.Bits.LVDACK
#define SPMSC1_LVDF                     _SPMSC1.Bits.LVDF

#define SPMSC1_BGBE_MASK                1
#define SPMSC1_BGBDS_MASK               2
#define SPMSC1_LVDE_MASK                4
#define SPMSC1_LVDSE_MASK               8
#define SPMSC1_LVDRE_MASK               16
#define SPMSC1_LVDIE_MASK               32
#define SPMSC1_LVDACK_MASK              64
#define SPMSC1_LVDF_MASK                128


/*** SPMSC2 - System Power Management Status and Control 2 Register; 0x0000181D ***/
typedef union {
  byte Byte;
  struct {
    byte PPDC        :1;                                       /* Partial Power Down Control */
    byte PPDE        :1;                                       /* Partial Power-Down Enable */
    byte PPDACK      :1;                                       /* Partial Power Down Acknowledge */
    byte PPDF        :1;                                       /* Partial Power Down Flag */
    byte             :1; 
    byte LPWUI       :1;                                       /* Low Power Wake Up on Interrupt */
    byte LPRS        :1;                                       /* Low Power Regulator Status */
    byte LPR         :1;                                       /* Low Power Regulator Control */
  } Bits;
} SPMSC2STR;
extern volatile SPMSC2STR _SPMSC2 @0x0000181D;
#define SPMSC2                          _SPMSC2.Byte
#define SPMSC2_PPDC                     _SPMSC2.Bits.PPDC
#define SPMSC2_PPDE                     _SPMSC2.Bits.PPDE
#define SPMSC2_PPDACK                   _SPMSC2.Bits.PPDACK
#define SPMSC2_PPDF                     _SPMSC2.Bits.PPDF
#define SPMSC2_LPWUI                    _SPMSC2.Bits.LPWUI
#define SPMSC2_LPRS                     _SPMSC2.Bits.LPRS
#define SPMSC2_LPR                      _SPMSC2.Bits.LPR

#define SPMSC2_PPDC_MASK                1
#define SPMSC2_PPDE_MASK                2
#define SPMSC2_PPDACK_MASK              4
#define SPMSC2_PPDF_MASK                8
#define SPMSC2_LPWUI_MASK               32
#define SPMSC2_LPRS_MASK                64
#define SPMSC2_LPR_MASK                 128


/*** SPMSC3 - System Power Management Status and Control 3 Register; 0x0000181E ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte LVWIE       :1;                                       /* Low-Voltage Warning Interrupt Enable */
    byte LVWV        :1;                                       /* Low-Voltage Warning Voltage Select */
    byte LVDV        :1;                                       /* Low-Voltage Detect Voltage Select */
    byte LVWACK      :1;                                       /* Low-Voltage Warning Acknowledge */
    byte LVWF        :1;                                       /* Low-Voltage Warning Flag */
  } Bits;
} SPMSC3STR;
extern volatile SPMSC3STR _SPMSC3 @0x0000181E;
#define SPMSC3                          _SPMSC3.Byte
#define SPMSC3_LVWIE                    _SPMSC3.Bits.LVWIE
#define SPMSC3_LVWV                     _SPMSC3.Bits.LVWV
#define SPMSC3_LVDV                     _SPMSC3.Bits.LVDV
#define SPMSC3_LVWACK                   _SPMSC3.Bits.LVWACK
#define SPMSC3_LVWF                     _SPMSC3.Bits.LVWF

#define SPMSC3_LVWIE_MASK               8
#define SPMSC3_LVWV_MASK                16
#define SPMSC3_LVDV_MASK                32
#define SPMSC3_LVWACK_MASK              64
#define SPMSC3_LVWF_MASK                128


/*** FCDIV - FLASH Clock Divider Register; 0x00001820 ***/
typedef union {
  byte Byte;
  struct {
    byte DIV0        :1;                                       /* Divisor for FLASH Clock Divider, bit 0 */
    byte DIV1        :1;                                       /* Divisor for FLASH Clock Divider, bit 1 */
    byte DIV2        :1;                                       /* Divisor for FLASH Clock Divider, bit 2 */
    byte DIV3        :1;                                       /* Divisor for FLASH Clock Divider, bit 3 */
    byte DIV4        :1;                                       /* Divisor for FLASH Clock Divider, bit 4 */
    byte DIV5        :1;                                       /* Divisor for FLASH Clock Divider, bit 5 */
    byte PRDIV8      :1;                                       /* Prescale (Divide) FLASH Clock by 8 */
    byte DIVLD       :1;                                       /* Divisor Loaded Status Flag */
  } Bits;
  struct {
    byte grpDIV  :6;
    byte grpPRDIV_8 :1;
    byte         :1;
  } MergedBits;
} FCDIVSTR;
extern volatile FCDIVSTR _FCDIV @0x00001820;
#define FCDIV                           _FCDIV.Byte
#define FCDIV_DIV0                      _FCDIV.Bits.DIV0
#define FCDIV_DIV1                      _FCDIV.Bits.DIV1
#define FCDIV_DIV2                      _FCDIV.Bits.DIV2
#define FCDIV_DIV3                      _FCDIV.Bits.DIV3
#define FCDIV_DIV4                      _FCDIV.Bits.DIV4
#define FCDIV_DIV5                      _FCDIV.Bits.DIV5
#define FCDIV_PRDIV8                    _FCDIV.Bits.PRDIV8
#define FCDIV_DIVLD                     _FCDIV.Bits.DIVLD
#define FCDIV_DIV                       _FCDIV.MergedBits.grpDIV

#define FCDIV_DIV0_MASK                 1
#define FCDIV_DIV1_MASK                 2
#define FCDIV_DIV2_MASK                 4
#define FCDIV_DIV3_MASK                 8
#define FCDIV_DIV4_MASK                 16
#define FCDIV_DIV5_MASK                 32
#define FCDIV_PRDIV8_MASK               64
#define FCDIV_DIVLD_MASK                128
#define FCDIV_DIV_MASK                  63
#define FCDIV_DIV_BITNUM                0


/*** FOPT - Flash Options Register; 0x00001821 ***/
typedef union {
  byte Byte;
  struct {
    byte SEC0        :1;                                       /* Flash Security Bit 0 */
    byte SEC1        :1;                                       /* Flash Security Bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte FNORED      :1;                                       /* Vector Redirection Disable */
    byte KEYEN       :1;                                       /* Enable Security Key Writing */
  } Bits;
  struct {
    byte grpSEC  :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} FOPTSTR;
extern volatile FOPTSTR _FOPT @0x00001821;
#define FOPT                            _FOPT.Byte
#define FOPT_SEC0                       _FOPT.Bits.SEC0
#define FOPT_SEC1                       _FOPT.Bits.SEC1
#define FOPT_FNORED                     _FOPT.Bits.FNORED
#define FOPT_KEYEN                      _FOPT.Bits.KEYEN
#define FOPT_SEC                        _FOPT.MergedBits.grpSEC

#define FOPT_SEC0_MASK                  1
#define FOPT_SEC1_MASK                  2
#define FOPT_FNORED_MASK                64
#define FOPT_KEYEN_MASK                 128
#define FOPT_SEC_MASK                   3
#define FOPT_SEC_BITNUM                 0


/*** FCNFG - Flash Configuration Register; 0x00001823 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte KEYACC      :1;                                       /* Enable Security Key Writing */
    byte             :1; 
    byte             :1; 
  } Bits;
} FCNFGSTR;
extern volatile FCNFGSTR _FCNFG @0x00001823;
#define FCNFG                           _FCNFG.Byte
#define FCNFG_KEYACC                    _FCNFG.Bits.KEYACC

#define FCNFG_KEYACC_MASK               32


/*** FPROT - Flash Protection Register; 0x00001824 ***/
typedef union {
  byte Byte;
  struct {
    byte FPDIS       :1;                                       /* Flash Protection Disable */
    byte FPS0        :1;                                       /* Flash Protection Size, bit 0 */
    byte FPS1        :1;                                       /* Flash Protection Size, bit 1 */
    byte FPS2        :1;                                       /* Flash Protection Size, bit 2 */
    byte FPS3        :1;                                       /* Flash Protection Size, bit 3 */
    byte FPS4        :1;                                       /* Flash Protection Size, bit 4 */
    byte FPS5        :1;                                       /* Flash Protection Size, bit 5 */
    byte FPS6        :1;                                       /* Flash Protection Size, bit 6 */
  } Bits;
  struct {
    byte         :1;
    byte grpFPS  :7;
  } MergedBits;
} FPROTSTR;
extern volatile FPROTSTR _FPROT @0x00001824;
#define FPROT                           _FPROT.Byte
#define FPROT_FPDIS                     _FPROT.Bits.FPDIS
#define FPROT_FPS0                      _FPROT.Bits.FPS0
#define FPROT_FPS1                      _FPROT.Bits.FPS1
#define FPROT_FPS2                      _FPROT.Bits.FPS2
#define FPROT_FPS3                      _FPROT.Bits.FPS3
#define FPROT_FPS4                      _FPROT.Bits.FPS4
#define FPROT_FPS5                      _FPROT.Bits.FPS5
#define FPROT_FPS6                      _FPROT.Bits.FPS6
#define FPROT_FPS                       _FPROT.MergedBits.grpFPS

#define FPROT_FPDIS_MASK                1
#define FPROT_FPS0_MASK                 2
#define FPROT_FPS1_MASK                 4
#define FPROT_FPS2_MASK                 8
#define FPROT_FPS3_MASK                 16
#define FPROT_FPS4_MASK                 32
#define FPROT_FPS5_MASK                 64
#define FPROT_FPS6_MASK                 128
#define FPROT_FPS_MASK                  254
#define FPROT_FPS_BITNUM                1


/*** FSTAT - Flash Status Register; 0x00001825 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte FBLANK      :1;                                       /* FLASH Flag Indicating the Erase Verify Operation Status */
    byte             :1; 
    byte FACCERR     :1;                                       /* FLASH Access Error Flag */
    byte FPVIOL      :1;                                       /* FLASH Protection Violation Flag */
    byte FCCF        :1;                                       /* FLASH Command Complete Interrupt Flag */
    byte FCBEF       :1;                                       /* FLASH Command Buffer Empty Flag */
  } Bits;
} FSTATSTR;
extern volatile FSTATSTR _FSTAT @0x00001825;
#define FSTAT                           _FSTAT.Byte
#define FSTAT_FBLANK                    _FSTAT.Bits.FBLANK
#define FSTAT_FACCERR                   _FSTAT.Bits.FACCERR
#define FSTAT_FPVIOL                    _FSTAT.Bits.FPVIOL
#define FSTAT_FCCF                      _FSTAT.Bits.FCCF
#define FSTAT_FCBEF                     _FSTAT.Bits.FCBEF

#define FSTAT_FBLANK_MASK               4
#define FSTAT_FACCERR_MASK              16
#define FSTAT_FPVIOL_MASK               32
#define FSTAT_FCCF_MASK                 64
#define FSTAT_FCBEF_MASK                128


/*** FCMD - Flash Command Register; 0x00001826 ***/
typedef union {
  byte Byte;
  struct {
    byte FCMD0       :1;                                       /* Flash Command, bit 0 */
    byte FCMD1       :1;                                       /* Flash Command, bit 1 */
    byte FCMD2       :1;                                       /* Flash Command, bit 2 */
    byte FCMD3       :1;                                       /* Flash Command, bit 3 */
    byte FCMD4       :1;                                       /* Flash Command, bit 4 */
    byte FCMD5       :1;                                       /* Flash Command, bit 5 */
    byte FCMD6       :1;                                       /* Flash Command, bit 6 */
    byte FCMD7       :1;                                       /* Flash Command, bit 7 */
  } Bits;
} FCMDSTR;
extern volatile FCMDSTR _FCMD @0x00001826;
#define FCMD                            _FCMD.Byte
#define FCMD_FCMD0                      _FCMD.Bits.FCMD0
#define FCMD_FCMD1                      _FCMD.Bits.FCMD1
#define FCMD_FCMD2                      _FCMD.Bits.FCMD2
#define FCMD_FCMD3                      _FCMD.Bits.FCMD3
#define FCMD_FCMD4                      _FCMD.Bits.FCMD4
#define FCMD_FCMD5                      _FCMD.Bits.FCMD5
#define FCMD_FCMD6                      _FCMD.Bits.FCMD6
#define FCMD_FCMD7                      _FCMD.Bits.FCMD7

#define FCMD_FCMD0_MASK                 1
#define FCMD_FCMD1_MASK                 2
#define FCMD_FCMD2_MASK                 4
#define FCMD_FCMD3_MASK                 8
#define FCMD_FCMD4_MASK                 16
#define FCMD_FCMD5_MASK                 32
#define FCMD_FCMD6_MASK                 64
#define FCMD_FCMD7_MASK                 128


/*** BKPTCA_word - Breakpoint Comparator A Register(word access); 0x00001830 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** BKPTCAH - Breakpoint Comparator A High Register; 0x00001830 ***/
    union {
      byte Byte;
      struct {
        byte Bit8        :1;                                       /* Comparator A High Compare Bit 8 */
        byte Bit9        :1;                                       /* Comparator A High Compare Bit 9 */
        byte Bit10       :1;                                       /* Comparator A High Compare Bit 10 */
        byte Bit11       :1;                                       /* Comparator A High Compare Bit 11 */
        byte Bit12       :1;                                       /* Comparator A High Compare Bit 12 */
        byte Bit13       :1;                                       /* Comparator A High Compare Bit 13 */
        byte Bit14       :1;                                       /* Comparator A High Compare Bit 14 */
        byte Bit15       :1;                                       /* Comparator A High Compare Bit 15 */
      } Bits;
    } BKPTCAHSTR;
    #define BKPTCAH                     _BKPTCA_word.Overlap_STR.BKPTCAHSTR.Byte
    #define BKPTCAH_Bit8                _BKPTCA_word.Overlap_STR.BKPTCAHSTR.Bits.Bit8
    #define BKPTCAH_Bit9                _BKPTCA_word.Overlap_STR.BKPTCAHSTR.Bits.Bit9
    #define BKPTCAH_Bit10               _BKPTCA_word.Overlap_STR.BKPTCAHSTR.Bits.Bit10
    #define BKPTCAH_Bit11               _BKPTCA_word.Overlap_STR.BKPTCAHSTR.Bits.Bit11
    #define BKPTCAH_Bit12               _BKPTCA_word.Overlap_STR.BKPTCAHSTR.Bits.Bit12
    #define BKPTCAH_Bit13               _BKPTCA_word.Overlap_STR.BKPTCAHSTR.Bits.Bit13
    #define BKPTCAH_Bit14               _BKPTCA_word.Overlap_STR.BKPTCAHSTR.Bits.Bit14
    #define BKPTCAH_Bit15               _BKPTCA_word.Overlap_STR.BKPTCAHSTR.Bits.Bit15
    
    #define BKPTCAH_Bit8_MASK           1
    #define BKPTCAH_Bit9_MASK           2
    #define BKPTCAH_Bit10_MASK          4
    #define BKPTCAH_Bit11_MASK          8
    #define BKPTCAH_Bit12_MASK          16
    #define BKPTCAH_Bit13_MASK          32
    #define BKPTCAH_Bit14_MASK          64
    #define BKPTCAH_Bit15_MASK          128
    

    /*** BKPTCAL - Breakpoint Comparator A Low Register; 0x00001831 ***/
    union {
      byte Byte;
      struct {
        byte Bit0        :1;                                       /* Comparator A Low Compare Bit 0 */
        byte Bit1        :1;                                       /* Comparator A Low Compare Bit 1 */
        byte Bit2        :1;                                       /* Comparator A Low Compare Bit 2 */
        byte Bit3        :1;                                       /* Comparator A Low Compare Bit 3 */
        byte Bit4        :1;                                       /* Comparator A Low Compare Bit 4 */
        byte Bit5        :1;                                       /* Comparator A Low Compare Bit 5 */
        byte Bit6        :1;                                       /* Comparator A Low Compare Bit 6 */
        byte Bit7        :1;                                       /* Comparator A Low Compare Bit 7 */
      } Bits;
    } BKPTCALSTR;
    #define BKPTCAL                     _BKPTCA_word.Overlap_STR.BKPTCALSTR.Byte
    #define BKPTCAL_Bit0                _BKPTCA_word.Overlap_STR.BKPTCALSTR.Bits.Bit0
    #define BKPTCAL_Bit1                _BKPTCA_word.Overlap_STR.BKPTCALSTR.Bits.Bit1
    #define BKPTCAL_Bit2                _BKPTCA_word.Overlap_STR.BKPTCALSTR.Bits.Bit2
    #define BKPTCAL_Bit3                _BKPTCA_word.Overlap_STR.BKPTCALSTR.Bits.Bit3
    #define BKPTCAL_Bit4                _BKPTCA_word.Overlap_STR.BKPTCALSTR.Bits.Bit4
    #define BKPTCAL_Bit5                _BKPTCA_word.Overlap_STR.BKPTCALSTR.Bits.Bit5
    #define BKPTCAL_Bit6                _BKPTCA_word.Overlap_STR.BKPTCALSTR.Bits.Bit6
    #define BKPTCAL_Bit7                _BKPTCA_word.Overlap_STR.BKPTCALSTR.Bits.Bit7
    
    #define BKPTCAL_Bit0_MASK           1
    #define BKPTCAL_Bit1_MASK           2
    #define BKPTCAL_Bit2_MASK           4
    #define BKPTCAL_Bit3_MASK           8
    #define BKPTCAL_Bit4_MASK           16
    #define BKPTCAL_Bit5_MASK           32
    #define BKPTCAL_Bit6_MASK           64
    #define BKPTCAL_Bit7_MASK           128
    
  } Overlap_STR;

} BKPTCA_wordSTR;
extern volatile BKPTCA_wordSTR _BKPTCA_word @0x00001830;
#define BKPTCA_word                     _BKPTCA_word.Word


/*** BKPTCB_word - Breakpoint Comparator B Register(word access); 0x00001832 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** BKPTCBH - Breakpoint Comparator B High Register; 0x00001832 ***/
    union {
      byte Byte;
      struct {
        byte Bit8        :1;                                       /* Comparator B High Compare Bit 8 */
        byte Bit9        :1;                                       /* Comparator B High Compare Bit 9 */
        byte Bit10       :1;                                       /* Comparator B High Compare Bit 10 */
        byte Bit11       :1;                                       /* Comparator B High Compare Bit 11 */
        byte Bit12       :1;                                       /* Comparator B High Compare Bit 12 */
        byte Bit13       :1;                                       /* Comparator B High Compare Bit 13 */
        byte Bit14       :1;                                       /* Comparator B High Compare Bit 14 */
        byte Bit15       :1;                                       /* Comparator B High Compare Bit 15 */
      } Bits;
    } BKPTCBHSTR;
    #define BKPTCBH                     _BKPTCB_word.Overlap_STR.BKPTCBHSTR.Byte
    #define BKPTCBH_Bit8                _BKPTCB_word.Overlap_STR.BKPTCBHSTR.Bits.Bit8
    #define BKPTCBH_Bit9                _BKPTCB_word.Overlap_STR.BKPTCBHSTR.Bits.Bit9
    #define BKPTCBH_Bit10               _BKPTCB_word.Overlap_STR.BKPTCBHSTR.Bits.Bit10
    #define BKPTCBH_Bit11               _BKPTCB_word.Overlap_STR.BKPTCBHSTR.Bits.Bit11
    #define BKPTCBH_Bit12               _BKPTCB_word.Overlap_STR.BKPTCBHSTR.Bits.Bit12
    #define BKPTCBH_Bit13               _BKPTCB_word.Overlap_STR.BKPTCBHSTR.Bits.Bit13
    #define BKPTCBH_Bit14               _BKPTCB_word.Overlap_STR.BKPTCBHSTR.Bits.Bit14
    #define BKPTCBH_Bit15               _BKPTCB_word.Overlap_STR.BKPTCBHSTR.Bits.Bit15
    
    #define BKPTCBH_Bit8_MASK           1
    #define BKPTCBH_Bit9_MASK           2
    #define BKPTCBH_Bit10_MASK          4
    #define BKPTCBH_Bit11_MASK          8
    #define BKPTCBH_Bit12_MASK          16
    #define BKPTCBH_Bit13_MASK          32
    #define BKPTCBH_Bit14_MASK          64
    #define BKPTCBH_Bit15_MASK          128
    

    /*** BKPTCBL - Breakpoint Comparator B Low Register; 0x00001833 ***/
    union {
      byte Byte;
      struct {
        byte Bit0        :1;                                       /* Comparator B Low Compare Bit 0 */
        byte Bit1        :1;                                       /* Comparator B Low Compare Bit 1 */
        byte Bit2        :1;                                       /* Comparator B Low Compare Bit 2 */
        byte Bit3        :1;                                       /* Comparator B Low Compare Bit 3 */
        byte Bit4        :1;                                       /* Comparator B Low Compare Bit 4 */
        byte Bit5        :1;                                       /* Comparator B Low Compare Bit 5 */
        byte Bit6        :1;                                       /* Comparator B Low Compare Bit 6 */
        byte Bit7        :1;                                       /* Comparator B Low Compare Bit 7 */
      } Bits;
    } BKPTCBLSTR;
    #define BKPTCBL                     _BKPTCB_word.Overlap_STR.BKPTCBLSTR.Byte
    #define BKPTCBL_Bit0                _BKPTCB_word.Overlap_STR.BKPTCBLSTR.Bits.Bit0
    #define BKPTCBL_Bit1                _BKPTCB_word.Overlap_STR.BKPTCBLSTR.Bits.Bit1
    #define BKPTCBL_Bit2                _BKPTCB_word.Overlap_STR.BKPTCBLSTR.Bits.Bit2
    #define BKPTCBL_Bit3                _BKPTCB_word.Overlap_STR.BKPTCBLSTR.Bits.Bit3
    #define BKPTCBL_Bit4                _BKPTCB_word.Overlap_STR.BKPTCBLSTR.Bits.Bit4
    #define BKPTCBL_Bit5                _BKPTCB_word.Overlap_STR.BKPTCBLSTR.Bits.Bit5
    #define BKPTCBL_Bit6                _BKPTCB_word.Overlap_STR.BKPTCBLSTR.Bits.Bit6
    #define BKPTCBL_Bit7                _BKPTCB_word.Overlap_STR.BKPTCBLSTR.Bits.Bit7
    
    #define BKPTCBL_Bit0_MASK           1
    #define BKPTCBL_Bit1_MASK           2
    #define BKPTCBL_Bit2_MASK           4
    #define BKPTCBL_Bit3_MASK           8
    #define BKPTCBL_Bit4_MASK           16
    #define BKPTCBL_Bit5_MASK           32
    #define BKPTCBL_Bit6_MASK           64
    #define BKPTCBL_Bit7_MASK           128
    
  } Overlap_STR;

} BKPTCB_wordSTR;
extern volatile BKPTCB_wordSTR _BKPTCB_word @0x00001832;
#define BKPTCB_word                     _BKPTCB_word.Word


/*** BKPTCC_word - Breakpoint Comparator C Register(word access); 0x00001834 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** BKPTCCH - Breakpoint Comparator C High Register; 0x00001834 ***/
    union {
      byte Byte;
      struct {
        byte Bit8        :1;                                       /* Comparator C High Compare Bit 8 */
        byte Bit9        :1;                                       /* Comparator C High Compare Bit 9 */
        byte Bit10       :1;                                       /* Comparator C High Compare Bit 10 */
        byte Bit11       :1;                                       /* Comparator C High Compare Bit 11 */
        byte Bit12       :1;                                       /* Comparator C High Compare Bit 12 */
        byte Bit13       :1;                                       /* Comparator C High Compare Bit 13 */
        byte Bit14       :1;                                       /* Comparator C High Compare Bit 14 */
        byte Bit15       :1;                                       /* Comparator C High Compare Bit 15 */
      } Bits;
    } BKPTCCHSTR;
    #define BKPTCCH                     _BKPTCC_word.Overlap_STR.BKPTCCHSTR.Byte
    #define BKPTCCH_Bit8                _BKPTCC_word.Overlap_STR.BKPTCCHSTR.Bits.Bit8
    #define BKPTCCH_Bit9                _BKPTCC_word.Overlap_STR.BKPTCCHSTR.Bits.Bit9
    #define BKPTCCH_Bit10               _BKPTCC_word.Overlap_STR.BKPTCCHSTR.Bits.Bit10
    #define BKPTCCH_Bit11               _BKPTCC_word.Overlap_STR.BKPTCCHSTR.Bits.Bit11
    #define BKPTCCH_Bit12               _BKPTCC_word.Overlap_STR.BKPTCCHSTR.Bits.Bit12
    #define BKPTCCH_Bit13               _BKPTCC_word.Overlap_STR.BKPTCCHSTR.Bits.Bit13
    #define BKPTCCH_Bit14               _BKPTCC_word.Overlap_STR.BKPTCCHSTR.Bits.Bit14
    #define BKPTCCH_Bit15               _BKPTCC_word.Overlap_STR.BKPTCCHSTR.Bits.Bit15
    
    #define BKPTCCH_Bit8_MASK           1
    #define BKPTCCH_Bit9_MASK           2
    #define BKPTCCH_Bit10_MASK          4
    #define BKPTCCH_Bit11_MASK          8
    #define BKPTCCH_Bit12_MASK          16
    #define BKPTCCH_Bit13_MASK          32
    #define BKPTCCH_Bit14_MASK          64
    #define BKPTCCH_Bit15_MASK          128
    

    /*** BKPTCCL - Breakpoint Comparator C Low Register; 0x00001835 ***/
    union {
      byte Byte;
      struct {
        byte Bit0        :1;                                       /* Comparator C Low Compare Bit 0 */
        byte Bit1        :1;                                       /* Comparator C Low Compare Bit 1 */
        byte Bit2        :1;                                       /* Comparator C Low Compare Bit 2 */
        byte Bit3        :1;                                       /* Comparator C Low Compare Bit 3 */
        byte Bit4        :1;                                       /* Comparator C Low Compare Bit 4 */
        byte Bit5        :1;                                       /* Comparator C Low Compare Bit 5 */
        byte Bit6        :1;                                       /* Comparator C Low Compare Bit 6 */
        byte Bit7        :1;                                       /* Comparator C Low Compare Bit 7 */
      } Bits;
    } BKPTCCLSTR;
    #define BKPTCCL                     _BKPTCC_word.Overlap_STR.BKPTCCLSTR.Byte
    #define BKPTCCL_Bit0                _BKPTCC_word.Overlap_STR.BKPTCCLSTR.Bits.Bit0
    #define BKPTCCL_Bit1                _BKPTCC_word.Overlap_STR.BKPTCCLSTR.Bits.Bit1
    #define BKPTCCL_Bit2                _BKPTCC_word.Overlap_STR.BKPTCCLSTR.Bits.Bit2
    #define BKPTCCL_Bit3                _BKPTCC_word.Overlap_STR.BKPTCCLSTR.Bits.Bit3
    #define BKPTCCL_Bit4                _BKPTCC_word.Overlap_STR.BKPTCCLSTR.Bits.Bit4
    #define BKPTCCL_Bit5                _BKPTCC_word.Overlap_STR.BKPTCCLSTR.Bits.Bit5
    #define BKPTCCL_Bit6                _BKPTCC_word.Overlap_STR.BKPTCCLSTR.Bits.Bit6
    #define BKPTCCL_Bit7                _BKPTCC_word.Overlap_STR.BKPTCCLSTR.Bits.Bit7
    
    #define BKPTCCL_Bit0_MASK           1
    #define BKPTCCL_Bit1_MASK           2
    #define BKPTCCL_Bit2_MASK           4
    #define BKPTCCL_Bit3_MASK           8
    #define BKPTCCL_Bit4_MASK           16
    #define BKPTCCL_Bit5_MASK           32
    #define BKPTCCL_Bit6_MASK           64
    #define BKPTCCL_Bit7_MASK           128
    
  } Overlap_STR;

} BKPTCC_wordSTR;
extern volatile BKPTCC_wordSTR _BKPTCC_word @0x00001834;
#define BKPTCC_word                     _BKPTCC_word.Word


/*** BKPTAC - Breakpoint Comparator A Control Register; 0x00001836 ***/
typedef union {
  byte Byte;
  struct {
    byte FMDC        :1;                                       /* Full Mode Data Condition */
    byte FMEN        :1;                                       /* Full Mode Enable Bit */
    byte             :1; 
    byte PAGESELA    :1;                                       /* Comparator A Page Select Bit */
    byte TAGA        :1;                                       /* Tag or Force Bit */
    byte RWA         :1;                                       /* Read/Write Comparator A Value Bit */
    byte RWAEN       :1;                                       /* Read/Write Comparator A Enable Bit */
    byte BKPTAEN     :1;                                       /* BKPT A Enable Bit */
  } Bits;
} BKPTACSTR;
extern volatile BKPTACSTR _BKPTAC @0x00001836;
#define BKPTAC                          _BKPTAC.Byte
#define BKPTAC_FMDC                     _BKPTAC.Bits.FMDC
#define BKPTAC_FMEN                     _BKPTAC.Bits.FMEN
#define BKPTAC_PAGESELA                 _BKPTAC.Bits.PAGESELA
#define BKPTAC_TAGA                     _BKPTAC.Bits.TAGA
#define BKPTAC_RWA                      _BKPTAC.Bits.RWA
#define BKPTAC_RWAEN                    _BKPTAC.Bits.RWAEN
#define BKPTAC_BKPTAEN                  _BKPTAC.Bits.BKPTAEN

#define BKPTAC_FMDC_MASK                1
#define BKPTAC_FMEN_MASK                2
#define BKPTAC_PAGESELA_MASK            8
#define BKPTAC_TAGA_MASK                16
#define BKPTAC_RWA_MASK                 32
#define BKPTAC_RWAEN_MASK               64
#define BKPTAC_BKPTAEN_MASK             128


/*** BKPTBC - Breakpoint Comparator B Control Register; 0x00001837 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte PAGESELB    :1;                                       /* Comparator B Page Select Bit */
    byte TAGB        :1;                                       /* Tag or Force Bit */
    byte RWB         :1;                                       /* Read/Write Comparator B Value Bit */
    byte RWBEN       :1;                                       /* Read/Write Comparator B Enable Bit */
    byte BKPTBEN     :1;                                       /* BKPT B Enable Bit */
  } Bits;
} BKPTBCSTR;
extern volatile BKPTBCSTR _BKPTBC @0x00001837;
#define BKPTBC                          _BKPTBC.Byte
#define BKPTBC_PAGESELB                 _BKPTBC.Bits.PAGESELB
#define BKPTBC_TAGB                     _BKPTBC.Bits.TAGB
#define BKPTBC_RWB                      _BKPTBC.Bits.RWB
#define BKPTBC_RWBEN                    _BKPTBC.Bits.RWBEN
#define BKPTBC_BKPTBEN                  _BKPTBC.Bits.BKPTBEN

#define BKPTBC_PAGESELB_MASK            8
#define BKPTBC_TAGB_MASK                16
#define BKPTBC_RWB_MASK                 32
#define BKPTBC_RWBEN_MASK               64
#define BKPTBC_BKPTBEN_MASK             128


/*** BKPTBCC - Breakpoint Comparator C Control Register; 0x00001838 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte PAGESELC    :1;                                       /* Comparator C Page Select Bit */
    byte TAGC        :1;                                       /* Tag or Force Bit */
    byte RWC         :1;                                       /* Read/Write Comparator C Value Bit */
    byte RWCEN       :1;                                       /* Read/Write Comparator C Enable Bit */
    byte BKPTCEN     :1;                                       /* BKPT C Enable Bit */
  } Bits;
} BKPTBCCSTR;
extern volatile BKPTBCCSTR _BKPTBCC @0x00001838;
#define BKPTBCC                         _BKPTBCC.Byte
#define BKPTBCC_PAGESELC                _BKPTBCC.Bits.PAGESELC
#define BKPTBCC_TAGC                    _BKPTBCC.Bits.TAGC
#define BKPTBCC_RWC                     _BKPTBCC.Bits.RWC
#define BKPTBCC_RWCEN                   _BKPTBCC.Bits.RWCEN
#define BKPTBCC_BKPTCEN                 _BKPTBCC.Bits.BKPTCEN

#define BKPTBCC_PAGESELC_MASK           8
#define BKPTBCC_TAGC_MASK               16
#define BKPTBCC_RWC_MASK                32
#define BKPTBCC_RWCEN_MASK              64
#define BKPTBCC_BKPTCEN_MASK            128


/*** BKPTS - Breakpoint Status Register; 0x00001839 ***/
typedef union {
  byte Byte;
  struct {
    byte CF          :1;                                       /* Comparator C Match Bit */
    byte BF          :1;                                       /* Comparator B Match Bit */
    byte AF          :1;                                       /* Comparator A Match Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} BKPTSSTR;
extern volatile BKPTSSTR _BKPTS @0x00001839;
#define BKPTS                           _BKPTS.Byte
#define BKPTS_CF                        _BKPTS.Bits.CF
#define BKPTS_BF                        _BKPTS.Bits.BF
#define BKPTS_AF                        _BKPTS.Bits.AF

#define BKPTS_CF_MASK                   1
#define BKPTS_BF_MASK                   2
#define BKPTS_AF_MASK                   4


/*** ICSC1 - ICS Control Register 1; 0x0000183C ***/
typedef union {
  byte Byte;
  struct {
    byte IREFSTEN    :1;                                       /* Internal Reference Stop Enable */
    byte IRCLKEN     :1;                                       /* Internal Reference Clock Enable */
    byte IREFS       :1;                                       /* Internal Reference Select */
    byte RDIV0       :1;                                       /* Reference Divider, bit 0 */
    byte RDIV1       :1;                                       /* Reference Divider, bit 1 */
    byte RDIV2       :1;                                       /* Reference Divider, bit 2 */
    byte CLKS0       :1;                                       /* Clock Source Select, bit 0 */
    byte CLKS1       :1;                                       /* Clock Source Select, bit 1 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpRDIV :3;
    byte grpCLKS :2;
  } MergedBits;
} ICSC1STR;
extern volatile ICSC1STR _ICSC1 @0x0000183C;
#define ICSC1                           _ICSC1.Byte
#define ICSC1_IREFSTEN                  _ICSC1.Bits.IREFSTEN
#define ICSC1_IRCLKEN                   _ICSC1.Bits.IRCLKEN
#define ICSC1_IREFS                     _ICSC1.Bits.IREFS
#define ICSC1_RDIV0                     _ICSC1.Bits.RDIV0
#define ICSC1_RDIV1                     _ICSC1.Bits.RDIV1
#define ICSC1_RDIV2                     _ICSC1.Bits.RDIV2
#define ICSC1_CLKS0                     _ICSC1.Bits.CLKS0
#define ICSC1_CLKS1                     _ICSC1.Bits.CLKS1
#define ICSC1_RDIV                      _ICSC1.MergedBits.grpRDIV
#define ICSC1_CLKS                      _ICSC1.MergedBits.grpCLKS

#define ICSC1_IREFSTEN_MASK             1
#define ICSC1_IRCLKEN_MASK              2
#define ICSC1_IREFS_MASK                4
#define ICSC1_RDIV0_MASK                8
#define ICSC1_RDIV1_MASK                16
#define ICSC1_RDIV2_MASK                32
#define ICSC1_CLKS0_MASK                64
#define ICSC1_CLKS1_MASK                128
#define ICSC1_RDIV_MASK                 56
#define ICSC1_RDIV_BITNUM               3
#define ICSC1_CLKS_MASK                 192
#define ICSC1_CLKS_BITNUM               6


/*** ICSC2 - ICS Control Register 2; 0x0000183D ***/
typedef union {
  byte Byte;
  struct {
    byte EREFSTEN    :1;                                       /* External Reference Stop Enable */
    byte ERCLKEN     :1;                                       /* External Reference Enable */
    byte EREFS       :1;                                       /* External Reference Select */
    byte LP          :1;                                       /* Low Power Select */
    byte HGO         :1;                                       /* High Gain Oscillator Select */
    byte RANGE       :1;                                       /* Frequency Range Select */
    byte BDIV0       :1;                                       /* Bus Frequency Divider, bit 0 */
    byte BDIV1       :1;                                       /* Bus Frequency Divider, bit 1 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpBDIV :2;
  } MergedBits;
} ICSC2STR;
extern volatile ICSC2STR _ICSC2 @0x0000183D;
#define ICSC2                           _ICSC2.Byte
#define ICSC2_EREFSTEN                  _ICSC2.Bits.EREFSTEN
#define ICSC2_ERCLKEN                   _ICSC2.Bits.ERCLKEN
#define ICSC2_EREFS                     _ICSC2.Bits.EREFS
#define ICSC2_LP                        _ICSC2.Bits.LP
#define ICSC2_HGO                       _ICSC2.Bits.HGO
#define ICSC2_RANGE                     _ICSC2.Bits.RANGE
#define ICSC2_BDIV0                     _ICSC2.Bits.BDIV0
#define ICSC2_BDIV1                     _ICSC2.Bits.BDIV1
#define ICSC2_BDIV                      _ICSC2.MergedBits.grpBDIV

#define ICSC2_EREFSTEN_MASK             1
#define ICSC2_ERCLKEN_MASK              2
#define ICSC2_EREFS_MASK                4
#define ICSC2_LP_MASK                   8
#define ICSC2_HGO_MASK                  16
#define ICSC2_RANGE_MASK                32
#define ICSC2_BDIV0_MASK                64
#define ICSC2_BDIV1_MASK                128
#define ICSC2_BDIV_MASK                 192
#define ICSC2_BDIV_BITNUM               6


/*** ICSTRM - ICS Trim Register; 0x0000183E ***/
typedef union {
  byte Byte;
  struct {
    byte TRIM0       :1;                                       /* ICS Trim Setting, bit 0 */
    byte TRIM1       :1;                                       /* ICS Trim Setting, bit 1 */
    byte TRIM2       :1;                                       /* ICS Trim Setting, bit 2 */
    byte TRIM3       :1;                                       /* ICS Trim Setting, bit 3 */
    byte TRIM4       :1;                                       /* ICS Trim Setting, bit 4 */
    byte TRIM5       :1;                                       /* ICS Trim Setting, bit 5 */
    byte TRIM6       :1;                                       /* ICS Trim Setting, bit 6 */
    byte TRIM7       :1;                                       /* ICS Trim Setting, bit 7 */
  } Bits;
} ICSTRMSTR;
extern volatile ICSTRMSTR _ICSTRM @0x0000183E;
#define ICSTRM                          _ICSTRM.Byte
#define ICSTRM_TRIM0                    _ICSTRM.Bits.TRIM0
#define ICSTRM_TRIM1                    _ICSTRM.Bits.TRIM1
#define ICSTRM_TRIM2                    _ICSTRM.Bits.TRIM2
#define ICSTRM_TRIM3                    _ICSTRM.Bits.TRIM3
#define ICSTRM_TRIM4                    _ICSTRM.Bits.TRIM4
#define ICSTRM_TRIM5                    _ICSTRM.Bits.TRIM5
#define ICSTRM_TRIM6                    _ICSTRM.Bits.TRIM6
#define ICSTRM_TRIM7                    _ICSTRM.Bits.TRIM7

#define ICSTRM_TRIM0_MASK               1
#define ICSTRM_TRIM1_MASK               2
#define ICSTRM_TRIM2_MASK               4
#define ICSTRM_TRIM3_MASK               8
#define ICSTRM_TRIM4_MASK               16
#define ICSTRM_TRIM5_MASK               32
#define ICSTRM_TRIM6_MASK               64
#define ICSTRM_TRIM7_MASK               128


/*** ICSSC - ICS Status and Control Register; 0x0000183F ***/
typedef union {
  byte Byte;
  struct {
    byte FTRIM       :1;                                       /* ICS Fine Trim */
    byte OSCINIT     :1;                                       /* OSC Initialization */
    byte CLKST0      :1;                                       /* Clock Mode Status, bit 0 */
    byte CLKST1      :1;                                       /* Clock Mode Status, bit 1 */
    byte IREFST      :1;                                       /* Internal Reference Status */
    byte DMX32       :1;                                       /* DCO Maximum frequency with 32.768 kHz reference */
    byte DRST_DRS0   :1;                                       /* DCO Range Status/Range Select, bit 0 */
    byte DRST_DRS1   :1;                                       /* DCO Range Status/Range Select, bit 1 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpCLKST :2;
    byte         :1;
    byte grpDMX_32 :1;
    byte grpDRST_DRS :2;
  } MergedBits;
} ICSSCSTR;
extern volatile ICSSCSTR _ICSSC @0x0000183F;
#define ICSSC                           _ICSSC.Byte
#define ICSSC_FTRIM                     _ICSSC.Bits.FTRIM
#define ICSSC_OSCINIT                   _ICSSC.Bits.OSCINIT
#define ICSSC_CLKST0                    _ICSSC.Bits.CLKST0
#define ICSSC_CLKST1                    _ICSSC.Bits.CLKST1
#define ICSSC_IREFST                    _ICSSC.Bits.IREFST
#define ICSSC_DMX32                     _ICSSC.Bits.DMX32
#define ICSSC_DRST_DRS0                 _ICSSC.Bits.DRST_DRS0
#define ICSSC_DRST_DRS1                 _ICSSC.Bits.DRST_DRS1
#define ICSSC_CLKST                     _ICSSC.MergedBits.grpCLKST
#define ICSSC_DRST_DRS                  _ICSSC.MergedBits.grpDRST_DRS

#define ICSSC_FTRIM_MASK                1
#define ICSSC_OSCINIT_MASK              2
#define ICSSC_CLKST0_MASK               4
#define ICSSC_CLKST1_MASK               8
#define ICSSC_IREFST_MASK               16
#define ICSSC_DMX32_MASK                32
#define ICSSC_DRST_DRS0_MASK            64
#define ICSSC_DRST_DRS1_MASK            128
#define ICSSC_CLKST_MASK                12
#define ICSSC_CLKST_BITNUM              2
#define ICSSC_DRST_DRS_MASK             192
#define ICSSC_DRST_DRS_BITNUM           6


/*** ADC0CV1 - Compare Value 1 Register; 0x00001840 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ADC0CV1H - Compare Value 1 High Register; 0x00001840 ***/
    union {
      byte Byte;
      struct {
        byte CV18        :1;                                       /* Compare Function Value 8 */
        byte CV19        :1;                                       /* Compare Function Value 9 */
        byte CV110       :1;                                       /* Compare Function Value 10 */
        byte CV111       :1;                                       /* Compare Function Value 11 */
        byte CV112       :1;                                       /* Compare Function Value 12 */
        byte CV113       :1;                                       /* Compare Function Value 13 */
        byte CV114       :1;                                       /* Compare Function Value 14 */
        byte CV115       :1;                                       /* Compare Function Value 15 */
      } Bits;
      struct {
        byte grpCV_18 :2;
        byte grpCV1_10 :6;
      } MergedBits;
    } ADC0CV1HSTR;
    #define ADC0CV1H                    _ADC0CV1.Overlap_STR.ADC0CV1HSTR.Byte
    #define ADC0CV1H_CV18               _ADC0CV1.Overlap_STR.ADC0CV1HSTR.Bits.CV18
    #define ADC0CV1H_CV19               _ADC0CV1.Overlap_STR.ADC0CV1HSTR.Bits.CV19
    #define ADC0CV1H_CV110              _ADC0CV1.Overlap_STR.ADC0CV1HSTR.Bits.CV110
    #define ADC0CV1H_CV111              _ADC0CV1.Overlap_STR.ADC0CV1HSTR.Bits.CV111
    #define ADC0CV1H_CV112              _ADC0CV1.Overlap_STR.ADC0CV1HSTR.Bits.CV112
    #define ADC0CV1H_CV113              _ADC0CV1.Overlap_STR.ADC0CV1HSTR.Bits.CV113
    #define ADC0CV1H_CV114              _ADC0CV1.Overlap_STR.ADC0CV1HSTR.Bits.CV114
    #define ADC0CV1H_CV115              _ADC0CV1.Overlap_STR.ADC0CV1HSTR.Bits.CV115
    #define ADC0CV1H_CV_18              _ADC0CV1.Overlap_STR.ADC0CV1HSTR.MergedBits.grpCV_18
    #define ADC0CV1H_CV1_10             _ADC0CV1.Overlap_STR.ADC0CV1HSTR.MergedBits.grpCV1_10
    #define ADC0CV1H_CV                 ADC0CV1H_CV_18
    #define ADC0CV1H_CV1                ADC0CV1H_CV1_10
    
    #define ADC0CV1H_CV18_MASK          1
    #define ADC0CV1H_CV19_MASK          2
    #define ADC0CV1H_CV110_MASK         4
    #define ADC0CV1H_CV111_MASK         8
    #define ADC0CV1H_CV112_MASK         16
    #define ADC0CV1H_CV113_MASK         32
    #define ADC0CV1H_CV114_MASK         64
    #define ADC0CV1H_CV115_MASK         128
    #define ADC0CV1H_CV_18_MASK         3
    #define ADC0CV1H_CV_18_BITNUM       0
    #define ADC0CV1H_CV1_10_MASK        252
    #define ADC0CV1H_CV1_10_BITNUM      2
    

    /*** ADC0CV1L - Compare Value 1 Low Register; 0x00001841 ***/
    union {
      byte Byte;
      struct {
        byte CV10        :1;                                       /* Compare Function Value 0 */
        byte CV11        :1;                                       /* Compare Function Value 1 */
        byte CV12        :1;                                       /* Compare Function Value 2 */
        byte CV13        :1;                                       /* Compare Function Value 3 */
        byte CV14        :1;                                       /* Compare Function Value 4 */
        byte CV15        :1;                                       /* Compare Function Value 5 */
        byte CV16        :1;                                       /* Compare Function Value 6 */
        byte CV17        :1;                                       /* Compare Function Value 7 */
      } Bits;
    } ADC0CV1LSTR;
    #define ADC0CV1L                    _ADC0CV1.Overlap_STR.ADC0CV1LSTR.Byte
    #define ADC0CV1L_CV10               _ADC0CV1.Overlap_STR.ADC0CV1LSTR.Bits.CV10
    #define ADC0CV1L_CV11               _ADC0CV1.Overlap_STR.ADC0CV1LSTR.Bits.CV11
    #define ADC0CV1L_CV12               _ADC0CV1.Overlap_STR.ADC0CV1LSTR.Bits.CV12
    #define ADC0CV1L_CV13               _ADC0CV1.Overlap_STR.ADC0CV1LSTR.Bits.CV13
    #define ADC0CV1L_CV14               _ADC0CV1.Overlap_STR.ADC0CV1LSTR.Bits.CV14
    #define ADC0CV1L_CV15               _ADC0CV1.Overlap_STR.ADC0CV1LSTR.Bits.CV15
    #define ADC0CV1L_CV16               _ADC0CV1.Overlap_STR.ADC0CV1LSTR.Bits.CV16
    #define ADC0CV1L_CV17               _ADC0CV1.Overlap_STR.ADC0CV1LSTR.Bits.CV17
    
    #define ADC0CV1L_CV10_MASK          1
    #define ADC0CV1L_CV11_MASK          2
    #define ADC0CV1L_CV12_MASK          4
    #define ADC0CV1L_CV13_MASK          8
    #define ADC0CV1L_CV14_MASK          16
    #define ADC0CV1L_CV15_MASK          32
    #define ADC0CV1L_CV16_MASK          64
    #define ADC0CV1L_CV17_MASK          128
    
  } Overlap_STR;

} ADC0CV1STR;
extern volatile ADC0CV1STR _ADC0CV1 @0x00001840;
#define ADC0CV1                         _ADC0CV1.Word


/*** ADC0CV2 - Compare Value 2 Register; 0x00001842 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ADC0CV2H - Compare Value 2 High Register; 0x00001842 ***/
    union {
      byte Byte;
      struct {
        byte CV28        :1;                                       /* Compare Function Value 8 */
        byte CV29        :1;                                       /* Compare Function Value 9 */
        byte CV210       :1;                                       /* Compare Function Value 10 */
        byte CV211       :1;                                       /* Compare Function Value 11 */
        byte CV212       :1;                                       /* Compare Function Value 12 */
        byte CV213       :1;                                       /* Compare Function Value 13 */
        byte CV214       :1;                                       /* Compare Function Value 14 */
        byte CV215       :1;                                       /* Compare Function Value 15 */
      } Bits;
      struct {
        byte grpCV_28 :2;
        byte grpCV2_10 :6;
      } MergedBits;
    } ADC0CV2HSTR;
    #define ADC0CV2H                    _ADC0CV2.Overlap_STR.ADC0CV2HSTR.Byte
    #define ADC0CV2H_CV28               _ADC0CV2.Overlap_STR.ADC0CV2HSTR.Bits.CV28
    #define ADC0CV2H_CV29               _ADC0CV2.Overlap_STR.ADC0CV2HSTR.Bits.CV29
    #define ADC0CV2H_CV210              _ADC0CV2.Overlap_STR.ADC0CV2HSTR.Bits.CV210
    #define ADC0CV2H_CV211              _ADC0CV2.Overlap_STR.ADC0CV2HSTR.Bits.CV211
    #define ADC0CV2H_CV212              _ADC0CV2.Overlap_STR.ADC0CV2HSTR.Bits.CV212
    #define ADC0CV2H_CV213              _ADC0CV2.Overlap_STR.ADC0CV2HSTR.Bits.CV213
    #define ADC0CV2H_CV214              _ADC0CV2.Overlap_STR.ADC0CV2HSTR.Bits.CV214
    #define ADC0CV2H_CV215              _ADC0CV2.Overlap_STR.ADC0CV2HSTR.Bits.CV215
    #define ADC0CV2H_CV_28              _ADC0CV2.Overlap_STR.ADC0CV2HSTR.MergedBits.grpCV_28
    #define ADC0CV2H_CV2_10             _ADC0CV2.Overlap_STR.ADC0CV2HSTR.MergedBits.grpCV2_10
    #define ADC0CV2H_CV                 ADC0CV2H_CV_28
    #define ADC0CV2H_CV2                ADC0CV2H_CV2_10
    
    #define ADC0CV2H_CV28_MASK          1
    #define ADC0CV2H_CV29_MASK          2
    #define ADC0CV2H_CV210_MASK         4
    #define ADC0CV2H_CV211_MASK         8
    #define ADC0CV2H_CV212_MASK         16
    #define ADC0CV2H_CV213_MASK         32
    #define ADC0CV2H_CV214_MASK         64
    #define ADC0CV2H_CV215_MASK         128
    #define ADC0CV2H_CV_28_MASK         3
    #define ADC0CV2H_CV_28_BITNUM       0
    #define ADC0CV2H_CV2_10_MASK        252
    #define ADC0CV2H_CV2_10_BITNUM      2
    

    /*** ADC0CV2L - Compare Value 2 Low Register; 0x00001843 ***/
    union {
      byte Byte;
      struct {
        byte CV20        :1;                                       /* Compare Function Value 0 */
        byte CV21        :1;                                       /* Compare Function Value 1 */
        byte CV22        :1;                                       /* Compare Function Value 2 */
        byte CV23        :1;                                       /* Compare Function Value 3 */
        byte CV24        :1;                                       /* Compare Function Value 4 */
        byte CV25        :1;                                       /* Compare Function Value 5 */
        byte CV26        :1;                                       /* Compare Function Value 6 */
        byte CV27        :1;                                       /* Compare Function Value 7 */
      } Bits;
    } ADC0CV2LSTR;
    #define ADC0CV2L                    _ADC0CV2.Overlap_STR.ADC0CV2LSTR.Byte
    #define ADC0CV2L_CV20               _ADC0CV2.Overlap_STR.ADC0CV2LSTR.Bits.CV20
    #define ADC0CV2L_CV21               _ADC0CV2.Overlap_STR.ADC0CV2LSTR.Bits.CV21
    #define ADC0CV2L_CV22               _ADC0CV2.Overlap_STR.ADC0CV2LSTR.Bits.CV22
    #define ADC0CV2L_CV23               _ADC0CV2.Overlap_STR.ADC0CV2LSTR.Bits.CV23
    #define ADC0CV2L_CV24               _ADC0CV2.Overlap_STR.ADC0CV2LSTR.Bits.CV24
    #define ADC0CV2L_CV25               _ADC0CV2.Overlap_STR.ADC0CV2LSTR.Bits.CV25
    #define ADC0CV2L_CV26               _ADC0CV2.Overlap_STR.ADC0CV2LSTR.Bits.CV26
    #define ADC0CV2L_CV27               _ADC0CV2.Overlap_STR.ADC0CV2LSTR.Bits.CV27
    
    #define ADC0CV2L_CV20_MASK          1
    #define ADC0CV2L_CV21_MASK          2
    #define ADC0CV2L_CV22_MASK          4
    #define ADC0CV2L_CV23_MASK          8
    #define ADC0CV2L_CV24_MASK          16
    #define ADC0CV2L_CV25_MASK          32
    #define ADC0CV2L_CV26_MASK          64
    #define ADC0CV2L_CV27_MASK          128
    
  } Overlap_STR;

} ADC0CV2STR;
extern volatile ADC0CV2STR _ADC0CV2 @0x00001842;
#define ADC0CV2                         _ADC0CV2.Word


/*** ADC0SC2 - Status and Control Register 2; 0x00001844 ***/
typedef union {
  byte Byte;
  struct {
    byte REFSEL0     :1;                                       /* Voltage Reference Selection, bit 0 */
    byte REFSEL1     :1;                                       /* Voltage Reference Selection, bit 1 */
    byte             :1; 
    byte ACREN       :1;                                       /* Compare Function Range Enable */
    byte ACFGT       :1;                                       /* Compare Function Greater Than Enable */
    byte ACFE        :1;                                       /* Compare Function Enable - ACFE is used to enable the compare function */
    byte ADTRG       :1;                                       /* Conversion Trigger Select-ADTRG is used to select the type of trigger to be used for initiating a conversion */
    byte ADACT       :1;                                       /* Conversion Active - ADACT indicates that a conversion is in progress. ADACT is set when a conversion is initiated and cleared when a conversion is completed or aborted */
  } Bits;
  struct {
    byte grpREFSEL :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} ADC0SC2STR;
extern volatile ADC0SC2STR _ADC0SC2 @0x00001844;
#define ADC0SC2                         _ADC0SC2.Byte
#define ADC0SC2_REFSEL0                 _ADC0SC2.Bits.REFSEL0
#define ADC0SC2_REFSEL1                 _ADC0SC2.Bits.REFSEL1
#define ADC0SC2_ACREN                   _ADC0SC2.Bits.ACREN
#define ADC0SC2_ACFGT                   _ADC0SC2.Bits.ACFGT
#define ADC0SC2_ACFE                    _ADC0SC2.Bits.ACFE
#define ADC0SC2_ADTRG                   _ADC0SC2.Bits.ADTRG
#define ADC0SC2_ADACT                   _ADC0SC2.Bits.ADACT
#define ADC0SC2_REFSEL                  _ADC0SC2.MergedBits.grpREFSEL

#define ADC0SC2_REFSEL0_MASK            1
#define ADC0SC2_REFSEL1_MASK            2
#define ADC0SC2_ACREN_MASK              8
#define ADC0SC2_ACFGT_MASK              16
#define ADC0SC2_ACFE_MASK               32
#define ADC0SC2_ADTRG_MASK              64
#define ADC0SC2_ADACT_MASK              128
#define ADC0SC2_REFSEL_MASK             3
#define ADC0SC2_REFSEL_BITNUM           0


/*** ADC0SC3 - Status and Control Register 3; 0x00001845 ***/
typedef union {
  byte Byte;
  struct {
    byte AVGS0       :1;                                       /* Hardware Average select, bit 0 */
    byte AVGS1       :1;                                       /* Hardware Average select, bit 1 */
    byte AVGE        :1;                                       /* Hardware average enable - AVGE enables the hardware average function of the ADC */
    byte ADCO        :1;                                       /* Continuous Conversion Enable - ADCO enables continuous conversions */
    byte             :1; 
    byte             :1; 
    byte CALF        :1;                                       /* Calibration Failed Flag - CALF displays the result of the calibration sequence */
    byte CAL         :1;                                       /* Calibration - CAL begins the calibration sequence when set */
  } Bits;
  struct {
    byte grpAVGS :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} ADC0SC3STR;
extern volatile ADC0SC3STR _ADC0SC3 @0x00001845;
#define ADC0SC3                         _ADC0SC3.Byte
#define ADC0SC3_AVGS0                   _ADC0SC3.Bits.AVGS0
#define ADC0SC3_AVGS1                   _ADC0SC3.Bits.AVGS1
#define ADC0SC3_AVGE                    _ADC0SC3.Bits.AVGE
#define ADC0SC3_ADCO                    _ADC0SC3.Bits.ADCO
#define ADC0SC3_CALF                    _ADC0SC3.Bits.CALF
#define ADC0SC3_CAL                     _ADC0SC3.Bits.CAL
#define ADC0SC3_AVGS                    _ADC0SC3.MergedBits.grpAVGS

#define ADC0SC3_AVGS0_MASK              1
#define ADC0SC3_AVGS1_MASK              2
#define ADC0SC3_AVGE_MASK               4
#define ADC0SC3_ADCO_MASK               8
#define ADC0SC3_CALF_MASK               64
#define ADC0SC3_CAL_MASK                128
#define ADC0SC3_AVGS_MASK               3
#define ADC0SC3_AVGS_BITNUM             0


/*** ADC0OFS - Offset Correction Register; 0x00001846 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ADC0OFSH - Offset Correction High Register; 0x00001846 ***/
    union {
      byte Byte;
      struct {
        byte OFS8        :1;                                       /* Offset error correction value bit 8 */
        byte OFS9        :1;                                       /* Offset error correction value bit 9 */
        byte OFS10       :1;                                       /* Offset error correction value bit 10 */
        byte OFS11       :1;                                       /* Offset error correction value bit 11 */
        byte OFS12       :1;                                       /* Offset error correction value bit 12 */
        byte OFS13       :1;                                       /* Offset error correction value bit 13 */
        byte OFS14       :1;                                       /* Offset error correction value bit 14 */
        byte OFS15       :1;                                       /* Offset error correction value bit 15 */
      } Bits;
    } ADC0OFSHSTR;
    #define ADC0OFSH                    _ADC0OFS.Overlap_STR.ADC0OFSHSTR.Byte
    #define ADC0OFSH_OFS8               _ADC0OFS.Overlap_STR.ADC0OFSHSTR.Bits.OFS8
    #define ADC0OFSH_OFS9               _ADC0OFS.Overlap_STR.ADC0OFSHSTR.Bits.OFS9
    #define ADC0OFSH_OFS10              _ADC0OFS.Overlap_STR.ADC0OFSHSTR.Bits.OFS10
    #define ADC0OFSH_OFS11              _ADC0OFS.Overlap_STR.ADC0OFSHSTR.Bits.OFS11
    #define ADC0OFSH_OFS12              _ADC0OFS.Overlap_STR.ADC0OFSHSTR.Bits.OFS12
    #define ADC0OFSH_OFS13              _ADC0OFS.Overlap_STR.ADC0OFSHSTR.Bits.OFS13
    #define ADC0OFSH_OFS14              _ADC0OFS.Overlap_STR.ADC0OFSHSTR.Bits.OFS14
    #define ADC0OFSH_OFS15              _ADC0OFS.Overlap_STR.ADC0OFSHSTR.Bits.OFS15
    
    #define ADC0OFSH_OFS8_MASK          1
    #define ADC0OFSH_OFS9_MASK          2
    #define ADC0OFSH_OFS10_MASK         4
    #define ADC0OFSH_OFS11_MASK         8
    #define ADC0OFSH_OFS12_MASK         16
    #define ADC0OFSH_OFS13_MASK         32
    #define ADC0OFSH_OFS14_MASK         64
    #define ADC0OFSH_OFS15_MASK         128
    

    /*** ADC0OFSL - Offset Correction Low Register; 0x00001847 ***/
    union {
      byte Byte;
      struct {
        byte OFS0        :1;                                       /* Offset error correction value bit 0 */
        byte OFS1        :1;                                       /* Offset error correction value bit 1 */
        byte OFS2        :1;                                       /* Offset error correction value bit 2 */
        byte OFS3        :1;                                       /* Offset error correction value bit 3 */
        byte OFS4        :1;                                       /* Offset error correction value bit 4 */
        byte OFS5        :1;                                       /* Offset error correction value bit 5 */
        byte OFS6        :1;                                       /* Offset error correction value bit 6 */
        byte OFS7        :1;                                       /* Offset error correction value bit 7 */
      } Bits;
    } ADC0OFSLSTR;
    #define ADC0OFSL                    _ADC0OFS.Overlap_STR.ADC0OFSLSTR.Byte
    #define ADC0OFSL_OFS0               _ADC0OFS.Overlap_STR.ADC0OFSLSTR.Bits.OFS0
    #define ADC0OFSL_OFS1               _ADC0OFS.Overlap_STR.ADC0OFSLSTR.Bits.OFS1
    #define ADC0OFSL_OFS2               _ADC0OFS.Overlap_STR.ADC0OFSLSTR.Bits.OFS2
    #define ADC0OFSL_OFS3               _ADC0OFS.Overlap_STR.ADC0OFSLSTR.Bits.OFS3
    #define ADC0OFSL_OFS4               _ADC0OFS.Overlap_STR.ADC0OFSLSTR.Bits.OFS4
    #define ADC0OFSL_OFS5               _ADC0OFS.Overlap_STR.ADC0OFSLSTR.Bits.OFS5
    #define ADC0OFSL_OFS6               _ADC0OFS.Overlap_STR.ADC0OFSLSTR.Bits.OFS6
    #define ADC0OFSL_OFS7               _ADC0OFS.Overlap_STR.ADC0OFSLSTR.Bits.OFS7
    
    #define ADC0OFSL_OFS0_MASK          1
    #define ADC0OFSL_OFS1_MASK          2
    #define ADC0OFSL_OFS2_MASK          4
    #define ADC0OFSL_OFS3_MASK          8
    #define ADC0OFSL_OFS4_MASK          16
    #define ADC0OFSL_OFS5_MASK          32
    #define ADC0OFSL_OFS6_MASK          64
    #define ADC0OFSL_OFS7_MASK          128
    
  } Overlap_STR;

} ADC0OFSSTR;
extern volatile ADC0OFSSTR _ADC0OFS @0x00001846;
#define ADC0OFS                         _ADC0OFS.Word


/*** ADC0PG - Plus-Side Gain Register; 0x00001848 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ADC0PGH - Plus-Side Gain High Register; 0x00001848 ***/
    union {
      byte Byte;
      struct {
        byte PG8         :1;                                       /* Gain error correction for the plus-side input value bit 8 */
        byte PG9         :1;                                       /* Gain error correction for the plus-side input value bit 9 */
        byte PG10        :1;                                       /* Gain error correction for the plus-side input value bit 10 */
        byte PG11        :1;                                       /* Gain error correction for the plus-side input value bit 11 */
        byte PG12        :1;                                       /* Gain error correction for the plus-side input value bit 12 */
        byte PG13        :1;                                       /* Gain error correction for the plus-side input value bit 13 */
        byte PG14        :1;                                       /* Gain error correction for the plus-side input value bit 14 */
        byte PG15        :1;                                       /* Gain error correction for the plus-side input value bit 15 */
      } Bits;
    } ADC0PGHSTR;
    #define ADC0PGH                     _ADC0PG.Overlap_STR.ADC0PGHSTR.Byte
    #define ADC0PGH_PG8                 _ADC0PG.Overlap_STR.ADC0PGHSTR.Bits.PG8
    #define ADC0PGH_PG9                 _ADC0PG.Overlap_STR.ADC0PGHSTR.Bits.PG9
    #define ADC0PGH_PG10                _ADC0PG.Overlap_STR.ADC0PGHSTR.Bits.PG10
    #define ADC0PGH_PG11                _ADC0PG.Overlap_STR.ADC0PGHSTR.Bits.PG11
    #define ADC0PGH_PG12                _ADC0PG.Overlap_STR.ADC0PGHSTR.Bits.PG12
    #define ADC0PGH_PG13                _ADC0PG.Overlap_STR.ADC0PGHSTR.Bits.PG13
    #define ADC0PGH_PG14                _ADC0PG.Overlap_STR.ADC0PGHSTR.Bits.PG14
    #define ADC0PGH_PG15                _ADC0PG.Overlap_STR.ADC0PGHSTR.Bits.PG15
    
    #define ADC0PGH_PG8_MASK            1
    #define ADC0PGH_PG9_MASK            2
    #define ADC0PGH_PG10_MASK           4
    #define ADC0PGH_PG11_MASK           8
    #define ADC0PGH_PG12_MASK           16
    #define ADC0PGH_PG13_MASK           32
    #define ADC0PGH_PG14_MASK           64
    #define ADC0PGH_PG15_MASK           128
    

    /*** ADC0PGL - Plus-Side Gain Low Register; 0x00001849 ***/
    union {
      byte Byte;
      struct {
        byte PG0         :1;                                       /* Gain error correction for the plus-side input value bit 0 */
        byte PG1         :1;                                       /* Gain error correction for the plus-side input value bit 1 */
        byte PG2         :1;                                       /* Gain error correction for the plus-side input value bit 2 */
        byte PG3         :1;                                       /* Gain error correction for the plus-side input value bit 3 */
        byte PG4         :1;                                       /* Gain error correction for the plus-side input value bit 4 */
        byte PG5         :1;                                       /* Gain error correction for the plus-side input value bit 5 */
        byte PG6         :1;                                       /* Gain error correction for the plus-side input value bit 6 */
        byte PG7         :1;                                       /* Gain error correction for the plus-side input value bit 7 */
      } Bits;
    } ADC0PGLSTR;
    #define ADC0PGL                     _ADC0PG.Overlap_STR.ADC0PGLSTR.Byte
    #define ADC0PGL_PG0                 _ADC0PG.Overlap_STR.ADC0PGLSTR.Bits.PG0
    #define ADC0PGL_PG1                 _ADC0PG.Overlap_STR.ADC0PGLSTR.Bits.PG1
    #define ADC0PGL_PG2                 _ADC0PG.Overlap_STR.ADC0PGLSTR.Bits.PG2
    #define ADC0PGL_PG3                 _ADC0PG.Overlap_STR.ADC0PGLSTR.Bits.PG3
    #define ADC0PGL_PG4                 _ADC0PG.Overlap_STR.ADC0PGLSTR.Bits.PG4
    #define ADC0PGL_PG5                 _ADC0PG.Overlap_STR.ADC0PGLSTR.Bits.PG5
    #define ADC0PGL_PG6                 _ADC0PG.Overlap_STR.ADC0PGLSTR.Bits.PG6
    #define ADC0PGL_PG7                 _ADC0PG.Overlap_STR.ADC0PGLSTR.Bits.PG7
    
    #define ADC0PGL_PG0_MASK            1
    #define ADC0PGL_PG1_MASK            2
    #define ADC0PGL_PG2_MASK            4
    #define ADC0PGL_PG3_MASK            8
    #define ADC0PGL_PG4_MASK            16
    #define ADC0PGL_PG5_MASK            32
    #define ADC0PGL_PG6_MASK            64
    #define ADC0PGL_PG7_MASK            128
    
  } Overlap_STR;

} ADC0PGSTR;
extern volatile ADC0PGSTR _ADC0PG @0x00001848;
#define ADC0PG                          _ADC0PG.Word


/*** ADC0MG - Minus-Side Gain Register; 0x0000184A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ADC0MGH - Minus-Side Gain High Register; 0x0000184A ***/
    union {
      byte Byte;
      struct {
        byte MG8         :1;                                       /* Gain error correction for the minus-side input value bit 8 */
        byte MG9         :1;                                       /* Gain error correction for the minus-side input value bit 9 */
        byte MG10        :1;                                       /* Gain error correction for the minus-side input value bit 10 */
        byte MG11        :1;                                       /* Gain error correction for the minus-side input value bit 11 */
        byte MG12        :1;                                       /* Gain error correction for the minus-side input value bit 12 */
        byte MG13        :1;                                       /* Gain error correction for the minus-side input value bit 13 */
        byte MG14        :1;                                       /* Gain error correction for the minus-side input value bit 14 */
        byte MG15        :1;                                       /* Gain error correction for the minus-side input value bit 15 */
      } Bits;
    } ADC0MGHSTR;
    #define ADC0MGH                     _ADC0MG.Overlap_STR.ADC0MGHSTR.Byte
    #define ADC0MGH_MG8                 _ADC0MG.Overlap_STR.ADC0MGHSTR.Bits.MG8
    #define ADC0MGH_MG9                 _ADC0MG.Overlap_STR.ADC0MGHSTR.Bits.MG9
    #define ADC0MGH_MG10                _ADC0MG.Overlap_STR.ADC0MGHSTR.Bits.MG10
    #define ADC0MGH_MG11                _ADC0MG.Overlap_STR.ADC0MGHSTR.Bits.MG11
    #define ADC0MGH_MG12                _ADC0MG.Overlap_STR.ADC0MGHSTR.Bits.MG12
    #define ADC0MGH_MG13                _ADC0MG.Overlap_STR.ADC0MGHSTR.Bits.MG13
    #define ADC0MGH_MG14                _ADC0MG.Overlap_STR.ADC0MGHSTR.Bits.MG14
    #define ADC0MGH_MG15                _ADC0MG.Overlap_STR.ADC0MGHSTR.Bits.MG15
    
    #define ADC0MGH_MG8_MASK            1
    #define ADC0MGH_MG9_MASK            2
    #define ADC0MGH_MG10_MASK           4
    #define ADC0MGH_MG11_MASK           8
    #define ADC0MGH_MG12_MASK           16
    #define ADC0MGH_MG13_MASK           32
    #define ADC0MGH_MG14_MASK           64
    #define ADC0MGH_MG15_MASK           128
    

    /*** ADC0MGL - Minus-Side Gain Low Register; 0x0000184B ***/
    union {
      byte Byte;
      struct {
        byte MG0         :1;                                       /* Gain error correction for the minus-side input value bit 0 */
        byte MG1         :1;                                       /* Gain error correction for the minus-side input value bit 1 */
        byte MG2         :1;                                       /* Gain error correction for the minus-side input value bit 2 */
        byte MG3         :1;                                       /* Gain error correction for the minus-side input value bit 3 */
        byte MG4         :1;                                       /* Gain error correction for the minus-side input value bit 4 */
        byte MG5         :1;                                       /* Gain error correction for the minus-side input value bit 5 */
        byte MG6         :1;                                       /* Gain error correction for the minus-side input value bit 6 */
        byte MG7         :1;                                       /* Gain error correction for the minus-side input value bit 7 */
      } Bits;
    } ADC0MGLSTR;
    #define ADC0MGL                     _ADC0MG.Overlap_STR.ADC0MGLSTR.Byte
    #define ADC0MGL_MG0                 _ADC0MG.Overlap_STR.ADC0MGLSTR.Bits.MG0
    #define ADC0MGL_MG1                 _ADC0MG.Overlap_STR.ADC0MGLSTR.Bits.MG1
    #define ADC0MGL_MG2                 _ADC0MG.Overlap_STR.ADC0MGLSTR.Bits.MG2
    #define ADC0MGL_MG3                 _ADC0MG.Overlap_STR.ADC0MGLSTR.Bits.MG3
    #define ADC0MGL_MG4                 _ADC0MG.Overlap_STR.ADC0MGLSTR.Bits.MG4
    #define ADC0MGL_MG5                 _ADC0MG.Overlap_STR.ADC0MGLSTR.Bits.MG5
    #define ADC0MGL_MG6                 _ADC0MG.Overlap_STR.ADC0MGLSTR.Bits.MG6
    #define ADC0MGL_MG7                 _ADC0MG.Overlap_STR.ADC0MGLSTR.Bits.MG7
    
    #define ADC0MGL_MG0_MASK            1
    #define ADC0MGL_MG1_MASK            2
    #define ADC0MGL_MG2_MASK            4
    #define ADC0MGL_MG3_MASK            8
    #define ADC0MGL_MG4_MASK            16
    #define ADC0MGL_MG5_MASK            32
    #define ADC0MGL_MG6_MASK            64
    #define ADC0MGL_MG7_MASK            128
    
  } Overlap_STR;

} ADC0MGSTR;
extern volatile ADC0MGSTR _ADC0MG @0x0000184A;
#define ADC0MG                          _ADC0MG.Word


/*** ADC0CLPD - Plus-Side General Calibration Value D Register; 0x0000184C ***/
typedef union {
  byte Byte;
  struct {
    byte CLPD0       :1;                                       /* Plus-Side General Calibration Value D bit 0 */
    byte CLPD1       :1;                                       /* Plus-Side General Calibration Value D bit 1 */
    byte CLPD2       :1;                                       /* Plus-Side General Calibration Value D bit 2 */
    byte CLPD3       :1;                                       /* Plus-Side General Calibration Value D bit 3 */
    byte CLPD4       :1;                                       /* Plus-Side General Calibration Value D bit 4 */
    byte CLPD5       :1;                                       /* Plus-Side General Calibration Value D bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpCLPD :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} ADC0CLPDSTR;
extern volatile ADC0CLPDSTR _ADC0CLPD @0x0000184C;
#define ADC0CLPD                        _ADC0CLPD.Byte
#define ADC0CLPD_CLPD0                  _ADC0CLPD.Bits.CLPD0
#define ADC0CLPD_CLPD1                  _ADC0CLPD.Bits.CLPD1
#define ADC0CLPD_CLPD2                  _ADC0CLPD.Bits.CLPD2
#define ADC0CLPD_CLPD3                  _ADC0CLPD.Bits.CLPD3
#define ADC0CLPD_CLPD4                  _ADC0CLPD.Bits.CLPD4
#define ADC0CLPD_CLPD5                  _ADC0CLPD.Bits.CLPD5
#define ADC0CLPD_CLPD                   _ADC0CLPD.MergedBits.grpCLPD

#define ADC0CLPD_CLPD0_MASK             1
#define ADC0CLPD_CLPD1_MASK             2
#define ADC0CLPD_CLPD2_MASK             4
#define ADC0CLPD_CLPD3_MASK             8
#define ADC0CLPD_CLPD4_MASK             16
#define ADC0CLPD_CLPD5_MASK             32
#define ADC0CLPD_CLPD_MASK              63
#define ADC0CLPD_CLPD_BITNUM            0


/*** ADC0CLPS - Plus-Side General Calibration Value S Register; 0x0000184D ***/
typedef union {
  byte Byte;
  struct {
    byte CLPS0       :1;                                       /* Plus-Side General Calibration Value S bit 0 */
    byte CLPS1       :1;                                       /* Plus-Side General Calibration Value S bit 1 */
    byte CLPS2       :1;                                       /* Plus-Side General Calibration Value S bit 2 */
    byte CLPS3       :1;                                       /* Plus-Side General Calibration Value S bit 3 */
    byte CLPS4       :1;                                       /* Plus-Side General Calibration Value S bit 4 */
    byte CLPS5       :1;                                       /* Plus-Side General Calibration Value S bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpCLPS :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} ADC0CLPSSTR;
extern volatile ADC0CLPSSTR _ADC0CLPS @0x0000184D;
#define ADC0CLPS                        _ADC0CLPS.Byte
#define ADC0CLPS_CLPS0                  _ADC0CLPS.Bits.CLPS0
#define ADC0CLPS_CLPS1                  _ADC0CLPS.Bits.CLPS1
#define ADC0CLPS_CLPS2                  _ADC0CLPS.Bits.CLPS2
#define ADC0CLPS_CLPS3                  _ADC0CLPS.Bits.CLPS3
#define ADC0CLPS_CLPS4                  _ADC0CLPS.Bits.CLPS4
#define ADC0CLPS_CLPS5                  _ADC0CLPS.Bits.CLPS5
#define ADC0CLPS_CLPS                   _ADC0CLPS.MergedBits.grpCLPS

#define ADC0CLPS_CLPS0_MASK             1
#define ADC0CLPS_CLPS1_MASK             2
#define ADC0CLPS_CLPS2_MASK             4
#define ADC0CLPS_CLPS3_MASK             8
#define ADC0CLPS_CLPS4_MASK             16
#define ADC0CLPS_CLPS5_MASK             32
#define ADC0CLPS_CLPS_MASK              63
#define ADC0CLPS_CLPS_BITNUM            0


/*** ADC0CLP4 - Plus-Side General Calibration Value 4 Register; 0x0000184E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ADC0CLP4H - Plus-Side General Calibration Value 4 High Register; 0x0000184E ***/
    union {
      byte Byte;
      struct {
        byte CLP48       :1;                                       /* Plus-Side General Calibration Value 4 bit 8 */
        byte CLP49       :1;                                       /* Plus-Side General Calibration Value 4 bit 9 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpCLP_48 :2;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ADC0CLP4HSTR;
    #define ADC0CLP4H                   _ADC0CLP4.Overlap_STR.ADC0CLP4HSTR.Byte
    #define ADC0CLP4H_CLP48             _ADC0CLP4.Overlap_STR.ADC0CLP4HSTR.Bits.CLP48
    #define ADC0CLP4H_CLP49             _ADC0CLP4.Overlap_STR.ADC0CLP4HSTR.Bits.CLP49
    #define ADC0CLP4H_CLP_48            _ADC0CLP4.Overlap_STR.ADC0CLP4HSTR.MergedBits.grpCLP_48
    #define ADC0CLP4H_CLP               ADC0CLP4H_CLP_48
    
    #define ADC0CLP4H_CLP48_MASK        1
    #define ADC0CLP4H_CLP49_MASK        2
    #define ADC0CLP4H_CLP_48_MASK       3
    #define ADC0CLP4H_CLP_48_BITNUM     0
    

    /*** ADC0CLP4L - Plus-Side General Calibration Value 4 Low Register; 0x0000184F ***/
    union {
      byte Byte;
      struct {
        byte CLP40       :1;                                       /* Plus-Side General Calibration Value 4 bit 0 */
        byte CLP41       :1;                                       /* Plus-Side General Calibration Value 4 bit 1 */
        byte CLP42       :1;                                       /* Plus-Side General Calibration Value 4 bit 2 */
        byte CLP43       :1;                                       /* Plus-Side General Calibration Value 4 bit 3 */
        byte CLP44       :1;                                       /* Plus-Side General Calibration Value 4 bit 4 */
        byte CLP45       :1;                                       /* Plus-Side General Calibration Value 4 bit 5 */
        byte CLP46       :1;                                       /* Plus-Side General Calibration Value 4 bit 6 */
        byte CLP47       :1;                                       /* Plus-Side General Calibration Value 4 bit 7 */
      } Bits;
    } ADC0CLP4LSTR;
    #define ADC0CLP4L                   _ADC0CLP4.Overlap_STR.ADC0CLP4LSTR.Byte
    #define ADC0CLP4L_CLP40             _ADC0CLP4.Overlap_STR.ADC0CLP4LSTR.Bits.CLP40
    #define ADC0CLP4L_CLP41             _ADC0CLP4.Overlap_STR.ADC0CLP4LSTR.Bits.CLP41
    #define ADC0CLP4L_CLP42             _ADC0CLP4.Overlap_STR.ADC0CLP4LSTR.Bits.CLP42
    #define ADC0CLP4L_CLP43             _ADC0CLP4.Overlap_STR.ADC0CLP4LSTR.Bits.CLP43
    #define ADC0CLP4L_CLP44             _ADC0CLP4.Overlap_STR.ADC0CLP4LSTR.Bits.CLP44
    #define ADC0CLP4L_CLP45             _ADC0CLP4.Overlap_STR.ADC0CLP4LSTR.Bits.CLP45
    #define ADC0CLP4L_CLP46             _ADC0CLP4.Overlap_STR.ADC0CLP4LSTR.Bits.CLP46
    #define ADC0CLP4L_CLP47             _ADC0CLP4.Overlap_STR.ADC0CLP4LSTR.Bits.CLP47
    
    #define ADC0CLP4L_CLP40_MASK        1
    #define ADC0CLP4L_CLP41_MASK        2
    #define ADC0CLP4L_CLP42_MASK        4
    #define ADC0CLP4L_CLP43_MASK        8
    #define ADC0CLP4L_CLP44_MASK        16
    #define ADC0CLP4L_CLP45_MASK        32
    #define ADC0CLP4L_CLP46_MASK        64
    #define ADC0CLP4L_CLP47_MASK        128
    
  } Overlap_STR;

} ADC0CLP4STR;
extern volatile ADC0CLP4STR _ADC0CLP4 @0x0000184E;
#define ADC0CLP4                        _ADC0CLP4.Word


/*** ADC0CLP3 - Plus-Side General Calibration Value 3 Register; 0x00001850 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ADC0CLP3H - Plus-Side General Calibration Value 3 High Register; 0x00001850 ***/
    union {
      byte Byte;
      struct {
        byte CLP38       :1;                                       /* Plus-Side General Calibration Value 3 bits */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
    } ADC0CLP3HSTR;
    #define ADC0CLP3H                   _ADC0CLP3.Overlap_STR.ADC0CLP3HSTR.Byte
    #define ADC0CLP3H_CLP38             _ADC0CLP3.Overlap_STR.ADC0CLP3HSTR.Bits.CLP38
    
    #define ADC0CLP3H_CLP38_MASK        1
    

    /*** ADC0CLP3L - Plus-Side General Calibration Value 3 Low Register; 0x00001851 ***/
    union {
      byte Byte;
      struct {
        byte CLP30       :1;                                       /* Plus-Side General Calibration Value 3 bit 0 */
        byte CLP31       :1;                                       /* Plus-Side General Calibration Value 3 bit 1 */
        byte CLP32       :1;                                       /* Plus-Side General Calibration Value 3 bit 2 */
        byte CLP33       :1;                                       /* Plus-Side General Calibration Value 3 bit 3 */
        byte CLP34       :1;                                       /* Plus-Side General Calibration Value 3 bit 4 */
        byte CLP35       :1;                                       /* Plus-Side General Calibration Value 3 bit 5 */
        byte CLP36       :1;                                       /* Plus-Side General Calibration Value 3 bit 6 */
        byte CLP37       :1;                                       /* Plus-Side General Calibration Value 3 bit 7 */
      } Bits;
    } ADC0CLP3LSTR;
    #define ADC0CLP3L                   _ADC0CLP3.Overlap_STR.ADC0CLP3LSTR.Byte
    #define ADC0CLP3L_CLP30             _ADC0CLP3.Overlap_STR.ADC0CLP3LSTR.Bits.CLP30
    #define ADC0CLP3L_CLP31             _ADC0CLP3.Overlap_STR.ADC0CLP3LSTR.Bits.CLP31
    #define ADC0CLP3L_CLP32             _ADC0CLP3.Overlap_STR.ADC0CLP3LSTR.Bits.CLP32
    #define ADC0CLP3L_CLP33             _ADC0CLP3.Overlap_STR.ADC0CLP3LSTR.Bits.CLP33
    #define ADC0CLP3L_CLP34             _ADC0CLP3.Overlap_STR.ADC0CLP3LSTR.Bits.CLP34
    #define ADC0CLP3L_CLP35             _ADC0CLP3.Overlap_STR.ADC0CLP3LSTR.Bits.CLP35
    #define ADC0CLP3L_CLP36             _ADC0CLP3.Overlap_STR.ADC0CLP3LSTR.Bits.CLP36
    #define ADC0CLP3L_CLP37             _ADC0CLP3.Overlap_STR.ADC0CLP3LSTR.Bits.CLP37
    
    #define ADC0CLP3L_CLP30_MASK        1
    #define ADC0CLP3L_CLP31_MASK        2
    #define ADC0CLP3L_CLP32_MASK        4
    #define ADC0CLP3L_CLP33_MASK        8
    #define ADC0CLP3L_CLP34_MASK        16
    #define ADC0CLP3L_CLP35_MASK        32
    #define ADC0CLP3L_CLP36_MASK        64
    #define ADC0CLP3L_CLP37_MASK        128
    
  } Overlap_STR;

} ADC0CLP3STR;
extern volatile ADC0CLP3STR _ADC0CLP3 @0x00001850;
#define ADC0CLP3                        _ADC0CLP3.Word


/*** ADC0CLP2 - Plus-Side General Calibration Value 2 Register; 0x00001852 ***/
typedef union {
  byte Byte;
  struct {
    byte CLP20       :1;                                       /* Plus-Side General Calibration Value 2 bit 0 */
    byte CLP21       :1;                                       /* Plus-Side General Calibration Value 2 bit 1 */
    byte CLP22       :1;                                       /* Plus-Side General Calibration Value 2 bit 2 */
    byte CLP23       :1;                                       /* Plus-Side General Calibration Value 2 bit 3 */
    byte CLP24       :1;                                       /* Plus-Side General Calibration Value 2 bit 4 */
    byte CLP25       :1;                                       /* Plus-Side General Calibration Value 2 bit 5 */
    byte CLP26       :1;                                       /* Plus-Side General Calibration Value 2 bit 6 */
    byte CLP27       :1;                                       /* Plus-Side General Calibration Value 2 bit 7 */
  } Bits;
} ADC0CLP2STR;
extern volatile ADC0CLP2STR _ADC0CLP2 @0x00001852;
#define ADC0CLP2                        _ADC0CLP2.Byte
#define ADC0CLP2_CLP20                  _ADC0CLP2.Bits.CLP20
#define ADC0CLP2_CLP21                  _ADC0CLP2.Bits.CLP21
#define ADC0CLP2_CLP22                  _ADC0CLP2.Bits.CLP22
#define ADC0CLP2_CLP23                  _ADC0CLP2.Bits.CLP23
#define ADC0CLP2_CLP24                  _ADC0CLP2.Bits.CLP24
#define ADC0CLP2_CLP25                  _ADC0CLP2.Bits.CLP25
#define ADC0CLP2_CLP26                  _ADC0CLP2.Bits.CLP26
#define ADC0CLP2_CLP27                  _ADC0CLP2.Bits.CLP27

#define ADC0CLP2_CLP20_MASK             1
#define ADC0CLP2_CLP21_MASK             2
#define ADC0CLP2_CLP22_MASK             4
#define ADC0CLP2_CLP23_MASK             8
#define ADC0CLP2_CLP24_MASK             16
#define ADC0CLP2_CLP25_MASK             32
#define ADC0CLP2_CLP26_MASK             64
#define ADC0CLP2_CLP27_MASK             128


/*** ADC0CLP1 - Plus-Side General Calibration Value 1 Register; 0x00001853 ***/
typedef union {
  byte Byte;
  struct {
    byte CLP10       :1;                                       /* Plus-Side General Calibration Value 1 bit 0 */
    byte CLP11       :1;                                       /* Plus-Side General Calibration Value 1 bit 1 */
    byte CLP12       :1;                                       /* Plus-Side General Calibration Value 1 bit 2 */
    byte CLP13       :1;                                       /* Plus-Side General Calibration Value 1 bit 3 */
    byte CLP14       :1;                                       /* Plus-Side General Calibration Value 1 bit 4 */
    byte CLP15       :1;                                       /* Plus-Side General Calibration Value 1 bit 5 */
    byte CLP16       :1;                                       /* Plus-Side General Calibration Value 1 bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpCLP_10 :7;
    byte         :1;
  } MergedBits;
} ADC0CLP1STR;
extern volatile ADC0CLP1STR _ADC0CLP1 @0x00001853;
#define ADC0CLP1                        _ADC0CLP1.Byte
#define ADC0CLP1_CLP10                  _ADC0CLP1.Bits.CLP10
#define ADC0CLP1_CLP11                  _ADC0CLP1.Bits.CLP11
#define ADC0CLP1_CLP12                  _ADC0CLP1.Bits.CLP12
#define ADC0CLP1_CLP13                  _ADC0CLP1.Bits.CLP13
#define ADC0CLP1_CLP14                  _ADC0CLP1.Bits.CLP14
#define ADC0CLP1_CLP15                  _ADC0CLP1.Bits.CLP15
#define ADC0CLP1_CLP16                  _ADC0CLP1.Bits.CLP16
#define ADC0CLP1_CLP_10                 _ADC0CLP1.MergedBits.grpCLP_10
#define ADC0CLP1_CLP                    ADC0CLP1_CLP_10

#define ADC0CLP1_CLP10_MASK             1
#define ADC0CLP1_CLP11_MASK             2
#define ADC0CLP1_CLP12_MASK             4
#define ADC0CLP1_CLP13_MASK             8
#define ADC0CLP1_CLP14_MASK             16
#define ADC0CLP1_CLP15_MASK             32
#define ADC0CLP1_CLP16_MASK             64
#define ADC0CLP1_CLP_10_MASK            127
#define ADC0CLP1_CLP_10_BITNUM          0


/*** ADC0CLP0 - Plus-Side General Calibration Value 0 Register; 0x00001854 ***/
typedef union {
  byte Byte;
  struct {
    byte CLP00       :1;                                       /* Plus-Side General Calibration Value 0 bit 0 */
    byte CLP01       :1;                                       /* Plus-Side General Calibration Value 0 bit 1 */
    byte CLP02       :1;                                       /* Plus-Side General Calibration Value 0 bit 2 */
    byte CLP03       :1;                                       /* Plus-Side General Calibration Value 0 bit 3 */
    byte CLP04       :1;                                       /* Plus-Side General Calibration Value 0 bit 4 */
    byte CLP05       :1;                                       /* Plus-Side General Calibration Value 0 bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpCLP0 :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} ADC0CLP0STR;
extern volatile ADC0CLP0STR _ADC0CLP0 @0x00001854;
#define ADC0CLP0                        _ADC0CLP0.Byte
#define ADC0CLP0_CLP00                  _ADC0CLP0.Bits.CLP00
#define ADC0CLP0_CLP01                  _ADC0CLP0.Bits.CLP01
#define ADC0CLP0_CLP02                  _ADC0CLP0.Bits.CLP02
#define ADC0CLP0_CLP03                  _ADC0CLP0.Bits.CLP03
#define ADC0CLP0_CLP04                  _ADC0CLP0.Bits.CLP04
#define ADC0CLP0_CLP05                  _ADC0CLP0.Bits.CLP05
#define ADC0CLP0_CLP0                   _ADC0CLP0.MergedBits.grpCLP0

#define ADC0CLP0_CLP00_MASK             1
#define ADC0CLP0_CLP01_MASK             2
#define ADC0CLP0_CLP02_MASK             4
#define ADC0CLP0_CLP03_MASK             8
#define ADC0CLP0_CLP04_MASK             16
#define ADC0CLP0_CLP05_MASK             32
#define ADC0CLP0_CLP0_MASK              63
#define ADC0CLP0_CLP0_BITNUM            0


/*** ADC0CLMD - Minus-Side General Calibration Value D Register; 0x00001856 ***/
typedef union {
  byte Byte;
  struct {
    byte CLMD0       :1;                                       /* Minus-Side General Calibration Value D bit 0 */
    byte CLMD1       :1;                                       /* Minus-Side General Calibration Value D bit 1 */
    byte CLMD2       :1;                                       /* Minus-Side General Calibration Value D bit 2 */
    byte CLMD3       :1;                                       /* Minus-Side General Calibration Value D bit 3 */
    byte CLMD4       :1;                                       /* Minus-Side General Calibration Value D bit 4 */
    byte CLMD5       :1;                                       /* Minus-Side General Calibration Value D bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpCLMD :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} ADC0CLMDSTR;
extern volatile ADC0CLMDSTR _ADC0CLMD @0x00001856;
#define ADC0CLMD                        _ADC0CLMD.Byte
#define ADC0CLMD_CLMD0                  _ADC0CLMD.Bits.CLMD0
#define ADC0CLMD_CLMD1                  _ADC0CLMD.Bits.CLMD1
#define ADC0CLMD_CLMD2                  _ADC0CLMD.Bits.CLMD2
#define ADC0CLMD_CLMD3                  _ADC0CLMD.Bits.CLMD3
#define ADC0CLMD_CLMD4                  _ADC0CLMD.Bits.CLMD4
#define ADC0CLMD_CLMD5                  _ADC0CLMD.Bits.CLMD5
#define ADC0CLMD_CLMD                   _ADC0CLMD.MergedBits.grpCLMD

#define ADC0CLMD_CLMD0_MASK             1
#define ADC0CLMD_CLMD1_MASK             2
#define ADC0CLMD_CLMD2_MASK             4
#define ADC0CLMD_CLMD3_MASK             8
#define ADC0CLMD_CLMD4_MASK             16
#define ADC0CLMD_CLMD5_MASK             32
#define ADC0CLMD_CLMD_MASK              63
#define ADC0CLMD_CLMD_BITNUM            0


/*** ADC0CLMS - Minus-Side General Calibration Value S Register; 0x00001857 ***/
typedef union {
  byte Byte;
  struct {
    byte CLMS0       :1;                                       /* Minus-Side General Calibration Value S bit 0 */
    byte CLMS1       :1;                                       /* Minus-Side General Calibration Value S bit 1 */
    byte CLMS2       :1;                                       /* Minus-Side General Calibration Value S bit 2 */
    byte CLMS3       :1;                                       /* Minus-Side General Calibration Value S bit 3 */
    byte CLMS4       :1;                                       /* Minus-Side General Calibration Value S bit 4 */
    byte CLMS5       :1;                                       /* Minus-Side General Calibration Value S bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpCLMS :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} ADC0CLMSSTR;
extern volatile ADC0CLMSSTR _ADC0CLMS @0x00001857;
#define ADC0CLMS                        _ADC0CLMS.Byte
#define ADC0CLMS_CLMS0                  _ADC0CLMS.Bits.CLMS0
#define ADC0CLMS_CLMS1                  _ADC0CLMS.Bits.CLMS1
#define ADC0CLMS_CLMS2                  _ADC0CLMS.Bits.CLMS2
#define ADC0CLMS_CLMS3                  _ADC0CLMS.Bits.CLMS3
#define ADC0CLMS_CLMS4                  _ADC0CLMS.Bits.CLMS4
#define ADC0CLMS_CLMS5                  _ADC0CLMS.Bits.CLMS5
#define ADC0CLMS_CLMS                   _ADC0CLMS.MergedBits.grpCLMS

#define ADC0CLMS_CLMS0_MASK             1
#define ADC0CLMS_CLMS1_MASK             2
#define ADC0CLMS_CLMS2_MASK             4
#define ADC0CLMS_CLMS3_MASK             8
#define ADC0CLMS_CLMS4_MASK             16
#define ADC0CLMS_CLMS5_MASK             32
#define ADC0CLMS_CLMS_MASK              63
#define ADC0CLMS_CLMS_BITNUM            0


/*** ADC0CLM4 - Minus-Side General Calibration Value 4 Register; 0x00001858 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ADC0CLM4H - Minus-Side General Calibration Value 4 High Register; 0x00001858 ***/
    union {
      byte Byte;
      struct {
        byte CLM48       :1;                                       /* Minus-Side General Calibration Value 4 bit 8 */
        byte CLM49       :1;                                       /* Minus-Side General Calibration Value 4 bit 9 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpCLM_48 :2;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ADC0CLM4HSTR;
    #define ADC0CLM4H                   _ADC0CLM4.Overlap_STR.ADC0CLM4HSTR.Byte
    #define ADC0CLM4H_CLM48             _ADC0CLM4.Overlap_STR.ADC0CLM4HSTR.Bits.CLM48
    #define ADC0CLM4H_CLM49             _ADC0CLM4.Overlap_STR.ADC0CLM4HSTR.Bits.CLM49
    #define ADC0CLM4H_CLM_48            _ADC0CLM4.Overlap_STR.ADC0CLM4HSTR.MergedBits.grpCLM_48
    #define ADC0CLM4H_CLM               ADC0CLM4H_CLM_48
    
    #define ADC0CLM4H_CLM48_MASK        1
    #define ADC0CLM4H_CLM49_MASK        2
    #define ADC0CLM4H_CLM_48_MASK       3
    #define ADC0CLM4H_CLM_48_BITNUM     0
    

    /*** ADC0CLM4L - Minus-Side General Calibration Value 4 Low Register; 0x00001859 ***/
    union {
      byte Byte;
      struct {
        byte CLM40       :1;                                       /* Minus-Side General Calibration Value 4 bit 0 */
        byte CLM41       :1;                                       /* Minus-Side General Calibration Value 4 bit 1 */
        byte CLM42       :1;                                       /* Minus-Side General Calibration Value 4 bit 2 */
        byte CLM43       :1;                                       /* Minus-Side General Calibration Value 4 bit 3 */
        byte CLM44       :1;                                       /* Minus-Side General Calibration Value 4 bit 4 */
        byte CLM45       :1;                                       /* Minus-Side General Calibration Value 4 bit 5 */
        byte CLM46       :1;                                       /* Minus-Side General Calibration Value 4 bit 6 */
        byte CLM47       :1;                                       /* Minus-Side General Calibration Value 4 bit 7 */
      } Bits;
    } ADC0CLM4LSTR;
    #define ADC0CLM4L                   _ADC0CLM4.Overlap_STR.ADC0CLM4LSTR.Byte
    #define ADC0CLM4L_CLM40             _ADC0CLM4.Overlap_STR.ADC0CLM4LSTR.Bits.CLM40
    #define ADC0CLM4L_CLM41             _ADC0CLM4.Overlap_STR.ADC0CLM4LSTR.Bits.CLM41
    #define ADC0CLM4L_CLM42             _ADC0CLM4.Overlap_STR.ADC0CLM4LSTR.Bits.CLM42
    #define ADC0CLM4L_CLM43             _ADC0CLM4.Overlap_STR.ADC0CLM4LSTR.Bits.CLM43
    #define ADC0CLM4L_CLM44             _ADC0CLM4.Overlap_STR.ADC0CLM4LSTR.Bits.CLM44
    #define ADC0CLM4L_CLM45             _ADC0CLM4.Overlap_STR.ADC0CLM4LSTR.Bits.CLM45
    #define ADC0CLM4L_CLM46             _ADC0CLM4.Overlap_STR.ADC0CLM4LSTR.Bits.CLM46
    #define ADC0CLM4L_CLM47             _ADC0CLM4.Overlap_STR.ADC0CLM4LSTR.Bits.CLM47
    
    #define ADC0CLM4L_CLM40_MASK        1
    #define ADC0CLM4L_CLM41_MASK        2
    #define ADC0CLM4L_CLM42_MASK        4
    #define ADC0CLM4L_CLM43_MASK        8
    #define ADC0CLM4L_CLM44_MASK        16
    #define ADC0CLM4L_CLM45_MASK        32
    #define ADC0CLM4L_CLM46_MASK        64
    #define ADC0CLM4L_CLM47_MASK        128
    
  } Overlap_STR;

} ADC0CLM4STR;
extern volatile ADC0CLM4STR _ADC0CLM4 @0x00001858;
#define ADC0CLM4                        _ADC0CLM4.Word


/*** ADC0CLM3 - Minus-Side General Calibration Value 3 Register; 0x0000185A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ADC0CLM3H - Minus-Side General Calibration Value 3 High Register; 0x0000185A ***/
    union {
      byte Byte;
      struct {
        byte CLM38       :1;                                       /* Minus-Side General Calibration Value 3 bits */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
    } ADC0CLM3HSTR;
    #define ADC0CLM3H                   _ADC0CLM3.Overlap_STR.ADC0CLM3HSTR.Byte
    #define ADC0CLM3H_CLM38             _ADC0CLM3.Overlap_STR.ADC0CLM3HSTR.Bits.CLM38
    
    #define ADC0CLM3H_CLM38_MASK        1
    

    /*** ADC0CLM3L - Minus-Side General Calibration Value 3 Low Register; 0x0000185B ***/
    union {
      byte Byte;
      struct {
        byte CLM30       :1;                                       /* Minus-Side General Calibration Value 3 bit 0 */
        byte CLM31       :1;                                       /* Minus-Side General Calibration Value 3 bit 1 */
        byte CLM32       :1;                                       /* Minus-Side General Calibration Value 3 bit 2 */
        byte CLM33       :1;                                       /* Minus-Side General Calibration Value 3 bit 3 */
        byte CLM34       :1;                                       /* Minus-Side General Calibration Value 3 bit 4 */
        byte CLM35       :1;                                       /* Minus-Side General Calibration Value 3 bit 5 */
        byte CLM36       :1;                                       /* Minus-Side General Calibration Value 3 bit 6 */
        byte CLM37       :1;                                       /* Minus-Side General Calibration Value 3 bit 7 */
      } Bits;
    } ADC0CLM3LSTR;
    #define ADC0CLM3L                   _ADC0CLM3.Overlap_STR.ADC0CLM3LSTR.Byte
    #define ADC0CLM3L_CLM30             _ADC0CLM3.Overlap_STR.ADC0CLM3LSTR.Bits.CLM30
    #define ADC0CLM3L_CLM31             _ADC0CLM3.Overlap_STR.ADC0CLM3LSTR.Bits.CLM31
    #define ADC0CLM3L_CLM32             _ADC0CLM3.Overlap_STR.ADC0CLM3LSTR.Bits.CLM32
    #define ADC0CLM3L_CLM33             _ADC0CLM3.Overlap_STR.ADC0CLM3LSTR.Bits.CLM33
    #define ADC0CLM3L_CLM34             _ADC0CLM3.Overlap_STR.ADC0CLM3LSTR.Bits.CLM34
    #define ADC0CLM3L_CLM35             _ADC0CLM3.Overlap_STR.ADC0CLM3LSTR.Bits.CLM35
    #define ADC0CLM3L_CLM36             _ADC0CLM3.Overlap_STR.ADC0CLM3LSTR.Bits.CLM36
    #define ADC0CLM3L_CLM37             _ADC0CLM3.Overlap_STR.ADC0CLM3LSTR.Bits.CLM37
    
    #define ADC0CLM3L_CLM30_MASK        1
    #define ADC0CLM3L_CLM31_MASK        2
    #define ADC0CLM3L_CLM32_MASK        4
    #define ADC0CLM3L_CLM33_MASK        8
    #define ADC0CLM3L_CLM34_MASK        16
    #define ADC0CLM3L_CLM35_MASK        32
    #define ADC0CLM3L_CLM36_MASK        64
    #define ADC0CLM3L_CLM37_MASK        128
    
  } Overlap_STR;

} ADC0CLM3STR;
extern volatile ADC0CLM3STR _ADC0CLM3 @0x0000185A;
#define ADC0CLM3                        _ADC0CLM3.Word


/*** ADC0CLM2 - Minus-Side General Calibration Value 2 Register; 0x0000185C ***/
typedef union {
  byte Byte;
  struct {
    byte CLM20       :1;                                       /* Minus-Side General Calibration Value 2 bit 0 */
    byte CLM21       :1;                                       /* Minus-Side General Calibration Value 2 bit 1 */
    byte CLM22       :1;                                       /* Minus-Side General Calibration Value 2 bit 2 */
    byte CLM23       :1;                                       /* Minus-Side General Calibration Value 2 bit 3 */
    byte CLM24       :1;                                       /* Minus-Side General Calibration Value 2 bit 4 */
    byte CLM25       :1;                                       /* Minus-Side General Calibration Value 2 bit 5 */
    byte CLM26       :1;                                       /* Minus-Side General Calibration Value 2 bit 6 */
    byte CLM27       :1;                                       /* Minus-Side General Calibration Value 2 bit 7 */
  } Bits;
} ADC0CLM2STR;
extern volatile ADC0CLM2STR _ADC0CLM2 @0x0000185C;
#define ADC0CLM2                        _ADC0CLM2.Byte
#define ADC0CLM2_CLM20                  _ADC0CLM2.Bits.CLM20
#define ADC0CLM2_CLM21                  _ADC0CLM2.Bits.CLM21
#define ADC0CLM2_CLM22                  _ADC0CLM2.Bits.CLM22
#define ADC0CLM2_CLM23                  _ADC0CLM2.Bits.CLM23
#define ADC0CLM2_CLM24                  _ADC0CLM2.Bits.CLM24
#define ADC0CLM2_CLM25                  _ADC0CLM2.Bits.CLM25
#define ADC0CLM2_CLM26                  _ADC0CLM2.Bits.CLM26
#define ADC0CLM2_CLM27                  _ADC0CLM2.Bits.CLM27

#define ADC0CLM2_CLM20_MASK             1
#define ADC0CLM2_CLM21_MASK             2
#define ADC0CLM2_CLM22_MASK             4
#define ADC0CLM2_CLM23_MASK             8
#define ADC0CLM2_CLM24_MASK             16
#define ADC0CLM2_CLM25_MASK             32
#define ADC0CLM2_CLM26_MASK             64
#define ADC0CLM2_CLM27_MASK             128


/*** ADC0CLM1 - Minus-Side General Calibration Value 1 Register; 0x0000185D ***/
typedef union {
  byte Byte;
  struct {
    byte CLM10       :1;                                       /* Minus-Side General Calibration Value 1 bit 0 */
    byte CLM11       :1;                                       /* Minus-Side General Calibration Value 1 bit 1 */
    byte CLM12       :1;                                       /* Minus-Side General Calibration Value 1 bit 2 */
    byte CLM13       :1;                                       /* Minus-Side General Calibration Value 1 bit 3 */
    byte CLM14       :1;                                       /* Minus-Side General Calibration Value 1 bit 4 */
    byte CLM15       :1;                                       /* Minus-Side General Calibration Value 1 bit 5 */
    byte CLM16       :1;                                       /* Minus-Side General Calibration Value 1 bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpCLM_10 :7;
    byte         :1;
  } MergedBits;
} ADC0CLM1STR;
extern volatile ADC0CLM1STR _ADC0CLM1 @0x0000185D;
#define ADC0CLM1                        _ADC0CLM1.Byte
#define ADC0CLM1_CLM10                  _ADC0CLM1.Bits.CLM10
#define ADC0CLM1_CLM11                  _ADC0CLM1.Bits.CLM11
#define ADC0CLM1_CLM12                  _ADC0CLM1.Bits.CLM12
#define ADC0CLM1_CLM13                  _ADC0CLM1.Bits.CLM13
#define ADC0CLM1_CLM14                  _ADC0CLM1.Bits.CLM14
#define ADC0CLM1_CLM15                  _ADC0CLM1.Bits.CLM15
#define ADC0CLM1_CLM16                  _ADC0CLM1.Bits.CLM16
#define ADC0CLM1_CLM_10                 _ADC0CLM1.MergedBits.grpCLM_10
#define ADC0CLM1_CLM                    ADC0CLM1_CLM_10

#define ADC0CLM1_CLM10_MASK             1
#define ADC0CLM1_CLM11_MASK             2
#define ADC0CLM1_CLM12_MASK             4
#define ADC0CLM1_CLM13_MASK             8
#define ADC0CLM1_CLM14_MASK             16
#define ADC0CLM1_CLM15_MASK             32
#define ADC0CLM1_CLM16_MASK             64
#define ADC0CLM1_CLM_10_MASK            127
#define ADC0CLM1_CLM_10_BITNUM          0


/*** ADC0CLM0 - Minus-Side General Calibration Value 0 Register; 0x0000185E ***/
typedef union {
  byte Byte;
  struct {
    byte CLM00       :1;                                       /* Minus-Side General Calibration Value 0 bit 0 */
    byte CLM01       :1;                                       /* Minus-Side General Calibration Value 0 bit 1 */
    byte CLM02       :1;                                       /* Minus-Side General Calibration Value 0 bit 2 */
    byte CLM03       :1;                                       /* Minus-Side General Calibration Value 0 bit 3 */
    byte CLM04       :1;                                       /* Minus-Side General Calibration Value 0 bit 4 */
    byte CLM05       :1;                                       /* Minus-Side General Calibration Value 0 bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpCLM0 :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} ADC0CLM0STR;
extern volatile ADC0CLM0STR _ADC0CLM0 @0x0000185E;
#define ADC0CLM0                        _ADC0CLM0.Byte
#define ADC0CLM0_CLM00                  _ADC0CLM0.Bits.CLM00
#define ADC0CLM0_CLM01                  _ADC0CLM0.Bits.CLM01
#define ADC0CLM0_CLM02                  _ADC0CLM0.Bits.CLM02
#define ADC0CLM0_CLM03                  _ADC0CLM0.Bits.CLM03
#define ADC0CLM0_CLM04                  _ADC0CLM0.Bits.CLM04
#define ADC0CLM0_CLM05                  _ADC0CLM0.Bits.CLM05
#define ADC0CLM0_CLM0                   _ADC0CLM0.MergedBits.grpCLM0

#define ADC0CLM0_CLM00_MASK             1
#define ADC0CLM0_CLM01_MASK             2
#define ADC0CLM0_CLM02_MASK             4
#define ADC0CLM0_CLM03_MASK             8
#define ADC0CLM0_CLM04_MASK             16
#define ADC0CLM0_CLM05_MASK             32
#define ADC0CLM0_CLM0_MASK              63
#define ADC0CLM0_CLM0_BITNUM            0


/*** CLK_PRSC - CLKOUT Prescaler Register; 0x00001864 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** CLK_PRSC_H - CLKOUT Prescaler Register High; 0x00001864 ***/
    union {
      byte Byte;
      struct {
        byte BIT         :3;                                       /* CLKOUT Prescaler match value bits */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
    } CLK_PRSC_HSTR;
    #define CLK_PRSC_H                  _CLK_PRSC.Overlap_STR.CLK_PRSC_HSTR.Byte
    #define CLK_PRSC_H_BIT              _CLK_PRSC.Overlap_STR.CLK_PRSC_HSTR.Bits.BIT
    
    #define CLK_PRSC_H_BIT_MASK         7
    #define CLK_PRSC_H_BIT_BITNUM       0
    

    /*** CLK_PRSC_L - CLKOUT Prescaler Register Low; 0x00001865 ***/
    union {
      byte Byte;
      struct {
        byte             :8;                                       /* CLKOUT Prescaler match value bits */
      } Bits;
    } CLK_PRSC_LSTR;
    #define CLK_PRSC_L                  _CLK_PRSC.Overlap_STR.CLK_PRSC_LSTR.Byte
    
  } Overlap_STR;

} CLK_PRSCSTR;
extern volatile CLK_PRSCSTR _CLK_PRSC @0x00001864;
#define CLK_PRSC                        _CLK_PRSC.Word


/*** SCI2BD - SCI2 Baud Rate Register; 0x00001868 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SCI2BDH - SCI2 Baud Rate Register High; 0x00001868 ***/
    union {
      byte Byte;
      struct {
        byte SBR8        :1;                                       /* Baud Rate Modulo Divisor Bit 8 */
        byte SBR9        :1;                                       /* Baud Rate Modulo Divisor Bit 9 */
        byte SBR10       :1;                                       /* Baud Rate Modulo Divisor Bit 10 */
        byte SBR11       :1;                                       /* Baud Rate Modulo Divisor Bit 11 */
        byte SBR12       :1;                                       /* Baud Rate Modulo Divisor Bit 12 */
        byte             :1; 
        byte RXEDGIE     :1;                                       /* RxD Input Active Edge Interrupt Enable (for RXEDGIF) */
        byte LBKDIE      :1;                                       /* LIN Break Detect Interrupt Enable (for LBKDIF) */
      } Bits;
      struct {
        byte grpSBR_8 :5;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } SCI2BDHSTR;
    #define SCI2BDH                     _SCI2BD.Overlap_STR.SCI2BDHSTR.Byte
    #define SCI2BDH_SBR8                _SCI2BD.Overlap_STR.SCI2BDHSTR.Bits.SBR8
    #define SCI2BDH_SBR9                _SCI2BD.Overlap_STR.SCI2BDHSTR.Bits.SBR9
    #define SCI2BDH_SBR10               _SCI2BD.Overlap_STR.SCI2BDHSTR.Bits.SBR10
    #define SCI2BDH_SBR11               _SCI2BD.Overlap_STR.SCI2BDHSTR.Bits.SBR11
    #define SCI2BDH_SBR12               _SCI2BD.Overlap_STR.SCI2BDHSTR.Bits.SBR12
    #define SCI2BDH_RXEDGIE             _SCI2BD.Overlap_STR.SCI2BDHSTR.Bits.RXEDGIE
    #define SCI2BDH_LBKDIE              _SCI2BD.Overlap_STR.SCI2BDHSTR.Bits.LBKDIE
    #define SCI2BDH_SBR_8               _SCI2BD.Overlap_STR.SCI2BDHSTR.MergedBits.grpSBR_8
    #define SCI2BDH_SBR                 SCI2BDH_SBR_8
    
    #define SCI2BDH_SBR8_MASK           1
    #define SCI2BDH_SBR9_MASK           2
    #define SCI2BDH_SBR10_MASK          4
    #define SCI2BDH_SBR11_MASK          8
    #define SCI2BDH_SBR12_MASK          16
    #define SCI2BDH_RXEDGIE_MASK        64
    #define SCI2BDH_LBKDIE_MASK         128
    #define SCI2BDH_SBR_8_MASK          31
    #define SCI2BDH_SBR_8_BITNUM        0
    

    /*** SCI2BDL - SCI2 Baud Rate Register Low; 0x00001869 ***/
    union {
      byte Byte;
      struct {
        byte SBR0        :1;                                       /* Baud Rate Modulo Divisor Bit 0 */
        byte SBR1        :1;                                       /* Baud Rate Modulo Divisor Bit 1 */
        byte SBR2        :1;                                       /* Baud Rate Modulo Divisor Bit 2 */
        byte SBR3        :1;                                       /* Baud Rate Modulo Divisor Bit 3 */
        byte SBR4        :1;                                       /* Baud Rate Modulo Divisor Bit 4 */
        byte SBR5        :1;                                       /* Baud Rate Modulo Divisor Bit 5 */
        byte SBR6        :1;                                       /* Baud Rate Modulo Divisor Bit 6 */
        byte SBR7        :1;                                       /* Baud Rate Modulo Divisor Bit 7 */
      } Bits;
    } SCI2BDLSTR;
    #define SCI2BDL                     _SCI2BD.Overlap_STR.SCI2BDLSTR.Byte
    #define SCI2BDL_SBR0                _SCI2BD.Overlap_STR.SCI2BDLSTR.Bits.SBR0
    #define SCI2BDL_SBR1                _SCI2BD.Overlap_STR.SCI2BDLSTR.Bits.SBR1
    #define SCI2BDL_SBR2                _SCI2BD.Overlap_STR.SCI2BDLSTR.Bits.SBR2
    #define SCI2BDL_SBR3                _SCI2BD.Overlap_STR.SCI2BDLSTR.Bits.SBR3
    #define SCI2BDL_SBR4                _SCI2BD.Overlap_STR.SCI2BDLSTR.Bits.SBR4
    #define SCI2BDL_SBR5                _SCI2BD.Overlap_STR.SCI2BDLSTR.Bits.SBR5
    #define SCI2BDL_SBR6                _SCI2BD.Overlap_STR.SCI2BDLSTR.Bits.SBR6
    #define SCI2BDL_SBR7                _SCI2BD.Overlap_STR.SCI2BDLSTR.Bits.SBR7
    
    #define SCI2BDL_SBR0_MASK           1
    #define SCI2BDL_SBR1_MASK           2
    #define SCI2BDL_SBR2_MASK           4
    #define SCI2BDL_SBR3_MASK           8
    #define SCI2BDL_SBR4_MASK           16
    #define SCI2BDL_SBR5_MASK           32
    #define SCI2BDL_SBR6_MASK           64
    #define SCI2BDL_SBR7_MASK           128
    
  } Overlap_STR;

} SCI2BDSTR;
extern volatile SCI2BDSTR _SCI2BD @0x00001868;
#define SCI2BD                          _SCI2BD.Word


/*** SCI2C1 - SCI2 Control Register 1; 0x0000186A ***/
typedef union {
  byte Byte;
  struct {
    byte PT          :1;                                       /* Parity Type */
    byte PE          :1;                                       /* Parity Enable */
    byte ILT         :1;                                       /* Idle Line Type Select */
    byte WAKE        :1;                                       /* Receiver Wakeup Method Select */
    byte M           :1;                                       /* 9-Bit or 8-Bit Mode Select */
    byte RSRC        :1;                                       /* Receiver Source Select */
    byte SCISWAI     :1;                                       /* SCI Stops in Wait Mode */
    byte LOOPS       :1;                                       /* Loop Mode Select */
  } Bits;
} SCI2C1STR;
extern volatile SCI2C1STR _SCI2C1 @0x0000186A;
#define SCI2C1                          _SCI2C1.Byte
#define SCI2C1_PT                       _SCI2C1.Bits.PT
#define SCI2C1_PE                       _SCI2C1.Bits.PE
#define SCI2C1_ILT                      _SCI2C1.Bits.ILT
#define SCI2C1_WAKE                     _SCI2C1.Bits.WAKE
#define SCI2C1_M                        _SCI2C1.Bits.M
#define SCI2C1_RSRC                     _SCI2C1.Bits.RSRC
#define SCI2C1_SCISWAI                  _SCI2C1.Bits.SCISWAI
#define SCI2C1_LOOPS                    _SCI2C1.Bits.LOOPS

#define SCI2C1_PT_MASK                  1
#define SCI2C1_PE_MASK                  2
#define SCI2C1_ILT_MASK                 4
#define SCI2C1_WAKE_MASK                8
#define SCI2C1_M_MASK                   16
#define SCI2C1_RSRC_MASK                32
#define SCI2C1_SCISWAI_MASK             64
#define SCI2C1_LOOPS_MASK               128


/*** SCI2C2 - SCI2 Control Register 2; 0x0000186B ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break */
    byte RWU         :1;                                       /* Receiver Wakeup Control */
    byte RE          :1;                                       /* Receiver Enable */
    byte TE          :1;                                       /* Transmitter Enable */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable (for IDLE) */
    byte RIE         :1;                                       /* Receiver Interrupt Enable (for RDRF) */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable (for TC) */
    byte TIE         :1;                                       /* Transmit Interrupt Enable (for TDRE) */
  } Bits;
} SCI2C2STR;
extern volatile SCI2C2STR _SCI2C2 @0x0000186B;
#define SCI2C2                          _SCI2C2.Byte
#define SCI2C2_SBK                      _SCI2C2.Bits.SBK
#define SCI2C2_RWU                      _SCI2C2.Bits.RWU
#define SCI2C2_RE                       _SCI2C2.Bits.RE
#define SCI2C2_TE                       _SCI2C2.Bits.TE
#define SCI2C2_ILIE                     _SCI2C2.Bits.ILIE
#define SCI2C2_RIE                      _SCI2C2.Bits.RIE
#define SCI2C2_TCIE                     _SCI2C2.Bits.TCIE
#define SCI2C2_TIE                      _SCI2C2.Bits.TIE

#define SCI2C2_SBK_MASK                 1
#define SCI2C2_RWU_MASK                 2
#define SCI2C2_RE_MASK                  4
#define SCI2C2_TE_MASK                  8
#define SCI2C2_ILIE_MASK                16
#define SCI2C2_RIE_MASK                 32
#define SCI2C2_TCIE_MASK                64
#define SCI2C2_TIE_MASK                 128


/*** SCI2S1 - SCI2 Status Register 1; 0x0000186C ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Receiver Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF        :1;                                       /* Receive Data Register Full Flag */
    byte TC          :1;                                       /* Transmission Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} SCI2S1STR;
extern volatile SCI2S1STR _SCI2S1 @0x0000186C;
#define SCI2S1                          _SCI2S1.Byte
#define SCI2S1_PF                       _SCI2S1.Bits.PF
#define SCI2S1_FE                       _SCI2S1.Bits.FE
#define SCI2S1_NF                       _SCI2S1.Bits.NF
#define SCI2S1_OR                       _SCI2S1.Bits.OR
#define SCI2S1_IDLE                     _SCI2S1.Bits.IDLE
#define SCI2S1_RDRF                     _SCI2S1.Bits.RDRF
#define SCI2S1_TC                       _SCI2S1.Bits.TC
#define SCI2S1_TDRE                     _SCI2S1.Bits.TDRE

#define SCI2S1_PF_MASK                  1
#define SCI2S1_FE_MASK                  2
#define SCI2S1_NF_MASK                  4
#define SCI2S1_OR_MASK                  8
#define SCI2S1_IDLE_MASK                16
#define SCI2S1_RDRF_MASK                32
#define SCI2S1_TC_MASK                  64
#define SCI2S1_TDRE_MASK                128


/*** SCI2S2 - SCI2 Status Register 2; 0x0000186D ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte LBKDE       :1;                                       /* LIN Break Detection Enable */
    byte BRK13       :1;                                       /* Break Character Generation Length */
    byte RWUID       :1;                                       /* Receive Wake Up Idle Detect */
    byte RXINV       :1;                                       /* Receive Data Inversion */
    byte             :1; 
    byte RXEDGIF     :1;                                       /* RxD Pin Active Edge Interrupt Flag */
    byte LBKDIF      :1;                                       /* LIN Break Detect Interrupt Flag */
  } Bits;
} SCI2S2STR;
extern volatile SCI2S2STR _SCI2S2 @0x0000186D;
#define SCI2S2                          _SCI2S2.Byte
#define SCI2S2_RAF                      _SCI2S2.Bits.RAF
#define SCI2S2_LBKDE                    _SCI2S2.Bits.LBKDE
#define SCI2S2_BRK13                    _SCI2S2.Bits.BRK13
#define SCI2S2_RWUID                    _SCI2S2.Bits.RWUID
#define SCI2S2_RXINV                    _SCI2S2.Bits.RXINV
#define SCI2S2_RXEDGIF                  _SCI2S2.Bits.RXEDGIF
#define SCI2S2_LBKDIF                   _SCI2S2.Bits.LBKDIF

#define SCI2S2_RAF_MASK                 1
#define SCI2S2_LBKDE_MASK               2
#define SCI2S2_BRK13_MASK               4
#define SCI2S2_RWUID_MASK               8
#define SCI2S2_RXINV_MASK               16
#define SCI2S2_RXEDGIF_MASK             64
#define SCI2S2_LBKDIF_MASK              128


/*** SCI2C3 - SCI2 Control Register 3; 0x0000186E ***/
typedef union {
  byte Byte;
  struct {
    byte PEIE        :1;                                       /* Parity Error Interrupt Enable */
    byte FEIE        :1;                                       /* Framing Error Interrupt Enable */
    byte NEIE        :1;                                       /* Noise Error Interrupt Enable */
    byte ORIE        :1;                                       /* Overrun Interrupt Enable */
    byte TXINV       :1;                                       /* Transmit Data Inversion */
    byte TXDIR       :1;                                       /* TxD Pin Direction in Single-Wire Mode */
    byte T8          :1;                                       /* Ninth Data Bit for Transmitter */
    byte R8          :1;                                       /* Ninth Data Bit for Receiver */
  } Bits;
} SCI2C3STR;
extern volatile SCI2C3STR _SCI2C3 @0x0000186E;
#define SCI2C3                          _SCI2C3.Byte
#define SCI2C3_PEIE                     _SCI2C3.Bits.PEIE
#define SCI2C3_FEIE                     _SCI2C3.Bits.FEIE
#define SCI2C3_NEIE                     _SCI2C3.Bits.NEIE
#define SCI2C3_ORIE                     _SCI2C3.Bits.ORIE
#define SCI2C3_TXINV                    _SCI2C3.Bits.TXINV
#define SCI2C3_TXDIR                    _SCI2C3.Bits.TXDIR
#define SCI2C3_T8                       _SCI2C3.Bits.T8
#define SCI2C3_R8                       _SCI2C3.Bits.R8

#define SCI2C3_PEIE_MASK                1
#define SCI2C3_FEIE_MASK                2
#define SCI2C3_NEIE_MASK                4
#define SCI2C3_ORIE_MASK                8
#define SCI2C3_TXINV_MASK               16
#define SCI2C3_TXDIR_MASK               32
#define SCI2C3_T8_MASK                  64
#define SCI2C3_R8_MASK                  128


/*** SCI2D - SCI2 Data Register; 0x0000186F ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Receive/Transmit Data Bit 0 */
    byte R1_T1       :1;                                       /* Receive/Transmit Data Bit 1 */
    byte R2_T2       :1;                                       /* Receive/Transmit Data Bit 2 */
    byte R3_T3       :1;                                       /* Receive/Transmit Data Bit 3 */
    byte R4_T4       :1;                                       /* Receive/Transmit Data Bit 4 */
    byte R5_T5       :1;                                       /* Receive/Transmit Data Bit 5 */
    byte R6_T6       :1;                                       /* Receive/Transmit Data Bit 6 */
    byte R7_T7       :1;                                       /* Receive/Transmit Data Bit 7 */
  } Bits;
} SCI2DSTR;
extern volatile SCI2DSTR _SCI2D @0x0000186F;
#define SCI2D                           _SCI2D.Byte
#define SCI2D_R0_T0                     _SCI2D.Bits.R0_T0
#define SCI2D_R1_T1                     _SCI2D.Bits.R1_T1
#define SCI2D_R2_T2                     _SCI2D.Bits.R2_T2
#define SCI2D_R3_T3                     _SCI2D.Bits.R3_T3
#define SCI2D_R4_T4                     _SCI2D.Bits.R4_T4
#define SCI2D_R5_T5                     _SCI2D.Bits.R5_T5
#define SCI2D_R6_T6                     _SCI2D.Bits.R6_T6
#define SCI2D_R7_T7                     _SCI2D.Bits.R7_T7

#define SCI2D_R0_T0_MASK                1
#define SCI2D_R1_T1_MASK                2
#define SCI2D_R2_T2_MASK                4
#define SCI2D_R3_T3_MASK                8
#define SCI2D_R4_T4_MASK                16
#define SCI2D_R5_T5_MASK                32
#define SCI2D_R6_T6_MASK                64
#define SCI2D_R7_T7_MASK                128


/*** SCI3BD - SCI3 Baud Rate Register; 0x00001870 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** SCI3BDH - SCI3 Baud Rate Register High; 0x00001870 ***/
    union {
      byte Byte;
      struct {
        byte SBR8        :1;                                       /* Baud Rate Modulo Divisor Bit 8 */
        byte SBR9        :1;                                       /* Baud Rate Modulo Divisor Bit 9 */
        byte SBR10       :1;                                       /* Baud Rate Modulo Divisor Bit 10 */
        byte SBR11       :1;                                       /* Baud Rate Modulo Divisor Bit 11 */
        byte SBR12       :1;                                       /* Baud Rate Modulo Divisor Bit 12 */
        byte             :1; 
        byte RXEDGIE     :1;                                       /* RxD Input Active Edge Interrupt Enable (for RXEDGIF) */
        byte LBKDIE      :1;                                       /* LIN Break Detect Interrupt Enable (for LBKDIF) */
      } Bits;
      struct {
        byte grpSBR_8 :5;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } SCI3BDHSTR;
    #define SCI3BDH                     _SCI3BD.Overlap_STR.SCI3BDHSTR.Byte
    #define SCI3BDH_SBR8                _SCI3BD.Overlap_STR.SCI3BDHSTR.Bits.SBR8
    #define SCI3BDH_SBR9                _SCI3BD.Overlap_STR.SCI3BDHSTR.Bits.SBR9
    #define SCI3BDH_SBR10               _SCI3BD.Overlap_STR.SCI3BDHSTR.Bits.SBR10
    #define SCI3BDH_SBR11               _SCI3BD.Overlap_STR.SCI3BDHSTR.Bits.SBR11
    #define SCI3BDH_SBR12               _SCI3BD.Overlap_STR.SCI3BDHSTR.Bits.SBR12
    #define SCI3BDH_RXEDGIE             _SCI3BD.Overlap_STR.SCI3BDHSTR.Bits.RXEDGIE
    #define SCI3BDH_LBKDIE              _SCI3BD.Overlap_STR.SCI3BDHSTR.Bits.LBKDIE
    #define SCI3BDH_SBR_8               _SCI3BD.Overlap_STR.SCI3BDHSTR.MergedBits.grpSBR_8
    #define SCI3BDH_SBR                 SCI3BDH_SBR_8
    
    #define SCI3BDH_SBR8_MASK           1
    #define SCI3BDH_SBR9_MASK           2
    #define SCI3BDH_SBR10_MASK          4
    #define SCI3BDH_SBR11_MASK          8
    #define SCI3BDH_SBR12_MASK          16
    #define SCI3BDH_RXEDGIE_MASK        64
    #define SCI3BDH_LBKDIE_MASK         128
    #define SCI3BDH_SBR_8_MASK          31
    #define SCI3BDH_SBR_8_BITNUM        0
    

    /*** SCI3BDL - SCI3 Baud Rate Register Low; 0x00001871 ***/
    union {
      byte Byte;
      struct {
        byte SBR0        :1;                                       /* Baud Rate Modulo Divisor Bit 0 */
        byte SBR1        :1;                                       /* Baud Rate Modulo Divisor Bit 1 */
        byte SBR2        :1;                                       /* Baud Rate Modulo Divisor Bit 2 */
        byte SBR3        :1;                                       /* Baud Rate Modulo Divisor Bit 3 */
        byte SBR4        :1;                                       /* Baud Rate Modulo Divisor Bit 4 */
        byte SBR5        :1;                                       /* Baud Rate Modulo Divisor Bit 5 */
        byte SBR6        :1;                                       /* Baud Rate Modulo Divisor Bit 6 */
        byte SBR7        :1;                                       /* Baud Rate Modulo Divisor Bit 7 */
      } Bits;
    } SCI3BDLSTR;
    #define SCI3BDL                     _SCI3BD.Overlap_STR.SCI3BDLSTR.Byte
    #define SCI3BDL_SBR0                _SCI3BD.Overlap_STR.SCI3BDLSTR.Bits.SBR0
    #define SCI3BDL_SBR1                _SCI3BD.Overlap_STR.SCI3BDLSTR.Bits.SBR1
    #define SCI3BDL_SBR2                _SCI3BD.Overlap_STR.SCI3BDLSTR.Bits.SBR2
    #define SCI3BDL_SBR3                _SCI3BD.Overlap_STR.SCI3BDLSTR.Bits.SBR3
    #define SCI3BDL_SBR4                _SCI3BD.Overlap_STR.SCI3BDLSTR.Bits.SBR4
    #define SCI3BDL_SBR5                _SCI3BD.Overlap_STR.SCI3BDLSTR.Bits.SBR5
    #define SCI3BDL_SBR6                _SCI3BD.Overlap_STR.SCI3BDLSTR.Bits.SBR6
    #define SCI3BDL_SBR7                _SCI3BD.Overlap_STR.SCI3BDLSTR.Bits.SBR7
    
    #define SCI3BDL_SBR0_MASK           1
    #define SCI3BDL_SBR1_MASK           2
    #define SCI3BDL_SBR2_MASK           4
    #define SCI3BDL_SBR3_MASK           8
    #define SCI3BDL_SBR4_MASK           16
    #define SCI3BDL_SBR5_MASK           32
    #define SCI3BDL_SBR6_MASK           64
    #define SCI3BDL_SBR7_MASK           128
    
  } Overlap_STR;

} SCI3BDSTR;
extern volatile SCI3BDSTR _SCI3BD @0x00001870;
#define SCI3BD                          _SCI3BD.Word


/*** SCI3C1 - SCI3 Control Register 1; 0x00001872 ***/
typedef union {
  byte Byte;
  struct {
    byte PT          :1;                                       /* Parity Type */
    byte PE          :1;                                       /* Parity Enable */
    byte ILT         :1;                                       /* Idle Line Type Select */
    byte WAKE        :1;                                       /* Receiver Wakeup Method Select */
    byte M           :1;                                       /* 9-Bit or 8-Bit Mode Select */
    byte RSRC        :1;                                       /* Receiver Source Select */
    byte SCISWAI     :1;                                       /* SCI Stops in Wait Mode */
    byte LOOPS       :1;                                       /* Loop Mode Select */
  } Bits;
} SCI3C1STR;
extern volatile SCI3C1STR _SCI3C1 @0x00001872;
#define SCI3C1                          _SCI3C1.Byte
#define SCI3C1_PT                       _SCI3C1.Bits.PT
#define SCI3C1_PE                       _SCI3C1.Bits.PE
#define SCI3C1_ILT                      _SCI3C1.Bits.ILT
#define SCI3C1_WAKE                     _SCI3C1.Bits.WAKE
#define SCI3C1_M                        _SCI3C1.Bits.M
#define SCI3C1_RSRC                     _SCI3C1.Bits.RSRC
#define SCI3C1_SCISWAI                  _SCI3C1.Bits.SCISWAI
#define SCI3C1_LOOPS                    _SCI3C1.Bits.LOOPS

#define SCI3C1_PT_MASK                  1
#define SCI3C1_PE_MASK                  2
#define SCI3C1_ILT_MASK                 4
#define SCI3C1_WAKE_MASK                8
#define SCI3C1_M_MASK                   16
#define SCI3C1_RSRC_MASK                32
#define SCI3C1_SCISWAI_MASK             64
#define SCI3C1_LOOPS_MASK               128


/*** SCI3C2 - SCI3 Control Register 2; 0x00001873 ***/
typedef union {
  byte Byte;
  struct {
    byte SBK         :1;                                       /* Send Break */
    byte RWU         :1;                                       /* Receiver Wakeup Control */
    byte RE          :1;                                       /* Receiver Enable */
    byte TE          :1;                                       /* Transmitter Enable */
    byte ILIE        :1;                                       /* Idle Line Interrupt Enable (for IDLE) */
    byte RIE         :1;                                       /* Receiver Interrupt Enable (for RDRF) */
    byte TCIE        :1;                                       /* Transmission Complete Interrupt Enable (for TC) */
    byte TIE         :1;                                       /* Transmit Interrupt Enable (for TDRE) */
  } Bits;
} SCI3C2STR;
extern volatile SCI3C2STR _SCI3C2 @0x00001873;
#define SCI3C2                          _SCI3C2.Byte
#define SCI3C2_SBK                      _SCI3C2.Bits.SBK
#define SCI3C2_RWU                      _SCI3C2.Bits.RWU
#define SCI3C2_RE                       _SCI3C2.Bits.RE
#define SCI3C2_TE                       _SCI3C2.Bits.TE
#define SCI3C2_ILIE                     _SCI3C2.Bits.ILIE
#define SCI3C2_RIE                      _SCI3C2.Bits.RIE
#define SCI3C2_TCIE                     _SCI3C2.Bits.TCIE
#define SCI3C2_TIE                      _SCI3C2.Bits.TIE

#define SCI3C2_SBK_MASK                 1
#define SCI3C2_RWU_MASK                 2
#define SCI3C2_RE_MASK                  4
#define SCI3C2_TE_MASK                  8
#define SCI3C2_ILIE_MASK                16
#define SCI3C2_RIE_MASK                 32
#define SCI3C2_TCIE_MASK                64
#define SCI3C2_TIE_MASK                 128


/*** SCI3S1 - SCI3 Status Register 1; 0x00001874 ***/
typedef union {
  byte Byte;
  struct {
    byte PF          :1;                                       /* Parity Error Flag */
    byte FE          :1;                                       /* Framing Error Flag */
    byte NF          :1;                                       /* Noise Flag */
    byte OR          :1;                                       /* Receiver Overrun Flag */
    byte IDLE        :1;                                       /* Idle Line Flag */
    byte RDRF        :1;                                       /* Receive Data Register Full Flag */
    byte TC          :1;                                       /* Transmission Complete Flag */
    byte TDRE        :1;                                       /* Transmit Data Register Empty Flag */
  } Bits;
} SCI3S1STR;
extern volatile SCI3S1STR _SCI3S1 @0x00001874;
#define SCI3S1                          _SCI3S1.Byte
#define SCI3S1_PF                       _SCI3S1.Bits.PF
#define SCI3S1_FE                       _SCI3S1.Bits.FE
#define SCI3S1_NF                       _SCI3S1.Bits.NF
#define SCI3S1_OR                       _SCI3S1.Bits.OR
#define SCI3S1_IDLE                     _SCI3S1.Bits.IDLE
#define SCI3S1_RDRF                     _SCI3S1.Bits.RDRF
#define SCI3S1_TC                       _SCI3S1.Bits.TC
#define SCI3S1_TDRE                     _SCI3S1.Bits.TDRE

#define SCI3S1_PF_MASK                  1
#define SCI3S1_FE_MASK                  2
#define SCI3S1_NF_MASK                  4
#define SCI3S1_OR_MASK                  8
#define SCI3S1_IDLE_MASK                16
#define SCI3S1_RDRF_MASK                32
#define SCI3S1_TC_MASK                  64
#define SCI3S1_TDRE_MASK                128


/*** SCI3S2 - SCI3 Status Register 2; 0x00001875 ***/
typedef union {
  byte Byte;
  struct {
    byte RAF         :1;                                       /* Receiver Active Flag */
    byte LBKDE       :1;                                       /* LIN Break Detection Enable */
    byte BRK13       :1;                                       /* Break Character Generation Length */
    byte RWUID       :1;                                       /* Receive Wake Up Idle Detect */
    byte RXINV       :1;                                       /* Receive Data Inversion */
    byte             :1; 
    byte RXEDGIF     :1;                                       /* RxD Pin Active Edge Interrupt Flag */
    byte LBKDIF      :1;                                       /* LIN Break Detect Interrupt Flag */
  } Bits;
} SCI3S2STR;
extern volatile SCI3S2STR _SCI3S2 @0x00001875;
#define SCI3S2                          _SCI3S2.Byte
#define SCI3S2_RAF                      _SCI3S2.Bits.RAF
#define SCI3S2_LBKDE                    _SCI3S2.Bits.LBKDE
#define SCI3S2_BRK13                    _SCI3S2.Bits.BRK13
#define SCI3S2_RWUID                    _SCI3S2.Bits.RWUID
#define SCI3S2_RXINV                    _SCI3S2.Bits.RXINV
#define SCI3S2_RXEDGIF                  _SCI3S2.Bits.RXEDGIF
#define SCI3S2_LBKDIF                   _SCI3S2.Bits.LBKDIF

#define SCI3S2_RAF_MASK                 1
#define SCI3S2_LBKDE_MASK               2
#define SCI3S2_BRK13_MASK               4
#define SCI3S2_RWUID_MASK               8
#define SCI3S2_RXINV_MASK               16
#define SCI3S2_RXEDGIF_MASK             64
#define SCI3S2_LBKDIF_MASK              128


/*** SCI3C3 - SCI3 Control Register 3; 0x00001876 ***/
typedef union {
  byte Byte;
  struct {
    byte PEIE        :1;                                       /* Parity Error Interrupt Enable */
    byte FEIE        :1;                                       /* Framing Error Interrupt Enable */
    byte NEIE        :1;                                       /* Noise Error Interrupt Enable */
    byte ORIE        :1;                                       /* Overrun Interrupt Enable */
    byte TXINV       :1;                                       /* Transmit Data Inversion */
    byte TXDIR       :1;                                       /* TxD Pin Direction in Single-Wire Mode */
    byte T8          :1;                                       /* Ninth Data Bit for Transmitter */
    byte R8          :1;                                       /* Ninth Data Bit for Receiver */
  } Bits;
} SCI3C3STR;
extern volatile SCI3C3STR _SCI3C3 @0x00001876;
#define SCI3C3                          _SCI3C3.Byte
#define SCI3C3_PEIE                     _SCI3C3.Bits.PEIE
#define SCI3C3_FEIE                     _SCI3C3.Bits.FEIE
#define SCI3C3_NEIE                     _SCI3C3.Bits.NEIE
#define SCI3C3_ORIE                     _SCI3C3.Bits.ORIE
#define SCI3C3_TXINV                    _SCI3C3.Bits.TXINV
#define SCI3C3_TXDIR                    _SCI3C3.Bits.TXDIR
#define SCI3C3_T8                       _SCI3C3.Bits.T8
#define SCI3C3_R8                       _SCI3C3.Bits.R8

#define SCI3C3_PEIE_MASK                1
#define SCI3C3_FEIE_MASK                2
#define SCI3C3_NEIE_MASK                4
#define SCI3C3_ORIE_MASK                8
#define SCI3C3_TXINV_MASK               16
#define SCI3C3_TXDIR_MASK               32
#define SCI3C3_T8_MASK                  64
#define SCI3C3_R8_MASK                  128


/*** SCI3D - SCI3 Data Register; 0x00001877 ***/
typedef union {
  byte Byte;
  struct {
    byte R0_T0       :1;                                       /* Receive/Transmit Data Bit 0 */
    byte R1_T1       :1;                                       /* Receive/Transmit Data Bit 1 */
    byte R2_T2       :1;                                       /* Receive/Transmit Data Bit 2 */
    byte R3_T3       :1;                                       /* Receive/Transmit Data Bit 3 */
    byte R4_T4       :1;                                       /* Receive/Transmit Data Bit 4 */
    byte R5_T5       :1;                                       /* Receive/Transmit Data Bit 5 */
    byte R6_T6       :1;                                       /* Receive/Transmit Data Bit 6 */
    byte R7_T7       :1;                                       /* Receive/Transmit Data Bit 7 */
  } Bits;
} SCI3DSTR;
extern volatile SCI3DSTR _SCI3D @0x00001877;
#define SCI3D                           _SCI3D.Byte
#define SCI3D_R0_T0                     _SCI3D.Bits.R0_T0
#define SCI3D_R1_T1                     _SCI3D.Bits.R1_T1
#define SCI3D_R2_T2                     _SCI3D.Bits.R2_T2
#define SCI3D_R3_T3                     _SCI3D.Bits.R3_T3
#define SCI3D_R4_T4                     _SCI3D.Bits.R4_T4
#define SCI3D_R5_T5                     _SCI3D.Bits.R5_T5
#define SCI3D_R6_T6                     _SCI3D.Bits.R6_T6
#define SCI3D_R7_T7                     _SCI3D.Bits.R7_T7

#define SCI3D_R0_T0_MASK                1
#define SCI3D_R1_T1_MASK                2
#define SCI3D_R2_T2_MASK                4
#define SCI3D_R3_T3_MASK                8
#define SCI3D_R4_T4_MASK                16
#define SCI3D_R5_T5_MASK                32
#define SCI3D_R6_T6_MASK                64
#define SCI3D_R7_T7_MASK                128


/*** LCDC0 - LCD Control Register 0; 0x00001878 ***/
typedef union {
  byte Byte;
  struct {
    byte DUTY0       :1;                                       /* LCD Duty Select Bit 0 */
    byte DUTY1       :1;                                       /* LCD Duty Select Bit 1 */
    byte DUTY2       :1;                                       /* LCD Duty Select Bit 2 */
    byte LCLK0       :1;                                       /* LCD Clock Prescaler Bit 0 */
    byte LCLK1       :1;                                       /* LCD Clock Prescaler Bit 1 */
    byte LCLK2       :1;                                       /* LCD Clock Prescaler Bit 2 */
    byte SOURCE      :1;                                       /* LCD Clock Source Select */
    byte LCDEN       :1;                                       /* LCD Driver Enable */
  } Bits;
  struct {
    byte grpDUTY :3;
    byte grpLCLK :3;
    byte         :1;
    byte         :1;
  } MergedBits;
} LCDC0STR;
extern volatile LCDC0STR _LCDC0 @0x00001878;
#define LCDC0                           _LCDC0.Byte
#define LCDC0_DUTY0                     _LCDC0.Bits.DUTY0
#define LCDC0_DUTY1                     _LCDC0.Bits.DUTY1
#define LCDC0_DUTY2                     _LCDC0.Bits.DUTY2
#define LCDC0_LCLK0                     _LCDC0.Bits.LCLK0
#define LCDC0_LCLK1                     _LCDC0.Bits.LCLK1
#define LCDC0_LCLK2                     _LCDC0.Bits.LCLK2
#define LCDC0_SOURCE                    _LCDC0.Bits.SOURCE
#define LCDC0_LCDEN                     _LCDC0.Bits.LCDEN
/* LCDC_ARR: Access 2 LCDCx registers in an array */
#define LCDC_ARR                        ((volatile byte * __far) &LCDC0)
#define LCDC0_DUTY                      _LCDC0.MergedBits.grpDUTY
#define LCDC0_LCLK                      _LCDC0.MergedBits.grpLCLK

#define LCDC0_DUTY0_MASK                1
#define LCDC0_DUTY1_MASK                2
#define LCDC0_DUTY2_MASK                4
#define LCDC0_LCLK0_MASK                8
#define LCDC0_LCLK1_MASK                16
#define LCDC0_LCLK2_MASK                32
#define LCDC0_SOURCE_MASK               64
#define LCDC0_LCDEN_MASK                128
#define LCDC0_DUTY_MASK                 7
#define LCDC0_DUTY_BITNUM               0
#define LCDC0_LCLK_MASK                 56
#define LCDC0_LCLK_BITNUM               3


/*** LCDC1 - LCD Control Register 1; 0x00001879 ***/
typedef union {
  byte Byte;
  struct {
    byte LCDSTP      :1;                                       /* LCD Module Driver and Charge Pump Stop While in Stop2 or Stop3 Mode */
    byte LCDWAI      :1;                                       /* LCD Module Driver and Charge Pump Stop While in Wait Mode */
    byte FCDEN       :1;                                       /* Full Complementary Drive Enable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte LCDIEN      :1;                                       /* LCD Module Frame Frequency Interrupt Enable */
  } Bits;
} LCDC1STR;
extern volatile LCDC1STR _LCDC1 @0x00001879;
#define LCDC1                           _LCDC1.Byte
#define LCDC1_LCDSTP                    _LCDC1.Bits.LCDSTP
#define LCDC1_LCDWAI                    _LCDC1.Bits.LCDWAI
#define LCDC1_FCDEN                     _LCDC1.Bits.FCDEN
#define LCDC1_LCDIEN                    _LCDC1.Bits.LCDIEN

#define LCDC1_LCDSTP_MASK               1
#define LCDC1_LCDWAI_MASK               2
#define LCDC1_FCDEN_MASK                4
#define LCDC1_LCDIEN_MASK               128


/*** LCDSUPPLY - LCD Voltage Supply Register; 0x0000187A ***/
typedef union {
  byte Byte;
  struct {
    byte VSUPPLY0    :1;                                       /* Voltage Supply Control Bit 0 */
    byte VSUPPLY1    :1;                                       /* Voltage Supply Control Bit 1 */
    byte BBYPASS     :1;                                       /* Op Amp Control */
    byte             :1; 
    byte LADJ0       :1;                                       /* LCD Module Load Adjust Bit 0 */
    byte LADJ1       :1;                                       /* LCD Module Load Adjust Bit 1 */
    byte HREFSEL     :1;                                       /* High Reference Select */
    byte CPSEL       :1;                                       /* Charge Pump or Resistor Bias Select */
  } Bits;
  struct {
    byte grpVSUPPLY :2;
    byte         :1;
    byte         :1;
    byte grpLADJ :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} LCDSUPPLYSTR;
extern volatile LCDSUPPLYSTR _LCDSUPPLY @0x0000187A;
#define LCDSUPPLY                       _LCDSUPPLY.Byte
#define LCDSUPPLY_VSUPPLY0              _LCDSUPPLY.Bits.VSUPPLY0
#define LCDSUPPLY_VSUPPLY1              _LCDSUPPLY.Bits.VSUPPLY1
#define LCDSUPPLY_BBYPASS               _LCDSUPPLY.Bits.BBYPASS
#define LCDSUPPLY_LADJ0                 _LCDSUPPLY.Bits.LADJ0
#define LCDSUPPLY_LADJ1                 _LCDSUPPLY.Bits.LADJ1
#define LCDSUPPLY_HREFSEL               _LCDSUPPLY.Bits.HREFSEL
#define LCDSUPPLY_CPSEL                 _LCDSUPPLY.Bits.CPSEL
#define LCDSUPPLY_VSUPPLY               _LCDSUPPLY.MergedBits.grpVSUPPLY
#define LCDSUPPLY_LADJ                  _LCDSUPPLY.MergedBits.grpLADJ

#define LCDSUPPLY_VSUPPLY0_MASK         1
#define LCDSUPPLY_VSUPPLY1_MASK         2
#define LCDSUPPLY_BBYPASS_MASK          4
#define LCDSUPPLY_LADJ0_MASK            16
#define LCDSUPPLY_LADJ1_MASK            32
#define LCDSUPPLY_HREFSEL_MASK          64
#define LCDSUPPLY_CPSEL_MASK            128
#define LCDSUPPLY_VSUPPLY_MASK          3
#define LCDSUPPLY_VSUPPLY_BITNUM        0
#define LCDSUPPLY_LADJ_MASK             48
#define LCDSUPPLY_LADJ_BITNUM           4


/*** LCDRVC - LCD Regulated Voltage Control Register; 0x0000187B ***/
typedef union {
  byte Byte;
  struct {
    byte RVTRIM0     :1;                                       /* Regulated Voltage Trim Bit 0 */
    byte RVTRIM1     :1;                                       /* Regulated Voltage Trim Bit 1 */
    byte RVTRIM2     :1;                                       /* Regulated Voltage Trim Bit 2 */
    byte RVTRIM3     :1;                                       /* Regulated Voltage Trim Bit 3 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte RVEN        :1;                                       /* Regulated Voltage Enable */
  } Bits;
  struct {
    byte grpRVTRIM :4;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} LCDRVCSTR;
extern volatile LCDRVCSTR _LCDRVC @0x0000187B;
#define LCDRVC                          _LCDRVC.Byte
#define LCDRVC_RVTRIM0                  _LCDRVC.Bits.RVTRIM0
#define LCDRVC_RVTRIM1                  _LCDRVC.Bits.RVTRIM1
#define LCDRVC_RVTRIM2                  _LCDRVC.Bits.RVTRIM2
#define LCDRVC_RVTRIM3                  _LCDRVC.Bits.RVTRIM3
#define LCDRVC_RVEN                     _LCDRVC.Bits.RVEN
#define LCDRVC_RVTRIM                   _LCDRVC.MergedBits.grpRVTRIM

#define LCDRVC_RVTRIM0_MASK             1
#define LCDRVC_RVTRIM1_MASK             2
#define LCDRVC_RVTRIM2_MASK             4
#define LCDRVC_RVTRIM3_MASK             8
#define LCDRVC_RVEN_MASK                128
#define LCDRVC_RVTRIM_MASK              15
#define LCDRVC_RVTRIM_BITNUM            0


/*** LCDBCTL - LCD Blink Control Register; 0x0000187C ***/
typedef union {
  byte Byte;
  struct {
    byte BRATE0      :1;                                       /* Blink-Rate Configuration Bit 0 */
    byte BRATE1      :1;                                       /* Blink-Rate Configuration Bit 1 */
    byte BRATE2      :1;                                       /* Blink-Rate Configuration Bit 2 */
    byte BMODE       :1;                                       /* Blink Mode */
    byte             :1; 
    byte BLANK       :1;                                       /* Blank Display Mode */
    byte ALT         :1;                                       /* Alternate Display Mode */
    byte BLINK       :1;                                       /* Blink Command */
  } Bits;
  struct {
    byte grpBRATE :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} LCDBCTLSTR;
extern volatile LCDBCTLSTR _LCDBCTL @0x0000187C;
#define LCDBCTL                         _LCDBCTL.Byte
#define LCDBCTL_BRATE0                  _LCDBCTL.Bits.BRATE0
#define LCDBCTL_BRATE1                  _LCDBCTL.Bits.BRATE1
#define LCDBCTL_BRATE2                  _LCDBCTL.Bits.BRATE2
#define LCDBCTL_BMODE                   _LCDBCTL.Bits.BMODE
#define LCDBCTL_BLANK                   _LCDBCTL.Bits.BLANK
#define LCDBCTL_ALT                     _LCDBCTL.Bits.ALT
#define LCDBCTL_BLINK                   _LCDBCTL.Bits.BLINK
#define LCDBCTL_BRATE                   _LCDBCTL.MergedBits.grpBRATE

#define LCDBCTL_BRATE0_MASK             1
#define LCDBCTL_BRATE1_MASK             2
#define LCDBCTL_BRATE2_MASK             4
#define LCDBCTL_BMODE_MASK              8
#define LCDBCTL_BLANK_MASK              32
#define LCDBCTL_ALT_MASK                64
#define LCDBCTL_BLINK_MASK              128
#define LCDBCTL_BRATE_MASK              7
#define LCDBCTL_BRATE_BITNUM            0


/*** LCDS - LCD Status Register; 0x0000187D ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte LCDIF       :1;                                       /* LCD Interrupt Flag */
  } Bits;
} LCDSSTR;
extern volatile LCDSSTR _LCDS @0x0000187D;
#define LCDS                            _LCDS.Byte
#define LCDS_LCDIF                      _LCDS.Bits.LCDIF

#define LCDS_LCDIF_MASK                 128


/*** IRTC_YEARMON - RTC Year and Month Counters Register (binary format); 0x00001880 ***/
typedef union {
  word Word;
  struct {
    word MONTH0      :1;                                       /* Month count value bits, bit 0 */
    word MONTH1      :1;                                       /* Month count value bits, bit 1 */
    word MONTH2      :1;                                       /* Month count value bits, bit 2 */
    word MONTH3      :1;                                       /* Month count value bits, bit 3 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word YEAR0       :1;                                       /* Year count value bits, bit 0 */
    word YEAR1       :1;                                       /* Year count value bits, bit 1 */
    word YEAR2       :1;                                       /* Year count value bits, bit 2 */
    word YEAR3       :1;                                       /* Year count value bits, bit 3 */
    word YEAR4       :1;                                       /* Year count value bits, bit 4 */
    word YEAR5       :1;                                       /* Year count value bits, bit 5 */
    word YEAR6       :1;                                       /* Year count value bits, bit 6 */
    word YEAR7       :1;                                       /* Year count value bits, bit 7 */
  } Bits;
  struct {
    word grpMONTH :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpYEAR :8;
  } MergedBits;
} IRTC_YEARMONSTR;
extern volatile IRTC_YEARMONSTR _IRTC_YEARMON @0x00001880;
#define IRTC_YEARMON                    _IRTC_YEARMON.Word
#define IRTC_YEARMON_MONTH0             _IRTC_YEARMON.Bits.MONTH0
#define IRTC_YEARMON_MONTH1             _IRTC_YEARMON.Bits.MONTH1
#define IRTC_YEARMON_MONTH2             _IRTC_YEARMON.Bits.MONTH2
#define IRTC_YEARMON_MONTH3             _IRTC_YEARMON.Bits.MONTH3
#define IRTC_YEARMON_YEAR0              _IRTC_YEARMON.Bits.YEAR0
#define IRTC_YEARMON_YEAR1              _IRTC_YEARMON.Bits.YEAR1
#define IRTC_YEARMON_YEAR2              _IRTC_YEARMON.Bits.YEAR2
#define IRTC_YEARMON_YEAR3              _IRTC_YEARMON.Bits.YEAR3
#define IRTC_YEARMON_YEAR4              _IRTC_YEARMON.Bits.YEAR4
#define IRTC_YEARMON_YEAR5              _IRTC_YEARMON.Bits.YEAR5
#define IRTC_YEARMON_YEAR6              _IRTC_YEARMON.Bits.YEAR6
#define IRTC_YEARMON_YEAR7              _IRTC_YEARMON.Bits.YEAR7
#define IRTC_YEARMON_MONTH              _IRTC_YEARMON.MergedBits.grpMONTH
#define IRTC_YEARMON_YEAR               _IRTC_YEARMON.MergedBits.grpYEAR

#define IRTC_YEARMON_MONTH0_MASK        1
#define IRTC_YEARMON_MONTH1_MASK        2
#define IRTC_YEARMON_MONTH2_MASK        4
#define IRTC_YEARMON_MONTH3_MASK        8
#define IRTC_YEARMON_YEAR0_MASK         256
#define IRTC_YEARMON_YEAR1_MASK         512
#define IRTC_YEARMON_YEAR2_MASK         1024
#define IRTC_YEARMON_YEAR3_MASK         2048
#define IRTC_YEARMON_YEAR4_MASK         4096
#define IRTC_YEARMON_YEAR5_MASK         8192
#define IRTC_YEARMON_YEAR6_MASK         16384
#define IRTC_YEARMON_YEAR7_MASK         32768
#define IRTC_YEARMON_MONTH_MASK         15
#define IRTC_YEARMON_MONTH_BITNUM       0
#define IRTC_YEARMON_YEAR_MASK          65280
#define IRTC_YEARMON_YEAR_BITNUM        8


/*** IRTC_DAYS - RTC Days Counter Register (binary format); 0x00001882 ***/
typedef union {
  word Word;
  struct {
    word DAYS0       :1;                                       /* Day Setting. Indicates the current day count. Valid Count: 1 - 31, bit 0 */
    word DAYS1       :1;                                       /* Day Setting. Indicates the current day count. Valid Count: 1 - 31, bit 1 */
    word DAYS2       :1;                                       /* Day Setting. Indicates the current day count. Valid Count: 1 - 31, bit 2 */
    word DAYS3       :1;                                       /* Day Setting. Indicates the current day count. Valid Count: 1 - 31, bit 3 */
    word DAYS4       :1;                                       /* Day Setting. Indicates the current day count. Valid Count: 1 - 31, bit 4 */
    word             :1; 
    word             :1; 
    word             :1; 
    word DAY_OF_WEEK0 :1;                                      /* Indicates the current day count, bit 0, bit 0 */
    word DAY_OF_WEEK1 :1;                                      /* Indicates the current day count, bit 0, bit 1 */
    word DAY_OF_WEEK2 :1;                                      /* Indicates the current day count, bit 0, bit 2 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpDAYS :5;
    word         :1;
    word         :1;
    word         :1;
    word grpDAY_OF_WEEK :3;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} IRTC_DAYSSTR;
extern volatile IRTC_DAYSSTR _IRTC_DAYS @0x00001882;
#define IRTC_DAYS                       _IRTC_DAYS.Word
#define IRTC_DAYS_DAYS0                 _IRTC_DAYS.Bits.DAYS0
#define IRTC_DAYS_DAYS1                 _IRTC_DAYS.Bits.DAYS1
#define IRTC_DAYS_DAYS2                 _IRTC_DAYS.Bits.DAYS2
#define IRTC_DAYS_DAYS3                 _IRTC_DAYS.Bits.DAYS3
#define IRTC_DAYS_DAYS4                 _IRTC_DAYS.Bits.DAYS4
#define IRTC_DAYS_DAY_OF_WEEK0          _IRTC_DAYS.Bits.DAY_OF_WEEK0
#define IRTC_DAYS_DAY_OF_WEEK1          _IRTC_DAYS.Bits.DAY_OF_WEEK1
#define IRTC_DAYS_DAY_OF_WEEK2          _IRTC_DAYS.Bits.DAY_OF_WEEK2
#define IRTC_DAYS_DAYS                  _IRTC_DAYS.MergedBits.grpDAYS
#define IRTC_DAYS_DAY_OF_WEEK           _IRTC_DAYS.MergedBits.grpDAY_OF_WEEK

#define IRTC_DAYS_DAYS0_MASK            1
#define IRTC_DAYS_DAYS1_MASK            2
#define IRTC_DAYS_DAYS2_MASK            4
#define IRTC_DAYS_DAYS3_MASK            8
#define IRTC_DAYS_DAYS4_MASK            16
#define IRTC_DAYS_DAY_OF_WEEK0_MASK     256
#define IRTC_DAYS_DAY_OF_WEEK1_MASK     512
#define IRTC_DAYS_DAY_OF_WEEK2_MASK     1024
#define IRTC_DAYS_DAYS_MASK             31
#define IRTC_DAYS_DAYS_BITNUM           0
#define IRTC_DAYS_DAY_OF_WEEK_MASK      1792
#define IRTC_DAYS_DAY_OF_WEEK_BITNUM    8


/*** IRTC_HOURMIN - RTC Hours and Minutes Counter Register (binary format); 0x00001884 ***/
typedef union {
  word Word;
  struct {
    word MINUTES0    :1;                                       /* Indicates the current minutes. It can be set to any value between 0 and 59 (0x3B), bit 0 */
    word MINUTES1    :1;                                       /* Indicates the current minutes. It can be set to any value between 0 and 59 (0x3B), bit 1 */
    word MINUTES2    :1;                                       /* Indicates the current minutes. It can be set to any value between 0 and 59 (0x3B), bit 2 */
    word MINUTES3    :1;                                       /* Indicates the current minutes. It can be set to any value between 0 and 59 (0x3B), bit 3 */
    word MINUTES4    :1;                                       /* Indicates the current minutes. It can be set to any value between 0 and 59 (0x3B), bit 4 */
    word MINUTES5    :1;                                       /* Indicates the current minutes. It can be set to any value between 0 and 59 (0x3B), bit 5 */
    word             :1; 
    word             :1; 
    word HOURS0      :1;                                       /* Indicates the current hour. It can be set to any value between 0 and 23 (0x17), bit 0 */
    word HOURS1      :1;                                       /* Indicates the current hour. It can be set to any value between 0 and 23 (0x17), bit 1 */
    word HOURS2      :1;                                       /* Indicates the current hour. It can be set to any value between 0 and 23 (0x17), bit 2 */
    word HOURS3      :1;                                       /* Indicates the current hour. It can be set to any value between 0 and 23 (0x17), bit 3 */
    word HOURS4      :1;                                       /* Indicates the current hour. It can be set to any value between 0 and 23 (0x17), bit 4 */
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpMINUTES :6;
    word         :1;
    word         :1;
    word grpHOURS :5;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} IRTC_HOURMINSTR;
extern volatile IRTC_HOURMINSTR _IRTC_HOURMIN @0x00001884;
#define IRTC_HOURMIN                    _IRTC_HOURMIN.Word
#define IRTC_HOURMIN_MINUTES0           _IRTC_HOURMIN.Bits.MINUTES0
#define IRTC_HOURMIN_MINUTES1           _IRTC_HOURMIN.Bits.MINUTES1
#define IRTC_HOURMIN_MINUTES2           _IRTC_HOURMIN.Bits.MINUTES2
#define IRTC_HOURMIN_MINUTES3           _IRTC_HOURMIN.Bits.MINUTES3
#define IRTC_HOURMIN_MINUTES4           _IRTC_HOURMIN.Bits.MINUTES4
#define IRTC_HOURMIN_MINUTES5           _IRTC_HOURMIN.Bits.MINUTES5
#define IRTC_HOURMIN_HOURS0             _IRTC_HOURMIN.Bits.HOURS0
#define IRTC_HOURMIN_HOURS1             _IRTC_HOURMIN.Bits.HOURS1
#define IRTC_HOURMIN_HOURS2             _IRTC_HOURMIN.Bits.HOURS2
#define IRTC_HOURMIN_HOURS3             _IRTC_HOURMIN.Bits.HOURS3
#define IRTC_HOURMIN_HOURS4             _IRTC_HOURMIN.Bits.HOURS4
#define IRTC_HOURMIN_MINUTES            _IRTC_HOURMIN.MergedBits.grpMINUTES
#define IRTC_HOURMIN_HOURS              _IRTC_HOURMIN.MergedBits.grpHOURS

#define IRTC_HOURMIN_MINUTES0_MASK      1
#define IRTC_HOURMIN_MINUTES1_MASK      2
#define IRTC_HOURMIN_MINUTES2_MASK      4
#define IRTC_HOURMIN_MINUTES3_MASK      8
#define IRTC_HOURMIN_MINUTES4_MASK      16
#define IRTC_HOURMIN_MINUTES5_MASK      32
#define IRTC_HOURMIN_HOURS0_MASK        256
#define IRTC_HOURMIN_HOURS1_MASK        512
#define IRTC_HOURMIN_HOURS2_MASK        1024
#define IRTC_HOURMIN_HOURS3_MASK        2048
#define IRTC_HOURMIN_HOURS4_MASK        4096
#define IRTC_HOURMIN_MINUTES_MASK       63
#define IRTC_HOURMIN_MINUTES_BITNUM     0
#define IRTC_HOURMIN_HOURS_MASK         7936
#define IRTC_HOURMIN_HOURS_BITNUM       8


/*** IRTC_SECONDS - RTC Seconds Counter Register  (binary format); 0x00001886 ***/
typedef union {
  word Word;
  struct {
    word SECONDS0    :1;                                       /* Indicates the current seconds. It can be set to any value between 0 and 59 (0x3B), bit 0 */
    word SECONDS1    :1;                                       /* Indicates the current seconds. It can be set to any value between 0 and 59 (0x3B), bit 1 */
    word SECONDS2    :1;                                       /* Indicates the current seconds. It can be set to any value between 0 and 59 (0x3B), bit 2 */
    word SECONDS3    :1;                                       /* Indicates the current seconds. It can be set to any value between 0 and 59 (0x3B), bit 3 */
    word SECONDS4    :1;                                       /* Indicates the current seconds. It can be set to any value between 0 and 59 (0x3B), bit 4 */
    word SECONDS5    :1;                                       /* Indicates the current seconds. It can be set to any value between 0 and 59 (0x3B), bit 5 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpSECONDS :6;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} IRTC_SECONDSSTR;
extern volatile IRTC_SECONDSSTR _IRTC_SECONDS @0x00001886;
#define IRTC_SECONDS                    _IRTC_SECONDS.Word
#define IRTC_SECONDS_SECONDS0           _IRTC_SECONDS.Bits.SECONDS0
#define IRTC_SECONDS_SECONDS1           _IRTC_SECONDS.Bits.SECONDS1
#define IRTC_SECONDS_SECONDS2           _IRTC_SECONDS.Bits.SECONDS2
#define IRTC_SECONDS_SECONDS3           _IRTC_SECONDS.Bits.SECONDS3
#define IRTC_SECONDS_SECONDS4           _IRTC_SECONDS.Bits.SECONDS4
#define IRTC_SECONDS_SECONDS5           _IRTC_SECONDS.Bits.SECONDS5
#define IRTC_SECONDS_SECONDS            _IRTC_SECONDS.MergedBits.grpSECONDS

#define IRTC_SECONDS_SECONDS0_MASK      1
#define IRTC_SECONDS_SECONDS1_MASK      2
#define IRTC_SECONDS_SECONDS2_MASK      4
#define IRTC_SECONDS_SECONDS3_MASK      8
#define IRTC_SECONDS_SECONDS4_MASK      16
#define IRTC_SECONDS_SECONDS5_MASK      32
#define IRTC_SECONDS_SECONDS_MASK       63
#define IRTC_SECONDS_SECONDS_BITNUM     0


/*** IRTC_ALM_YRMON - RTC Year and Month Alarm Register (binary format); 0x00001888 ***/
typedef union {
  word Word;
  struct {
    word AML_MONTH0  :1;                                       /* Month alarm value bits, bit 0 */
    word AML_MONTH1  :1;                                       /* Month alarm value bits, bit 1 */
    word AML_MONTH2  :1;                                       /* Month alarm value bits, bit 2 */
    word AML_MONTH3  :1;                                       /* Month alarm value bits, bit 3 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ALM_YEAR0   :1;                                       /* Year count value bits, bit 0 */
    word ALM_YEAR1   :1;                                       /* Year count value bits, bit 1 */
    word ALM_YEAR2   :1;                                       /* Year count value bits, bit 2 */
    word ALM_YEAR3   :1;                                       /* Year count value bits, bit 3 */
    word ALM_YEAR4   :1;                                       /* Year count value bits, bit 4 */
    word ALM_YEAR5   :1;                                       /* Year count value bits, bit 5 */
    word ALM_YEAR6   :1;                                       /* Year count value bits, bit 6 */
    word ALM_YEAR7   :1;                                       /* Year count value bits, bit 7 */
  } Bits;
  struct {
    word grpAML_MONTH :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpALM_YEAR :8;
  } MergedBits;
} IRTC_ALM_YRMONSTR;
extern volatile IRTC_ALM_YRMONSTR _IRTC_ALM_YRMON @0x00001888;
#define IRTC_ALM_YRMON                  _IRTC_ALM_YRMON.Word
#define IRTC_ALM_YRMON_AML_MONTH0       _IRTC_ALM_YRMON.Bits.AML_MONTH0
#define IRTC_ALM_YRMON_AML_MONTH1       _IRTC_ALM_YRMON.Bits.AML_MONTH1
#define IRTC_ALM_YRMON_AML_MONTH2       _IRTC_ALM_YRMON.Bits.AML_MONTH2
#define IRTC_ALM_YRMON_AML_MONTH3       _IRTC_ALM_YRMON.Bits.AML_MONTH3
#define IRTC_ALM_YRMON_ALM_YEAR0        _IRTC_ALM_YRMON.Bits.ALM_YEAR0
#define IRTC_ALM_YRMON_ALM_YEAR1        _IRTC_ALM_YRMON.Bits.ALM_YEAR1
#define IRTC_ALM_YRMON_ALM_YEAR2        _IRTC_ALM_YRMON.Bits.ALM_YEAR2
#define IRTC_ALM_YRMON_ALM_YEAR3        _IRTC_ALM_YRMON.Bits.ALM_YEAR3
#define IRTC_ALM_YRMON_ALM_YEAR4        _IRTC_ALM_YRMON.Bits.ALM_YEAR4
#define IRTC_ALM_YRMON_ALM_YEAR5        _IRTC_ALM_YRMON.Bits.ALM_YEAR5
#define IRTC_ALM_YRMON_ALM_YEAR6        _IRTC_ALM_YRMON.Bits.ALM_YEAR6
#define IRTC_ALM_YRMON_ALM_YEAR7        _IRTC_ALM_YRMON.Bits.ALM_YEAR7
#define IRTC_ALM_YRMON_AML_MONTH        _IRTC_ALM_YRMON.MergedBits.grpAML_MONTH
#define IRTC_ALM_YRMON_ALM_YEAR         _IRTC_ALM_YRMON.MergedBits.grpALM_YEAR

#define IRTC_ALM_YRMON_AML_MONTH0_MASK  1
#define IRTC_ALM_YRMON_AML_MONTH1_MASK  2
#define IRTC_ALM_YRMON_AML_MONTH2_MASK  4
#define IRTC_ALM_YRMON_AML_MONTH3_MASK  8
#define IRTC_ALM_YRMON_ALM_YEAR0_MASK   256
#define IRTC_ALM_YRMON_ALM_YEAR1_MASK   512
#define IRTC_ALM_YRMON_ALM_YEAR2_MASK   1024
#define IRTC_ALM_YRMON_ALM_YEAR3_MASK   2048
#define IRTC_ALM_YRMON_ALM_YEAR4_MASK   4096
#define IRTC_ALM_YRMON_ALM_YEAR5_MASK   8192
#define IRTC_ALM_YRMON_ALM_YEAR6_MASK   16384
#define IRTC_ALM_YRMON_ALM_YEAR7_MASK   32768
#define IRTC_ALM_YRMON_AML_MONTH_MASK   15
#define IRTC_ALM_YRMON_AML_MONTH_BITNUM 0
#define IRTC_ALM_YRMON_ALM_YEAR_MASK    65280
#define IRTC_ALM_YRMON_ALM_YEAR_BITNUM  8


/*** IRTC_ALM_DAYS - RTC Day Alarm Register (binary format); 0x0000188A ***/
typedef union {
  word Word;
  struct {
    word ALM_DAYS0   :1;                                       /* Indicates the current day setting of the alarm, bit 0 */
    word ALM_DAYS1   :1;                                       /* Indicates the current day setting of the alarm, bit 1 */
    word ALM_DAYS2   :1;                                       /* Indicates the current day setting of the alarm, bit 2 */
    word ALM_DAYS3   :1;                                       /* Indicates the current day setting of the alarm, bit 3 */
    word ALM_DAYS4   :1;                                       /* Indicates the current day setting of the alarm, bit 4 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpALM_DAYS :5;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} IRTC_ALM_DAYSSTR;
extern volatile IRTC_ALM_DAYSSTR _IRTC_ALM_DAYS @0x0000188A;
#define IRTC_ALM_DAYS                   _IRTC_ALM_DAYS.Word
#define IRTC_ALM_DAYS_ALM_DAYS0         _IRTC_ALM_DAYS.Bits.ALM_DAYS0
#define IRTC_ALM_DAYS_ALM_DAYS1         _IRTC_ALM_DAYS.Bits.ALM_DAYS1
#define IRTC_ALM_DAYS_ALM_DAYS2         _IRTC_ALM_DAYS.Bits.ALM_DAYS2
#define IRTC_ALM_DAYS_ALM_DAYS3         _IRTC_ALM_DAYS.Bits.ALM_DAYS3
#define IRTC_ALM_DAYS_ALM_DAYS4         _IRTC_ALM_DAYS.Bits.ALM_DAYS4
#define IRTC_ALM_DAYS_ALM_DAYS          _IRTC_ALM_DAYS.MergedBits.grpALM_DAYS

#define IRTC_ALM_DAYS_ALM_DAYS0_MASK    1
#define IRTC_ALM_DAYS_ALM_DAYS1_MASK    2
#define IRTC_ALM_DAYS_ALM_DAYS2_MASK    4
#define IRTC_ALM_DAYS_ALM_DAYS3_MASK    8
#define IRTC_ALM_DAYS_ALM_DAYS4_MASK    16
#define IRTC_ALM_DAYS_ALM_DAYS_MASK     31
#define IRTC_ALM_DAYS_ALM_DAYS_BITNUM   0


/*** IRTC_ALM_HM - RTC Hours and Minutes Alarm Register (binary format); 0x0000188C ***/
typedef union {
  word Word;
  struct {
    word ALM_MINUTES0 :1;                                      /* Minutes setting of the alarm. It can be set to any value between 0 and 59 (0x3B), bit 0 */
    word ALM_MINUTES1 :1;                                      /* Minutes setting of the alarm. It can be set to any value between 0 and 59 (0x3B), bit 1 */
    word ALM_MINUTES2 :1;                                      /* Minutes setting of the alarm. It can be set to any value between 0 and 59 (0x3B), bit 2 */
    word ALM_MINUTES3 :1;                                      /* Minutes setting of the alarm. It can be set to any value between 0 and 59 (0x3B), bit 3 */
    word ALM_MINUTES4 :1;                                      /* Minutes setting of the alarm. It can be set to any value between 0 and 59 (0x3B), bit 4 */
    word ALM_MINUTES5 :1;                                      /* Minutes setting of the alarm. It can be set to any value between 0 and 59 (0x3B), bit 5 */
    word             :1; 
    word             :1; 
    word ALM_HOURS0  :1;                                       /* Hours setting of the alarm. It can be set to any value between 0 and 23 (0x17), bit 0 */
    word ALM_HOURS1  :1;                                       /* Hours setting of the alarm. It can be set to any value between 0 and 23 (0x17), bit 1 */
    word ALM_HOURS2  :1;                                       /* Hours setting of the alarm. It can be set to any value between 0 and 23 (0x17), bit 2 */
    word ALM_HOURS3  :1;                                       /* Hours setting of the alarm. It can be set to any value between 0 and 23 (0x17), bit 3 */
    word ALM_HOURS4  :1;                                       /* Hours setting of the alarm. It can be set to any value between 0 and 23 (0x17), bit 4 */
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpALM_MINUTES :6;
    word         :1;
    word         :1;
    word grpALM_HOURS :5;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} IRTC_ALM_HMSTR;
extern volatile IRTC_ALM_HMSTR _IRTC_ALM_HM @0x0000188C;
#define IRTC_ALM_HM                     _IRTC_ALM_HM.Word
#define IRTC_ALM_HM_ALM_MINUTES0        _IRTC_ALM_HM.Bits.ALM_MINUTES0
#define IRTC_ALM_HM_ALM_MINUTES1        _IRTC_ALM_HM.Bits.ALM_MINUTES1
#define IRTC_ALM_HM_ALM_MINUTES2        _IRTC_ALM_HM.Bits.ALM_MINUTES2
#define IRTC_ALM_HM_ALM_MINUTES3        _IRTC_ALM_HM.Bits.ALM_MINUTES3
#define IRTC_ALM_HM_ALM_MINUTES4        _IRTC_ALM_HM.Bits.ALM_MINUTES4
#define IRTC_ALM_HM_ALM_MINUTES5        _IRTC_ALM_HM.Bits.ALM_MINUTES5
#define IRTC_ALM_HM_ALM_HOURS0          _IRTC_ALM_HM.Bits.ALM_HOURS0
#define IRTC_ALM_HM_ALM_HOURS1          _IRTC_ALM_HM.Bits.ALM_HOURS1
#define IRTC_ALM_HM_ALM_HOURS2          _IRTC_ALM_HM.Bits.ALM_HOURS2
#define IRTC_ALM_HM_ALM_HOURS3          _IRTC_ALM_HM.Bits.ALM_HOURS3
#define IRTC_ALM_HM_ALM_HOURS4          _IRTC_ALM_HM.Bits.ALM_HOURS4
#define IRTC_ALM_HM_ALM_MINUTES         _IRTC_ALM_HM.MergedBits.grpALM_MINUTES
#define IRTC_ALM_HM_ALM_HOURS           _IRTC_ALM_HM.MergedBits.grpALM_HOURS

#define IRTC_ALM_HM_ALM_MINUTES0_MASK   1
#define IRTC_ALM_HM_ALM_MINUTES1_MASK   2
#define IRTC_ALM_HM_ALM_MINUTES2_MASK   4
#define IRTC_ALM_HM_ALM_MINUTES3_MASK   8
#define IRTC_ALM_HM_ALM_MINUTES4_MASK   16
#define IRTC_ALM_HM_ALM_MINUTES5_MASK   32
#define IRTC_ALM_HM_ALM_HOURS0_MASK     256
#define IRTC_ALM_HM_ALM_HOURS1_MASK     512
#define IRTC_ALM_HM_ALM_HOURS2_MASK     1024
#define IRTC_ALM_HM_ALM_HOURS3_MASK     2048
#define IRTC_ALM_HM_ALM_HOURS4_MASK     4096
#define IRTC_ALM_HM_ALM_MINUTES_MASK    63
#define IRTC_ALM_HM_ALM_MINUTES_BITNUM  0
#define IRTC_ALM_HM_ALM_HOURS_MASK      7936
#define IRTC_ALM_HM_ALM_HOURS_BITNUM    8


/*** IRTC_ALM_SEC - RTC Seconds Alarm Register (binary format); 0x0000188E ***/
typedef union {
  word Word;
  struct {
    word ALM_SECONDS0 :1;                                      /* Seconds setting of the alarm. It can be set to any value between 0 and 59 (0x3B), bit 0 */
    word ALM_SECONDS1 :1;                                      /* Seconds setting of the alarm. It can be set to any value between 0 and 59 (0x3B), bit 1 */
    word ALM_SECONDS2 :1;                                      /* Seconds setting of the alarm. It can be set to any value between 0 and 59 (0x3B), bit 2 */
    word ALM_SECONDS3 :1;                                      /* Seconds setting of the alarm. It can be set to any value between 0 and 59 (0x3B), bit 3 */
    word ALM_SECONDS4 :1;                                      /* Seconds setting of the alarm. It can be set to any value between 0 and 59 (0x3B), bit 4 */
    word ALM_SECONDS5 :1;                                      /* Seconds setting of the alarm. It can be set to any value between 0 and 59 (0x3B), bit 5 */
    word             :1; 
    word             :1; 
    word DEC_S       :1;                                       /* Controls the decrement of seconds counter */
    word INC_S       :1;                                       /* Controls the increment of seconds counter */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpALM_SECONDS :6;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} IRTC_ALM_SECSTR;
extern volatile IRTC_ALM_SECSTR _IRTC_ALM_SEC @0x0000188E;
#define IRTC_ALM_SEC                    _IRTC_ALM_SEC.Word
#define IRTC_ALM_SEC_ALM_SECONDS0       _IRTC_ALM_SEC.Bits.ALM_SECONDS0
#define IRTC_ALM_SEC_ALM_SECONDS1       _IRTC_ALM_SEC.Bits.ALM_SECONDS1
#define IRTC_ALM_SEC_ALM_SECONDS2       _IRTC_ALM_SEC.Bits.ALM_SECONDS2
#define IRTC_ALM_SEC_ALM_SECONDS3       _IRTC_ALM_SEC.Bits.ALM_SECONDS3
#define IRTC_ALM_SEC_ALM_SECONDS4       _IRTC_ALM_SEC.Bits.ALM_SECONDS4
#define IRTC_ALM_SEC_ALM_SECONDS5       _IRTC_ALM_SEC.Bits.ALM_SECONDS5
#define IRTC_ALM_SEC_DEC_S              _IRTC_ALM_SEC.Bits.DEC_S
#define IRTC_ALM_SEC_INC_S              _IRTC_ALM_SEC.Bits.INC_S
#define IRTC_ALM_SEC_ALM_SECONDS        _IRTC_ALM_SEC.MergedBits.grpALM_SECONDS

#define IRTC_ALM_SEC_ALM_SECONDS0_MASK  1
#define IRTC_ALM_SEC_ALM_SECONDS1_MASK  2
#define IRTC_ALM_SEC_ALM_SECONDS2_MASK  4
#define IRTC_ALM_SEC_ALM_SECONDS3_MASK  8
#define IRTC_ALM_SEC_ALM_SECONDS4_MASK  16
#define IRTC_ALM_SEC_ALM_SECONDS5_MASK  32
#define IRTC_ALM_SEC_DEC_S_MASK         256
#define IRTC_ALM_SEC_INC_S_MASK         512
#define IRTC_ALM_SEC_ALM_SECONDS_MASK   63
#define IRTC_ALM_SEC_ALM_SECONDS_BITNUM 0


/*** IRTC_CTRL - RTC Control Register; 0x00001890 ***/
typedef union {
  word Word;
  struct {
    word WE0         :1;                                       /* Write enable bits, bit 0 */
    word WE1         :1;                                       /* Write enable bits, bit 1 */
    word ALARM_MATCH0 :1;                                      /* Alarm match bits, bit 0 */
    word ALARM_MATCH1 :1;                                      /* Alarm match bits, bit 1 */
    word             :1; 
    word             :1; 
    word DSTEN       :1;                                       /* Daylight saving enable */
    word             :1; 
    word SWR         :1;                                       /* Software reset */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word RTC_CLKOUT0 :1;                                       /* Off-chip clock output enable bits, bit 0 */
    word RTC_CLKOUT1 :1;                                       /* Off-chip clock output enable bits, bit 1 */
    word             :1; 
  } Bits;
  struct {
    word grpWE   :2;
    word grpALARM_MATCH :2;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpRTC_CLKOUT :2;
    word         :1;
  } MergedBits;
} IRTC_CTRLSTR;
extern volatile IRTC_CTRLSTR _IRTC_CTRL @0x00001890;
#define IRTC_CTRL                       _IRTC_CTRL.Word
#define IRTC_CTRL_WE0                   _IRTC_CTRL.Bits.WE0
#define IRTC_CTRL_WE1                   _IRTC_CTRL.Bits.WE1
#define IRTC_CTRL_ALARM_MATCH0          _IRTC_CTRL.Bits.ALARM_MATCH0
#define IRTC_CTRL_ALARM_MATCH1          _IRTC_CTRL.Bits.ALARM_MATCH1
#define IRTC_CTRL_DSTEN                 _IRTC_CTRL.Bits.DSTEN
#define IRTC_CTRL_SWR                   _IRTC_CTRL.Bits.SWR
#define IRTC_CTRL_RTC_CLKOUT0           _IRTC_CTRL.Bits.RTC_CLKOUT0
#define IRTC_CTRL_RTC_CLKOUT1           _IRTC_CTRL.Bits.RTC_CLKOUT1
#define IRTC_CTRL_WE                    _IRTC_CTRL.MergedBits.grpWE
#define IRTC_CTRL_ALARM_MATCH           _IRTC_CTRL.MergedBits.grpALARM_MATCH
#define IRTC_CTRL_RTC_CLKOUT            _IRTC_CTRL.MergedBits.grpRTC_CLKOUT

#define IRTC_CTRL_WE0_MASK              1
#define IRTC_CTRL_WE1_MASK              2
#define IRTC_CTRL_ALARM_MATCH0_MASK     4
#define IRTC_CTRL_ALARM_MATCH1_MASK     8
#define IRTC_CTRL_DSTEN_MASK            64
#define IRTC_CTRL_SWR_MASK              256
#define IRTC_CTRL_RTC_CLKOUT0_MASK      8192
#define IRTC_CTRL_RTC_CLKOUT1_MASK      16384
#define IRTC_CTRL_WE_MASK               3
#define IRTC_CTRL_WE_BITNUM             0
#define IRTC_CTRL_ALARM_MATCH_MASK      12
#define IRTC_CTRL_ALARM_MATCH_BITNUM    2
#define IRTC_CTRL_RTC_CLKOUT_MASK       24576
#define IRTC_CTRL_RTC_CLKOUT_BITNUM     13


/*** IRTC_STATUS - RTC Status Register; 0x00001892 ***/
typedef union {
  word Word;
  struct {
    word INVAL       :1;                                       /* Invalid time bit */
    word C_DON       :1;                                       /* Compensation one bit */
    word BERR        :1;                                       /* Bus error bit */
    word OCAL        :1;                                       /* Calibration output bit or compensation interval bit */
    word WPE         :1;                                       /* Write protect enable */
    word CLV         :1;                                       /* CPU low voltage */
    word PORB        :1;                                       /* Boot Source after POR */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} IRTC_STATUSSTR;
extern volatile IRTC_STATUSSTR _IRTC_STATUS @0x00001892;
#define IRTC_STATUS                     _IRTC_STATUS.Word
#define IRTC_STATUS_INVAL               _IRTC_STATUS.Bits.INVAL
#define IRTC_STATUS_C_DON               _IRTC_STATUS.Bits.C_DON
#define IRTC_STATUS_BERR                _IRTC_STATUS.Bits.BERR
#define IRTC_STATUS_OCAL                _IRTC_STATUS.Bits.OCAL
#define IRTC_STATUS_WPE                 _IRTC_STATUS.Bits.WPE
#define IRTC_STATUS_CLV                 _IRTC_STATUS.Bits.CLV
#define IRTC_STATUS_PORB                _IRTC_STATUS.Bits.PORB

#define IRTC_STATUS_INVAL_MASK          1
#define IRTC_STATUS_C_DON_MASK          2
#define IRTC_STATUS_BERR_MASK           4
#define IRTC_STATUS_OCAL_MASK           8
#define IRTC_STATUS_WPE_MASK            16
#define IRTC_STATUS_CLV_MASK            32
#define IRTC_STATUS_PORB_MASK           64


/*** IRTC_ISR - RTC Interrupt Status Register; 0x00001894 ***/
typedef union {
  word Word;
  struct {
    word TMPR        :1;                                       /* Tamper detect interrupt */
    word CDT         :1;                                       /* Countdown timer expiry flag */
    word ALM         :1;                                       /* Alarm flag */
    word DAY         :1;                                       /* Day flag */
    word HR          :1;                                       /* Hour flag */
    word MIN         :1;                                       /* Minutes flag */
    word _1HZ        :1;                                       /* Interrupt flag 1 Hz. Indicates an interrupt has occurred. If enabled, this bit is set every half a second */
    word _2HZ        :1;                                       /* Interrupt flag 2 Hz. Indicates an interrupt has occurred. If enabled, this bit is set every half a second */
    word SAM0        :1;                                       /* Sampling timer 0 interrupt flag. Indicates than an interrupt has occurred at the corresponding sampling rate */
    word SAM1        :1;                                       /* Sampling timer 1 interrupt flag. Indicates than an interrupt has occurred at the corresponding sampling rate */
    word SAM2        :1;                                       /* Sampling timer 2 interrupt flag. Indicates than an interrupt has occurred at the corresponding sampling rate */
    word SAM3        :1;                                       /* Sampling timer 3 interrupt flag. Indicates than an interrupt has occurred at the corresponding sampling rate */
    word SAM4        :1;                                       /* Sampling timer 4 interrupt flag. Indicates than an interrupt has occurred at the corresponding sampling rate */
    word SAM5        :1;                                       /* Sampling timer 5 interrupt flag. Indicates than an interrupt has occurred at the corresponding sampling rate */
    word SAM6        :1;                                       /* Sampling timer 6 interrupt flag. Indicates than an interrupt has occurred at the corresponding sampling rate */
    word SAM7        :1;                                       /* Sampling timer 7 interrupt flag. Indicates than an interrupt has occurred at the corresponding sampling rate */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpSAM  :8;
  } MergedBits;
} IRTC_ISRSTR;
extern volatile IRTC_ISRSTR _IRTC_ISR @0x00001894;
#define IRTC_ISR                        _IRTC_ISR.Word
#define IRTC_ISR_TMPR                   _IRTC_ISR.Bits.TMPR
#define IRTC_ISR_CDT                    _IRTC_ISR.Bits.CDT
#define IRTC_ISR_ALM                    _IRTC_ISR.Bits.ALM
#define IRTC_ISR_DAY                    _IRTC_ISR.Bits.DAY
#define IRTC_ISR_HR                     _IRTC_ISR.Bits.HR
#define IRTC_ISR_MIN                    _IRTC_ISR.Bits.MIN
#define IRTC_ISR_1HZ                    _IRTC_ISR.Bits._1HZ
#define IRTC_ISR_2HZ                    _IRTC_ISR.Bits._2HZ
#define IRTC_ISR_SAM0                   _IRTC_ISR.Bits.SAM0
#define IRTC_ISR_SAM1                   _IRTC_ISR.Bits.SAM1
#define IRTC_ISR_SAM2                   _IRTC_ISR.Bits.SAM2
#define IRTC_ISR_SAM3                   _IRTC_ISR.Bits.SAM3
#define IRTC_ISR_SAM4                   _IRTC_ISR.Bits.SAM4
#define IRTC_ISR_SAM5                   _IRTC_ISR.Bits.SAM5
#define IRTC_ISR_SAM6                   _IRTC_ISR.Bits.SAM6
#define IRTC_ISR_SAM7                   _IRTC_ISR.Bits.SAM7
#define IRTC_ISR_SAM                    _IRTC_ISR.MergedBits.grpSAM

#define IRTC_ISR_TMPR_MASK              1
#define IRTC_ISR_CDT_MASK               2
#define IRTC_ISR_ALM_MASK               4
#define IRTC_ISR_DAY_MASK               8
#define IRTC_ISR_HR_MASK                16
#define IRTC_ISR_MIN_MASK               32
#define IRTC_ISR_1HZ_MASK               64
#define IRTC_ISR_2HZ_MASK               128
#define IRTC_ISR_SAM0_MASK              256
#define IRTC_ISR_SAM1_MASK              512
#define IRTC_ISR_SAM2_MASK              1024
#define IRTC_ISR_SAM3_MASK              2048
#define IRTC_ISR_SAM4_MASK              4096
#define IRTC_ISR_SAM5_MASK              8192
#define IRTC_ISR_SAM6_MASK              16384
#define IRTC_ISR_SAM7_MASK              32768
#define IRTC_ISR_SAM_MASK               65280
#define IRTC_ISR_SAM_BITNUM             8


/*** IRTC_IER - RTC Interrupt Enable Register; 0x00001896 ***/
typedef union {
  word Word;
  struct {
    word TMPR        :1;                                       /* Tamper detect interrupt */
    word CDT         :1;                                       /* Countdown timer expiry flag */
    word ALM         :1;                                       /* Alarm flag */
    word DAY         :1;                                       /* Day flag */
    word HR          :1;                                       /* Hour flag */
    word MIN         :1;                                       /* Minutes flag */
    word _1HZ        :1;                                       /* Sampling timer interrupt at 1 Hz frequency */
    word _2HZ        :1;                                       /* Sampling timer interrupt at 2 Hz frequency */
    word SAM0        :1;                                       /* Sampling timer 0 interrupt enable */
    word SAM1        :1;                                       /* Sampling timer 1 interrupt enable */
    word SAM2        :1;                                       /* Sampling timer 2 interrupt enable */
    word SAM3        :1;                                       /* Sampling timer 3 interrupt enable */
    word SAM4        :1;                                       /* Sampling timer 4 interrupt enable */
    word SAM5        :1;                                       /* Sampling timer 5 interrupt enable */
    word SAM6        :1;                                       /* Sampling timer 6 interrupt enable */
    word SAM7        :1;                                       /* Sampling timer 7 interrupt enable */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpSAM  :8;
  } MergedBits;
} IRTC_IERSTR;
extern volatile IRTC_IERSTR _IRTC_IER @0x00001896;
#define IRTC_IER                        _IRTC_IER.Word
#define IRTC_IER_TMPR                   _IRTC_IER.Bits.TMPR
#define IRTC_IER_CDT                    _IRTC_IER.Bits.CDT
#define IRTC_IER_ALM                    _IRTC_IER.Bits.ALM
#define IRTC_IER_DAY                    _IRTC_IER.Bits.DAY
#define IRTC_IER_HR                     _IRTC_IER.Bits.HR
#define IRTC_IER_MIN                    _IRTC_IER.Bits.MIN
#define IRTC_IER_1HZ                    _IRTC_IER.Bits._1HZ
#define IRTC_IER_2HZ                    _IRTC_IER.Bits._2HZ
#define IRTC_IER_SAM0                   _IRTC_IER.Bits.SAM0
#define IRTC_IER_SAM1                   _IRTC_IER.Bits.SAM1
#define IRTC_IER_SAM2                   _IRTC_IER.Bits.SAM2
#define IRTC_IER_SAM3                   _IRTC_IER.Bits.SAM3
#define IRTC_IER_SAM4                   _IRTC_IER.Bits.SAM4
#define IRTC_IER_SAM5                   _IRTC_IER.Bits.SAM5
#define IRTC_IER_SAM6                   _IRTC_IER.Bits.SAM6
#define IRTC_IER_SAM7                   _IRTC_IER.Bits.SAM7
#define IRTC_IER_SAM                    _IRTC_IER.MergedBits.grpSAM

#define IRTC_IER_TMPR_MASK              1
#define IRTC_IER_CDT_MASK               2
#define IRTC_IER_ALM_MASK               4
#define IRTC_IER_DAY_MASK               8
#define IRTC_IER_HR_MASK                16
#define IRTC_IER_MIN_MASK               32
#define IRTC_IER_1HZ_MASK               64
#define IRTC_IER_2HZ_MASK               128
#define IRTC_IER_SAM0_MASK              256
#define IRTC_IER_SAM1_MASK              512
#define IRTC_IER_SAM2_MASK              1024
#define IRTC_IER_SAM3_MASK              2048
#define IRTC_IER_SAM4_MASK              4096
#define IRTC_IER_SAM5_MASK              8192
#define IRTC_IER_SAM6_MASK              16384
#define IRTC_IER_SAM7_MASK              32768
#define IRTC_IER_SAM_MASK               65280
#define IRTC_IER_SAM_BITNUM             8


/*** IRTC_COUNT_DN - RTC Countdown (Minutes) Timer Register (binary format); 0x00001898 ***/
typedef union {
  word Word;
  struct {
    word COUNTDOWN_COUNT0 :1;                                  /* Countdown counter value bits, bit 0 */
    word COUNTDOWN_COUNT1 :1;                                  /* Countdown counter value bits, bit 1 */
    word COUNTDOWN_COUNT2 :1;                                  /* Countdown counter value bits, bit 2 */
    word COUNTDOWN_COUNT3 :1;                                  /* Countdown counter value bits, bit 3 */
    word COUNTDOWN_COUNT4 :1;                                  /* Countdown counter value bits, bit 4 */
    word COUNTDOWN_COUNT5 :1;                                  /* Countdown counter value bits, bit 5 */
    word COUNTDOWN_COUNT6 :1;                                  /* Countdown counter value bits, bit 6 */
    word COUNTDOWN_COUNT7 :1;                                  /* Countdown counter value bits, bit 7 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpCOUNTDOWN_COUNT :8;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} IRTC_COUNT_DNSTR;
extern volatile IRTC_COUNT_DNSTR _IRTC_COUNT_DN @0x00001898;
#define IRTC_COUNT_DN                   _IRTC_COUNT_DN.Word
#define IRTC_COUNT_DN_COUNTDOWN_COUNT0  _IRTC_COUNT_DN.Bits.COUNTDOWN_COUNT0
#define IRTC_COUNT_DN_COUNTDOWN_COUNT1  _IRTC_COUNT_DN.Bits.COUNTDOWN_COUNT1
#define IRTC_COUNT_DN_COUNTDOWN_COUNT2  _IRTC_COUNT_DN.Bits.COUNTDOWN_COUNT2
#define IRTC_COUNT_DN_COUNTDOWN_COUNT3  _IRTC_COUNT_DN.Bits.COUNTDOWN_COUNT3
#define IRTC_COUNT_DN_COUNTDOWN_COUNT4  _IRTC_COUNT_DN.Bits.COUNTDOWN_COUNT4
#define IRTC_COUNT_DN_COUNTDOWN_COUNT5  _IRTC_COUNT_DN.Bits.COUNTDOWN_COUNT5
#define IRTC_COUNT_DN_COUNTDOWN_COUNT6  _IRTC_COUNT_DN.Bits.COUNTDOWN_COUNT6
#define IRTC_COUNT_DN_COUNTDOWN_COUNT7  _IRTC_COUNT_DN.Bits.COUNTDOWN_COUNT7
#define IRTC_COUNT_DN_COUNTDOWN_COUNT   _IRTC_COUNT_DN.MergedBits.grpCOUNTDOWN_COUNT

#define IRTC_COUNT_DN_COUNTDOWN_COUNT0_MASK 1
#define IRTC_COUNT_DN_COUNTDOWN_COUNT1_MASK 2
#define IRTC_COUNT_DN_COUNTDOWN_COUNT2_MASK 4
#define IRTC_COUNT_DN_COUNTDOWN_COUNT3_MASK 8
#define IRTC_COUNT_DN_COUNTDOWN_COUNT4_MASK 16
#define IRTC_COUNT_DN_COUNTDOWN_COUNT5_MASK 32
#define IRTC_COUNT_DN_COUNTDOWN_COUNT6_MASK 64
#define IRTC_COUNT_DN_COUNTDOWN_COUNT7_MASK 128
#define IRTC_COUNT_DN_COUNTDOWN_COUNT_MASK 255
#define IRTC_COUNT_DN_COUNTDOWN_COUNT_BITNUM 0


/*** IRTC_DST_HOUR - RTC Daylight Saving Hour Register; 0x000018A2 ***/
typedef union {
  word Word;
  struct {
    word DST_END_HOUR0 :1;                                     /* Hour value when daylight saving has to end bits, bit 0 */
    word DST_END_HOUR1 :1;                                     /* Hour value when daylight saving has to end bits, bit 1 */
    word DST_END_HOUR2 :1;                                     /* Hour value when daylight saving has to end bits, bit 2 */
    word DST_END_HOUR3 :1;                                     /* Hour value when daylight saving has to end bits, bit 3 */
    word DST_END_HOUR4 :1;                                     /* Hour value when daylight saving has to end bits, bit 4 */
    word             :1; 
    word             :1; 
    word             :1; 
    word DST_START_HOUR0 :1;                                   /* Hour value when daylight saving has to start bits, bit 0 */
    word DST_START_HOUR1 :1;                                   /* Hour value when daylight saving has to start bits, bit 1 */
    word DST_START_HOUR2 :1;                                   /* Hour value when daylight saving has to start bits, bit 2 */
    word DST_START_HOUR3 :1;                                   /* Hour value when daylight saving has to start bits, bit 3 */
    word DST_START_HOUR4 :1;                                   /* Hour value when daylight saving has to start bits, bit 4 */
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpDST_END_HOUR :5;
    word         :1;
    word         :1;
    word         :1;
    word grpDST_START_HOUR :5;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} IRTC_DST_HOURSTR;
extern volatile IRTC_DST_HOURSTR _IRTC_DST_HOUR @0x000018A2;
#define IRTC_DST_HOUR                   _IRTC_DST_HOUR.Word
#define IRTC_DST_HOUR_DST_END_HOUR0     _IRTC_DST_HOUR.Bits.DST_END_HOUR0
#define IRTC_DST_HOUR_DST_END_HOUR1     _IRTC_DST_HOUR.Bits.DST_END_HOUR1
#define IRTC_DST_HOUR_DST_END_HOUR2     _IRTC_DST_HOUR.Bits.DST_END_HOUR2
#define IRTC_DST_HOUR_DST_END_HOUR3     _IRTC_DST_HOUR.Bits.DST_END_HOUR3
#define IRTC_DST_HOUR_DST_END_HOUR4     _IRTC_DST_HOUR.Bits.DST_END_HOUR4
#define IRTC_DST_HOUR_DST_START_HOUR0   _IRTC_DST_HOUR.Bits.DST_START_HOUR0
#define IRTC_DST_HOUR_DST_START_HOUR1   _IRTC_DST_HOUR.Bits.DST_START_HOUR1
#define IRTC_DST_HOUR_DST_START_HOUR2   _IRTC_DST_HOUR.Bits.DST_START_HOUR2
#define IRTC_DST_HOUR_DST_START_HOUR3   _IRTC_DST_HOUR.Bits.DST_START_HOUR3
#define IRTC_DST_HOUR_DST_START_HOUR4   _IRTC_DST_HOUR.Bits.DST_START_HOUR4
#define IRTC_DST_HOUR_DST_END_HOUR      _IRTC_DST_HOUR.MergedBits.grpDST_END_HOUR
#define IRTC_DST_HOUR_DST_START_HOUR    _IRTC_DST_HOUR.MergedBits.grpDST_START_HOUR

#define IRTC_DST_HOUR_DST_END_HOUR0_MASK 1
#define IRTC_DST_HOUR_DST_END_HOUR1_MASK 2
#define IRTC_DST_HOUR_DST_END_HOUR2_MASK 4
#define IRTC_DST_HOUR_DST_END_HOUR3_MASK 8
#define IRTC_DST_HOUR_DST_END_HOUR4_MASK 16
#define IRTC_DST_HOUR_DST_START_HOUR0_MASK 256
#define IRTC_DST_HOUR_DST_START_HOUR1_MASK 512
#define IRTC_DST_HOUR_DST_START_HOUR2_MASK 1024
#define IRTC_DST_HOUR_DST_START_HOUR3_MASK 2048
#define IRTC_DST_HOUR_DST_START_HOUR4_MASK 4096
#define IRTC_DST_HOUR_DST_END_HOUR_MASK 31
#define IRTC_DST_HOUR_DST_END_HOUR_BITNUM 0
#define IRTC_DST_HOUR_DST_START_HOUR_MASK 7936
#define IRTC_DST_HOUR_DST_START_HOUR_BITNUM 8


/*** IRTC_DST_MNTH - RTC Daylight Saving Month Register; 0x000018A4 ***/
typedef union {
  word Word;
  struct {
    word DST_END_MONTH0 :1;                                    /* Month value when daylight saving has to end bits, bit 0 */
    word DST_END_MONTH1 :1;                                    /* Month value when daylight saving has to end bits, bit 1 */
    word DST_END_MONTH2 :1;                                    /* Month value when daylight saving has to end bits, bit 2 */
    word DST_END_MONTH3 :1;                                    /* Month value when daylight saving has to end bits, bit 3 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word DST_START_MONTH0 :1;                                  /* Month value when daylight saving has to start bits, bit 0 */
    word DST_START_MONTH1 :1;                                  /* Month value when daylight saving has to start bits, bit 1 */
    word DST_START_MONTH2 :1;                                  /* Month value when daylight saving has to start bits, bit 2 */
    word DST_START_MONTH3 :1;                                  /* Month value when daylight saving has to start bits, bit 3 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpDST_END_MONTH :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpDST_START_MONTH :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} IRTC_DST_MNTHSTR;
extern volatile IRTC_DST_MNTHSTR _IRTC_DST_MNTH @0x000018A4;
#define IRTC_DST_MNTH                   _IRTC_DST_MNTH.Word
#define IRTC_DST_MNTH_DST_END_MONTH0    _IRTC_DST_MNTH.Bits.DST_END_MONTH0
#define IRTC_DST_MNTH_DST_END_MONTH1    _IRTC_DST_MNTH.Bits.DST_END_MONTH1
#define IRTC_DST_MNTH_DST_END_MONTH2    _IRTC_DST_MNTH.Bits.DST_END_MONTH2
#define IRTC_DST_MNTH_DST_END_MONTH3    _IRTC_DST_MNTH.Bits.DST_END_MONTH3
#define IRTC_DST_MNTH_DST_START_MONTH0  _IRTC_DST_MNTH.Bits.DST_START_MONTH0
#define IRTC_DST_MNTH_DST_START_MONTH1  _IRTC_DST_MNTH.Bits.DST_START_MONTH1
#define IRTC_DST_MNTH_DST_START_MONTH2  _IRTC_DST_MNTH.Bits.DST_START_MONTH2
#define IRTC_DST_MNTH_DST_START_MONTH3  _IRTC_DST_MNTH.Bits.DST_START_MONTH3
#define IRTC_DST_MNTH_DST_END_MONTH     _IRTC_DST_MNTH.MergedBits.grpDST_END_MONTH
#define IRTC_DST_MNTH_DST_START_MONTH   _IRTC_DST_MNTH.MergedBits.grpDST_START_MONTH

#define IRTC_DST_MNTH_DST_END_MONTH0_MASK 1
#define IRTC_DST_MNTH_DST_END_MONTH1_MASK 2
#define IRTC_DST_MNTH_DST_END_MONTH2_MASK 4
#define IRTC_DST_MNTH_DST_END_MONTH3_MASK 8
#define IRTC_DST_MNTH_DST_START_MONTH0_MASK 256
#define IRTC_DST_MNTH_DST_START_MONTH1_MASK 512
#define IRTC_DST_MNTH_DST_START_MONTH2_MASK 1024
#define IRTC_DST_MNTH_DST_START_MONTH3_MASK 2048
#define IRTC_DST_MNTH_DST_END_MONTH_MASK 15
#define IRTC_DST_MNTH_DST_END_MONTH_BITNUM 0
#define IRTC_DST_MNTH_DST_START_MONTH_MASK 3840
#define IRTC_DST_MNTH_DST_START_MONTH_BITNUM 8


/*** IRTC_DST_DAY - RTC Daylight Saving Day Register; 0x000018A6 ***/
typedef union {
  word Word;
  struct {
    word DST_END_DAY0 :1;                                      /* Day value when daylight saving has to end bits, bit 0 */
    word DST_END_DAY1 :1;                                      /* Day value when daylight saving has to end bits, bit 1 */
    word DST_END_DAY2 :1;                                      /* Day value when daylight saving has to end bits, bit 2 */
    word DST_END_DAY3 :1;                                      /* Day value when daylight saving has to end bits, bit 3 */
    word DST_END_DAY4 :1;                                      /* Day value when daylight saving has to end bits, bit 4 */
    word             :1; 
    word             :1; 
    word             :1; 
    word DST_START_DAY0 :1;                                    /* Day value when daylight saving has to start bits, bit 0 */
    word DST_START_DAY1 :1;                                    /* Day value when daylight saving has to start bits, bit 1 */
    word DST_START_DAY2 :1;                                    /* Day value when daylight saving has to start bits, bit 2 */
    word DST_START_DAY3 :1;                                    /* Day value when daylight saving has to start bits, bit 3 */
    word DST_START_DAY4 :1;                                    /* Day value when daylight saving has to start bits, bit 4 */
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpDST_END_DAY :5;
    word         :1;
    word         :1;
    word         :1;
    word grpDST_START_DAY :5;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} IRTC_DST_DAYSTR;
extern volatile IRTC_DST_DAYSTR _IRTC_DST_DAY @0x000018A6;
#define IRTC_DST_DAY                    _IRTC_DST_DAY.Word
#define IRTC_DST_DAY_DST_END_DAY0       _IRTC_DST_DAY.Bits.DST_END_DAY0
#define IRTC_DST_DAY_DST_END_DAY1       _IRTC_DST_DAY.Bits.DST_END_DAY1
#define IRTC_DST_DAY_DST_END_DAY2       _IRTC_DST_DAY.Bits.DST_END_DAY2
#define IRTC_DST_DAY_DST_END_DAY3       _IRTC_DST_DAY.Bits.DST_END_DAY3
#define IRTC_DST_DAY_DST_END_DAY4       _IRTC_DST_DAY.Bits.DST_END_DAY4
#define IRTC_DST_DAY_DST_START_DAY0     _IRTC_DST_DAY.Bits.DST_START_DAY0
#define IRTC_DST_DAY_DST_START_DAY1     _IRTC_DST_DAY.Bits.DST_START_DAY1
#define IRTC_DST_DAY_DST_START_DAY2     _IRTC_DST_DAY.Bits.DST_START_DAY2
#define IRTC_DST_DAY_DST_START_DAY3     _IRTC_DST_DAY.Bits.DST_START_DAY3
#define IRTC_DST_DAY_DST_START_DAY4     _IRTC_DST_DAY.Bits.DST_START_DAY4
#define IRTC_DST_DAY_DST_END_DAY        _IRTC_DST_DAY.MergedBits.grpDST_END_DAY
#define IRTC_DST_DAY_DST_START_DAY      _IRTC_DST_DAY.MergedBits.grpDST_START_DAY

#define IRTC_DST_DAY_DST_END_DAY0_MASK  1
#define IRTC_DST_DAY_DST_END_DAY1_MASK  2
#define IRTC_DST_DAY_DST_END_DAY2_MASK  4
#define IRTC_DST_DAY_DST_END_DAY3_MASK  8
#define IRTC_DST_DAY_DST_END_DAY4_MASK  16
#define IRTC_DST_DAY_DST_START_DAY0_MASK 256
#define IRTC_DST_DAY_DST_START_DAY1_MASK 512
#define IRTC_DST_DAY_DST_START_DAY2_MASK 1024
#define IRTC_DST_DAY_DST_START_DAY3_MASK 2048
#define IRTC_DST_DAY_DST_START_DAY4_MASK 4096
#define IRTC_DST_DAY_DST_END_DAY_MASK   31
#define IRTC_DST_DAY_DST_END_DAY_BITNUM 0
#define IRTC_DST_DAY_DST_START_DAY_MASK 7936
#define IRTC_DST_DAY_DST_START_DAY_BITNUM 8


/*** IRTC_COMPEN - RTC Compensation Register; 0x000018A8 ***/
typedef union {
  word Word;
  struct {
    word COMPENSATION_VALUE0 :1;                               /* Compensation value bits, bit 0 */
    word COMPENSATION_VALUE1 :1;                               /* Compensation value bits, bit 1 */
    word COMPENSATION_VALUE2 :1;                               /* Compensation value bits, bit 2 */
    word COMPENSATION_VALUE3 :1;                               /* Compensation value bits, bit 3 */
    word COMPENSATION_VALUE4 :1;                               /* Compensation value bits, bit 4 */
    word COMPENSATION_VALUE5 :1;                               /* Compensation value bits, bit 5 */
    word COMPENSATION_VALUE6 :1;                               /* Compensation value bits, bit 6 */
    word COMPENSATION_VALUE7 :1;                               /* Compensation value bits, bit 7 */
    word COMPENSTAION_INTERVAL0 :1;                            /* Compensation interval value bits, bit 0 */
    word COMPENSTAION_INTERVAL1 :1;                            /* Compensation interval value bits, bit 1 */
    word COMPENSTAION_INTERVAL2 :1;                            /* Compensation interval value bits, bit 2 */
    word COMPENSTAION_INTERVAL3 :1;                            /* Compensation interval value bits, bit 3 */
    word COMPENSTAION_INTERVAL4 :1;                            /* Compensation interval value bits, bit 4 */
    word COMPENSTAION_INTERVAL5 :1;                            /* Compensation interval value bits, bit 5 */
    word COMPENSTAION_INTERVAL6 :1;                            /* Compensation interval value bits, bit 6 */
    word COMPENSTAION_INTERVAL7 :1;                            /* Compensation interval value bits, bit 7 */
  } Bits;
  struct {
    word grpCOMPENSATION_VALUE :8;
    word grpCOMPENSTAION_INTERVAL :8;
  } MergedBits;
} IRTC_COMPENSTR;
extern volatile IRTC_COMPENSTR _IRTC_COMPEN @0x000018A8;
#define IRTC_COMPEN                     _IRTC_COMPEN.Word
#define IRTC_COMPEN_COMPENSATION_VALUE0 _IRTC_COMPEN.Bits.COMPENSATION_VALUE0
#define IRTC_COMPEN_COMPENSATION_VALUE1 _IRTC_COMPEN.Bits.COMPENSATION_VALUE1
#define IRTC_COMPEN_COMPENSATION_VALUE2 _IRTC_COMPEN.Bits.COMPENSATION_VALUE2
#define IRTC_COMPEN_COMPENSATION_VALUE3 _IRTC_COMPEN.Bits.COMPENSATION_VALUE3
#define IRTC_COMPEN_COMPENSATION_VALUE4 _IRTC_COMPEN.Bits.COMPENSATION_VALUE4
#define IRTC_COMPEN_COMPENSATION_VALUE5 _IRTC_COMPEN.Bits.COMPENSATION_VALUE5
#define IRTC_COMPEN_COMPENSATION_VALUE6 _IRTC_COMPEN.Bits.COMPENSATION_VALUE6
#define IRTC_COMPEN_COMPENSATION_VALUE7 _IRTC_COMPEN.Bits.COMPENSATION_VALUE7
#define IRTC_COMPEN_COMPENSTAION_INTERVAL0 _IRTC_COMPEN.Bits.COMPENSTAION_INTERVAL0
#define IRTC_COMPEN_COMPENSTAION_INTERVAL1 _IRTC_COMPEN.Bits.COMPENSTAION_INTERVAL1
#define IRTC_COMPEN_COMPENSTAION_INTERVAL2 _IRTC_COMPEN.Bits.COMPENSTAION_INTERVAL2
#define IRTC_COMPEN_COMPENSTAION_INTERVAL3 _IRTC_COMPEN.Bits.COMPENSTAION_INTERVAL3
#define IRTC_COMPEN_COMPENSTAION_INTERVAL4 _IRTC_COMPEN.Bits.COMPENSTAION_INTERVAL4
#define IRTC_COMPEN_COMPENSTAION_INTERVAL5 _IRTC_COMPEN.Bits.COMPENSTAION_INTERVAL5
#define IRTC_COMPEN_COMPENSTAION_INTERVAL6 _IRTC_COMPEN.Bits.COMPENSTAION_INTERVAL6
#define IRTC_COMPEN_COMPENSTAION_INTERVAL7 _IRTC_COMPEN.Bits.COMPENSTAION_INTERVAL7
#define IRTC_COMPEN_COMPENSATION_VALUE  _IRTC_COMPEN.MergedBits.grpCOMPENSATION_VALUE
#define IRTC_COMPEN_COMPENSTAION_INTERVAL _IRTC_COMPEN.MergedBits.grpCOMPENSTAION_INTERVAL

#define IRTC_COMPEN_COMPENSATION_VALUE0_MASK 1
#define IRTC_COMPEN_COMPENSATION_VALUE1_MASK 2
#define IRTC_COMPEN_COMPENSATION_VALUE2_MASK 4
#define IRTC_COMPEN_COMPENSATION_VALUE3_MASK 8
#define IRTC_COMPEN_COMPENSATION_VALUE4_MASK 16
#define IRTC_COMPEN_COMPENSATION_VALUE5_MASK 32
#define IRTC_COMPEN_COMPENSATION_VALUE6_MASK 64
#define IRTC_COMPEN_COMPENSATION_VALUE7_MASK 128
#define IRTC_COMPEN_COMPENSTAION_INTERVAL0_MASK 256
#define IRTC_COMPEN_COMPENSTAION_INTERVAL1_MASK 512
#define IRTC_COMPEN_COMPENSTAION_INTERVAL2_MASK 1024
#define IRTC_COMPEN_COMPENSTAION_INTERVAL3_MASK 2048
#define IRTC_COMPEN_COMPENSTAION_INTERVAL4_MASK 4096
#define IRTC_COMPEN_COMPENSTAION_INTERVAL5_MASK 8192
#define IRTC_COMPEN_COMPENSTAION_INTERVAL6_MASK 16384
#define IRTC_COMPEN_COMPENSTAION_INTERVAL7_MASK 32768
#define IRTC_COMPEN_COMPENSATION_VALUE_MASK 255
#define IRTC_COMPEN_COMPENSATION_VALUE_BITNUM 0
#define IRTC_COMPEN_COMPENSTAION_INTERVAL_MASK 65280
#define IRTC_COMPEN_COMPENSTAION_INTERVAL_BITNUM 8


/*** IRTC_TTSR_YM - RTC Tamper Time Stamp Month & Year Register; 0x000018AA ***/
typedef union {
  word Word;
  struct {
    word TIME_STAMP_MONTHS0 :1;                                /* Tamper detect month value bits, bit 0 */
    word TIME_STAMP_MONTHS1 :1;                                /* Tamper detect month value bits, bit 1 */
    word TIME_STAMP_MONTHS2 :1;                                /* Tamper detect month value bits, bit 2 */
    word TIME_STAMP_MONTHS3 :1;                                /* Tamper detect month value bits, bit 3 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word TIME_STAMP_YEAR0 :1;                                  /* Tamper detect year value bits, bit 0 */
    word TIME_STAMP_YEAR1 :1;                                  /* Tamper detect year value bits, bit 1 */
    word TIME_STAMP_YEAR2 :1;                                  /* Tamper detect year value bits, bit 2 */
    word TIME_STAMP_YEAR3 :1;                                  /* Tamper detect year value bits, bit 3 */
    word TIME_STAMP_YEAR4 :1;                                  /* Tamper detect year value bits, bit 4 */
    word TIME_STAMP_YEAR5 :1;                                  /* Tamper detect year value bits, bit 5 */
    word TIME_STAMP_YEAR6 :1;                                  /* Tamper detect year value bits, bit 6 */
    word TIME_STAMP_YEAR7 :1;                                  /* Tamper detect year value bits, bit 7 */
  } Bits;
  struct {
    word grpTIME_STAMP_MONTHS :4;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpTIME_STAMP_YEAR :8;
  } MergedBits;
} IRTC_TTSR_YMSTR;
extern volatile IRTC_TTSR_YMSTR _IRTC_TTSR_YM @0x000018AA;
#define IRTC_TTSR_YM                    _IRTC_TTSR_YM.Word
#define IRTC_TTSR_YM_TIME_STAMP_MONTHS0 _IRTC_TTSR_YM.Bits.TIME_STAMP_MONTHS0
#define IRTC_TTSR_YM_TIME_STAMP_MONTHS1 _IRTC_TTSR_YM.Bits.TIME_STAMP_MONTHS1
#define IRTC_TTSR_YM_TIME_STAMP_MONTHS2 _IRTC_TTSR_YM.Bits.TIME_STAMP_MONTHS2
#define IRTC_TTSR_YM_TIME_STAMP_MONTHS3 _IRTC_TTSR_YM.Bits.TIME_STAMP_MONTHS3
#define IRTC_TTSR_YM_TIME_STAMP_YEAR0   _IRTC_TTSR_YM.Bits.TIME_STAMP_YEAR0
#define IRTC_TTSR_YM_TIME_STAMP_YEAR1   _IRTC_TTSR_YM.Bits.TIME_STAMP_YEAR1
#define IRTC_TTSR_YM_TIME_STAMP_YEAR2   _IRTC_TTSR_YM.Bits.TIME_STAMP_YEAR2
#define IRTC_TTSR_YM_TIME_STAMP_YEAR3   _IRTC_TTSR_YM.Bits.TIME_STAMP_YEAR3
#define IRTC_TTSR_YM_TIME_STAMP_YEAR4   _IRTC_TTSR_YM.Bits.TIME_STAMP_YEAR4
#define IRTC_TTSR_YM_TIME_STAMP_YEAR5   _IRTC_TTSR_YM.Bits.TIME_STAMP_YEAR5
#define IRTC_TTSR_YM_TIME_STAMP_YEAR6   _IRTC_TTSR_YM.Bits.TIME_STAMP_YEAR6
#define IRTC_TTSR_YM_TIME_STAMP_YEAR7   _IRTC_TTSR_YM.Bits.TIME_STAMP_YEAR7
#define IRTC_TTSR_YM_TIME_STAMP_MONTHS  _IRTC_TTSR_YM.MergedBits.grpTIME_STAMP_MONTHS
#define IRTC_TTSR_YM_TIME_STAMP_YEAR    _IRTC_TTSR_YM.MergedBits.grpTIME_STAMP_YEAR

#define IRTC_TTSR_YM_TIME_STAMP_MONTHS0_MASK 1
#define IRTC_TTSR_YM_TIME_STAMP_MONTHS1_MASK 2
#define IRTC_TTSR_YM_TIME_STAMP_MONTHS2_MASK 4
#define IRTC_TTSR_YM_TIME_STAMP_MONTHS3_MASK 8
#define IRTC_TTSR_YM_TIME_STAMP_YEAR0_MASK 256
#define IRTC_TTSR_YM_TIME_STAMP_YEAR1_MASK 512
#define IRTC_TTSR_YM_TIME_STAMP_YEAR2_MASK 1024
#define IRTC_TTSR_YM_TIME_STAMP_YEAR3_MASK 2048
#define IRTC_TTSR_YM_TIME_STAMP_YEAR4_MASK 4096
#define IRTC_TTSR_YM_TIME_STAMP_YEAR5_MASK 8192
#define IRTC_TTSR_YM_TIME_STAMP_YEAR6_MASK 16384
#define IRTC_TTSR_YM_TIME_STAMP_YEAR7_MASK 32768
#define IRTC_TTSR_YM_TIME_STAMP_MONTHS_MASK 15
#define IRTC_TTSR_YM_TIME_STAMP_MONTHS_BITNUM 0
#define IRTC_TTSR_YM_TIME_STAMP_YEAR_MASK 65280
#define IRTC_TTSR_YM_TIME_STAMP_YEAR_BITNUM 8


/*** IRTC_TTSR_DAY - RTC Tamper Time Stamp Day Register; 0x000018AC ***/
typedef union {
  word Word;
  struct {
    word TIME_STAMP_DAY0 :1;                                   /* Tamper detect days value bits, bit 0 */
    word TIME_STAMP_DAY1 :1;                                   /* Tamper detect days value bits, bit 1 */
    word TIME_STAMP_DAY2 :1;                                   /* Tamper detect days value bits, bit 2 */
    word TIME_STAMP_DAY3 :1;                                   /* Tamper detect days value bits, bit 3 */
    word TIME_STAMP_DAY4 :1;                                   /* Tamper detect days value bits, bit 4 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpTIME_STAMP_DAY :5;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} IRTC_TTSR_DAYSTR;
extern volatile IRTC_TTSR_DAYSTR _IRTC_TTSR_DAY @0x000018AC;
#define IRTC_TTSR_DAY                   _IRTC_TTSR_DAY.Word
#define IRTC_TTSR_DAY_TIME_STAMP_DAY0   _IRTC_TTSR_DAY.Bits.TIME_STAMP_DAY0
#define IRTC_TTSR_DAY_TIME_STAMP_DAY1   _IRTC_TTSR_DAY.Bits.TIME_STAMP_DAY1
#define IRTC_TTSR_DAY_TIME_STAMP_DAY2   _IRTC_TTSR_DAY.Bits.TIME_STAMP_DAY2
#define IRTC_TTSR_DAY_TIME_STAMP_DAY3   _IRTC_TTSR_DAY.Bits.TIME_STAMP_DAY3
#define IRTC_TTSR_DAY_TIME_STAMP_DAY4   _IRTC_TTSR_DAY.Bits.TIME_STAMP_DAY4
#define IRTC_TTSR_DAY_TIME_STAMP_DAY    _IRTC_TTSR_DAY.MergedBits.grpTIME_STAMP_DAY

#define IRTC_TTSR_DAY_TIME_STAMP_DAY0_MASK 1
#define IRTC_TTSR_DAY_TIME_STAMP_DAY1_MASK 2
#define IRTC_TTSR_DAY_TIME_STAMP_DAY2_MASK 4
#define IRTC_TTSR_DAY_TIME_STAMP_DAY3_MASK 8
#define IRTC_TTSR_DAY_TIME_STAMP_DAY4_MASK 16
#define IRTC_TTSR_DAY_TIME_STAMP_DAY_MASK 31
#define IRTC_TTSR_DAY_TIME_STAMP_DAY_BITNUM 0


/*** IRTC_TTSR_HM - RTC Tamper Time Stamp Hours & Minutes Register; 0x000018AE ***/
typedef union {
  word Word;
  struct {
    word TIME_STAMP_MINUTES0 :1;                               /* Tamper detect minutes value bits, bit 0 */
    word TIME_STAMP_MINUTES1 :1;                               /* Tamper detect minutes value bits, bit 1 */
    word TIME_STAMP_MINUTES2 :1;                               /* Tamper detect minutes value bits, bit 2 */
    word TIME_STAMP_MINUTES3 :1;                               /* Tamper detect minutes value bits, bit 3 */
    word TIME_STAMP_MINUTES4 :1;                               /* Tamper detect minutes value bits, bit 4 */
    word TIME_STAMP_MINUTES5 :1;                               /* Tamper detect minutes value bits, bit 5 */
    word             :1; 
    word             :1; 
    word TIME_STAMP_HOURS0 :1;                                 /* Tamper detect hours value bits, bit 0 */
    word TIME_STAMP_HOURS1 :1;                                 /* Tamper detect hours value bits, bit 1 */
    word TIME_STAMP_HOURS2 :1;                                 /* Tamper detect hours value bits, bit 2 */
    word TIME_STAMP_HOURS3 :1;                                 /* Tamper detect hours value bits, bit 3 */
    word TIME_STAMP_HOURS4 :1;                                 /* Tamper detect hours value bits, bit 4 */
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpTIME_STAMP_MINUTES :6;
    word         :1;
    word         :1;
    word grpTIME_STAMP_HOURS :5;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} IRTC_TTSR_HMSTR;
extern volatile IRTC_TTSR_HMSTR _IRTC_TTSR_HM @0x000018AE;
#define IRTC_TTSR_HM                    _IRTC_TTSR_HM.Word
#define IRTC_TTSR_HM_TIME_STAMP_MINUTES0 _IRTC_TTSR_HM.Bits.TIME_STAMP_MINUTES0
#define IRTC_TTSR_HM_TIME_STAMP_MINUTES1 _IRTC_TTSR_HM.Bits.TIME_STAMP_MINUTES1
#define IRTC_TTSR_HM_TIME_STAMP_MINUTES2 _IRTC_TTSR_HM.Bits.TIME_STAMP_MINUTES2
#define IRTC_TTSR_HM_TIME_STAMP_MINUTES3 _IRTC_TTSR_HM.Bits.TIME_STAMP_MINUTES3
#define IRTC_TTSR_HM_TIME_STAMP_MINUTES4 _IRTC_TTSR_HM.Bits.TIME_STAMP_MINUTES4
#define IRTC_TTSR_HM_TIME_STAMP_MINUTES5 _IRTC_TTSR_HM.Bits.TIME_STAMP_MINUTES5
#define IRTC_TTSR_HM_TIME_STAMP_HOURS0  _IRTC_TTSR_HM.Bits.TIME_STAMP_HOURS0
#define IRTC_TTSR_HM_TIME_STAMP_HOURS1  _IRTC_TTSR_HM.Bits.TIME_STAMP_HOURS1
#define IRTC_TTSR_HM_TIME_STAMP_HOURS2  _IRTC_TTSR_HM.Bits.TIME_STAMP_HOURS2
#define IRTC_TTSR_HM_TIME_STAMP_HOURS3  _IRTC_TTSR_HM.Bits.TIME_STAMP_HOURS3
#define IRTC_TTSR_HM_TIME_STAMP_HOURS4  _IRTC_TTSR_HM.Bits.TIME_STAMP_HOURS4
#define IRTC_TTSR_HM_TIME_STAMP_MINUTES _IRTC_TTSR_HM.MergedBits.grpTIME_STAMP_MINUTES
#define IRTC_TTSR_HM_TIME_STAMP_HOURS   _IRTC_TTSR_HM.MergedBits.grpTIME_STAMP_HOURS

#define IRTC_TTSR_HM_TIME_STAMP_MINUTES0_MASK 1
#define IRTC_TTSR_HM_TIME_STAMP_MINUTES1_MASK 2
#define IRTC_TTSR_HM_TIME_STAMP_MINUTES2_MASK 4
#define IRTC_TTSR_HM_TIME_STAMP_MINUTES3_MASK 8
#define IRTC_TTSR_HM_TIME_STAMP_MINUTES4_MASK 16
#define IRTC_TTSR_HM_TIME_STAMP_MINUTES5_MASK 32
#define IRTC_TTSR_HM_TIME_STAMP_HOURS0_MASK 256
#define IRTC_TTSR_HM_TIME_STAMP_HOURS1_MASK 512
#define IRTC_TTSR_HM_TIME_STAMP_HOURS2_MASK 1024
#define IRTC_TTSR_HM_TIME_STAMP_HOURS3_MASK 2048
#define IRTC_TTSR_HM_TIME_STAMP_HOURS4_MASK 4096
#define IRTC_TTSR_HM_TIME_STAMP_MINUTES_MASK 63
#define IRTC_TTSR_HM_TIME_STAMP_MINUTES_BITNUM 0
#define IRTC_TTSR_HM_TIME_STAMP_HOURS_MASK 7936
#define IRTC_TTSR_HM_TIME_STAMP_HOURS_BITNUM 8


/*** IRTC_TTSR_SEC - RTC Tamper Time Stamp Seconds Register; 0x000018B0 ***/
typedef union {
  word Word;
  struct {
    word TIME_STAMP_SECONDS0 :1;                               /* Tamper detect seconds value bits, bit 0 */
    word TIME_STAMP_SECONDS1 :1;                               /* Tamper detect seconds value bits, bit 1 */
    word TIME_STAMP_SECONDS2 :1;                               /* Tamper detect seconds value bits, bit 2 */
    word TIME_STAMP_SECONDS3 :1;                               /* Tamper detect seconds value bits, bit 3 */
    word TIME_STAMP_SECONDS4 :1;                               /* Tamper detect seconds value bits, bit 4 */
    word TIME_STAMP_SECONDS5 :1;                               /* Tamper detect seconds value bits, bit 5 */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpTIME_STAMP_SECONDS :6;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} IRTC_TTSR_SECSTR;
extern volatile IRTC_TTSR_SECSTR _IRTC_TTSR_SEC @0x000018B0;
#define IRTC_TTSR_SEC                   _IRTC_TTSR_SEC.Word
#define IRTC_TTSR_SEC_TIME_STAMP_SECONDS0 _IRTC_TTSR_SEC.Bits.TIME_STAMP_SECONDS0
#define IRTC_TTSR_SEC_TIME_STAMP_SECONDS1 _IRTC_TTSR_SEC.Bits.TIME_STAMP_SECONDS1
#define IRTC_TTSR_SEC_TIME_STAMP_SECONDS2 _IRTC_TTSR_SEC.Bits.TIME_STAMP_SECONDS2
#define IRTC_TTSR_SEC_TIME_STAMP_SECONDS3 _IRTC_TTSR_SEC.Bits.TIME_STAMP_SECONDS3
#define IRTC_TTSR_SEC_TIME_STAMP_SECONDS4 _IRTC_TTSR_SEC.Bits.TIME_STAMP_SECONDS4
#define IRTC_TTSR_SEC_TIME_STAMP_SECONDS5 _IRTC_TTSR_SEC.Bits.TIME_STAMP_SECONDS5
#define IRTC_TTSR_SEC_TIME_STAMP_SECONDS _IRTC_TTSR_SEC.MergedBits.grpTIME_STAMP_SECONDS

#define IRTC_TTSR_SEC_TIME_STAMP_SECONDS0_MASK 1
#define IRTC_TTSR_SEC_TIME_STAMP_SECONDS1_MASK 2
#define IRTC_TTSR_SEC_TIME_STAMP_SECONDS2_MASK 4
#define IRTC_TTSR_SEC_TIME_STAMP_SECONDS3_MASK 8
#define IRTC_TTSR_SEC_TIME_STAMP_SECONDS4_MASK 16
#define IRTC_TTSR_SEC_TIME_STAMP_SECONDS5_MASK 32
#define IRTC_TTSR_SEC_TIME_STAMP_SECONDS_MASK 63
#define IRTC_TTSR_SEC_TIME_STAMP_SECONDS_BITNUM 0


/*** IRTC_TAMPER_SCR - Tamper Status & Control Register; 0x000018B2 ***/
typedef union {
  word Word;
  struct {
    word BAT_TAMPER_CTRL :1;                                   /* Battery Tamper Control Bit */
    word TAMPER1_CTRL :1;                                      /* Tamper Pin1 Control Bits */
    word TAMPER2_CTRL :1;                                      /* Tamper Pin2 Control Bits */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word BAT_TAMPER_STATUS :1;                                 /* Battery Tamper Status Bit */
    word TAMPER1_STATUS :1;                                    /* Tamper Pin1 Status Bit */
    word TAMPER2_STATUS :1;                                    /* Tamper Pin2 Status Bit */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} IRTC_TAMPER_SCRSTR;
extern volatile IRTC_TAMPER_SCRSTR _IRTC_TAMPER_SCR @0x000018B2;
#define IRTC_TAMPER_SCR                 _IRTC_TAMPER_SCR.Word
#define IRTC_TAMPER_SCR_BAT_TAMPER_CTRL _IRTC_TAMPER_SCR.Bits.BAT_TAMPER_CTRL
#define IRTC_TAMPER_SCR_TAMPER1_CTRL    _IRTC_TAMPER_SCR.Bits.TAMPER1_CTRL
#define IRTC_TAMPER_SCR_TAMPER2_CTRL    _IRTC_TAMPER_SCR.Bits.TAMPER2_CTRL
#define IRTC_TAMPER_SCR_BAT_TAMPER_STATUS _IRTC_TAMPER_SCR.Bits.BAT_TAMPER_STATUS
#define IRTC_TAMPER_SCR_TAMPER1_STATUS  _IRTC_TAMPER_SCR.Bits.TAMPER1_STATUS
#define IRTC_TAMPER_SCR_TAMPER2_STATUS  _IRTC_TAMPER_SCR.Bits.TAMPER2_STATUS

#define IRTC_TAMPER_SCR_BAT_TAMPER_CTRL_MASK 1
#define IRTC_TAMPER_SCR_TAMPER1_CTRL_MASK 2
#define IRTC_TAMPER_SCR_TAMPER2_CTRL_MASK 4
#define IRTC_TAMPER_SCR_BAT_TAMPER_STATUS_MASK 256
#define IRTC_TAMPER_SCR_TAMPER1_STATUS_MASK 512
#define IRTC_TAMPER_SCR_TAMPER2_STATUS_MASK 1024


/*** IRTC_FILTER01_CTRL - Tamper Filter 0 & 1 Control Register; 0x000018B4 ***/
typedef union {
  word Word;
  struct {
    word FILTER1_DURATION0 :1;                                 /* Tamper Detect Bit 1 Filter Duration, bit 0 */
    word FILTER1_DURATION1 :1;                                 /* Tamper Detect Bit 1 Filter Duration, bit 1 */
    word FILTER1_DURATION2 :1;                                 /* Tamper Detect Bit 1 Filter Duration, bit 2 */
    word FILTER1_DURATION3 :1;                                 /* Tamper Detect Bit 1 Filter Duration, bit 3 */
    word FILTER1_DURATION4 :1;                                 /* Tamper Detect Bit 1 Filter Duration, bit 4 */
    word FILTER1_DURATION5 :1;                                 /* Tamper Detect Bit 1 Filter Duration, bit 5 */
    word CLKSEL      :1;                                       /* Tamper Filter 1 Clock Select */
    word POL         :1;                                       /* Tamper Detect Input Bit 1 Polarity Control */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
  struct {
    word grpFILTER1_DURATION :6;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} IRTC_FILTER01_CTRLSTR;
extern volatile IRTC_FILTER01_CTRLSTR _IRTC_FILTER01_CTRL @0x000018B4;
#define IRTC_FILTER01_CTRL              _IRTC_FILTER01_CTRL.Word
#define IRTC_FILTER01_CTRL_FILTER1_DURATION0 _IRTC_FILTER01_CTRL.Bits.FILTER1_DURATION0
#define IRTC_FILTER01_CTRL_FILTER1_DURATION1 _IRTC_FILTER01_CTRL.Bits.FILTER1_DURATION1
#define IRTC_FILTER01_CTRL_FILTER1_DURATION2 _IRTC_FILTER01_CTRL.Bits.FILTER1_DURATION2
#define IRTC_FILTER01_CTRL_FILTER1_DURATION3 _IRTC_FILTER01_CTRL.Bits.FILTER1_DURATION3
#define IRTC_FILTER01_CTRL_FILTER1_DURATION4 _IRTC_FILTER01_CTRL.Bits.FILTER1_DURATION4
#define IRTC_FILTER01_CTRL_FILTER1_DURATION5 _IRTC_FILTER01_CTRL.Bits.FILTER1_DURATION5
#define IRTC_FILTER01_CTRL_CLKSEL       _IRTC_FILTER01_CTRL.Bits.CLKSEL
#define IRTC_FILTER01_CTRL_POL          _IRTC_FILTER01_CTRL.Bits.POL
#define IRTC_FILTER01_CTRL_FILTER1_DURATION _IRTC_FILTER01_CTRL.MergedBits.grpFILTER1_DURATION

#define IRTC_FILTER01_CTRL_FILTER1_DURATION0_MASK 1
#define IRTC_FILTER01_CTRL_FILTER1_DURATION1_MASK 2
#define IRTC_FILTER01_CTRL_FILTER1_DURATION2_MASK 4
#define IRTC_FILTER01_CTRL_FILTER1_DURATION3_MASK 8
#define IRTC_FILTER01_CTRL_FILTER1_DURATION4_MASK 16
#define IRTC_FILTER01_CTRL_FILTER1_DURATION5_MASK 32
#define IRTC_FILTER01_CTRL_CLKSEL_MASK  64
#define IRTC_FILTER01_CTRL_POL_MASK     128
#define IRTC_FILTER01_CTRL_FILTER1_DURATION_MASK 63
#define IRTC_FILTER01_CTRL_FILTER1_DURATION_BITNUM 0


/*** IRTC_FILTER23_CTRL - Tamper Filter 2 & 3 Control Register; 0x000018B6 ***/
typedef union {
  word Word;
  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word FILTER2_DURATION0 :1;                                 /* Tamper Detect Bit 2 Filter Duration, bit 0 */
    word FILTER2_DURATION1 :1;                                 /* Tamper Detect Bit 2 Filter Duration, bit 1 */
    word FILTER2_DURATION2 :1;                                 /* Tamper Detect Bit 2 Filter Duration, bit 2 */
    word FILTER2_DURATION3 :1;                                 /* Tamper Detect Bit 2 Filter Duration, bit 3 */
    word FILTER2_DURATION4 :1;                                 /* Tamper Detect Bit 2 Filter Duration, bit 4 */
    word FILTER2_DURATION5 :1;                                 /* Tamper Detect Bit 2 Filter Duration, bit 5 */
    word CLKSEL      :1;                                       /* Tamper Filter 2 Clock Select */
    word POL         :1;                                       /* Tamper Detect Input Bit 2 Polarity Control */
  } Bits;
  struct {
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpFILTER2_DURATION :6;
    word         :1;
    word         :1;
  } MergedBits;
} IRTC_FILTER23_CTRLSTR;
extern volatile IRTC_FILTER23_CTRLSTR _IRTC_FILTER23_CTRL @0x000018B6;
#define IRTC_FILTER23_CTRL              _IRTC_FILTER23_CTRL.Word
#define IRTC_FILTER23_CTRL_FILTER2_DURATION0 _IRTC_FILTER23_CTRL.Bits.FILTER2_DURATION0
#define IRTC_FILTER23_CTRL_FILTER2_DURATION1 _IRTC_FILTER23_CTRL.Bits.FILTER2_DURATION1
#define IRTC_FILTER23_CTRL_FILTER2_DURATION2 _IRTC_FILTER23_CTRL.Bits.FILTER2_DURATION2
#define IRTC_FILTER23_CTRL_FILTER2_DURATION3 _IRTC_FILTER23_CTRL.Bits.FILTER2_DURATION3
#define IRTC_FILTER23_CTRL_FILTER2_DURATION4 _IRTC_FILTER23_CTRL.Bits.FILTER2_DURATION4
#define IRTC_FILTER23_CTRL_FILTER2_DURATION5 _IRTC_FILTER23_CTRL.Bits.FILTER2_DURATION5
#define IRTC_FILTER23_CTRL_CLKSEL       _IRTC_FILTER23_CTRL.Bits.CLKSEL
#define IRTC_FILTER23_CTRL_POL          _IRTC_FILTER23_CTRL.Bits.POL
#define IRTC_FILTER23_CTRL_FILTER2_DURATION _IRTC_FILTER23_CTRL.MergedBits.grpFILTER2_DURATION

#define IRTC_FILTER23_CTRL_FILTER2_DURATION0_MASK 256
#define IRTC_FILTER23_CTRL_FILTER2_DURATION1_MASK 512
#define IRTC_FILTER23_CTRL_FILTER2_DURATION2_MASK 1024
#define IRTC_FILTER23_CTRL_FILTER2_DURATION3_MASK 2048
#define IRTC_FILTER23_CTRL_FILTER2_DURATION4_MASK 4096
#define IRTC_FILTER23_CTRL_FILTER2_DURATION5_MASK 8192
#define IRTC_FILTER23_CTRL_CLKSEL_MASK  16384
#define IRTC_FILTER23_CTRL_POL_MASK     32768
#define IRTC_FILTER23_CTRL_FILTER2_DURATION_MASK 16128
#define IRTC_FILTER23_CTRL_FILTER2_DURATION_BITNUM 8


/*** PTAPE - Port A Pull Enable Register; 0x000018E0 ***/
typedef union {
  byte Byte;
  struct {
    byte PTAPE0      :1;                                       /* Internal Pull Enable for Port A Bit 0 */
    byte PTAPE1      :1;                                       /* Internal Pull Enable for Port A Bit 1 */
    byte PTAPE2      :1;                                       /* Internal Pull Enable for Port A Bit 2 */
    byte PTAPE3      :1;                                       /* Internal Pull Enable for Port A Bit 3 */
    byte PTAPE4      :1;                                       /* Internal Pull Enable for Port A Bit 4 */
    byte PTAPE5      :1;                                       /* Internal Pull Enable for Port A Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTAPE :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTAPESTR;
extern volatile PTAPESTR _PTAPE @0x000018E0;
#define PTAPE                           _PTAPE.Byte
#define PTAPE_PTAPE0                    _PTAPE.Bits.PTAPE0
#define PTAPE_PTAPE1                    _PTAPE.Bits.PTAPE1
#define PTAPE_PTAPE2                    _PTAPE.Bits.PTAPE2
#define PTAPE_PTAPE3                    _PTAPE.Bits.PTAPE3
#define PTAPE_PTAPE4                    _PTAPE.Bits.PTAPE4
#define PTAPE_PTAPE5                    _PTAPE.Bits.PTAPE5
#define PTAPE_PTAPE                     _PTAPE.MergedBits.grpPTAPE

#define PTAPE_PTAPE0_MASK               1
#define PTAPE_PTAPE1_MASK               2
#define PTAPE_PTAPE2_MASK               4
#define PTAPE_PTAPE3_MASK               8
#define PTAPE_PTAPE4_MASK               16
#define PTAPE_PTAPE5_MASK               32
#define PTAPE_PTAPE_MASK                63
#define PTAPE_PTAPE_BITNUM              0


/*** PTASE - Port A Slew Rate Enable Register; 0x000018E1 ***/
typedef union {
  byte Byte;
  struct {
    byte PTASE0      :1;                                       /* Output Slew Rate Enable for Port A Bit 0 */
    byte PTASE1      :1;                                       /* Output Slew Rate Enable for Port A Bit 1 */
    byte PTASE2      :1;                                       /* Output Slew Rate Enable for Port A Bit 2 */
    byte PTASE3      :1;                                       /* Output Slew Rate Enable for Port A Bit 3 */
    byte PTASE4      :1;                                       /* Output Slew Rate Enable for Port A Bit 4 */
    byte PTASE5      :1;                                       /* Output Slew Rate Enable for Port A Bit 5 */
    byte PTASE6      :1;                                       /* Output Slew Rate Enable for Port A Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpPTASE :7;
    byte         :1;
  } MergedBits;
} PTASESTR;
extern volatile PTASESTR _PTASE @0x000018E1;
#define PTASE                           _PTASE.Byte
#define PTASE_PTASE0                    _PTASE.Bits.PTASE0
#define PTASE_PTASE1                    _PTASE.Bits.PTASE1
#define PTASE_PTASE2                    _PTASE.Bits.PTASE2
#define PTASE_PTASE3                    _PTASE.Bits.PTASE3
#define PTASE_PTASE4                    _PTASE.Bits.PTASE4
#define PTASE_PTASE5                    _PTASE.Bits.PTASE5
#define PTASE_PTASE6                    _PTASE.Bits.PTASE6
#define PTASE_PTASE                     _PTASE.MergedBits.grpPTASE

#define PTASE_PTASE0_MASK               1
#define PTASE_PTASE1_MASK               2
#define PTASE_PTASE2_MASK               4
#define PTASE_PTASE3_MASK               8
#define PTASE_PTASE4_MASK               16
#define PTASE_PTASE5_MASK               32
#define PTASE_PTASE6_MASK               64
#define PTASE_PTASE_MASK                127
#define PTASE_PTASE_BITNUM              0


/*** PTADS - Port A Drive Strength Selection Register; 0x000018E2 ***/
typedef union {
  byte Byte;
  struct {
    byte PTADS0      :1;                                       /* Output Drive Strength Selection for Port A Bit 0 */
    byte PTADS1      :1;                                       /* Output Drive Strength Selection for Port A Bit 1 */
    byte PTADS2      :1;                                       /* Output Drive Strength Selection for Port A Bit 2 */
    byte PTADS3      :1;                                       /* Output Drive Strength Selection for Port A Bit 3 */
    byte PTADS4      :1;                                       /* Output Drive Strength Selection for Port A Bit 4 */
    byte PTADS5      :1;                                       /* Output Drive Strength Selection for Port A Bit 5 */
    byte PTADS6      :1;                                       /* Output Drive Strength Selection for Port A Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpPTADS :7;
    byte         :1;
  } MergedBits;
} PTADSSTR;
extern volatile PTADSSTR _PTADS @0x000018E2;
#define PTADS                           _PTADS.Byte
#define PTADS_PTADS0                    _PTADS.Bits.PTADS0
#define PTADS_PTADS1                    _PTADS.Bits.PTADS1
#define PTADS_PTADS2                    _PTADS.Bits.PTADS2
#define PTADS_PTADS3                    _PTADS.Bits.PTADS3
#define PTADS_PTADS4                    _PTADS.Bits.PTADS4
#define PTADS_PTADS5                    _PTADS.Bits.PTADS5
#define PTADS_PTADS6                    _PTADS.Bits.PTADS6
#define PTADS_PTADS                     _PTADS.MergedBits.grpPTADS

#define PTADS_PTADS0_MASK               1
#define PTADS_PTADS1_MASK               2
#define PTADS_PTADS2_MASK               4
#define PTADS_PTADS3_MASK               8
#define PTADS_PTADS4_MASK               16
#define PTADS_PTADS5_MASK               32
#define PTADS_PTADS6_MASK               64
#define PTADS_PTADS_MASK                127
#define PTADS_PTADS_BITNUM              0


/*** PTAIFE - Port A Input Filter Enable Register; 0x000018E3 ***/
typedef union {
  byte Byte;
  struct {
    byte PTAIFE0     :1;                                       /* Port A Input Filter Enable Bit 0 */
    byte PTAIFE1     :1;                                       /* Port A Input Filter Enable Bit 1 */
    byte PTAIFE2     :1;                                       /* Port A Input Filter Enable Bit 2 */
    byte PTAIFE3     :1;                                       /* Port A Input Filter Enable Bit 3 */
    byte PTAIFE4     :1;                                       /* Port A Input Filter Enable Bit 4 */
    byte PTAIFE5     :1;                                       /* Port A Input Filter Enable Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTAIFE :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTAIFESTR;
extern volatile PTAIFESTR _PTAIFE @0x000018E3;
#define PTAIFE                          _PTAIFE.Byte
#define PTAIFE_PTAIFE0                  _PTAIFE.Bits.PTAIFE0
#define PTAIFE_PTAIFE1                  _PTAIFE.Bits.PTAIFE1
#define PTAIFE_PTAIFE2                  _PTAIFE.Bits.PTAIFE2
#define PTAIFE_PTAIFE3                  _PTAIFE.Bits.PTAIFE3
#define PTAIFE_PTAIFE4                  _PTAIFE.Bits.PTAIFE4
#define PTAIFE_PTAIFE5                  _PTAIFE.Bits.PTAIFE5
#define PTAIFE_PTAIFE                   _PTAIFE.MergedBits.grpPTAIFE

#define PTAIFE_PTAIFE0_MASK             1
#define PTAIFE_PTAIFE1_MASK             2
#define PTAIFE_PTAIFE2_MASK             4
#define PTAIFE_PTAIFE3_MASK             8
#define PTAIFE_PTAIFE4_MASK             16
#define PTAIFE_PTAIFE5_MASK             32
#define PTAIFE_PTAIFE_MASK              63
#define PTAIFE_PTAIFE_BITNUM            0


/*** PTBPE - Port B Pull Enable Register; 0x000018E4 ***/
typedef union {
  byte Byte;
  struct {
    byte PTBPE0      :1;                                       /* Internal Pull Enable for Port B Bit 0 */
    byte PTBPE1      :1;                                       /* Internal Pull Enable for Port B Bit 1 */
    byte PTBPE2      :1;                                       /* Internal Pull Enable for Port B Bit 2 */
    byte PTBPE3      :1;                                       /* Internal Pull Enable for Port B Bit 3 */
    byte PTBPE4      :1;                                       /* Internal Pull Enable for Port B Bit 4 */
    byte PTBPE5      :1;                                       /* Internal Pull Enable for Port B Bit 5 */
    byte PTBPE6      :1;                                       /* Internal Pull Enable for Port B Bit 6 */
    byte PTBPE7      :1;                                       /* Internal Pull Enable for Port B Bit 7 */
  } Bits;
} PTBPESTR;
extern volatile PTBPESTR _PTBPE @0x000018E4;
#define PTBPE                           _PTBPE.Byte
#define PTBPE_PTBPE0                    _PTBPE.Bits.PTBPE0
#define PTBPE_PTBPE1                    _PTBPE.Bits.PTBPE1
#define PTBPE_PTBPE2                    _PTBPE.Bits.PTBPE2
#define PTBPE_PTBPE3                    _PTBPE.Bits.PTBPE3
#define PTBPE_PTBPE4                    _PTBPE.Bits.PTBPE4
#define PTBPE_PTBPE5                    _PTBPE.Bits.PTBPE5
#define PTBPE_PTBPE6                    _PTBPE.Bits.PTBPE6
#define PTBPE_PTBPE7                    _PTBPE.Bits.PTBPE7

#define PTBPE_PTBPE0_MASK               1
#define PTBPE_PTBPE1_MASK               2
#define PTBPE_PTBPE2_MASK               4
#define PTBPE_PTBPE3_MASK               8
#define PTBPE_PTBPE4_MASK               16
#define PTBPE_PTBPE5_MASK               32
#define PTBPE_PTBPE6_MASK               64
#define PTBPE_PTBPE7_MASK               128


/*** PTBSE - Port B Slew Rate Enable Register; 0x000018E5 ***/
typedef union {
  byte Byte;
  struct {
    byte PTBSE0      :1;                                       /* Output Slew Rate Enable for Port B Bit 0 */
    byte PTBSE1      :1;                                       /* Output Slew Rate Enable for Port B Bit 1 */
    byte PTBSE2      :1;                                       /* Output Slew Rate Enable for Port B Bit 2 */
    byte PTBSE3      :1;                                       /* Output Slew Rate Enable for Port B Bit 3 */
    byte PTBSE4      :1;                                       /* Output Slew Rate Enable for Port B Bit 4 */
    byte PTBSE5      :1;                                       /* Output Slew Rate Enable for Port B Bit 5 */
    byte PTBSE6      :1;                                       /* Output Slew Rate Enable for Port B Bit 6 */
    byte PTBSE7      :1;                                       /* Output Slew Rate Enable for Port B Bit 7 */
  } Bits;
} PTBSESTR;
extern volatile PTBSESTR _PTBSE @0x000018E5;
#define PTBSE                           _PTBSE.Byte
#define PTBSE_PTBSE0                    _PTBSE.Bits.PTBSE0
#define PTBSE_PTBSE1                    _PTBSE.Bits.PTBSE1
#define PTBSE_PTBSE2                    _PTBSE.Bits.PTBSE2
#define PTBSE_PTBSE3                    _PTBSE.Bits.PTBSE3
#define PTBSE_PTBSE4                    _PTBSE.Bits.PTBSE4
#define PTBSE_PTBSE5                    _PTBSE.Bits.PTBSE5
#define PTBSE_PTBSE6                    _PTBSE.Bits.PTBSE6
#define PTBSE_PTBSE7                    _PTBSE.Bits.PTBSE7

#define PTBSE_PTBSE0_MASK               1
#define PTBSE_PTBSE1_MASK               2
#define PTBSE_PTBSE2_MASK               4
#define PTBSE_PTBSE3_MASK               8
#define PTBSE_PTBSE4_MASK               16
#define PTBSE_PTBSE5_MASK               32
#define PTBSE_PTBSE6_MASK               64
#define PTBSE_PTBSE7_MASK               128


/*** PTBDS - Port B Drive Strength Selection Register; 0x000018E6 ***/
typedef union {
  byte Byte;
  struct {
    byte PTBDS0      :1;                                       /* Output Drive Strength Selection for Port B Bit 0 */
    byte PTBDS1      :1;                                       /* Output Drive Strength Selection for Port B Bit 1 */
    byte PTBDS2      :1;                                       /* Output Drive Strength Selection for Port B Bit 2 */
    byte PTBDS3      :1;                                       /* Output Drive Strength Selection for Port B Bit 3 */
    byte PTBDS4      :1;                                       /* Output Drive Strength Selection for Port B Bit 4 */
    byte PTBDS5      :1;                                       /* Output Drive Strength Selection for Port B Bit 5 */
    byte PTBDS6      :1;                                       /* Output Drive Strength Selection for Port B Bit 6 */
    byte PTBDS7      :1;                                       /* Output Drive Strength Selection for Port B Bit 7 */
  } Bits;
} PTBDSSTR;
extern volatile PTBDSSTR _PTBDS @0x000018E6;
#define PTBDS                           _PTBDS.Byte
#define PTBDS_PTBDS0                    _PTBDS.Bits.PTBDS0
#define PTBDS_PTBDS1                    _PTBDS.Bits.PTBDS1
#define PTBDS_PTBDS2                    _PTBDS.Bits.PTBDS2
#define PTBDS_PTBDS3                    _PTBDS.Bits.PTBDS3
#define PTBDS_PTBDS4                    _PTBDS.Bits.PTBDS4
#define PTBDS_PTBDS5                    _PTBDS.Bits.PTBDS5
#define PTBDS_PTBDS6                    _PTBDS.Bits.PTBDS6
#define PTBDS_PTBDS7                    _PTBDS.Bits.PTBDS7

#define PTBDS_PTBDS0_MASK               1
#define PTBDS_PTBDS1_MASK               2
#define PTBDS_PTBDS2_MASK               4
#define PTBDS_PTBDS3_MASK               8
#define PTBDS_PTBDS4_MASK               16
#define PTBDS_PTBDS5_MASK               32
#define PTBDS_PTBDS6_MASK               64
#define PTBDS_PTBDS7_MASK               128


/*** PTBIFE - Port B Input Filter Enable Register; 0x000018E7 ***/
typedef union {
  byte Byte;
  struct {
    byte PTBIFE0     :1;                                       /* Port B Input Filter Enable Bit 0 */
    byte PTBIFE1     :1;                                       /* Port B Input Filter Enable Bit 1 */
    byte PTBIFE2     :1;                                       /* Port B Input Filter Enable Bit 2 */
    byte PTBIFE3     :1;                                       /* Port B Input Filter Enable Bit 3 */
    byte PTBIFE4     :1;                                       /* Port B Input Filter Enable Bit 4 */
    byte PTBIFE5     :1;                                       /* Port B Input Filter Enable Bit 5 */
    byte PTBIFE6     :1;                                       /* Port B Input Filter Enable Bit 6 */
    byte PTBIFE7     :1;                                       /* Port B Input Filter Enable Bit 7 */
  } Bits;
} PTBIFESTR;
extern volatile PTBIFESTR _PTBIFE @0x000018E7;
#define PTBIFE                          _PTBIFE.Byte
#define PTBIFE_PTBIFE0                  _PTBIFE.Bits.PTBIFE0
#define PTBIFE_PTBIFE1                  _PTBIFE.Bits.PTBIFE1
#define PTBIFE_PTBIFE2                  _PTBIFE.Bits.PTBIFE2
#define PTBIFE_PTBIFE3                  _PTBIFE.Bits.PTBIFE3
#define PTBIFE_PTBIFE4                  _PTBIFE.Bits.PTBIFE4
#define PTBIFE_PTBIFE5                  _PTBIFE.Bits.PTBIFE5
#define PTBIFE_PTBIFE6                  _PTBIFE.Bits.PTBIFE6
#define PTBIFE_PTBIFE7                  _PTBIFE.Bits.PTBIFE7

#define PTBIFE_PTBIFE0_MASK             1
#define PTBIFE_PTBIFE1_MASK             2
#define PTBIFE_PTBIFE2_MASK             4
#define PTBIFE_PTBIFE3_MASK             8
#define PTBIFE_PTBIFE4_MASK             16
#define PTBIFE_PTBIFE5_MASK             32
#define PTBIFE_PTBIFE6_MASK             64
#define PTBIFE_PTBIFE7_MASK             128


/*** PTCPE - Port C Pull Enable Register; 0x000018E8 ***/
typedef union {
  byte Byte;
  struct {
    byte PTCPE0      :1;                                       /* Internal Pull Enable for Port C Bit 0 */
    byte PTCPE1      :1;                                       /* Internal Pull Enable for Port C Bit 1 */
    byte PTCPE2      :1;                                       /* Internal Pull Enable for Port C Bit 2 */
    byte PTCPE3      :1;                                       /* Internal Pull Enable for Port C Bit 3 */
    byte PTCPE4      :1;                                       /* Internal Pull Enable for Port C Bit 4 */
    byte PTCPE5      :1;                                       /* Internal Pull Enable for Port C Bit 5 */
    byte PTCPE6      :1;                                       /* Internal Pull Enable for Port C Bit 6 */
    byte PTCPE7      :1;                                       /* Internal Pull Enable for Port C Bit 7 */
  } Bits;
} PTCPESTR;
extern volatile PTCPESTR _PTCPE @0x000018E8;
#define PTCPE                           _PTCPE.Byte
#define PTCPE_PTCPE0                    _PTCPE.Bits.PTCPE0
#define PTCPE_PTCPE1                    _PTCPE.Bits.PTCPE1
#define PTCPE_PTCPE2                    _PTCPE.Bits.PTCPE2
#define PTCPE_PTCPE3                    _PTCPE.Bits.PTCPE3
#define PTCPE_PTCPE4                    _PTCPE.Bits.PTCPE4
#define PTCPE_PTCPE5                    _PTCPE.Bits.PTCPE5
#define PTCPE_PTCPE6                    _PTCPE.Bits.PTCPE6
#define PTCPE_PTCPE7                    _PTCPE.Bits.PTCPE7

#define PTCPE_PTCPE0_MASK               1
#define PTCPE_PTCPE1_MASK               2
#define PTCPE_PTCPE2_MASK               4
#define PTCPE_PTCPE3_MASK               8
#define PTCPE_PTCPE4_MASK               16
#define PTCPE_PTCPE5_MASK               32
#define PTCPE_PTCPE6_MASK               64
#define PTCPE_PTCPE7_MASK               128


/*** PTCSE - Port C Slew Rate Enable Register; 0x000018E9 ***/
typedef union {
  byte Byte;
  struct {
    byte PTCSE0      :1;                                       /* Output Slew Rate Enable for Port C Bit 0 */
    byte PTCSE1      :1;                                       /* Output Slew Rate Enable for Port C Bit 1 */
    byte PTCSE2      :1;                                       /* Output Slew Rate Enable for Port C Bit 2 */
    byte PTCSE3      :1;                                       /* Output Slew Rate Enable for Port C Bit 3 */
    byte PTCSE4      :1;                                       /* Output Slew Rate Enable for Port C Bit 4 */
    byte PTCSE5      :1;                                       /* Output Slew Rate Enable for Port C Bit 5 */
    byte PTCSE6      :1;                                       /* Output Slew Rate Enable for Port C Bit 6 */
    byte PTCSE7      :1;                                       /* Output Slew Rate Enable for Port C Bit 7 */
  } Bits;
} PTCSESTR;
extern volatile PTCSESTR _PTCSE @0x000018E9;
#define PTCSE                           _PTCSE.Byte
#define PTCSE_PTCSE0                    _PTCSE.Bits.PTCSE0
#define PTCSE_PTCSE1                    _PTCSE.Bits.PTCSE1
#define PTCSE_PTCSE2                    _PTCSE.Bits.PTCSE2
#define PTCSE_PTCSE3                    _PTCSE.Bits.PTCSE3
#define PTCSE_PTCSE4                    _PTCSE.Bits.PTCSE4
#define PTCSE_PTCSE5                    _PTCSE.Bits.PTCSE5
#define PTCSE_PTCSE6                    _PTCSE.Bits.PTCSE6
#define PTCSE_PTCSE7                    _PTCSE.Bits.PTCSE7

#define PTCSE_PTCSE0_MASK               1
#define PTCSE_PTCSE1_MASK               2
#define PTCSE_PTCSE2_MASK               4
#define PTCSE_PTCSE3_MASK               8
#define PTCSE_PTCSE4_MASK               16
#define PTCSE_PTCSE5_MASK               32
#define PTCSE_PTCSE6_MASK               64
#define PTCSE_PTCSE7_MASK               128


/*** PTCDS - Port C Drive Strength Selection Register; 0x000018EA ***/
typedef union {
  byte Byte;
  struct {
    byte PTCDS0      :1;                                       /* Output Drive Strength Selection for Port C Bit 0 */
    byte PTCDS1      :1;                                       /* Output Drive Strength Selection for Port C Bit 1 */
    byte PTCDS2      :1;                                       /* Output Drive Strength Selection for Port C Bit 2 */
    byte PTCDS3      :1;                                       /* Output Drive Strength Selection for Port C Bit 3 */
    byte PTCDS4      :1;                                       /* Output Drive Strength Selection for Port C Bit 4 */
    byte PTCDS5      :1;                                       /* Output Drive Strength Selection for Port C Bit 5 */
    byte PTCDS6      :1;                                       /* Output Drive Strength Selection for Port C Bit 6 */
    byte PTCDS7      :1;                                       /* Output Drive Strength Selection for Port C Bit 7 */
  } Bits;
} PTCDSSTR;
extern volatile PTCDSSTR _PTCDS @0x000018EA;
#define PTCDS                           _PTCDS.Byte
#define PTCDS_PTCDS0                    _PTCDS.Bits.PTCDS0
#define PTCDS_PTCDS1                    _PTCDS.Bits.PTCDS1
#define PTCDS_PTCDS2                    _PTCDS.Bits.PTCDS2
#define PTCDS_PTCDS3                    _PTCDS.Bits.PTCDS3
#define PTCDS_PTCDS4                    _PTCDS.Bits.PTCDS4
#define PTCDS_PTCDS5                    _PTCDS.Bits.PTCDS5
#define PTCDS_PTCDS6                    _PTCDS.Bits.PTCDS6
#define PTCDS_PTCDS7                    _PTCDS.Bits.PTCDS7

#define PTCDS_PTCDS0_MASK               1
#define PTCDS_PTCDS1_MASK               2
#define PTCDS_PTCDS2_MASK               4
#define PTCDS_PTCDS3_MASK               8
#define PTCDS_PTCDS4_MASK               16
#define PTCDS_PTCDS5_MASK               32
#define PTCDS_PTCDS6_MASK               64
#define PTCDS_PTCDS7_MASK               128


/*** PTCIFE - Port C Input Filter Enable Register; 0x000018EB ***/
typedef union {
  byte Byte;
  struct {
    byte PTCIFE0     :1;                                       /* Port C Input Filter Enable Bit 0 */
    byte PTCIFE1     :1;                                       /* Port C Input Filter Enable Bit 1 */
    byte PTCIFE2     :1;                                       /* Port C Input Filter Enable Bit 2 */
    byte PTCIFE3     :1;                                       /* Port C Input Filter Enable Bit 3 */
    byte PTCIFE4     :1;                                       /* Port C Input Filter Enable Bit 4 */
    byte PTCIFE5     :1;                                       /* Port C Input Filter Enable Bit 5 */
    byte PTCIFE6     :1;                                       /* Port C Input Filter Enable Bit 6 */
    byte PTCIFE7     :1;                                       /* Port C Input Filter Enable Bit 7 */
  } Bits;
} PTCIFESTR;
extern volatile PTCIFESTR _PTCIFE @0x000018EB;
#define PTCIFE                          _PTCIFE.Byte
#define PTCIFE_PTCIFE0                  _PTCIFE.Bits.PTCIFE0
#define PTCIFE_PTCIFE1                  _PTCIFE.Bits.PTCIFE1
#define PTCIFE_PTCIFE2                  _PTCIFE.Bits.PTCIFE2
#define PTCIFE_PTCIFE3                  _PTCIFE.Bits.PTCIFE3
#define PTCIFE_PTCIFE4                  _PTCIFE.Bits.PTCIFE4
#define PTCIFE_PTCIFE5                  _PTCIFE.Bits.PTCIFE5
#define PTCIFE_PTCIFE6                  _PTCIFE.Bits.PTCIFE6
#define PTCIFE_PTCIFE7                  _PTCIFE.Bits.PTCIFE7

#define PTCIFE_PTCIFE0_MASK             1
#define PTCIFE_PTCIFE1_MASK             2
#define PTCIFE_PTCIFE2_MASK             4
#define PTCIFE_PTCIFE3_MASK             8
#define PTCIFE_PTCIFE4_MASK             16
#define PTCIFE_PTCIFE5_MASK             32
#define PTCIFE_PTCIFE6_MASK             64
#define PTCIFE_PTCIFE7_MASK             128


/*** PTDPE - Port D Pull Enable Register; 0x000018EC ***/
typedef union {
  byte Byte;
  struct {
    byte PTDPE0      :1;                                       /* Internal Pull Enable for Port D Bit 0 */
    byte PTDPE1      :1;                                       /* Internal Pull Enable for Port D Bit 1 */
    byte PTDPE2      :1;                                       /* Internal Pull Enable for Port D Bit 2 */
    byte PTDPE3      :1;                                       /* Internal Pull Enable for Port D Bit 3 */
    byte PTDPE4      :1;                                       /* Internal Pull Enable for Port D Bit 4 */
    byte PTDPE5      :1;                                       /* Internal Pull Enable for Port D Bit 5 */
    byte PTDPE6      :1;                                       /* Internal Pull Enable for Port D Bit 6 */
    byte PTDPE7      :1;                                       /* Internal Pull Enable for Port D Bit 7 */
  } Bits;
} PTDPESTR;
extern volatile PTDPESTR _PTDPE @0x000018EC;
#define PTDPE                           _PTDPE.Byte
#define PTDPE_PTDPE0                    _PTDPE.Bits.PTDPE0
#define PTDPE_PTDPE1                    _PTDPE.Bits.PTDPE1
#define PTDPE_PTDPE2                    _PTDPE.Bits.PTDPE2
#define PTDPE_PTDPE3                    _PTDPE.Bits.PTDPE3
#define PTDPE_PTDPE4                    _PTDPE.Bits.PTDPE4
#define PTDPE_PTDPE5                    _PTDPE.Bits.PTDPE5
#define PTDPE_PTDPE6                    _PTDPE.Bits.PTDPE6
#define PTDPE_PTDPE7                    _PTDPE.Bits.PTDPE7

#define PTDPE_PTDPE0_MASK               1
#define PTDPE_PTDPE1_MASK               2
#define PTDPE_PTDPE2_MASK               4
#define PTDPE_PTDPE3_MASK               8
#define PTDPE_PTDPE4_MASK               16
#define PTDPE_PTDPE5_MASK               32
#define PTDPE_PTDPE6_MASK               64
#define PTDPE_PTDPE7_MASK               128


/*** PTDSE - Port D Slew Rate Enable Register; 0x000018ED ***/
typedef union {
  byte Byte;
  struct {
    byte PTDSE0      :1;                                       /* Output Slew Rate Enable for Port D Bit 0 */
    byte PTDSE1      :1;                                       /* Output Slew Rate Enable for Port D Bit 1 */
    byte PTDSE2      :1;                                       /* Output Slew Rate Enable for Port D Bit 2 */
    byte PTDSE3      :1;                                       /* Output Slew Rate Enable for Port D Bit 3 */
    byte PTDSE4      :1;                                       /* Output Slew Rate Enable for Port D Bit 4 */
    byte PTDSE5      :1;                                       /* Output Slew Rate Enable for Port D Bit 5 */
    byte PTDSE6      :1;                                       /* Output Slew Rate Enable for Port D Bit 6 */
    byte PTDSE7      :1;                                       /* Output Slew Rate Enable for Port D Bit 7 */
  } Bits;
} PTDSESTR;
extern volatile PTDSESTR _PTDSE @0x000018ED;
#define PTDSE                           _PTDSE.Byte
#define PTDSE_PTDSE0                    _PTDSE.Bits.PTDSE0
#define PTDSE_PTDSE1                    _PTDSE.Bits.PTDSE1
#define PTDSE_PTDSE2                    _PTDSE.Bits.PTDSE2
#define PTDSE_PTDSE3                    _PTDSE.Bits.PTDSE3
#define PTDSE_PTDSE4                    _PTDSE.Bits.PTDSE4
#define PTDSE_PTDSE5                    _PTDSE.Bits.PTDSE5
#define PTDSE_PTDSE6                    _PTDSE.Bits.PTDSE6
#define PTDSE_PTDSE7                    _PTDSE.Bits.PTDSE7

#define PTDSE_PTDSE0_MASK               1
#define PTDSE_PTDSE1_MASK               2
#define PTDSE_PTDSE2_MASK               4
#define PTDSE_PTDSE3_MASK               8
#define PTDSE_PTDSE4_MASK               16
#define PTDSE_PTDSE5_MASK               32
#define PTDSE_PTDSE6_MASK               64
#define PTDSE_PTDSE7_MASK               128


/*** PTDDS - Port D Drive Strength Selection Register; 0x000018EE ***/
typedef union {
  byte Byte;
  struct {
    byte PTDDS0      :1;                                       /* Output Drive Strength Selection for Port D Bit 0 */
    byte PTDDS1      :1;                                       /* Output Drive Strength Selection for Port D Bit 1 */
    byte PTDDS2      :1;                                       /* Output Drive Strength Selection for Port D Bit 2 */
    byte PTDDS3      :1;                                       /* Output Drive Strength Selection for Port D Bit 3 */
    byte PTDDS4      :1;                                       /* Output Drive Strength Selection for Port D Bit 4 */
    byte PTDDS5      :1;                                       /* Output Drive Strength Selection for Port D Bit 5 */
    byte PTDDS6      :1;                                       /* Output Drive Strength Selection for Port D Bit 6 */
    byte PTDDS7      :1;                                       /* Output Drive Strength Selection for Port D Bit 7 */
  } Bits;
} PTDDSSTR;
extern volatile PTDDSSTR _PTDDS @0x000018EE;
#define PTDDS                           _PTDDS.Byte
#define PTDDS_PTDDS0                    _PTDDS.Bits.PTDDS0
#define PTDDS_PTDDS1                    _PTDDS.Bits.PTDDS1
#define PTDDS_PTDDS2                    _PTDDS.Bits.PTDDS2
#define PTDDS_PTDDS3                    _PTDDS.Bits.PTDDS3
#define PTDDS_PTDDS4                    _PTDDS.Bits.PTDDS4
#define PTDDS_PTDDS5                    _PTDDS.Bits.PTDDS5
#define PTDDS_PTDDS6                    _PTDDS.Bits.PTDDS6
#define PTDDS_PTDDS7                    _PTDDS.Bits.PTDDS7

#define PTDDS_PTDDS0_MASK               1
#define PTDDS_PTDDS1_MASK               2
#define PTDDS_PTDDS2_MASK               4
#define PTDDS_PTDDS3_MASK               8
#define PTDDS_PTDDS4_MASK               16
#define PTDDS_PTDDS5_MASK               32
#define PTDDS_PTDDS6_MASK               64
#define PTDDS_PTDDS7_MASK               128


/*** PTDIFE - Port D Input Filter Enable Register; 0x000018EF ***/
typedef union {
  byte Byte;
  struct {
    byte PTDIFE0     :1;                                       /* Port D Input Filter Enable Bit 0 */
    byte PTDIFE1     :1;                                       /* Port D Input Filter Enable Bit 1 */
    byte PTDIFE2     :1;                                       /* Port D Input Filter Enable Bit 2 */
    byte PTDIFE3     :1;                                       /* Port D Input Filter Enable Bit 3 */
    byte PTDIFE4     :1;                                       /* Port D Input Filter Enable Bit 4 */
    byte PTDIFE5     :1;                                       /* Port D Input Filter Enable Bit 5 */
    byte PTDIFE6     :1;                                       /* Port D Input Filter Enable Bit 6 */
    byte PTDIFE7     :1;                                       /* Port D Input Filter Enable Bit 7 */
  } Bits;
} PTDIFESTR;
extern volatile PTDIFESTR _PTDIFE @0x000018EF;
#define PTDIFE                          _PTDIFE.Byte
#define PTDIFE_PTDIFE0                  _PTDIFE.Bits.PTDIFE0
#define PTDIFE_PTDIFE1                  _PTDIFE.Bits.PTDIFE1
#define PTDIFE_PTDIFE2                  _PTDIFE.Bits.PTDIFE2
#define PTDIFE_PTDIFE3                  _PTDIFE.Bits.PTDIFE3
#define PTDIFE_PTDIFE4                  _PTDIFE.Bits.PTDIFE4
#define PTDIFE_PTDIFE5                  _PTDIFE.Bits.PTDIFE5
#define PTDIFE_PTDIFE6                  _PTDIFE.Bits.PTDIFE6
#define PTDIFE_PTDIFE7                  _PTDIFE.Bits.PTDIFE7

#define PTDIFE_PTDIFE0_MASK             1
#define PTDIFE_PTDIFE1_MASK             2
#define PTDIFE_PTDIFE2_MASK             4
#define PTDIFE_PTDIFE3_MASK             8
#define PTDIFE_PTDIFE4_MASK             16
#define PTDIFE_PTDIFE5_MASK             32
#define PTDIFE_PTDIFE6_MASK             64
#define PTDIFE_PTDIFE7_MASK             128


/*** PTEPE - Port E Pull Enable Register; 0x000018F0 ***/
typedef union {
  byte Byte;
  struct {
    byte PTEPE0      :1;                                       /* Internal Pull Enable for Port E Bit 0 */
    byte PTEPE1      :1;                                       /* Internal Pull Enable for Port E Bit 1 */
    byte PTEPE2      :1;                                       /* Internal Pull Enable for Port E Bit 2 */
    byte PTEPE3      :1;                                       /* Internal Pull Enable for Port E Bit 3 */
    byte PTEPE4      :1;                                       /* Internal Pull Enable for Port E Bit 4 */
    byte PTEPE5      :1;                                       /* Internal Pull Enable for Port E Bit 5 */
    byte PTEPE6      :1;                                       /* Internal Pull Enable for Port E Bit 6 */
    byte PTEPE7      :1;                                       /* Internal Pull Enable for Port E Bit 7 */
  } Bits;
} PTEPESTR;
extern volatile PTEPESTR _PTEPE @0x000018F0;
#define PTEPE                           _PTEPE.Byte
#define PTEPE_PTEPE0                    _PTEPE.Bits.PTEPE0
#define PTEPE_PTEPE1                    _PTEPE.Bits.PTEPE1
#define PTEPE_PTEPE2                    _PTEPE.Bits.PTEPE2
#define PTEPE_PTEPE3                    _PTEPE.Bits.PTEPE3
#define PTEPE_PTEPE4                    _PTEPE.Bits.PTEPE4
#define PTEPE_PTEPE5                    _PTEPE.Bits.PTEPE5
#define PTEPE_PTEPE6                    _PTEPE.Bits.PTEPE6
#define PTEPE_PTEPE7                    _PTEPE.Bits.PTEPE7

#define PTEPE_PTEPE0_MASK               1
#define PTEPE_PTEPE1_MASK               2
#define PTEPE_PTEPE2_MASK               4
#define PTEPE_PTEPE3_MASK               8
#define PTEPE_PTEPE4_MASK               16
#define PTEPE_PTEPE5_MASK               32
#define PTEPE_PTEPE6_MASK               64
#define PTEPE_PTEPE7_MASK               128


/*** PTESE - Port E Slew Rate Enable Register; 0x000018F1 ***/
typedef union {
  byte Byte;
  struct {
    byte PTESE0      :1;                                       /* Output Slew Rate Enable for Port E Bit 0 */
    byte PTESE1      :1;                                       /* Output Slew Rate Enable for Port E Bit 1 */
    byte PTESE2      :1;                                       /* Output Slew Rate Enable for Port E Bit 2 */
    byte PTESE3      :1;                                       /* Output Slew Rate Enable for Port E Bit 3 */
    byte PTESE4      :1;                                       /* Output Slew Rate Enable for Port E Bit 4 */
    byte PTESE5      :1;                                       /* Output Slew Rate Enable for Port E Bit 5 */
    byte PTESE6      :1;                                       /* Output Slew Rate Enable for Port E Bit 6 */
    byte PTESE7      :1;                                       /* Output Slew Rate Enable for Port E Bit 7 */
  } Bits;
} PTESESTR;
extern volatile PTESESTR _PTESE @0x000018F1;
#define PTESE                           _PTESE.Byte
#define PTESE_PTESE0                    _PTESE.Bits.PTESE0
#define PTESE_PTESE1                    _PTESE.Bits.PTESE1
#define PTESE_PTESE2                    _PTESE.Bits.PTESE2
#define PTESE_PTESE3                    _PTESE.Bits.PTESE3
#define PTESE_PTESE4                    _PTESE.Bits.PTESE4
#define PTESE_PTESE5                    _PTESE.Bits.PTESE5
#define PTESE_PTESE6                    _PTESE.Bits.PTESE6
#define PTESE_PTESE7                    _PTESE.Bits.PTESE7

#define PTESE_PTESE0_MASK               1
#define PTESE_PTESE1_MASK               2
#define PTESE_PTESE2_MASK               4
#define PTESE_PTESE3_MASK               8
#define PTESE_PTESE4_MASK               16
#define PTESE_PTESE5_MASK               32
#define PTESE_PTESE6_MASK               64
#define PTESE_PTESE7_MASK               128


/*** PTEDS - Port E Drive Strength Selection Register; 0x000018F2 ***/
typedef union {
  byte Byte;
  struct {
    byte PTEDS0      :1;                                       /* Output Drive Strength Selection for Port E Bit 0 */
    byte PTEDS1      :1;                                       /* Output Drive Strength Selection for Port E Bit 1 */
    byte PTEDS2      :1;                                       /* Output Drive Strength Selection for Port E Bit 2 */
    byte PTEDS3      :1;                                       /* Output Drive Strength Selection for Port E Bit 3 */
    byte PTEDS4      :1;                                       /* Output Drive Strength Selection for Port E Bit 4 */
    byte PTEDS5      :1;                                       /* Output Drive Strength Selection for Port E Bit 5 */
    byte PTEDS6      :1;                                       /* Output Drive Strength Selection for Port E Bit 6 */
    byte PTEDS7      :1;                                       /* Output Drive Strength Selection for Port E Bit 7 */
  } Bits;
} PTEDSSTR;
extern volatile PTEDSSTR _PTEDS @0x000018F2;
#define PTEDS                           _PTEDS.Byte
#define PTEDS_PTEDS0                    _PTEDS.Bits.PTEDS0
#define PTEDS_PTEDS1                    _PTEDS.Bits.PTEDS1
#define PTEDS_PTEDS2                    _PTEDS.Bits.PTEDS2
#define PTEDS_PTEDS3                    _PTEDS.Bits.PTEDS3
#define PTEDS_PTEDS4                    _PTEDS.Bits.PTEDS4
#define PTEDS_PTEDS5                    _PTEDS.Bits.PTEDS5
#define PTEDS_PTEDS6                    _PTEDS.Bits.PTEDS6
#define PTEDS_PTEDS7                    _PTEDS.Bits.PTEDS7

#define PTEDS_PTEDS0_MASK               1
#define PTEDS_PTEDS1_MASK               2
#define PTEDS_PTEDS2_MASK               4
#define PTEDS_PTEDS3_MASK               8
#define PTEDS_PTEDS4_MASK               16
#define PTEDS_PTEDS5_MASK               32
#define PTEDS_PTEDS6_MASK               64
#define PTEDS_PTEDS7_MASK               128


/*** PTEIFE - Port E Input Filter Enable Register; 0x000018F3 ***/
typedef union {
  byte Byte;
  struct {
    byte PTEIFE0     :1;                                       /* Port E Input Filter Enable Bit 0 */
    byte PTEIFE1     :1;                                       /* Port E Input Filter Enable Bit 1 */
    byte PTEIFE2     :1;                                       /* Port E Input Filter Enable Bit 2 */
    byte PTEIFE3     :1;                                       /* Port E Input Filter Enable Bit 3 */
    byte PTEIFE4     :1;                                       /* Port E Input Filter Enable Bit 4 */
    byte PTEIFE5     :1;                                       /* Port E Input Filter Enable Bit 5 */
    byte PTEIFE6     :1;                                       /* Port E Input Filter Enable Bit 6 */
    byte PTEIFE7     :1;                                       /* Port E Input Filter Enable Bit 7 */
  } Bits;
} PTEIFESTR;
extern volatile PTEIFESTR _PTEIFE @0x000018F3;
#define PTEIFE                          _PTEIFE.Byte
#define PTEIFE_PTEIFE0                  _PTEIFE.Bits.PTEIFE0
#define PTEIFE_PTEIFE1                  _PTEIFE.Bits.PTEIFE1
#define PTEIFE_PTEIFE2                  _PTEIFE.Bits.PTEIFE2
#define PTEIFE_PTEIFE3                  _PTEIFE.Bits.PTEIFE3
#define PTEIFE_PTEIFE4                  _PTEIFE.Bits.PTEIFE4
#define PTEIFE_PTEIFE5                  _PTEIFE.Bits.PTEIFE5
#define PTEIFE_PTEIFE6                  _PTEIFE.Bits.PTEIFE6
#define PTEIFE_PTEIFE7                  _PTEIFE.Bits.PTEIFE7

#define PTEIFE_PTEIFE0_MASK             1
#define PTEIFE_PTEIFE1_MASK             2
#define PTEIFE_PTEIFE2_MASK             4
#define PTEIFE_PTEIFE3_MASK             8
#define PTEIFE_PTEIFE4_MASK             16
#define PTEIFE_PTEIFE5_MASK             32
#define PTEIFE_PTEIFE6_MASK             64
#define PTEIFE_PTEIFE7_MASK             128


/*** PTFPE - Port F Pull Enable Register; 0x000018F4 ***/
typedef union {
  byte Byte;
  struct {
    byte PTFPE0      :1;                                       /* Internal Pull Enable for Port F Bit 0 */
    byte PTFPE1      :1;                                       /* Internal Pull Enable for Port F Bit 1 */
    byte PTFPE2      :1;                                       /* Internal Pull Enable for Port F Bit 2 */
    byte PTFPE3      :1;                                       /* Internal Pull Enable for Port F Bit 3 */
    byte PTFPE4      :1;                                       /* Internal Pull Enable for Port F Bit 4 */
    byte PTFPE5      :1;                                       /* Internal Pull Enable for Port F Bit 5 */
    byte PTFPE6      :1;                                       /* Internal Pull Enable for Port F Bit 6 */
    byte PTFPE7      :1;                                       /* Internal Pull Enable for Port F Bit 7 */
  } Bits;
} PTFPESTR;
extern volatile PTFPESTR _PTFPE @0x000018F4;
#define PTFPE                           _PTFPE.Byte
#define PTFPE_PTFPE0                    _PTFPE.Bits.PTFPE0
#define PTFPE_PTFPE1                    _PTFPE.Bits.PTFPE1
#define PTFPE_PTFPE2                    _PTFPE.Bits.PTFPE2
#define PTFPE_PTFPE3                    _PTFPE.Bits.PTFPE3
#define PTFPE_PTFPE4                    _PTFPE.Bits.PTFPE4
#define PTFPE_PTFPE5                    _PTFPE.Bits.PTFPE5
#define PTFPE_PTFPE6                    _PTFPE.Bits.PTFPE6
#define PTFPE_PTFPE7                    _PTFPE.Bits.PTFPE7

#define PTFPE_PTFPE0_MASK               1
#define PTFPE_PTFPE1_MASK               2
#define PTFPE_PTFPE2_MASK               4
#define PTFPE_PTFPE3_MASK               8
#define PTFPE_PTFPE4_MASK               16
#define PTFPE_PTFPE5_MASK               32
#define PTFPE_PTFPE6_MASK               64
#define PTFPE_PTFPE7_MASK               128


/*** PTFSE - Port F Slew Rate Enable Register; 0x000018F5 ***/
typedef union {
  byte Byte;
  struct {
    byte PTFSE0      :1;                                       /* Output Slew Rate Enable for Port F Bit 0 */
    byte PTFSE1      :1;                                       /* Output Slew Rate Enable for Port F Bit 1 */
    byte PTFSE2      :1;                                       /* Output Slew Rate Enable for Port F Bit 2 */
    byte PTFSE3      :1;                                       /* Output Slew Rate Enable for Port F Bit 3 */
    byte PTFSE4      :1;                                       /* Output Slew Rate Enable for Port F Bit 4 */
    byte PTFSE5      :1;                                       /* Output Slew Rate Enable for Port F Bit 5 */
    byte PTFSE6      :1;                                       /* Output Slew Rate Enable for Port F Bit 6 */
    byte PTFSE7      :1;                                       /* Output Slew Rate Enable for Port F Bit 7 */
  } Bits;
} PTFSESTR;
extern volatile PTFSESTR _PTFSE @0x000018F5;
#define PTFSE                           _PTFSE.Byte
#define PTFSE_PTFSE0                    _PTFSE.Bits.PTFSE0
#define PTFSE_PTFSE1                    _PTFSE.Bits.PTFSE1
#define PTFSE_PTFSE2                    _PTFSE.Bits.PTFSE2
#define PTFSE_PTFSE3                    _PTFSE.Bits.PTFSE3
#define PTFSE_PTFSE4                    _PTFSE.Bits.PTFSE4
#define PTFSE_PTFSE5                    _PTFSE.Bits.PTFSE5
#define PTFSE_PTFSE6                    _PTFSE.Bits.PTFSE6
#define PTFSE_PTFSE7                    _PTFSE.Bits.PTFSE7

#define PTFSE_PTFSE0_MASK               1
#define PTFSE_PTFSE1_MASK               2
#define PTFSE_PTFSE2_MASK               4
#define PTFSE_PTFSE3_MASK               8
#define PTFSE_PTFSE4_MASK               16
#define PTFSE_PTFSE5_MASK               32
#define PTFSE_PTFSE6_MASK               64
#define PTFSE_PTFSE7_MASK               128


/*** PTFDS - Port F Drive Strength Selection Register; 0x000018F6 ***/
typedef union {
  byte Byte;
  struct {
    byte PTFDS0      :1;                                       /* Output Drive Strength Selection for Port F Bit 0 */
    byte PTFDS1      :1;                                       /* Output Drive Strength Selection for Port F Bit 1 */
    byte PTFDS2      :1;                                       /* Output Drive Strength Selection for Port F Bit 2 */
    byte PTFDS3      :1;                                       /* Output Drive Strength Selection for Port F Bit 3 */
    byte PTFDS4      :1;                                       /* Output Drive Strength Selection for Port F Bit 4 */
    byte PTFDS5      :1;                                       /* Output Drive Strength Selection for Port F Bit 5 */
    byte PTFDS6      :1;                                       /* Output Drive Strength Selection for Port F Bit 6 */
    byte PTFDS7      :1;                                       /* Output Drive Strength Selection for Port F Bit 7 */
  } Bits;
} PTFDSSTR;
extern volatile PTFDSSTR _PTFDS @0x000018F6;
#define PTFDS                           _PTFDS.Byte
#define PTFDS_PTFDS0                    _PTFDS.Bits.PTFDS0
#define PTFDS_PTFDS1                    _PTFDS.Bits.PTFDS1
#define PTFDS_PTFDS2                    _PTFDS.Bits.PTFDS2
#define PTFDS_PTFDS3                    _PTFDS.Bits.PTFDS3
#define PTFDS_PTFDS4                    _PTFDS.Bits.PTFDS4
#define PTFDS_PTFDS5                    _PTFDS.Bits.PTFDS5
#define PTFDS_PTFDS6                    _PTFDS.Bits.PTFDS6
#define PTFDS_PTFDS7                    _PTFDS.Bits.PTFDS7

#define PTFDS_PTFDS0_MASK               1
#define PTFDS_PTFDS1_MASK               2
#define PTFDS_PTFDS2_MASK               4
#define PTFDS_PTFDS3_MASK               8
#define PTFDS_PTFDS4_MASK               16
#define PTFDS_PTFDS5_MASK               32
#define PTFDS_PTFDS6_MASK               64
#define PTFDS_PTFDS7_MASK               128


/*** PTFIFE - Port F Input Filter Enable Register; 0x000018F7 ***/
typedef union {
  byte Byte;
  struct {
    byte PTFIFE0     :1;                                       /* Port F Input Filter Enable Bit 0 */
    byte PTFIFE1     :1;                                       /* Port F Input Filter Enable Bit 1 */
    byte PTFIFE2     :1;                                       /* Port F Input Filter Enable Bit 2 */
    byte PTFIFE3     :1;                                       /* Port F Input Filter Enable Bit 3 */
    byte PTFIFE4     :1;                                       /* Port F Input Filter Enable Bit 4 */
    byte PTFIFE5     :1;                                       /* Port F Input Filter Enable Bit 5 */
    byte PTFIFE6     :1;                                       /* Port F Input Filter Enable Bit 6 */
    byte PTFIFE7     :1;                                       /* Port F Input Filter Enable Bit 7 */
  } Bits;
} PTFIFESTR;
extern volatile PTFIFESTR _PTFIFE @0x000018F7;
#define PTFIFE                          _PTFIFE.Byte
#define PTFIFE_PTFIFE0                  _PTFIFE.Bits.PTFIFE0
#define PTFIFE_PTFIFE1                  _PTFIFE.Bits.PTFIFE1
#define PTFIFE_PTFIFE2                  _PTFIFE.Bits.PTFIFE2
#define PTFIFE_PTFIFE3                  _PTFIFE.Bits.PTFIFE3
#define PTFIFE_PTFIFE4                  _PTFIFE.Bits.PTFIFE4
#define PTFIFE_PTFIFE5                  _PTFIFE.Bits.PTFIFE5
#define PTFIFE_PTFIFE6                  _PTFIFE.Bits.PTFIFE6
#define PTFIFE_PTFIFE7                  _PTFIFE.Bits.PTFIFE7

#define PTFIFE_PTFIFE0_MASK             1
#define PTFIFE_PTFIFE1_MASK             2
#define PTFIFE_PTFIFE2_MASK             4
#define PTFIFE_PTFIFE3_MASK             8
#define PTFIFE_PTFIFE4_MASK             16
#define PTFIFE_PTFIFE5_MASK             32
#define PTFIFE_PTFIFE6_MASK             64
#define PTFIFE_PTFIFE7_MASK             128


/*** PTGPE - Port G Pull Enable Register; 0x000018F8 ***/
typedef union {
  byte Byte;
  struct {
    byte PTGPE0      :1;                                       /* Internal Pull Enable for Port G Bit 0 */
    byte PTGPE1      :1;                                       /* Internal Pull Enable for Port G Bit 1 */
    byte PTGPE2      :1;                                       /* Internal Pull Enable for Port G Bit 2 */
    byte PTGPE3      :1;                                       /* Internal Pull Enable for Port G Bit 3 */
    byte PTGPE4      :1;                                       /* Internal Pull Enable for Port G Bit 4 */
    byte PTGPE5      :1;                                       /* Internal Pull Enable for Port G Bit 5 */
    byte PTGPE6      :1;                                       /* Internal Pull Enable for Port G Bit 6 */
    byte PTGPE7      :1;                                       /* Internal Pull Enable for Port G Bit 7 */
  } Bits;
} PTGPESTR;
extern volatile PTGPESTR _PTGPE @0x000018F8;
#define PTGPE                           _PTGPE.Byte
#define PTGPE_PTGPE0                    _PTGPE.Bits.PTGPE0
#define PTGPE_PTGPE1                    _PTGPE.Bits.PTGPE1
#define PTGPE_PTGPE2                    _PTGPE.Bits.PTGPE2
#define PTGPE_PTGPE3                    _PTGPE.Bits.PTGPE3
#define PTGPE_PTGPE4                    _PTGPE.Bits.PTGPE4
#define PTGPE_PTGPE5                    _PTGPE.Bits.PTGPE5
#define PTGPE_PTGPE6                    _PTGPE.Bits.PTGPE6
#define PTGPE_PTGPE7                    _PTGPE.Bits.PTGPE7

#define PTGPE_PTGPE0_MASK               1
#define PTGPE_PTGPE1_MASK               2
#define PTGPE_PTGPE2_MASK               4
#define PTGPE_PTGPE3_MASK               8
#define PTGPE_PTGPE4_MASK               16
#define PTGPE_PTGPE5_MASK               32
#define PTGPE_PTGPE6_MASK               64
#define PTGPE_PTGPE7_MASK               128


/*** PTGSE - Port G Slew Rate Enable Register; 0x000018F9 ***/
typedef union {
  byte Byte;
  struct {
    byte PTGSE0      :1;                                       /* Output Slew Rate Enable for Port G Bit 0 */
    byte PTGSE1      :1;                                       /* Output Slew Rate Enable for Port G Bit 1 */
    byte PTGSE2      :1;                                       /* Output Slew Rate Enable for Port G Bit 2 */
    byte PTGSE3      :1;                                       /* Output Slew Rate Enable for Port G Bit 3 */
    byte PTGSE4      :1;                                       /* Output Slew Rate Enable for Port G Bit 4 */
    byte PTGSE5      :1;                                       /* Output Slew Rate Enable for Port G Bit 5 */
    byte PTGSE6      :1;                                       /* Output Slew Rate Enable for Port G Bit 6 */
    byte PTGSE7      :1;                                       /* Output Slew Rate Enable for Port G Bit 7 */
  } Bits;
} PTGSESTR;
extern volatile PTGSESTR _PTGSE @0x000018F9;
#define PTGSE                           _PTGSE.Byte
#define PTGSE_PTGSE0                    _PTGSE.Bits.PTGSE0
#define PTGSE_PTGSE1                    _PTGSE.Bits.PTGSE1
#define PTGSE_PTGSE2                    _PTGSE.Bits.PTGSE2
#define PTGSE_PTGSE3                    _PTGSE.Bits.PTGSE3
#define PTGSE_PTGSE4                    _PTGSE.Bits.PTGSE4
#define PTGSE_PTGSE5                    _PTGSE.Bits.PTGSE5
#define PTGSE_PTGSE6                    _PTGSE.Bits.PTGSE6
#define PTGSE_PTGSE7                    _PTGSE.Bits.PTGSE7

#define PTGSE_PTGSE0_MASK               1
#define PTGSE_PTGSE1_MASK               2
#define PTGSE_PTGSE2_MASK               4
#define PTGSE_PTGSE3_MASK               8
#define PTGSE_PTGSE4_MASK               16
#define PTGSE_PTGSE5_MASK               32
#define PTGSE_PTGSE6_MASK               64
#define PTGSE_PTGSE7_MASK               128


/*** PTGDS - Port G Drive Strength Selection Register; 0x000018FA ***/
typedef union {
  byte Byte;
  struct {
    byte PTGDS0      :1;                                       /* Output Drive Strength Selection for Port G Bit 0 */
    byte PTGDS1      :1;                                       /* Output Drive Strength Selection for Port G Bit 1 */
    byte PTGDS2      :1;                                       /* Output Drive Strength Selection for Port G Bit 2 */
    byte PTGDS3      :1;                                       /* Output Drive Strength Selection for Port G Bit 3 */
    byte PTGDS4      :1;                                       /* Output Drive Strength Selection for Port G Bit 4 */
    byte PTGDS5      :1;                                       /* Output Drive Strength Selection for Port G Bit 5 */
    byte PTGDS6      :1;                                       /* Output Drive Strength Selection for Port G Bit 6 */
    byte PTGDS7      :1;                                       /* Output Drive Strength Selection for Port G Bit 7 */
  } Bits;
} PTGDSSTR;
extern volatile PTGDSSTR _PTGDS @0x000018FA;
#define PTGDS                           _PTGDS.Byte
#define PTGDS_PTGDS0                    _PTGDS.Bits.PTGDS0
#define PTGDS_PTGDS1                    _PTGDS.Bits.PTGDS1
#define PTGDS_PTGDS2                    _PTGDS.Bits.PTGDS2
#define PTGDS_PTGDS3                    _PTGDS.Bits.PTGDS3
#define PTGDS_PTGDS4                    _PTGDS.Bits.PTGDS4
#define PTGDS_PTGDS5                    _PTGDS.Bits.PTGDS5
#define PTGDS_PTGDS6                    _PTGDS.Bits.PTGDS6
#define PTGDS_PTGDS7                    _PTGDS.Bits.PTGDS7

#define PTGDS_PTGDS0_MASK               1
#define PTGDS_PTGDS1_MASK               2
#define PTGDS_PTGDS2_MASK               4
#define PTGDS_PTGDS3_MASK               8
#define PTGDS_PTGDS4_MASK               16
#define PTGDS_PTGDS5_MASK               32
#define PTGDS_PTGDS6_MASK               64
#define PTGDS_PTGDS7_MASK               128


/*** PTGIFE - Port G Input Filter Enable Register; 0x000018FB ***/
typedef union {
  byte Byte;
  struct {
    byte PTGIFE0     :1;                                       /* Port G Input Filter Enable Bit 0 */
    byte PTGIFE1     :1;                                       /* Port G Input Filter Enable Bit 1 */
    byte PTGIFE2     :1;                                       /* Port G Input Filter Enable Bit 2 */
    byte PTGIFE3     :1;                                       /* Port G Input Filter Enable Bit 3 */
    byte PTGIFE4     :1;                                       /* Port G Input Filter Enable Bit 4 */
    byte PTGIFE5     :1;                                       /* Port G Input Filter Enable Bit 5 */
    byte PTGIFE6     :1;                                       /* Port G Input Filter Enable Bit 6 */
    byte PTGIFE7     :1;                                       /* Port G Input Filter Enable Bit 7 */
  } Bits;
} PTGIFESTR;
extern volatile PTGIFESTR _PTGIFE @0x000018FB;
#define PTGIFE                          _PTGIFE.Byte
#define PTGIFE_PTGIFE0                  _PTGIFE.Bits.PTGIFE0
#define PTGIFE_PTGIFE1                  _PTGIFE.Bits.PTGIFE1
#define PTGIFE_PTGIFE2                  _PTGIFE.Bits.PTGIFE2
#define PTGIFE_PTGIFE3                  _PTGIFE.Bits.PTGIFE3
#define PTGIFE_PTGIFE4                  _PTGIFE.Bits.PTGIFE4
#define PTGIFE_PTGIFE5                  _PTGIFE.Bits.PTGIFE5
#define PTGIFE_PTGIFE6                  _PTGIFE.Bits.PTGIFE6
#define PTGIFE_PTGIFE7                  _PTGIFE.Bits.PTGIFE7

#define PTGIFE_PTGIFE0_MASK             1
#define PTGIFE_PTGIFE1_MASK             2
#define PTGIFE_PTGIFE2_MASK             4
#define PTGIFE_PTGIFE3_MASK             8
#define PTGIFE_PTGIFE4_MASK             16
#define PTGIFE_PTGIFE5_MASK             32
#define PTGIFE_PTGIFE6_MASK             64
#define PTGIFE_PTGIFE7_MASK             128


/*** PTHPE - Port H Pull Enable Register; 0x000018FC ***/
typedef union {
  byte Byte;
  struct {
    byte PTHPE0      :1;                                       /* Internal Pull Enable for Port H Bit 0 */
    byte PTHPE1      :1;                                       /* Internal Pull Enable for Port H Bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTHPE :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTHPESTR;
extern volatile PTHPESTR _PTHPE @0x000018FC;
#define PTHPE                           _PTHPE.Byte
#define PTHPE_PTHPE0                    _PTHPE.Bits.PTHPE0
#define PTHPE_PTHPE1                    _PTHPE.Bits.PTHPE1
#define PTHPE_PTHPE                     _PTHPE.MergedBits.grpPTHPE

#define PTHPE_PTHPE0_MASK               1
#define PTHPE_PTHPE1_MASK               2
#define PTHPE_PTHPE_MASK                3
#define PTHPE_PTHPE_BITNUM              0


/*** PTHSE - Port H Slew Rate Enable Register; 0x000018FD ***/
typedef union {
  byte Byte;
  struct {
    byte PTHSE0      :1;                                       /* Output Slew Rate Enable for Port H Bit 0 */
    byte PTHSE1      :1;                                       /* Output Slew Rate Enable for Port H Bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTHSE :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTHSESTR;
extern volatile PTHSESTR _PTHSE @0x000018FD;
#define PTHSE                           _PTHSE.Byte
#define PTHSE_PTHSE0                    _PTHSE.Bits.PTHSE0
#define PTHSE_PTHSE1                    _PTHSE.Bits.PTHSE1
#define PTHSE_PTHSE                     _PTHSE.MergedBits.grpPTHSE

#define PTHSE_PTHSE0_MASK               1
#define PTHSE_PTHSE1_MASK               2
#define PTHSE_PTHSE_MASK                3
#define PTHSE_PTHSE_BITNUM              0


/*** PTHDS - Port H Drive Strength Selection Register; 0x000018FE ***/
typedef union {
  byte Byte;
  struct {
    byte PTHDS0      :1;                                       /* Output Drive Strength Selection for Port H Bit 0 */
    byte PTHDS1      :1;                                       /* Output Drive Strength Selection for Port H Bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTHDS :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTHDSSTR;
extern volatile PTHDSSTR _PTHDS @0x000018FE;
#define PTHDS                           _PTHDS.Byte
#define PTHDS_PTHDS0                    _PTHDS.Bits.PTHDS0
#define PTHDS_PTHDS1                    _PTHDS.Bits.PTHDS1
#define PTHDS_PTHDS                     _PTHDS.MergedBits.grpPTHDS

#define PTHDS_PTHDS0_MASK               1
#define PTHDS_PTHDS1_MASK               2
#define PTHDS_PTHDS_MASK                3
#define PTHDS_PTHDS_BITNUM              0


/*** PTHIFE - Port H Input Filter Enable Register; 0x000018FF ***/
typedef union {
  byte Byte;
  struct {
    byte PTHIFE0     :1;                                       /* Port H Input Filter Enable Bit 0 */
    byte PTHIFE1     :1;                                       /* Port H Input Filter Enable Bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpPTHIFE :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTHIFESTR;
extern volatile PTHIFESTR _PTHIFE @0x000018FF;
#define PTHIFE                          _PTHIFE.Byte
#define PTHIFE_PTHIFE0                  _PTHIFE.Bits.PTHIFE0
#define PTHIFE_PTHIFE1                  _PTHIFE.Bits.PTHIFE1
#define PTHIFE_PTHIFE                   _PTHIFE.MergedBits.grpPTHIFE

#define PTHIFE_PTHIFE0_MASK             1
#define PTHIFE_PTHIFE1_MASK             2
#define PTHIFE_PTHIFE_MASK              3
#define PTHIFE_PTHIFE_BITNUM            0


/*** ADC1CV1 - Compare Value 1 Register; 0x00001900 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ADC1CV1H - Compare Value 1 High Register; 0x00001900 ***/
    union {
      byte Byte;
      struct {
        byte CV18        :1;                                       /* Compare Function Value 8 */
        byte CV19        :1;                                       /* Compare Function Value 9 */
        byte CV110       :1;                                       /* Compare Function Value 10 */
        byte CV111       :1;                                       /* Compare Function Value 11 */
        byte CV112       :1;                                       /* Compare Function Value 12 */
        byte CV113       :1;                                       /* Compare Function Value 13 */
        byte CV114       :1;                                       /* Compare Function Value 14 */
        byte CV115       :1;                                       /* Compare Function Value 15 */
      } Bits;
      struct {
        byte grpCV_18 :2;
        byte grpCV1_10 :6;
      } MergedBits;
    } ADC1CV1HSTR;
    #define ADC1CV1H                    _ADC1CV1.Overlap_STR.ADC1CV1HSTR.Byte
    #define ADC1CV1H_CV18               _ADC1CV1.Overlap_STR.ADC1CV1HSTR.Bits.CV18
    #define ADC1CV1H_CV19               _ADC1CV1.Overlap_STR.ADC1CV1HSTR.Bits.CV19
    #define ADC1CV1H_CV110              _ADC1CV1.Overlap_STR.ADC1CV1HSTR.Bits.CV110
    #define ADC1CV1H_CV111              _ADC1CV1.Overlap_STR.ADC1CV1HSTR.Bits.CV111
    #define ADC1CV1H_CV112              _ADC1CV1.Overlap_STR.ADC1CV1HSTR.Bits.CV112
    #define ADC1CV1H_CV113              _ADC1CV1.Overlap_STR.ADC1CV1HSTR.Bits.CV113
    #define ADC1CV1H_CV114              _ADC1CV1.Overlap_STR.ADC1CV1HSTR.Bits.CV114
    #define ADC1CV1H_CV115              _ADC1CV1.Overlap_STR.ADC1CV1HSTR.Bits.CV115
    #define ADC1CV1H_CV_18              _ADC1CV1.Overlap_STR.ADC1CV1HSTR.MergedBits.grpCV_18
    #define ADC1CV1H_CV1_10             _ADC1CV1.Overlap_STR.ADC1CV1HSTR.MergedBits.grpCV1_10
    #define ADC1CV1H_CV                 ADC1CV1H_CV_18
    #define ADC1CV1H_CV1                ADC1CV1H_CV1_10
    
    #define ADC1CV1H_CV18_MASK          1
    #define ADC1CV1H_CV19_MASK          2
    #define ADC1CV1H_CV110_MASK         4
    #define ADC1CV1H_CV111_MASK         8
    #define ADC1CV1H_CV112_MASK         16
    #define ADC1CV1H_CV113_MASK         32
    #define ADC1CV1H_CV114_MASK         64
    #define ADC1CV1H_CV115_MASK         128
    #define ADC1CV1H_CV_18_MASK         3
    #define ADC1CV1H_CV_18_BITNUM       0
    #define ADC1CV1H_CV1_10_MASK        252
    #define ADC1CV1H_CV1_10_BITNUM      2
    

    /*** ADC1CV1L - Compare Value 1 Low Register; 0x00001901 ***/
    union {
      byte Byte;
      struct {
        byte CV10        :1;                                       /* Compare Function Value 0 */
        byte CV11        :1;                                       /* Compare Function Value 1 */
        byte CV12        :1;                                       /* Compare Function Value 2 */
        byte CV13        :1;                                       /* Compare Function Value 3 */
        byte CV14        :1;                                       /* Compare Function Value 4 */
        byte CV15        :1;                                       /* Compare Function Value 5 */
        byte CV16        :1;                                       /* Compare Function Value 6 */
        byte CV17        :1;                                       /* Compare Function Value 7 */
      } Bits;
    } ADC1CV1LSTR;
    #define ADC1CV1L                    _ADC1CV1.Overlap_STR.ADC1CV1LSTR.Byte
    #define ADC1CV1L_CV10               _ADC1CV1.Overlap_STR.ADC1CV1LSTR.Bits.CV10
    #define ADC1CV1L_CV11               _ADC1CV1.Overlap_STR.ADC1CV1LSTR.Bits.CV11
    #define ADC1CV1L_CV12               _ADC1CV1.Overlap_STR.ADC1CV1LSTR.Bits.CV12
    #define ADC1CV1L_CV13               _ADC1CV1.Overlap_STR.ADC1CV1LSTR.Bits.CV13
    #define ADC1CV1L_CV14               _ADC1CV1.Overlap_STR.ADC1CV1LSTR.Bits.CV14
    #define ADC1CV1L_CV15               _ADC1CV1.Overlap_STR.ADC1CV1LSTR.Bits.CV15
    #define ADC1CV1L_CV16               _ADC1CV1.Overlap_STR.ADC1CV1LSTR.Bits.CV16
    #define ADC1CV1L_CV17               _ADC1CV1.Overlap_STR.ADC1CV1LSTR.Bits.CV17
    
    #define ADC1CV1L_CV10_MASK          1
    #define ADC1CV1L_CV11_MASK          2
    #define ADC1CV1L_CV12_MASK          4
    #define ADC1CV1L_CV13_MASK          8
    #define ADC1CV1L_CV14_MASK          16
    #define ADC1CV1L_CV15_MASK          32
    #define ADC1CV1L_CV16_MASK          64
    #define ADC1CV1L_CV17_MASK          128
    
  } Overlap_STR;

} ADC1CV1STR;
extern volatile ADC1CV1STR _ADC1CV1 @0x00001900;
#define ADC1CV1                         _ADC1CV1.Word


/*** ADC1CV2 - Compare Value 2 Register; 0x00001902 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ADC1CV2H - Compare Value 2 High Register; 0x00001902 ***/
    union {
      byte Byte;
      struct {
        byte CV28        :1;                                       /* Compare Function Value 8 */
        byte CV29        :1;                                       /* Compare Function Value 9 */
        byte CV210       :1;                                       /* Compare Function Value 10 */
        byte CV211       :1;                                       /* Compare Function Value 11 */
        byte CV212       :1;                                       /* Compare Function Value 12 */
        byte CV213       :1;                                       /* Compare Function Value 13 */
        byte CV214       :1;                                       /* Compare Function Value 14 */
        byte CV215       :1;                                       /* Compare Function Value 15 */
      } Bits;
      struct {
        byte grpCV_28 :2;
        byte grpCV2_10 :6;
      } MergedBits;
    } ADC1CV2HSTR;
    #define ADC1CV2H                    _ADC1CV2.Overlap_STR.ADC1CV2HSTR.Byte
    #define ADC1CV2H_CV28               _ADC1CV2.Overlap_STR.ADC1CV2HSTR.Bits.CV28
    #define ADC1CV2H_CV29               _ADC1CV2.Overlap_STR.ADC1CV2HSTR.Bits.CV29
    #define ADC1CV2H_CV210              _ADC1CV2.Overlap_STR.ADC1CV2HSTR.Bits.CV210
    #define ADC1CV2H_CV211              _ADC1CV2.Overlap_STR.ADC1CV2HSTR.Bits.CV211
    #define ADC1CV2H_CV212              _ADC1CV2.Overlap_STR.ADC1CV2HSTR.Bits.CV212
    #define ADC1CV2H_CV213              _ADC1CV2.Overlap_STR.ADC1CV2HSTR.Bits.CV213
    #define ADC1CV2H_CV214              _ADC1CV2.Overlap_STR.ADC1CV2HSTR.Bits.CV214
    #define ADC1CV2H_CV215              _ADC1CV2.Overlap_STR.ADC1CV2HSTR.Bits.CV215
    #define ADC1CV2H_CV_28              _ADC1CV2.Overlap_STR.ADC1CV2HSTR.MergedBits.grpCV_28
    #define ADC1CV2H_CV2_10             _ADC1CV2.Overlap_STR.ADC1CV2HSTR.MergedBits.grpCV2_10
    #define ADC1CV2H_CV                 ADC1CV2H_CV_28
    #define ADC1CV2H_CV2                ADC1CV2H_CV2_10
    
    #define ADC1CV2H_CV28_MASK          1
    #define ADC1CV2H_CV29_MASK          2
    #define ADC1CV2H_CV210_MASK         4
    #define ADC1CV2H_CV211_MASK         8
    #define ADC1CV2H_CV212_MASK         16
    #define ADC1CV2H_CV213_MASK         32
    #define ADC1CV2H_CV214_MASK         64
    #define ADC1CV2H_CV215_MASK         128
    #define ADC1CV2H_CV_28_MASK         3
    #define ADC1CV2H_CV_28_BITNUM       0
    #define ADC1CV2H_CV2_10_MASK        252
    #define ADC1CV2H_CV2_10_BITNUM      2
    

    /*** ADC1CV2L - Compare Value 2 Low Register; 0x00001903 ***/
    union {
      byte Byte;
      struct {
        byte CV20        :1;                                       /* Compare Function Value 0 */
        byte CV21        :1;                                       /* Compare Function Value 1 */
        byte CV22        :1;                                       /* Compare Function Value 2 */
        byte CV23        :1;                                       /* Compare Function Value 3 */
        byte CV24        :1;                                       /* Compare Function Value 4 */
        byte CV25        :1;                                       /* Compare Function Value 5 */
        byte CV26        :1;                                       /* Compare Function Value 6 */
        byte CV27        :1;                                       /* Compare Function Value 7 */
      } Bits;
    } ADC1CV2LSTR;
    #define ADC1CV2L                    _ADC1CV2.Overlap_STR.ADC1CV2LSTR.Byte
    #define ADC1CV2L_CV20               _ADC1CV2.Overlap_STR.ADC1CV2LSTR.Bits.CV20
    #define ADC1CV2L_CV21               _ADC1CV2.Overlap_STR.ADC1CV2LSTR.Bits.CV21
    #define ADC1CV2L_CV22               _ADC1CV2.Overlap_STR.ADC1CV2LSTR.Bits.CV22
    #define ADC1CV2L_CV23               _ADC1CV2.Overlap_STR.ADC1CV2LSTR.Bits.CV23
    #define ADC1CV2L_CV24               _ADC1CV2.Overlap_STR.ADC1CV2LSTR.Bits.CV24
    #define ADC1CV2L_CV25               _ADC1CV2.Overlap_STR.ADC1CV2LSTR.Bits.CV25
    #define ADC1CV2L_CV26               _ADC1CV2.Overlap_STR.ADC1CV2LSTR.Bits.CV26
    #define ADC1CV2L_CV27               _ADC1CV2.Overlap_STR.ADC1CV2LSTR.Bits.CV27
    
    #define ADC1CV2L_CV20_MASK          1
    #define ADC1CV2L_CV21_MASK          2
    #define ADC1CV2L_CV22_MASK          4
    #define ADC1CV2L_CV23_MASK          8
    #define ADC1CV2L_CV24_MASK          16
    #define ADC1CV2L_CV25_MASK          32
    #define ADC1CV2L_CV26_MASK          64
    #define ADC1CV2L_CV27_MASK          128
    
  } Overlap_STR;

} ADC1CV2STR;
extern volatile ADC1CV2STR _ADC1CV2 @0x00001902;
#define ADC1CV2                         _ADC1CV2.Word


/*** ADC1SC2 - Status and Control Register 2; 0x00001904 ***/
typedef union {
  byte Byte;
  struct {
    byte REFSEL0     :1;                                       /* Voltage Reference Selection, bit 0 */
    byte REFSEL1     :1;                                       /* Voltage Reference Selection, bit 1 */
    byte             :1; 
    byte ACREN       :1;                                       /* Compare Function Range Enable */
    byte ACFGT       :1;                                       /* Compare Function Greater Than Enable */
    byte ACFE        :1;                                       /* Compare Function Enable - ACFE is used to enable the compare function */
    byte ADTRG       :1;                                       /* Conversion Trigger Select-ADTRG is used to select the type of trigger to be used for initiating a conversion */
    byte ADACT       :1;                                       /* Conversion Active - ADACT indicates that a conversion is in progress. ADACT is set when a conversion is initiated and cleared when a conversion is completed or aborted */
  } Bits;
  struct {
    byte grpREFSEL :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} ADC1SC2STR;
extern volatile ADC1SC2STR _ADC1SC2 @0x00001904;
#define ADC1SC2                         _ADC1SC2.Byte
#define ADC1SC2_REFSEL0                 _ADC1SC2.Bits.REFSEL0
#define ADC1SC2_REFSEL1                 _ADC1SC2.Bits.REFSEL1
#define ADC1SC2_ACREN                   _ADC1SC2.Bits.ACREN
#define ADC1SC2_ACFGT                   _ADC1SC2.Bits.ACFGT
#define ADC1SC2_ACFE                    _ADC1SC2.Bits.ACFE
#define ADC1SC2_ADTRG                   _ADC1SC2.Bits.ADTRG
#define ADC1SC2_ADACT                   _ADC1SC2.Bits.ADACT
#define ADC1SC2_REFSEL                  _ADC1SC2.MergedBits.grpREFSEL

#define ADC1SC2_REFSEL0_MASK            1
#define ADC1SC2_REFSEL1_MASK            2
#define ADC1SC2_ACREN_MASK              8
#define ADC1SC2_ACFGT_MASK              16
#define ADC1SC2_ACFE_MASK               32
#define ADC1SC2_ADTRG_MASK              64
#define ADC1SC2_ADACT_MASK              128
#define ADC1SC2_REFSEL_MASK             3
#define ADC1SC2_REFSEL_BITNUM           0


/*** ADC1SC3 - Status and Control Register 3; 0x00001905 ***/
typedef union {
  byte Byte;
  struct {
    byte AVGS0       :1;                                       /* Hardware Average select, bit 0 */
    byte AVGS1       :1;                                       /* Hardware Average select, bit 1 */
    byte AVGE        :1;                                       /* Hardware average enable - AVGE enables the hardware average function of the ADC */
    byte ADCO        :1;                                       /* Continuous Conversion Enable - ADCO enables continuous conversions */
    byte             :1; 
    byte             :1; 
    byte CALF        :1;                                       /* Calibration Failed Flag - CALF displays the result of the calibration sequence */
    byte CAL         :1;                                       /* Calibration - CAL begins the calibration sequence when set */
  } Bits;
  struct {
    byte grpAVGS :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} ADC1SC3STR;
extern volatile ADC1SC3STR _ADC1SC3 @0x00001905;
#define ADC1SC3                         _ADC1SC3.Byte
#define ADC1SC3_AVGS0                   _ADC1SC3.Bits.AVGS0
#define ADC1SC3_AVGS1                   _ADC1SC3.Bits.AVGS1
#define ADC1SC3_AVGE                    _ADC1SC3.Bits.AVGE
#define ADC1SC3_ADCO                    _ADC1SC3.Bits.ADCO
#define ADC1SC3_CALF                    _ADC1SC3.Bits.CALF
#define ADC1SC3_CAL                     _ADC1SC3.Bits.CAL
#define ADC1SC3_AVGS                    _ADC1SC3.MergedBits.grpAVGS

#define ADC1SC3_AVGS0_MASK              1
#define ADC1SC3_AVGS1_MASK              2
#define ADC1SC3_AVGE_MASK               4
#define ADC1SC3_ADCO_MASK               8
#define ADC1SC3_CALF_MASK               64
#define ADC1SC3_CAL_MASK                128
#define ADC1SC3_AVGS_MASK               3
#define ADC1SC3_AVGS_BITNUM             0


/*** ADC1OFS - Offset Correction Register; 0x00001906 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ADC1OFSH - Offset Correction High Register; 0x00001906 ***/
    union {
      byte Byte;
      struct {
        byte OFS8        :1;                                       /* Offset error correction value bit 8 */
        byte OFS9        :1;                                       /* Offset error correction value bit 9 */
        byte OFS10       :1;                                       /* Offset error correction value bit 10 */
        byte OFS11       :1;                                       /* Offset error correction value bit 11 */
        byte OFS12       :1;                                       /* Offset error correction value bit 12 */
        byte OFS13       :1;                                       /* Offset error correction value bit 13 */
        byte OFS14       :1;                                       /* Offset error correction value bit 14 */
        byte OFS15       :1;                                       /* Offset error correction value bit 15 */
      } Bits;
    } ADC1OFSHSTR;
    #define ADC1OFSH                    _ADC1OFS.Overlap_STR.ADC1OFSHSTR.Byte
    #define ADC1OFSH_OFS8               _ADC1OFS.Overlap_STR.ADC1OFSHSTR.Bits.OFS8
    #define ADC1OFSH_OFS9               _ADC1OFS.Overlap_STR.ADC1OFSHSTR.Bits.OFS9
    #define ADC1OFSH_OFS10              _ADC1OFS.Overlap_STR.ADC1OFSHSTR.Bits.OFS10
    #define ADC1OFSH_OFS11              _ADC1OFS.Overlap_STR.ADC1OFSHSTR.Bits.OFS11
    #define ADC1OFSH_OFS12              _ADC1OFS.Overlap_STR.ADC1OFSHSTR.Bits.OFS12
    #define ADC1OFSH_OFS13              _ADC1OFS.Overlap_STR.ADC1OFSHSTR.Bits.OFS13
    #define ADC1OFSH_OFS14              _ADC1OFS.Overlap_STR.ADC1OFSHSTR.Bits.OFS14
    #define ADC1OFSH_OFS15              _ADC1OFS.Overlap_STR.ADC1OFSHSTR.Bits.OFS15
    
    #define ADC1OFSH_OFS8_MASK          1
    #define ADC1OFSH_OFS9_MASK          2
    #define ADC1OFSH_OFS10_MASK         4
    #define ADC1OFSH_OFS11_MASK         8
    #define ADC1OFSH_OFS12_MASK         16
    #define ADC1OFSH_OFS13_MASK         32
    #define ADC1OFSH_OFS14_MASK         64
    #define ADC1OFSH_OFS15_MASK         128
    

    /*** ADC1OFSL - Offset Correction Low Register; 0x00001907 ***/
    union {
      byte Byte;
      struct {
        byte OFS0        :1;                                       /* Offset error correction value bit 0 */
        byte OFS1        :1;                                       /* Offset error correction value bit 1 */
        byte OFS2        :1;                                       /* Offset error correction value bit 2 */
        byte OFS3        :1;                                       /* Offset error correction value bit 3 */
        byte OFS4        :1;                                       /* Offset error correction value bit 4 */
        byte OFS5        :1;                                       /* Offset error correction value bit 5 */
        byte OFS6        :1;                                       /* Offset error correction value bit 6 */
        byte OFS7        :1;                                       /* Offset error correction value bit 7 */
      } Bits;
    } ADC1OFSLSTR;
    #define ADC1OFSL                    _ADC1OFS.Overlap_STR.ADC1OFSLSTR.Byte
    #define ADC1OFSL_OFS0               _ADC1OFS.Overlap_STR.ADC1OFSLSTR.Bits.OFS0
    #define ADC1OFSL_OFS1               _ADC1OFS.Overlap_STR.ADC1OFSLSTR.Bits.OFS1
    #define ADC1OFSL_OFS2               _ADC1OFS.Overlap_STR.ADC1OFSLSTR.Bits.OFS2
    #define ADC1OFSL_OFS3               _ADC1OFS.Overlap_STR.ADC1OFSLSTR.Bits.OFS3
    #define ADC1OFSL_OFS4               _ADC1OFS.Overlap_STR.ADC1OFSLSTR.Bits.OFS4
    #define ADC1OFSL_OFS5               _ADC1OFS.Overlap_STR.ADC1OFSLSTR.Bits.OFS5
    #define ADC1OFSL_OFS6               _ADC1OFS.Overlap_STR.ADC1OFSLSTR.Bits.OFS6
    #define ADC1OFSL_OFS7               _ADC1OFS.Overlap_STR.ADC1OFSLSTR.Bits.OFS7
    
    #define ADC1OFSL_OFS0_MASK          1
    #define ADC1OFSL_OFS1_MASK          2
    #define ADC1OFSL_OFS2_MASK          4
    #define ADC1OFSL_OFS3_MASK          8
    #define ADC1OFSL_OFS4_MASK          16
    #define ADC1OFSL_OFS5_MASK          32
    #define ADC1OFSL_OFS6_MASK          64
    #define ADC1OFSL_OFS7_MASK          128
    
  } Overlap_STR;

} ADC1OFSSTR;
extern volatile ADC1OFSSTR _ADC1OFS @0x00001906;
#define ADC1OFS                         _ADC1OFS.Word


/*** ADC1PG - Plus-Side Gain Register; 0x00001908 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ADC1PGH - Plus-Side Gain High Register; 0x00001908 ***/
    union {
      byte Byte;
      struct {
        byte PG8         :1;                                       /* Gain error correction for the plus-side input value bit 8 */
        byte PG9         :1;                                       /* Gain error correction for the plus-side input value bit 9 */
        byte PG10        :1;                                       /* Gain error correction for the plus-side input value bit 10 */
        byte PG11        :1;                                       /* Gain error correction for the plus-side input value bit 11 */
        byte PG12        :1;                                       /* Gain error correction for the plus-side input value bit 12 */
        byte PG13        :1;                                       /* Gain error correction for the plus-side input value bit 13 */
        byte PG14        :1;                                       /* Gain error correction for the plus-side input value bit 14 */
        byte PG15        :1;                                       /* Gain error correction for the plus-side input value bit 15 */
      } Bits;
    } ADC1PGHSTR;
    #define ADC1PGH                     _ADC1PG.Overlap_STR.ADC1PGHSTR.Byte
    #define ADC1PGH_PG8                 _ADC1PG.Overlap_STR.ADC1PGHSTR.Bits.PG8
    #define ADC1PGH_PG9                 _ADC1PG.Overlap_STR.ADC1PGHSTR.Bits.PG9
    #define ADC1PGH_PG10                _ADC1PG.Overlap_STR.ADC1PGHSTR.Bits.PG10
    #define ADC1PGH_PG11                _ADC1PG.Overlap_STR.ADC1PGHSTR.Bits.PG11
    #define ADC1PGH_PG12                _ADC1PG.Overlap_STR.ADC1PGHSTR.Bits.PG12
    #define ADC1PGH_PG13                _ADC1PG.Overlap_STR.ADC1PGHSTR.Bits.PG13
    #define ADC1PGH_PG14                _ADC1PG.Overlap_STR.ADC1PGHSTR.Bits.PG14
    #define ADC1PGH_PG15                _ADC1PG.Overlap_STR.ADC1PGHSTR.Bits.PG15
    
    #define ADC1PGH_PG8_MASK            1
    #define ADC1PGH_PG9_MASK            2
    #define ADC1PGH_PG10_MASK           4
    #define ADC1PGH_PG11_MASK           8
    #define ADC1PGH_PG12_MASK           16
    #define ADC1PGH_PG13_MASK           32
    #define ADC1PGH_PG14_MASK           64
    #define ADC1PGH_PG15_MASK           128
    

    /*** ADC1PGL - Plus-Side Gain Low Register; 0x00001909 ***/
    union {
      byte Byte;
      struct {
        byte PG0         :1;                                       /* Gain error correction for the plus-side input value bit 0 */
        byte PG1         :1;                                       /* Gain error correction for the plus-side input value bit 1 */
        byte PG2         :1;                                       /* Gain error correction for the plus-side input value bit 2 */
        byte PG3         :1;                                       /* Gain error correction for the plus-side input value bit 3 */
        byte PG4         :1;                                       /* Gain error correction for the plus-side input value bit 4 */
        byte PG5         :1;                                       /* Gain error correction for the plus-side input value bit 5 */
        byte PG6         :1;                                       /* Gain error correction for the plus-side input value bit 6 */
        byte PG7         :1;                                       /* Gain error correction for the plus-side input value bit 7 */
      } Bits;
    } ADC1PGLSTR;
    #define ADC1PGL                     _ADC1PG.Overlap_STR.ADC1PGLSTR.Byte
    #define ADC1PGL_PG0                 _ADC1PG.Overlap_STR.ADC1PGLSTR.Bits.PG0
    #define ADC1PGL_PG1                 _ADC1PG.Overlap_STR.ADC1PGLSTR.Bits.PG1
    #define ADC1PGL_PG2                 _ADC1PG.Overlap_STR.ADC1PGLSTR.Bits.PG2
    #define ADC1PGL_PG3                 _ADC1PG.Overlap_STR.ADC1PGLSTR.Bits.PG3
    #define ADC1PGL_PG4                 _ADC1PG.Overlap_STR.ADC1PGLSTR.Bits.PG4
    #define ADC1PGL_PG5                 _ADC1PG.Overlap_STR.ADC1PGLSTR.Bits.PG5
    #define ADC1PGL_PG6                 _ADC1PG.Overlap_STR.ADC1PGLSTR.Bits.PG6
    #define ADC1PGL_PG7                 _ADC1PG.Overlap_STR.ADC1PGLSTR.Bits.PG7
    
    #define ADC1PGL_PG0_MASK            1
    #define ADC1PGL_PG1_MASK            2
    #define ADC1PGL_PG2_MASK            4
    #define ADC1PGL_PG3_MASK            8
    #define ADC1PGL_PG4_MASK            16
    #define ADC1PGL_PG5_MASK            32
    #define ADC1PGL_PG6_MASK            64
    #define ADC1PGL_PG7_MASK            128
    
  } Overlap_STR;

} ADC1PGSTR;
extern volatile ADC1PGSTR _ADC1PG @0x00001908;
#define ADC1PG                          _ADC1PG.Word


/*** ADC1MG - Minus-Side Gain Register; 0x0000190A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ADC1MGH - Minus-Side Gain High Register; 0x0000190A ***/
    union {
      byte Byte;
      struct {
        byte MG8         :1;                                       /* Gain error correction for the minus-side input value bit 8 */
        byte MG9         :1;                                       /* Gain error correction for the minus-side input value bit 9 */
        byte MG10        :1;                                       /* Gain error correction for the minus-side input value bit 10 */
        byte MG11        :1;                                       /* Gain error correction for the minus-side input value bit 11 */
        byte MG12        :1;                                       /* Gain error correction for the minus-side input value bit 12 */
        byte MG13        :1;                                       /* Gain error correction for the minus-side input value bit 13 */
        byte MG14        :1;                                       /* Gain error correction for the minus-side input value bit 14 */
        byte MG15        :1;                                       /* Gain error correction for the minus-side input value bit 15 */
      } Bits;
    } ADC1MGHSTR;
    #define ADC1MGH                     _ADC1MG.Overlap_STR.ADC1MGHSTR.Byte
    #define ADC1MGH_MG8                 _ADC1MG.Overlap_STR.ADC1MGHSTR.Bits.MG8
    #define ADC1MGH_MG9                 _ADC1MG.Overlap_STR.ADC1MGHSTR.Bits.MG9
    #define ADC1MGH_MG10                _ADC1MG.Overlap_STR.ADC1MGHSTR.Bits.MG10
    #define ADC1MGH_MG11                _ADC1MG.Overlap_STR.ADC1MGHSTR.Bits.MG11
    #define ADC1MGH_MG12                _ADC1MG.Overlap_STR.ADC1MGHSTR.Bits.MG12
    #define ADC1MGH_MG13                _ADC1MG.Overlap_STR.ADC1MGHSTR.Bits.MG13
    #define ADC1MGH_MG14                _ADC1MG.Overlap_STR.ADC1MGHSTR.Bits.MG14
    #define ADC1MGH_MG15                _ADC1MG.Overlap_STR.ADC1MGHSTR.Bits.MG15
    
    #define ADC1MGH_MG8_MASK            1
    #define ADC1MGH_MG9_MASK            2
    #define ADC1MGH_MG10_MASK           4
    #define ADC1MGH_MG11_MASK           8
    #define ADC1MGH_MG12_MASK           16
    #define ADC1MGH_MG13_MASK           32
    #define ADC1MGH_MG14_MASK           64
    #define ADC1MGH_MG15_MASK           128
    

    /*** ADC1MGL - Minus-Side Gain Low Register; 0x0000190B ***/
    union {
      byte Byte;
      struct {
        byte MG0         :1;                                       /* Gain error correction for the minus-side input value bit 0 */
        byte MG1         :1;                                       /* Gain error correction for the minus-side input value bit 1 */
        byte MG2         :1;                                       /* Gain error correction for the minus-side input value bit 2 */
        byte MG3         :1;                                       /* Gain error correction for the minus-side input value bit 3 */
        byte MG4         :1;                                       /* Gain error correction for the minus-side input value bit 4 */
        byte MG5         :1;                                       /* Gain error correction for the minus-side input value bit 5 */
        byte MG6         :1;                                       /* Gain error correction for the minus-side input value bit 6 */
        byte MG7         :1;                                       /* Gain error correction for the minus-side input value bit 7 */
      } Bits;
    } ADC1MGLSTR;
    #define ADC1MGL                     _ADC1MG.Overlap_STR.ADC1MGLSTR.Byte
    #define ADC1MGL_MG0                 _ADC1MG.Overlap_STR.ADC1MGLSTR.Bits.MG0
    #define ADC1MGL_MG1                 _ADC1MG.Overlap_STR.ADC1MGLSTR.Bits.MG1
    #define ADC1MGL_MG2                 _ADC1MG.Overlap_STR.ADC1MGLSTR.Bits.MG2
    #define ADC1MGL_MG3                 _ADC1MG.Overlap_STR.ADC1MGLSTR.Bits.MG3
    #define ADC1MGL_MG4                 _ADC1MG.Overlap_STR.ADC1MGLSTR.Bits.MG4
    #define ADC1MGL_MG5                 _ADC1MG.Overlap_STR.ADC1MGLSTR.Bits.MG5
    #define ADC1MGL_MG6                 _ADC1MG.Overlap_STR.ADC1MGLSTR.Bits.MG6
    #define ADC1MGL_MG7                 _ADC1MG.Overlap_STR.ADC1MGLSTR.Bits.MG7
    
    #define ADC1MGL_MG0_MASK            1
    #define ADC1MGL_MG1_MASK            2
    #define ADC1MGL_MG2_MASK            4
    #define ADC1MGL_MG3_MASK            8
    #define ADC1MGL_MG4_MASK            16
    #define ADC1MGL_MG5_MASK            32
    #define ADC1MGL_MG6_MASK            64
    #define ADC1MGL_MG7_MASK            128
    
  } Overlap_STR;

} ADC1MGSTR;
extern volatile ADC1MGSTR _ADC1MG @0x0000190A;
#define ADC1MG                          _ADC1MG.Word


/*** ADC1CLPD - Plus-Side General Calibration Value D Register; 0x0000190C ***/
typedef union {
  byte Byte;
  struct {
    byte CLPD0       :1;                                       /* Plus-Side General Calibration Value D bit 0 */
    byte CLPD1       :1;                                       /* Plus-Side General Calibration Value D bit 1 */
    byte CLPD2       :1;                                       /* Plus-Side General Calibration Value D bit 2 */
    byte CLPD3       :1;                                       /* Plus-Side General Calibration Value D bit 3 */
    byte CLPD4       :1;                                       /* Plus-Side General Calibration Value D bit 4 */
    byte CLPD5       :1;                                       /* Plus-Side General Calibration Value D bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpCLPD :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} ADC1CLPDSTR;
extern volatile ADC1CLPDSTR _ADC1CLPD @0x0000190C;
#define ADC1CLPD                        _ADC1CLPD.Byte
#define ADC1CLPD_CLPD0                  _ADC1CLPD.Bits.CLPD0
#define ADC1CLPD_CLPD1                  _ADC1CLPD.Bits.CLPD1
#define ADC1CLPD_CLPD2                  _ADC1CLPD.Bits.CLPD2
#define ADC1CLPD_CLPD3                  _ADC1CLPD.Bits.CLPD3
#define ADC1CLPD_CLPD4                  _ADC1CLPD.Bits.CLPD4
#define ADC1CLPD_CLPD5                  _ADC1CLPD.Bits.CLPD5
#define ADC1CLPD_CLPD                   _ADC1CLPD.MergedBits.grpCLPD

#define ADC1CLPD_CLPD0_MASK             1
#define ADC1CLPD_CLPD1_MASK             2
#define ADC1CLPD_CLPD2_MASK             4
#define ADC1CLPD_CLPD3_MASK             8
#define ADC1CLPD_CLPD4_MASK             16
#define ADC1CLPD_CLPD5_MASK             32
#define ADC1CLPD_CLPD_MASK              63
#define ADC1CLPD_CLPD_BITNUM            0


/*** ADC1CLPS - Plus-Side General Calibration Value S Register; 0x0000190D ***/
typedef union {
  byte Byte;
  struct {
    byte CLPS0       :1;                                       /* Plus-Side General Calibration Value S bit 0 */
    byte CLPS1       :1;                                       /* Plus-Side General Calibration Value S bit 1 */
    byte CLPS2       :1;                                       /* Plus-Side General Calibration Value S bit 2 */
    byte CLPS3       :1;                                       /* Plus-Side General Calibration Value S bit 3 */
    byte CLPS4       :1;                                       /* Plus-Side General Calibration Value S bit 4 */
    byte CLPS5       :1;                                       /* Plus-Side General Calibration Value S bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpCLPS :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} ADC1CLPSSTR;
extern volatile ADC1CLPSSTR _ADC1CLPS @0x0000190D;
#define ADC1CLPS                        _ADC1CLPS.Byte
#define ADC1CLPS_CLPS0                  _ADC1CLPS.Bits.CLPS0
#define ADC1CLPS_CLPS1                  _ADC1CLPS.Bits.CLPS1
#define ADC1CLPS_CLPS2                  _ADC1CLPS.Bits.CLPS2
#define ADC1CLPS_CLPS3                  _ADC1CLPS.Bits.CLPS3
#define ADC1CLPS_CLPS4                  _ADC1CLPS.Bits.CLPS4
#define ADC1CLPS_CLPS5                  _ADC1CLPS.Bits.CLPS5
#define ADC1CLPS_CLPS                   _ADC1CLPS.MergedBits.grpCLPS

#define ADC1CLPS_CLPS0_MASK             1
#define ADC1CLPS_CLPS1_MASK             2
#define ADC1CLPS_CLPS2_MASK             4
#define ADC1CLPS_CLPS3_MASK             8
#define ADC1CLPS_CLPS4_MASK             16
#define ADC1CLPS_CLPS5_MASK             32
#define ADC1CLPS_CLPS_MASK              63
#define ADC1CLPS_CLPS_BITNUM            0


/*** ADC1CLP4 - Plus-Side General Calibration Value 4 Register; 0x0000190E ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ADC1CLP4H - Plus-Side General Calibration Value 4 High Register; 0x0000190E ***/
    union {
      byte Byte;
      struct {
        byte CLP48       :1;                                       /* Plus-Side General Calibration Value 4 bit 8 */
        byte CLP49       :1;                                       /* Plus-Side General Calibration Value 4 bit 9 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpCLP_48 :2;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ADC1CLP4HSTR;
    #define ADC1CLP4H                   _ADC1CLP4.Overlap_STR.ADC1CLP4HSTR.Byte
    #define ADC1CLP4H_CLP48             _ADC1CLP4.Overlap_STR.ADC1CLP4HSTR.Bits.CLP48
    #define ADC1CLP4H_CLP49             _ADC1CLP4.Overlap_STR.ADC1CLP4HSTR.Bits.CLP49
    #define ADC1CLP4H_CLP_48            _ADC1CLP4.Overlap_STR.ADC1CLP4HSTR.MergedBits.grpCLP_48
    #define ADC1CLP4H_CLP               ADC1CLP4H_CLP_48
    
    #define ADC1CLP4H_CLP48_MASK        1
    #define ADC1CLP4H_CLP49_MASK        2
    #define ADC1CLP4H_CLP_48_MASK       3
    #define ADC1CLP4H_CLP_48_BITNUM     0
    

    /*** ADC1CLP4L - Plus-Side General Calibration Value 4 Low Register; 0x0000190F ***/
    union {
      byte Byte;
      struct {
        byte CLP40       :1;                                       /* Plus-Side General Calibration Value 4 bit 0 */
        byte CLP41       :1;                                       /* Plus-Side General Calibration Value 4 bit 1 */
        byte CLP42       :1;                                       /* Plus-Side General Calibration Value 4 bit 2 */
        byte CLP43       :1;                                       /* Plus-Side General Calibration Value 4 bit 3 */
        byte CLP44       :1;                                       /* Plus-Side General Calibration Value 4 bit 4 */
        byte CLP45       :1;                                       /* Plus-Side General Calibration Value 4 bit 5 */
        byte CLP46       :1;                                       /* Plus-Side General Calibration Value 4 bit 6 */
        byte CLP47       :1;                                       /* Plus-Side General Calibration Value 4 bit 7 */
      } Bits;
    } ADC1CLP4LSTR;
    #define ADC1CLP4L                   _ADC1CLP4.Overlap_STR.ADC1CLP4LSTR.Byte
    #define ADC1CLP4L_CLP40             _ADC1CLP4.Overlap_STR.ADC1CLP4LSTR.Bits.CLP40
    #define ADC1CLP4L_CLP41             _ADC1CLP4.Overlap_STR.ADC1CLP4LSTR.Bits.CLP41
    #define ADC1CLP4L_CLP42             _ADC1CLP4.Overlap_STR.ADC1CLP4LSTR.Bits.CLP42
    #define ADC1CLP4L_CLP43             _ADC1CLP4.Overlap_STR.ADC1CLP4LSTR.Bits.CLP43
    #define ADC1CLP4L_CLP44             _ADC1CLP4.Overlap_STR.ADC1CLP4LSTR.Bits.CLP44
    #define ADC1CLP4L_CLP45             _ADC1CLP4.Overlap_STR.ADC1CLP4LSTR.Bits.CLP45
    #define ADC1CLP4L_CLP46             _ADC1CLP4.Overlap_STR.ADC1CLP4LSTR.Bits.CLP46
    #define ADC1CLP4L_CLP47             _ADC1CLP4.Overlap_STR.ADC1CLP4LSTR.Bits.CLP47
    
    #define ADC1CLP4L_CLP40_MASK        1
    #define ADC1CLP4L_CLP41_MASK        2
    #define ADC1CLP4L_CLP42_MASK        4
    #define ADC1CLP4L_CLP43_MASK        8
    #define ADC1CLP4L_CLP44_MASK        16
    #define ADC1CLP4L_CLP45_MASK        32
    #define ADC1CLP4L_CLP46_MASK        64
    #define ADC1CLP4L_CLP47_MASK        128
    
  } Overlap_STR;

} ADC1CLP4STR;
extern volatile ADC1CLP4STR _ADC1CLP4 @0x0000190E;
#define ADC1CLP4                        _ADC1CLP4.Word


/*** ADC1CLP3 - Plus-Side General Calibration Value 3 Register; 0x00001910 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ADC1CLP3H - Plus-Side General Calibration Value 3 High Register; 0x00001910 ***/
    union {
      byte Byte;
      struct {
        byte CLP38       :1;                                       /* Plus-Side General Calibration Value 3 bits */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
    } ADC1CLP3HSTR;
    #define ADC1CLP3H                   _ADC1CLP3.Overlap_STR.ADC1CLP3HSTR.Byte
    #define ADC1CLP3H_CLP38             _ADC1CLP3.Overlap_STR.ADC1CLP3HSTR.Bits.CLP38
    
    #define ADC1CLP3H_CLP38_MASK        1
    

    /*** ADC1CLP3L - Plus-Side General Calibration Value 3 Low Register; 0x00001911 ***/
    union {
      byte Byte;
      struct {
        byte CLP30       :1;                                       /* Plus-Side General Calibration Value 3 bit 0 */
        byte CLP31       :1;                                       /* Plus-Side General Calibration Value 3 bit 1 */
        byte CLP32       :1;                                       /* Plus-Side General Calibration Value 3 bit 2 */
        byte CLP33       :1;                                       /* Plus-Side General Calibration Value 3 bit 3 */
        byte CLP34       :1;                                       /* Plus-Side General Calibration Value 3 bit 4 */
        byte CLP35       :1;                                       /* Plus-Side General Calibration Value 3 bit 5 */
        byte CLP36       :1;                                       /* Plus-Side General Calibration Value 3 bit 6 */
        byte CLP37       :1;                                       /* Plus-Side General Calibration Value 3 bit 7 */
      } Bits;
    } ADC1CLP3LSTR;
    #define ADC1CLP3L                   _ADC1CLP3.Overlap_STR.ADC1CLP3LSTR.Byte
    #define ADC1CLP3L_CLP30             _ADC1CLP3.Overlap_STR.ADC1CLP3LSTR.Bits.CLP30
    #define ADC1CLP3L_CLP31             _ADC1CLP3.Overlap_STR.ADC1CLP3LSTR.Bits.CLP31
    #define ADC1CLP3L_CLP32             _ADC1CLP3.Overlap_STR.ADC1CLP3LSTR.Bits.CLP32
    #define ADC1CLP3L_CLP33             _ADC1CLP3.Overlap_STR.ADC1CLP3LSTR.Bits.CLP33
    #define ADC1CLP3L_CLP34             _ADC1CLP3.Overlap_STR.ADC1CLP3LSTR.Bits.CLP34
    #define ADC1CLP3L_CLP35             _ADC1CLP3.Overlap_STR.ADC1CLP3LSTR.Bits.CLP35
    #define ADC1CLP3L_CLP36             _ADC1CLP3.Overlap_STR.ADC1CLP3LSTR.Bits.CLP36
    #define ADC1CLP3L_CLP37             _ADC1CLP3.Overlap_STR.ADC1CLP3LSTR.Bits.CLP37
    
    #define ADC1CLP3L_CLP30_MASK        1
    #define ADC1CLP3L_CLP31_MASK        2
    #define ADC1CLP3L_CLP32_MASK        4
    #define ADC1CLP3L_CLP33_MASK        8
    #define ADC1CLP3L_CLP34_MASK        16
    #define ADC1CLP3L_CLP35_MASK        32
    #define ADC1CLP3L_CLP36_MASK        64
    #define ADC1CLP3L_CLP37_MASK        128
    
  } Overlap_STR;

} ADC1CLP3STR;
extern volatile ADC1CLP3STR _ADC1CLP3 @0x00001910;
#define ADC1CLP3                        _ADC1CLP3.Word


/*** ADC1CLP2 - Plus-Side General Calibration Value 2 Register; 0x00001912 ***/
typedef union {
  byte Byte;
  struct {
    byte CLP20       :1;                                       /* Plus-Side General Calibration Value 2 bit 0 */
    byte CLP21       :1;                                       /* Plus-Side General Calibration Value 2 bit 1 */
    byte CLP22       :1;                                       /* Plus-Side General Calibration Value 2 bit 2 */
    byte CLP23       :1;                                       /* Plus-Side General Calibration Value 2 bit 3 */
    byte CLP24       :1;                                       /* Plus-Side General Calibration Value 2 bit 4 */
    byte CLP25       :1;                                       /* Plus-Side General Calibration Value 2 bit 5 */
    byte CLP26       :1;                                       /* Plus-Side General Calibration Value 2 bit 6 */
    byte CLP27       :1;                                       /* Plus-Side General Calibration Value 2 bit 7 */
  } Bits;
} ADC1CLP2STR;
extern volatile ADC1CLP2STR _ADC1CLP2 @0x00001912;
#define ADC1CLP2                        _ADC1CLP2.Byte
#define ADC1CLP2_CLP20                  _ADC1CLP2.Bits.CLP20
#define ADC1CLP2_CLP21                  _ADC1CLP2.Bits.CLP21
#define ADC1CLP2_CLP22                  _ADC1CLP2.Bits.CLP22
#define ADC1CLP2_CLP23                  _ADC1CLP2.Bits.CLP23
#define ADC1CLP2_CLP24                  _ADC1CLP2.Bits.CLP24
#define ADC1CLP2_CLP25                  _ADC1CLP2.Bits.CLP25
#define ADC1CLP2_CLP26                  _ADC1CLP2.Bits.CLP26
#define ADC1CLP2_CLP27                  _ADC1CLP2.Bits.CLP27

#define ADC1CLP2_CLP20_MASK             1
#define ADC1CLP2_CLP21_MASK             2
#define ADC1CLP2_CLP22_MASK             4
#define ADC1CLP2_CLP23_MASK             8
#define ADC1CLP2_CLP24_MASK             16
#define ADC1CLP2_CLP25_MASK             32
#define ADC1CLP2_CLP26_MASK             64
#define ADC1CLP2_CLP27_MASK             128


/*** ADC1CLP1 - Plus-Side General Calibration Value 1 Register; 0x00001913 ***/
typedef union {
  byte Byte;
  struct {
    byte CLP10       :1;                                       /* Plus-Side General Calibration Value 1 bit 0 */
    byte CLP11       :1;                                       /* Plus-Side General Calibration Value 1 bit 1 */
    byte CLP12       :1;                                       /* Plus-Side General Calibration Value 1 bit 2 */
    byte CLP13       :1;                                       /* Plus-Side General Calibration Value 1 bit 3 */
    byte CLP14       :1;                                       /* Plus-Side General Calibration Value 1 bit 4 */
    byte CLP15       :1;                                       /* Plus-Side General Calibration Value 1 bit 5 */
    byte CLP16       :1;                                       /* Plus-Side General Calibration Value 1 bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpCLP_10 :7;
    byte         :1;
  } MergedBits;
} ADC1CLP1STR;
extern volatile ADC1CLP1STR _ADC1CLP1 @0x00001913;
#define ADC1CLP1                        _ADC1CLP1.Byte
#define ADC1CLP1_CLP10                  _ADC1CLP1.Bits.CLP10
#define ADC1CLP1_CLP11                  _ADC1CLP1.Bits.CLP11
#define ADC1CLP1_CLP12                  _ADC1CLP1.Bits.CLP12
#define ADC1CLP1_CLP13                  _ADC1CLP1.Bits.CLP13
#define ADC1CLP1_CLP14                  _ADC1CLP1.Bits.CLP14
#define ADC1CLP1_CLP15                  _ADC1CLP1.Bits.CLP15
#define ADC1CLP1_CLP16                  _ADC1CLP1.Bits.CLP16
#define ADC1CLP1_CLP_10                 _ADC1CLP1.MergedBits.grpCLP_10
#define ADC1CLP1_CLP                    ADC1CLP1_CLP_10

#define ADC1CLP1_CLP10_MASK             1
#define ADC1CLP1_CLP11_MASK             2
#define ADC1CLP1_CLP12_MASK             4
#define ADC1CLP1_CLP13_MASK             8
#define ADC1CLP1_CLP14_MASK             16
#define ADC1CLP1_CLP15_MASK             32
#define ADC1CLP1_CLP16_MASK             64
#define ADC1CLP1_CLP_10_MASK            127
#define ADC1CLP1_CLP_10_BITNUM          0


/*** ADC1CLP0 - Plus-Side General Calibration Value 0 Register; 0x00001914 ***/
typedef union {
  byte Byte;
  struct {
    byte CLP00       :1;                                       /* Plus-Side General Calibration Value 0 bit 0 */
    byte CLP01       :1;                                       /* Plus-Side General Calibration Value 0 bit 1 */
    byte CLP02       :1;                                       /* Plus-Side General Calibration Value 0 bit 2 */
    byte CLP03       :1;                                       /* Plus-Side General Calibration Value 0 bit 3 */
    byte CLP04       :1;                                       /* Plus-Side General Calibration Value 0 bit 4 */
    byte CLP05       :1;                                       /* Plus-Side General Calibration Value 0 bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpCLP0 :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} ADC1CLP0STR;
extern volatile ADC1CLP0STR _ADC1CLP0 @0x00001914;
#define ADC1CLP0                        _ADC1CLP0.Byte
#define ADC1CLP0_CLP00                  _ADC1CLP0.Bits.CLP00
#define ADC1CLP0_CLP01                  _ADC1CLP0.Bits.CLP01
#define ADC1CLP0_CLP02                  _ADC1CLP0.Bits.CLP02
#define ADC1CLP0_CLP03                  _ADC1CLP0.Bits.CLP03
#define ADC1CLP0_CLP04                  _ADC1CLP0.Bits.CLP04
#define ADC1CLP0_CLP05                  _ADC1CLP0.Bits.CLP05
#define ADC1CLP0_CLP0                   _ADC1CLP0.MergedBits.grpCLP0

#define ADC1CLP0_CLP00_MASK             1
#define ADC1CLP0_CLP01_MASK             2
#define ADC1CLP0_CLP02_MASK             4
#define ADC1CLP0_CLP03_MASK             8
#define ADC1CLP0_CLP04_MASK             16
#define ADC1CLP0_CLP05_MASK             32
#define ADC1CLP0_CLP0_MASK              63
#define ADC1CLP0_CLP0_BITNUM            0


/*** ADC1CLMD - Minus-Side General Calibration Value D Register; 0x00001916 ***/
typedef union {
  byte Byte;
  struct {
    byte CLMD0       :1;                                       /* Minus-Side General Calibration Value D bit 0 */
    byte CLMD1       :1;                                       /* Minus-Side General Calibration Value D bit 1 */
    byte CLMD2       :1;                                       /* Minus-Side General Calibration Value D bit 2 */
    byte CLMD3       :1;                                       /* Minus-Side General Calibration Value D bit 3 */
    byte CLMD4       :1;                                       /* Minus-Side General Calibration Value D bit 4 */
    byte CLMD5       :1;                                       /* Minus-Side General Calibration Value D bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpCLMD :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} ADC1CLMDSTR;
extern volatile ADC1CLMDSTR _ADC1CLMD @0x00001916;
#define ADC1CLMD                        _ADC1CLMD.Byte
#define ADC1CLMD_CLMD0                  _ADC1CLMD.Bits.CLMD0
#define ADC1CLMD_CLMD1                  _ADC1CLMD.Bits.CLMD1
#define ADC1CLMD_CLMD2                  _ADC1CLMD.Bits.CLMD2
#define ADC1CLMD_CLMD3                  _ADC1CLMD.Bits.CLMD3
#define ADC1CLMD_CLMD4                  _ADC1CLMD.Bits.CLMD4
#define ADC1CLMD_CLMD5                  _ADC1CLMD.Bits.CLMD5
#define ADC1CLMD_CLMD                   _ADC1CLMD.MergedBits.grpCLMD

#define ADC1CLMD_CLMD0_MASK             1
#define ADC1CLMD_CLMD1_MASK             2
#define ADC1CLMD_CLMD2_MASK             4
#define ADC1CLMD_CLMD3_MASK             8
#define ADC1CLMD_CLMD4_MASK             16
#define ADC1CLMD_CLMD5_MASK             32
#define ADC1CLMD_CLMD_MASK              63
#define ADC1CLMD_CLMD_BITNUM            0


/*** ADC1CLMS - Minus-Side General Calibration Value S Register; 0x00001917 ***/
typedef union {
  byte Byte;
  struct {
    byte CLMS0       :1;                                       /* Minus-Side General Calibration Value S bit 0 */
    byte CLMS1       :1;                                       /* Minus-Side General Calibration Value S bit 1 */
    byte CLMS2       :1;                                       /* Minus-Side General Calibration Value S bit 2 */
    byte CLMS3       :1;                                       /* Minus-Side General Calibration Value S bit 3 */
    byte CLMS4       :1;                                       /* Minus-Side General Calibration Value S bit 4 */
    byte CLMS5       :1;                                       /* Minus-Side General Calibration Value S bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpCLMS :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} ADC1CLMSSTR;
extern volatile ADC1CLMSSTR _ADC1CLMS @0x00001917;
#define ADC1CLMS                        _ADC1CLMS.Byte
#define ADC1CLMS_CLMS0                  _ADC1CLMS.Bits.CLMS0
#define ADC1CLMS_CLMS1                  _ADC1CLMS.Bits.CLMS1
#define ADC1CLMS_CLMS2                  _ADC1CLMS.Bits.CLMS2
#define ADC1CLMS_CLMS3                  _ADC1CLMS.Bits.CLMS3
#define ADC1CLMS_CLMS4                  _ADC1CLMS.Bits.CLMS4
#define ADC1CLMS_CLMS5                  _ADC1CLMS.Bits.CLMS5
#define ADC1CLMS_CLMS                   _ADC1CLMS.MergedBits.grpCLMS

#define ADC1CLMS_CLMS0_MASK             1
#define ADC1CLMS_CLMS1_MASK             2
#define ADC1CLMS_CLMS2_MASK             4
#define ADC1CLMS_CLMS3_MASK             8
#define ADC1CLMS_CLMS4_MASK             16
#define ADC1CLMS_CLMS5_MASK             32
#define ADC1CLMS_CLMS_MASK              63
#define ADC1CLMS_CLMS_BITNUM            0


/*** ADC1CLM4 - Minus-Side General Calibration Value 4 Register; 0x00001918 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ADC1CLM4H - Minus-Side General Calibration Value 4 High Register; 0x00001918 ***/
    union {
      byte Byte;
      struct {
        byte CLM48       :1;                                       /* Minus-Side General Calibration Value 4 bit 8 */
        byte CLM49       :1;                                       /* Minus-Side General Calibration Value 4 bit 9 */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
      struct {
        byte grpCLM_48 :2;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
        byte     :1;
      } MergedBits;
    } ADC1CLM4HSTR;
    #define ADC1CLM4H                   _ADC1CLM4.Overlap_STR.ADC1CLM4HSTR.Byte
    #define ADC1CLM4H_CLM48             _ADC1CLM4.Overlap_STR.ADC1CLM4HSTR.Bits.CLM48
    #define ADC1CLM4H_CLM49             _ADC1CLM4.Overlap_STR.ADC1CLM4HSTR.Bits.CLM49
    #define ADC1CLM4H_CLM_48            _ADC1CLM4.Overlap_STR.ADC1CLM4HSTR.MergedBits.grpCLM_48
    #define ADC1CLM4H_CLM               ADC1CLM4H_CLM_48
    
    #define ADC1CLM4H_CLM48_MASK        1
    #define ADC1CLM4H_CLM49_MASK        2
    #define ADC1CLM4H_CLM_48_MASK       3
    #define ADC1CLM4H_CLM_48_BITNUM     0
    

    /*** ADC1CLM4L - Minus-Side General Calibration Value 4 Low Register; 0x00001919 ***/
    union {
      byte Byte;
      struct {
        byte CLM40       :1;                                       /* Minus-Side General Calibration Value 4 bit 0 */
        byte CLM41       :1;                                       /* Minus-Side General Calibration Value 4 bit 1 */
        byte CLM42       :1;                                       /* Minus-Side General Calibration Value 4 bit 2 */
        byte CLM43       :1;                                       /* Minus-Side General Calibration Value 4 bit 3 */
        byte CLM44       :1;                                       /* Minus-Side General Calibration Value 4 bit 4 */
        byte CLM45       :1;                                       /* Minus-Side General Calibration Value 4 bit 5 */
        byte CLM46       :1;                                       /* Minus-Side General Calibration Value 4 bit 6 */
        byte CLM47       :1;                                       /* Minus-Side General Calibration Value 4 bit 7 */
      } Bits;
    } ADC1CLM4LSTR;
    #define ADC1CLM4L                   _ADC1CLM4.Overlap_STR.ADC1CLM4LSTR.Byte
    #define ADC1CLM4L_CLM40             _ADC1CLM4.Overlap_STR.ADC1CLM4LSTR.Bits.CLM40
    #define ADC1CLM4L_CLM41             _ADC1CLM4.Overlap_STR.ADC1CLM4LSTR.Bits.CLM41
    #define ADC1CLM4L_CLM42             _ADC1CLM4.Overlap_STR.ADC1CLM4LSTR.Bits.CLM42
    #define ADC1CLM4L_CLM43             _ADC1CLM4.Overlap_STR.ADC1CLM4LSTR.Bits.CLM43
    #define ADC1CLM4L_CLM44             _ADC1CLM4.Overlap_STR.ADC1CLM4LSTR.Bits.CLM44
    #define ADC1CLM4L_CLM45             _ADC1CLM4.Overlap_STR.ADC1CLM4LSTR.Bits.CLM45
    #define ADC1CLM4L_CLM46             _ADC1CLM4.Overlap_STR.ADC1CLM4LSTR.Bits.CLM46
    #define ADC1CLM4L_CLM47             _ADC1CLM4.Overlap_STR.ADC1CLM4LSTR.Bits.CLM47
    
    #define ADC1CLM4L_CLM40_MASK        1
    #define ADC1CLM4L_CLM41_MASK        2
    #define ADC1CLM4L_CLM42_MASK        4
    #define ADC1CLM4L_CLM43_MASK        8
    #define ADC1CLM4L_CLM44_MASK        16
    #define ADC1CLM4L_CLM45_MASK        32
    #define ADC1CLM4L_CLM46_MASK        64
    #define ADC1CLM4L_CLM47_MASK        128
    
  } Overlap_STR;

} ADC1CLM4STR;
extern volatile ADC1CLM4STR _ADC1CLM4 @0x00001918;
#define ADC1CLM4                        _ADC1CLM4.Word


/*** ADC1CLM3 - Minus-Side General Calibration Value 3 Register; 0x0000191A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** ADC1CLM3H - Minus-Side General Calibration Value 3 High Register; 0x0000191A ***/
    union {
      byte Byte;
      struct {
        byte CLM38       :1;                                       /* Minus-Side General Calibration Value 3 bits */
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
        byte             :1; 
      } Bits;
    } ADC1CLM3HSTR;
    #define ADC1CLM3H                   _ADC1CLM3.Overlap_STR.ADC1CLM3HSTR.Byte
    #define ADC1CLM3H_CLM38             _ADC1CLM3.Overlap_STR.ADC1CLM3HSTR.Bits.CLM38
    
    #define ADC1CLM3H_CLM38_MASK        1
    

    /*** ADC1CLM3L - Minus-Side General Calibration Value 3 Low Register; 0x0000191B ***/
    union {
      byte Byte;
      struct {
        byte CLM30       :1;                                       /* Minus-Side General Calibration Value 3 bit 0 */
        byte CLM31       :1;                                       /* Minus-Side General Calibration Value 3 bit 1 */
        byte CLM32       :1;                                       /* Minus-Side General Calibration Value 3 bit 2 */
        byte CLM33       :1;                                       /* Minus-Side General Calibration Value 3 bit 3 */
        byte CLM34       :1;                                       /* Minus-Side General Calibration Value 3 bit 4 */
        byte CLM35       :1;                                       /* Minus-Side General Calibration Value 3 bit 5 */
        byte CLM36       :1;                                       /* Minus-Side General Calibration Value 3 bit 6 */
        byte CLM37       :1;                                       /* Minus-Side General Calibration Value 3 bit 7 */
      } Bits;
    } ADC1CLM3LSTR;
    #define ADC1CLM3L                   _ADC1CLM3.Overlap_STR.ADC1CLM3LSTR.Byte
    #define ADC1CLM3L_CLM30             _ADC1CLM3.Overlap_STR.ADC1CLM3LSTR.Bits.CLM30
    #define ADC1CLM3L_CLM31             _ADC1CLM3.Overlap_STR.ADC1CLM3LSTR.Bits.CLM31
    #define ADC1CLM3L_CLM32             _ADC1CLM3.Overlap_STR.ADC1CLM3LSTR.Bits.CLM32
    #define ADC1CLM3L_CLM33             _ADC1CLM3.Overlap_STR.ADC1CLM3LSTR.Bits.CLM33
    #define ADC1CLM3L_CLM34             _ADC1CLM3.Overlap_STR.ADC1CLM3LSTR.Bits.CLM34
    #define ADC1CLM3L_CLM35             _ADC1CLM3.Overlap_STR.ADC1CLM3LSTR.Bits.CLM35
    #define ADC1CLM3L_CLM36             _ADC1CLM3.Overlap_STR.ADC1CLM3LSTR.Bits.CLM36
    #define ADC1CLM3L_CLM37             _ADC1CLM3.Overlap_STR.ADC1CLM3LSTR.Bits.CLM37
    
    #define ADC1CLM3L_CLM30_MASK        1
    #define ADC1CLM3L_CLM31_MASK        2
    #define ADC1CLM3L_CLM32_MASK        4
    #define ADC1CLM3L_CLM33_MASK        8
    #define ADC1CLM3L_CLM34_MASK        16
    #define ADC1CLM3L_CLM35_MASK        32
    #define ADC1CLM3L_CLM36_MASK        64
    #define ADC1CLM3L_CLM37_MASK        128
    
  } Overlap_STR;

} ADC1CLM3STR;
extern volatile ADC1CLM3STR _ADC1CLM3 @0x0000191A;
#define ADC1CLM3                        _ADC1CLM3.Word


/*** ADC1CLM2 - Minus-Side General Calibration Value 2 Register; 0x0000191C ***/
typedef union {
  byte Byte;
  struct {
    byte CLM20       :1;                                       /* Minus-Side General Calibration Value 2 bit 0 */
    byte CLM21       :1;                                       /* Minus-Side General Calibration Value 2 bit 1 */
    byte CLM22       :1;                                       /* Minus-Side General Calibration Value 2 bit 2 */
    byte CLM23       :1;                                       /* Minus-Side General Calibration Value 2 bit 3 */
    byte CLM24       :1;                                       /* Minus-Side General Calibration Value 2 bit 4 */
    byte CLM25       :1;                                       /* Minus-Side General Calibration Value 2 bit 5 */
    byte CLM26       :1;                                       /* Minus-Side General Calibration Value 2 bit 6 */
    byte CLM27       :1;                                       /* Minus-Side General Calibration Value 2 bit 7 */
  } Bits;
} ADC1CLM2STR;
extern volatile ADC1CLM2STR _ADC1CLM2 @0x0000191C;
#define ADC1CLM2                        _ADC1CLM2.Byte
#define ADC1CLM2_CLM20                  _ADC1CLM2.Bits.CLM20
#define ADC1CLM2_CLM21                  _ADC1CLM2.Bits.CLM21
#define ADC1CLM2_CLM22                  _ADC1CLM2.Bits.CLM22
#define ADC1CLM2_CLM23                  _ADC1CLM2.Bits.CLM23
#define ADC1CLM2_CLM24                  _ADC1CLM2.Bits.CLM24
#define ADC1CLM2_CLM25                  _ADC1CLM2.Bits.CLM25
#define ADC1CLM2_CLM26                  _ADC1CLM2.Bits.CLM26
#define ADC1CLM2_CLM27                  _ADC1CLM2.Bits.CLM27

#define ADC1CLM2_CLM20_MASK             1
#define ADC1CLM2_CLM21_MASK             2
#define ADC1CLM2_CLM22_MASK             4
#define ADC1CLM2_CLM23_MASK             8
#define ADC1CLM2_CLM24_MASK             16
#define ADC1CLM2_CLM25_MASK             32
#define ADC1CLM2_CLM26_MASK             64
#define ADC1CLM2_CLM27_MASK             128


/*** ADC1CLM1 - Minus-Side General Calibration Value 1 Register; 0x0000191D ***/
typedef union {
  byte Byte;
  struct {
    byte CLM10       :1;                                       /* Minus-Side General Calibration Value 1 bit 0 */
    byte CLM11       :1;                                       /* Minus-Side General Calibration Value 1 bit 1 */
    byte CLM12       :1;                                       /* Minus-Side General Calibration Value 1 bit 2 */
    byte CLM13       :1;                                       /* Minus-Side General Calibration Value 1 bit 3 */
    byte CLM14       :1;                                       /* Minus-Side General Calibration Value 1 bit 4 */
    byte CLM15       :1;                                       /* Minus-Side General Calibration Value 1 bit 5 */
    byte CLM16       :1;                                       /* Minus-Side General Calibration Value 1 bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpCLM_10 :7;
    byte         :1;
  } MergedBits;
} ADC1CLM1STR;
extern volatile ADC1CLM1STR _ADC1CLM1 @0x0000191D;
#define ADC1CLM1                        _ADC1CLM1.Byte
#define ADC1CLM1_CLM10                  _ADC1CLM1.Bits.CLM10
#define ADC1CLM1_CLM11                  _ADC1CLM1.Bits.CLM11
#define ADC1CLM1_CLM12                  _ADC1CLM1.Bits.CLM12
#define ADC1CLM1_CLM13                  _ADC1CLM1.Bits.CLM13
#define ADC1CLM1_CLM14                  _ADC1CLM1.Bits.CLM14
#define ADC1CLM1_CLM15                  _ADC1CLM1.Bits.CLM15
#define ADC1CLM1_CLM16                  _ADC1CLM1.Bits.CLM16
#define ADC1CLM1_CLM_10                 _ADC1CLM1.MergedBits.grpCLM_10
#define ADC1CLM1_CLM                    ADC1CLM1_CLM_10

#define ADC1CLM1_CLM10_MASK             1
#define ADC1CLM1_CLM11_MASK             2
#define ADC1CLM1_CLM12_MASK             4
#define ADC1CLM1_CLM13_MASK             8
#define ADC1CLM1_CLM14_MASK             16
#define ADC1CLM1_CLM15_MASK             32
#define ADC1CLM1_CLM16_MASK             64
#define ADC1CLM1_CLM_10_MASK            127
#define ADC1CLM1_CLM_10_BITNUM          0


/*** ADC1CLM0 - Minus-Side General Calibration Value 0 Register; 0x0000191E ***/
typedef union {
  byte Byte;
  struct {
    byte CLM00       :1;                                       /* Minus-Side General Calibration Value 0 bit 0 */
    byte CLM01       :1;                                       /* Minus-Side General Calibration Value 0 bit 1 */
    byte CLM02       :1;                                       /* Minus-Side General Calibration Value 0 bit 2 */
    byte CLM03       :1;                                       /* Minus-Side General Calibration Value 0 bit 3 */
    byte CLM04       :1;                                       /* Minus-Side General Calibration Value 0 bit 4 */
    byte CLM05       :1;                                       /* Minus-Side General Calibration Value 0 bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpCLM0 :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} ADC1CLM0STR;
extern volatile ADC1CLM0STR _ADC1CLM0 @0x0000191E;
#define ADC1CLM0                        _ADC1CLM0.Byte
#define ADC1CLM0_CLM00                  _ADC1CLM0.Bits.CLM00
#define ADC1CLM0_CLM01                  _ADC1CLM0.Bits.CLM01
#define ADC1CLM0_CLM02                  _ADC1CLM0.Bits.CLM02
#define ADC1CLM0_CLM03                  _ADC1CLM0.Bits.CLM03
#define ADC1CLM0_CLM04                  _ADC1CLM0.Bits.CLM04
#define ADC1CLM0_CLM05                  _ADC1CLM0.Bits.CLM05
#define ADC1CLM0_CLM0                   _ADC1CLM0.MergedBits.grpCLM0

#define ADC1CLM0_CLM00_MASK             1
#define ADC1CLM0_CLM01_MASK             2
#define ADC1CLM0_CLM02_MASK             4
#define ADC1CLM0_CLM03_MASK             8
#define ADC1CLM0_CLM04_MASK             16
#define ADC1CLM0_CLM05_MASK             32
#define ADC1CLM0_CLM0_MASK              63
#define ADC1CLM0_CLM0_BITNUM            0


/*** PRACMP0CS - PRACMP0 Control and Status Register; 0x00001924 ***/
typedef union {
  byte Byte;
  struct {
    byte ACIEN       :1;                                       /* ACMP Interrupt Enable */
    byte ACINTS0     :1;                                       /* ACMP Interrupt Select, bit 0 */
    byte ACINTS1     :1;                                       /* ACMP Interrupt Select, bit 1 */
    byte ACMPO       :1;                                       /* ACMP Output Bit */
    byte ACOPE       :1;                                       /* ACMP Output Pin Enable */
    byte             :1; 
    byte ACMPF       :1;                                       /* ACMP Interrupt Flag */
    byte ACEN        :1;                                       /* ACMP Module Enable */
  } Bits;
  struct {
    byte         :1;
    byte grpACINTS :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PRACMP0CSSTR;
extern volatile PRACMP0CSSTR _PRACMP0CS @0x00001924;
#define PRACMP0CS                       _PRACMP0CS.Byte
#define PRACMP0CS_ACIEN                 _PRACMP0CS.Bits.ACIEN
#define PRACMP0CS_ACINTS0               _PRACMP0CS.Bits.ACINTS0
#define PRACMP0CS_ACINTS1               _PRACMP0CS.Bits.ACINTS1
#define PRACMP0CS_ACMPO                 _PRACMP0CS.Bits.ACMPO
#define PRACMP0CS_ACOPE                 _PRACMP0CS.Bits.ACOPE
#define PRACMP0CS_ACMPF                 _PRACMP0CS.Bits.ACMPF
#define PRACMP0CS_ACEN                  _PRACMP0CS.Bits.ACEN
#define PRACMP0CS_ACINTS                _PRACMP0CS.MergedBits.grpACINTS

#define PRACMP0CS_ACIEN_MASK            1
#define PRACMP0CS_ACINTS0_MASK          2
#define PRACMP0CS_ACINTS1_MASK          4
#define PRACMP0CS_ACMPO_MASK            8
#define PRACMP0CS_ACOPE_MASK            16
#define PRACMP0CS_ACMPF_MASK            64
#define PRACMP0CS_ACEN_MASK             128
#define PRACMP0CS_ACINTS_MASK           6
#define PRACMP0CS_ACINTS_BITNUM         1


/*** PRACMP0C0 - PRACMP0 Control 0 Register; 0x00001925 ***/
typedef union {
  byte Byte;
  struct {
    byte ACNSEL0     :1;                                       /* ACMP Negative Input Select, bit 0 */
    byte ACNSEL1     :1;                                       /* ACMP Negative Input Select, bit 1 */
    byte ACNSEL2     :1;                                       /* ACMP Negative Input Select, bit 2 */
    byte             :1; 
    byte ACPSEL0     :1;                                       /* ACMP Positive Input Select, bit 0 */
    byte ACPSEL1     :1;                                       /* ACMP Positive Input Select, bit 1 */
    byte ACPSEL2     :1;                                       /* ACMP Positive Input Select, bit 2 */
    byte             :1; 
  } Bits;
  struct {
    byte grpACNSEL :3;
    byte         :1;
    byte grpACPSEL :3;
    byte         :1;
  } MergedBits;
} PRACMP0C0STR;
extern volatile PRACMP0C0STR _PRACMP0C0 @0x00001925;
#define PRACMP0C0                       _PRACMP0C0.Byte
#define PRACMP0C0_ACNSEL0               _PRACMP0C0.Bits.ACNSEL0
#define PRACMP0C0_ACNSEL1               _PRACMP0C0.Bits.ACNSEL1
#define PRACMP0C0_ACNSEL2               _PRACMP0C0.Bits.ACNSEL2
#define PRACMP0C0_ACPSEL0               _PRACMP0C0.Bits.ACPSEL0
#define PRACMP0C0_ACPSEL1               _PRACMP0C0.Bits.ACPSEL1
#define PRACMP0C0_ACPSEL2               _PRACMP0C0.Bits.ACPSEL2
/* PRACMP0C_ARR: Access 3 PRACMP0Cx registers in an array */
#define PRACMP0C_ARR                    ((volatile byte * __far) &PRACMP0C0)
#define PRACMP0C0_ACNSEL                _PRACMP0C0.MergedBits.grpACNSEL
#define PRACMP0C0_ACPSEL                _PRACMP0C0.MergedBits.grpACPSEL

#define PRACMP0C0_ACNSEL0_MASK          1
#define PRACMP0C0_ACNSEL1_MASK          2
#define PRACMP0C0_ACNSEL2_MASK          4
#define PRACMP0C0_ACPSEL0_MASK          16
#define PRACMP0C0_ACPSEL1_MASK          32
#define PRACMP0C0_ACPSEL2_MASK          64
#define PRACMP0C0_ACNSEL_MASK           7
#define PRACMP0C0_ACNSEL_BITNUM         0
#define PRACMP0C0_ACPSEL_MASK           112
#define PRACMP0C0_ACPSEL_BITNUM         4


/*** PRACMP0C1 - PRACMP0 Control 1 Register; 0x00001926 ***/
typedef union {
  byte Byte;
  struct {
    byte PRGOS0      :1;                                       /* Programmable Reference Generator Output Selection, bit 0 */
    byte PRGOS1      :1;                                       /* Programmable Reference Generator Output Selection, bit 1 */
    byte PRGOS2      :1;                                       /* Programmable Reference Generator Output Selection, bit 2 */
    byte PRGOS3      :1;                                       /* Programmable Reference Generator Output Selection, bit 3 */
    byte PRGOS4      :1;                                       /* Programmable Reference Generator Output Selection, bit 4 */
    byte             :1; 
    byte PRGINS      :1;                                       /* Programmable Reference Generator Input Selection */
    byte PRGEN       :1;                                       /* Programmable Reference Generator Enable */
  } Bits;
  struct {
    byte grpPRGOS :5;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PRACMP0C1STR;
extern volatile PRACMP0C1STR _PRACMP0C1 @0x00001926;
#define PRACMP0C1                       _PRACMP0C1.Byte
#define PRACMP0C1_PRGOS0                _PRACMP0C1.Bits.PRGOS0
#define PRACMP0C1_PRGOS1                _PRACMP0C1.Bits.PRGOS1
#define PRACMP0C1_PRGOS2                _PRACMP0C1.Bits.PRGOS2
#define PRACMP0C1_PRGOS3                _PRACMP0C1.Bits.PRGOS3
#define PRACMP0C1_PRGOS4                _PRACMP0C1.Bits.PRGOS4
#define PRACMP0C1_PRGINS                _PRACMP0C1.Bits.PRGINS
#define PRACMP0C1_PRGEN                 _PRACMP0C1.Bits.PRGEN
#define PRACMP0C1_PRGOS                 _PRACMP0C1.MergedBits.grpPRGOS

#define PRACMP0C1_PRGOS0_MASK           1
#define PRACMP0C1_PRGOS1_MASK           2
#define PRACMP0C1_PRGOS2_MASK           4
#define PRACMP0C1_PRGOS3_MASK           8
#define PRACMP0C1_PRGOS4_MASK           16
#define PRACMP0C1_PRGINS_MASK           64
#define PRACMP0C1_PRGEN_MASK            128
#define PRACMP0C1_PRGOS_MASK            31
#define PRACMP0C1_PRGOS_BITNUM          0


/*** PRACMP0C2 - PRACMP0 Control 2 Register; 0x00001927 ***/
typedef union {
  byte Byte;
  struct {
    byte ACIPE0      :1;                                       /* ACMP Input Pin 0 Enable - ACIPE0 is used to control the PRACMP external pin 0 as analog input */
    byte ACIPE1      :1;                                       /* ACMP Input Pin 1 Enable - ACIPE1 is used to control the PRACMP external pin 1 as analog input */
    byte ACIPE2      :1;                                       /* ACMP Input Pin 2 Enable - ACIPE2 is used to control the PRACMP external pin 2 as analog input */
    byte ACIPE3      :1;                                       /* ACMP Input Pin 3 Enable - ACIPE3 is used to control the PRACMP external pin 3 as analog input */
    byte ACIPE4      :1;                                       /* ACMP Input Pin 4 Enable - ACIPE4 is used to control the PRACMP external pin 4 as analog input */
    byte ACIPE5      :1;                                       /* ACMP Input Pin 5 Enable - ACIPE5 is used to control the PRACMP external pin 5 as analog input */
    byte ACIPE6      :1;                                       /* ACMP Input Pin 6 Enable - ACIPE6 is used to control the PRACMP external pin 6 as analog input */
    byte             :1; 
  } Bits;
  struct {
    byte grpACIPE :7;
    byte         :1;
  } MergedBits;
} PRACMP0C2STR;
extern volatile PRACMP0C2STR _PRACMP0C2 @0x00001927;
#define PRACMP0C2                       _PRACMP0C2.Byte
#define PRACMP0C2_ACIPE0                _PRACMP0C2.Bits.ACIPE0
#define PRACMP0C2_ACIPE1                _PRACMP0C2.Bits.ACIPE1
#define PRACMP0C2_ACIPE2                _PRACMP0C2.Bits.ACIPE2
#define PRACMP0C2_ACIPE3                _PRACMP0C2.Bits.ACIPE3
#define PRACMP0C2_ACIPE4                _PRACMP0C2.Bits.ACIPE4
#define PRACMP0C2_ACIPE5                _PRACMP0C2.Bits.ACIPE5
#define PRACMP0C2_ACIPE6                _PRACMP0C2.Bits.ACIPE6
#define PRACMP0C2_ACIPE                 _PRACMP0C2.MergedBits.grpACIPE

#define PRACMP0C2_ACIPE0_MASK           1
#define PRACMP0C2_ACIPE1_MASK           2
#define PRACMP0C2_ACIPE2_MASK           4
#define PRACMP0C2_ACIPE3_MASK           8
#define PRACMP0C2_ACIPE4_MASK           16
#define PRACMP0C2_ACIPE5_MASK           32
#define PRACMP0C2_ACIPE6_MASK           64
#define PRACMP0C2_ACIPE_MASK            127
#define PRACMP0C2_ACIPE_BITNUM          0


/*** PRACMP1CS - PRACMP1 Control and Status Register; 0x00001928 ***/
typedef union {
  byte Byte;
  struct {
    byte ACIEN       :1;                                       /* ACMP Interrupt Enable */
    byte ACINTS0     :1;                                       /* ACMP Interrupt Select, bit 0 */
    byte ACINTS1     :1;                                       /* ACMP Interrupt Select, bit 1 */
    byte ACMPO       :1;                                       /* ACMP Output Bit */
    byte ACOPE       :1;                                       /* ACMP Output Pin Enable */
    byte             :1; 
    byte ACMPF       :1;                                       /* ACMP Interrupt Flag */
    byte ACEN        :1;                                       /* ACMP Module Enable */
  } Bits;
  struct {
    byte         :1;
    byte grpACINTS :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PRACMP1CSSTR;
extern volatile PRACMP1CSSTR _PRACMP1CS @0x00001928;
#define PRACMP1CS                       _PRACMP1CS.Byte
#define PRACMP1CS_ACIEN                 _PRACMP1CS.Bits.ACIEN
#define PRACMP1CS_ACINTS0               _PRACMP1CS.Bits.ACINTS0
#define PRACMP1CS_ACINTS1               _PRACMP1CS.Bits.ACINTS1
#define PRACMP1CS_ACMPO                 _PRACMP1CS.Bits.ACMPO
#define PRACMP1CS_ACOPE                 _PRACMP1CS.Bits.ACOPE
#define PRACMP1CS_ACMPF                 _PRACMP1CS.Bits.ACMPF
#define PRACMP1CS_ACEN                  _PRACMP1CS.Bits.ACEN
#define PRACMP1CS_ACINTS                _PRACMP1CS.MergedBits.grpACINTS

#define PRACMP1CS_ACIEN_MASK            1
#define PRACMP1CS_ACINTS0_MASK          2
#define PRACMP1CS_ACINTS1_MASK          4
#define PRACMP1CS_ACMPO_MASK            8
#define PRACMP1CS_ACOPE_MASK            16
#define PRACMP1CS_ACMPF_MASK            64
#define PRACMP1CS_ACEN_MASK             128
#define PRACMP1CS_ACINTS_MASK           6
#define PRACMP1CS_ACINTS_BITNUM         1


/*** PRACMP1C0 - PRACMP1 Control 0 Register; 0x00001929 ***/
typedef union {
  byte Byte;
  struct {
    byte ACNSEL0     :1;                                       /* ACMP Negative Input Select, bit 0 */
    byte ACNSEL1     :1;                                       /* ACMP Negative Input Select, bit 1 */
    byte ACNSEL2     :1;                                       /* ACMP Negative Input Select, bit 2 */
    byte             :1; 
    byte ACPSEL0     :1;                                       /* ACMP Positive Input Select, bit 0 */
    byte ACPSEL1     :1;                                       /* ACMP Positive Input Select, bit 1 */
    byte ACPSEL2     :1;                                       /* ACMP Positive Input Select, bit 2 */
    byte             :1; 
  } Bits;
  struct {
    byte grpACNSEL :3;
    byte         :1;
    byte grpACPSEL :3;
    byte         :1;
  } MergedBits;
} PRACMP1C0STR;
extern volatile PRACMP1C0STR _PRACMP1C0 @0x00001929;
#define PRACMP1C0                       _PRACMP1C0.Byte
#define PRACMP1C0_ACNSEL0               _PRACMP1C0.Bits.ACNSEL0
#define PRACMP1C0_ACNSEL1               _PRACMP1C0.Bits.ACNSEL1
#define PRACMP1C0_ACNSEL2               _PRACMP1C0.Bits.ACNSEL2
#define PRACMP1C0_ACPSEL0               _PRACMP1C0.Bits.ACPSEL0
#define PRACMP1C0_ACPSEL1               _PRACMP1C0.Bits.ACPSEL1
#define PRACMP1C0_ACPSEL2               _PRACMP1C0.Bits.ACPSEL2
/* PRACMP1C_ARR: Access 3 PRACMP1Cx registers in an array */
#define PRACMP1C_ARR                    ((volatile byte * __far) &PRACMP1C0)
#define PRACMP1C0_ACNSEL                _PRACMP1C0.MergedBits.grpACNSEL
#define PRACMP1C0_ACPSEL                _PRACMP1C0.MergedBits.grpACPSEL

#define PRACMP1C0_ACNSEL0_MASK          1
#define PRACMP1C0_ACNSEL1_MASK          2
#define PRACMP1C0_ACNSEL2_MASK          4
#define PRACMP1C0_ACPSEL0_MASK          16
#define PRACMP1C0_ACPSEL1_MASK          32
#define PRACMP1C0_ACPSEL2_MASK          64
#define PRACMP1C0_ACNSEL_MASK           7
#define PRACMP1C0_ACNSEL_BITNUM         0
#define PRACMP1C0_ACPSEL_MASK           112
#define PRACMP1C0_ACPSEL_BITNUM         4


/*** PRACMP1C1 - PRACMP1 Control 1 Register; 0x0000192A ***/
typedef union {
  byte Byte;
  struct {
    byte PRGOS0      :1;                                       /* Programmable Reference Generator Output Selection, bit 0 */
    byte PRGOS1      :1;                                       /* Programmable Reference Generator Output Selection, bit 1 */
    byte PRGOS2      :1;                                       /* Programmable Reference Generator Output Selection, bit 2 */
    byte PRGOS3      :1;                                       /* Programmable Reference Generator Output Selection, bit 3 */
    byte PRGOS4      :1;                                       /* Programmable Reference Generator Output Selection, bit 4 */
    byte             :1; 
    byte PRGINS      :1;                                       /* Programmable Reference Generator Input Selection */
    byte PRGEN       :1;                                       /* Programmable Reference Generator Enable */
  } Bits;
  struct {
    byte grpPRGOS :5;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PRACMP1C1STR;
extern volatile PRACMP1C1STR _PRACMP1C1 @0x0000192A;
#define PRACMP1C1                       _PRACMP1C1.Byte
#define PRACMP1C1_PRGOS0                _PRACMP1C1.Bits.PRGOS0
#define PRACMP1C1_PRGOS1                _PRACMP1C1.Bits.PRGOS1
#define PRACMP1C1_PRGOS2                _PRACMP1C1.Bits.PRGOS2
#define PRACMP1C1_PRGOS3                _PRACMP1C1.Bits.PRGOS3
#define PRACMP1C1_PRGOS4                _PRACMP1C1.Bits.PRGOS4
#define PRACMP1C1_PRGINS                _PRACMP1C1.Bits.PRGINS
#define PRACMP1C1_PRGEN                 _PRACMP1C1.Bits.PRGEN
#define PRACMP1C1_PRGOS                 _PRACMP1C1.MergedBits.grpPRGOS

#define PRACMP1C1_PRGOS0_MASK           1
#define PRACMP1C1_PRGOS1_MASK           2
#define PRACMP1C1_PRGOS2_MASK           4
#define PRACMP1C1_PRGOS3_MASK           8
#define PRACMP1C1_PRGOS4_MASK           16
#define PRACMP1C1_PRGINS_MASK           64
#define PRACMP1C1_PRGEN_MASK            128
#define PRACMP1C1_PRGOS_MASK            31
#define PRACMP1C1_PRGOS_BITNUM          0


/*** PRACMP1C2 - PRACMP1 Control 2 Register; 0x0000192B ***/
typedef union {
  byte Byte;
  struct {
    byte ACIPE0      :1;                                       /* ACMP Input Pin 0 Enable - ACIPE0 is used to control the PRACMP external pin 0 as analog input */
    byte ACIPE1      :1;                                       /* ACMP Input Pin 1 Enable - ACIPE1 is used to control the PRACMP external pin 1 as analog input */
    byte ACIPE2      :1;                                       /* ACMP Input Pin 2 Enable - ACIPE2 is used to control the PRACMP external pin 2 as analog input */
    byte ACIPE3      :1;                                       /* ACMP Input Pin 3 Enable - ACIPE3 is used to control the PRACMP external pin 3 as analog input */
    byte ACIPE4      :1;                                       /* ACMP Input Pin 4 Enable - ACIPE4 is used to control the PRACMP external pin 4 as analog input */
    byte ACIPE5      :1;                                       /* ACMP Input Pin 5 Enable - ACIPE5 is used to control the PRACMP external pin 5 as analog input */
    byte ACIPE6      :1;                                       /* ACMP Input Pin 6 Enable - ACIPE6 is used to control the PRACMP external pin 6 as analog input */
    byte             :1; 
  } Bits;
  struct {
    byte grpACIPE :7;
    byte         :1;
  } MergedBits;
} PRACMP1C2STR;
extern volatile PRACMP1C2STR _PRACMP1C2 @0x0000192B;
#define PRACMP1C2                       _PRACMP1C2.Byte
#define PRACMP1C2_ACIPE0                _PRACMP1C2.Bits.ACIPE0
#define PRACMP1C2_ACIPE1                _PRACMP1C2.Bits.ACIPE1
#define PRACMP1C2_ACIPE2                _PRACMP1C2.Bits.ACIPE2
#define PRACMP1C2_ACIPE3                _PRACMP1C2.Bits.ACIPE3
#define PRACMP1C2_ACIPE4                _PRACMP1C2.Bits.ACIPE4
#define PRACMP1C2_ACIPE5                _PRACMP1C2.Bits.ACIPE5
#define PRACMP1C2_ACIPE6                _PRACMP1C2.Bits.ACIPE6
#define PRACMP1C2_ACIPE                 _PRACMP1C2.MergedBits.grpACIPE

#define PRACMP1C2_ACIPE0_MASK           1
#define PRACMP1C2_ACIPE1_MASK           2
#define PRACMP1C2_ACIPE2_MASK           4
#define PRACMP1C2_ACIPE3_MASK           8
#define PRACMP1C2_ACIPE4_MASK           16
#define PRACMP1C2_ACIPE5_MASK           32
#define PRACMP1C2_ACIPE6_MASK           64
#define PRACMP1C2_ACIPE_MASK            127
#define PRACMP1C2_ACIPE_BITNUM          0


/*** PRACMP2CS - PRACMP2 Control and Status Register; 0x0000192C ***/
typedef union {
  byte Byte;
  struct {
    byte ACIEN       :1;                                       /* ACMP Interrupt Enable */
    byte ACINTS0     :1;                                       /* ACMP Interrupt Select, bit 0 */
    byte ACINTS1     :1;                                       /* ACMP Interrupt Select, bit 1 */
    byte ACMPO       :1;                                       /* ACMP Output Bit */
    byte ACOPE       :1;                                       /* ACMP Output Pin Enable */
    byte             :1; 
    byte ACMPF       :1;                                       /* ACMP Interrupt Flag */
    byte ACEN        :1;                                       /* ACMP Module Enable */
  } Bits;
  struct {
    byte         :1;
    byte grpACINTS :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PRACMP2CSSTR;
extern volatile PRACMP2CSSTR _PRACMP2CS @0x0000192C;
#define PRACMP2CS                       _PRACMP2CS.Byte
#define PRACMP2CS_ACIEN                 _PRACMP2CS.Bits.ACIEN
#define PRACMP2CS_ACINTS0               _PRACMP2CS.Bits.ACINTS0
#define PRACMP2CS_ACINTS1               _PRACMP2CS.Bits.ACINTS1
#define PRACMP2CS_ACMPO                 _PRACMP2CS.Bits.ACMPO
#define PRACMP2CS_ACOPE                 _PRACMP2CS.Bits.ACOPE
#define PRACMP2CS_ACMPF                 _PRACMP2CS.Bits.ACMPF
#define PRACMP2CS_ACEN                  _PRACMP2CS.Bits.ACEN
#define PRACMP2CS_ACINTS                _PRACMP2CS.MergedBits.grpACINTS

#define PRACMP2CS_ACIEN_MASK            1
#define PRACMP2CS_ACINTS0_MASK          2
#define PRACMP2CS_ACINTS1_MASK          4
#define PRACMP2CS_ACMPO_MASK            8
#define PRACMP2CS_ACOPE_MASK            16
#define PRACMP2CS_ACMPF_MASK            64
#define PRACMP2CS_ACEN_MASK             128
#define PRACMP2CS_ACINTS_MASK           6
#define PRACMP2CS_ACINTS_BITNUM         1


/*** PRACMP2C0 - PRACMP2 Control 0 Register; 0x0000192D ***/
typedef union {
  byte Byte;
  struct {
    byte ACNSEL0     :1;                                       /* ACMP Negative Input Select, bit 0 */
    byte ACNSEL1     :1;                                       /* ACMP Negative Input Select, bit 1 */
    byte ACNSEL2     :1;                                       /* ACMP Negative Input Select, bit 2 */
    byte             :1; 
    byte ACPSEL0     :1;                                       /* ACMP Positive Input Select, bit 0 */
    byte ACPSEL1     :1;                                       /* ACMP Positive Input Select, bit 1 */
    byte ACPSEL2     :1;                                       /* ACMP Positive Input Select, bit 2 */
    byte             :1; 
  } Bits;
  struct {
    byte grpACNSEL :3;
    byte         :1;
    byte grpACPSEL :3;
    byte         :1;
  } MergedBits;
} PRACMP2C0STR;
extern volatile PRACMP2C0STR _PRACMP2C0 @0x0000192D;
#define PRACMP2C0                       _PRACMP2C0.Byte
#define PRACMP2C0_ACNSEL0               _PRACMP2C0.Bits.ACNSEL0
#define PRACMP2C0_ACNSEL1               _PRACMP2C0.Bits.ACNSEL1
#define PRACMP2C0_ACNSEL2               _PRACMP2C0.Bits.ACNSEL2
#define PRACMP2C0_ACPSEL0               _PRACMP2C0.Bits.ACPSEL0
#define PRACMP2C0_ACPSEL1               _PRACMP2C0.Bits.ACPSEL1
#define PRACMP2C0_ACPSEL2               _PRACMP2C0.Bits.ACPSEL2
/* PRACMP2C_ARR: Access 3 PRACMP2Cx registers in an array */
#define PRACMP2C_ARR                    ((volatile byte * __far) &PRACMP2C0)
#define PRACMP2C0_ACNSEL                _PRACMP2C0.MergedBits.grpACNSEL
#define PRACMP2C0_ACPSEL                _PRACMP2C0.MergedBits.grpACPSEL

#define PRACMP2C0_ACNSEL0_MASK          1
#define PRACMP2C0_ACNSEL1_MASK          2
#define PRACMP2C0_ACNSEL2_MASK          4
#define PRACMP2C0_ACPSEL0_MASK          16
#define PRACMP2C0_ACPSEL1_MASK          32
#define PRACMP2C0_ACPSEL2_MASK          64
#define PRACMP2C0_ACNSEL_MASK           7
#define PRACMP2C0_ACNSEL_BITNUM         0
#define PRACMP2C0_ACPSEL_MASK           112
#define PRACMP2C0_ACPSEL_BITNUM         4


/*** PRACMP2C1 - PRACMP2 Control 1 Register; 0x0000192E ***/
typedef union {
  byte Byte;
  struct {
    byte PRGOS0      :1;                                       /* Programmable Reference Generator Output Selection, bit 0 */
    byte PRGOS1      :1;                                       /* Programmable Reference Generator Output Selection, bit 1 */
    byte PRGOS2      :1;                                       /* Programmable Reference Generator Output Selection, bit 2 */
    byte PRGOS3      :1;                                       /* Programmable Reference Generator Output Selection, bit 3 */
    byte PRGOS4      :1;                                       /* Programmable Reference Generator Output Selection, bit 4 */
    byte             :1; 
    byte PRGINS      :1;                                       /* Programmable Reference Generator Input Selection */
    byte PRGEN       :1;                                       /* Programmable Reference Generator Enable */
  } Bits;
  struct {
    byte grpPRGOS :5;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} PRACMP2C1STR;
extern volatile PRACMP2C1STR _PRACMP2C1 @0x0000192E;
#define PRACMP2C1                       _PRACMP2C1.Byte
#define PRACMP2C1_PRGOS0                _PRACMP2C1.Bits.PRGOS0
#define PRACMP2C1_PRGOS1                _PRACMP2C1.Bits.PRGOS1
#define PRACMP2C1_PRGOS2                _PRACMP2C1.Bits.PRGOS2
#define PRACMP2C1_PRGOS3                _PRACMP2C1.Bits.PRGOS3
#define PRACMP2C1_PRGOS4                _PRACMP2C1.Bits.PRGOS4
#define PRACMP2C1_PRGINS                _PRACMP2C1.Bits.PRGINS
#define PRACMP2C1_PRGEN                 _PRACMP2C1.Bits.PRGEN
#define PRACMP2C1_PRGOS                 _PRACMP2C1.MergedBits.grpPRGOS

#define PRACMP2C1_PRGOS0_MASK           1
#define PRACMP2C1_PRGOS1_MASK           2
#define PRACMP2C1_PRGOS2_MASK           4
#define PRACMP2C1_PRGOS3_MASK           8
#define PRACMP2C1_PRGOS4_MASK           16
#define PRACMP2C1_PRGINS_MASK           64
#define PRACMP2C1_PRGEN_MASK            128
#define PRACMP2C1_PRGOS_MASK            31
#define PRACMP2C1_PRGOS_BITNUM          0


/*** PRACMP2C2 - PRACMP2 Control 2 Register; 0x0000192F ***/
typedef union {
  byte Byte;
  struct {
    byte ACIPE0      :1;                                       /* ACMP Input Pin 0 Enable - ACIPE0 is used to control the PRACMP external pin 0 as analog input */
    byte ACIPE1      :1;                                       /* ACMP Input Pin 1 Enable - ACIPE1 is used to control the PRACMP external pin 1 as analog input */
    byte ACIPE2      :1;                                       /* ACMP Input Pin 2 Enable - ACIPE2 is used to control the PRACMP external pin 2 as analog input */
    byte ACIPE3      :1;                                       /* ACMP Input Pin 3 Enable - ACIPE3 is used to control the PRACMP external pin 3 as analog input */
    byte ACIPE4      :1;                                       /* ACMP Input Pin 4 Enable - ACIPE4 is used to control the PRACMP external pin 4 as analog input */
    byte ACIPE5      :1;                                       /* ACMP Input Pin 5 Enable - ACIPE5 is used to control the PRACMP external pin 5 as analog input */
    byte ACIPE6      :1;                                       /* ACMP Input Pin 6 Enable - ACIPE6 is used to control the PRACMP external pin 6 as analog input */
    byte             :1; 
  } Bits;
  struct {
    byte grpACIPE :7;
    byte         :1;
  } MergedBits;
} PRACMP2C2STR;
extern volatile PRACMP2C2STR _PRACMP2C2 @0x0000192F;
#define PRACMP2C2                       _PRACMP2C2.Byte
#define PRACMP2C2_ACIPE0                _PRACMP2C2.Bits.ACIPE0
#define PRACMP2C2_ACIPE1                _PRACMP2C2.Bits.ACIPE1
#define PRACMP2C2_ACIPE2                _PRACMP2C2.Bits.ACIPE2
#define PRACMP2C2_ACIPE3                _PRACMP2C2.Bits.ACIPE3
#define PRACMP2C2_ACIPE4                _PRACMP2C2.Bits.ACIPE4
#define PRACMP2C2_ACIPE5                _PRACMP2C2.Bits.ACIPE5
#define PRACMP2C2_ACIPE6                _PRACMP2C2.Bits.ACIPE6
#define PRACMP2C2_ACIPE                 _PRACMP2C2.MergedBits.grpACIPE

#define PRACMP2C2_ACIPE0_MASK           1
#define PRACMP2C2_ACIPE1_MASK           2
#define PRACMP2C2_ACIPE2_MASK           4
#define PRACMP2C2_ACIPE3_MASK           8
#define PRACMP2C2_ACIPE4_MASK           16
#define PRACMP2C2_ACIPE5_MASK           32
#define PRACMP2C2_ACIPE6_MASK           64
#define PRACMP2C2_ACIPE_MASK            127
#define PRACMP2C2_ACIPE_BITNUM          0


/*** VREFTRM - VREF Trim Register; 0x00001930 ***/
typedef union {
  byte Byte;
  struct {
    byte TRM0        :1;                                       /* Trim Bits, bit 0 */
    byte TRM1        :1;                                       /* Trim Bits, bit 1 */
    byte TRM2        :1;                                       /* Trim Bits, bit 2 */
    byte TRM3        :1;                                       /* Trim Bits, bit 3 */
    byte TRM4        :1;                                       /* Trim Bits, bit 4 */
    byte TRM5        :1;                                       /* Trim Bits, bit 5 */
    byte TRM6        :1;                                       /* Trim Bits, bit 6 */
    byte TRM7        :1;                                       /* Trim Bits, bit 7 */
  } Bits;
} VREFTRMSTR;
extern volatile VREFTRMSTR _VREFTRM @0x00001930;
#define VREFTRM                         _VREFTRM.Byte
#define VREFTRM_TRM0                    _VREFTRM.Bits.TRM0
#define VREFTRM_TRM1                    _VREFTRM.Bits.TRM1
#define VREFTRM_TRM2                    _VREFTRM.Bits.TRM2
#define VREFTRM_TRM3                    _VREFTRM.Bits.TRM3
#define VREFTRM_TRM4                    _VREFTRM.Bits.TRM4
#define VREFTRM_TRM5                    _VREFTRM.Bits.TRM5
#define VREFTRM_TRM6                    _VREFTRM.Bits.TRM6
#define VREFTRM_TRM7                    _VREFTRM.Bits.TRM7

#define VREFTRM_TRM0_MASK               1
#define VREFTRM_TRM1_MASK               2
#define VREFTRM_TRM2_MASK               4
#define VREFTRM_TRM3_MASK               8
#define VREFTRM_TRM4_MASK               16
#define VREFTRM_TRM5_MASK               32
#define VREFTRM_TRM6_MASK               64
#define VREFTRM_TRM7_MASK               128


/*** VREFSC - VREF Control Register; 0x00001931 ***/
typedef union {
  byte Byte;
  struct {
    byte MODE0       :1;                                       /* Mode selection, bit 0 */
    byte MODE1       :1;                                       /* Mode selection, bit 1 */
    byte VREFST      :1;                                       /* Internal Voltage Reference Stable */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte VREFEN      :1;                                       /* Internal Voltage Reference Enable */
  } Bits;
  struct {
    byte grpMODE :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} VREFSCSTR;
extern volatile VREFSCSTR _VREFSC @0x00001931;
#define VREFSC                          _VREFSC.Byte
#define VREFSC_MODE0                    _VREFSC.Bits.MODE0
#define VREFSC_MODE1                    _VREFSC.Bits.MODE1
#define VREFSC_VREFST                   _VREFSC.Bits.VREFST
#define VREFSC_VREFEN                   _VREFSC.Bits.VREFEN
#define VREFSC_MODE                     _VREFSC.MergedBits.grpMODE

#define VREFSC_MODE0_MASK               1
#define VREFSC_MODE1_MASK               2
#define VREFSC_VREFST_MASK              4
#define VREFSC_VREFEN_MASK              128
#define VREFSC_MODE_MASK                3
#define VREFSC_MODE_BITNUM              0


/*** PTAPF1 - Port A Routing Register 1; 0x00001940 ***/
typedef union {
  byte Byte;
  struct {
    byte A0          :3;                                       /* Port PTA0 Pin Mux Controls */
    byte             :1; 
    byte A1          :3;                                       /* Port PTA1 Pin Mux Controls */
    byte             :1; 
  } Bits;
} PTAPF1STR;
extern volatile PTAPF1STR _PTAPF1 @0x00001940;
#define PTAPF1                          _PTAPF1.Byte
#define PTAPF1_A0                       _PTAPF1.Bits.A0
#define PTAPF1_A1                       _PTAPF1.Bits.A1

#define PTAPF1_A0_MASK                  7
#define PTAPF1_A0_BITNUM                0
#define PTAPF1_A1_MASK                  112
#define PTAPF1_A1_BITNUM                4


/*** PTAPF2 - Port A Routing Register 2; 0x00001941 ***/
typedef union {
  byte Byte;
  struct {
    byte A2          :3;                                       /* Port PTA2 Pin Mux Controls */
    byte             :1; 
    byte A3          :3;                                       /* Port PTA3 Pin Mux Controls */
    byte             :1; 
  } Bits;
} PTAPF2STR;
extern volatile PTAPF2STR _PTAPF2 @0x00001941;
#define PTAPF2                          _PTAPF2.Byte
#define PTAPF2_A2                       _PTAPF2.Bits.A2
#define PTAPF2_A3                       _PTAPF2.Bits.A3

#define PTAPF2_A2_MASK                  7
#define PTAPF2_A2_BITNUM                0
#define PTAPF2_A3_MASK                  112
#define PTAPF2_A3_BITNUM                4


/*** PTAPF3 - Port A Routing Register 3; 0x00001942 ***/
typedef union {
  byte Byte;
  struct {
    byte A4          :3;                                       /* Port PTA4 Pin Mux Controls */
    byte             :1; 
    byte A5          :3;                                       /* Port PTA5 Pin Mux Controls */
    byte             :1; 
  } Bits;
} PTAPF3STR;
extern volatile PTAPF3STR _PTAPF3 @0x00001942;
#define PTAPF3                          _PTAPF3.Byte
#define PTAPF3_A4                       _PTAPF3.Bits.A4
#define PTAPF3_A5                       _PTAPF3.Bits.A5

#define PTAPF3_A4_MASK                  7
#define PTAPF3_A4_BITNUM                0
#define PTAPF3_A5_MASK                  112
#define PTAPF3_A5_BITNUM                4


/*** PTAPF4 - Port A Routing Register 4; 0x00001943 ***/
typedef union {
  byte Byte;
  struct {
    byte A0          :3;                                       /* Port PTA0 Pin Mux Controls */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} PTAPF4STR;
extern volatile PTAPF4STR _PTAPF4 @0x00001943;
#define PTAPF4                          _PTAPF4.Byte
#define PTAPF4_A0                       _PTAPF4.Bits.A0

#define PTAPF4_A0_MASK                  7
#define PTAPF4_A0_BITNUM                0


/*** PTBPF1 - Port B Routing Register 1; 0x00001944 ***/
typedef union {
  byte Byte;
  struct {
    byte B0          :3;                                       /* Port PTB0 Pin Mux Controls */
    byte             :1; 
    byte B1          :3;                                       /* Port PTB1 Pin Mux Controls */
    byte             :1; 
  } Bits;
} PTBPF1STR;
extern volatile PTBPF1STR _PTBPF1 @0x00001944;
#define PTBPF1                          _PTBPF1.Byte
#define PTBPF1_B0                       _PTBPF1.Bits.B0
#define PTBPF1_B1                       _PTBPF1.Bits.B1

#define PTBPF1_B0_MASK                  7
#define PTBPF1_B0_BITNUM                0
#define PTBPF1_B1_MASK                  112
#define PTBPF1_B1_BITNUM                4


/*** PTBPF2 - Port B Routing Register 2; 0x00001945 ***/
typedef union {
  byte Byte;
  struct {
    byte B2          :3;                                       /* Port PTB2 Pin Mux Controls */
    byte             :1; 
    byte B3          :3;                                       /* Port PTB3 Pin Mux Controls */
    byte             :1; 
  } Bits;
} PTBPF2STR;
extern volatile PTBPF2STR _PTBPF2 @0x00001945;
#define PTBPF2                          _PTBPF2.Byte
#define PTBPF2_B2                       _PTBPF2.Bits.B2
#define PTBPF2_B3                       _PTBPF2.Bits.B3

#define PTBPF2_B2_MASK                  7
#define PTBPF2_B2_BITNUM                0
#define PTBPF2_B3_MASK                  112
#define PTBPF2_B3_BITNUM                4


/*** PTBPF3 - Port B Routing Register 3; 0x00001946 ***/
typedef union {
  byte Byte;
  struct {
    byte B4          :3;                                       /* Port PTB4 Pin Mux Controls */
    byte             :1; 
    byte B5          :3;                                       /* Port PTB5 Pin Mux Controls */
    byte             :1; 
  } Bits;
} PTBPF3STR;
extern volatile PTBPF3STR _PTBPF3 @0x00001946;
#define PTBPF3                          _PTBPF3.Byte
#define PTBPF3_B4                       _PTBPF3.Bits.B4
#define PTBPF3_B5                       _PTBPF3.Bits.B5

#define PTBPF3_B4_MASK                  7
#define PTBPF3_B4_BITNUM                0
#define PTBPF3_B5_MASK                  112
#define PTBPF3_B5_BITNUM                4


/*** PTBPF4 - Port B Routing Register 4; 0x00001947 ***/
typedef union {
  byte Byte;
  struct {
    byte B0          :3;                                       /* Port PTB0 Pin Mux Controls */
    byte             :1; 
    byte B1          :3;                                       /* Port PTB1 Pin Mux Controls */
    byte             :1; 
  } Bits;
} PTBPF4STR;
extern volatile PTBPF4STR _PTBPF4 @0x00001947;
#define PTBPF4                          _PTBPF4.Byte
#define PTBPF4_B0                       _PTBPF4.Bits.B0
#define PTBPF4_B1                       _PTBPF4.Bits.B1

#define PTBPF4_B0_MASK                  7
#define PTBPF4_B0_BITNUM                0
#define PTBPF4_B1_MASK                  112
#define PTBPF4_B1_BITNUM                4


/*** PTCPF1 - Port C Routing Register 1; 0x00001948 ***/
typedef union {
  byte Byte;
  struct {
    byte C0          :3;                                       /* Port PTC0 Pin Mux Controls */
    byte             :1; 
    byte C1          :3;                                       /* Port PTC1 Pin Mux Controls */
    byte             :1; 
  } Bits;
} PTCPF1STR;
extern volatile PTCPF1STR _PTCPF1 @0x00001948;
#define PTCPF1                          _PTCPF1.Byte
#define PTCPF1_C0                       _PTCPF1.Bits.C0
#define PTCPF1_C1                       _PTCPF1.Bits.C1

#define PTCPF1_C0_MASK                  7
#define PTCPF1_C0_BITNUM                0
#define PTCPF1_C1_MASK                  112
#define PTCPF1_C1_BITNUM                4


/*** PTCPF2 - Port C Routing Register 2; 0x00001949 ***/
typedef union {
  byte Byte;
  struct {
    byte C2          :3;                                       /* Port PTC2 Pin Mux Controls */
    byte             :1; 
    byte C3          :3;                                       /* Port PTC3 Pin Mux Controls */
    byte             :1; 
  } Bits;
} PTCPF2STR;
extern volatile PTCPF2STR _PTCPF2 @0x00001949;
#define PTCPF2                          _PTCPF2.Byte
#define PTCPF2_C2                       _PTCPF2.Bits.C2
#define PTCPF2_C3                       _PTCPF2.Bits.C3

#define PTCPF2_C2_MASK                  7
#define PTCPF2_C2_BITNUM                0
#define PTCPF2_C3_MASK                  112
#define PTCPF2_C3_BITNUM                4


/*** PTCPF3 - Port C Routing Register 3; 0x0000194A ***/
typedef union {
  byte Byte;
  struct {
    byte C4          :3;                                       /* Port PTC4 Pin Mux Controls */
    byte             :1; 
    byte C5          :3;                                       /* Port PTC5 Pin Mux Controls */
    byte             :1; 
  } Bits;
} PTCPF3STR;
extern volatile PTCPF3STR _PTCPF3 @0x0000194A;
#define PTCPF3                          _PTCPF3.Byte
#define PTCPF3_C4                       _PTCPF3.Bits.C4
#define PTCPF3_C5                       _PTCPF3.Bits.C5

#define PTCPF3_C4_MASK                  7
#define PTCPF3_C4_BITNUM                0
#define PTCPF3_C5_MASK                  112
#define PTCPF3_C5_BITNUM                4


/*** PTCPF4 - Port C Routing Register 4; 0x0000194B ***/
typedef union {
  byte Byte;
  struct {
    byte C0          :3;                                       /* Port PTC0 Pin Mux Controls */
    byte             :1; 
    byte C1          :3;                                       /* Port PTC1 Pin Mux Controls */
    byte             :1; 
  } Bits;
} PTCPF4STR;
extern volatile PTCPF4STR _PTCPF4 @0x0000194B;
#define PTCPF4                          _PTCPF4.Byte
#define PTCPF4_C0                       _PTCPF4.Bits.C0
#define PTCPF4_C1                       _PTCPF4.Bits.C1

#define PTCPF4_C0_MASK                  7
#define PTCPF4_C0_BITNUM                0
#define PTCPF4_C1_MASK                  112
#define PTCPF4_C1_BITNUM                4


/*** PTDPF1 - Port D Routing Register 1; 0x0000194C ***/
typedef union {
  byte Byte;
  struct {
    byte D0          :3;                                       /* Port PTD0 Pin Mux Controls */
    byte             :1; 
    byte D1          :3;                                       /* Port PTD1 Pin Mux Controls */
    byte             :1; 
  } Bits;
} PTDPF1STR;
extern volatile PTDPF1STR _PTDPF1 @0x0000194C;
#define PTDPF1                          _PTDPF1.Byte
#define PTDPF1_D0                       _PTDPF1.Bits.D0
#define PTDPF1_D1                       _PTDPF1.Bits.D1

#define PTDPF1_D0_MASK                  7
#define PTDPF1_D0_BITNUM                0
#define PTDPF1_D1_MASK                  112
#define PTDPF1_D1_BITNUM                4


/*** PTDPF2 - Port D Routing Register 2; 0x0000194D ***/
typedef union {
  byte Byte;
  struct {
    byte D2          :3;                                       /* Port PTD2 Pin Mux Controls */
    byte             :1; 
    byte D3          :3;                                       /* Port PTD3 Pin Mux Controls */
    byte             :1; 
  } Bits;
} PTDPF2STR;
extern volatile PTDPF2STR _PTDPF2 @0x0000194D;
#define PTDPF2                          _PTDPF2.Byte
#define PTDPF2_D2                       _PTDPF2.Bits.D2
#define PTDPF2_D3                       _PTDPF2.Bits.D3

#define PTDPF2_D2_MASK                  7
#define PTDPF2_D2_BITNUM                0
#define PTDPF2_D3_MASK                  112
#define PTDPF2_D3_BITNUM                4


/*** PTDPF3 - Port D Routing Register 3; 0x0000194E ***/
typedef union {
  byte Byte;
  struct {
    byte D4          :3;                                       /* Port PTD4 Pin Mux Controls */
    byte             :1; 
    byte D5          :3;                                       /* Port PTD5 Pin Mux Controls */
    byte             :1; 
  } Bits;
} PTDPF3STR;
extern volatile PTDPF3STR _PTDPF3 @0x0000194E;
#define PTDPF3                          _PTDPF3.Byte
#define PTDPF3_D4                       _PTDPF3.Bits.D4
#define PTDPF3_D5                       _PTDPF3.Bits.D5

#define PTDPF3_D4_MASK                  7
#define PTDPF3_D4_BITNUM                0
#define PTDPF3_D5_MASK                  112
#define PTDPF3_D5_BITNUM                4


/*** PTDPF4 - Port D Routing Register 4; 0x0000194F ***/
typedef union {
  byte Byte;
  struct {
    byte D0          :3;                                       /* Port PTD0 Pin Mux Controls */
    byte             :1; 
    byte D1          :3;                                       /* Port PTD1 Pin Mux Controls */
    byte             :1; 
  } Bits;
} PTDPF4STR;
extern volatile PTDPF4STR _PTDPF4 @0x0000194F;
#define PTDPF4                          _PTDPF4.Byte
#define PTDPF4_D0                       _PTDPF4.Bits.D0
#define PTDPF4_D1                       _PTDPF4.Bits.D1

#define PTDPF4_D0_MASK                  7
#define PTDPF4_D0_BITNUM                0
#define PTDPF4_D1_MASK                  112
#define PTDPF4_D1_BITNUM                4


/*** PTEPF1 - Port E Routing Register 1; 0x00001950 ***/
typedef union {
  byte Byte;
  struct {
    byte E0          :3;                                       /* Port PTE0 Pin Mux Controls */
    byte             :1; 
    byte E1          :3;                                       /* Port PTE1 Pin Mux Controls */
    byte             :1; 
  } Bits;
} PTEPF1STR;
extern volatile PTEPF1STR _PTEPF1 @0x00001950;
#define PTEPF1                          _PTEPF1.Byte
#define PTEPF1_E0                       _PTEPF1.Bits.E0
#define PTEPF1_E1                       _PTEPF1.Bits.E1

#define PTEPF1_E0_MASK                  7
#define PTEPF1_E0_BITNUM                0
#define PTEPF1_E1_MASK                  112
#define PTEPF1_E1_BITNUM                4


/*** PTEPF2 - Port E Routing Register 2; 0x00001951 ***/
typedef union {
  byte Byte;
  struct {
    byte E2          :3;                                       /* Port PTE2 Pin Mux Controls */
    byte             :1; 
    byte E3          :3;                                       /* Port PTE3 Pin Mux Controls */
    byte             :1; 
  } Bits;
} PTEPF2STR;
extern volatile PTEPF2STR _PTEPF2 @0x00001951;
#define PTEPF2                          _PTEPF2.Byte
#define PTEPF2_E2                       _PTEPF2.Bits.E2
#define PTEPF2_E3                       _PTEPF2.Bits.E3

#define PTEPF2_E2_MASK                  7
#define PTEPF2_E2_BITNUM                0
#define PTEPF2_E3_MASK                  112
#define PTEPF2_E3_BITNUM                4


/*** PTEPF3 - Port E Routing Register 3; 0x00001952 ***/
typedef union {
  byte Byte;
  struct {
    byte E4          :3;                                       /* Port PTE4 Pin Mux Controls */
    byte             :1; 
    byte E5          :3;                                       /* Port PTE5 Pin Mux Controls */
    byte             :1; 
  } Bits;
} PTEPF3STR;
extern volatile PTEPF3STR _PTEPF3 @0x00001952;
#define PTEPF3                          _PTEPF3.Byte
#define PTEPF3_E4                       _PTEPF3.Bits.E4
#define PTEPF3_E5                       _PTEPF3.Bits.E5

#define PTEPF3_E4_MASK                  7
#define PTEPF3_E4_BITNUM                0
#define PTEPF3_E5_MASK                  112
#define PTEPF3_E5_BITNUM                4


/*** PTEPF4 - Port E Routing Register 4; 0x00001953 ***/
typedef union {
  byte Byte;
  struct {
    byte E0          :3;                                       /* Port PTE0 Pin Mux Controls */
    byte             :1; 
    byte E1          :3;                                       /* Port PTE1 Pin Mux Controls */
    byte             :1; 
  } Bits;
} PTEPF4STR;
extern volatile PTEPF4STR _PTEPF4 @0x00001953;
#define PTEPF4                          _PTEPF4.Byte
#define PTEPF4_E0                       _PTEPF4.Bits.E0
#define PTEPF4_E1                       _PTEPF4.Bits.E1

#define PTEPF4_E0_MASK                  7
#define PTEPF4_E0_BITNUM                0
#define PTEPF4_E1_MASK                  112
#define PTEPF4_E1_BITNUM                4


/*** PTFPF1 - Port F Routing Register 1; 0x00001954 ***/
typedef union {
  byte Byte;
  struct {
    byte F0          :3;                                       /* Port PTF0 Pin Mux Controls */
    byte             :1; 
    byte F1          :3;                                       /* Port PTF1 Pin Mux Controls */
    byte             :1; 
  } Bits;
} PTFPF1STR;
extern volatile PTFPF1STR _PTFPF1 @0x00001954;
#define PTFPF1                          _PTFPF1.Byte
#define PTFPF1_F0                       _PTFPF1.Bits.F0
#define PTFPF1_F1                       _PTFPF1.Bits.F1

#define PTFPF1_F0_MASK                  7
#define PTFPF1_F0_BITNUM                0
#define PTFPF1_F1_MASK                  112
#define PTFPF1_F1_BITNUM                4


/*** PTFPF2 - Port F Routing Register 2; 0x00001955 ***/
typedef union {
  byte Byte;
  struct {
    byte F2          :3;                                       /* Port PTF2 Pin Mux Controls */
    byte             :1; 
    byte F3          :3;                                       /* Port PTF3 Pin Mux Controls */
    byte             :1; 
  } Bits;
} PTFPF2STR;
extern volatile PTFPF2STR _PTFPF2 @0x00001955;
#define PTFPF2                          _PTFPF2.Byte
#define PTFPF2_F2                       _PTFPF2.Bits.F2
#define PTFPF2_F3                       _PTFPF2.Bits.F3

#define PTFPF2_F2_MASK                  7
#define PTFPF2_F2_BITNUM                0
#define PTFPF2_F3_MASK                  112
#define PTFPF2_F3_BITNUM                4


/*** PTFPF3 - Port F Routing Register 3; 0x00001956 ***/
typedef union {
  byte Byte;
  struct {
    byte F4          :3;                                       /* Port PTF4 Pin Mux Controls */
    byte             :1; 
    byte F5          :3;                                       /* Port PTF5 Pin Mux Controls */
    byte             :1; 
  } Bits;
} PTFPF3STR;
extern volatile PTFPF3STR _PTFPF3 @0x00001956;
#define PTFPF3                          _PTFPF3.Byte
#define PTFPF3_F4                       _PTFPF3.Bits.F4
#define PTFPF3_F5                       _PTFPF3.Bits.F5

#define PTFPF3_F4_MASK                  7
#define PTFPF3_F4_BITNUM                0
#define PTFPF3_F5_MASK                  112
#define PTFPF3_F5_BITNUM                4


/*** PTFPF4 - Port F Routing Register 4; 0x00001957 ***/
typedef union {
  byte Byte;
  struct {
    byte F0          :3;                                       /* Port PTF0 Pin Mux Controls */
    byte             :1; 
    byte F1          :3;                                       /* Port PTF1 Pin Mux Controls */
    byte             :1; 
  } Bits;
} PTFPF4STR;
extern volatile PTFPF4STR _PTFPF4 @0x00001957;
#define PTFPF4                          _PTFPF4.Byte
#define PTFPF4_F0                       _PTFPF4.Bits.F0
#define PTFPF4_F1                       _PTFPF4.Bits.F1

#define PTFPF4_F0_MASK                  7
#define PTFPF4_F0_BITNUM                0
#define PTFPF4_F1_MASK                  112
#define PTFPF4_F1_BITNUM                4


/*** PTGPF1 - Port G Routing Register 1; 0x00001958 ***/
typedef union {
  byte Byte;
  struct {
    byte G0          :3;                                       /* Port PTG0 Pin Mux Controls */
    byte             :1; 
    byte G1          :3;                                       /* Port PTG1 Pin Mux Controls */
    byte             :1; 
  } Bits;
} PTGPF1STR;
extern volatile PTGPF1STR _PTGPF1 @0x00001958;
#define PTGPF1                          _PTGPF1.Byte
#define PTGPF1_G0                       _PTGPF1.Bits.G0
#define PTGPF1_G1                       _PTGPF1.Bits.G1

#define PTGPF1_G0_MASK                  7
#define PTGPF1_G0_BITNUM                0
#define PTGPF1_G1_MASK                  112
#define PTGPF1_G1_BITNUM                4


/*** PTGPF2 - Port G Routing Register 2; 0x00001959 ***/
typedef union {
  byte Byte;
  struct {
    byte G2          :3;                                       /* Port PTG2 Pin Mux Controls */
    byte             :1; 
    byte G3          :3;                                       /* Port PTG3 Pin Mux Controls */
    byte             :1; 
  } Bits;
} PTGPF2STR;
extern volatile PTGPF2STR _PTGPF2 @0x00001959;
#define PTGPF2                          _PTGPF2.Byte
#define PTGPF2_G2                       _PTGPF2.Bits.G2
#define PTGPF2_G3                       _PTGPF2.Bits.G3

#define PTGPF2_G2_MASK                  7
#define PTGPF2_G2_BITNUM                0
#define PTGPF2_G3_MASK                  112
#define PTGPF2_G3_BITNUM                4


/*** PTGPF3 - Port G Routing Register 3; 0x0000195A ***/
typedef union {
  byte Byte;
  struct {
    byte G4          :3;                                       /* Port PTG4 Pin Mux Controls */
    byte             :1; 
    byte G5          :3;                                       /* Port PTG5 Pin Mux Controls */
    byte             :1; 
  } Bits;
} PTGPF3STR;
extern volatile PTGPF3STR _PTGPF3 @0x0000195A;
#define PTGPF3                          _PTGPF3.Byte
#define PTGPF3_G4                       _PTGPF3.Bits.G4
#define PTGPF3_G5                       _PTGPF3.Bits.G5

#define PTGPF3_G4_MASK                  7
#define PTGPF3_G4_BITNUM                0
#define PTGPF3_G5_MASK                  112
#define PTGPF3_G5_BITNUM                4


/*** PTGPF4 - Port G Routing Register 4; 0x0000195B ***/
typedef union {
  byte Byte;
  struct {
    byte G0          :3;                                       /* Port PTG0 Pin Mux Controls */
    byte             :1; 
    byte G1          :3;                                       /* Port PTG1 Pin Mux Controls */
    byte             :1; 
  } Bits;
} PTGPF4STR;
extern volatile PTGPF4STR _PTGPF4 @0x0000195B;
#define PTGPF4                          _PTGPF4.Byte
#define PTGPF4_G0                       _PTGPF4.Bits.G0
#define PTGPF4_G1                       _PTGPF4.Bits.G1

#define PTGPF4_G0_MASK                  7
#define PTGPF4_G0_BITNUM                0
#define PTGPF4_G1_MASK                  112
#define PTGPF4_G1_BITNUM                4


/*** PTHPF1 - Port H Routing Register 1; 0x0000195C ***/
typedef union {
  byte Byte;
  struct {
    byte H0          :3;                                       /* Port PTH0 Pin Mux Controls */
    byte             :1; 
    byte H1          :3;                                       /* Port PTH1 Pin Mux Controls */
    byte             :1; 
  } Bits;
} PTHPF1STR;
extern volatile PTHPF1STR _PTHPF1 @0x0000195C;
#define PTHPF1                          _PTHPF1.Byte
#define PTHPF1_H0                       _PTHPF1.Bits.H0
#define PTHPF1_H1                       _PTHPF1.Bits.H1

#define PTHPF1_H0_MASK                  7
#define PTHPF1_H0_BITNUM                0
#define PTHPF1_H1_MASK                  112
#define PTHPF1_H1_BITNUM                4


/*** NVVREFTRM - Non-volatile VREF Trim Register; 0x0000FFAD ***/
typedef union {
  byte Byte;
  struct {
    byte TRM0        :1;                                       /* Trim Bit 0, bit 0 */
    byte TRM1        :1;                                       /* Trim Bit 0, bit 1 */
    byte TRM2        :1;                                       /* Trim Bit 0, bit 2 */
    byte TRM3        :1;                                       /* Trim Bit 0, bit 3 */
    byte TRM4        :1;                                       /* Trim Bit 0, bit 4 */
    byte TRM5        :1;                                       /* Trim Bit 0, bit 5 */
    byte TRM6        :1;                                       /* Trim Bit 0, bit 6 */
    byte TRM7        :1;                                       /* Trim Bit 0, bit 7 */
  } Bits;
} NVVREFTRMSTR;
/* Tip for register initialization in the user code:  const byte NVVREFTRM_INIT @0x0000FFAD = <NVVREFTRM_INITVAL>; */
#define _NVVREFTRM (*(const NVVREFTRMSTR * __far)0x0000FFAD)
#define NVVREFTRM                       _NVVREFTRM.Byte
#define NVVREFTRM_TRM0                  _NVVREFTRM.Bits.TRM0
#define NVVREFTRM_TRM1                  _NVVREFTRM.Bits.TRM1
#define NVVREFTRM_TRM2                  _NVVREFTRM.Bits.TRM2
#define NVVREFTRM_TRM3                  _NVVREFTRM.Bits.TRM3
#define NVVREFTRM_TRM4                  _NVVREFTRM.Bits.TRM4
#define NVVREFTRM_TRM5                  _NVVREFTRM.Bits.TRM5
#define NVVREFTRM_TRM6                  _NVVREFTRM.Bits.TRM6
#define NVVREFTRM_TRM7                  _NVVREFTRM.Bits.TRM7

#define NVVREFTRM_TRM0_MASK             1
#define NVVREFTRM_TRM1_MASK             2
#define NVVREFTRM_TRM2_MASK             4
#define NVVREFTRM_TRM3_MASK             8
#define NVVREFTRM_TRM4_MASK             16
#define NVVREFTRM_TRM5_MASK             32
#define NVVREFTRM_TRM6_MASK             64
#define NVVREFTRM_TRM7_MASK             128


/*** NVFTRIM - Nonvolatile ICS Fine Trim; 0x0000FFAE ***/
typedef union {
  byte Byte;
  struct {
    byte FTRIM       :1;                                       /* ICS Fine Trim */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} NVFTRIMSTR;
/* Tip for register initialization in the user code:  const byte NVFTRIM_INIT @0x0000FFAE = <NVFTRIM_INITVAL>; */
#define _NVFTRIM (*(const NVFTRIMSTR * __far)0x0000FFAE)
#define NVFTRIM                         _NVFTRIM.Byte
#define NVFTRIM_FTRIM                   _NVFTRIM.Bits.FTRIM

#define NVFTRIM_FTRIM_MASK              1


/*** NVICSTRM - Nonvolatile ICS Trim Register; 0x0000FFAF ***/
typedef union {
  byte Byte;
  struct {
    byte TRIM0       :1;                                       /* ICS Trim Setting, bit 0 */
    byte TRIM1       :1;                                       /* ICS Trim Setting, bit 1 */
    byte TRIM2       :1;                                       /* ICS Trim Setting, bit 2 */
    byte TRIM3       :1;                                       /* ICS Trim Setting, bit 3 */
    byte TRIM4       :1;                                       /* ICS Trim Setting, bit 4 */
    byte TRIM5       :1;                                       /* ICS Trim Setting, bit 5 */
    byte TRIM6       :1;                                       /* ICS Trim Setting, bit 6 */
    byte TRIM7       :1;                                       /* ICS Trim Setting, bit 7 */
  } Bits;
} NVICSTRMSTR;
/* Tip for register initialization in the user code:  const byte NVICSTRM_INIT @0x0000FFAF = <NVICSTRM_INITVAL>; */
#define _NVICSTRM (*(const NVICSTRMSTR * __far)0x0000FFAF)
#define NVICSTRM                        _NVICSTRM.Byte
#define NVICSTRM_TRIM0                  _NVICSTRM.Bits.TRIM0
#define NVICSTRM_TRIM1                  _NVICSTRM.Bits.TRIM1
#define NVICSTRM_TRIM2                  _NVICSTRM.Bits.TRIM2
#define NVICSTRM_TRIM3                  _NVICSTRM.Bits.TRIM3
#define NVICSTRM_TRIM4                  _NVICSTRM.Bits.TRIM4
#define NVICSTRM_TRIM5                  _NVICSTRM.Bits.TRIM5
#define NVICSTRM_TRIM6                  _NVICSTRM.Bits.TRIM6
#define NVICSTRM_TRIM7                  _NVICSTRM.Bits.TRIM7

#define NVICSTRM_TRIM0_MASK             1
#define NVICSTRM_TRIM1_MASK             2
#define NVICSTRM_TRIM2_MASK             4
#define NVICSTRM_TRIM3_MASK             8
#define NVICSTRM_TRIM4_MASK             16
#define NVICSTRM_TRIM5_MASK             32
#define NVICSTRM_TRIM6_MASK             64
#define NVICSTRM_TRIM7_MASK             128


/*** NVBACKKEY0 - Backdoor Comparison Key 0; 0x0000FFB0 ***/
typedef union {
  byte Byte;
  struct {
    byte KEY0        :1;                                       /* Backdoor Comparison Key 0 Bits, bit 0 */
    byte KEY1        :1;                                       /* Backdoor Comparison Key 0 Bits, bit 1 */
    byte KEY2        :1;                                       /* Backdoor Comparison Key 0 Bits, bit 2 */
    byte KEY3        :1;                                       /* Backdoor Comparison Key 0 Bits, bit 3 */
    byte KEY4        :1;                                       /* Backdoor Comparison Key 0 Bits, bit 4 */
    byte KEY5        :1;                                       /* Backdoor Comparison Key 0 Bits, bit 5 */
    byte KEY6        :1;                                       /* Backdoor Comparison Key 0 Bits, bit 6 */
    byte KEY7        :1;                                       /* Backdoor Comparison Key 0 Bits, bit 7 */
  } Bits;
} NVBACKKEY0STR;
/* Tip for register initialization in the user code:  const byte NVBACKKEY0_INIT @0x0000FFB0 = <NVBACKKEY0_INITVAL>; */
#define _NVBACKKEY0 (*(const NVBACKKEY0STR * __far)0x0000FFB0)
#define NVBACKKEY0                      _NVBACKKEY0.Byte
#define NVBACKKEY0_KEY0                 _NVBACKKEY0.Bits.KEY0
#define NVBACKKEY0_KEY1                 _NVBACKKEY0.Bits.KEY1
#define NVBACKKEY0_KEY2                 _NVBACKKEY0.Bits.KEY2
#define NVBACKKEY0_KEY3                 _NVBACKKEY0.Bits.KEY3
#define NVBACKKEY0_KEY4                 _NVBACKKEY0.Bits.KEY4
#define NVBACKKEY0_KEY5                 _NVBACKKEY0.Bits.KEY5
#define NVBACKKEY0_KEY6                 _NVBACKKEY0.Bits.KEY6
#define NVBACKKEY0_KEY7                 _NVBACKKEY0.Bits.KEY7
/* NVBACKKEY_ARR: Access 8 NVBACKKEYx registers in an array */
#define NVBACKKEY_ARR                   ((volatile byte * __far) &NVBACKKEY0)

#define NVBACKKEY0_KEY0_MASK            1
#define NVBACKKEY0_KEY1_MASK            2
#define NVBACKKEY0_KEY2_MASK            4
#define NVBACKKEY0_KEY3_MASK            8
#define NVBACKKEY0_KEY4_MASK            16
#define NVBACKKEY0_KEY5_MASK            32
#define NVBACKKEY0_KEY6_MASK            64
#define NVBACKKEY0_KEY7_MASK            128


/*** NVBACKKEY1 - Backdoor Comparison Key 1; 0x0000FFB1 ***/
typedef union {
  byte Byte;
  struct {
    byte KEY0        :1;                                       /* Backdoor Comparison Key 1 Bits, bit 0 */
    byte KEY1        :1;                                       /* Backdoor Comparison Key 1 Bits, bit 1 */
    byte KEY2        :1;                                       /* Backdoor Comparison Key 1 Bits, bit 2 */
    byte KEY3        :1;                                       /* Backdoor Comparison Key 1 Bits, bit 3 */
    byte KEY4        :1;                                       /* Backdoor Comparison Key 1 Bits, bit 4 */
    byte KEY5        :1;                                       /* Backdoor Comparison Key 1 Bits, bit 5 */
    byte KEY6        :1;                                       /* Backdoor Comparison Key 1 Bits, bit 6 */
    byte KEY7        :1;                                       /* Backdoor Comparison Key 1 Bits, bit 7 */
  } Bits;
} NVBACKKEY1STR;
/* Tip for register initialization in the user code:  const byte NVBACKKEY1_INIT @0x0000FFB1 = <NVBACKKEY1_INITVAL>; */
#define _NVBACKKEY1 (*(const NVBACKKEY1STR * __far)0x0000FFB1)
#define NVBACKKEY1                      _NVBACKKEY1.Byte
#define NVBACKKEY1_KEY0                 _NVBACKKEY1.Bits.KEY0
#define NVBACKKEY1_KEY1                 _NVBACKKEY1.Bits.KEY1
#define NVBACKKEY1_KEY2                 _NVBACKKEY1.Bits.KEY2
#define NVBACKKEY1_KEY3                 _NVBACKKEY1.Bits.KEY3
#define NVBACKKEY1_KEY4                 _NVBACKKEY1.Bits.KEY4
#define NVBACKKEY1_KEY5                 _NVBACKKEY1.Bits.KEY5
#define NVBACKKEY1_KEY6                 _NVBACKKEY1.Bits.KEY6
#define NVBACKKEY1_KEY7                 _NVBACKKEY1.Bits.KEY7

#define NVBACKKEY1_KEY0_MASK            1
#define NVBACKKEY1_KEY1_MASK            2
#define NVBACKKEY1_KEY2_MASK            4
#define NVBACKKEY1_KEY3_MASK            8
#define NVBACKKEY1_KEY4_MASK            16
#define NVBACKKEY1_KEY5_MASK            32
#define NVBACKKEY1_KEY6_MASK            64
#define NVBACKKEY1_KEY7_MASK            128


/*** NVBACKKEY2 - Backdoor Comparison Key 2; 0x0000FFB2 ***/
typedef union {
  byte Byte;
  struct {
    byte KEY0        :1;                                       /* Backdoor Comparison Key 2 Bits, bit 0 */
    byte KEY1        :1;                                       /* Backdoor Comparison Key 2 Bits, bit 1 */
    byte KEY2        :1;                                       /* Backdoor Comparison Key 2 Bits, bit 2 */
    byte KEY3        :1;                                       /* Backdoor Comparison Key 2 Bits, bit 3 */
    byte KEY4        :1;                                       /* Backdoor Comparison Key 2 Bits, bit 4 */
    byte KEY5        :1;                                       /* Backdoor Comparison Key 2 Bits, bit 5 */
    byte KEY6        :1;                                       /* Backdoor Comparison Key 2 Bits, bit 6 */
    byte KEY7        :1;                                       /* Backdoor Comparison Key 2 Bits, bit 7 */
  } Bits;
} NVBACKKEY2STR;
/* Tip for register initialization in the user code:  const byte NVBACKKEY2_INIT @0x0000FFB2 = <NVBACKKEY2_INITVAL>; */
#define _NVBACKKEY2 (*(const NVBACKKEY2STR * __far)0x0000FFB2)
#define NVBACKKEY2                      _NVBACKKEY2.Byte
#define NVBACKKEY2_KEY0                 _NVBACKKEY2.Bits.KEY0
#define NVBACKKEY2_KEY1                 _NVBACKKEY2.Bits.KEY1
#define NVBACKKEY2_KEY2                 _NVBACKKEY2.Bits.KEY2
#define NVBACKKEY2_KEY3                 _NVBACKKEY2.Bits.KEY3
#define NVBACKKEY2_KEY4                 _NVBACKKEY2.Bits.KEY4
#define NVBACKKEY2_KEY5                 _NVBACKKEY2.Bits.KEY5
#define NVBACKKEY2_KEY6                 _NVBACKKEY2.Bits.KEY6
#define NVBACKKEY2_KEY7                 _NVBACKKEY2.Bits.KEY7

#define NVBACKKEY2_KEY0_MASK            1
#define NVBACKKEY2_KEY1_MASK            2
#define NVBACKKEY2_KEY2_MASK            4
#define NVBACKKEY2_KEY3_MASK            8
#define NVBACKKEY2_KEY4_MASK            16
#define NVBACKKEY2_KEY5_MASK            32
#define NVBACKKEY2_KEY6_MASK            64
#define NVBACKKEY2_KEY7_MASK            128


/*** NVBACKKEY3 - Backdoor Comparison Key 3; 0x0000FFB3 ***/
typedef union {
  byte Byte;
  struct {
    byte KEY0        :1;                                       /* Backdoor Comparison Key 3 Bits, bit 0 */
    byte KEY1        :1;                                       /* Backdoor Comparison Key 3 Bits, bit 1 */
    byte KEY2        :1;                                       /* Backdoor Comparison Key 3 Bits, bit 2 */
    byte KEY3        :1;                                       /* Backdoor Comparison Key 3 Bits, bit 3 */
    byte KEY4        :1;                                       /* Backdoor Comparison Key 3 Bits, bit 4 */
    byte KEY5        :1;                                       /* Backdoor Comparison Key 3 Bits, bit 5 */
    byte KEY6        :1;                                       /* Backdoor Comparison Key 3 Bits, bit 6 */
    byte KEY7        :1;                                       /* Backdoor Comparison Key 3 Bits, bit 7 */
  } Bits;
} NVBACKKEY3STR;
/* Tip for register initialization in the user code:  const byte NVBACKKEY3_INIT @0x0000FFB3 = <NVBACKKEY3_INITVAL>; */
#define _NVBACKKEY3 (*(const NVBACKKEY3STR * __far)0x0000FFB3)
#define NVBACKKEY3                      _NVBACKKEY3.Byte
#define NVBACKKEY3_KEY0                 _NVBACKKEY3.Bits.KEY0
#define NVBACKKEY3_KEY1                 _NVBACKKEY3.Bits.KEY1
#define NVBACKKEY3_KEY2                 _NVBACKKEY3.Bits.KEY2
#define NVBACKKEY3_KEY3                 _NVBACKKEY3.Bits.KEY3
#define NVBACKKEY3_KEY4                 _NVBACKKEY3.Bits.KEY4
#define NVBACKKEY3_KEY5                 _NVBACKKEY3.Bits.KEY5
#define NVBACKKEY3_KEY6                 _NVBACKKEY3.Bits.KEY6
#define NVBACKKEY3_KEY7                 _NVBACKKEY3.Bits.KEY7

#define NVBACKKEY3_KEY0_MASK            1
#define NVBACKKEY3_KEY1_MASK            2
#define NVBACKKEY3_KEY2_MASK            4
#define NVBACKKEY3_KEY3_MASK            8
#define NVBACKKEY3_KEY4_MASK            16
#define NVBACKKEY3_KEY5_MASK            32
#define NVBACKKEY3_KEY6_MASK            64
#define NVBACKKEY3_KEY7_MASK            128


/*** NVBACKKEY4 - Backdoor Comparison Key 4; 0x0000FFB4 ***/
typedef union {
  byte Byte;
  struct {
    byte KEY0        :1;                                       /* Backdoor Comparison Key 4 Bits, bit 0 */
    byte KEY1        :1;                                       /* Backdoor Comparison Key 4 Bits, bit 1 */
    byte KEY2        :1;                                       /* Backdoor Comparison Key 4 Bits, bit 2 */
    byte KEY3        :1;                                       /* Backdoor Comparison Key 4 Bits, bit 3 */
    byte KEY4        :1;                                       /* Backdoor Comparison Key 4 Bits, bit 4 */
    byte KEY5        :1;                                       /* Backdoor Comparison Key 4 Bits, bit 5 */
    byte KEY6        :1;                                       /* Backdoor Comparison Key 4 Bits, bit 6 */
    byte KEY7        :1;                                       /* Backdoor Comparison Key 4 Bits, bit 7 */
  } Bits;
} NVBACKKEY4STR;
/* Tip for register initialization in the user code:  const byte NVBACKKEY4_INIT @0x0000FFB4 = <NVBACKKEY4_INITVAL>; */
#define _NVBACKKEY4 (*(const NVBACKKEY4STR * __far)0x0000FFB4)
#define NVBACKKEY4                      _NVBACKKEY4.Byte
#define NVBACKKEY4_KEY0                 _NVBACKKEY4.Bits.KEY0
#define NVBACKKEY4_KEY1                 _NVBACKKEY4.Bits.KEY1
#define NVBACKKEY4_KEY2                 _NVBACKKEY4.Bits.KEY2
#define NVBACKKEY4_KEY3                 _NVBACKKEY4.Bits.KEY3
#define NVBACKKEY4_KEY4                 _NVBACKKEY4.Bits.KEY4
#define NVBACKKEY4_KEY5                 _NVBACKKEY4.Bits.KEY5
#define NVBACKKEY4_KEY6                 _NVBACKKEY4.Bits.KEY6
#define NVBACKKEY4_KEY7                 _NVBACKKEY4.Bits.KEY7

#define NVBACKKEY4_KEY0_MASK            1
#define NVBACKKEY4_KEY1_MASK            2
#define NVBACKKEY4_KEY2_MASK            4
#define NVBACKKEY4_KEY3_MASK            8
#define NVBACKKEY4_KEY4_MASK            16
#define NVBACKKEY4_KEY5_MASK            32
#define NVBACKKEY4_KEY6_MASK            64
#define NVBACKKEY4_KEY7_MASK            128


/*** NVBACKKEY5 - Backdoor Comparison Key 5; 0x0000FFB5 ***/
typedef union {
  byte Byte;
  struct {
    byte KEY0        :1;                                       /* Backdoor Comparison Key 5 Bits, bit 0 */
    byte KEY1        :1;                                       /* Backdoor Comparison Key 5 Bits, bit 1 */
    byte KEY2        :1;                                       /* Backdoor Comparison Key 5 Bits, bit 2 */
    byte KEY3        :1;                                       /* Backdoor Comparison Key 5 Bits, bit 3 */
    byte KEY4        :1;                                       /* Backdoor Comparison Key 5 Bits, bit 4 */
    byte KEY5        :1;                                       /* Backdoor Comparison Key 5 Bits, bit 5 */
    byte KEY6        :1;                                       /* Backdoor Comparison Key 5 Bits, bit 6 */
    byte KEY7        :1;                                       /* Backdoor Comparison Key 5 Bits, bit 7 */
  } Bits;
} NVBACKKEY5STR;
/* Tip for register initialization in the user code:  const byte NVBACKKEY5_INIT @0x0000FFB5 = <NVBACKKEY5_INITVAL>; */
#define _NVBACKKEY5 (*(const NVBACKKEY5STR * __far)0x0000FFB5)
#define NVBACKKEY5                      _NVBACKKEY5.Byte
#define NVBACKKEY5_KEY0                 _NVBACKKEY5.Bits.KEY0
#define NVBACKKEY5_KEY1                 _NVBACKKEY5.Bits.KEY1
#define NVBACKKEY5_KEY2                 _NVBACKKEY5.Bits.KEY2
#define NVBACKKEY5_KEY3                 _NVBACKKEY5.Bits.KEY3
#define NVBACKKEY5_KEY4                 _NVBACKKEY5.Bits.KEY4
#define NVBACKKEY5_KEY5                 _NVBACKKEY5.Bits.KEY5
#define NVBACKKEY5_KEY6                 _NVBACKKEY5.Bits.KEY6
#define NVBACKKEY5_KEY7                 _NVBACKKEY5.Bits.KEY7

#define NVBACKKEY5_KEY0_MASK            1
#define NVBACKKEY5_KEY1_MASK            2
#define NVBACKKEY5_KEY2_MASK            4
#define NVBACKKEY5_KEY3_MASK            8
#define NVBACKKEY5_KEY4_MASK            16
#define NVBACKKEY5_KEY5_MASK            32
#define NVBACKKEY5_KEY6_MASK            64
#define NVBACKKEY5_KEY7_MASK            128


/*** NVBACKKEY6 - Backdoor Comparison Key 6; 0x0000FFB6 ***/
typedef union {
  byte Byte;
  struct {
    byte KEY0        :1;                                       /* Backdoor Comparison Key 6 Bits, bit 0 */
    byte KEY1        :1;                                       /* Backdoor Comparison Key 6 Bits, bit 1 */
    byte KEY2        :1;                                       /* Backdoor Comparison Key 6 Bits, bit 2 */
    byte KEY3        :1;                                       /* Backdoor Comparison Key 6 Bits, bit 3 */
    byte KEY4        :1;                                       /* Backdoor Comparison Key 6 Bits, bit 4 */
    byte KEY5        :1;                                       /* Backdoor Comparison Key 6 Bits, bit 5 */
    byte KEY6        :1;                                       /* Backdoor Comparison Key 6 Bits, bit 6 */
    byte KEY7        :1;                                       /* Backdoor Comparison Key 6 Bits, bit 7 */
  } Bits;
} NVBACKKEY6STR;
/* Tip for register initialization in the user code:  const byte NVBACKKEY6_INIT @0x0000FFB6 = <NVBACKKEY6_INITVAL>; */
#define _NVBACKKEY6 (*(const NVBACKKEY6STR * __far)0x0000FFB6)
#define NVBACKKEY6                      _NVBACKKEY6.Byte
#define NVBACKKEY6_KEY0                 _NVBACKKEY6.Bits.KEY0
#define NVBACKKEY6_KEY1                 _NVBACKKEY6.Bits.KEY1
#define NVBACKKEY6_KEY2                 _NVBACKKEY6.Bits.KEY2
#define NVBACKKEY6_KEY3                 _NVBACKKEY6.Bits.KEY3
#define NVBACKKEY6_KEY4                 _NVBACKKEY6.Bits.KEY4
#define NVBACKKEY6_KEY5                 _NVBACKKEY6.Bits.KEY5
#define NVBACKKEY6_KEY6                 _NVBACKKEY6.Bits.KEY6
#define NVBACKKEY6_KEY7                 _NVBACKKEY6.Bits.KEY7

#define NVBACKKEY6_KEY0_MASK            1
#define NVBACKKEY6_KEY1_MASK            2
#define NVBACKKEY6_KEY2_MASK            4
#define NVBACKKEY6_KEY3_MASK            8
#define NVBACKKEY6_KEY4_MASK            16
#define NVBACKKEY6_KEY5_MASK            32
#define NVBACKKEY6_KEY6_MASK            64
#define NVBACKKEY6_KEY7_MASK            128


/*** NVBACKKEY7 - Backdoor Comparison Key 7; 0x0000FFB7 ***/
typedef union {
  byte Byte;
  struct {
    byte KEY0        :1;                                       /* Backdoor Comparison Key 7 Bits, bit 0 */
    byte KEY1        :1;                                       /* Backdoor Comparison Key 7 Bits, bit 1 */
    byte KEY2        :1;                                       /* Backdoor Comparison Key 7 Bits, bit 2 */
    byte KEY3        :1;                                       /* Backdoor Comparison Key 7 Bits, bit 3 */
    byte KEY4        :1;                                       /* Backdoor Comparison Key 7 Bits, bit 4 */
    byte KEY5        :1;                                       /* Backdoor Comparison Key 7 Bits, bit 5 */
    byte KEY6        :1;                                       /* Backdoor Comparison Key 7 Bits, bit 6 */
    byte KEY7        :1;                                       /* Backdoor Comparison Key 7 Bits, bit 7 */
  } Bits;
} NVBACKKEY7STR;
/* Tip for register initialization in the user code:  const byte NVBACKKEY7_INIT @0x0000FFB7 = <NVBACKKEY7_INITVAL>; */
#define _NVBACKKEY7 (*(const NVBACKKEY7STR * __far)0x0000FFB7)
#define NVBACKKEY7                      _NVBACKKEY7.Byte
#define NVBACKKEY7_KEY0                 _NVBACKKEY7.Bits.KEY0
#define NVBACKKEY7_KEY1                 _NVBACKKEY7.Bits.KEY1
#define NVBACKKEY7_KEY2                 _NVBACKKEY7.Bits.KEY2
#define NVBACKKEY7_KEY3                 _NVBACKKEY7.Bits.KEY3
#define NVBACKKEY7_KEY4                 _NVBACKKEY7.Bits.KEY4
#define NVBACKKEY7_KEY5                 _NVBACKKEY7.Bits.KEY5
#define NVBACKKEY7_KEY6                 _NVBACKKEY7.Bits.KEY6
#define NVBACKKEY7_KEY7                 _NVBACKKEY7.Bits.KEY7

#define NVBACKKEY7_KEY0_MASK            1
#define NVBACKKEY7_KEY1_MASK            2
#define NVBACKKEY7_KEY2_MASK            4
#define NVBACKKEY7_KEY3_MASK            8
#define NVBACKKEY7_KEY4_MASK            16
#define NVBACKKEY7_KEY5_MASK            32
#define NVBACKKEY7_KEY6_MASK            64
#define NVBACKKEY7_KEY7_MASK            128


/*** NVPROT - Nonvolatile Flash Protection Register; 0x0000FFBD ***/
typedef union {
  byte Byte;
  struct {
    byte FPDIS       :1;                                       /* Flash Protection Disable */
    byte FPS0        :1;                                       /* Flash Protection Size, bit 0 */
    byte FPS1        :1;                                       /* Flash Protection Size, bit 1 */
    byte FPS2        :1;                                       /* Flash Protection Size, bit 2 */
    byte FPS3        :1;                                       /* Flash Protection Size, bit 3 */
    byte FPS4        :1;                                       /* Flash Protection Size, bit 4 */
    byte FPS5        :1;                                       /* Flash Protection Size, bit 5 */
    byte FPS6        :1;                                       /* Flash Protection Size, bit 6 */
  } Bits;
  struct {
    byte         :1;
    byte grpFPS  :7;
  } MergedBits;
} NVPROTSTR;
/* Tip for register initialization in the user code:  const byte NVPROT_INIT @0x0000FFBD = <NVPROT_INITVAL>; */
#define _NVPROT (*(const NVPROTSTR * __far)0x0000FFBD)
#define NVPROT                          _NVPROT.Byte
#define NVPROT_FPDIS                    _NVPROT.Bits.FPDIS
#define NVPROT_FPS0                     _NVPROT.Bits.FPS0
#define NVPROT_FPS1                     _NVPROT.Bits.FPS1
#define NVPROT_FPS2                     _NVPROT.Bits.FPS2
#define NVPROT_FPS3                     _NVPROT.Bits.FPS3
#define NVPROT_FPS4                     _NVPROT.Bits.FPS4
#define NVPROT_FPS5                     _NVPROT.Bits.FPS5
#define NVPROT_FPS6                     _NVPROT.Bits.FPS6
#define NVPROT_FPS                      _NVPROT.MergedBits.grpFPS

#define NVPROT_FPDIS_MASK               1
#define NVPROT_FPS0_MASK                2
#define NVPROT_FPS1_MASK                4
#define NVPROT_FPS2_MASK                8
#define NVPROT_FPS3_MASK                16
#define NVPROT_FPS4_MASK                32
#define NVPROT_FPS5_MASK                64
#define NVPROT_FPS6_MASK                128
#define NVPROT_FPS_MASK                 254
#define NVPROT_FPS_BITNUM               1


/*** NVOPT - Nonvolatile Flash Options Register; 0x0000FFBF ***/
typedef union {
  byte Byte;
  struct {
    byte SEC0        :1;                                       /* Flash Security Bit 0 */
    byte SEC1        :1;                                       /* Flash Security Bit 1 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte FNORED      :1;                                       /* Vector Redirection Disable */
    byte KEYEN       :1;                                       /* Backdoor Key Security Enable */
  } Bits;
  struct {
    byte grpSEC  :2;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} NVOPTSTR;
/* Tip for register initialization in the user code:  const byte NVOPT_INIT @0x0000FFBF = <NVOPT_INITVAL>; */
#define _NVOPT (*(const NVOPTSTR * __far)0x0000FFBF)
#define NVOPT                           _NVOPT.Byte
#define NVOPT_SEC0                      _NVOPT.Bits.SEC0
#define NVOPT_SEC1                      _NVOPT.Bits.SEC1
#define NVOPT_FNORED                    _NVOPT.Bits.FNORED
#define NVOPT_KEYEN                     _NVOPT.Bits.KEYEN
#define NVOPT_SEC                       _NVOPT.MergedBits.grpSEC

#define NVOPT_SEC0_MASK                 1
#define NVOPT_SEC1_MASK                 2
#define NVOPT_FNORED_MASK               64
#define NVOPT_KEYEN_MASK                128
#define NVOPT_SEC_MASK                  3
#define NVOPT_SEC_BITNUM                0


/*** IRTC RAM ***/
/*** It is not recommended to mix usage of the StandbyRAM array and variables allocated into the appropriate section defined in the linker file at the same time. ***/
extern volatile byte StandbyRAM[32] @0x000018C0;


/* Flash commands */
#define mBlank                          0x05
#define mBurstProg                      0x25
#define mByteProg                       0x20
#define mMassErase                      0x41
#define mPageErase                      0x40


/***********************************************/
/**   D E P R E C I A T E D   S Y M B O L S   **/
/***********************************************/
#endif
