//----------------------------------------------------------------
// COPYRIGHT (c) Freescale 2009
// Freescale Confidential Proprietary
//  All Rights Reserved
//----------------------------------------------------------------
//!\file    main.c
//!\brief   This file conatins the application code for AN4168
//
// TYPE: C Source File
// DEPARTMENT: MSG-IDC
// CREATED BY: Neeraj Mangla (R64896)
// PURPOSE:  AN4168 Applciaiton code
//
// This code make use of the ADC driver released for the
// MC9S08LGW64 device. This applciation code init both ADCs 0
// and 1. Led D6 and D7 are used as a indicator of successful
// Calibration. If both of these led glows then ADCs are calibrated
// and gain are stored in the calibration gain registers. 
//----------------------------------------------------------------

#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "adc_flowtron.h"
#include "sci_flowtron.h"
#include "pdb_flowtron.h"

void InitConfig(void);
void fcd_enable_on_lcd_pins(void);

//----------------------------------------------------------------
// Main application program code
//----------------------------------------------------------------
void main(void) {

  EnableInterrupts; /* enable interrupts */
  InitConfig();         
  fcd_enable_on_lcd_pins();
  
  PTAD_PTAD3 = 1;   // Config LED D6 of MC9S08GW64 Demo board
  PTAD_PTAD4 = 1;   // Config LED D8 of MC9S08GW64 Demo board
  
  PTADD_PTADD3 = 1; //makes the GPIO pin PTA3 as output
  PTADD_PTADD4 = 1; //makes the GPIO pin PTA4 as output
   
  ADC_Init(ADC_0,ADICLK_BUS,ADIV_1,ADC_MODE_12,ADTRG_SW,ADCO_SINGLE,ADC_REFSEL_EXT);
  ADC_Init(ADC_1,ADICLK_BUS,ADIV_1,ADC_MODE_12,ADTRG_SW,ADCO_SINGLE,ADC_REFSEL_EXT);
  
  if(ADC_Cal(ADC_1))
   PTAD_PTAD3 = 0;  //Glow LED D6 if calibration is okey
  
  if(ADC_Cal(ADC_0))
   PTAD_PTAD4 = 0;  //Glow LED D8 if calibration is okey
      
  for(;;) {
    __RESET_WATCHDOG(); /* feeds the dog */
  } /* loop forever */
  /* please make sure that you never leave main */
}
//----------------------------------------------------------------
// Init MCU Cllocks and gpio
//----------------------------------------------------------------
void InitConfig() 
{
  SOPT1_COPT = 0;
  ICSC1 = 0x06;
  ICSC2 = 0x00; 
  ICSTRM = 0x8B; //0x8B: Recommended
  ICSSC = 0x20;
  SCGC4_MUXCTRL = 1;
  SCGC3_PTA = 1;     
}
//----------------------------------------------------------------
// Enable LCD pins for complementry drive strength
//----------------------------------------------------------------
void fcd_enable_on_lcd_pins(void)
 {
	 //Configuring FCD on LCD Pads
  	SCGC2_LCD=1;
  	LCDSUPPLY |= 0x03;
  	LCDC1 |= 0x04;
  	SCGC2 |= 0x40; //Enabling clock for Prescalar block 
}
//----------------------------------------------------------------
// RTC Tamper Interrupt service routine
//----------------------------------------------------------------
interrupt VectorNumber_Virtc void rtc_isr(void) 
{

  unsigned int status;
  // Unlock rtc seq
  status = (IRTC_STATUS & 0x10);
 
  if(status == 0x10 )
  {
    IRTC_CTRL &= ~(0x03);
    IRTC_CTRL |= 0x01;
    IRTC_CTRL |= 0x03;
    IRTC_CTRL |= 0x02;
  } 
  IRTC_ISR = 0xFFFF;
  IRTC_IER = 0x0;
}
//----------------------------------------------------------------
// End of application code
//----------------------------------------------------------------