#**************************************************************************/
#* FILE NAME: cfg_MMU_vle.s               COPYRIGHT (c) Freescale 2010    */
#*                                                All Rights Reserved     */
#* DESCRIPTION:                                                           */
#* makes a general setup of the MMU                                       */
#*                                                                        */
#* SETUP:                                                                 */
#* Software tested on MPC5516 EVB using GHS 5.0 + Lauterbach              */
#*																		  */
#*========================================================================*/

    .globl cfg_MMU_vle
    
    .section .vletext,vax        # The "ax" generates symbols for debug, "v" for VLE    
 
# make basic MMU setup 
# setup MMU for flash, RAM and register access, VLE
# MMU.TLBSET 0x0 0xC0000900 0x00000020 0x0000003F  ; 0x0000_0000 to 0x003F_FFFF (256MB VLE)     CFLASH
# MMU.TLBSET 0x2 0xC0000400 0x40000028 0x4000003F  ; 0x4000_0000 to 0x4003_FFFF (256KB VLE)   RAM
# MMU.TLBSET 0x3 0xC0000A00 0xC000002A 0xC000003F  ; 0xC000_0000 to 0xFFFF_FFFF (1GB   VLE)   Platform Peripherals 

cfg_MMU_vle:
    .vle

#****************
# Setup MMU
#****************
	# MMU setup 
	# Set up MMU for FLASH

    e_lis   r3, 0x1000
    mtMAS0 r3

    e_lis   r4, 0xC000
    e_or2i  r4, 0x0900
    mtMAS1 r4

    e_lis   r5, 0x0000
    e_or2i  r5, 0x0020
    mtMAS2 r5

    e_lis  r6,0x0000
    e_or2i r6, 0x003f
    mtMAS3 r6

    tlbwe

    # Set up MMU for SRAM

    e_lis   r3, 0x1001
    mtMAS0 r3

    e_lis   r4, 0xC000
    e_or2i  r4, 0x0400
    mtMAS1  r4

    e_lis   r5, 0x4000
    e_or2i  r5, 0x0028
    mtMAS2 r5

    e_lis  r6, 0x4000
    e_or2i r6, 0x003f
    mtMAS3 r6

    tlbwe

    # Set up MMU for Peripherials

    e_lis   r3, 0x1002
    mtMAS0 r3

    e_lis   r4, 0xC000
    e_or2i  r4, 0x0A00
    mtMAS1 r4

    e_lis   r5, 0xC000
    e_or2i r5, 0x002A
    mtMAS2 r5

    e_lis  r6,0xC000
    e_or2i r6, 0x003f
    mtMAS3 r6

    tlbwe
	
    se_blr                           	# done


