/********************************************************************************************/
/* FILE NAME: update_blank_part.c                                                           */
/*                                                           COPYRIGHT (c) Freescale 2010   */
/*                                                                  All Rights Reserved     */
/* DESCRIPTION:                                                                             */
/* This program will program the BOOT_MAC_KEY and the KEYs 1..10 in the secure Flash        */
/* to be able to use the CSE functions                                                      */
/* SETUP:                                                                                   */
/* Software tested on MPC564xB EVB using GHS 5.1.7 + Lauterbach                             */
/*																		                    */
/********************************************************************************************/

#include "..\header\typedefs.h"
#include "..\header\project.h"
#include "..\header\cse.h"
#include "..\header\update_keys.h" 

/*========================================================================*/
/*				 			Global variables							  */
/*========================================================================*/

extern  uint32_t failcount;
        
/*========================================================================*/
/*				 			Function        							  */
/*========================================================================*/
                     
uint32_t update_blank_part ()
{
    uint32_t M4_output [13][8];
    uint32_t M5_output [13][4];
    uint32_t x, y;
    failcount=0;

    
    while (CSE.SR.B.BSY ==1){} // wait until CSE is idle
    // update all the slots :BOOT_MAC_KEY, KEY_1..10 
    for (x = 1; x < 12 ; x++)
    {
      while (CSE.SR.B.BSY ==1){} // wait until CSE is idle
      
      CSE.P1.R = (vuint32_t)&M1 + (uint32_t)(x * 16);
      CSE.P2.R = (vuint32_t)&M2 + (uint32_t)(x * 32);
      CSE.P3.R = (vuint32_t)&M3 + (uint32_t)(x * 16);
      CSE.P4.R = (vuint32_t)&M4_output + (uint32_t)(x * 32);
      CSE.P5.R = (vuint32_t)&M5_output + (uint32_t)(x * 16);
      CSE.CMD.R= CSE_LOAD_KEY;     	

      while (CSE.SR.B.BSY ==1){} // wait until CSE is idle

      for (y = 0; y < 8 ; y++)
      {
      	if (M4_output[x][y] != M4[x][y])
      	{
      		failcount++;
      	}
      }
       for (y = 0; y < 4 ; y++)
      {
      	if (M5_output[x][y] != M5[x][y])
      	{
      		failcount++;
      	}
      }     
      
      
    }
    while (CSE.SR.B.BSY ==1){} // wait until CSE is idle
    
    // update MASTER_ECU_KEY
      
    CSE.P1.R = (vuint32_t)&M1 ;
    CSE.P2.R = (vuint32_t)&M2 ;
    CSE.P3.R = (vuint32_t)&M3 ;
    CSE.P4.R = (vuint32_t)&M4_output ;
    CSE.P5.R = (vuint32_t)&M5_output ;
    CSE.CMD.R= CSE_LOAD_KEY;     	

    while (CSE.SR.B.BSY ==1){} // wait until CSE is idle

    for (y = 0; y < 8 ; y++)
    {
    	if (M4_output[0][y] != M4[0][y])
    	{
    		failcount++;
    	}
    }
     for (y = 0; y < 4 ; y++)
    {
    	if (M5_output[0][y] != M5[0][y])
    	{
    		failcount++;
    	}
    }
    
    return(failcount);
}
