#!/usr/bin/perl

use Getopt::Std;
#use strict ;
###############################################################################################
# example use perl generate_MACS_over_object_code.pl -m Flash -s SECTION_KEYS.txt -k KEYS.txt #
# -m Map file name (no .map  extension)                                                       #
# -s name of file containing section names and corresponding keys                             #
# -k name of file containing keys                                                             #
###############################################################################################

getopts('m:s:k:');
print "################################\n";
print "CSE Ring of Trust example script\n";
print "################################\n";

####################################
#read the section versus keys data #
####################################
open (SECTION, $opt_s) or die "Can't open section/keys file: $opt_s\n";
LINE: while ($line = <SECTION>)
{
	chop;
	next LINE if $line =~ /^#/; #remove comment line
	next LINE if $line =~ /^$/; #remove blank lines;
	next LINE if $line =~ /^\s*$/; #remove whitespace only lines;
	($section, $this_key_number) = split (" ", $line);
	$key_number{$section}=$this_key_number;
}

######################
# read the keys data #
######################
open (KEYS, $opt_k) or die "Can't open keys file: $opt_k\n";
LINE1: while ($line = <KEYS>)
{
	chop;
	next LINE1 if $line =~ /^#/; #remove comment line
	next LINE1 if $line =~ /^$/; #remove blank lines;
	next LINE1 if $line =~ /^\s*$/; #remove whitespace only lines;
	($index, $this_key) = split (" ", $line);
	$keys{$index}=$this_key;
}

######################
# read the keys data #
######################
open (CSE_KEYS_INDEX, "CSE_KEY_INDEX.txt") or die "Can't open keys file: CSE_KEY_INDEX.txt\n";
LINE2: while ($line = <CSE_KEYS_INDEX>)
{
	chomp;
	next LINE2 if $line =~ /^#/; #remove comment line
	next LINE2 if $line =~ /^$/; #remove blank lines;
	next LINE2 if $line =~ /^\s*$/; #remove whitespace only lines;
	($CSE_key_name, $value) = split (" ", $line);
	$CSE_keys{$CSE_key_name}=$value;
}


print "reading map file $opt_m.map\n";
$map_file_name = $opt_m . ".map";
open (MAP, $map_file_name) or die "Can't open map file: $map_file_name\n";
while ($line = <MAP>)
{
	   ($value, $label) = split (" ", $line);
    	foreach $section (sort keys %key_number)
	    {
	      if ($label eq $section . "_START_ADDR") {$start_addr{$section} = "0x" . $value}
	      if ($label eq $section . "_LENGTH_IN_BITS") {$length_in_bits{$section} = hex($value);}
	      if ($label eq $section . "_END_ADDR") {$end_addr{$section} = "0x" . $value;}
	}
}
foreach $section (sort keys %key_number)
{
 print "###################################################\n";
 print "Extracted data from MAP file for section $section\n";
 print "START_ADDR is : $start_addr{$section}\n";
 print "LENGTH_IN_BITS is : $length_in_bits{$section}\n";
 print "END_ADDR is : $end_addr{$section}\n";
 
 print "And the CMAC key is  $CSE_keys{$key_number{$section}}\n"; 
 print "And the CMAC key name is  $key_number{$section}\n"; 
 print "And it's value is $keys{$key_number{$section}}\n";
}
print "###################################################\n";

foreach $section (sort keys %key_number)
{
#############################################
# extract data for section using srec_cat tool
############################################

$prog ="../binaries/srec_cat.exe";
$filename= $opt_m . ".run";
$fill = "--fill";
$fill_value = "0xFF";
$within = "--within";
$range_pad = "--range-padding";
$range_pad_num = "4";
$crop= "-crop";
$output= "-output";
$section1= $section . ".hex";
$vmem= "-vmem";
$vmem_value= "32";
$linelength= "-line-length=46";
$start_addr{$section} = hex($start_addr{$section});
$end_addr{$section} = hex($end_addr{$section});

# round up end address of section so it is 32 bit aligned
# misalignment is caused by vle code potentially ending on a 16 bit boundary

if ($end_addr{$section}/4 ne int ($end_addr{$section}/4))
{
print "rounded end addr of section  $section from  $end_addr{$section} to $end_addr{$section}+2\n"; 
   $end_addr{$section} = $end_addr{$section}+2;
}

 print                "$prog, $filename, $fill, $fill_value, $within, $filename, $range_pad, $range_pad_num, $crop,$start_addr{$section},$end_addr{$section},$output,$section1,$vmem,$vmem_value, $linelength\n";
 $return_value = system($prog, $filename, $fill, $fill_value, $within, $filename, $range_pad, $range_pad_num, $crop,$start_addr{$section},$end_addr{$section},$output,$section1,$vmem,$vmem_value, $linelength);




##################################################
#read in hex data and output as lines of 128 bits
##################################################
$outfile = ">" . $section . "_128.hex";
open (HEX_IN, $section1) or die "Can't open hex section file: $section1\n";
open (HEX_OUT, $outfile) or die "Can't open hex out section file: $outfile\n";
while ($line = <HEX_IN>)
{
	($A, $B, $C, $D, $E) = split (" ", $line);
  if ($B eq $opt_m){next;}
  print HEX_OUT "$B$C$D$E\n";
}
close (HEX_OUT);
close (HEX_IN);

############################
# do the CMAC calculation  #
############################
$prog ="tools/bin/AES_CMAC_CMD.exe";
$KEY = $keys{$key_number{$section}};
$infile = $section . "_128.hex";


$my_cmac{$section}=`$prog $KEY $length_in_bits{$section} $infile`;
print "CMAC for $section is $my_cmac{$section}\n";
}

#######################################################################
#  write header file containing keys & CMACS for protected sections   #
#######################################################################
$outfile = ">keys_and_cmacs.h";
open (OUTFILE, $outfile) or die "Can't open file: $outfile\n";


print OUTFILE "/**********************************/\n";
print OUTFILE "/* CMACs generated by perl script */\n";
print OUTFILE "/**********************************/\n";
foreach $section (sort keys %key_number)
{
 $v1=substr $my_cmac{$section}, 0, 8;
 $v2=substr $my_cmac{$section}, 8, 8;
 $v3=substr $my_cmac{$section}, 16, 8;
 $v4=substr $my_cmac{$section}, 24, 8;
 $output_section0 = $section . "_0";
 $output_section1 = $section . "_1";
 $output_section2 = $section . "_2";
 $output_section3 = $section . "_3";
 print OUTFILE "#define $output_section0 0x$v1\n";
 print OUTFILE "#define $output_section1 0x$v2\n";
 print OUTFILE "#define $output_section2 0x$v3\n";
 print OUTFILE "#define $output_section3 0x$v4\n";
 print OUTFILE "\n";
}
print OUTFILE "/****************************************/\n";
print OUTFILE "/* key number for use by CSE            */\n";
print OUTFILE "/* These can be used to check the CMACS */\n";
print OUTFILE "/****************************************/\n";
foreach $section (sort keys %key_number)
{
 $output_key_name = $section . "_KEY_NUMBER";
 print OUTFILE "#define $output_key_name $key_number{$section}\n";
}
print OUTFILE "\n";


print OUTFILE "/********************************************/\n";
print OUTFILE "/* Code section start addresses and lengths */\n";
print OUTFILE "/* These can be used to check the CMACS     */\n";
print OUTFILE "/********************************************/\n";
foreach $section (sort keys %key_number)
{
 $output_section0 = $section . "_START_ADDR";
 $output_section1 = $section . "_LENGTH_IN_BITS";
 print OUTFILE "#define $output_section0 $start_addr{$section}\n";
 print OUTFILE "#define $output_section1 $length_in_bits{$section}\n";
}
close (OUTFILE);