#*************************************************************************
# FILE NAME: flash_init_vle.s                  COPYRIGHT (c) Freescale 2010    
#                                                All Rights Reserved      
#
#*************************************************************************
 
  .globl __start
  
  .section .rcw, axv
   .vle
  .long 0x015a0000
  .long __start
#this the length in bytes of the boot block.
  .long 0x8000 -0x10
  .long 0x0 #dummy - used to optimise BOOT_MAC calc. time
  
  .section .init,axv     		# The "ax" generates symbols for debug
  .vle

__start:

    e_lis       r1, __SP_INIT@h     # Initialize stack pointer r1 to
    e_or2i      r1, __SP_INIT@l     # value in linker command file. 

    e_lis       r13, _SDA_BASE_@h   # Initialize r13 to sdata base
    e_or2i      r13, _SDA_BASE_@l   # (provided by linker).    

    e_lis       r2, _SDA2_BASE_@h   # Initialize r2 to sdata2 base
    e_or2i      r2, _SDA2_BASE_@l   # (provided by linker).
    
#******************
# Enable SPE in MSR
#******************
  mfMSR r6
  e_or2is  r6, 0x0200
  mtMSR r6

#***************
# Clear Timebase
#***************
  e_li r3, 0
  mtspr 284, r3
  mtspr 285, r3

#****************
# Enable Timebase
#****************
  e_li r3, 0x4000
  mtspr HID0, r3


#***********************
# Configure MMU SRAM
#***********************
#TLB2 =  1MB for Internal RAM
   e_lis r3, 0x1003
   mtmas0 r3
   e_lis  r3, 0xC000
   e_or2i   r3, 0x0500
   mtmas1 r3
   e_lis  r3, 0x4000
   e_or2i   r3, 0x0020
   mtmas2 r3
   e_lis  r3, 0x4000
   e_or2i   r3, 0x003F
   mtmas3 r3
   tlbwe


#***********************
# Initialize ECC in SRAM
# 596K of RAM
#***********************
#  e_li   r5, 4864 // Used to be 2048 but 4864 covers all 608K
  e_li   r5, 384 // Used to be 384 but 4864 covers all 128K
  mtctr r5
  e_lis   r5,0x4000
sram_loop:
  e_stmw  r0, 0x0 (r5)
  e_addi  r5, r5, 128
  e_bdnz  sram_loop
  
  e_stwu      r0,-64(r1)          # Terminate stack.


#********************************
# Enable the branch target buffer
#********************************
  e_li	r0, 0x201
  mtspr	1013, r0

#******************
# configure the MMU
#******************
#TLB0 = pbridgeB (configured by BAM)

#TLB1 =  1M Internal flash - z6
# Execute from RAM

e_b copy_to_ram

tlb0_config:
   e_lis r3, 0x1000
   mtmas0 r3
   e_lis  r3, 0xC000
   e_or2i r3, 0x0500
   mtmas1	r3

   e_lis  r3, 0x0000
   e_or2i r3, 0x0020
   mtmas2	 r3

   e_lis  r3, 0x0000
   e_or2i r3, 0x003F
   mtmas3	 r3
   tlbwe
   se_blr
   
copy_to_ram:
  e_lis r3, tlb0_config@h
  e_or2i r3, tlb0_config@l
  e_lis r4, copy_to_ram@h
  e_or2i r4, copy_to_ram@l
  subf r4, r3, r4
  mtctr r4
  e_lis r5, 0x4000
  mtlr r5

copy:
  e_lbz r6, 0(r3)
  e_stb r6, 0(r5)
  e_addi r3, r3, 1
  e_addi r5, r5, 1
  e_bdnz copy

  se_blrl

#TLB2 =  1M Internal flash - z0
   e_lis r3, 0x1002
   mtmas0 r3
   e_lis  r3, 0xC000
   e_or2i   r3, 0x0500
   mtmas1 r3
#  tlbwe
   e_lis  r3, 0x0010
   e_or2i   r3, 0x0020
   mtmas2 r3
#  tlbwe
   e_lis  r3, 0x0010
   e_or2i   r3, 0x003F
   mtmas3 r3
   tlbwe

#TLB4 =  pbridgeA
   e_lis r3, 0x1004
   mtmas0 r3
   e_lis  r3, 0xC000
   e_or2i   r3, 0x0800
   mtmas1 r3
#  tlbwe
   e_lis  r3, 0xC000
   e_or2i   r3, 0x000A
   mtmas2 r3
#  tlbwe
   e_lis  r3, 0xC000
   e_or2i   r3, 0x003F
   mtmas3 r3
   tlbwe

#TLB6 =  Peripheral Bridge and BAM
#0x6 0xC0000600 0xFFC00028 0xFFC0003F 
   e_lis r3, 0x1006
   mtmas0 r3
   e_lis  r3, 0xC000
   e_or2i   r3, 0x0600
   mtmas1 r3
   e_lis  r3, 0xFFC0
   e_or2i   r3, 0x0028
   mtmas2 r3
   e_lis  r3, 0xFFC0
   e_or2i   r3, 0x003F
   mtmas3 r3
   tlbwe
   
##--------- Load Initialised Data Values from Flash into RAM ----------------

##--------- Initialised Data - ".data" --------------------------------------
DATACOPY:
    e_lis       r9, __DATA_SIZE@ha      # Load upper SRAM load size (# of bytes) into R9
    e_or2i      r9, __DATA_SIZE@l       # Load lower SRAM load size into R9                                     
    e_cmp16i    r9,0                    # Compare to see if equal to 0                                  
    e_beq       SDATACOPY               # Exit cfg_ROMCPY if size is zero (no data to initialise)
                                        
    mtctr       r9                      # Store no. of bytes to be moved in counter
                                        
    e_lis       r10, __DATA_ROM_ADDR@h  # Load address of first SRAM load into R10
    e_or2i      r10, __DATA_ROM_ADDR@l  # Load lower address of SRAM load into R10
    e_subi      r10,r10, 1              # Decrement address to prepare for ROMCPYLOOP

    e_lis       r5, __DATA_SRAM_ADDR@h  # Load upper SRAM address into R5 (from linker file)
    e_or2i      r5, __DATA_SRAM_ADDR@l  # Load lower SRAM address into R5 (from linker file)
    e_subi      r5, r5, 1               # Decrement address to prepare for ROMCPYLOOP

DATACPYLOOP:
    e_lbzu      r4, 1(r10)              # Load data byte at R10 into R4,incrementing (update) ROM address
    e_stbu      r4, 1(r5)               # Store R4 data byte into SRAM at R5 and update SRAM address 
    e_bdnz      DATACPYLOOP             # Branch if more bytes to load from ROM

##--------- Small Initialised Data - ".sdata" --------------------------------------
SDATACOPY:    
    e_lis       r9, __SDATA_SIZE@ha     # Load upper SRAM load size (# of bytes) into R9
    e_or2i      r9, __SDATA_SIZE@l      # Load lower SRAM load size into R9                                     
    e_cmp16i    r9,0                    # Compare to see if equal to 0                                  
    e_beq       ROMCPYEND               # Exit cfg_ROMCPY if size is zero (no data to initialise)
                                        
    mtctr       r9                      # Store no. of bytes to be moved in counter
                                        
    e_lis       r10, __SDATA_ROM_ADDR@h # Load address of first SRAM load into R10
    e_or2i      r10, __SDATA_ROM_ADDR@l # Load lower address of SRAM load into R10
    e_subi      r10,r10, 1              # Decrement address to prepare for ROMCPYLOOP

    e_lis       r5, __SDATA_SRAM_ADDR@h # Load upper SRAM address into R5 (from linker file)
    e_or2i      r5, __SDATA_SRAM_ADDR@l # Load lower SRAM address into R5 (from linker file)
    e_subi      r5, r5, 1               # Decrement address to prepare for ROMCPYLOOP

SDATACPYLOOP:
    e_lbzu      r4, 1(r10)              # Load data byte at R10 into R4,incrementing (update) ROM address
    e_stbu      r4, 1(r5)               # Store R4 data byte into SRAM at R5 and update SRAM address 
    e_bdnz      SDATACPYLOOP            # Branch if more bytes to load from ROM
    
    
ROMCPYEND: 
##--------------------------------------------------------------------------- 



##---------------------------------------------------------------------------
# Start of MCU initialisation code
#    e_bl      init_MCU
# Start of optimisation code
#   e_bl      optimise_MCU
# Start of main code
    e_bl      main
##---------------------------------------------------------------------------   

        

loop_forever:
  e_b loop_forever




