/********************************************************************************************/
/* FILE NAME: main_flash.c                                                                  */
/*                                                           COPYRIGHT (c) Freescale 2010   */
/*                                                                  All Rights Reserved     */
/* DESCRIPTION:                                                                             */
/* Main program will set up the MPC564xB/C for running on 120Mhz system clock and           */
/* disable the internal watchdog. Checks next section is authentic.                         */
/* The code will then call each of 3 functions in turn                                      */ 
/* SETUP:                                                                                   */
/* Software tested on MPC564xB EVB using GHS 5.1.7 + Lauterbach                             */
/*																		                                                      */
/********************************************************************************************/

#include "..\header\project.h"
#include "..\keys_and_cmacs.h"
#include "..\header\cse.h"

const uint32_t  my_app_code1_build_cmac[4] = {CMAC_APP_CODE1_0, CMAC_APP_CODE1_1, CMAC_APP_CODE1_2, CMAC_APP_CODE1_3}; 
/* CMAC of my_app_code1.c calculated at build time and stored in boot block and protected by BOOT_MAC */

const uint32_t  my_app_code2_build_cmac[4] = {CMAC_APP_CODE2_0, CMAC_APP_CODE2_1, CMAC_APP_CODE2_2, CMAC_APP_CODE2_3}; 
/* CMAC of my_app_code2.c calculated at build time and stored in boot block and protected by BOOT_MAC */

const uint32_t  my_app_code3_build_cmac[4] = {CMAC_APP_CODE3_0, CMAC_APP_CODE3_1, CMAC_APP_CODE3_2, CMAC_APP_CODE3_3}; 
/* CMAC of my_app_code3.c calculated at build time and stored in boot block and protected by BOOT_MAC */


#pragma ghs section rodata=".my_boot_code_section_rodata",text=".my_boot_code_section"
const uint32_t Boot_Protected_Constant[2] = {0xffffffff, 0xffffffff};
uint32_t failcount = 0;
uint32_t function_code1_bad = 0;
uint32_t function_code2_bad = 0;
uint32_t function_code3_bad = 0;
vuint32_t r1, r2, r3;


int main(void)
{
  unsigned long long length = CMAC_APP_CODE1_LENGTH_IN_BITS ; 
                               /* function code length in bits*/
  vuint32_t CMAC_mismatch;
	
	r1=0;
	r2=0;
	r3=0;
	
  while ((CSE.SR.B.BOK ==0) & (CSE.SR.B.BFN ==0)){}  
  /* wait until CSE is has finished Secure Boot process*/

  /* Issue_BOOT_OK */
  CSE.CMD.R= CSE_BOOT_OK;
   
  while (CSE.SR.B.BSY ==1){} /* wait until CSE is idle*/
break_here0:
  while (CSE.SR.B.BFN!=1) {}; 
  /* trap if Secure Boot Finished is not set */
  /* BFN will be set because either the SECURE_BOOT passed and BOOT_OK sets it */
  /* or SECURE_BOOT failed and set it */
  
  failcount=0; CMAC_mismatch=0;    

  CSE.P1.R = CMAC_APP_CODE1_KEY_NUMBER; /*  */
  CSE.P2.R = (unsigned long long)&length; /* msg length */
  CSE.P3.R = CMAC_APP_CODE1_START_ADDR;	
  CSE.P4.R = (vuint32_t)&my_app_code1_build_cmac;
  CSE.P5.R= 128; /* verify all 128 bits */
  CSE.CMD.R= CSE_VERIFY_MAC; 

  while (CSE.SR.B.BSY ==1){} /*wait until CSE is idle*/

  if (CSE.ECR.R != CSE_NO_ERR) {failcount++;}
  if (CSE.P5.R != 0) {CMAC_mismatch++;}
  if (CMAC_mismatch != 0)
  {
    failcount++;
    /* the code for my_function_code1 was not authenticated */
    /* app code to deal with that */
    function_code1_bad = 1;
  }
  
    
break_here1:		
	r1 = my_function_code1( 2 );
	r2 = my_function_code2( 2 );
	r3 = my_function_code3( 2 );
break_here2:		
  while(1);
}
