/********************************************************************************************/
/* FILE NAME: my_app_code1_flash.c                                                          */
/*                                                           COPYRIGHT (c) Freescale 2010   */
/*                                                                  All Rights Reserved     */
/* DESCRIPTION:                                                                             */
/* Simple function. Checks next section is authentic.                                       */
/* SETUP:                                                                                   */
/* Software tested on MPC564xB EVB using GHS 5.1.7 + Lauterbach                             */
/*																		                                                      */
/********************************************************************************************/
#include "..\header\project.h"
#include "..\keys_and_cmacs.h"
#include "..\header\cse.h"
extern uint32_t  my_app_code2_build_cmac[4]; /*CMAC of my_app_code1 calculated at build time */
extern uint32_t failcount;
extern uint32_t function_code2_bad;
#pragma ghs section rodata=".my_app_code1_section_rodata",text=".my_app_code1_section"
const uint32_t my_app_code_protected_constant1[2] = {0xffffffff, 0xffffffff};

uint32_t my_function_code1(uint32_t parameter)
{
    vuint32_t result1, CMAC_mismatch;

    unsigned long long length = CMAC_APP_CODE2_LENGTH_IN_BITS ; 
                               /* function code length in bits*/
    failcount=0; CMAC_mismatch=0;    

    CSE.P1.R = CMAC_APP_CODE2_KEY_NUMBER; /*  */
    CSE.P2.R = (unsigned long long)&length; /* msg length */
    CSE.P3.R = CMAC_APP_CODE2_START_ADDR;	
    CSE.P4.R = (vuint32_t)&my_app_code2_build_cmac;
    CSE.P5.R= 128; /* verify all 128 bits */
    CSE.CMD.R= CSE_VERIFY_MAC; 

    while (CSE.SR.B.BSY ==1){} /*wait until CSE is idle*/

    if (CSE.ECR.R != CSE_NO_ERR) {failcount++;}
    if (CSE.P5.R != 0) {CMAC_mismatch++;}
    if (CMAC_mismatch != 0)
    {
      function_code2_bad = 1;
    }

  result1 = parameter*parameter; //or whatever - application code
break_here3:
  return(result1);
}

