/********************************************************************************************/
/* FILE NAME: debug_chall_auth.c                                                            */
/*                                                           COPYRIGHT (c) Freescale 2010   */
/*                                                                  All Rights Reserved     */
/* DESCRIPTION:                                                                             */
/* Debug challenge and authorization code.                                                  */
/* SETUP:                                                                                   */
/* Software tested on MPC564xB EVB using GHS 5.1.7 + Lauterbach                             */
/*																		                                                      */
/********************************************************************************************/

#include "..\header\typedefs.h"
#include "..\header\project.h"
#include "..\header\cse.h"

extern uint32_t failcount;
extern uint32_t encrypted_data[64];
extern uint32_t data_for_encryption[64]; 
                           
/******************************************************************************/
/* Test description: Debug_challenge and debug_auth tests                     */
/* Purpose: Recover parts where KEYS are unknown; will only work if WP == 0   */
/*          for all keys                                                      */
/******************************************************************************/
uint32_t debug_chal_auth ()
{
    uint32_t challenge [4];
    uint32_t get_id_challenge [4] = {0x12345678, 0x12345678, 0x12345678, 0x12345678};
    uint32_t UID [4];
    uint32_t UID_MAC [4];
    /* KDEBUG derived from MASTER_ECU_KEY = D275F12CA863A7B5F933DF926498FB4D and
                              DEBUG_KEY_C = 010353484500800000000000000000B0 */
    uint32_t KDEBUG [4] =      {0x707140cd, 0xd1c41cc5, 0x5d84c81e, 0xa6b6b508};
    /* KDEBUG derived from MASTER_ECU_KEY = 00000000000000000000000000000000 and
                              DEBUG_KEY_C = 010353484500800000000000000000B0 */
//    uint32_t KDEBUG [4] =      {0x79e87423, 0x8da1dc2b, 0xaec36ea6, 0x48927523};

    uint32_t challenge_UID [8];
    uint32_t authorization [4];    
    unsigned long long length = 248;
    
    
    uint32_t i ;
    failcount=0;
    
    /* set up DIVIDER for TRNG*/
    //CSE.CR.B.DIV = 19;  /* for  80Mhz Fsys - gives 2Mhz TRNG clock*/
    CSE.CR.B.DIV = 29;  /* for 120Mhz Fsys - gives 2Mhz TRNG clock*/
    
    /* initialise RNG */
    CSE.CMD.R= CSE_INIT_RNG;
    while (CSE.SR.B.BSY ==1){} /*wait until CSE is idle*/           

    if (CSE.ECR.R != CSE_NO_ERR) {failcount++;}
    if (CSE.SR.R & 0x00000020 != 0x00000020 ) {failcount++;} /* check RIN bit is set*/
    
    /* generate challenge value */
    CSE.P1.R = (vuint32_t)&challenge ;
    CSE.CMD.R= CSE_DEBUG_CHAL;

    while (CSE.SR.B.BSY ==1){} /*wait until CSE is idle*/        
    if (CSE.ECR.R != CSE_NO_ERR) {failcount++;}

    while (CSE.SR.B.BSY ==1){} /*wait until CSE is idle*/

    /* get UID */
    CSE.P1.R = (vuint32_t)&get_id_challenge;
    CSE.P2.R = (vuint32_t)&UID;
    CSE.P3.R = 0 ;
    CSE.P4.R = (vuint32_t)&UID_MAC;
    CSE.CMD.R= CSE_GET_ID; 

    while (CSE.SR.B.BSY ==1){} /*wait until CSE is idle*/

    if (CSE.ECR.R != CSE_NO_ERR) {failcount++;}
    
    /* issue challenge command */
    CSE.P1.R = (vuint32_t)&challenge ;
    CSE.CMD.R = CSE_DEBUG_CHAL;

    while (CSE.SR.B.BSY ==1){} /*wait until CSE is idle*/           
     
    if (CSE.ECR.R != CSE_NO_ERR) {failcount++;}

    /* load RAM_key with KDEBUG*/
    CSE.P1.R = (uint32_t) &KDEBUG;
    CSE.CMD.R= CSE_LOAD_PLAIN_KEY; 
        
    while (CSE.SR.B.BSY ==1){} /*wait until CSE is idle*/
    
    challenge_UID [0] = challenge[0];
    challenge_UID [1] = challenge[1];
    challenge_UID [2] = challenge[2];
    challenge_UID [3] = challenge[3];
    challenge_UID [4] = UID[0];
    challenge_UID [5] = UID[1];
    challenge_UID [6] = UID[2];
    challenge_UID [7] = UID[3];    

    /* generate CMAC based on challenge|UID using KDEBUG */
    CSE.P1.R = CSE_RAM_KEY; /* RAM key */
    CSE.P2.R = (unsigned long long)&length; /* msg length */
    CSE.P3.R = (vuint32_t)&challenge_UID;	
    CSE.P4.R = (vuint32_t)&authorization;
    CSE.CMD.R= CSE_GENERATE_MAC; 

    while (CSE.SR.B.BSY ==1){} /*wait until CSE is idle*/

    if (CSE.ECR.R != CSE_NO_ERR) {failcount++;}
    
    /* issue authorization command */
    CSE.P1.R = (vuint32_t)&authorization ;
    CSE.CMD.R = CSE_DEBUG_AUTH;
    while (CSE.SR.B.BSY ==1){} /*wait until CSE is idle*/

    if ((CSE.ECR.R != CSE_NO_ERR) && (CSE.ECR.R != CSE_INT_DEBUG_NOT_ALLOWED )) {failcount++;}
    
    /* secure memory now erased */
    
    /* try to use one of the old keys for encryption */
        for (i=0; i<64; i++)
    {
	    encrypted_data[i] = 0xffffffff;
    }
    
    while (CSE.SR.B.BSY ==1){} /*wait until CSE is idle*/

    CSE.P1.R = CSE_KEY_1; /* KEY_1 has KEY_USAGE=0 (encryption) */
    CSE.P2.R = 16;
    CSE.P3.R = (vuint32_t)&data_for_encryption;	
    CSE.P4.R = (vuint32_t)&encrypted_data;
    CSE.CMD.R= CSE_ENC_ECB; 

    while (CSE.SR.B.BSY ==1){} /*wait until CSE is idle*/

    if (CSE.ECR.R != CSE_EMPTY_KEY) {failcount++;}
    
    /* confirm ecryption did not happen */
    for (i=0; i<64; i++)
    {
	    if (encrypted_data[i] != 0xffffffff)
		   {
		     failcount++;
		   }
    } 
    return(failcount);    
}
