/********************************************************************************************/
/* FILE NAME: main_z4_ram-erase_CSE_user_keys.c                                             */
/*                                                           COPYRIGHT (c) Freescale 2010   */
/*                                                                  All Rights Reserved     */
/* DESCRIPTION:                                                                             */
/* Erase any user keys from secure flash.                                                   */
/* SETUP:                                                                                   */
/* Software tested on MPC564xB EVB using GHS 5.1.7 + Lauterbach                             */
/*																		                                                      */
/********************************************************************************************/
#include "..\header\typedefs.h"
#include "..\header\project.h"
#include "..\header\cse.h"

//#undef RUN_DEBUG_CHAL_AUTH 
#define RUN_DEBUG_CHAL_AUTH

uint32_t failcount = 0;
int32_t result;

uint32_t data_for_encryption[64] =
{
0xB61C75C0,	0x9FEC0524,	0x66414070,	0x6C4E1BD1,
0xAEB7E985,	0xE9AB7CD3,	0xCD779188,	0xB2382049,
0x927CA102,	0x761F195D,	0x404B8C41,	0x86354D38,
0xAF5C1FC5,	0x78983111,	0xA21AC9E3,	0xB2DA46B6,
0x9FD49878,	0x5977A146,	0x3DCC25C2,	0x19337A67,
0x83B3FBBC,	0x2604FE82,	0x7AEEF3AA,	0x2D09E95E,
0xD120C731,	0x5F1102ED,	0x3DE352F9,	0x0E50AEDB,
0x662C5519,	0x0F7368E0,	0xDCA54BBA,	0x0EF728DF,
0xB5954C51,	0x42484B23,	0xA7E1BD36,	0x0CAF25B8,
0x69AD6B86,	0x6F306102,	0xDA7123E7,	0xC52856FC,
0x531770A0,	0x56E27593,	0x6878193B,	0xAB647307,
0xF08356CC,	0x22A8A84C,	0x60D6B28A,	0xCE8B8255,
0x4334C05F,	0x74F0815F,	0xF7DE7AFD,	0x30855913,
0x27A16CD5,	0x99078BA3,	0x3734D50A,	0x96FB5ADD,
0x97870258,	0x0BA0C5F3,	0xF9D69DC0,	0x0B7C2B31,
0x76DA8C55,	0xC23253E3,	0x4B0FE2D8,	0x8E3994B7
};
uint32_t encrypted_data[64];                            



/* prototypes */
void PLL_120MHZ_40Mhz_xtal();
void CGM_init(void);
void ENABLE_PLL_OUT_DIV4();



int main(void)
{
    CGM_init();
    ENABLE_PLL_OUT_DIV4();

    /* add a RAM wait state */
    ECSM.MUDCR.R |= 0x40000000; 
        
  /* confirm that Secure Boot has occurred */
  
                                              
#ifdef RUN_DEBUG_CHAL_AUTH
  result =  debug_chal_auth();   
#endif                                               
  
  while(1);
  
}

void PLL_120MHZ_40Mhz_xtal()
{
   CGM.AC0_SC.B.SELCTL = 0x1; /* selects PLL to be driven by FXOSC */

  /* these next 3 lines can be optimised in to a single write */
  ME.RUN[0].B.FXOSC0ON = 1;       /* Enable external osc */ 
  ME.RUN[0].B.FMPLLON  = 1;       /* Enable PLL */
  ME.RUN[0].B.SYSCLK   = 0x4;     /* System clock is PLL */
  
  /* these next 3 lines can be optimised in to a single write */
  CGM.FMPLL_CR.B.IDF  = 0x3;  /* Input Divider  = 4  -> 10 MHz   */
  CGM.FMPLL_CR.B.NDIV = 48;   /* Loop Divider   = 48 -> 480 MHz */
  CGM.FMPLL_CR.B.ODF  = 0x1;  /* Output Divider = 4  -> 120 MHz  */
  
  ME.MCTL.R = 0x40005AF0;         /* Mode & Key */
  ME.MCTL.R = 0x4000A50F;         /* Mode & Key inverted */
  while(ME.GS.B.S_MTRANS==1) {};  /* Wait for mode entry to complete */

  /* Configure CLKOUT on PA0 */
  /* next 4 lines aren't required except to ensure correct Fsys is being generated */
  SIU.PCR[0].R         = 0x0A04;  /* PA0 clkout               */
  CGM.OC_EN.R          = 1;       /* Enable Output Clock      */
  CGM.OCDS_SC.B.SELDIV = 2;       /* Divide Output Clock by 4 */
  CGM.OCDS_SC.B.SELCTL = 2;       /* PLL is Output Clock      */
}
void CGM_init(void)
{
   /* ME_PCTL[all periph] default points to ME_RUN_PC[0] */
   ME.RUNPC[0].R=0x000000FE; /* Peripheral ON in every mode */
   /* Divide by 16 Peripheral Set 2 (PS2) Clock for ADC, CTU & EMIOS */
   CGM.SC_DC[2].B.DIV = 0xF;

   PLL_120MHZ_40Mhz_xtal();
}

void ENABLE_PLL_OUT_DIV4()
{
  /* Configure CLKOUT on PA0 */
  /* next 4 lines aren't required except to ensure correct Fsys is being generated */  
  SIU.PCR[0].R        = 0x0A04;        /* PA0 clkout               */
  CGM.OC_EN.R          = 1;            /* Enable Output Clock      */
  CGM.OCDS_SC.B.SELDIV = 2;            /* Divide Output Clock by 4 */
  CGM.OCDS_SC.B.SELCTL = 2;            /* PLL is Output Clock      */
}
