#**************************************************************************/
#* FILE NAME: ctr0_VLE_RAM.s               COPYRIGHT (c) Freescale 201-   */
#*                                                All Rights Reserved     */
#* DESCRIPTION:                                                           */
#* This is a generic base template for init of a VLE RAM Project          */
#=========================================================================*/
#*                                                                        */
#*========================================================================*/
#* REV      AUTHOR        DATE        DESCRIPTION OF CHANGE               */
#* ---   -----------    ----------    ---------------------               */
#* 0.1    R. Moran       10/12/2008    Initial Version                    */
#**************************************************************************/

    .section    ".vletext", "vax"
    .vle
    .globl      _start
    .align 4
    
_start:

    e_lis       r1, __SP_INIT@h     # Initialize stack pointer r1 to
    e_or2i      r1, __SP_INIT@l     # value in linker command file. 

    e_lis       r13, _SDA_BASE_@h   # Initialize r13 to sdata base
    e_or2i      r13, _SDA_BASE_@l   # (provided by linker).    

    e_lis       r2, _SDA2_BASE_@h   # Initialize r2 to sdata2 base
    e_or2i      r2, _SDA2_BASE_@l   # (provided by linker).
    
    e_stwu      r0,-64(r1)          # Terminate stack.

#******************
# Enable SPE in MSR
#******************
  mfMSR r6
  e_or2is  r6, 0x0200
  mtMSR r6

#------------------------------------------------------------
# Start of MCU initialisation code
#   e_bl      init_MCU
# Start of optimisation code
#    e_bl      optimise_MCU
# Start of main code
    e_bl      main



    

        